//============================================================================================
/**
 * @file	tv_cm.c
 * @brief	fCM̌
 * @author	tamada GAME FREAK inc.
 * @date	2006.05.17
 */
//============================================================================================

#include "common.h"

#include "fieldsys.h"

#include "savedata/tv_work.h"
#include "savedata/zukanwork.h"
#include "savedata/mystatus.h"
#include "field/eventflag.h"

#include "field/tv_topic.h"

#include "system/pm_rtc.h"
#include "ev_time.h"
#include "sysflag.h"

#include "tv.h"

//============================================================================================
//============================================================================================
//--------------------------------------------------------------------
/**
 * @brief	CM`FbNp֐^`
 */
//--------------------------------------------------------------------
typedef BOOL (*CHECK_CM_FUNC)(FIELDSYS_WORK *);

static BOOL AnytimeEnable(FIELDSYS_WORK * fsys);
static BOOL AnytimeDisable(FIELDSYS_WORK * fsys);
static BOOL C01Check(FIELDSYS_WORK * fsys);
static BOOL T03Check(FIELDSYS_WORK * fsys);
static BOOL C03Check(FIELDSYS_WORK * fsys);
static BOOL C04Check(FIELDSYS_WORK * fsys);
static BOOL C05Check(FIELDSYS_WORK * fsys);
static BOOL C11Check(FIELDSYS_WORK * fsys);
static BOOL GTCOpenCheck(FIELDSYS_WORK * fsys);
static BOOL Get5BadgeCheck(FIELDSYS_WORK * fsys);
static BOOL SinouZukanCompleteCheck(FIELDSYS_WORK * fsys);
static BOOL GingaCMCheck(FIELDSYS_WORK * fsys);
static BOOL ZukanGetCheck(FIELDSYS_WORK * fsys);
static BOOL BattleTowerOpenCheck(FIELDSYS_WORK * fsys);
static BOOL WiFiBattleTowerOpenCheck(FIELDSYS_WORK * fsys);
static BOOL ShipEnableCheck(FIELDSYS_WORK * fsys);
static BOOL GameClearCheck(FIELDSYS_WORK * fsys);



//--------------------------------------------------------------------
/**
 * @brief	`FbNID
 *
 * AllConditionFuncTableƕтvĂKv
 */
//--------------------------------------------------------------------
enum {
	FLAG_AnytimeEnable,				///<ŏ
	FLAG_T03Check,					///<\mI
	FLAG_C01Check,					///<RguL
	FLAG_C03Check,					///<NKl
	FLAG_C04Check,					///<nN^C
	FLAG_C05Check,					///<XK
	FLAG_C11Check,					///<C11
	FLAG_Get5BadgeCheck,			///<WobWT
	FLAG_SinouZukanCompleteCheck,	///<VIE}ӃRv
	FLAG_ZukanGetCheck,				///<}ӎ擾
	FLAG_GameClearCheck,			///<a

	FLAG_CMCHECK_MAX,
};
//--------------------------------------------------------------------
/**
 * @brief	`FbN֐̃e[u
 */
//--------------------------------------------------------------------
static const CHECK_CM_FUNC AllConditionFuncTable[] = {
	AnytimeEnable,				///<ŏ
	T03Check,					///<\mI
	C01Check,					///<RguL
	C03Check,					///<NKl
	C04Check,					///<nN^C
	C05Check,					///<XK
	C11Check,					///<C11
	Get5BadgeCheck,				///<WobWT
	SinouZukanCompleteCheck,	///<VIE}ӃRv
	ZukanGetCheck,				///<}ӎ擾
	GameClearCheck,				///<a
};

//============================================================================================
//
//============================================================================================
//--------------------------------------------------------------------
/**
 * @brief	eCMƂ̕e[u
 */
//--------------------------------------------------------------------
static u8 CheckCMTable[] = {
	FLAG_AnytimeEnable,				///<|PZ^[	ŏ
	FLAG_AnytimeEnable,				///<thBVbv	ŏ
	FLAG_AnytimeEnable,				///<su	ŏ
	FLAG_AnytimeEnable,				///<g[i[XN[	ŏ
	FLAG_AnytimeEnable,				///<|Pb`	ŏ
	FLAG_C01Check,					///<|Pb`\tg	
	FLAG_T03Check,					///<ԉ	\mI
	FLAG_C04Check,					///<]ԉ	nN^C
	FLAG_C04Check,					///<ReXgbl	nN^C
	FLAG_C05Check,					///<Q[R[i[	XK
	FLAG_C05Check,					///<R	XK
	FLAG_C05Check,					///<gofp[g	XK
	FLAG_C05Check,					///<ĉ	XK
	FLAG_C05Check,					///<ze	XK
	FLAG_C05Check,					///<厼	XK
	FLAG_Get5BadgeCheck,				///<LbTLVeB	WobWT
	FLAG_Get5BadgeCheck,				///<iMTs	WobWT
	FLAG_C03Check,					///<fsb	NKl
	FLAG_SinouZukanCompleteCheck,	///<|Pp[N	VIE}ӃRv
	FLAG_GameClearCheck,			///<LbTLVeB̑D	VIE}ӃRv
	FLAG_GameClearCheck,			///<og][	VIE}ӃRv
	FLAG_SinouZukanCompleteCheck,	///<̌	VIE}ӃRv
	FLAG_C05Check,					///<MKcP	XK
	FLAG_C05Check,					///<MKcQ	XK
	FLAG_ZukanGetCheck,				///<|PZ^[ʐM	}ӎ擾
	FLAG_ZukanGetCheck,				///<|PZ^[Wi-Fi	}ӎ擾
	FLAG_C11Check,					///<og^[	C11
	FLAG_C11Check,					///< Wi-Fiog^[	C11
	FLAG_GameClearCheck,				///<蕨bliDj	a
};

//============================================================================================
//============================================================================================

//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL AnytimeEnable(FIELDSYS_WORK * fsys)
{
	return TRUE;
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL AnytimeDisable(FIELDSYS_WORK * fsys)
{
	return FALSE;
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL C01Check(FIELDSYS_WORK * fsys)
{
	EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
	return SysFlag_ArriveGet(ev, FLAG_ARRIVE_C01);
}

//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL T03Check(FIELDSYS_WORK * fsys)
{
	EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
	return SysFlag_ArriveGet(ev, FLAG_ARRIVE_T03);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL C03Check(FIELDSYS_WORK * fsys)
{
	EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
	return SysFlag_ArriveGet(ev, FLAG_ARRIVE_C03);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL C04Check(FIELDSYS_WORK * fsys)
{
	EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
	return SysFlag_ArriveGet(ev, FLAG_ARRIVE_C04);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL C05Check(FIELDSYS_WORK * fsys)
{
	EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
	return SysFlag_ArriveGet(ev, FLAG_ARRIVE_C05);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL C11Check(FIELDSYS_WORK * fsys)
{
	EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
	return SysFlag_ArriveGet(ev, FLAG_ARRIVE_C11);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL GTCOpenCheck(FIELDSYS_WORK * fsys)
{
	EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
	return SysFlag_GTCOpenCheck(ev);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL Get5BadgeCheck(FIELDSYS_WORK * fsys)
{
	MYSTATUS * my = SaveData_GetMyStatus(fsys->savedata);
	if (MyStatus_GetBadgeCount(my) >= 5) {
		return TRUE;
	} else {
		return FALSE;
	}
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL SinouZukanCompleteCheck(FIELDSYS_WORK * fsys)
{
	ZUKAN_WORK * zw = SaveData_GetZukanWork(fsys->savedata);
	return ZukanWork_CheckShinouComp(zw);
}

//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL GingaCMCheck(FIELDSYS_WORK * fsys)
{
	return FALSE;
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL ZukanGetCheck(FIELDSYS_WORK * fsys)
{
	ZUKAN_WORK * zw = SaveData_GetZukanWork(fsys->savedata);
	return ZukanWork_GetZukanGetFlag(zw);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL BattleTowerOpenCheck(FIELDSYS_WORK * fsys)
{
	EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
	return SysFlag_BTowerOpenCheck(ev);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL WiFiBattleTowerOpenCheck(FIELDSYS_WORK * fsys)
{
	EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
	return SysFlag_BTowerOpenCheck(ev);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL ShipEnableCheck(FIELDSYS_WORK * fsys)
{
	EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
	return SysFlag_ShipCheck(ev);
}
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static BOOL GameClearCheck(FIELDSYS_WORK * fsys)
{
	EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
	return SysFlag_GameClearCheck(ev);
}



//============================================================================================
//============================================================================================
//--------------------------------------------------------------------
/**
 * @brief	f\CM̒o
 */
//--------------------------------------------------------------------
static int ChooseEnableCMID(FIELDSYS_WORK * fsys, u8 * cm_array)
{
	int i,n;
	BOOL check_list[NELEMS(AllConditionFuncTable)];

	GF_ASSERT(NELEMS(AllConditionFuncTable) == FLAG_CMCHECK_MAX);
	//S`FbN
	for (i = 0; i < NELEMS(AllConditionFuncTable); i++) {
		check_list[i] = AllConditionFuncTable[i](fsys);
	}
	//CMƂɏĂ邩`FbN
	for (i = 0, n = 0; i < NELEMS(CheckCMTable); i++) {
		if (check_list[CheckCMTable[i]]) {
			cm_array[n] = i;
			n ++;
		}
	}
	return n;
}

//--------------------------------------------------------------------
/**
 * @brief	CM𒊏oA̒烉_ID擾
 */
//--------------------------------------------------------------------
int TVCM_ChooseID(FIELDSYS_WORK * fsys)
{
	u8 cm_id[32];
	int max;
	MI_CpuClear8(cm_id, 32);
	max = ChooseEnableCMID(fsys, cm_id);
	if (max == 0) {
		return 0;
	}
	return cm_id[gf_mtRand() % max];
}






