//============================================================================================
/**
 * @file	tv_topic.h
 * @brief	er̃gsbNo^pwb_
 * @date	2006.05.22
 * @author	tamada GAME FREAK inc.
 */
//============================================================================================

#ifndef	__TV_TOPIC_H__
#define	__TV_TOPIC_H__

#include "field_common.h"

#include "poketool/poke_tool.h"
#include "field/tvtopic_battle.h"
#include "system/pms_data.h"

//============================================================================================
//
//
//		ʃgsbNp
//
//
//============================================================================================
//02-01,02-02	gsbNFߊls
//--------------------------------------------------------------------
/**
 * @brief	ergsbNFߊl
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	tvwbw			ergsbNpێ[N
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_Watch_Capture(FIELDSYS_WORK * fsys,
		const TVWATCH_BATTLE_WORK * wcw_result, int win_lose_flag);

//02-03	gsbNFEނI
//--------------------------------------------------------------------
/**
 * @brief	gsbNFEނI
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	success_flag	ǂ
 * @param	itemno			gp肴̃ACeio[
 * @param	pp				ނグ|PPOKEMON_PARAMւ̃|C^
 *
 * ނグȂꍇAsuccess_flag == FALSEPP==NULLł悢
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_Watch_Fishing(FIELDSYS_WORK * fsys, BOOL success_flag,
		u16 itemno, POKEMON_PARAM * pp);

//02-04	gsbNFO[vւ
extern void TVTOPIC_Entry_Watch_ChangeGroup(FIELDSYS_WORK * fsys);

//02-06	gsbNFBACe
//--------------------------------------------------------------------
/**
 * @brief	gsbNFBACeI
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	item_no		ACẽio[
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_Watch_HideItem(FIELDSYS_WORK * fsys, u16 item_no);

//02-08	gsbNF^}SzI
//--------------------------------------------------------------------
/**
 * @brief	gsbNF^}SzI
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	z|Pւ̃|C^
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_Watch_HatchEgg(FIELDSYS_WORK * fsys, POKEMON_PARAM * pp);

//02-10	gsbNFf
//--------------------------------------------------------------------
/**
 * @brief	gsbNFf	jbNl[ύXƂ
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	pp		Oς|Pւ̃|C^
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_Watch_ChangeName(FIELDSYS_WORK * fsys, POKEMON_PARAM * pp);

//02-13	gsbNFnΌ@
//--------------------------------------------------------------------
/**
 * @brief	gsbNFΌ@	Ό@
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	fossil_type		΂̃ACeio[
 * @param	fossil_num		ꂽ΂̐
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_Watch_DigFossil(FIELDSYS_WORK * fsys, int fossil_type, int fossil_num);

//02-15	gsbNFTt@Q[
//--------------------------------------------------------------------
/**
 * @brief	gsbNFTt@Q[	Tt@Q[IƂ
 * @param	fsys	tB[h䃏[Nւ̃|C^
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_Watch_Safari(FIELDSYS_WORK * fsys);

//02-17	gsbNFǖ͌ɋꂵI	|PɊƂ
//tvtopic_extern.hɂ܂

//02-18,02-19,03-06	gsbNF̂݊֘A
//--------------------------------------------------------------------
/**
 * @brief	gsbNF݂̂ƂƂ
 * @param	fsys			tB[h䃏[Nւ̃|C^
 * @param	nuts_item_no	Ƃ݂̂̃ACeio[
 * @param	hp				ƂƂHP̒l
 * @param	nuts_count		Ƃ݂̂̐
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_TakeNuts(FIELDSYS_WORK  *fsys, u16 nuts_item_no, u8 hp, u16 nuts_count);

//02-20	gsbNFO[v
extern void TVTOPIC_Entry_Watch_MakeGroup(FIELDSYS_WORK * fsys);

//02-21	gsbNFJX^{[Zbg
//field/tvtopic_extern.hɂ܂

//02-22	gsbNFAI
//--------------------------------------------------------------------
/**
 * @brief	gsbNFI		l̊AI
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	rival		MYSTATUSւ̃|C^
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_Watch_GetFlag(FIELDSYS_WORK * fsys, const MYSTATUS * rival);

//02-23	gsbNFAꂽI
//--------------------------------------------------------------------
/**
 * @brief	gsbNFꂽI		̊AꂽI
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	rival		MYSTATUSւ̃|C^
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_Watch_LoseFlag(FIELDSYS_WORK * fsys, const MYSTATUS * rival);


//--------------------------------------------------------------------
/**
 * @brief	gsbNFog^[A
 * @param	fsys			tB[h䃏[Nւ̃|C^
 * @param	renshou			A
 * @param	pp				擪̃|Pւ̃|C^
 * @param	IsSingleFlag	VO킩ǂ
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_Record_BTower(FIELDSYS_WORK * fsys,
		u32 renshou, POKEMON_PARAM * pp, BOOL IsSingleFlag);

//--------------------------------------------------------------------
/**
 * @brief	gsbNF傫L^XV	傫ŋL^XVƂ
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	size		L^
 * @param	pp			XV|Pւ̃|C^
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_Record_Ookisa(FIELDSYS_WORK * fsys, u32 size, POKEMON_PARAM * pp);

//--------------------------------------------------------------------
/**
 * @brief	gsbNFXbgBl	Xbgň薇ȏ҂Ƃ
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	start_coin		JñRC
 * @param	end_coin		ĨRC
 * @param	playtime		vCԁiPʁj
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_Record_Slot(FIELDSYS_WORK * fsys, u32 start_coin, u32 end_coin, u32 playtime);

//--------------------------------------------------------------------
/**
 * @brief	gsbNFil	nɓƂÃi쐬
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	trap_no			ŏɉĩio[
 * @param	remove_count	i
 *
 * nɓĂo܂ł̊Ԃ̉񐔂łBxo烊Zbg܂B
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_Record_RemoveTrap(FIELDSYS_WORK * fsys, u16 trap_no, u16 remove_count);

//--------------------------------------------------------------------
/**
 * @brief	gsbNFn^gl
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	flag_count		
 *
 * nɓĂo܂ł̊Ԃ̉񐔂łBxo烊Zbg܂B
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_Record_GetFlag(FIELDSYS_WORK * fsys, u16 flag_count);

//============================================================================================
//============================================================================================
//--------------------------------------------------------------------
/**
 * @brief	gsbNFog^[C^r[
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	word		ȈՉbPID
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_QandA_BTower(FIELDSYS_WORK * fsys, PMS_WORD word);

//--------------------------------------------------------------------
/**
 * @brief	gsbNFȂ̃|PC^r[
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	word		ȈՉbPID
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_QandA_Pokemon(FIELDSYS_WORK * fsys, PMS_WORD word);

//--------------------------------------------------------------------
/**
 * @brief	gsbNFCɓ̃|Pb`
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	word		ȈՉbPID
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_QandA_Poketch(FIELDSYS_WORK * fsys, PMS_WORD word);

//--------------------------------------------------------------------
/**
 * @brief	gsbNFIReXg
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	word		ȈՉbPID
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_QandA_Contest(FIELDSYS_WORK * fsys, PMS_WORD word);

//--------------------------------------------------------------------
/**
 * @brief	gsbNF|PNbvI
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	word		ȈՉbPID
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_QandA_Clip(FIELDSYS_WORK * fsys, PMS_WORD word);

//--------------------------------------------------------------------
/**
 * @brief	gsbNFiffI
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	word		ȈՉbPID
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_QandA_Character(FIELDSYS_WORK * fsys, PMS_WORD word);

//--------------------------------------------------------------------
/**
 * @brief	gsbNF|g
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	word		ȈՉbPID
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_QandA_Poruto(FIELDSYS_WORK * fsys, PMS_WORD word);

//--------------------------------------------------------------------
/**
 * @brief	gsbNF|PA
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	word		ȈՉbPID
 */
//--------------------------------------------------------------------
extern void TVTOPIC_Entry_QandA_Park(FIELDSYS_WORK * fsys, PMS_WORD word);

#endif	//__TV_TOPIC_H__
