//=============================================================================
/**
 * @file	comm_secretbase_info.h
 * @brief	n̔閧nǗNX
 * @author	Katsumi Ohno
 * @date    2005.10.04
 */
//=============================================================================

#ifndef __UG_SECRETBASE_H__
#define __UG_SECRETBASE_H__

#include "savedata/undergrounddata.h"

/// 閧n񏉊
extern void CommSecretBaseInfoInitialize(void* pWork, FIELDSYS_WORK* pFSys);
extern void CommSecretBaseInfoReset(void);
extern void CommSecretBaseInfoReboot(void);
/// 閧n񏈗I
extern void CommSecretBaseInfoFinalize(void);
extern void CommSecretBaseInfoReInit(void);
extern void CommSecretBaseInfoParentDel(void);
/// [NŜ̃TCYԂ
extern int CommSecretBaseInfoGetWorkSize(void);
/// Z[uf[^玩̂쐬
extern void UgSecretBaseMakeMyAttr(FIELDSYS_WORK* pFSys);
/// q@̃vO  e@ɔ閧n𑗂
extern void CommSecretBaseInfoChildSendStart(void);
/// 閧nf[^M
extern void CommSecretBaseInfoRecvData(int netID, int size, void* pData, void* pWork);
/// 閧nf[^TCY
extern int CommSecretBaseInfoGetDataSize(void);
/// e@閧nf[^͂ǂ
extern BOOL CommSecretBaseInfoIsChildRecv(void);
/// e@閧nf[^͂̂ŁAtO
extern void CommSecretBaseResetChildRecv(void);

extern BOOL CommSecretBaseInfoIsPosRecv(void);

extern void CommSecretBaseResetPosRecv(void);

extern BOOL CommSecretBaseIsTraveling(int netID);

/// 閧nړIƂ𑗐M
extern void CommSecretBaseInfoJumpEnd(void);
/// 閧nړIƂM
extern void CommSecretBaseInfoRecvJumpEnd(int netID, int size, void* pData, void* pWork);

extern void UgSecretBaseRecvJumpEvent(int netID, int size, void* pData, void* pWork);

extern void UgSecretBaseRecvMoveFailed(int netID, int size, void* pData, void* pWork);

extern int UgSecretBaseRecvJumpEventSize(void);

extern void UgSecretBaseRecvJumpEventRes(int netID, int size, void* pData, void* pWork);

extern int UgSecretBaseRecvJumpEventResSize(void);

extern void CommSecretBaseInfoParentSendStart(int netID);

extern void CommSecretBaseInfoRecvData(int netID, int size, void* pData, void* pWork);
extern void CommSecretBaseInfoRecvDataServer(int netID, int size, void* pData, void* pWork);
extern void CommSecretBaseInfoRecvPos(int netID, int size, void* pData, void* pWork);
extern int CommSecretBaseInfoGetDataSize(void);
extern int CommSecretBaseInfoGetPosSize(void);

extern void CommSecretBaseInfoStepFunc(void);
extern BOOL CommSecretBaseSingleStepFunc(int playerId, int moveX, int moveZ);

extern BOOL CommSecretBaseInfoGetActionMessage(STRBUF* pStrBuf);

extern void CommSecretBaseInfoRecvRetJump(int netID, int size, void* pData, void* pWork);
extern int CommSecretBaseInfoGetRetJumpSize(void);

extern void CommSecretBaseDrillStart(void);
extern void CommSecretBaseRecvDrillStart(int netID, int size, void* pData, void* pWork);
extern void CommSecretBaseRecvDrillStartResult(int netID, int size, void* pData, void* pWork);
extern int CommSecretBaseDrillStartResultSize(void);

/// ʐMEl̔閧n
extern void UgSecretBaseResetPlayer(int netID);
extern void UgSecretBaseDestroyPlayer(int netID);
extern void UgSecretBaseDestroyDoor(int netID);
extern void UgSecretBaseDestroyPlayerDontBaseIn(int netID);
/// 閧n̓eԂ
extern SECRETBASEDATA* UgSetupSecretBaseData(SAVEDATA * sv);
///ZbgAbv閧ñubNԂ
extern int UgSetupSecretBaseBlockX(void);
extern int UgSetupSecretBaseBlockZ(void);
/// 閧nObYf[^݂ĕ邩ǂׂ
extern BOOL UgSecretBaseMoveing(int x, int z);
/// 悤̉bX^[g
extern int UgSecretBaseTalkStart(int messageNo);
/// 悤̉bI
extern void UgSecretBaseTalkEnd(void);
/// ObY̖ObZ[Wɕ\ꍇ̊֐
extern void UgSecretBaseTalkRegisterGoodsName(int type);
/// QbZ[Wɕ\ꍇ̊֐
extern void UgSecretBaseTalkRegisterNum2(int number,int index);
/// A{^ŃObỸ`FbN
extern BOOL UgSecretBaseGoodsCheck(int netID, Grid* pTouch);
/// A{^ŃObỸ`FbN
extern void UgSecretBaseRecvGoodsCheck(int netID, int size, void* pData, void* pWork);
extern int UgSecretBaseGetRecvGoodsCheckSize(void);

extern void UgSecretBaseSetFlagGetLog(int netID, int targetPCNetID);
extern void UgSecretBaseSetFlagReverseLog(int myNetID);
extern void UgSecretBaseSetFlagConquerLog(int myNetID, int targetID);


extern int UgSBGetLVUPFlagRetSize(void);
extern void UgSBRecvLVUPFlagRet(int netID, int size, void* pData, void* pWork);
extern void UgSBRecvLVUPFlag(int netID, int size, void* pData, void* pWork);

// 
extern BOOL UgSecretBaseTrapGoodsCheck(int netID);
// Zbg
extern BOOL UgSecretBaseTrapGoodsReset(int netID);

extern void UgSecretBaseRemovePlayer(int netID);
//
extern BOOL UgSecretBaseRemovePlayer_Client(int playerID, BOOL bRemove);

extern BOOL UgSecretBaseIsOtherEnter(void);

extern void UgSecretBaseErrorMoveTickets(void);
extern void UgSecretBaseErrorDisconnectTickets(void);
// q@閧nɂꍇAOɂłĂ炤
extern void UgSecretBaseFirstConnectChild(int netID);




extern int UgSecretBaseEscapePosX(void);
extern int UgSecretBaseEscapePosZ(void);
extern int UgSecretBaseEscapeDir(void);
extern void UgSecretBaseEscapePosSXSet(int netID,int x);
extern void UgSecretBaseEscapePosSZSet(int netID,int z);
extern void UgSecretBaseEscapeDirSet(int netID,int dir);

extern void UgSecretBaseBootOn(BOOL bOn);


#endif //__UG_SECRETBASE_H__
