//============================================================================================
/**
 * @file	vm.c
 * @brief	zC^[v^}V@C(XNvgR}hsɎgp)
 * @author	Sousuke Tamada
 * @date	01.11.07
 *
 * 03.04.15	Satoshi Nohara
 * 05.04.25 Hiroyuki Nakamura
 *
 * Gh̃t@Cx[X ( R/S -> FR/LG -> EME -> D/P )
 */
//============================================================================================
#include "common.h"

#define __VM_H_GLOBAL
#include "vm.h"


//============================================================================================
//	`
//============================================================================================
// z}V̓Ԓ`
enum{
	VMSTAT_READY,		// ~(Ij
	VMSTAT_RUN,			// 쒆
	VMSTAT_WAIT,		// ҂ԁi`FbN[`Ăяoj
};


//============================================================================================
//	O[oϐ
//============================================================================================
//const u32 ScriptBreakPoint = 0;


//============================================================================================
//
//
// z}Vp֐
//
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * z}V
 *
 * @param	core		z}V\̂ւ̃|C^
 * @param	cmd_tbl		߃e[uJnAhX
 * @param	cmd_max		߃e[ȗ傫
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void VM_Init( VM_MACHINE * core, const VM_CMD * cmd_tbl, u32 cmd_max)
{
	u32	i;

	core->status = VMSTAT_READY;
	core->PC = NULL;
	core->SP = 0;
	core->routine = NULL;
	core->command_table = cmd_tbl;
	core->cmd_max = cmd_max;
	for( i=0; i<VM_REG_MAX; i++ ){
		core->reg[i] = 0;
	}
	for( i=0; i<VM_STACK_MAX; i++ ){
		core->array[i] = NULL;
	}

#ifdef OLD_MSG_SYS
	core->pMsg = NULL;
#endif

#if 0
	//script.c EV_SCRIPT_WORKֈړ
	for( i=0; i<VM_WORK_MAX; i++ ){
		core->scr_work[i] = 0;
	}
#endif

	core->event_work = NULL;		//(06.07.20)
}


//--------------------------------------------------------------------------------------------
/**
 * z}VɃR[hݒ
 *
 * @param	core		z}V\̂ւ̃|C^
 * @param	start		sR[h̊JnAhX
 *
 * @return	TRUE
 */
//--------------------------------------------------------------------------------------------
u8 VM_Start( VM_MACHINE * core, const VM_CODE * start )
{
	core->PC = start;
	core->status = VMSTAT_RUN;

	return TRUE;
}

//--------------------------------------------------------------------------------------------
/**
 * z}VEFCgԂɐݒ
 *
 * @param	core		z}V\̂ւ̃|C^
 * @param	func		EFCg֐
 *
 * @return	none
 *
 * @li	TRUEԂĂ܂ŃEFCg֐𖈉Ăт
 */
//--------------------------------------------------------------------------------------------
void VM_SetWait( VM_MACHINE * core, VM_WAIT_FUNC func )
{
	core->status = VMSTAT_WAIT;
	core->routine = func;
}

//--------------------------------------------------------------------------------------------
/**
 * z}VsI
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void VM_End( VM_MACHINE * core )
{
	core->status = VMSTAT_READY;
	core->PC = NULL;
}

//--------------------------------------------------------------------------------------------
/**
 * R}hȂǂŎQƂ郏[NZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 * @param	work		[Ñ|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void VM_SetWork( VM_MACHINE * core, void * work )
{
	core->event_work = work;
}

//--------------------------------------------------------------------------------------------
/**
 * z}V䃁C
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @retval	"TRUE = s"
 * @retval	"FALSE = ~EsI"
 */
//--------------------------------------------------------------------------------------------
u8 VM_Control( VM_MACHINE * core )
{
	u16 code;

	if( core->status == VMSTAT_READY ){ return FALSE; }

	switch( core->status ){
	case VMSTAT_READY:
		return FALSE;

	case VMSTAT_WAIT:
		if( core->routine != NULL ){
			if( core->routine(core) == TRUE ){
				core->status = VMSTAT_RUN;
			}
			return TRUE;
		}
		core->status = VMSTAT_RUN;
		/* FALL THROUGH */

	case VMSTAT_RUN:
		while( TRUE ){
			if( core->PC == NULL ){
				core->status = VMSTAT_READY;
				return FALSE;
			}
/*	fobO
			if( core->PC == (VM_CODE *)ScriptBreakPoint ){
				while( TRUE ){
					Halt();
				}
			}
*/

			code = VMGetU16( core );

			if( code >= core->cmd_max ) {
				GF_ASSERT_MSG(0, "command error %04x:%08x\n",code, core->PC - 2);
				core->status = VMSTAT_READY;
				return FALSE;
			}
			if( core->command_table[code]( core ) == 1 ){
				break;
			}
		}
	}
	return TRUE;
}


//============================================================================================
// z}VpTu[`
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * z}VX^bNvbV
 *
 * @param	core		z}V\̂ւ̃|C^
 * @param	val
 *
 * @retval	"0 = "
 * @retval	"1 = G["
 */
//--------------------------------------------------------------------------------------------
u8 VMStackPush( VM_MACHINE * core, const VM_CODE * val )
{
	if( core->SP + 1 >= VM_STACK_MAX ){ return 1; }
	core->array[core->SP] = val;
	core->SP ++;

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * z}VX^bN|bv
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return
 */
//--------------------------------------------------------------------------------------------
const VM_CODE * VMStackPop( VM_MACHINE * core )
{
	if( core->SP == 0 ){ return NULL; }
	core->SP --;

	return core->array[core->SP];
}

//--------------------------------------------------------------------------------------------
/**
 * z}VWv
 *
 * @param	core		z}V\̂ւ̃|C^
 * @param	adrs		WvAhX
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void VMJump( VM_MACHINE * core, VM_CODE * adrs )
{
	core->PC = adrs;
}

//--------------------------------------------------------------------------------------------
/**
 * z}VR[
 *
 * @param	core		z}V\̂ւ̃|C^
 * @param	adrs		ĂяoAhX
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void VMCall( VM_MACHINE * core, VM_CODE * adrs )
{
	VMStackPush( core, core->PC );
	core->PC = adrs;
}

//--------------------------------------------------------------------------------------------
/**
 * z}V^[
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void VMRet( VM_MACHINE * core )
{
	core->PC = VMStackPop( core );
}


//--------------------------------------------------------------------------------------------
/**
 * PC̃AhX16bit(2byte)f[^擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	擾f[^
 */
//--------------------------------------------------------------------------------------------
u16 VMGetU16( VM_MACHINE * core )
{
	u16	val;

	val = (u16)VMGetU8( core );
	val += (u16)VMGetU8( core ) << 8;

	return val;
}

//--------------------------------------------------------------------------------------------
/**
 * PC̃AhX32bit(4byte)f[^擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	擾f[^
 */
//--------------------------------------------------------------------------------------------
u32 VMGetU32( VM_MACHINE * core )
{
	u32	val;
	u8	a,b,c,d;

	a = VMGetU8( core );
	b = VMGetU8( core );
	c = VMGetU8( core );
	d = VMGetU8( core );

	val = 0;
	val += (u32)d;
	val <<= 8;
	val += (u32)c;
	val <<= 8;
	val += (u32)b;
	val <<= 8;
	val += (u32)a;

	return val;
}

