//============================================================================================
/**
 * @file	zonedata.c
 * @brief	][ŗL̊Ǘf[^
 * @author	tamada
 * @date	2005.08.05
 */
//============================================================================================

#include "common.h"

#include "fieldsys.h"

#include "zonedata.h"

#include "mapdefine.h"
#include "maptype.h"


#include "../fielddata/script/scr_seq.naix"

#include "../msgdata/msg.naix"

#include "../data/sound/sound_data.sadl"

#include "../fielddata/eventdata/zone_event.naix"

#include "../fielddata/encountdata/enc_data.naix"

#include "msgdata/msg_place_name.h"

#include "weather_sys.h"
#include "mapdata_weather_def.h"

#include "battle/attr_def.h"

#include "../fielddata/mm_list/mmlist_def.h"

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	][Ɏf[^̍\
 */
//------------------------------------------------------------------
typedef struct{
	u8 area_id;							///<AREA_ID̎w
	u8 movemodel_id;					///<샂f̎w
	u16 matrix_id;						///<}bv}gbNX̎w
	u16 script_id;						///<XNvgt@C̃A[JCuID
	u16 sp_script_id;					///<XNvgt@C̃A[JCuID
	u16 msg_id;							///<bZ[Wt@C̃A[JCuID
	u16 bgm_day_id;						///<BGMwijID
	u16 bgm_night_id;					///<BGMwijID
	u16 enc_data_id;					///<GJEgw
	u16 event_data_id;					///<Cxgf[^t@C̃A[JCuID
	u16 placename_id;					///<nbZ[Ŵhc
	u8 weather_id;						///<VwID
	u8 camera_id;						///<JwID
	u8 maptype;							///<}bv^Cv̎w(MAPTYPE`QƁj
	u8 battle_bg_type:4;				///<퓬wi̎w
	u8 bicycle_flag:1;					///<]Ԃɏ邩ǂ
	u8 dash_flag:1;						///<_bVł邩ǂ
	u8 escape_flag:1;					///<Ȃʂł邩ǂ
	u8 fly_flag:1;
}ZONE_DATA;
//------------------------------------------------------------------
//------------------------------------------------------------------

enum {
	sp_scr_dummy = NARC_scr_seq_sp_dummy_bin,
	scr_dummy = NARC_scr_seq_dummy_bin,
	//sp_scr_dummy = NARC_scr_seq_sp_c01_bin,
	//scr_dummy = NARC_scr_seq_c01_bin,
	msg_dummy = NARC_msg_c01_dat,
	enc_dummy = 0xffff,
};

#include "../fielddata/maptable/maptable.dat"

static int ZoneData_GetMapType(int zone_id);
//===========================================================================
//===========================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------
int ZoneData_CheckRange(int zone_id)
{
	if (zone_id >= NELEMS(ZoneData)) {
		GF_ASSERT_MSG(0, "%d/%d:zone_id error\n",zone_id,NELEMS(ZoneData)-1);
		return ZONE_ID_C01;
	}
	return zone_id;
}

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	GAID̎擾
 * @param	zone_id		][w
 * @return	u16			GAw
 */
//------------------------------------------------------------------
const u16 ZoneData_GetAreaID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].area_id;
}

//------------------------------------------------------------------
//------------------------------------------------------------------
const u16 ZoneData_GetMoveModelID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].movemodel_id;
}

//------------------------------------------------------------------
/**
 * @brief	}bv}gbNXID̎擾
 * @param	zone_id		][w
 * @return	u16			}bv}gbNXw
 */
//------------------------------------------------------------------
const u16 ZoneData_GetMatrixID(int zone_id)
{
	u16 mtx_id;
	zone_id = ZoneData_CheckRange(zone_id);
	mtx_id = ZoneData[zone_id].matrix_id;
	if (mtx_id == MATRIX_ID_DUN0514){
		if (CasetteVersion == VERSION_PEARL) {
			mtx_id = MATRIX_ID_DUN0515;
		}
	}
	return mtx_id;
}
//------------------------------------------------------------------
/**
 * @brief	bZ[WA[JCuID̎擾
 * @param	zone_id		][w
 * @return	u32			bZ[WA[JCuID
 */
//------------------------------------------------------------------
u32 ZoneData_GetMsgArchiveID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].msg_id;
}

//------------------------------------------------------------------
/**
 * @brief	XNvgA[JCuID̎擾
 * @param	zone_id		][w
 * @return	u32			XNvgA[JCuID
 */
//------------------------------------------------------------------
u32 ZoneData_GetScriptArchiveID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].script_id;
}
//------------------------------------------------------------------
/**
 * @brief	XNvgA[JCuID̎擾
 * @param	zone_id		][w
 * @return	u32			XNvgA[JCuID
 */
//------------------------------------------------------------------
u32 ZoneData_GetSpScriptArchiveID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].sp_script_id;
}


//------------------------------------------------------------------
/**
 * @brief	BGMw̎擾
 * @param	zone_id		][w
 * @return	u16			BGMw
 */
//------------------------------------------------------------------
u16 ZoneData_GetDayBGMID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].bgm_day_id;
}

//------------------------------------------------------------------
/**
 * @brief	BGMw̎擾
 * @param	zone_id		][w
 * @return	u16			BGMw
 */
//------------------------------------------------------------------
u16 ZoneData_GetNightBGMID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].bgm_night_id;
}

//------------------------------------------------------------------
/**
 * @brief	GJEgtO̎擾
 * @param	zone_id		][w
 * @return	TRUEFGJEgf[^AFALSE:GJEgf[^Ȃ
 */
//------------------------------------------------------------------
BOOL ZoneData_GetEncountFlag (int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return (ZoneData[zone_id].enc_data_id != enc_dummy);
}

//------------------------------------------------------------------
/**
 * @brief	GJEgA[JCuID̎擾
 * @param	zone_id		][w
 * @return	u32	A[JCuIDw
 */
//------------------------------------------------------------------
u32 ZoneData_GetEncountArchiveID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].enc_data_id;
}

//------------------------------------------------------------------
/**
 * @brief	Cxgf[^A[JCuID̎擾
 * @param	zone_id		][w
 * @return	u32			Cxgf[^A[JCuID
 */
//------------------------------------------------------------------
u32 ZoneData_GetEventID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].event_data_id;
}

//------------------------------------------------------------------
/**
 * @brief	nbZ[WwID̎擾
 * @param	zone_id		][w
 * @return	u32			nbZ[Wwhc
 */
//------------------------------------------------------------------
u32 ZoneData_GetPlaceNameID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].placename_id;
}

//------------------------------------------------------------------
/**
 * @brief	VwID̎擾
 * @param	zone_id		][w
 * @return	u32			VwID
 */
//------------------------------------------------------------------
u32 ZoneData_GetWeatherID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].weather_id;
}

//------------------------------------------------------------------
/**
 * @brief	JwID̎擾
 * @param	zone_id		][w
 * @return	u32			JwID
 */
//------------------------------------------------------------------
u32 ZoneData_GetCameraID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].camera_id;
}

//------------------------------------------------------------------
/**
 * @brief	JwID̎擾
 * @param	zone_id		][w
 * @return	u32			퓬wiwID
 */
//------------------------------------------------------------------
u32 ZoneData_GetBattleBGID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].battle_bg_type;
}
//------------------------------------------------------------------
/**
 * @brief	Ȃʂł邩ǂ̃tO擾
 * @param	zone_id		][w
 * @return	BOOL		ł邩ǂ
 */
//------------------------------------------------------------------
BOOL ZoneData_GetEnableEscapeFlag(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].escape_flag;
}
//------------------------------------------------------------------
/**
 * @brief	ƂԁEe|[gł邩ǂ̃tO擾
 * @param	zone_id		][w
 * @return	BOOL		ł邩ǂ
 */
//------------------------------------------------------------------
BOOL ZoneData_GetEnableFlyFlag(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].fly_flag;
}

//------------------------------------------------------------------
/**
 * @brief	_bVł邩ǂ̃tO擾
 * @param	zone_id		][w
 * @return	BOOL		ł邩ǂ
 */
//------------------------------------------------------------------
BOOL ZoneData_GetEnableDashFlag(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].dash_flag;
}
//------------------------------------------------------------------
/**
 * @brief	Ă񂵂邩ǂ̃tO擾
 * @param	zone_id		][w
 * @return	BOOL		ł邩ǂ
 */
//------------------------------------------------------------------
BOOL ZoneData_GetEnableBicycleFlag(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].bicycle_flag;
}
//------------------------------------------------------------------
/**
 * @brief	}bv^Cv̎擾
 * @param	zone_id		][w
 * @return	int			}bv^CvwID
 *
 * }bv^Cvgp͕UƌX̃^CvǉȂǂ
 * ςɂȂ̂ł̊֐͊OJĂȂ
 */
//------------------------------------------------------------------
static int ZoneData_GetMapType(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].maptype;
}
//============================================================================================
//
//
//	][IDɂe픻胍WbN
//
//
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	e|[gg邩ǂ̃`FbN
 * @param	zone_id		][w
 * @retval	BOOL	TRUÊƂAe|[gg
 */
//------------------------------------------------------------------
BOOL ZoneData_GetEnableTeleportFlag(int zone_id)
{
	if (ZoneData_GetEnableFlyFlag(zone_id) == FALSE) {
		return FALSE;
	}
	return (ZoneData_GetMapType(zone_id) != MAPTYPE_TOWN);
}

//------------------------------------------------------------------
/**
 * @brief	tB[hǂ̃`FbN
 * @param	zone_id		][w
 * @retval	BOOL	TRUÊƂAtB[hił_WłȂj
 */
//------------------------------------------------------------------
BOOL ZoneData_IsSinouField(int zone_id)
{
	return (ZoneData_GetMatrixID(zone_id) == MATRIX_ID_FIELD);
}

//------------------------------------------------------------------
/**
 * @brief	|PZǂ̃`FbN
 * @param	zone_id		][w
 * @retval	BOOL	TRUÊƂA|PZ
 */
//------------------------------------------------------------------
BOOL ZoneData_IsPokecen(int zone_id)
{
	return (ZoneData_GetMapType(zone_id) == MAPTYPE_POKECEN);
}

//------------------------------------------------------------------
/**
 * @brief	_Wǂ̃`FbN
 * @param	zone_id		][w
 * @retval	BOOL	TRUÊƂA_W
 */
//------------------------------------------------------------------
BOOL ZoneData_IsDungeon(int zone_id)
{
	return (ZoneData_GetMapType(zone_id) == MAPTYPE_CAVE);
}

//------------------------------------------------------------------
/**
 * @brief	ǂ̃`FbN
 * @param	zone_id		][w
 * @retval	BOOL	TRUÊƂA
 */
//------------------------------------------------------------------
BOOL ZoneData_IsRoom(int zone_id)
{
	return ( (ZoneData_GetMapType(zone_id) == MAPTYPE_ROOM) ||
			 (ZoneData_GetMapType(zone_id) == MAPTYPE_POKECEN) );
}

//------------------------------------------------------------------
/**
 * @brief	Oǂ̃`FbN
 * @param	zone_id		][w
 * @retval	BOOL	TRUÊƂAO
 */
//------------------------------------------------------------------
BOOL ZoneData_IsOutDoor(int zone_id)
{
	return ( (ZoneData_GetMapType(zone_id) == MAPTYPE_TOWN) ||
			 (ZoneData_GetMapType(zone_id) == MAPTYPE_ROAD) );
}

//------------------------------------------------------------------
/**
 * @brief	ʐM𗘗p\̂][ǂ`FbN
 *
 * @param   zone_id		][w
 *
 * @retval  BOOL		TRUÊƂAʐM𗘗p邩
 */
//------------------------------------------------------------------
BOOL ZoneData_IsCommPlayableZone(int zone_id)
{
	if( ZoneData_IsPokecen(zone_id) )
	{
		return TRUE;
	}


	return FALSE;
}

//------------------------------------------------------------------
/**
 * @brief	jI[ǂ̃`FbN
 * @param   zone_id		][w
 * @return	BOOL	TRUÊƂAjI[
 */
//------------------------------------------------------------------
BOOL ZoneData_IsUnionRoom(const int zone_id)
{
	return (zone_id == ZONE_ID_UNION);
}

//------------------------------------------------------------------
/**
 * @brief	ނGJEg][ǂ`FbN
 *
 * @param   zone_id		][w
 *
 * @retval  BOOL		TRUÊƂAނGJEg][
 */
//------------------------------------------------------------------
BOOL ZoneData_IsSpFishingZone(const int zone_id)
{
	return (zone_id == ZONE_ID_D05R0113);
}

//------------------------------------------------------------------
/**
 * @brief	RGJEg][ǂ`FbN
 *
 * @param   zone_id		][w
 *
 * @retval  BOOL		TRUÊƂARGJEg][
 */
//------------------------------------------------------------------
BOOL ZoneData_IsHillBackZone(const int zone_id)
{
	return (zone_id == ZONE_ID_D23R0101);
}

//------------------------------------------------------------------
/**
 * @brief	Rǂ̃`FbN
 * @param   zone_id		][w
 * @retval	BOOL		TRUÊƂAR
 */
//------------------------------------------------------------------
BOOL ZoneData_IsNaturalPark(const int zone_id)
{
	return (zone_id == ZONE_ID_D11R0101);
}

//------------------------------------------------------------------
/**
 * @brief	Ă񂩂̂ӂg][ǂ`FbN
 *
 * @param   zone_id		][w
 *
 * @retval  BOOL		TRUÊƂAg][
 */
//------------------------------------------------------------------
BOOL ZoneData_IsUseTenkainofueZone(const int zone_id)
{
	return (zone_id == ZONE_ID_D05R0114);
}

//------------------------------------------------------------------
/**
 * @brief	|PZQFɂ邩ǂ̃`FbN
 * @param   zone_id		][w
 */
//------------------------------------------------------------------
BOOL ZoneData_IsPokecen2F(const int zone_id)
{
	static const u16 pc2f[] = {
		ZONE_ID_T02PC0102,
		ZONE_ID_T03PC0102,
		ZONE_ID_T04PC0102,
		ZONE_ID_T05PC0102,
		ZONE_ID_T06PC0102,
		ZONE_ID_T07PC0102,
		ZONE_ID_C01PC0102,
		ZONE_ID_C02PC0102,
		ZONE_ID_C03PC0102,
// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if	AFTERMASTER_061004_FIX
		ZONE_ID_C10R0114,
#else
		ZONE_ID_C03PC0102,
#endif
// ----------------------------------------------------------------------------
		ZONE_ID_C04PC0102,
		ZONE_ID_C05PC0102,
		ZONE_ID_C06PC0102,
		ZONE_ID_C07PC0102,
		ZONE_ID_C08PC0102,
		ZONE_ID_C09PC0102,
		ZONE_ID_C10PC0102,
		ZONE_ID_C11PC0102,
	};

	int index;
	for (index = 0; index < NELEMS(pc2f); index++ ) {
		if (zone_id == pc2f[index]) {
			return TRUE;
		}
	}
	return FALSE;

}

//============================================================================================
//
//
//
//	}bvƂ̌ʃf[^擾
//
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	ꏊȉԂ
 * @param	zone_id		][wID
 * @retval	SHINKA_NONE
 * @retval	SHINKA_PLACE_TENGANZAN
 * @retval	SHINKA_PLACE_KOKE
 * @retval	SHINKA_PLACE_ICE
 */
//-----------------------------------------------------------------------------
int ZoneData_GetShinkaPlaceID(int zone_id)
{
	static const u16 tbl[] = {
		ZONE_ID_R217,		SHINKA_PLACE_ICE,
		ZONE_ID_D03R0101,	SHINKA_PLACE_KOKE,
		ZONE_ID_D05R0101,	SHINKA_PLACE_TENGANZAN,
		ZONE_ID_D05R0102,	SHINKA_PLACE_TENGANZAN,
		ZONE_ID_D05R0103,	SHINKA_PLACE_TENGANZAN,
		ZONE_ID_D05R0104,	SHINKA_PLACE_TENGANZAN,
		ZONE_ID_D05R0105,	SHINKA_PLACE_TENGANZAN,
		ZONE_ID_D05R0106,	SHINKA_PLACE_TENGANZAN,
		ZONE_ID_D05R0107,	SHINKA_PLACE_TENGANZAN,
		ZONE_ID_D05R0108,	SHINKA_PLACE_TENGANZAN,
		ZONE_ID_D05R0109,	SHINKA_PLACE_TENGANZAN,
		ZONE_ID_D05R0110,	SHINKA_PLACE_TENGANZAN,
		ZONE_ID_D05R0111,	SHINKA_PLACE_TENGANZAN,
		ZONE_ID_D05R0112,	SHINKA_PLACE_TENGANZAN,
		ZONE_ID_D05R0113,	SHINKA_PLACE_TENGANZAN,
		ZONE_ID_D05R0114,	SHINKA_PLACE_TENGANZAN,
		ZONE_ID_D05R0115,	SHINKA_PLACE_TENGANZAN,
	};
	int i;
	for (i = 0; i < NELEMS(tbl); i += 2) {
		if (tbl[i] == zone_id) {
			return tbl[i + 1];
		}
	}
	return SHINKA_NONE;
}

