#---------------------------------------------------
#
#	@brief	GA̓샂fXgpXNvg
#	@file	area_move_model.rb
#	@date	2005.11.24
#	@author	tamada GAME FREAK Inc.
#
#	@param	ARGV[0]	^[Qbg`o͐t@C	
#	@param	ARGV[1]	A[JCuΏے`t@C
#	@param	ARGV[2]	GAǗ\t@C
#	@param	ARGV[3]	샂fǗ\t@C
#
#---------------------------------------------------
FIELDOBJ_CODE_HEADER	=	"fieldobj_code.h"
$KCODE = "SJIS"
#---------------------------------------------------
#	GAǗ\̉
#---------------------------------------------------
def read_areatable	filename
	arealist = []
	count = 0
	infile = File.open(filename, "r")
	infile.gets		#2sǂݔ΂
	infile.gets
	while line = infile.gets
		if line =~ /^AREA_ID_/ then
			areaname = line.split[0].sub(/\AAREA_ID_/, "").downcase
			if arealist.include?(areaname) then
				STDERR.puts "GAIDd`Ă܂:#{areaname}\n"
			else
				arealist[count] = areaname
				count += 1
			end
		else
			break
		end
	end
	return arealist
end

#---------------------------------------------------
#	GÃAZut@C𐶐
#---------------------------------------------------
def make_asmfile filename, objlist
	output = ""
	output += "\#	풓샂f`Xg:#{filename}\n"
	output += "\t.text\n"
	output += "\#include	\"#{FIELDOBJ_CODE_HEADER}\"\n"
	output += "\n"
	objlist.each {|model|
		name = model.upcase
		if name != model
			STDERR.puts "܂:#{filename},#{model}\n"
		end
		output += "\t.short\t#{model}\n"
	}
	output += "\n"
	output += "	.short	OBJCODEMAX\n"
	output += "\n"
end

#---------------------------------------------------
#	샂fXg̏ꂽt@C
#---------------------------------------------------
def read_area_movemodel filename
	areadata = {}
	infile = File.open(filename, "r")

	while line = infile.gets
		#	"#end"Ŏn܂ꍇAf[^I[Ƃ݂Ȃ
		if line =~/^#end/ then break end
		#	"#"Ŏn܂ꍇRgsƂēǂݔ΂
		if line =~ /^#/ then next end

		column = line.split
		areaname = column[0].downcase
		if areadata.key? areaname
			STDERR.puts "GAdĂ̂ŃXLbv܂F#{areaname}\n"
			next
		end
		areadata[areaname] = make_asmfile areaname, column[1..column.length - 1]
	end

	infile.close
	return areadata
end

#---------------------------------------------------
#---------------------------------------------------
def make_listfile srcfilename, arcfilename, arealist
	srcfile = File.open(srcfilename, "w")
	arcfile = File.open(arcfilename, "w")

	srcfile.puts "#ꂽt@Cł\n"
	srcfile.puts "SRCFILES	=	\\\n"

	arealist.each {|name|
		srcfile.puts "\t#{name}.s \\"
		arcfile.puts "\"#{name}.bin\"\n"
	}

	srcfile.puts "\n"
	srcfile.close
	arcfile.close
end

#---------------------------------------------------
#---------------------------------------------------
def make_area_asm_files arealist, areadata
	dummy_list = []
	arealist.each {|areaname|
		sfile = File.open(areaname + ".s", "w")
		if areadata.key?(areaname) then
			sfile.puts areadata[areaname]	
		else
			STDERR.puts "f[^Ȃ̂Ń_~[𐶐܂F#{areaname}\n"
			sfile.puts "#{make_asmfile areaname, dummy_list}\n"
		end
		sfile.close
	}
end

#---------------------------------------------------
#---------------------------------------------------
def check_entry_area arealist, areadata
	areadata.each{|key, value|
		unless arealist.include?(key) then
			puts "݂ȂGA̒`܂\t#{key}\n"
		end
	}
end
#---------------------------------------------------
#	Cт
#---------------------------------------------------
arealist = read_areatable ARGV[2]
areadata = read_area_movemodel ARGV[3]

make_listfile ARGV[0], ARGV[1], arealist
make_area_asm_files arealist, areadata
check_entry_area arealist, areadata

