#ifndef _AGB_ACCESS_H
#define _AGB_ACCESS_H

#include "pokeparam.h"
#include "pm_version.h"

#define SOFTTYPE_RS	0	// r[ATt@CA
#define SOFTTYPE_FL	1	// t@CAbhA[tO[
#define SOFTTYPE_EM 2	// Gh

#if 0
#define LANGTYPE_JP 0
#define LANGTYPE_US 1
#define LANGTYPE_FR 2
#define LANGTYPE_GE 3
#define LANGTYPE_SP 4
#define LANGTYPE_IT 5
#else
#define LANGTYPE_JP LANG_JAPAN
#define LANGTYPE_US LANG_ENGLISH
#define LANGTYPE_FR LANG_FRANCE
#define LANGTYPE_GE LANG_GERMANY
#define LANGTYPE_SP LANG_SPAIN
#define LANGTYPE_IT LANG_ITALY
#endif

enum {
  CASTYPE_RUBY = 0,
  CASTYPE_SAPPHIRE,
  CASTYPE_GREEN,
  CASTYPE_RED,
  CASTYPE_EMERALD,
  CASTYPE_MAX
};


#define	SVLD_RET_NG			(0xff)		//Z[uʁiݏoȂj
#define	SVLD_RET_NULL		(0x0)		//Z[uʁiobNAbvȂj
#define	SVLD_RET_OK			(0x1)		//Z[uʁiɏIj
#define	SVLD_RET_DESTROY	(0x2)		//Z[uʁiSjFAs\j
#define	SVLD_RET_FULL		(0x3)		//Z[uʁiȏ㏑ݏoȂj
#define	SVLD_RET_HARDERROR	(0x4)		//n[hG[iՂȂj
#define	SVLD_RET_ERROR		(0x5)		//ǂݍ݂Ɏs@idāAJ[gbW肳Ƃ𑣂j

#define	SVLD_HEADER_SIZE	(4+2+4+2)	//wb_TCY
#define	SVLD_SECTOR_SIZE	(0x1000)	//ZN^TCY
#define	SVLD_DATA_SIZE		(SVLD_SECTOR_SIZE - SVLD_HEADER_SIZE)	//f[^TCY





typedef struct
{
	u32 buffer[SVLD_SECTOR_SIZE / 4];
	u8 MyData[SVLD_SECTOR_SIZE];
	u8 Fld[SVLD_SECTOR_SIZE*4];
	POKEBOX_SAVE_DATA pc_data;
} AGBPOKE_SAVEDATA;

#define AGBPOKE_BUFFERSIZE (sizeof(AGBPOKE_SAVEDATA)) 

enum
{
	AGBPOKE_ERROR_OK,
	AGBPOKE_ERROR_NOROM,
	AGBPOKE_ERROR_NOTPOKEMON,
	AGBPOKE_ERROR_NOFLASH,
	AGBPOKE_ERROR_READ,
	AGBPOKE_ERROR_NG,
	AGBPOKE_ERROR_DESTROY,
	AGBPOKE_ERROR_NULL,	
	AGBPOKE_ERROR_WRITE,
	AGBPOKE_ERROR_WRITING,
	AGBPOKE_ERROR_CONTINUE,	
	AGBPOKE_ERROR_LAST,
	AGBPOKE_ERROR_OTHER			
};

//==============================================================================
/**
 * agbpoke_*ĂяoOɁÅ֐R[ĂB
 * @param   buffercobt@nBKvȗʂAGBPOKE_BUFFERSIZE
 * @retval  G[R[h
 */
//==============================================================================
extern int agbpoke_init( void *buffer );
extern void agbpoke_preinit(void);

//==============================================================================
/**
 * Ă\tg̃CjVR[h擾܂B
 * @retval  TRUEc@FALSEcs
 */
//==============================================================================
extern u32 agbpoke_getInitialCode();

//==============================================================================
/**
 * Ă\tg̃Q[ނԂ܂B
 * @retval  JZbg̃|P^Cv
 */
//==============================================================================
extern int agbpoke_getPokemonType();

//==============================================================================
/**
 * Ă|P\tǧԂB
 * @retval  JZbǧ
 */
//==============================================================================
extern int agbpoke_getPokemonLanguage();

//==============================================================================
/**
 * f[^[hB
 * @param   newsectorcVZN^[̔ԍĂ(01)
 * @param   buffer   cSVLD_SECTOR_SIZE Kv
 * @retval  ʁB
 */
//==============================================================================
extern int agbpoke_LoadDATA();

//==============================================================================
/**
 * p\Rf[^ւ̃|C^擾B
 * @param   newsectorcVZN^[̔ԍĂ(01)
 * @param   buffer   cSVLD_SECTOR_SIZE Kv
 * @retval  ʁB
 */
//==============================================================================
extern POKEBOX_SAVE_DATA *agbpoke_getPCdata();

//==============================================================================
/**
 * }ӂĂ邩B
 * @retval  ʁB
 */
//==============================================================================
extern BOOL gbapoke_hasZukan();

//==============================================================================
/**
 * |PZ^[ŃZ[uĂ邩ǂ
 * @retval  ʁB
 */
//==============================================================================
extern BOOL gbapoke_inPokemonCenter();

//==============================================================================
/**
 * f[^񓯊ŃZ[uB
 * @retval  ʁB
 */
//==============================================================================
extern BOOL agbpoke_saveEdit_Async();
//==============================================================================
/**
 * f[^񓯊ŃZ[uƂAI`FbN֐B
 * @retval  ʁB
 */
//==============================================================================
extern int agbpoke_saveEdit_check();
extern int agbpoke_check_status(void);

//==============================================================================
/**
 * f[^Z[uBAGBPOKE_ERROR_CONTINUEȊO̒lԂ܂ŌĂяoĉB
 * @retval  ʁB
 */
//==============================================================================
extern int agbpoke_saveEdit( );
extern void *agbpoke_GetMyDataPtr(void);

#endif
