#include "agbpoke_access.h"
#include "agbpoke_util.h"

static u16 agbpoke_font[] = L"@ĂƂȂɂʂ˂̂͂Ђӂւق܂݂ނ߂񂟂傪Âłǂ΂тԂׂڂς҂Ղ؂ۂACEGIJLNPRTVXZ\^`cegijklmnqtwz}~@BDFHKMOQSUWY[]_adfhorux{psvy|b0123456789!?B[Ecwxuv~D~^ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz:";
#define EUFONT_START 0xf1
#define EOM_			0xff		/* IR[h */

static u16 eufont[] = 
{
	0x00c4, /* EEg啶A */
	0x00d6, /* EEg啶O */
	0x0055, /* EEg啶U */
	0x00e4, /* EEgA */
	0x00f6, /* EEgO */
	0x00fc /* EEgU */
};
static u16 convPokecode(u8 code)
{
	if( code < EUFONT_START ) return agbpoke_font[code];
	return eufont[code - EUFONT_START];
	
}

void agbpoke_codeConv(u8 *src, u16 *dest, int length)
{
	int i;
	for(i = 0; i < length; i++)
	{
		if( *(src + i) == EOM_ )
		{
			dest[i] = 0;
			return;
		}
		dest[i] = convPokecode(*(src + i));
	}
	dest[length] = 0;
}


//------------------------------------------------------------------
/**
 * @brief	g[i[̂hcio[Ԃ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
u32 agbpoke_GetTrainerID(void)
{
  SYS_SAVE_DATA *myd = agbpoke_GetMyDataPtr();	// MyDataւ̃|C^Ԃ
  return myd->ID[3] << 24 | myd->ID[2] << 16 | myd->ID[1] << 8 | myd->ID[0];
}

//------------------------------------------------------------------
/**
 * @brief	g[i[Ԃ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
u8 *agbpoke_GetTrainerName(void)
{
  SYS_SAVE_DATA *myd = agbpoke_GetMyDataPtr();	// MyDataւ̃|C^Ԃ
  return myd->my_name;
}


/*  */
