//===================================================================
/**
 * @file	agbpokemon.c	
 * @bfief	AGB|PJZbgDPԂ̃|Pf[^ړ
 * @author	Satoshi Mitsuhara
 * @date	06.05.30
 *
 */
//===================================================================

// BG0	bZ[WEBhE
// BG1	|PXe[^X\EBhE
// BG2	wi
// BG3	gp

#include "common.h"
#include "system/main.h"
#include "system/procsys.h"
#include "system/wordset.h"
#include "system/wipe.h"
#include "system/arc_util.h"
#include "system/msgdata_util.h"
#include "system/fontproc.h"
#include "system/window.h"
#include "system/snd_tool.h"
#include "system/touch_subwindow.h"
#include "system/pmfprint.h"
#include "system/agb_str.h"

#include "gflib/touchpanel.h"
#include "itemtool/item.h"

#include "system/clact_tool.h"
#include "poketool/monsno.h"
#include "poketool/pokeicon.h"
#include "poketool/poke_tool.h"
#include "../poketool/poke_tool_def.h"		/* ##### */
#include "savedata/pokepark_data.h"
#include "savedata/savedata.h"
#include "savedata/config.h"

#include "battle/battle_server.h"
#include "battle/wazano_def.h"

#include "agbpoke_access.h"
#include "agbpoke_tool.h"
#include "agbpoke_util.h"

#include "msgdata/msg.naix"
#include "msgdata/msg_pokemonpark.h"

#include "demo/title.h"

#include "comm_mystery_func.h"
#include "mystery.naix"
#include "mysterylib.h"

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/01
// AGBJ[gbWꂽƂ́Au[XN[ɑJڂ悤ɕύX
#if AFTERMASTER_070123_GBACARTRIDGE_BUF_FIX
#include "application/backup.h"
#endif
// ----------------------------------------------------------------------------


//============================================================================================
//	萔`
//============================================================================================
#define SetSeq(x)		*seq = (x)

// |PACRn܂VRAMł̃ItZbg
#define POKEICON_VRAM_OFFSET ( 0x64 )
#define POKEICON_TRANS_CHARA	(4*4)
#define POKEICON_TRANS_SIZE		(POKEICON_TRANS_CHARA*0x20)
// |PACR̃pbg]ItZbg
#define POKEICON_PAL_OFFSET				(  8 )
//** CharManager PlttManagerp **//
#define RECORD_CHAR_CONT_NUM				(20)
#define RECORD_CHAR_VRAMTRANS_MAIN_SIZE		(2048)
#define RECORD_CHAR_VRAMTRANS_SUB_SIZE		(2048)
#define RECORD_PLTT_CONT_NUM				(20)
// |P̕\ݒ
#define POKEMON_WIDTH			40
#define POKEMON_HEIGHT			24
#define POKEMON_BASEX			28
#define POKEMON_BASEY			40


#define POKEMON_ICON_MAX			30
#define POKEMON_SCREEN_TOUCH_MAX		3
#define POKEMON_TOUCH_ICONMAX		(POKEMON_ICON_MAX+POKEMON_SCREEN_TOUCH_MAX+1)

#define POKEMON_SELECT_MAX			6
#define POKEMON_NOSELECT			-1

#define ICON_CANCEL			(POKEMON_ICON_MAX+0)
#define ICON_ARROWL			(POKEMON_ICON_MAX+1)
#define ICON_ARROWR			(POKEMON_ICON_MAX+2)
#define ICON_TERMINATE			(POKEMON_ICON_MAX+3)


typedef struct {
  GF_BGL_BMPWIN *win;
  int flag;
  int sx, sy;
  int width, height;
  int dx, dy;
  int base;
  int screen;
  FONT_TYPE font;
  GF_PRINTCOLOR color;
  GF_PRINTCOLOR clrcolor;
  int msgid;
  STRCODE *msgp;
  STRBUF *msg;
  WORDSET *word;
  int msgwait;

  int m_id;
} REGWIN;
#define MSG_FLAG_CENTER		0x01
#define MSG_FLAG_NOCLEAR	0x02
#define MSG_FLAG_NOREDRAW	0x04
#define MSG_FLAG_FRAME		0x08
#define MSG_FLAG_TALKWIN	0x10



typedef struct {
  CLACT_WORK_PTR clact;
  CLACT_WORK_PTR item;
  int monsno;
} POKEMON_ICON;

typedef struct {
  CLACT_WORK_PTR icon;
  int pokeno;
  int boxno;
} MARK_ICON;


typedef struct {
  int save_seq;
  int wait_frame;
  void *time_icon;

} SAVEWORK;


typedef struct {
  int vadrs;				// VRAMAhX
  int palno;				// pbgԍ
  CLACT_WORK_PTR icon;			// CLACT
  u8 chbuf[POKEICON_TRANS_SIZE];	// LN^obt@
} POKEBUF;



typedef struct {
  int cartridge_type;				// VERSION_xxxx (pm_version.hQ)
  int agberror;
  int msg_flag;
  int jiffy;
  
  SAVEDATA *sv;
  MYSTATUS *mst;
  CONFIG *cfg;
  int win_type;
  
  GF_BGL_INI *bgl;

  int next_seq;

  // ZAN^[֘A
  CLACT_SET_PTR	clactSet;				// ZAN^[Zbg 
  CLACT_U_EASYRENDER_DATA renddata;			// ȈՃ_[f[^
  CLACT_U_RES_MANAGER_PTR resMan[CLACT_U_RES_MAX];	// \[X}l[W
  CLACT_U_RES_OBJ_PTR resObjTbl[CLACT_U_RES_MAX];	// \[XIuWFe[u
  CLACT_HEADER clActHeaderMain;
  // |PACR 30̕
  POKEMON_ICON icon[POKEMON_ICON_MAX];
  RECT_HIT_TBL iconrect[POKEMON_TOUCH_ICONMAX];

  // Ƃ
  CLACT_WORK_PTR cancel[4];	// S
  // E
  CLACT_WORK_PTR arrowr[4];	// S
  // 
  CLACT_WORK_PTR arrowl[4];	// S
  // }[N
  MARK_ICON mark[POKEMON_SELECT_MAX];	// U(Ił|P̐)
  int selected;
  
  // ʂ̃|PAN^[
  CLACT_WORK_PTR check_poke[POKEMON_SELECT_MAX];
  REGWIN cwin;

  // bZ[WEBhE֘A
  GF_BGL_BMPWIN	TitleWin;
  GF_BGL_BMPWIN	BoxNameWin;
  GF_BGL_BMPWIN	CheckWin;
  
  // AGBJ[gbWANZX֌W
  int cartridge_status;
  int load_status;
  u32 buffer[AGBPOKE_BUFFERSIZE/sizeof(u32)];
  POKEBOX_SAVE_DATA *boxdata;
  int CurrentBox;

  int wait_seq;

  // ʃEChEVXe
  TOUCH_SW_SYS *TouchSubWindowSys;

  SAVEWORK save_work;

  // |PACR̍\p
  POKEBUF pokebuf[POKEMON_ICON_MAX];
  void (*DrawFunc)(void);
  
} AGBCARTRIDGE_WORK;


POKEBUF *_PokeBufPtr;


enum {

  AGBCARTRIDGE_SEQ_INIT_CARTRIDGE,	/* AGBJ[gbW */
  AGBCARTRIDGE_SEQ_PREINIT_SCREEN,	/* XN[ */
  
  AGBCARTRIDGE_SEQ_CHECK_USER,		/* J[gbW̃[U[mF */
  AGBCARTRIDGE_SEQ_CHECK_USER_YESNO,

  AGBCARTRIDGE_SEQ_CHECK_FINAL,
  AGBCARTRIDGE_SEQ_CHECK_FINAL_YESNO,
  AGBCARTRIDGE_SEQ_DISP_MESSAGE,
  AGBCARTRIDGE_SEQ_DISP_MESSAGE_YESNO,
  
  AGBCARTRIDGE_SEQ_ERROR_YESNO_SCREEN,
  AGBCARTRIDGE_SEQ_ERROR_YESNO_SCREEN2,
  AGBCARTRIDGE_SEQ_ERROR_YESNO_SCREEN3,
  AGBCARTRIDGE_SEQ_ERROR_SCREEN,	/* ^Cg֖߂G[\ */

  AGBCARTRIDGE_SEQ_INIT_SCREEN,		/* XN[ ̂Q */
  AGBCARTRIDGE_SEQ_MAIN,		/* C */
  AGBCARTRIDGE_SEQ_SELECT_WARNING,	/* IłȂ|PI */

  AGBCARTRIDGE_SEQ_WAIT_CHECK_SCREEN,	/* mFʂ֍sԂ̂Ƃ́uԁv */
  AGBCARTRIDGE_SEQ_CREATE_CHECK_SCREEN,	/* mFʍ쐬 */
  AGBCARTRIDGE_SEQ_CREATE_CHECK_TOUCH1,	/* uĂ܂ṽ^bv҂ */
  AGBCARTRIDGE_SEQ_CREATE_CHECK_TOUCH,	/* uzgɂ́Hṽ^bv҂ */
  AGBCARTRIDGE_SEQ_CREATE_CHECK_MAIN,	/* mFʏ */
  AGBCARTRIDGE_SEQ_RETURN_SELECT,	/* Iʂɖ߂邽߂̏ */

  AGBCARTRIDGE_SEQ_SAVE,		/* Z[u */
  AGBCARTRIDGE_SEQ_SAVE_END,		/* ^bv҂ */
  
  AGBCARTRIDGE_SEQ_WAIT_FADE,		/* tF[h҂Ď̃V[PX */
  AGBCARTRIDGE_SEQ_FINISH,		/* ̉ʂ̌n{Ō */
  AGBCARTRIDGE_SEQ_MAX
};


enum {
  SAVE_SEQ_INIT,			/* Z[u */

  SAVE_SEQ_WAIT_INIT_TIMING1,		/* ^C~O炵ԏ̂P */
  SAVE_SEQ_WAIT_TIMING1,		/* ^C~O炵Ԃ̂P */
  
  SAVE_SEQ_DSSAVE_INIT,			/* DS̃Z[u */
  SAVE_SEQ_DSSAVE_MAIN,			/* DS̃Z[uC */

  SAVE_SEQ_AGBSAVE_CHECK,		/* AGB̃Z[ueXg(KChCɊÂ) */
  SAVE_SEQ_AGBSAVE_INIT,		/* AGB̃Z[u */
  SAVE_SEQ_AGBSAVE_MAIN,		/* AGB̃Z[uC */
#if 0
  SAVE_SEQ_WAIT_INIT_TIMING2,		/* ^C~O炵ԏ̂Q */
  SAVE_SEQ_WAIT_TIMING2,		/* ^C~O炵Ԃ̂Q */
#endif
  SAVE_SEQ_SAVE_LAST,			/* Ō̃ZN^Z[u */
  SAVE_SEQ_SAVE_FINAL,			/* Ō҂ */

  /* ֐̖߂lƂĎgp */
  SAVE_STATUS_WRITING,			/* ݏ */
  SAVE_STATUS_WRITE_SUCCESS,		/* ݂ɐ */
  SAVE_STATUS_WRITE_ERROR,		/* ݂Ɏs */
  
  SAVE_SEQ_MAX
};


// EBhE֘A
#define	FONT_PALNO_NORMAL	15	/* m[}pbg */

#define	AGBPOKEMON_BLACK	(GF_PRINTCOLOR_MAKE( 1, 2, 0))
#define	AGBPOKEMON_WHITE	(GF_PRINTCOLOR_MAKE(15, 2, 0))
#define	AGBPOKEMON_WHITEBLACK	(GF_PRINTCOLOR_MAKE(15, 2, 15))
#define	AGBPOKEMON_BLACKBLACK	(GF_PRINTCOLOR_MAKE( 1, 2, 15))

#define AGBPOKEMON_CHRBASE	0
#define AGBPOKEMON_TITLEBASE	0xA0
#define AGBPOKEMON_STATUSBASE	(14*2+AGBPOKEMON_TITLEBASE)

#define AGBPOKEMON_FRAMECHR	0x3F0
#define AGBPOKEMON_FRAMECOL	14
#define AGBPOKEMON_TFRAMECHR	(AGBPOKEMON_FRAMECHR - TALK_WIN_CGX_SIZ)
#define AGBPOKEMON_TFRAMECOL	13

#define AGBPOKEMON_YESWIN	(30*4+1)
#define AGBPOKEMON_NOWIN	(8*2+30*4+1)


// AčsȂuЂł킴ṽXg
static int WazaHidenTable[] = {
  WAZANO_IAIGIRI,			// 
  WAZANO_SORAWOTOBU,			// Ƃ
  WAZANO_NAMINORI,			// Ȃ݂̂
  WAZANO_KAIRIKI,			// 肫
  WAZANO_HURASSYU,			// tbV
  WAZANO_IWAKUDAKI,			// 킭
  WAZANO_TAKINOBORI,			// ̂ڂ
  WAZANO_DAIBINGU,			// _CrO
};

// [U[mFp̃bZ[We[u
static int UsrCheckMsgTable[] = {
  NULL,		// unknown
  msg_pokepark_02,			// o[WFAGBTt@CA
  msg_pokepark_01,			// o[WFAGBr[
  msg_pokepark_03,			// o[WFAGBGh
  msg_pokepark_04,			// o[WFAGBt@CA[bh
  msg_pokepark_05,			// o[WFAGB[tO[
};

// Z[ũbZ[W
static int SaveMsgTable[] = {
  NULL,		// unknown
#if (PM_VERSION == VERSION_DIAMOND)
  msg_pokepark_22,			// "Tt@CA@Ɓ@_Ch@\n|P|[g@Ă܂"
  msg_pokepark_20,			// "r[@Ɓ@_Ch@\n|P|[g@Ă܂"
  msg_pokepark_24,			// "Gh@Ɓ@_Ch@\n|P|[g@Ă܂"
  msg_pokepark_26,			// "t@CAbh@Ɓ@_Ch@\n|P|[g@Ă܂"
  msg_pokepark_28,			// "[tO[@Ɓ@_Ch@\n|P|[g@Ă܂"
#elif (PM_VERSION == VERSION_PEARL)
  msg_pokepark_23,			// "Tt@CA@Ɓ@p[@\n|P|[g@Ă܂"
  msg_pokepark_21,			// "r[@Ɓ@p[@\n|P|[g@Ă܂"
  msg_pokepark_25,			// "Gh@Ɓ@p[@\n|P|[g@Ă܂"
  msg_pokepark_27,			// "t@CAbh@Ɓ@p[@\n|P|[g@Ă܂"
  msg_pokepark_29,			// "[tO[@Ɓ@p[@\n|P|[g@Ă܂"
#endif
};

static u8 BgPalTable[] = {
  0,		// NULL
  2,		// Tt@C
  1,		// r[
  3,		// Gh
  4,		// t@CAbh
  5,		// [tO[
};


static int ErrorMsgTable[] = {
  NULL,
  msg_pokepark_39,			// AGB̃Z[uf[^ǂ߂Ȃ
  msg_pokepark_33,			// QS񂽂ȂƁc
  msg_pokepark_34,			// ق񂽂Ƃ
  msg_pokepark_34,			// ق񂽂Ƃ
  msg_pokepark_07,			// {bNXɂU܂
  msg_pokepark_09,			// łɂĂ܂c
  msg_pokepark_35,			// ܂QSĂ܂
};

#if (PM_VERSION == VERSION_DIAMOND)
#define CHECK_FINAL_MSG		msg_pokepark_36
#define SAVE_SUCCESS_MSG	msg_pokepark_31
#elif (PM_VERSION == VERSION_PEARL)
#define CHECK_FINAL_MSG		msg_pokepark_37
#define SAVE_SUCCESS_MSG	msg_pokepark_32
#endif


//============================================================================================
//	vg^Cv錾
//============================================================================================
static void DrawBoxTitle(AGBCARTRIDGE_WORK *wk, int boxnumber);
static void CheckSelectPokemonIcon(AGBCARTRIDGE_WORK *wk);
static void InitUpMessageWindow(AGBCARTRIDGE_WORK *wk);
static void AgbCartridge_ReqYesNoIcon(AGBCARTRIDGE_WORK *wk);
static void AgbCartridgeDataUpdate(AGBCARTRIDGE_WORK *wk);
void STRBUF_SetStringCodeOrderLength( STRBUF* strbuf, const STRCODE* str, u32 len );

extern void STRBUF_SetStringCode( STRBUF* strbuf, const STRCODE* sz );

//============================================================================================
//	O[oϐ
//============================================================================================

extern void AGBPPPtoDSPPP(PokemonPasoParam *agb_ppp,POKEMON_PASO_PARAM *ds_ppp);


//------------------------------------------------------------------
/**
 * @brief	AGBł͂肦Ȃ|P̔
 * @param	NONE
 * @return	TRUE: OK  FALSE: s|P
 */
//------------------------------------------------------------------
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/18
// AGB̃|Pio[ŃZrBƃL̊ԂsƔf悤

#define MONSNO_AGB_SEREBII	251
#define	MONSNO_AGB_KIMORI	277
#define	MONSNO_AGB_TIRIIN	411

static BOOL CheckInJusticePokemon(int agb_monsno)
{
  if (agb_monsno <= 0)                  return TRUE;	// 
  if (agb_monsno <= MONSNO_AGB_SEREBII) return FALSE;
  if (agb_monsno <  MONSNO_AGB_KIMORI)  return TRUE;
  if (agb_monsno <= MONSNO_AGB_TIRIIN)  return FALSE;
  return TRUE;
}

// ----------------------------------------------------------------------------


//------------------------------------------------------------------
/**
 * @brief	wk->cartridge_type ֒lݒ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void AgbCartridge_SetCartridgeType(AGBCARTRIDGE_WORK *wk)
{
  switch(agbpoke_getPokemonType()){
  case CASTYPE_RUBY:	wk->cartridge_type = VERSION_RUBY;	break;
  case CASTYPE_SAPPHIRE:wk->cartridge_type = VERSION_SAPPHIRE;	break;
  case CASTYPE_GREEN:	wk->cartridge_type = VERSION_GREEN;	break;
  case CASTYPE_RED:	wk->cartridge_type = VERSION_RED;	break;
  case CASTYPE_EMERALD:	wk->cartridge_type = VERSION_EMERALD;	break;
  default:		wk->cartridge_type = -1;		break;
  }
}


//------------------------------------------------------------------
/**
 * @brief	Z[uV[PX
 * @param	NONE
 * @return	NONE
 *
 * ňȏԂłĂB͂邯ǌ͂Ȃ悤ɂ
 * ̏ԂƂĂ͈ȉ̒ʂ
 * PAcr̃XgPZN^ȊOSăZ[u
 * QA`fãXgPZN^ȊOSăZ[u
 * RA^C~O炵(^C~OvđBȂ悤ɂ邽)
 * SAcrƂ`fãXgZN^CɃZ[u
 * TAI
*/
//------------------------------------------------------------------
static int SaveSequence(AGBCARTRIDGE_WORK *wk)
{
  int ret;
  u8 backupbuf[16];
  SAVE_RESULT result;
  POKEPARK_DATA *ppark;
  SAVEWORK *sw = &wk->save_work;

#if 0//def DEBUG_ONLY_FOR_mituhara
  OS_TPrintf("  save_seq = %d\n", sw->save_seq);
#endif
#if 0
  // Z[useXg
  return SAVE_STATUS_WRITE_SUCCESS;
#endif
  
  switch(sw->save_seq){
  case SAVE_SEQ_INIT:
    // 
    AgbCartridgeDataUpdate(wk);
    ppark = SaveData_GetPokeParkData(wk->sv);
    // Z[uǗpf[^Zbg
    POKEPARKDATA_SetMasterData(ppark, agbpoke_GetTrainerID());
    sw->save_seq++;
    break;

  case SAVE_SEQ_WAIT_INIT_TIMING1:
    /* ^C~O炵ԏ̂P */
    sw->wait_frame = 1 + OS_GetTick() % 120;
    sw->save_seq++;
    break;

  case SAVE_SEQ_WAIT_TIMING1:
    /* ^C~O炵Ԃ̂P */
    if(--sw->wait_frame == 0)
      sw->save_seq++;
    break;

  case SAVE_SEQ_DSSAVE_INIT:
    // DS̃Z[uAݒ
    SaveData_DivSave_Init(wk->sv, SVBLK_ID_MAX);
    sw->save_seq++;
    break;

  case SAVE_SEQ_DSSAVE_MAIN:
    // DS̃Z[uC
    result = SaveData_DivSave_Main(wk->sv);
    if(result == SAVE_RESULT_NG)	return SAVE_STATUS_WRITE_ERROR;
    if(result == SAVE_RESULT_LAST)	sw->save_seq++;
    break;

  case SAVE_SEQ_AGBSAVE_CHECK:
    // AGB̃Z[ueXg(KChCɊÂ)
    CTRDG_ReadAgbFlash(0, 0, backupbuf, sizeof(backupbuf));
    sw->save_seq++;
    break;

  case SAVE_SEQ_AGBSAVE_INIT:
    // AGB̃Z[u
    ret = agbpoke_saveEdit_Async();
    if(ret == FALSE){
      sys_SleepOK(SLEEPTYPE_SAVELOAD);
      return SAVE_STATUS_WRITE_ERROR;
    }
    sw->save_seq++;
    break;

  case SAVE_SEQ_AGBSAVE_MAIN:
    // AGB̃Z[uC
    if(agbpoke_check_status() == AGBPOKE_ERROR_WRITING)
      // ĂŒPt[҂
      break;
    if(agbpoke_check_status() == AGBPOKE_ERROR_LAST){
      // Ō̂PZN^ȊO͏߂
      sw->save_seq++;
    } else {
      // ɂǂǂ񏑂Ă
      ret = agbpoke_saveEdit_check();
      if(ret == AGBPOKE_ERROR_WRITE){
	sys_SleepOK(SLEEPTYPE_SAVELOAD);
	return SAVE_STATUS_WRITE_ERROR;
      }
    }
    break;
#if 0
  case SAVE_SEQ_WAIT_INIT_TIMING2:
    // ^C~O炵ԏ
    sw->wait_frame = 10 + (wk->jiffy % 60);
    sw->save_seq++;
    break;

  case SAVE_SEQ_WAIT_TIMING2:
    // ^C~O炵
    if(--sw->wait_frame == 0)
      sw->save_seq++;
    break;
#endif
  case SAVE_SEQ_SAVE_LAST:
    // Ō̃ZN^Z[u
    // ܂DSZ[u
    do {
      result = SaveData_DivSave_Main(wk->sv);
      //      OS_TPrintf("----- DS : %d\n", result);
      if(result == SAVE_RESULT_NG)	return SAVE_STATUS_WRITE_ERROR;
    } while(result != SAVE_RESULT_OK);
    // AGBZ[u(łAsyncĂ΂Ă̂ňUmain֏߂)
    agbpoke_saveEdit_check();
    sys_SleepNG(SLEEPTYPE_SAVELOAD); // DSSleepONɂĂ̂ōēxOFF
    sw->save_seq++;
    break;

  case SAVE_SEQ_SAVE_FINAL:
    // AGB̏I҂
    ret = agbpoke_saveEdit_check();
    if(ret == AGBPOKE_ERROR_WRITE){
      sys_SleepOK(SLEEPTYPE_SAVELOAD);
      return SAVE_STATUS_WRITE_ERROR;
    }
    if(ret == AGBPOKE_ERROR_OK){
      //      OS_TPrintf("Z[uIł\n");
      sys_SleepOK(SLEEPTYPE_SAVELOAD);
      return SAVE_STATUS_WRITE_SUCCESS;
    }
    break;
  }

  return SAVE_STATUS_WRITING;
}


//------------------------------------------------------------------
/**
 * @brief	crJ[hւ̃Z[u
 * @param	wk
 * @return	NONE
 */
//------------------------------------------------------------------
static void SaveDsCard(AGBCARTRIDGE_WORK *wk)
{
  POKEPARK_DATA *ppark;
  SAVE_RESULT result;

  ppark = SaveData_GetPokeParkData(wk->sv);
  // Z[uǗpf[^Zbg
  POKEPARKDATA_SetMasterData(ppark, agbpoke_GetTrainerID());
  // ۂ̃Z[u
  sys_SoftResetNG(SOFTRESET_TYPE_SAVELOAD);
  result = SaveData_Save(wk->sv);
  sys_SoftResetOK(SOFTRESET_TYPE_SAVELOAD);
  //  result = SaveData_SaveParts(wk->sv, SVBLK_ID_MAX);
}


//------------------------------------------------------------------
/**
 * @brief	q`l̂`faJZbgf[^XV
 * @brief	q`l̂crJ[hf[^XV
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void AgbCartridgeDataUpdate(AGBCARTRIDGE_WORK *wk)
{
  int i, boxno, index;
  u16 monsno;

  POKEMON_PASO_PARAM *ds_ppp_ptr;
  PokemonPasoParam *ppp;
  POKEMON_PARAM ds_ppp;
  POKEPARK_DATA *ppark;

  // DS̃f[^XV
  
  ppark = SaveData_GetPokeParkData(wk->sv);
  ds_ppp_ptr = PPPPointerGet(&ds_ppp);
  // IUC|Pp[Ñ[NփZbg
  for(i = 0; i < POKEMON_SELECT_MAX; i++){
    index = wk->mark[i].pokeno;
    boxno = wk->mark[i].boxno;
    ppp = &wk->boxdata->PPPBox[boxno][index];
    // AGBPPPDSPPP֕ϊȂ珑
    AGBPPPtoDSPPP(ppp, ds_ppp_ptr);
    POKEPARKDATA_SetData(ppark, ds_ppp_ptr, i);
  }


  // `fãf[^XV
  
  // Iꂽ|P{bNX
  monsno = 0;
  for(i = 0; i < POKEMON_SELECT_MAX; i++){
    index = wk->mark[i].pokeno;
    boxno = wk->mark[i].boxno;
    // 蓾ȂǔÔ߂Ƀ`FbN
    if(index != POKEMON_NOSELECT && boxno != BOX_NUM){
      AgbPokePasoParaPut(&(wk->boxdata->PPPBox[boxno][index]),ID_AGB_monsno, (u8 *)&monsno);
    }
  }

#if 0
  // ɃfobOpɒǉĂ܂(poke_exist_flag0Ȃmonsno0ɂĂ)
  for(boxno = 0; boxno < BOX_NUM; boxno++){
    for(i = 0; i < POKEMON_ICON_MAX; i++){
      if(AgbPokePasoParaGet(&(wk->boxdata->PPPBox[boxno][i]),ID_AGB_poke_exist_flag, NULL) == 0)
	AgbPokePasoParaPut(&(wk->boxdata->PPPBox[boxno][i]),ID_AGB_monsno, (u8 *)&monsno);
    }
  }
#endif

#if 0//def DEBUG_ONLY_FOR_mituhara
  // |PB(ӂ)
  if(sys.cont & PAD_BUTTON_B){
    MATHRandContext16 context;
    u8 name[MONS_NAME_SIZE+1] = { JP_AGB_A__, JP_AGB_B__, JP_AGB_C__, JP_AGB_D__, JP_AGB_E__,
				  JP_AGB_F__, JP_AGB_G__, JP_AGB_H__, JP_AGB_I__, JP_AGB_J__ };
    u8 oyaname[PERSON_NAME_SIZE+1] = { JP_AGB_K__, JP_AGB_L__, JP_AGB_M__, JP_AGB_N__, JP_AGB_O__, JP_AGB_P__, JP_AGB_Q__ };
    
    PokemonPasoParam ppp = wk->boxdata->PPPBox[0][0];
    MATH_InitRand16(&context, 0xabab);

    for(boxno = 0; boxno < BOX_NUM; boxno++){
      for(i = 0; i < POKEMON_ICON_MAX; i++){
	monsno = MATH_Rand16(&context, 386);
	AgbPokePasoParaPut(&ppp, ID_AGB_monsno, (u8 *)&monsno);
#if 0	// COŃJZbgeXg
	monsno = LANG_ENGLISH;
	AgbPokePasoParaPut(&ppp, ID_AGB_country_code, (u8 *)&monsno);
	AgbPokePasoParaPut(&ppp, ID_AGB_nickname, name);
	AgbPokePasoParaPut(&ppp, ID_AGB_oyaname, oyaname);
#endif
	wk->boxdata->PPPBox[boxno][i] = ppp;
      }
    }
  }
#endif
}


//------------------------------------------------------------------
/**
 * @brief	bZ[WZ^O
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static int GetMessageStartPos(REGWIN *rwin, STRBUF *str, int flag)
{
  int len, width;
  if(flag & MSG_FLAG_CENTER){
    len = FontProc_GetPrintStrWidth(FONT_TALK, (const STRBUF *)str, 0);
    width = rwin->width * 8;
    return (width - len) / 2;
  } else {
    return rwin->dx;
  }
}

//------------------------------------------------------------------
/**
 * @brief	bZ[WEBhȄ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void CreateMsgWindow(AGBCARTRIDGE_WORK *wk, REGWIN *rwin, int flag)
{
  STRBUF * msg;
  WORDSET *word;
  MSGDATA_MANAGER *msgman;
  int x, y, msgwait;

  if(rwin->msgwait == 0)	msgwait = MSG_NO_PUT;
  else				msgwait = rwin->msgwait;

  // EBhEo^ĂȂΓo^
  if(rwin->win->ini == NULL){
    GF_BGL_BmpWinAdd(wk->bgl, rwin->win, rwin->screen,
		     rwin->sx, rwin->sy, rwin->width, rwin->height,
		     FONT_PALNO_NORMAL, rwin->base);
  }
  // EBhE
  if(!(flag & MSG_FLAG_NOCLEAR))
    GF_BGL_BmpWinDataFill(rwin->win, rwin->clrcolor);

  // bZ[WΕ\
  if(rwin->msgid != -1){
    // A[JCuWJĕ\
    msgman = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_pokemonpark_dat, HEAPID_AGBCARTRIDGE);
    if(rwin->word)	word = rwin->word;
    else		word = WORDSET_Create(HEAPID_AGBCARTRIDGE);
    msg = MSGDAT_UTIL_AllocExpandString(word, msgman, rwin->msgid, HEAPID_AGBCARTRIDGE);
    x = GetMessageStartPos(rwin, msg, flag);
    rwin->m_id = GF_STR_PrintColor(rwin->win, rwin->font, msg, x, rwin->dy, msgwait, rwin->color, NULL);
    STRBUF_Delete(msg);
    if(rwin->word == NULL)
      WORDSET_Delete(word);
    MSGMAN_Delete(msgman);
    rwin->msgid = -1;
  }
  if(rwin->msgp){
    // 𒼐ڕ\
    msg = STRBUF_Create(64, HEAPID_AGBCARTRIDGE);
    STRBUF_SetStringCodeOrderLength(msg, rwin->msgp, 64);
    x = GetMessageStartPos(rwin, msg, flag);
    rwin->m_id = GF_STR_PrintColor(rwin->win, rwin->font, msg, x, rwin->dy, msgwait, rwin->color, NULL);
    STRBUF_Delete(msg);
    rwin->msgp = NULL;
  }
  if(rwin->msg){
    // STRBUF`\
    x = GetMessageStartPos(rwin, rwin->msg, flag);
    rwin->m_id = GF_STR_PrintColor(rwin->win, rwin->font, rwin->msg, x, rwin->dy, msgwait, rwin->color, NULL);
    rwin->msg = NULL;
  }
  // tOɂĕ`
  if(!(flag & MSG_FLAG_NOREDRAW))
    GF_BGL_BmpWinOn(rwin->win);
  // gꍇ܂
  if(flag & MSG_FLAG_FRAME){
    if(flag & MSG_FLAG_TALKWIN){
      BmpTalkWinWrite(rwin->win, WINDOW_TRANS_ON, AGBPOKEMON_TFRAMECHR, AGBPOKEMON_TFRAMECOL);
    } else {
      BmpMenuWinWrite(rwin->win, WINDOW_TRANS_ON, AGBPOKEMON_FRAMECHR, AGBPOKEMON_FRAMECOL);
    }
  }
}

//------------------------------------------------------------------
/**
 * @brief	LN^Apbg̃}l[W[N
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void CharPlttManagerInit(void)
{
  // LN^}l[W[
  {
    CHAR_MANAGER_MAKE cm = {
      RECORD_CHAR_CONT_NUM,
      RECORD_CHAR_VRAMTRANS_MAIN_SIZE,
      RECORD_CHAR_VRAMTRANS_SUB_SIZE,
      HEAPID_AGBCARTRIDGE,
    };
    InitCharManager(&cm);
  }
  // pbg}l[W[
  InitPlttManager(RECORD_PLTT_CONT_NUM, HEAPID_AGBCARTRIDGE);
      
  // ǂݍ݊Jnʒu
  CharLoadStartAll();
  PlttLoadStartAll();
}


//------------------------------------------------------------------
/**
 * @brief	ZAN^[̏
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void InitCellActor(AGBCARTRIDGE_WORK *wk)
{
  int i;
  // OAM}l[W[̏
  NNS_G2dInitOamManagerModule();
  // LOAM}l[W쐬
  // _pOAM}l[W쐬
  // ō쐬OAM}l[W݂ȂŋL
  REND_OAMInit( 
	       0, 126,		// COAMǗ̈
	       0, 32,		// CʃAtBǗ̈
	       0, 126,		// TuOAMǗ̈
	       0, 32,		// TuʃAtBǗ̈
	       HEAPID_AGBCARTRIDGE);
	
  // ZAN^[
  wk->clactSet = CLACT_U_SetEasyInit( 80, &wk->renddata, HEAPID_AGBCARTRIDGE);
  CLACT_U_SetSubSurfaceMatrix( &wk->renddata, 0, (256*FX32_ONE)/*NAMEIN_SUB_ACTOR_DISTANCE*/ );

  //\[X}l[W[
  for(i=0;i<CLACT_U_RES_MAX;i++){		//\[X}l[W[쐬
    wk->resMan[i] = CLACT_U_ResManagerInit(3, i, HEAPID_AGBCARTRIDGE);
  }

  //---------ʗp-------------------
  //charaǂݍ
  wk->resObjTbl[CLACT_U_CHAR_RES] =
    CLACT_U_ResManagerResAddArcChar(wk->resMan[CLACT_U_CHAR_RES], 
				    ARC_MYSTERY_GRA, NARC_mystery_gba_box_oam_lz_cngr,
				    1, 0, NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_AGBCARTRIDGE);
      
  //palǂݍ
  wk->resObjTbl[CLACT_U_PLTT_RES] =
    CLACT_U_ResManagerResAddArcPltt(wk->resMan[CLACT_U_PLTT_RES],
				    ARC_MYSTERY_GRA, NARC_mystery_gba_box_oam_nclr,
				    0, 0, NNS_G2D_VRAM_TYPE_2DMAIN, 4, HEAPID_AGBCARTRIDGE);

  //cellǂݍ
  wk->resObjTbl[CLACT_U_CELL_RES] =
    CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELL_RES],
					ARC_MYSTERY_GRA, NARC_mystery_gba_box_oam_lz_ccer,
					1, 0, CLACT_U_CELL_RES,HEAPID_AGBCARTRIDGE);

  //֐animǂݍ
  wk->resObjTbl[CLACT_U_CELLANM_RES] =
    CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELLANM_RES],
					ARC_MYSTERY_GRA, NARC_mystery_gba_box_oam_lz_canr,
					1, 0, CLACT_U_CELLANM_RES,HEAPID_AGBCARTRIDGE);
  // Chara]
  CLACT_U_CharManagerSet( wk->resObjTbl[CLACT_U_CHAR_RES] );
  // pbg]
  CLACT_U_PlttManagerSet( wk->resObjTbl[CLACT_U_PLTT_RES] );
  // |PACRppbgCɓǂݍVRAM]
  ArcUtil_PalSet( ARC_POKEICON, PokeIconPalArcIndexGet(), PALTYPE_MAIN_OBJ, POKEICON_PAL_OFFSET*0x20,
		  0, HEAPID_AGBCARTRIDGE);
}


//------------------------------------------------------------------
/**
 * @brief	ZAN^[wb_̍쐬
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void SetCellActor(AGBCARTRIDGE_WORK *wk)
{
  // ZAN^[wb_쐬
  CLACT_U_MakeHeader(&wk->clActHeaderMain, 0, 0, 0, 0, CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
		     0, 0,
		     wk->resMan[CLACT_U_CHAR_RES],
		     wk->resMan[CLACT_U_PLTT_RES],
		     wk->resMan[CLACT_U_CELL_RES],
		     wk->resMan[CLACT_U_CELLANM_RES],
		     NULL,NULL);
  //܂]ĂȂ
  GF_Disp_GX_VisibleControl(  GX_PLANEMASK_OBJ, VISIBLE_ON );	//COBJʂnm
}


//------------------------------------------------------------------
/**
 * @brief	CLACT_ADD̐`쐬
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void AgbPokemon_MakeCLACT(CLACT_ADD *add, AGBCARTRIDGE_WORK *wk, CLACT_HEADER *header, int param)
{
  add->ClActSet		= wk->clactSet;
  add->ClActHeader	= &wk->clActHeaderMain;
  add->mat.z		= 0;
  add->sca.x		= FX32_ONE;
  add->sca.y		= FX32_ONE;
  add->sca.z		= FX32_ONE;
  add->rot		= 0;
  add->pri		= 20;
  add->DrawArea		= param;
  add->heap		= HEAPID_AGBCARTRIDGE;
}


//------------------------------------------------------------------
/**
 * @brief	wԍ̃{bNXindexԖڂ̃|PԂ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static int GetPokeBoxIndex(AGBCARTRIDGE_WORK *wk, int box, int index)
{
  // AGB̍\̐p֐pӂĂ܂
  // DP̍\̂ƍȂ悤AȂ蒍ӂĂ܂
  return AgbPokePasoParaGet(&(wk->boxdata->PPPBox[box][index]), ID_AGB_monsno, NULL);
}

//Add by soga@
//|PACR\ŕKvȃp[^ǉ܂
//------------------------------------------------------------------
/**
 * @brief	wԍ̃{bNXindexԖڂ̃^}StOԂ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static int GetEggFlagBoxIndex(AGBCARTRIDGE_WORK *wk, int box, int index)
{
  // AGB̍\̐p֐pӂĂ܂
  // DP̍\̂ƍȂ悤AȂ蒍ӂĂ܂
  return AgbPokePasoParaGet(&(wk->boxdata->PPPBox[box][index]), ID_AGB_tamago_flag, NULL);
}

//------------------------------------------------------------------
/**
 * @brief	wԍ̃{bNXindexԖڂ̌Ԃ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static int GetPersonalRndBoxIndex(AGBCARTRIDGE_WORK *wk, int box, int index)
{
  // AGB̍\̐p֐pӂĂ܂
  // DP̍\̂ƍȂ悤AȂ蒍ӂĂ܂
  return AgbPokePasoParaGet(&(wk->boxdata->PPPBox[box][index]), ID_AGB_personal_rnd, NULL);
}

//------------------------------------------------------------------
/**
 * @brief	wԍ̃{bNXindexԖڂ̃Qbgo[WԂ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static int GetCassetteVersionBoxIndex(AGBCARTRIDGE_WORK *wk, int box, int index)
{
  // AGB̍\̐p֐pӂĂ܂
  // DP̍\̂ƍȂ悤AȂ蒍ӂĂ܂
  return AgbPokePasoParaGet(&(wk->boxdata->PPPBox[box][index]), ID_AGB_get_cassette, NULL);
}
//Add by soga@܂

//------------------------------------------------------------------
/**
 * @brief	RECT_HIT_TBLo^
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void SetRectHitTable(RECT_HIT_TBL *rect, int x, int y, int sizx, int sizy)
{
  rect->rect.top    = y - sizy / 2;
  rect->rect.left   = x - sizx / 2;
  rect->rect.bottom = y + sizy / 2;
  rect->rect.right  = x + sizx / 2;
}

//------------------------------------------------------------------
/// @brief	q[vTCYŒɂłArcUtrl_CahrDataGet
//------------------------------------------------------------------
static void *ArcUtil_CharDataGet2(u32 fileIdx, u32 dataIdx, NNSG2dCharacterData** charData, u32 heapID)
{
  void* arcData;

  arcData = sys_AllocMemoryLo(heapID, 4096);	/* q[vTCYŒ */
  if(arcData != NULL){
    ArchiveDataLoad(arcData, fileIdx, dataIdx);
    if( NNS_G2dGetUnpackedBGCharacterData( arcData, charData ) == FALSE){
      // sNULL
      sys_FreeMemoryEz( arcData );
      return NULL;
    }
  }
  return arcData;
}
static void ArcUtil_CharDataGet3(u32 dataIdx, NNSG2dCharacterData** charData, void *arcData, ARCHANDLE* handle)
{
  ArchiveDataLoadByHandle(handle, dataIdx, arcData);
  NNS_G2dGetUnpackedBGCharacterData( arcData, charData );
}

//------------------------------------------------------------------
/**
 * @brief	|P̃tHio[擾
 * @param	pokeno			擾|Pio[
 * @param	personal_rnd	擾邽߂ɕKvȌ
 * @param	get_cassette	擾邽߂ɕKvȃQbgJZbgo[W
 *
 * @return	擾tHio[
 */
//------------------------------------------------------------------
static	u8	GetPokeFormNo(int pokeno,u32 personal_rnd,int get_cassette)
{
	u8	form_no;

	form_no=0;

#if 0//def DEBUG_ONLY_FOR_mituhara
	OS_TPrintf("MONSNO_DEOKISISU: %d - %d\n", MONSNO_DEOKISISU, pokeno);
	OS_TPrintf("get_cassette\n", get_cassette);
#endif

	switch(pokeno){
	//Am[̃tH擾
	case MONSNO_ANNOON:
		form_no=(((personal_rnd&0x03000000)>>18)|
				 ((personal_rnd&0x00030000)>>12)|
				 ((personal_rnd&0x00000300)>> 6)|
				  (personal_rnd&0x00000003))%28;
		break;
	case MONSNO_DEOKISISU:
		switch(get_cassette){
		default:
		case VERSION_RUBY:
		case VERSION_SAPPHIRE:
			//r[ETt@CAEm̃o[W̓m[}
			form_no=FORMNO_DEOKISISU_NORMAL;
			break;
		case VERSION_RED:
			//t@CAbh̓A^bN
			form_no=FORMNO_DEOKISISU_ATTACK;
			break;
		case VERSION_GREEN:
			//[tO[̓fBtFX
			form_no=FORMNO_DEOKISISU_DEFENCE;
			break;
		case VERSION_EMERALD:
			//Gh̓Xs[h
			form_no=FORMNO_DEOKISISU_SPEED;
			break;
		}
		break;
	}

	return form_no;
}

//------------------------------------------------------------------
/**
 * @brief	|P̃ACRuq`l֓o^
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void TransPokeIconCharaPal( int pokeno, int tamago_flag, u32 personal_rnd, int get_cassette, int no, CLACT_WORK_PTR icon)
{
  u8 *buf;
  u8 form_no;
  NNSG2dCharacterData *chara;

  // AGB|PDP|P֕ϊ
  pokeno = ChangeAGBPoke2DPPoke(pokeno);

  // |P̃tHio[擾(DSmonsnoŔ)
  form_no = GetPokeFormNo(pokeno,personal_rnd,get_cassette);

  buf = ArcUtil_CharDataGet2( ARC_POKEICON, 
			      PokeIconCgxArcIndexGetByMonsNumber( pokeno, tamago_flag, form_no ), &chara, HEAPID_AGBCARTRIDGE);
  DC_FlushRange(chara->pRawData, POKEICON_TRANS_SIZE);

  // LN^[]
  GX_LoadOBJ(chara->pRawData, (POKEICON_VRAM_OFFSET+no*POKEICON_TRANS_CHARA)*0x20, POKEICON_TRANS_SIZE);
  // pbgݒ
  CLACT_PaletteNoChg( icon,  PokeIconPalNumGet( pokeno, form_no, tamago_flag )+POKEICON_PAL_OFFSET );

  sys_FreeMemoryEz(buf);
}

static void TransPokeIconCharaPal2(int pokeno, int tamago_flag, int form_no,
				   int no, CLACT_WORK_PTR icon, void *buf, ARCHANDLE* handle)
{
  u32 dataidx;
  NNSG2dCharacterData *chara;
  POKEBUF *pbuf = _PokeBufPtr + no;

  if(icon){
#if 0
    // AGB|PDP|P֕ϊ
    pokeno = ChangeAGBPoke2DPPoke(pokeno);
#else

    if(CheckInJusticePokemon(pokeno) == FALSE)
      // AGB|PDP|P֕ϊ
      pokeno = ChangeAGBPoke2DPPoke(pokeno);
    else
      // s|P
      pokeno = 0;
#endif
    // |P̃f[^CfbNXԍ擾
    dataidx = PokeIconCgxArcIndexGetByMonsNumber( pokeno, tamago_flag, form_no );
    // |PLN^obt@ɓ]
    ArcUtil_CharDataGet3(dataidx, &chara, buf, handle);
    MI_CpuCopyFast(chara->pRawData, pbuf->chbuf, POKEICON_TRANS_SIZE);
    pbuf->vadrs = (POKEICON_VRAM_OFFSET+no*POKEICON_TRANS_CHARA)*0x20;
    pbuf->icon = icon;
    pbuf->palno = PokeIconPalNumGet( pokeno, form_no, tamago_flag )+POKEICON_PAL_OFFSET;
  } else {
    pbuf->icon = NULL;
  }
}

static void TransPokeIconFinish(void)
{
  int i;
  POKEBUF *pbuf = _PokeBufPtr;
  for(i = 0; i < POKEMON_ICON_MAX; i++, pbuf++){
    if(pbuf->icon){
      // LN^[]
      DC_FlushRange(pbuf->chbuf, POKEICON_TRANS_SIZE);
      GX_LoadOBJ(pbuf->chbuf, pbuf->vadrs, POKEICON_TRANS_SIZE);
      // pbgݒ
      CLACT_PaletteNoChg(pbuf->icon, pbuf->palno);
    }
  }
}


     
//------------------------------------------------------------------
/**
 * @brief	w{bNX̃|Pʂɕ\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void RedrawPokemonBox(AGBCARTRIDGE_WORK *wk)
{
  int i, monsno, tamago_flag, get_cassette, form_no;
  u32 personal_rnd;
  void *buf;
  ARCHANDLE* handle;

  handle = ArchiveDataHandleOpen( ARC_POKEICON, HEAPID_AGBCARTRIDGE);
  buf = sys_AllocMemoryLo(HEAPID_AGBCARTRIDGE, 4096);

  // |PACR̕\
  for(i = 0; i < POKEMON_ICON_MAX; i++){
    if(AgbPokePasoParaGet(&(wk->boxdata->PPPBox[wk->CurrentBox][i]), ID_AGB_poke_exist_flag, NULL)){
      monsno = GetPokeBoxIndex(wk, wk->CurrentBox, i);
      //add by soga@
      tamago_flag = GetEggFlagBoxIndex(wk, wk->CurrentBox, i);
      personal_rnd = GetPersonalRndBoxIndex(wk, wk->CurrentBox, i);
#if 0
      get_cassette = GetCassetteVersionBoxIndex(wk, wk->CurrentBox, i);
#else
      get_cassette = sys.AgbCasetteVersion;
#endif
      //add by soga@܂

      // |P̃tHio[擾(DSmonsnoŔ)
      form_no = GetPokeFormNo(ChangeAGBPoke2DPPoke(monsno), personal_rnd, get_cassette);
      TransPokeIconCharaPal2(monsno, tamago_flag, form_no, i, wk->icon[i].clact, buf, handle);
      CLACT_SetDrawFlag( wk->icon[i].clact, 1 );
      // ACeACR̓o^
      if(AgbPokePasoParaGet(&(wk->boxdata->PPPBox[wk->CurrentBox][i]), ID_AGB_item, NULL))
	CLACT_SetDrawFlag( wk->icon[i].item, 1 );
      else
	CLACT_SetDrawFlag( wk->icon[i].item, 0 );
    } else {
      TransPokeIconCharaPal2(monsno, tamago_flag, form_no, i, NULL, buf, handle);
      CLACT_SetDrawFlag( wk->icon[i].clact, 0 );
      CLACT_SetDrawFlag( wk->icon[i].item, 0 );
    }
  }
  sys_FreeMemoryEz(buf);
  ArchiveDataHandleClose( handle );

  
  // |PACR̓]֐`
  wk->DrawFunc = TransPokeIconFinish;
  
  // {bNX̃^Cg\
  DrawBoxTitle(wk, wk->CurrentBox);
  // IACR𔽉f
  CheckSelectPokemonIcon(wk);
}


//------------------------------------------------------------------
/**
 * @brief	ʂɃ|PROׂ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void SetPokemonIcon(AGBCARTRIDGE_WORK *wk)
{
  int index, x, y;
  CLACT_ADD add;

  AgbPokemon_MakeCLACT(&add, wk, &wk->clActHeaderMain, NNS_G2D_VRAM_TYPE_2DMAIN );

  index = 0;
  for(y = 0; y < 5; y++){
    for(x = 0; x < 6; x++){

      SetRectHitTable(&wk->iconrect[index],
		      x * POKEMON_WIDTH  + POKEMON_BASEX,
		      y * POKEMON_HEIGHT + POKEMON_BASEY,
		      28, 28);
      add.mat.x = FX32_ONE * (x * POKEMON_WIDTH  + POKEMON_BASEX);
      add.mat.y = FX32_ONE * (y * POKEMON_HEIGHT + POKEMON_BASEY);
      // |P̃ACRo^
      if(wk->icon[index].clact == NULL)
	wk->icon[index].clact = CLACT_Add(&add);
      CLACT_SetAnmFlag(wk->icon[index].clact, 1);
      CLACT_AnmChg( wk->icon[index].clact, 10+index );
      CLACT_BGPriorityChg( wk->icon[index].clact, 1 );
      CLACT_SetDrawFlag( wk->icon[index].clact, 1 );
      CLACT_DrawPriorityChg( wk->icon[index].clact, 100+index);
      // ACẽACRo^
      add.mat.x += FX32_ONE * 6;
      add.mat.y += FX32_ONE * 12;
      if(wk->icon[index].item == NULL)
	wk->icon[index].item = CLACT_Add(&add);
      CLACT_SetAnmFlag(wk->icon[index].item, 1);
      CLACT_AnmChg( wk->icon[index].item, 40);
      CLACT_BGPriorityChg( wk->icon[index].item, 1 );
      CLACT_SetDrawFlag( wk->icon[index].item, 0 );
      CLACT_DrawPriorityChg( wk->icon[index].item, 0+index);

      index++;
      if(index == POKEMON_ICON_MAX)	return;
    }
  }
}


//------------------------------------------------------------------
/**
 * @brief	|PȊÕACRo^
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static CLACT_WORK_PTR SetOamIcon(AGBCARTRIDGE_WORK *wk, int x, int y, int anim, int flag)
{
  CLACT_ADD add;
  CLACT_WORK_PTR p;
  
  AgbPokemon_MakeCLACT(&add, wk, &wk->clActHeaderMain, NNS_G2D_VRAM_TYPE_2DMAIN );
  add.mat.x = FX32_ONE * x;
  add.mat.y = FX32_ONE * y;
  add.pri   = 10;
  p = CLACT_Add(&add);
  CLACT_SetAnmFlag(p, 1);
  CLACT_AnmChg(p, anim);
  CLACT_BGPriorityChg(p, 1);
  CLACT_SetDrawFlag(p, flag);
  return p;
}
static void SetMiscIcon(AGBCARTRIDGE_WORK *wk)
{
  int i;

  SetRectHitTable(&wk->iconrect[ICON_CANCEL], 228, 176, 50, 32);
  wk->cancel[0] = SetOamIcon(wk, 228, 176, 6, 1);	// ߂

  SetRectHitTable(&wk->iconrect[ICON_ARROWR], 176, 176, 32, 32);
  wk->arrowr[0] = SetOamIcon(wk, 176, 176, 3, 1);	// E

  SetRectHitTable(&wk->iconrect[ICON_ARROWL],  24, 176, 32, 32);
  wk->arrowl[0] = SetOamIcon(wk,  24, 176, 0, 1);	// 

  wk->iconrect[ICON_TERMINATE].rect.top = RECT_HIT_END;

  // ACR̓o^
  for(i = 0; i < POKEMON_SELECT_MAX; i++){
    wk->mark[i].icon = SetOamIcon(wk, 36*i, 64, 9, 0);
    wk->mark[i].pokeno = POKEMON_NOSELECT;
    wk->mark[i].boxno = BOX_NUM;
  }
  wk->selected = 0;
}


//------------------------------------------------------------------
/**
 * @brief	|P̃^}S`FbN
 * @param	NONE
 * @return	TRUE: ܂ł@FALSE: ܂Ȃ
 */
//------------------------------------------------------------------
static BOOL CheckPokemonEgg(AGBCARTRIDGE_WORK *wk, int num)
{
  int monsno;
  PokemonPasoParam *ppp = &wk->boxdata->PPPBox[wk->CurrentBox][num];

  if(AgbPokePasoParaGet(ppp, ID_AGB_monsno_egg, NULL) == MONSNO_AGB_TAMAGO)
    return TRUE;
  return FALSE;
}

//------------------------------------------------------------------
/**
 * @brief	Ђł킴Ă邩`FbN
 * @param	NONE
 * @return	TRUE: Ă@FALSE: ĂȂ
 */
//------------------------------------------------------------------
static BOOL CheckPokemonHidenWaza(AGBCARTRIDGE_WORK *wk, int num)
{
  int w, i, waza;

  PokemonPasoParam *ppp = &wk->boxdata->PPPBox[wk->CurrentBox][num];

  for(w = 0; w < 4; w++){
    waza = AgbPokePasoParaGet(ppp, ID_AGB_waza1 + w, NULL);
    for(i = 0; i < sizeof(WazaHidenTable) / sizeof(int); i++){
      if(WazaHidenTable[i] == waza)
	return TRUE;
    }
  }
  return FALSE;
}


//------------------------------------------------------------------
/**
 * @brief	ĂȂACeĂȂ`FbN
 * @param	NONE
 * @return	TRUE: Ă@FALSE: ĂȂ
 */
//------------------------------------------------------------------
#include "agbitemexist.h"
static BOOL CheckPokemonExistItem(AGBCARTRIDGE_WORK *wk, int num)
{
  PokemonPasoParam *ppp = &wk->boxdata->PPPBox[wk->CurrentBox][num];
  int item = AgbPokePasoParaGet(ppp, ID_AGB_item, NULL);
  int i;

  for(i = 0; AgbItemExistCheck[i]; i++){
    if(item == AgbItemExistCheck[i])
      return TRUE;
  }
  return FALSE;
}


//------------------------------------------------------------------
/**
 * @brief	sȃ|P`FbN
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static BOOL CheckPokemonFusei(AGBCARTRIDGE_WORK *wk, int num)
{
  PokemonPasoParam *ppp = &wk->boxdata->PPPBox[wk->CurrentBox][num];
  int monsno = AgbPokePasoParaGet(ppp, ID_AGB_monsno, NULL);
  return CheckInJusticePokemon(monsno);
}


//------------------------------------------------------------------
/**
 * @brief	w肵ACR̉ɌACR𐧌
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
#define SELECT_POKEMON_FULL	0		// łɂς
#define SELECT_POKEMON_SELECT	1		// I
#define SELECT_POKEMON_CANCEL	2		// 
#define SELECT_POKEMON_NOMONS	3		// ɂȂ
#define SELECT_POKEMON_EGG	4		// ͂܂
#define SELECT_POKEMON_WAZA	5		// Ђł킴Ă
#define SELECT_POKEMON_ITEM	6		// ĂȂACeĂ
#define SELECT_POKEMON_FUSEI	7		// sȃ|Pԍ

static int SelectPokemon(AGBCARTRIDGE_WORK *wk, int num)
{
  int i, sel;

  // 󔒂̃`FbN
  if(wk->icon[num].clact && CLACT_GetDrawFlag(wk->icon[num].clact) == FALSE)
    return SELECT_POKEMON_NOMONS;
  
  // łɑIς݂Ȃ̂𒲂ׂ
  for(sel = -1, i = 0; sel == -1 && i < POKEMON_SELECT_MAX; i++){
    if(wk->mark[i].boxno == wk->CurrentBox &&
       wk->mark[i].pokeno == num)
      sel = i;
  }
#if 0	// the N
  return SELECT_POKEMON_ITEM;
#endif
  
  // ܂`FbN
  if(CheckPokemonEgg(wk, num) == TRUE)
    return SELECT_POKEMON_EGG;

  // Ђł킴Ă邩`FbN
  if(CheckPokemonHidenWaza(wk, num) == TRUE)
    return SELECT_POKEMON_WAZA;

  // ĂȂACeĂ邩`FbN
  if(CheckPokemonExistItem(wk, num) == TRUE)
    return SELECT_POKEMON_ITEM;

  // sȃ|P`FbN
  if(CheckPokemonFusei(wk, num) == TRUE)
    return SELECT_POKEMON_FUSEI;
  
  if(sel == -1){
    // IĂȂꍇ
    const VecFx32 *vec;
    VecFx32 nvec;

    // łɂUCIĂ牽Ȃ
    if(wk->selected == POKEMON_SELECT_MAX)
      return SELECT_POKEMON_FULL;

    for(i = 0; i < POKEMON_SELECT_MAX; i++)
      if(wk->mark[i].pokeno == POKEMON_NOSELECT){
	// ̃|PW𓾂(|C^𓾂邾)
	vec = CLACT_GetMatrix(wk->icon[num].clact);
	// ̏ACRփRs[
	CLACT_SetMatrix(wk->mark[i].icon, vec);
	// ̃Rs[̃|C^𓾂āc
	vec = CLACT_GetMatrix(wk->mark[i].icon);
	// W|P̍ɃItZbgړ
	nvec = *vec;
	nvec.x -= FX32_ONE * 8;
	nvec.y -= FX32_ONE * 4;
	CLACT_SetMatrix(wk->mark[i].icon, &nvec);
	// ACR̕\tOON
  	CLACT_SetDrawFlag(wk->mark[i].icon, 1);
	wk->mark[i].pokeno = num;
	wk->mark[i].boxno = wk->CurrentBox;
	wk->selected++;
	return SELECT_POKEMON_SELECT;
      }

  } else {
    // IĂꍇ
    CLACT_SetDrawFlag(wk->mark[sel].icon, 0);
    wk->mark[sel].pokeno = POKEMON_NOSELECT;
    wk->selected--;
    return SELECT_POKEMON_CANCEL;
  }
  return SELECT_POKEMON_FULL;
}


//------------------------------------------------------------------
/**
 * @brief	{bNXȂ΃ACR\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void CheckSelectPokemonIcon(AGBCARTRIDGE_WORK *wk)
{
  int i;
  for(i = 0; i < POKEMON_SELECT_MAX; i++){
    if(wk->mark[i].pokeno != POKEMON_NOSELECT && wk->mark[i].boxno == wk->CurrentBox){
      CLACT_SetDrawFlag(wk->mark[i].icon, 1);
    } else {
      CLACT_SetDrawFlag(wk->mark[i].icon, 0);
    }
  }
}



//------------------------------------------------------------------
/**
 * @brief	{bNX^Cg̕\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void DrawBoxTitle(AGBCARTRIDGE_WORK *wk, int boxnumber)
{
  REGWIN rwin;
  STRCODE title[BOXNAME_MAX+EOM_SIZE];

  memset(&rwin, 0, sizeof(REGWIN));
  rwin.win = &wk->TitleWin;
  rwin.sx = 6;
  rwin.sy = 21;
  rwin.width = 13;
  rwin.height = 2;
  rwin.msgid = -1;
  rwin.dx = 0;
  rwin.dy = 0;
  rwin.screen = GF_BGL_FRAME1_M;
  rwin.font = FONT_TALK;
  rwin.color = AGBPOKEMON_BLACK;
  rwin.base = AGBPOKEMON_TITLEBASE;
  AGBSTR_to_DSSTR(wk->boxdata->BoxName[boxnumber], title, BOXNAME_MAX+EOM_SIZE, agbpoke_getPokemonLanguage());
  rwin.msgp = title;
  CreateMsgWindow(wk, &rwin, MSG_FLAG_CENTER);
}


//------------------------------------------------------------------
/**
 * @brief	|P̃}[N\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void DrawStatusPokeMark(AGBCARTRIDGE_WORK *wk, PokemonPasoParam *ppp)
{
  u16 *scrn = GF_BGL_ScreenAdrsGet(wk->bgl, GF_BGL_FRAME2_M);
  u8 mark;
  int i;

  if(ppp)	mark = AgbPokePasoParaGet(ppp, ID_AGB_mark, NULL);
  else		mark = 0;

  for(i = 0; i < 4; i++){
    if(mark & 1)	scrn[32*3 + 11 + i] = 0x0080 + i;
    else		scrn[32*3 + 11 + i] = 0x0060 + i;
    mark >>= 1;
  }
  GF_BGL_LoadScreenReq(wk->bgl, GF_BGL_FRAME2_M);
}


//------------------------------------------------------------------
/**
 * @brief	EBhE\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
#define SetRWin(msg, x, y)	rwin.msgid = (msg), rwin.dx = (x), rwin.dy = (y);
static void DrawStatusWindow(AGBCARTRIDGE_WORK *wk, PokemonPasoParam *ppp)
{
  int monsno, level;
  int agb_item, dp_item;
  REGWIN rwin;
  MSGDATA_MANAGER* man;
  u8 agb_name[MONS_NAME_SIZE+AGB_EOM_SIZE];
  STRCODE ds_name[MONS_NAME_SIZE+AGB_EOM_SIZE];
  STRBUF *msg;

  memset(&rwin, 0, sizeof(REGWIN));
  rwin.win = &wk->BoxNameWin;
  rwin.sx = 0;
  rwin.sy = 0;
  rwin.width = 32;
  rwin.height = 4;
  rwin.screen = GF_BGL_FRAME1_M;
  rwin.font = FONT_TALK;
  rwin.base = AGBPOKEMON_STATUSBASE;
  rwin.color = AGBPOKEMON_WHITE;
  rwin.msgp = NULL;

  // úv
  SetRWin(msg_pokepark__status_02, 18*8, 0);
  CreateMsgWindow(wk, &rwin, MSG_FLAG_NOREDRAW);
  // uLv.v
  SetRWin(msg_pokepark__status_01, 10*8, 8);
  CreateMsgWindow(wk, &rwin, MSG_FLAG_NOREDRAW|MSG_FLAG_NOCLEAR);
  // }[N
  DrawStatusPokeMark(wk, ppp);

  // PPP̎w肪Ȃ΂ȍ~͏Ȃ
  if(ppp == NULL){
    GF_BGL_BmpWinOn(rwin.win);
    return;
  }

  // jbNl[(̃|PĂ\)
  AgbPokePasoParaGet(ppp, ID_AGB_nickname, agb_name);
  AGBSTR_to_DSSTR(agb_name, ds_name, MONS_NAME_SIZE+AGB_EOM_SIZE, AgbPokePasoParaGet(ppp, ID_AGB_country_code, NULL));
  rwin.msgp = ds_name;
  SetRWin(-1, 1*8, 0);
  CreateMsgWindow(wk, &rwin, MSG_FLAG_NOREDRAW|MSG_FLAG_NOCLEAR);

  // |P
  msg = STRBUF_Create(64, HEAPID_AGBCARTRIDGE);
  man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_monsname_dat, HEAPID_AGBCARTRIDGE);
  // [[[Ń|P̐ʓ`FbNł]]]
  monsno = ChangeAGBPoke2DPPoke(AgbPokePasoParaGet(ppp, ID_AGB_monsno, NULL));
  MSGMAN_GetString(man, monsno, msg);
  rwin.msg = msg;
  SetRWin(-1, 2*8, 2*8);
  CreateMsgWindow(wk, &rwin, MSG_FLAG_NOREDRAW|MSG_FLAG_NOCLEAR);
  MSGMAN_Delete(man);
  STRBUF_Delete(msg);

  // ĂACe
  agb_item = AgbPokePasoParaGet(ppp, ID_AGB_item, NULL);
  if(agb_item){
    dp_item = ITEM_AgbItemCnv(agb_item);
    msg = STRBUF_Create(64, HEAPID_AGBCARTRIDGE);
    GetItemName(msg, dp_item, HEAPID_AGBCARTRIDGE);
    rwin.msg = msg;
    SetRWin(-1, 19*8, 2*8);
    CreateMsgWindow(wk, &rwin, MSG_FLAG_NOREDRAW|MSG_FLAG_NOCLEAR);
    STRBUF_Delete(msg);
  }
  
  // x
  level = AgbPokePasoLevelCalc(ppp);
  msg = STRBUF_Create(10, HEAPID_AGBCARTRIDGE);
  STRBUF_SetNumber(msg, level,  3, NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT);
  rwin.msg = msg;
  SetRWin(-1, 12*8+4, 1*8);
  CreateMsgWindow(wk, &rwin, MSG_FLAG_NOCLEAR);
  STRBUF_Delete(msg);

  // |P{CX炷
  Snd_PMVoicePlay(monsno);
}

//------------------------------------------------------------------
/**
 * @brief	tF[h
 *
 * @param	none
 * @return	none
 */
//------------------------------------------------------------------
static void RequestFade(AGBCARTRIDGE_WORK *wk, int type, int next_seq, int *seq)
{
  WIPE_SYS_Start(WIPE_PATTERN_WMS, type, type, WIPE_FADE_BLACK,WIPE_DEF_DIV,WIPE_DEF_SYNC,HEAPID_AGBCARTRIDGE);
  if(seq)
    SetSeq(AGBCARTRIDGE_SEQ_WAIT_FADE);
  wk->next_seq = next_seq;
}
static void RequestFadeW(AGBCARTRIDGE_WORK *wk, int type, int next_seq, int *seq)
{
  WIPE_SYS_Start(WIPE_PATTERN_WMS, type, type, WIPE_FADE_WHITE,WIPE_DEF_DIV,WIPE_DEF_SYNC,HEAPID_AGBCARTRIDGE);
  if(seq)
    SetSeq(AGBCARTRIDGE_SEQ_WAIT_FADE);
  wk->next_seq = next_seq;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	BG
 * @param	none
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgInit(GF_BGL_INI * ini)
{
  {	/* BG SYSTEM */
    GF_BGL_SYS_HEADER BGsys_data = {
      GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D,
    };
    GF_BGL_InitBG( &BGsys_data );
  }

  {	/* MAIN DISP BG0 */
    GF_BGL_BGCNT_HEADER MBg0_Data = {
      0, 0, 0x800, 0,
      GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
      GX_BG_SCRBASE_0xe000, GX_BG_CHARBASE_0x00000,
      GX_BG_EXTPLTT_01, 0, 0, 0, FALSE
    };
    GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_M, &MBg0_Data, GF_BGL_MODE_TEXT );
    GF_BGL_ScrClear( ini, GF_BGL_FRAME0_M );
  }

  {	/* MAIN DISP BG1 */
    GF_BGL_BGCNT_HEADER MBg1_Data = {
      0, 0, 0x800, 0,
      GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
      GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x08000,
      GX_BG_EXTPLTT_01, 1, 0, 0, FALSE
    };
    GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_M, &MBg1_Data, GF_BGL_MODE_TEXT );
    GF_BGL_ScrClear( ini, GF_BGL_FRAME1_M );
  }

  {	/* MAIN DISP BG2 */
    GF_BGL_BGCNT_HEADER MBg2_Data = {
      0, 0, 0x800, 0,
      GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
      GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x08000,
      GX_BG_EXTPLTT_23, 2, 0, 0, FALSE
    };
    GF_BGL_BGControlSet( ini, GF_BGL_FRAME2_M, &MBg2_Data, GF_BGL_MODE_TEXT );
    GF_BGL_ScrClear( ini, GF_BGL_FRAME2_M );
  }

  {	/* MAIN DISP BG3 */
    GF_BGL_BGCNT_HEADER MBg3_Data = {
      0, 0, 0x800, 0,
      GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
      GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x08000,
      GX_BG_EXTPLTT_23, 3, 0, 0, FALSE
    };
    GF_BGL_BGControlSet( ini, GF_BGL_FRAME3_M, &MBg3_Data, GF_BGL_MODE_TEXT );
    GF_BGL_ScrClear( ini, GF_BGL_FRAME3_M );
  }
}


//------------------------------------------------------------------
/**
 * @brief	XN[쐬
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void CreateAgbCartridgeScreen(AGBCARTRIDGE_WORK *wk)
{
  GF_BGL_DISPVRAM tbl = {
    GX_VRAM_BG_128_A,				// C2DGWBG
    GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg

    GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
    GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg

    GX_VRAM_OBJ_64_E,				// C2DGWOBJ
    GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg

    GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
    GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg

    GX_VRAM_TEX_0_B,				// eNX`C[WXbg
    GX_VRAM_TEXPLTT_01_FG			// eNX`pbgXbg
  };
  GF_Disp_SetBank( &tbl );

  BgInit(wk->bgl);

  // ㉺ʂЂԂ
  sys.disp3DSW = DISP_3D_TO_SUB;
  GF_Disp_DispSelect();
  
  MSG_PrintInit();

  /* bZ[W̃tHgJ[ݒ */
  SystemFontPaletteLoad( PALTYPE_MAIN_BG, FONT_PALNO_NORMAL * 32, HEAPID_AGBCARTRIDGE);

  // Cʂafpbg]
  ArcUtil_PalSet(ARC_MYSTERY_GRA, NARC_mystery_gba_box_bg_nclr, PALTYPE_MAIN_BG, 0, 32*6, HEAPID_AGBCARTRIDGE);
  // CBG1L]
  ArcUtil_BgCharSet(ARC_MYSTERY_GRA, NARC_mystery_gba_box_main_lz_cngr, wk->bgl,
		    GF_BGL_FRAME2_M, 0, 10*16*0x20, 1, HEAPID_AGBCARTRIDGE);

  // {^ptHg̓ǂݍ
  FontProc_LoadFont(FONT_BUTTON, HEAPID_AGBCARTRIDGE);
}
static void CreateAgbCartridgeScreen2(AGBCARTRIDGE_WORK *wk)
{
  // CʃXN[P
  ArcUtil_ScrnSet(ARC_MYSTERY_GRA, NARC_mystery_gba_box_main1_lz_cscr, wk->bgl,
		  GF_BGL_FRAME2_M, 0, 32*24*2, 1, HEAPID_AGBCARTRIDGE);
  // hĂ`faJZbgɂĂaf̃pbgς
  GF_BGL_ScrPalChange(wk->bgl, GF_BGL_FRAME2_M, 0, 0, 32, 24, BgPalTable[wk->cartridge_type]);
  GF_BGL_LoadScreenReq(wk->bgl, GF_BGL_FRAME2_M);
}


//------------------------------------------------------------------
/**
 * @brief	EBhȄ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void InitUpMessageWindow(AGBCARTRIDGE_WORK *wk)
{
  // EBhEgƃpbguq`lփ[h
  SystemFontPaletteLoad( PALTYPE_MAIN_BG, AGBPOKEMON_FRAMECOL * 32, HEAPID_AGBCARTRIDGE);
  MenuWinGraphicSet(wk->bgl, GF_BGL_FRAME0_M, AGBPOKEMON_FRAMECHR, AGBPOKEMON_FRAMECOL, 0, HEAPID_AGBCARTRIDGE);
  TalkWinGraphicSet(wk->bgl, GF_BGL_FRAME0_M, AGBPOKEMON_TFRAMECHR, AGBPOKEMON_TFRAMECOL, wk->win_type, HEAPID_AGBCARTRIDGE);

  memset(&wk->cwin, 0, sizeof(REGWIN));
  wk->cwin.win = &wk->CheckWin;
  wk->cwin.sx = 2;
  wk->cwin.sy = 1;
  wk->cwin.width = 27;
  wk->cwin.height = 4;
  wk->cwin.screen = GF_BGL_FRAME0_M;
  wk->cwin.font = FONT_TALK;
  wk->cwin.base = AGBPOKEMON_CHRBASE + 1;
  wk->cwin.color = AGBPOKEMON_BLACKBLACK;
  wk->cwin.clrcolor = AGBPOKEMON_WHITEBLACK;
  wk->cwin.msgp = NULL;
  wk->cwin.msg = NULL;
}

//------------------------------------------------------------------
/**
 * @brief	mFʂ̃XN[쐬
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void CreateCheckScreen(AGBCARTRIDGE_WORK *wk)
{
  int i, monsno, tamago_flag, get_cassette;
  u32 personal_rnd;
  CLACT_ADD add;

  // ʒ̃IuWFNg͖(o^͎cĂ)
  for(i = 0; i < POKEMON_ICON_MAX; i++){
    CLACT_SetDrawFlag( wk->icon[i].clact, 0 );
    CLACT_SetDrawFlag( wk->icon[i].item, 0 );
  }
  for(i = 0; i < POKEMON_SELECT_MAX; i++)
    CLACT_SetDrawFlag( wk->mark[i].icon, 0 );
  CLACT_SetDrawFlag(wk->cancel[0], 0);
  CLACT_SetDrawFlag(wk->arrowl[0], 0);
  CLACT_SetDrawFlag(wk->arrowr[0], 0);
  
  // VɂŨ̕AN^[o^
  AgbPokemon_MakeCLACT(&add, wk, &wk->clActHeaderMain, NNS_G2D_VRAM_TYPE_2DMAIN );
  for(i = 0; i < POKEMON_SELECT_MAX; i++){
    add.mat.x = FX32_ONE * (i * POKEMON_WIDTH  + POKEMON_BASEX);
    add.mat.y = FX32_ONE * 142;
    wk->check_poke[i] = CLACT_Add(&add);
    
    CLACT_SetAnmFlag(wk->check_poke[i], 1);
    CLACT_AnmChg( wk->check_poke[i], 10+i );
    CLACT_BGPriorityChg( wk->check_poke[i], 1 );
    CLACT_SetDrawFlag( wk->check_poke[i], 1 );
    monsno = GetPokeBoxIndex(wk, wk->mark[i].boxno, wk->mark[i].pokeno);
	//add by soga@
    tamago_flag = GetEggFlagBoxIndex(wk, wk->mark[i].boxno, wk->mark[i].pokeno);
    personal_rnd = GetPersonalRndBoxIndex(wk, wk->mark[i].boxno, wk->mark[i].pokeno);
#if 0
    get_cassette = GetCassetteVersionBoxIndex(wk, wk->mark[i].boxno, wk->mark[i].pokeno);
#else
    get_cassette = sys.AgbCasetteVersion;
#endif
	//add by soga@܂
    TransPokeIconCharaPal(monsno, tamago_flag, personal_rnd, get_cassette, i, wk->check_poke[i]);
  }
  
  // XN[f[^](LN^͓̂̂g)
  ArcUtil_ScrnSet(ARC_MYSTERY_GRA, NARC_mystery_gba_box_main2_lz_cscr, wk->bgl,
		  GF_BGL_FRAME2_M, 0, 32*24*2, 1, HEAPID_AGBCARTRIDGE);
  // hĂ`faJZbgɂĂaf̃pbgς
  GF_BGL_ScrPalChange(wk->bgl, GF_BGL_FRAME2_M, 0, 0, 32, 24, BgPalTable[wk->cartridge_type]);
  GF_BGL_LoadScreenReq(wk->bgl, GF_BGL_FRAME2_M);
  // |PXe[^X\af͏Ă܂
  GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );

  // EBhEgƃpbguq`lփ[h
  SystemFontPaletteLoad( PALTYPE_MAIN_BG, AGBPOKEMON_FRAMECOL * 32, HEAPID_AGBCARTRIDGE);
  MenuWinGraphicSet(wk->bgl, GF_BGL_FRAME0_M, AGBPOKEMON_FRAMECHR, AGBPOKEMON_FRAMECOL, 0, HEAPID_AGBCARTRIDGE);
  TalkWinGraphicSet(wk->bgl, GF_BGL_FRAME0_M, AGBPOKEMON_TFRAMECHR, AGBPOKEMON_TFRAMECOL, wk->win_type, HEAPID_AGBCARTRIDGE);
  
  // bZ[WEBhE쐬
  InitUpMessageWindow(wk);
  wk->cwin.msgid = msg_pokepark_12;	// 񂾁@UЂ́@|P\nā@܂
  CreateMsgWindow(wk, &wk->cwin, MSG_FLAG_FRAME|MSG_FLAG_TALKWIN);
}


//------------------------------------------------------------------
/**
 * @brief	EBhE
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void DeleteWindow(GF_BGL_BMPWIN *win)
{
  if(win->ini){
    BmpTalkWinClear(win, WINDOW_TRANS_ON);
    GF_BGL_BmpWinOff(win);
    GF_BGL_BmpWinDel(win);
  }
}


//------------------------------------------------------------------
/**
 * @brief	Iʂ𕜊
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void ReviveSelectScreen(AGBCARTRIDGE_WORK *wk)
{
  int i;
  // Iʂɖ߂鏈


  // \ĂAN^[𖕏
  for(i = 0; i < POKEMON_SELECT_MAX; i++)
    CLACT_Delete(wk->check_poke[i]);
    
  // |PXe[^X\af𕜊
  GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_ON );

  /* bZ[WEBhE */
  DeleteWindow(&wk->CheckWin);
  // ̑ACR𕜊
  CLACT_SetDrawFlag(wk->cancel[0], 1);
  CLACT_SetDrawFlag(wk->arrowl[0], 1);
  CLACT_SetDrawFlag(wk->arrowr[0], 1);
  for(i = 0; i < POKEMON_SELECT_MAX; i++){
    wk->mark[i].pokeno = POKEMON_NOSELECT;
    wk->mark[i].boxno = BOX_NUM;
  }
  wk->selected = 0;
}


//------------------------------------------------------------------
/**
 * @brief	ׂẴ\[XJďI
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void FinishScreen(AGBCARTRIDGE_WORK *wk)
{
  int i;

  sys_VBlankFuncChange( NULL, NULL );

  // |PACR
  for(i = 0; i < POKEMON_ICON_MAX; i++){
    if(wk->icon[i].clact)
      CLACT_Delete(wk->icon[i].clact);
    if(wk->icon[i].item)
      CLACT_Delete(wk->icon[i].item);
  }
  // I}[N
  for(i = 0; i < POKEMON_SELECT_MAX; i++){
    if(wk->mark[i].icon)
      CLACT_Delete(wk->mark[i].icon);
  }
  // ₶邵Ƃu߂vƂ
  if(wk->cancel[0])	CLACT_Delete(wk->cancel[0]);
  if(wk->arrowl[0])	CLACT_Delete(wk->arrowl[0]);
  if(wk->arrowr[0])	CLACT_Delete(wk->arrowr[0]);
  // EBhE폜
  DeleteWindow(&wk->TitleWin);
  DeleteWindow(&wk->BoxNameWin);
  DeleteWindow(&wk->CheckWin);
  
  //tHg폜
  FontProc_UnloadFont(FONT_BUTTON);

  // L]}l[W[j
  CLACT_U_CharManagerDelete(wk->resObjTbl[CLACT_U_CHAR_RES]);
  // pbg]}l[W[j
  CLACT_U_PlttManagerDelete(wk->resObjTbl[CLACT_U_PLTT_RES]);
  // LEpbgEZEZAj̃\[X}l[W[j
  for(i=0;i<CLACT_U_RES_MAX;i++)
    CLACT_U_ResManagerDelete(wk->resMan[i]);

  // ZAN^[Zbgj
  CLACT_DestSet(wk->clactSet);
  wk->clactSet = NULL;
  //OAM_[j
  REND_OAM_Delete();
  // \[X
  DeleteCharManager();
  DeletePlttManager();
  // ^b`VXe̊J
  TOUCH_SW_FreeWork(wk->TouchSubWindowSys);
  
  // ㉺ʂɖ߂Ă
  sys.disp3DSW = DISP_3D_TO_MAIN;
  GF_Disp_DispSelect();

  GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME0_M);
  GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME1_M);
  GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME2_M);
  GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME3_M);
}


//------------------------------------------------------------------
/**
 * @brief	͂^ACRo^
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void AgbCartridge_ReqYesNoIcon(AGBCARTRIDGE_WORK *wk)
{
  // ͂^I
  TOUCH_SW_PARAM param;
  param.p_bgl		= wk->bgl;
  param.bg_frame	= GF_BGL_FRAME0_M;
  param.char_offs	= 512;
  param.pltt_offs 	= 8;
  param.x		= 25;
  param.y		= 7;
  TOUCH_SW_Init(wk->TouchSubWindowSys, &param );
}


//------------------------------------------------------------------
/**
 * @brief	J[gbW̃[U[mF
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void AgbCartridge_CreateCheckUser(AGBCARTRIDGE_WORK *wk)
{
  REGWIN rwin;
  WORDSET *word;
  STRBUF *strbuf;
  STRCODE dsname[AGB_PERSON_NAME_SIZE+AGB_EOM_SIZE];

  AGBSTR_to_DSSTR(agbpoke_GetTrainerName(), dsname, AGB_PERSON_NAME_SIZE+AGB_EOM_SIZE, agbpoke_getPokemonLanguage());
  word = WORDSET_Create(HEAPID_AGBCARTRIDGE);
  strbuf = STRBUF_Create(AGB_PERSON_NAME_SIZE+AGB_EOM_SIZE, HEAPID_AGBCARTRIDGE);
  STRBUF_SetStringCode(strbuf, dsname);
  WORDSET_RegisterWord(word, 1, strbuf, PM_MALE, TRUE, PM_LANG);

  // [g[i[]́@[JZbg] \n|P@Ă܂H
  InitUpMessageWindow(wk);
  wk->cwin.msgid = UsrCheckMsgTable[wk->cartridge_type];
  wk->cwin.word = word;
  CreateMsgWindow(wk, &wk->cwin, MSG_FLAG_FRAME|MSG_FLAG_TALKWIN);
  STRBUF_Delete(strbuf);
  WORDSET_Delete(word);
  AgbCartridge_ReqYesNoIcon(wk);
}

static void VBlankFunc( void * work )
{
  AGBCARTRIDGE_WORK *wk = (AGBCARTRIDGE_WORK *)work;

  if(wk->DrawFunc){
    wk->DrawFunc();
    wk->DrawFunc = NULL;
  }
  
  // ZAN^[Vram]}l[W[s
  DoVramTransferManager();
  // _LOAM}l[WVram]
  REND_OAMTrans();	
  GF_BGL_VBlankFunc(wk->bgl);
  OS_SetIrqCheckFlag( OS_IE_V_BLANK );
}


//------------------------------------------------------------------
/**
 * @brief	G[`FbN܂֐
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
enum {
  AGBPOKEMON_ERROR_NONE,		// G[Ȃ
  AGBPOKEMON_ERROR_LOAD_FAILD,		// Z[uf[^̃[hɎs
  AGBPOKEMON_ERROR_FEW_24HOUR,		// ܂QSԗĂȂ
  AGBPOKEMON_ERROR_MACADDRESS,		// DS{̂MacAddressςĂ
  AGBPOKEMON_ERROR_MOVE_TIME,		// DS{̂̎vꂽ
  AGBPOKEMON_ERROR_PCBOX_NOPOKE,	// {bNXɂUC݂Ȃ
  AGBPOKEMON_ERROR_POKEPARK_FULL,	// |Pp[Nɑ݂Ă
  AGBPOKEMON_ERROR_IMAKARA_24HOUR,	// QSԘAĂȂ
  AGBPOKEMON_ERROR_MAX
};

#define AGBPOKEMON_24HOUR		(60*60*24)	// 60b~60~24

static int AgbCartridge_CheckAgbError(AGBCARTRIDGE_WORK *wk)
{
  int time;
  u32 AgbTrainerID;
  POKEPARK_DATA *ppark;

#if 0
  return AGBPOKEMON_ERROR_MOVE_TIME;		// DS{̂̎vꂽ
#endif


#if 0//def DEBUG_ONLY_FOR_mituhara
  return AGBPOKEMON_ERROR_NONE;
#endif
  
  ppark = SaveData_GetPokeParkData(wk->sv);
  // VKZ[uȂ΂̃G[`FbN͂΂
  if(POKEPARKDATA_isNewSave(ppark) == FALSE){

    // MACAhX`FbN
    if(POKEPARKDATA_CheckMacAddress(ppark) == FALSE)
      return AGBPOKEMON_ERROR_MACADDRESS;	// MACAhXsv

    // vsύX`FbN
    if(POKEPARKDATA_CheckRTCOffset(ppark) == FALSE)
      return AGBPOKEMON_ERROR_MOVE_TIME;	// v炵

    // AGBJZbg̃g[i[ID𓾂
    AgbTrainerID = agbpoke_GetTrainerID();
    time = POKEPARKDATA_CheckHistoryID(ppark, AgbTrainerID);
    // ܂PxAĂĂȂΘAĂ
    if(time == 0)	time = AGBPOKEMON_24HOUR * 2;
#ifdef DEBUG_ONLY_FOR_mituhara
    OS_TPrintf("OAĂĂ̌oߎ: %2d %2db\n", time / 60, time % 60);
    //    time = AGBPOKEMON_24HOUR * 2;
#endif
    if(time < AGBPOKEMON_24HOUR)
      return AGBPOKEMON_ERROR_FEW_24HOUR;	// ܂24ԌoĂȂ

  }
  // {bNX̃|P`FbN
  {
    PokemonPasoParam *ppp;
    int i, box, max = 0;
    for(box = 0; box < BOX_NUM; box++){
      for(i = 0; i < POKEMON_ICON_MAX; i++){
	ppp = &wk->boxdata->PPPBox[box][i];
	if(AgbPokePasoParaGet(ppp, ID_AGB_poke_exist_flag, NULL))
	  max++;
      }
    }
#ifdef DEBUG_ONLY_FOR_mituhara
    OS_TPrintf("PCBOXɂ|P̐: %d\n", max);
#endif    
    if(max < POKEPARK_MONS_MAX)	// include/savedata/pokepark_data.h
      return AGBPOKEMON_ERROR_PCBOX_NOPOKE; // {bNXɂUCȂ
  }
  
  // |Pp[Np{bNX󂢂Ă邩ׂ
  if(POKEPARKDATA_CountPokemon(ppark))
    return AGBPOKEMON_ERROR_POKEPARK_FULL;
  return AGBPOKEMON_ERROR_NONE;
}


//------------------------------------------------------------------
/**
 * @brief	As\ȃG[\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static BOOL AgbCartridge_DisplayError(AGBCARTRIDGE_WORK *wk, int errno)
{
  if(wk->agberror){
    InitUpMessageWindow(wk);
    MsgPrintTouchPanelFlagSet(MSG_TP_ON);
    wk->cwin.msgid = ErrorMsgTable[errno];
    wk->cwin.msgwait = 1;
    CreateMsgWindow(wk, &wk->cwin, MSG_FLAG_FRAME|MSG_FLAG_TALKWIN);
    wk->agberror = 0;
  } else {
    if(GF_MSG_PrintEndCheck(wk->cwin.m_id) == 0){
      MsgPrintTouchPanelFlagSet(MSG_TP_OFF);
      return TRUE;
    }
  }
  return FALSE;
}


//------------------------------------------------------------------
/**
 * @brief	IKvȃG[\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static BOOL AgbCartridge_DispYesNoError(AGBCARTRIDGE_WORK *wk, int errno)
{
  if(wk->agberror){
    InitUpMessageWindow(wk);
    MsgPrintTouchPanelFlagSet(MSG_TP_ON);
    wk->cwin.msgid = ErrorMsgTable[errno];
    wk->cwin.msgwait = 1;
    CreateMsgWindow(wk, &wk->cwin, MSG_FLAG_FRAME|MSG_FLAG_TALKWIN);
    wk->agberror = 0;
  } else {
    if(GF_MSG_PrintEndCheck(wk->cwin.m_id) == 0){
       AgbCartridge_ReqYesNoIcon(wk);
       MsgPrintTouchPanelFlagSet(MSG_TP_OFF);
       return TRUE;
    }
  }
  return FALSE;
}


//------------------------------------------------------------------
/**
 * @brief	XN[KvȃbZ[W̕\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static BOOL AgbCartridge_DisplayMessage(AGBCARTRIDGE_WORK *wk, int frame)
{
  if(wk->msg_flag != -1){
    InitUpMessageWindow(wk);
    MsgPrintTouchPanelFlagSet(MSG_TP_ON);
    wk->cwin.msgid = wk->msg_flag;
    wk->cwin.msgwait = frame;
    CreateMsgWindow(wk, &wk->cwin, MSG_FLAG_FRAME|MSG_FLAG_TALKWIN);
    wk->msg_flag = -1;
    Snd_SePlay(SEQ_SE_DP_SELECT);
  } else {
    if(frame){
      if(GF_MSG_PrintEndCheck(wk->cwin.m_id) == 0){
	MsgPrintTouchPanelFlagSet(MSG_TP_OFF);
	return TRUE;
      }
    } else {
      if(sys.tp_trg || sys.trg){
	MsgPrintTouchPanelFlagSet(MSG_TP_OFF);
	Snd_SePlay(SEQ_SE_DP_SELECT);
	return TRUE;
      }
    }
  }
  return FALSE;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	`faJZbgĂF
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT AgbCartridgeProc_Init(PROC * proc, int * seq)
{
  AGBCARTRIDGE_WORK *wk;

  sys_CreateHeap( HEAPID_BASE_APP, HEAPID_AGBCARTRIDGE, 0x28000);
  sys_PrintHeapFreeSize(HEAPID_AGBCARTRIDGE);
  wk = PROC_AllocWork(proc, sizeof(AGBCARTRIDGE_WORK), HEAPID_AGBCARTRIDGE);
  /* sǂ|̂Ń[N̓[NA */
  memset(wk, 0, sizeof(AGBCARTRIDGE_WORK));

  /* eϐ̏ */
  wk->bgl = GF_BGL_BglIniAlloc(HEAPID_AGBCARTRIDGE);

  /* ʃEChEVXe */
  wk->TouchSubWindowSys = TOUCH_SW_AllocWork(HEAPID_AGBCARTRIDGE);

  /* ʂ̏ݒ */
  WIPE_SetBrightness( WIPE_DISP_MAIN, WIPE_FADE_BLACK );
  WIPE_SetBrightness( WIPE_DISP_SUB, WIPE_FADE_BLACK );

  /* ϐ */
  wk->sv = ((MAINWORK *)PROC_GetParentWork(proc))->savedata;
  wk->mst = SaveData_GetMyStatus(wk->sv);
  wk->cfg = SaveData_GetConfig(wk->sv);
  wk->win_type = CONFIG_GetWindowType(wk->cfg);

  /* TEhf[^[h */
  Snd_DataSetByScene( SND_SCENE_AGB, SEQ_PRESENT, 1 );

  /* Z[upTick */
  if(OS_IsTickAvailable() == FALSE)
    OS_InitTick();
  
  /* AGBJ[gbW̔oON */
  MysteryLib_SetAgbCartridgeIntr2();

  _PokeBufPtr = wk->pokebuf;
  
  return PROC_RES_FINISH;
}



// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/14
// RTCJ[gbWɑΉ
// iAFTERMASTER_070123_GBACARTRIDGE_BUF_FIX ^̏ꍇ̂݁j
#if AFTERMASTER_070123_GBACARTRIDGE_BUF_FIX
extern int AGBCartridge_TriggerFlag;
#endif
// ----------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------
/**
 * @brief	`faJZbgĂFC
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT AgbCartridgeProc_Main(PROC * proc, int * seq)
{
  int selno, seltype, ret;
  AGBCARTRIDGE_WORK *wk = PROC_GetWork(proc);

  // AGBJ[gbWꍇ͏~
  CTRDG_IsExisting();
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/01
// AGBJ[gbWꂽƂ́Au[XN[ɑJڂ悤ɕύX
// i#ifےeXgɂȂȂ悤ɏĔfj
// localize_spec_mark(LANG_ALL) imatake 2007/02/14
// RTCJ[gbWɑΉ
// iAFTERMASTER_070123_GBACARTRIDGE_BUF_FIX ^̏ꍇ̂݁j
#if AFTERMASTER_070123_GBACARTRIDGE_BUF_FIX
  if(CTRDG_IsPulledOut() == TRUE || AGBCartridge_TriggerFlag)
    GbaCartridgeErrorWarningCall(HEAPID_AGBCARTRIDGE);
#else
  if(CTRDG_IsPulledOut() == TRUE)
    CTRDG_TerminateForPulledOut();
#endif
// ----------------------------------------------------------------------------
  
  wk->jiffy++;
  
  switch(*seq){

  case AGBCARTRIDGE_SEQ_INIT_CARTRIDGE:
    // J[gbW̏
#if 0//def DEBUG_ONLY_FOR_mituhara
    OS_Printf("|PJZbg̃Z[uf[^̑傫 = %d\n", AGBPOKE_BUFFERSIZE);
#endif
    agbpoke_preinit();
    wk->cartridge_status = agbpoke_init(wk->buffer);
    if(wk->cartridge_status == AGBPOKE_ERROR_OK){
      wk->load_status = agbpoke_LoadDATA();
      if(wk->load_status == AGBPOKE_ERROR_OK){
	wk->boxdata = agbpoke_getPCdata();
	wk->CurrentBox = wk->boxdata->CurrentBoxNo;
      } else {
	// Ⴆ΃{bNXɂPCȂƂA
	// ĂȂƂ
#if 0//def DEBUG_ONLY_FOR_mituhara
	OS_Printf("AGBJZbgf[^̃[hɎs܂: %d\n", wk->load_status);
#endif
	wk->agberror = AGBPOKEMON_ERROR_LOAD_FAILD;
      }
    } else {
      // AGBJZbgꂽꍇɂ́A~邽߁A
      // ܂ŏȂ͂łB
    }
    // JZbg̃^Cvݒ
    AgbCartridge_SetCartridgeType(wk);
    SetSeq(AGBCARTRIDGE_SEQ_PREINIT_SCREEN);
    break;

  case AGBCARTRIDGE_SEQ_PREINIT_SCREEN:
    // ʍ쐬
    CreateAgbCartridgeScreen(wk);

    CharPlttManagerInit();
    InitCellActor(wk);
    SetCellActor(wk);
    SetMiscIcon(wk);
    sys_VBlankFuncChange( VBlankFunc, wk );
    GF_Disp_GX_VisibleControl(  GX_PLANEMASK_OBJ, VISIBLE_OFF );	//COBJOFF

    if(wk->agberror == AGBPOKEMON_ERROR_LOAD_FAILD)
      RequestFade(wk, WIPE_TYPE_FADEIN, AGBCARTRIDGE_SEQ_ERROR_SCREEN, seq);
    else
      SetSeq(AGBCARTRIDGE_SEQ_CHECK_USER);
    break;

  case AGBCARTRIDGE_SEQ_CHECK_USER:
    // J[gbW̃[U[mF
    AgbCartridge_CreateCheckUser(wk);
    RequestFade(wk, WIPE_TYPE_FADEIN, AGBCARTRIDGE_SEQ_CHECK_USER_YESNO, seq);
    break;

  case AGBCARTRIDGE_SEQ_CHECK_USER_YESNO:
    // mFʏ
    selno = TOUCH_SW_Main( wk->TouchSubWindowSys );
    switch(selno){
    case TOUCH_SW_RET_YES:		// ͂
      TOUCH_SW_Reset( wk->TouchSubWindowSys );
      wk->msg_flag = CHECK_FINAL_MSG;
      SetSeq(AGBCARTRIDGE_SEQ_CHECK_FINAL);
      break;
    case TOUCH_SW_RET_NO:		// 
      TOUCH_SW_Reset( wk->TouchSubWindowSys );
      RequestFadeW(wk, WIPE_TYPE_FADEOUT, AGBCARTRIDGE_SEQ_FINISH, seq);
      break;
    }
    break;

  case AGBCARTRIDGE_SEQ_CHECK_FINAL:
    // ŏImF
    // "Ă@|Ṕ@fa`ɂ\nǂƂ@ł܂
    // |P@_Ch\nĂ܂H"
    if(AgbCartridge_DisplayMessage(wk, 1)){
      // ͂^I̓o^
      AgbCartridge_ReqYesNoIcon(wk);
      SetSeq(AGBCARTRIDGE_SEQ_CHECK_FINAL_YESNO);
    }
    break;

  case AGBCARTRIDGE_SEQ_CHECK_FINAL_YESNO:
    // mFʏ
    selno = TOUCH_SW_Main( wk->TouchSubWindowSys );
    switch(selno){
    case TOUCH_SW_RET_YES:		// ͂
      TOUCH_SW_Reset( wk->TouchSubWindowSys );
      // G[`FbN܂̂
      wk->agberror = AgbCartridge_CheckAgbError(wk);
      if(wk->agberror){
	if(wk->agberror == AGBPOKEMON_ERROR_MACADDRESS || wk->agberror == AGBPOKEMON_ERROR_MOVE_TIME)
	  SetSeq(AGBCARTRIDGE_SEQ_ERROR_YESNO_SCREEN);
	else
	  SetSeq(AGBCARTRIDGE_SEQ_ERROR_SCREEN);
      } else {
	wk->msg_flag = msg_pokepark_08;
	SetSeq(AGBCARTRIDGE_SEQ_DISP_MESSAGE);
      //	RequestFade(wk, WIPE_TYPE_FADEOUT, AGBCARTRIDGE_SEQ_INIT_SCREEN, seq);
      }
      break;
    case TOUCH_SW_RET_NO:		// 
      TOUCH_SW_Reset( wk->TouchSubWindowSys );
      RequestFadeW(wk, WIPE_TYPE_FADEOUT, AGBCARTRIDGE_SEQ_FINISH, seq);
      break;
    }
    break;

  case AGBCARTRIDGE_SEQ_DISP_MESSAGE:
    // "Ă@|P\nUЂ@Ł@"
    if(AgbCartridge_DisplayMessage(wk, 1)){
      // ͂^I̓o^
      //      AgbCartridge_ReqYesNoIcon(wk);
      SetSeq(AGBCARTRIDGE_SEQ_DISP_MESSAGE_YESNO);
    }
    break;

  case AGBCARTRIDGE_SEQ_DISP_MESSAGE_YESNO:
    // mF̃^bv܂̓L[͂҂
    if(sys.tp_trg || sys.trg)
      RequestFade(wk, WIPE_TYPE_FADEOUT, AGBCARTRIDGE_SEQ_INIT_SCREEN, seq);
    break;
    
  case AGBCARTRIDGE_SEQ_ERROR_YESNO_SCREEN:
    // IKvȃG[\[]  AGBCARTRIDGE_SEQ_ERROR_SCREEN
    // MACAhXԂ炵ꍇ̃Z[u
    if(AgbCartridge_DispYesNoError(wk, wk->agberror))
      SetSeq(AGBCARTRIDGE_SEQ_ERROR_YESNO_SCREEN2);
    break;

  case AGBCARTRIDGE_SEQ_ERROR_YESNO_SCREEN2:
    selno = TOUCH_SW_Main( wk->TouchSubWindowSys );
    switch(selno){
    case TOUCH_SW_RET_YES:		// ͂
      TOUCH_SW_Reset( wk->TouchSubWindowSys );

      wk->cwin.msgwait = 0;
      wk->cwin.msgid = msg_pokepark_42;	// ւ񂱂イ@ł\nł񂰂@ȂŁ@
      CreateMsgWindow(wk, &wk->cwin, 0);


      wk->save_work.time_icon = TimeWaitIconAdd(&wk->CheckWin, AGBPOKEMON_TFRAMECHR);
      SetSeq(AGBCARTRIDGE_SEQ_ERROR_YESNO_SCREEN3);
      break;
    case TOUCH_SW_RET_NO:		// 
      TOUCH_SW_Reset( wk->TouchSubWindowSys );
      RequestFadeW(wk, WIPE_TYPE_FADEOUT, AGBCARTRIDGE_SEQ_FINISH, seq);
      break;
    }
    break;

  case AGBCARTRIDGE_SEQ_ERROR_YESNO_SCREEN3:
    // ł̓Z[uI܂Ŗ߂ĂȂ
    SaveDsCard(wk);
    TimeWaitIconDel(wk->save_work.time_icon);
    wk->agberror = AGBPOKEMON_ERROR_IMAKARA_24HOUR;
    SetSeq(AGBCARTRIDGE_SEQ_ERROR_SCREEN);
    break;

  case AGBCARTRIDGE_SEQ_ERROR_SCREEN:
    // G[\^Cg֖߂
    if(AgbCartridge_DisplayError(wk, wk->agberror))
      SetSeq(AGBCARTRIDGE_SEQ_SAVE_END);
    break;

    
  case AGBCARTRIDGE_SEQ_INIT_SCREEN:
    // ʍ쐬@̂Q
    DeleteWindow(&wk->CheckWin);
    CreateAgbCartridgeScreen2(wk);
    SetPokemonIcon(wk);
    RedrawPokemonBox(wk);

    // VBlank֐Zbg
    sys_VBlankFuncChange( VBlankFunc, wk );
    GF_Disp_GX_VisibleControl(  GX_PLANEMASK_OBJ, VISIBLE_ON );	//COBJON
    // uLvvƁúv\
    DrawStatusWindow(wk, NULL);
    RequestFade(wk, WIPE_TYPE_FADEIN, AGBCARTRIDGE_SEQ_MAIN, seq);

    sys_PrintHeapFreeSize(HEAPID_AGBCARTRIDGE);
    
    break;

  case AGBCARTRIDGE_SEQ_MAIN:
    // IC
    selno = GF_TP_RectHitTrg((const RECT_HIT_TBL *)wk->iconrect);
    if(selno != RECT_HIT_NONE){
      if(selno < POKEMON_ICON_MAX){
	seltype = SelectPokemon(wk, selno);
	if(seltype == SELECT_POKEMON_SELECT){
	  // |PI܂
	  DrawStatusWindow(wk, &(wk->boxdata->PPPBox[wk->CurrentBox][selno]));
	  // I|PMAXɒBĂmFʂ
	  if(wk->selected == POKEMON_SELECT_MAX){
	    wk->wait_seq = 45;	// 45 * 290framȇ҂
	    SetSeq(AGBCARTRIDGE_SEQ_WAIT_CHECK_SCREEN);
	  }
	} else if(seltype == SELECT_POKEMON_CANCEL){
	  // I܂
	  DrawStatusWindow(wk, NULL);		// EBhÉuv
	} else if(seltype == SELECT_POKEMON_EGG){
	  // I|P܂ł
	  wk->msg_flag = msg_pokepark_10;
	  SetSeq(AGBCARTRIDGE_SEQ_SELECT_WARNING);
	} else if(seltype == SELECT_POKEMON_WAZA){
	  // I|PЂł킴Ă
	  wk->msg_flag = msg_pokepark_11;
	  SetSeq(AGBCARTRIDGE_SEQ_SELECT_WARNING);
	} else if(seltype == SELECT_POKEMON_ITEM){
	  // I|PĂȂACeĂ
	  wk->msg_flag = msg_pokepark_40;
	  SetSeq(AGBCARTRIDGE_SEQ_SELECT_WARNING);
	} else if(seltype == SELECT_POKEMON_FUSEI){
	  // sȔԍ̃|P
	  wk->msg_flag = msg_pokepark_40;
	  SetSeq(AGBCARTRIDGE_SEQ_SELECT_WARNING);
	}
      } else {
	switch(selno){
	case ICON_ARROWL:
	  if(wk->CurrentBox == 0)
	    wk->CurrentBox = BOX_NUM - 1;
	  else
	    wk->CurrentBox--;
	  RedrawPokemonBox(wk);
	  Snd_SePlay(SEQ_SE_DP_SELECT);
	  break;
	case ICON_ARROWR:
	  if(++wk->CurrentBox == BOX_NUM)
	    wk->CurrentBox = 0;
	  RedrawPokemonBox(wk);
	  Snd_SePlay(SEQ_SE_DP_SELECT);
	  break;
	case ICON_CANCEL:
	  RequestFadeW(wk, WIPE_TYPE_FADEOUT, AGBCARTRIDGE_SEQ_FINISH, seq);
	  Snd_SePlay(SEQ_SE_DP_SELECT);
	  break;
	}
      }
    }
    break;

  case AGBCARTRIDGE_SEQ_SELECT_WARNING:
    // x\
    if(AgbCartridge_DisplayMessage(wk, 0)){
      DeleteWindow(&wk->CheckWin);
      SetSeq(AGBCARTRIDGE_SEQ_MAIN);
    }
    break;


  case AGBCARTRIDGE_SEQ_WAIT_CHECK_SCREEN:
    // mFʂ֍sÖůԂ
    if(--wk->wait_seq == 0){
      RequestFade(wk, WIPE_TYPE_FADEOUT, AGBCARTRIDGE_SEQ_CREATE_CHECK_SCREEN, seq);
    }
    break;
    
  case AGBCARTRIDGE_SEQ_CREATE_CHECK_SCREEN:
    // mFʂ̍쐬
    CreateCheckScreen(wk);
    RequestFade(wk, WIPE_TYPE_FADEIN, AGBCARTRIDGE_SEQ_CREATE_CHECK_TOUCH1, seq);
    // ͂^I
    AgbCartridge_ReqYesNoIcon(wk);
    break;

  case AGBCARTRIDGE_SEQ_CREATE_CHECK_TOUCH1:
    // u񂾂UЂ́@ۂ@Ă܂vmFʏ
    selno = TOUCH_SW_Main( wk->TouchSubWindowSys );
    switch(selno){
    case TOUCH_SW_RET_YES:		// ͂
      TOUCH_SW_Reset( wk->TouchSubWindowSys );
      SetSeq(AGBCARTRIDGE_SEQ_CREATE_CHECK_TOUCH);
      break;
    case TOUCH_SW_RET_NO:		// 
      TOUCH_SW_Reset( wk->TouchSubWindowSys );
      RequestFade(wk, WIPE_TYPE_FADEOUT, AGBCARTRIDGE_SEQ_RETURN_SELECT, seq);
      break;
    }
    break;
    
  case AGBCARTRIDGE_SEQ_CREATE_CHECK_TOUCH:
    // mF^bv҂
    //    if(sys.tp_trg)
    {
      REGWIN rwin;
      // bZ[WEBhE̓eύX
      wk->cwin.msgid = msg_pokepark_13;	// r[@Ɂ@ǂƂ\nł܂񂪁@낵@łH
      CreateMsgWindow(wk, &wk->cwin, 0);
      // ͂^I
      AgbCartridge_ReqYesNoIcon(wk);
      Snd_SePlay(SEQ_SE_DP_SELECT);
      SetSeq(AGBCARTRIDGE_SEQ_CREATE_CHECK_MAIN);
    }
    break;

  case AGBCARTRIDGE_SEQ_CREATE_CHECK_MAIN:
    // mFʏ
    selno = TOUCH_SW_Main( wk->TouchSubWindowSys );
    switch(selno){
    case TOUCH_SW_RET_YES:		// ͂
      // ~~@Ɓ@\n|P|[g@Ă܂
      wk->cwin.msgid = SaveMsgTable[wk->cartridge_type];
      CreateMsgWindow(wk, &wk->cwin, 0);
      //      wk->wait_seq = 60;
      TOUCH_SW_Reset( wk->TouchSubWindowSys );
      wk->save_work.save_seq = SAVE_SEQ_INIT;
      wk->save_work.time_icon = TimeWaitIconAdd(&wk->CheckWin, AGBPOKEMON_TFRAMECHR);

      SetSeq(AGBCARTRIDGE_SEQ_SAVE);
      sys_SoftResetNG(SOFTRESET_TYPE_SAVELOAD);
      break;
    case TOUCH_SW_RET_NO:		// 
      TOUCH_SW_Reset( wk->TouchSubWindowSys );
      RequestFade(wk, WIPE_TYPE_FADEOUT, AGBCARTRIDGE_SEQ_RETURN_SELECT, seq);
      break;
    }
    break;
    
  case AGBCARTRIDGE_SEQ_RETURN_SELECT:
    // Iʂ𕜊
    ReviveSelectScreen(wk);
    SetSeq(AGBCARTRIDGE_SEQ_INIT_SCREEN);
    break;

  case AGBCARTRIDGE_SEQ_SAVE:
    // 񓯊Z[u
    ret = SaveSequence(wk);

    if(ret != SAVE_STATUS_WRITING){

      TimeWaitIconDel(wk->save_work.time_icon);

      Snd_SePlay(SEQ_SE_DP_SAVE);

#if 0//def DEBUG_ONLY_FOR_mituhara
      OS_TPrintf("Z[u: %d\n", ret);
#endif
      if(ret == SAVE_STATUS_WRITE_SUCCESS)
	wk->cwin.msgid = SAVE_SUCCESS_MSG;	// UЂ@Ԃ@[]@\nĂ@Ƃ@ł܂
      else
	wk->cwin.msgid = msg_pokepark_38;	// |P|[g@̂Ɂ@ς@܂

      CreateMsgWindow(wk, &wk->cwin, 0);
      SetSeq(AGBCARTRIDGE_SEQ_SAVE_END);
      sys_SoftResetOK(SOFTRESET_TYPE_SAVELOAD);
    }
    break;

  case AGBCARTRIDGE_SEQ_SAVE_END:
    // ----------------------------------------------------------------------------
    // localize_spec_mark(LANG_ALL) imatake 2007/01/16
    // ^bvłȂAL[͂łI悤
    if(sys.tp_trg || sys.trg) {
    // ----------------------------------------------------------------------------
      RequestFadeW(wk, WIPE_TYPE_FADEOUT, AGBCARTRIDGE_SEQ_FINISH, seq);
      Snd_SePlay(SEQ_SE_DP_SELECT);
    }
    break;
    
    
  case AGBCARTRIDGE_SEQ_WAIT_FADE:
    // tF[hI܂ő҂Ď̃V[PX
    if(WIPE_SYS_EndCheck()){
      *seq = wk->next_seq;
    }
    break;

  case AGBCARTRIDGE_SEQ_FINISH:
    FinishScreen(wk);
    return PROC_RES_FINISH;
    break;
  }

  // ACR\邽߂ɕKvȋ쓮
  if(wk->clactSet!=NULL)
    CLACT_Draw( wk->clactSet );

  return PROC_RES_CONTINUE;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	`faJZbgĂFI
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT AgbCartridgeProc_End(PROC * proc, int * seq)
{
  FS_EXTERN_OVERLAY( title );
  AGBCARTRIDGE_WORK *wk = PROC_GetWork(proc);

  sys_FreeMemoryEz(wk->bgl);
  Main_SetNextProc( FS_OVERLAY_ID(title), &TitleProcData);
  PROC_FreeWork(proc);
  sys_DeleteHeap(HEAPID_AGBCARTRIDGE);
  /* AGBJ[gbW̔oOFF */
  MysteryLib_SetAgbCartridgeIntr(FALSE);

  return PROC_RES_FINISH;
}

const PROC_DATA AgbCartridgeProcData = {
  AgbCartridgeProc_Init,
  AgbCartridgeProc_Main,
  AgbCartridgeProc_End,
  NO_OVERLAY_ID,
};

/*  */
