//============================================================================================
/**
 * @file	comm_mystery_figt.c
 * @bfief	ӂȁ@
 * @author	Satoshi Mitsuhara
 * @date	06.05.08
 *
 */
//============================================================================================
#include "system/main.h"
#include "system/fontproc.h"
#include "system/window.h"
#include "system/arc_util.h"
#include "system/msgdata_util.h"
#include "system/snd_tool.h"
#include "system/pm_rtc.h"

#include "demo/title.h"
#include "mystery.naix"
#include "msgdata/msg.naix"
#include "msgdata/msg_mystery.h"
#include "msgdata/msg_wifi_system.h"

#include "communication/communication.h"
#include "communication/comm_state.h"
#include "../communication/wh.h"

#include "savedata/fushigi_data.h"
#include "savedata/system_data.h"
#include "savedata/config.h"

#include "poketool/poke_tool.h"
#include "poketool/pokeparty.h"

#include "comm_mystery_func.h"
#include "comm_mystery_state.h"
#include "comm_mystery_gift.h"
#include "agbdownload.h"
#include "beacondownload.h"

#include "mysterylib.h"

// ẽeXg
//#define PARENT_TEST


extern void STRBUF_GetStringCode( const STRBUF* strbuf, STRCODE* ary, u32 arysize );
extern void STRBUF_SetStringCodeOrderLength( STRBUF* strbuf, const STRCODE* str, u32 len );
extern FUSHIGI_DATA * SaveData_GetFushigiData(SAVEDATA * sv);
extern void MysteryCard_DisplayCardOnly(GF_BGL_INI *bgl, void *, int heapid);

// Qlt@C
//  src/field/comm_command_field.h       ʐMR}h̃R}hx
//  src/field/comm_command_field.c       ʐMR}h̃R[obN֐e[u
//  src/field/comm_field_state.c         ʐMɊ֘A闬̐  
//  src/field/comm_direct_counter.c      |PZ^[QF̃JE^[ŕKvȃj[Ƃ̗

//============================================================================================
//	萔`
//============================================================================================

enum {
  MYSTERYGIFT_SEQ_INIT = 0,		/* ʊ֌W̏ */
  MYSTERYGIFT_SEQ_CREATE_SCREEN,	/* ʍ쐬 */
  MYSTERYGIFT_SEQ_WAIT_FADE,		/* tF[h҂ */
  MYSTERYGIFT_SEQ_MAIN,			/* MAIN PROC */
  
  MYSTERYGIFT_SEQ_RECV,			/* û@Ƃv */
  MYSTERYGIFT_SEQ_DIRECT_YESNO,		/* _CNgőu͂^v */

  MYSTERYGIFT_SEQ_RECV_BEACON,		/* r[R󂯎 */

  /* DSe@̃_E[hV[PX */
  MYSTERYGIFT_SEQ_START_CHILD,		/* q@ƂĒʐMJn */
  MYSTERYGIFT_SEQ_RECV_YESNO_CHILD,	/* q@Ff[^󂯎邩H */
  MYSTERYGIFT_SEQ_REQEST_CHILD,		/* q@Feɑ΂Đڑvo^e҂ */
  MYSTERYGIFT_SEQ_RECV_WAIT_CHILD1,	/* q@Fe@f[^M܂ő҂ */
  MYSTERYGIFT_SEQ_RECV_WAIT_CHILD2,	/* q@FMꂽf[^̈Í */
  MYSTERYGIFT_SEQ_RECV_WAIT_CHILD3,	/* q@FZ[uI҂ */
  MYSTERYGIFT_SEQ_RECV_WAIT_CHILD30,
  MYSTERYGIFT_SEQ_RECV_WAIT_CHILD31,
  MYSTERYGIFT_SEQ_RECV_WAIT_CHILD4,
  MYSTERYGIFT_SEQ_SEND_RECV_REFUSAL,	/* q@F\݂ۂꂽꍇ */
  MYSTERYGIFT_SEQ_SEND_RECV_CANCEL_INIT,/* q@FLZ */
  MYSTERYGIFT_SEQ_SEND_RECV_CANCEL,	/* q@FLZ */

  /* AGBJZbg̃_E[hV[PX */
  MYSTERYGIFT_SEQ_AGB_START_CHILD,	/* q@ƂĒʐMJn */
  MYSTERYGIFT_SEQ_AGB_RECV_YESNO_CHILD,	/* q@Ff[^󂯎邩H */
  MYSTERYGIFT_SEQ_AGB_RECV_CHECK_CHILD,	/* q@F󂯎邩`FbN */
  MYSTERYGIFT_SEQ_AGB_REQEST_CHILD,	/* q@Feɑ΂Đڑvo^e҂ */
  MYSTERYGIFT_SEQ_AGB_RECV_WAIT_CHILD,	/* q@Fe@f[^M܂ő҂ */
  MYSTERYGIFT_SEQ_AGB_RECV_WAIT_CHILD2,	/* q@FZ[uI҂ */
  MYSTERYGIFT_SEQ_AGB_SEND_RECV_FLAG_CHILD,/* q@Ff[^󂯎|e@ɑM */
  MYSTERYGIFT_SEQ_AGB_SEND_RECV_FLAG_CHILD2,
  
  /* WiFi̎擾V[PX */
  MYSTERYGIFT_WIFI_DOWNLOAD_MAIN,	/* WiFiʐM */
  
  /* r[R擾V[PX */
  MYSTERYGIFT_BEACON_SEQ_INIT,		/* r[R擾 */
  MYSTERYGIFT_BEACON_SEQ_WAIT,		/* r[R擾@Ȃ */
  MYSTERYGIFT_BEACON_SEQ_TIMER,		/* r[R擾 */

  MYSTERYGIFT_BEACON_DOWNLOAD_YESNO,	/* r[R_E[h */
  MYSTERYGIFT_BEACON_DOWNLOAD_WAIT_TITLE,	/* event_nameĂ̂҂ */
  MYSTERYGIFT_BEACON_DOWNLOAD,		/* r[R_E[h */
  MYSTERYGIFT_BEACON_DOWNLOAD_WAITSAVE,	/* Z[uI҂Ď̏ */
  MYSTERYGIFT_BEACON_DOWNLOAD_CANCEL,	/* LZ */
  
  /* r[R_E[hV[PX */
  BEACON_STATE_INIT1,			// (ʐMCu)
  BEACON_STATE_INIT2,			// 
  BEACON_STATE_START,			// Jn
  BEACON_STATE_SCANNING,		// XL
  BEACON_STATE_DOWNLOAD,		// e@āA_E[h
  BEACON_STATE_COMPLETE,		// _E[h
  BEACON_STATE_CANCELING,		// LZ
  BEACON_STATE_FINISH,			// _E[hI
  BEACON_STATE_SUCCESS,			// _E[h
  BEACON_STATE_CRCERROR,		// _E[hbqbG[	
  BEACON_STATE_CANCEL,			// LZI
  BEACON_STATE_ERROR,				// G[

  MYSTERYGIFT_ERROR_FULL,		// zB܂̓J[htŎ󂯎Ȃ
  MYSTERYGIFT_SEQ_DISP_MSG,
  MYSTERYGIFT_SEQ_RETURN_TOPMENU,
  MYSTERYGIFT_SEQ_GROUNDCHILD_CHECK,	// zz`FbN
  
  MYSTERYGIFT_SEQ_RETURN,		/* ^Cg̃j[ɖ߂ */
  MYSTERYGIFT_SEQ_GO_LOOKCARD,		/* J[h֔ */

  MYSTERYGIFT_SEQ_LOOP,			/* [v */
  MYSTERYGIFT_SEQ_DISP_CARD,		/* J[h\ */
  MYSTERYGIFT_SEQ_FADEOUT_RESET,	/* tF[hAEgZbg */
  
#ifdef PARENT_TEST
  /* ȉAfobOp */
  MYSTERYGIFT_SEQ_START_PARENT,		/* e@FʐMJn */
  MYSTERYGIFT_SEQ_SYNC_CHILD_TIMING,	/* e@Fq@Ƃ̓҂ */
  MYSTERYGIFT_SEQ_SYNC_CHILD_PARENT,	/* e@Fq@Ƃ̃^C~O킹 */
  MYSTERYGIFT_SEQ_SENDDATA_PARENT,	/* e@Ff[^MJn */
#endif	// PARENT_TEST

  MYSTERYGIFT_SEQ_MAX
};



typedef struct {
  int id;
  u32 param;
} LISTDATA;


#define MYSTERYGIFT_FRAMECHR1	1
#define MYSTERYGIFT_FRAMECHR2	(MYSTERYGIFT_FRAMECHR1 + TALK_WIN_CGX_SIZ)
#define MYSTERYGIFT_WINDOWCHR	(MYSTERYGIFT_FRAMECHR2 + MENU_WIN_CGX_SIZ)
#define MYSTERYGIFT_TOPMENUCHR	(MYSTERYGIFT_WINDOWCHR + 26 * 6)
#define MYSTERYGIFT_COMMTYPECHR	(MYSTERYGIFT_TOPMENUCHR + 16 * 6)
#define MYSTERYGIFT_COMMDIRCHR	(MYSTERYGIFT_COMMTYPECHR + 17 * 8)
#define MYSTERYGIFT_UPWINCHR	(MYSTERYGIFT_COMMDIRCHR + 6 * 4)

#define	FONT_PALNO_NORMAL	0	/* m[}pbg */
#define	FONT_PALNO_SELECT	1	/* Ipbg */
#define WAKU_PALETTE_NUMBER1	2
#define WAKU_PALETTE_NUMBER2	3
#define	MYSTERYGIFT_BLACK	(GF_PRINTCOLOR_MAKE(1, 2, 15))
#define	MYSTERYGIFT_WHITE	(GF_PRINTCOLOR_MAKE(15, 2, 0))

//============================================================================================
//	vg^Cv錾
//============================================================================================
static int CommParentStart(PROC *proc);
static int CommChildStart(PROC *proc);
static int CommChildRecvStart(PROC *proc);
static int CommWiFiChildStart(PROC *proc);
static int CommBeaconChildStart(PROC *proc);

static int CommDirectMenuNo(PROC *proc);
static int CommDirectCommMenuNo(PROC *proc);
static int CommDirectMenuYesNo(PROC *proc);
static int CommWiFiMenuYesNo(PROC *proc);
static int CommBeaconMenuYesNo(PROC *proc);
static int CommChildRecvBeaconStart(PROC *proc);
static int CommChildRecvBeaconCancel(PROC *proc);

static int CommTypeMenuRetire(PROC *proc);

static int TopMainMenuRecvGift(PROC *proc);
static int TopMainMenuLookCard(PROC *proc);
static int TopMainMenuRetire(PROC *proc);
static void CreateWindowMenuData(PROC *proc, LISTDATA *ld, int num, GF_BGL_BMPWIN *win, u32 msg);
static void CreateMenuWindow(PROC *proc, int base, u32 msg);

static void DisplaySequence(PROC *proc, GF_BGL_BMPWIN *win, u32 msgid);

static void MysteryGift_BeaconCancel(void);
static void MysteryGiftBeaconProc_Main(MYSTERYGIFT_WORK *wk);
static void MysteryGift_BeaconMainLoop(MYSTERYGIFT_WORK *wk);
static int MysteryGif_DisplayMessage(PROC *proc, GF_BGL_BMPWIN *win, int msgid, int seq);


//============================================================================================
//	O[oϐ
//============================================================================================
static PROC *MysteryProc;

/* gbvCj[pf[^ */
LISTDATA TopMainMenu_MenuData1[] = {
  { mystery_menu_001, (u32)TopMainMenuRecvGift },
  { mystery_menu_002, (u32)TopMainMenuLookCard },
  { mystery_menu_003, (u32)TopMainMenuRetire },
};

/* ʐMIj[pf[^ */
LISTDATA CommTypeMenu_MenuData[] = {
  { mystery_menu_004, (u32)CommDirectMenuYesNo },
  { mystery_menu_009, (u32)CommBeaconMenuYesNo },
  { mystery_menu_005, (u32)CommWiFiMenuYesNo },
  { mystery_menu_006, (u32)CommTypeMenuRetire },
};

/* ʐMŁu_CNgvI̊mFj[ */
LISTDATA CommDirectYesNoMenu_MenuData[] = {
  { mystery_menu_007, (u32)CommChildStart },
#ifndef PARENT_TEST
  { mystery_menu_008, (u32)CommDirectMenuNo },
#else
  // fobOpł͐e@ƂċN
  { mystery_menu_008, (u32)CommParentStart },
#endif
};

/* _CNgʐMɐڑ܂u͂^vj[ */
LISTDATA CommDirectCommYesNoMenu_MenuData[] = {
  { mystery_menu_007, (u32)CommChildRecvStart },
  { mystery_menu_008, (u32)CommDirectCommMenuNo },
};



/* ʐMŁuWiFivI̊mFj[ */
LISTDATA CommWiFiYesNoMenu_MenuData[] = {
  { mystery_menu_007, (u32)CommWiFiChildStart },
  { mystery_menu_008, (u32)CommDirectMenuNo },
};
/* WiFiʐMɐڑ܂u͂^vj[ */
LISTDATA CommWiFiCommYesNoMenu_MenuData[] = {
  { mystery_menu_007, (u32)CommChildRecvStart },
  { mystery_menu_008, (u32)NULL },
};



/* ʐMŁuu[hLXgvI̊mFj[ */
LISTDATA CommBeaconYesNoMenu_MenuData[] = {
  { mystery_menu_007, (u32)CommBeaconChildStart },
  { mystery_menu_008, (u32)CommDirectMenuNo },
};
/* u[hLXgʐMɌf[^M邩u͂^vj[ */
LISTDATA CommBeaconCommYesNoMenu_MenuData[] = {
  { mystery_menu_007, (u32)CommChildRecvBeaconStart },
  { mystery_menu_008, (u32)CommChildRecvBeaconCancel },
};





/* ėpj[\(gčėp) */
static BMPLIST_HEADER MenuListHeader = {
  NULL,
  MysteryLib_MenuKeyMove,	 	/* J[\ړƂ̃R[obN֐ */
  NULL,				     	/* \Ƃ̃R[obN֐ */
  NULL,					/* BMPEBhEf[^ */
  0,/* Ŗ߂ */			/* Xgڐ */
  3,					/* \ő區ڐ */
  0,					/* x\wW */
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_GERMANY) imatake 2007/05/01
// hCcŁuv|eŁ@Ƃv̕\͂ݏôɑΏ
#if PM_LANG == LANG_GERMANY
  8,					/* ڕ\wW */
#else
  12,					/* ڕ\wW */
#endif
// ----------------------------------------------------------------------------
  0,					/* J[\\wW */
  0,					/* \xW */
  FBMP_COL_BLACK,			/*F */
  FBMP_COL_WHITE,			/*wiF */
  FBMP_COL_BLK_SDW,			/*eF */
  0,					/* Ԋuw */
  16,					/* Ԋux */
  BMPLIST_LRKEY_SKIP,			/* y[WXLbv^Cv */
  FONT_SYSTEM, 				/* w({ u8 ǁAȂɍȂƎv̂) */
  0			  		/* afJ[\(allow)\tO(0:ON,1:OFF) */
};



#define debug_printf	OS_TPrintf
static int s_state;
static int progress_time;
static void *buffer;


#ifdef PARENT_TEST
//--------------------------------------------------------------------------------------------
/**
 * @brief	ʐMf[^̂ł֐
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
#include "gflib/fntsys.h"
#include "msgdata/msg_debug_mitsuhara.h"
static GIFT_COMM_PACK decchi_giftdata;
static GIFT_COMM_PACK *DecchiCreateGiftData(MYSTERYGIFT_WORK *wk)
{
  int i;
  
  GIFT_COMM_PACK *gd = &decchi_giftdata;
  // ǂq͐^_łI
  static STRCODE title[] = { hu_, si_, gi_, na_, o_, ku_, ri_, mo_, no_, TE_, SU_, TO_, de_, su_, CR_,
			     D__, S__, spc_, BA_, bou_, ZI_, YYO_, N_, EOM_, 0 };
  static STRCODE etext[] = { hu_, na_, tu_, ki_, ba_, ni_, spc_, hu_, ru_, bi_, ta_, ka_, i_, zu_, wo_, CR_,
			     mo_, ttu_, te_, i_, ku_, to_, CR_,
			     sa_, i_, ha_, te_, no_, ko_, to_, u_, ni_, spc_, i_, ke_, ru_, zo_, gyoe_, CR_,
			     ya_, se_, i_, no_, MI_, YYU_, U_, ni_, spc_, a_, i_, ni_, i_, ko_, u_, gyoe_,  EOM_, 0 };
  static u8 pokedata[] = {
    0xA6, 0x8A, 0x4E, 0x79, 0x00, 0x00, 0x6F, 0xFD, 0x0F, 0x80, 0xCC, 0x00, 0xE1, 0x4C, 0xEA, 0x2D,
    0x94, 0x1D, 0x47, 0x82, 0xF0, 0xAE, 0x93, 0xCE, 0x7F, 0x0A, 0xE7, 0xA3, 0x67, 0xD3, 0x98, 0x2F,
    0x2B, 0x8A, 0xD9, 0x46, 0xF9, 0xE9, 0xE5, 0x53, 0xC6, 0x18, 0x72, 0xB7, 0x2C, 0x7D, 0x3B, 0x86,
    0x9D, 0x85, 0x49, 0xC1, 0xB6, 0x97, 0xBA, 0x86, 0x2E, 0xA8, 0x19, 0x01, 0x20, 0x07, 0x9D, 0x0B,
    0xFA, 0xFF, 0x89, 0x74, 0xED, 0x8C, 0x68, 0x00, 0xF7, 0x54, 0xB9, 0x92, 0xB3, 0xCF, 0xC4, 0xB8,
    0xA6, 0x84, 0x0A, 0xF3, 0x8C, 0xE3, 0x56, 0x3A, 0x03, 0xB0, 0x08, 0x03, 0x75, 0x49, 0x80, 0x19,
    0x00, 0x85, 0xEE, 0xBF, 0x3F, 0x99, 0x84, 0x21, 0xFD, 0x34, 0x71, 0x40, 0x7D, 0x11, 0x75, 0x07,
    0xA3, 0xCB, 0xAA, 0xDB, 0x1E, 0x60, 0x03, 0xEB, 0x7C, 0xE1, 0x8D, 0x23, 0x60, 0xEE, 0xAD, 0x2E,
    0xA9, 0xEC, 0xBE, 0x26, 0xA1, 0xE5, 0x78, 0x4C, 0x13, 0xF7, 0x29, 0x73, 0xBA, 0x77, 0x92, 0xCB,
    0x58, 0x20, 0x2A, 0x89, 0x06, 0xBB, 0x19, 0x60, 0xA5, 0xDF, 0xE4, 0xD5, 0x6D, 0xFE, 0xDF, 0x0B,
    0xA2, 0x0B, 0x3B, 0xC7, 0xC2, 0xBF, 0xC7, 0x17, 0xC6, 0x5F, 0xB7, 0x4B, 0xD0, 0x38, 0x52, 0x35,
    0xD1, 0xB4, 0x8D, 0x81, 0x60, 0x83, 0x4E, 0x07, 0x82, 0x66, 0x68, 0x1A, 0x8C, 0xF8, 0x38, 0xD8,
    0x70, 0xAF, 0xA3, 0x65, 0x4B, 0xC8, 0x64, 0x6C, 0x0F, 0x6B, 0xE4, 0x85, 0xA0, 0x68, 0xE1, 0x6B,
    0xBA, 0x26, 0x8C, 0x66, 0x7D, 0x34, 0xCA, 0x89, 0x7C, 0xC8, 0x14, 0xDA, 0x71, 0xF8, 0x8C, 0xB3,
    0x44, 0x9F, 0x9E, 0xF1, 0x90, 0x20, 0x51, 0x90, 0xBF, 0xA8, 0x42, 0x5A,
  };
  
  // ƂĂ邽߂ɏ
  wk->msgman = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_mystery_dat, HEAPID_MYSTERYGIFT);
  wk->word = WORDSET_Create(HEAPID_MYSTERYGIFT);

  MI_CpuClear8(gd, sizeof(GIFT_COMM_PACK));
  // |Pf[^Rs[(PokemonParam)
  for(i = 0; i < sizeof(pokedata); i++)
    gd->data.deli.data.pokemon.data[i] = pokedata[i];

  // ȊÕf[^Zbg
  memcpy(gd->beacon.event_name, title, GIFT_DATA_CARD_TITLE_MAX*2);
  
  gd->beacon.version = (1 << VERSION_DIAMOND) | (1 << VERSION_PEARL) | (1 << VERSION_DP_NEXT);// Ώۃo[W
  gd->beacon.only_one_flag = 0;			// PxzMtO
  gd->beacon.access_point = 0;			// ANZX|Cg(gp)
  gd->beacon.have_card = 1;			// J[h܂ł邩
  gd->beacon.delivery_flag = 1;			// zB󂯎̂܂ł邩

  // J[ĥł
  gd->data.card.re_deal_count = 128; 		// Ĕzz̉(0`254A255͖)
  gd->data.card.pokemon_icon[0] = 1;		// |PACRR
  gd->data.card.pokemon_icon[1] = 151;		// |PACRR
  gd->data.card.pokemon_icon[2] = 250;		// |PACRR

  //  gd->data.deli.gift_type = MYSTERYGIFT_TYPE_POKEMON;	// |P
  //  gd->data.deli.gift_type = MYSTERYGIFT_TYPE_POKEEGG;	// ^}S
  //  gd->data.deli.gift_type = MYSTERYGIFT_TYPE_ITEM;	// ǂ
  //  gd->data.deli.gift_type = MYSTERYGIFT_TYPE_RULE;	// [
  //  gd->data.deli.gift_type = MYSTERYGIFT_TYPE_GOODS;	// ObY
  gd->data.deli.gift_type = MYSTERYGIFT_TYPE_ACCESSORY;	// ANZT
  //  gd->data.deli.gift_type = MYSTERYGIFT_TYPE_RANGEREGG;	// }itB[̃^}S
  //  gd->data.deli.gift_type = MYSTERYGIFT_TYPE_MEMBERSCARD;	// o[YJ[h
  //  gd->data.deli.gift_type = MYSTERYGIFT_TYPE_LETTER;	// I[LĥĂ
  //  gd->data.deli.gift_type = MYSTERYGIFT_TYPE_WHISTLE;	// Ă񂩂̂ӂ
  //  gd->data.deli.gift_type = MYSTERYGIFT_TYPE_POKETCH;	// |Pb`
  //  gd->data.deli.gift_type = MYSTERYGIFT_TYPE_CLEAR;	// ӂ̈̋NA


  gd->beacon.event_id = gd->data.deli.gift_type + 100;	// Cxghc

  // ܂^}Sݒ
  if(gd->data.deli.gift_type == MYSTERYGIFT_TYPE_POKEEGG){
    u8 tamago = 1;
    POKEMON_PARAM *pp = (POKEMON_PARAM *)gd->data.deli.data.pokemon.data;
    PokeParaPut(pp, ID_PARA_tamago_flag, &tamago);
  }

  // ACe
  if(gd->data.deli.gift_type == MYSTERYGIFT_TYPE_ITEM){
    gd->data.deli.data.item.itemNo = 80;
  }

  // M[V
  if(gd->data.deli.gift_type == MYSTERYGIFT_TYPE_RULE){
    REGULATION _dummycup = {
      {EOM_}, // gmmƂĂ
      80,//x̍vWO܂
      3,//RC
      30,//|P̃xRO܂
      -20,//gQDO
      -20,// ̏dQO
      0,// i|PQłȂ
      0,// ʂȃ|PQłȂ
      0,// |PQłȂ
      0,// Ȃ
      0,// Œ_[WZKs
    };
    MSGDATA_MANAGER* msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_mitsuhara_dat, HEAPID_MYSTERYGIFT);
    STRBUF* pStr = MSGMAN_AllocString( msgman, msg_regulation_dummy );
    //    gd.gift_type = MYSTERYGIFT_TYPE_RULE;
    Regulation_SetCupName(&_dummycup,pStr);
    MI_CpuCopy8(&_dummycup, &gd->data.deli.data, sizeof(REGULATION));
    MSGMAN_Delete(msgman);
    STRBUF_Delete(pStr);
  }

  // ObY
  if(gd->data.deli.gift_type == MYSTERYGIFT_TYPE_GOODS){
    gd->data.deli.data.goods.goodsNo = 33;
  }

  // ANZT
  if(gd->data.deli.gift_type == MYSTERYGIFT_TYPE_ACCESSORY){
    gd->data.deli.data.accessory.accType = MYSTERYGIFT_ACCTYPE_SEAL;
    gd->data.deli.data.accessory.accNo = 79;//V[
  }

  // |Pb`
  if(gd->data.deli.gift_type == MYSTERYGIFT_TYPE_POKETCH){
    gd->data.deli.data.poketch.id = 1; //POKETCH_APPID_STOPWATCH
  }

  // ӂ̈̋NA
  if(gd->data.deli.gift_type == MYSTERYGIFT_TYPE_CLEAR){
    gd->beacon.version  = 0xFFFFFFFF;
    gd->beacon.event_id = 0xFFFF;
  }


  
  // oオr[Rf[^{̂ɂRs[Ă(Ĕzzp)
  memcpy(&gd->data.card.beacon, &gd->beacon, sizeof(GIFT_BEACON));

  // Cxg̃Rs[
  memcpy(gd->data.card.event_text, etext, GIFT_DATA_CARD_TEXT_MAX*2);
  // n
  MSGMAN_Delete(wk->msgman);
  WORDSET_Delete(wk->word);

#ifdef DEBUG_ONLY_FOR_mituhara
  // fobKŃoCio͂AGB-ROM邽߂̃AhX\
  OS_TPrintf("łf[^F0x%08X - 0x%08X\n", &decchi_giftdata, (u32)&decchi_giftdata + sizeof(GIFT_COMM_PACK));
  OS_TPrintf("                  %dbytes\n", sizeof(GIFT_COMM_PACK));
#endif
  
  return gd;
}
#endif	// PARENT_TEST

//------------------------------------------------------------------
/**
 * @brief	^CACRON/OFF
 * @param	flag: TRUE \@FALSE \
 * @return	NONE
 */
//------------------------------------------------------------------
static void SetTimeWaitIcon(MYSTERYGIFT_WORK *wk, int flag)
{
  if(flag == TRUE){
    if(wk->time_icon == NULL){
      wk->time_icon = TimeWaitIconAdd(&wk->msgwin, MYSTERYGIFT_FRAMECHR1);
#if 0//def DEBUG_ONLY_FOR_mituhara
      OS_TPrintf("--- ^CACR: ON\n");
#endif
    }
  } else {
    if(wk->time_icon){
      TimeWaitIconDel(wk->time_icon);
#if 0//def DEBUG_ONLY_FOR_mituhara
      OS_TPrintf("--- ^CACR: OFF\n");
#endif
    }
    wk->time_icon = NULL;
  }
}
void SetTimeWaitIconEx(MYSTERYGIFT_WORK *wk, int flag)
{
  SetTimeWaitIcon(wk, flag);
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	̃j[ʂ̍ŏIn
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
static void TopMainMenuFinish(PROC *proc)
{
  int i;
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  MysteryLib_RemoveClact();

  
  if(wk->bmd)		BMP_MENULIST_Delete(wk->bmd);
  if(wk->lw)		BmpListExit(wk->lw, NULL, NULL);
  GF_BGL_BmpWinOff(&wk->msgwin); GF_BGL_BmpWinDel(&wk->msgwin);
  if(GF_BGL_BmpWinAddCheck(&wk->upwin)){
    GF_BGL_BmpWinOff(&wk->upwin); GF_BGL_BmpWinDel(&wk->upwin);
  }
  for(i = 0; i < MYSTERYGIFT_WIN_MAX; i++){
    if(wk->selwin[i].ini){
      GF_BGL_BmpWinOff(&wk->selwin[i]);
      GF_BGL_BmpWinDel(&wk->selwin[i]);
    }
  }
  GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME0_M);
  GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME1_M);
  GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME0_S);
  GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME1_S);
  sys_FreeMemoryEz(wk->bgl);
}

// *******************************************************************************************


//** CharManager PlttManagerp **//
#define RECORD_CHAR_CONT_NUM				(20)
#define RECORD_CHAR_VRAMTRANS_MAIN_SIZE		(2048)
#define RECORD_CHAR_VRAMTRANS_SUB_SIZE		(2048)
#define RECORD_PLTT_CONT_NUM				(20)


static void VBlankFunc( void * work )
{
  // ZAN^[Vram]}l[W[s
  DoVramTransferManager();
  // _LOAM}l[WVram]
  REND_OAMTrans();	
  OS_SetIrqCheckFlag( OS_IE_V_BLANK );
}

//------------------------------------------------------------------
/**
 * @brief	ZAN^[̏
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void InitCellActor(MYSTERYGIFT_WORK *wk)
{
  MysteryLib_InitCPManager();
  MysteryLib_InitClactSystem();
  MysteryLib_InitClact(ARC_MYSTERY_GRA,
		       NARC_mystery_fusigi_cur_00_lz_ccgr,
		       NARC_mystery_fusigi_cur_nclr,
		       NARC_mystery_fusigi_cur_00_lz_ccer,
		       NARC_mystery_fusigi_cur_00_lz_canr,
		       GF_BGL_MAIN_DISP);
}


//------------------------------------------------------------------
/**
 * @brief	I^߂yIuWFNg̓o^
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void SetBaseIcon(MYSTERYGIFT_WORK *wk, int anum)
{
  if(anum != -1){
    wk->arrow = MysteryLib_MakeCLACT(GF_BGL_MAIN_DISP, wk->arrow, HW_LCD_WIDTH/2, 100, anum);
  } else {
    CLACT_SetDrawFlag(wk->arrow, 0);
  }
}



// *******************************************************************************************


#ifdef PARENT_TEST
//--------------------------------------------------------------------------------------------
/**
 * @brief	e@ƂĒʐMJn
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
static int CommParentStart(PROC *proc)
{
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);
  SAVEDATA *sv = ((MAINWORK *)PROC_GetParentWork(proc))->savedata;

  // f[^̂ł
  GIFT_COMM_PACK *gd = DecchiCreateGiftData(wk);
  // MYSTERYGIFT_WORKփf[^Zbg
  memcpy(&wk->gift_data, gd, sizeof(GIFT_COMM_PACK));
  
  CommMysteryStateEnterGiftParent(wk, sv, COMM_MODE_MYSTERY);
#ifdef DEBUG_ONLY_FOR_mituhara
  OS_Printf("eƂĒʐMJn\n");
#endif
  return MYSTERYGIFT_SEQ_START_PARENT;
}
#endif	// PARENT_TEST


// *******************************************************************************************


//------------------------------------------------------------------
/**
 * @brief	EBhE݂΃NA
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void CMG_BmpMenuWinClear(GF_BGL_BMPWIN * win, u8 trans_sw)
{
  if(GF_BGL_BmpWinAddCheck(win) == TRUE)
    BmpMenuWinClear(win, trans_sw);
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	q@ƂĒʐMJn
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
static int CommChildStart(PROC *proc)
{
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);
  
  if(wk->comm_type != MYSTERYCOMM_TYPE_AGBCARTRIDGE){
    /* ú@@Ă܂\n΂炭@܂@ccv */
    DisplaySequence(proc, &wk->msgwin, mystery_01_004);
  }
  /* u͂^ṽj[EBhE͂ */
  CMG_BmpMenuWinClear(&wk->selwin[MYSTERYGIFT_WIN_COMM_DIRECT_YESNO], WINDOW_TRANS_ON);
#if 0//def DEBUG_ONLY_FOR_mituhara
  OS_Printf("qƂĒʐMJn\n");
#endif
  if(wk->comm_type != MYSTERYCOMM_TYPE_AGBCARTRIDGE){
    CommMysteryStateEnterGiftChild(wk, COMM_MODE_MYSTERY);
    // ^CAEgԂݒ
    wk->timeout = MYSTERYGIFT_TIMEOUT;
    // ʐMACR\
    WirelessIconEasy();
    // ^CACR\
    SetTimeWaitIcon(wk, TRUE);
    return MYSTERYGIFT_SEQ_START_CHILD;
  } else {
    OS_TPrintf("AGBJ[gbW̓] \n");
    return MYSTERYGIFT_SEQ_AGB_START_CHILD;
  }
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	̂MƊm肵̓(q@)
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
static int CommChildRecvStart(PROC *proc)
{
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  // _CNgʐM̏ꍇ͂Ńo[WႢ`FbN
  if(wk->gift_error == COMMMYSTERYFUNC_ERROR_VERSION)
    return MYSTERYGIFT_ERROR_FULL;
  
  // zgɎ󂯎邩`FbNs
  if(wk->gift_error == COMMMYSTERYFUNC_ERROR_FULLGIFT ||	/* zBt */
     wk->gift_error == COMMMYSTERYFUNC_ERROR_FULLCARD ||	/* J[ht */
     wk->gift_error == COMMMYSTERYFUNC_ERROR_HAVE)		/* x󂯎Ȃ */
    return MYSTERYGIFT_ERROR_FULL;

  // zz̏ꍇ̓zgɎ󂯎́H`FbNs
  if(wk->gift_error == COMMMYSTERYFUNC_ERROR_GROUNDCHILD){
    /* mituhara; */
    return MYSTERYGIFT_ERROR_FULL;
  }

  if(wk->comm_type == MYSTERYCOMM_TYPE_DIRECT){
    CommMysteryStateConnectGiftChild(wk->connectIndex);
#if 0//def DEBUG_ONLY_FOR_mituhara
    OS_Printf("eɑ΂Đڑvo܂\n");
#endif  
  }
  // u݂@܂\n΂炭@܂cv
  DisplaySequence(proc, &wk->msgwin, mystery_01_007);
  /* u͂^ṽj[EBhE͂ */
  CMG_BmpMenuWinClear(&wk->selwin[MYSTERYGIFT_WIN_COMM_DIRECT_YESNO], WINDOW_TRANS_ON);

  // 󂯎IuWFNg̕\(Wi-Fȉꍇ͏uԓIɂ\Ȃ̂ŁA\Ȃ)
  if(wk->comm_type == MYSTERYCOMM_TYPE_DIRECT){
    SetBaseIcon(wk, 0);
    SetTimeWaitIcon(wk, TRUE);
  }

  // 󂯎@ɕς邽߁AV[PX
  if(wk->comm_type == MYSTERYCOMM_TYPE_DIRECT){
    CommTimingSyncStart(MYSTERYGIFT_SYNC_CODE);
    return MYSTERYGIFT_SEQ_REQEST_CHILD;
  } else {
    return MYSTERYGIFT_SEQ_AGB_RECV_CHECK_CHILD;
  }
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	Z[uf[^Z[u\̂ɃZbg
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
static GIFT_DELIVERY *CommSetSaveData(PROC *proc)
{
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);
  GIFT_DATA *gdata = &wk->gift_data.data;
  GIFT_BEACON *beacon = &wk->gift_data.beacon;
  GIFT_COMM_PACK *gcp;

  switch(wk->comm_type){
  case MYSTERYCOMM_TYPE_DIRECT:
    memcpy(gdata, CommGetMysteryGiftRecvBuff(0, NULL, 0), sizeof(GIFT_DATA));
    /* Mf[^̈Ídecode */
    MysteryLib_DecodeCryptoData(&wk->gift_data, &wk->gift_data.data, HEAPID_MYSTERYGIFT);
    break;
  case MYSTERYCOMM_TYPE_BEACON:
    gcp = (GIFT_COMM_PACK *)wk->recvbuf;
    memcpy(gdata, &gcp->data, sizeof(GIFT_DATA));
#if 0
    memcpy(beacon, &gcp->data.card.beacon, sizeof(GIFT_BEACON));
#else
    memcpy(beacon, &gcp->beacon, sizeof(GIFT_BEACON));
#endif
    break;
  }
  return &gdata->deli;
}


//------------------------------------------------------------------
/**
 * @brief	Z[uV[PX
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void SaveSequence(void *p)
{
  int ret;
  MYSTERYGIFT_WORK *wk = (MYSTERYGIFT_WORK *)p;
  if(wk->save_cancel == TRUE){
    // Z[uLZꂽ
    wk->func_hook = NULL;
  }
  ret = MysteryLib_SaveDSCard();
  if(ret == SAVE_RESULT_OK || ret == SAVE_RESULT_NG){
    Snd_SePlay(SEQ_SE_DP_SAVE);
    //    OS_TPrintf("Z[uI܂\n");
    wk->func_hook = NULL;
  }
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	͂f[^Z[ü֓o^
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
static void CommChildSaveRecvData(PROC *proc)
{
  int type, ret;
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);
  GIFT_BEACON *beacon = &wk->gift_data.beacon;
  GIFT_DATA *gdata = &wk->gift_data.data;
  SAVEDATA *sv = ((MAINWORK *)PROC_GetParentWork(proc))->savedata;
  FUSHIGI_DATA *fdata;

#if 0//def DEBUG_ONLY_FOR_mituhara
  OS_TPrintf("J[h:\t%d\n", beacon->have_card);
  OS_TPrintf("|PACR:\t%3d : %3d : %3d\n",
	     gdata->card.pokemon_icon[0], gdata->card.pokemon_icon[1], gdata->card.pokemon_icon[2]);
#endif
  
  if(beacon->have_card == 0){
    type = MYSTERYGIFT_DELIVERY;
  } else {
    RTCDate date;
    type = MYSTERYGIFT_CARD;
    /* Ĕzz񐔂Zbg */
    gdata->card.re_dealed_count = 0;	//gdata->card.re_deal_count;
    /* Ĕzz\tOQĂ񐔂Zbg */
    if(beacon->re_deal_flag == FALSE)
      gdata->card.re_deal_count = 0;
    /* Z[ut */
    GF_RTC_GetDate(&date);
    gdata->card.recv_date = RTC_ConvertDateToDay(&date);
#if 0//def DEBUG_ONLY_FOR_mituhara
    OS_Printf("%4dN%2d%2d -> %08X\n", date.year, date.month, date.day, gdata->card.recv_date);
#endif
  }

  // ӂf[^̃|C^𓾂
  fdata = SaveData_GetFushigiData(sv);
  // CxgԍtO𗧂Ă
  FUSHIGIDATA_SetEventRecvFlag(fdata, beacon->event_id);
  // Z[uGAɃf[^Zbg
  if(type == MYSTERYGIFT_DELIVERY){
    ret = FUSHIGIDATA_SetDeliData(fdata, (const void *)gdata, 0);
  } else {
    ret = FUSHIGIDATA_SetCardData(fdata, (const void *)gdata);
  }
  // Z[uV[PXo^
  MysteryLib_InitSaveDSCard(sv);
  wk->save_cancel = FALSE;
  wk->func_hook = SaveSequence;
}




//--------------------------------------------------------------------------------------------
// _CNgʐMŁu͂^vIEBhE

//--------------------------------------------------------------------------------------------
/**
 * @brief	_CNgʐMɌeƐڑ邩u͂^v
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
static void CreateDirectCommYesNoMenu(PROC *proc, int flag)
{
  int msg;
  GF_BGL_BMPWIN *win;
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  if(flag == 0)	msg = mystery_01_005;
  else		msg = -1;
  
  win = &wk->selwin[MYSTERYGIFT_WIN_COMM_DIRECT_YESNO];
  if(win->ini == NULL)
    GF_BGL_BmpWinAdd(wk->bgl, win, GF_BGL_FRAME0_M, 23, 10, 6, 4, FONT_PALNO_NORMAL, MYSTERYGIFT_COMMDIRCHR);
  // ----------------------------------------------------------------------------
  // localize_spec_mark(LANG_ALL) imatake 2007/01/10
  // EBhE̘g`悪x̂C
  BmpMenuWinWrite(win, WINDOW_TRANS_OFF, MYSTERYGIFT_FRAMECHR2, WAKU_PALETTE_NUMBER2);
  CreateWindowMenuData(proc, CommDirectCommYesNoMenu_MenuData, NELEMS(CommDirectCommYesNoMenu_MenuData), win, msg);
  // ----------------------------------------------------------------------------
}



//--------------------------------------------------------------------------------------------
// ʐM@Ń_CNgʐMIۂ̊mFEBhE

//--------------------------------------------------------------------------------------------
/**
 * @brief	_CNgʐM܂HŁuvI
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
static int CommDirectMenuNo(PROC *proc)
{
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);
  /* ̃j[EBhE\Ȃ */
  CMG_BmpMenuWinClear(&wk->selwin[MYSTERYGIFT_WIN_COMM_DIRECT_YESNO], WINDOW_TRANS_ON);
  CMG_BmpMenuWinClear(&wk->upwin, WINDOW_TRANS_ON);
  if(wk->comm_type == MYSTERYCOMM_TYPE_DIRECT){
    SetTimeWaitIcon(wk, FALSE);	// ^CACR
  }

  WirelessIconEasyEnd();
  return TopMainMenuRecvGift(proc);
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	_CNgʐM܂Hu͂^v
 * @param	NONE
 * @return	̃V[PXԍ
 */
//--------------------------------------------------------------------------------------------
static int CommDirectMenuYesNo(PROC *proc)
{
  GF_BGL_BMPWIN *win;
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/17
// xł̂󂯎낤ƂƁǍAGB󂯎ȂȂ
// s̏C𔽉f
#if AFTERMASTER_070213_MISTERY_AGBCARTRIDGE_FIX
  if(GetAgbCartridgeDataSize())
    wk->comm_type = MYSTERYCOMM_TYPE_AGBCARTRIDGE;
  else
    wk->comm_type = MYSTERYCOMM_TYPE_DIRECT;
#else
  if(wk->comm_type != MYSTERYCOMM_TYPE_AGBCARTRIDGE)
    wk->comm_type = MYSTERYCOMM_TYPE_DIRECT;
#endif
// ----------------------------------------------------------------------------
  /* ̃j[EBhE\Ȃ */
  CMG_BmpMenuWinClear(&wk->selwin[MYSTERYGIFT_WIN_COMM_TYPE], WINDOW_TRANS_ON);
  /* j[ */
  win = &wk->selwin[MYSTERYGIFT_WIN_COMM_DIRECT_YESNO];
  if(win->ini == NULL)
    GF_BGL_BmpWinAdd(wk->bgl, win, GF_BGL_FRAME0_M, 23, 10, 6, 4, FONT_PALNO_NORMAL, MYSTERYGIFT_COMMDIRCHR);
  // ----------------------------------------------------------------------------
  // localize_spec_mark(LANG_ALL) imatake 2007/01/10
  // EBhE̘g`悪x̂C
  BmpMenuWinWrite(win, WINDOW_TRANS_OFF, MYSTERYGIFT_FRAMECHR2, WAKU_PALETTE_NUMBER2);
  CreateWindowMenuData(proc, CommDirectYesNoMenu_MenuData, NELEMS(CommDirectYesNoMenu_MenuData), win, mystery_01_003);
  // ----------------------------------------------------------------------------
  
  return MYSTERYGIFT_SEQ_DIRECT_YESNO;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	WiFi_E[hʐM܂Hu͂^v
 * @param	NONE
 * @return	̃V[PXԍ
 */
//--------------------------------------------------------------------------------------------
static int CommWiFiMenuYesNo(PROC *proc)
{
  GF_BGL_BMPWIN *win;
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  wk->comm_type = MYSTERYCOMM_TYPE_WIFI;
  /* ̃j[EBhE\Ȃ */
  CMG_BmpMenuWinClear(&wk->selwin[MYSTERYGIFT_WIN_COMM_TYPE], WINDOW_TRANS_ON);
  /* j[ */
  win = &wk->selwin[MYSTERYGIFT_WIN_COMM_DIRECT_YESNO];
  if(win->ini == NULL)
    GF_BGL_BmpWinAdd(wk->bgl, win, GF_BGL_FRAME0_M, 23, 10, 6, 4, FONT_PALNO_NORMAL, MYSTERYGIFT_COMMDIRCHR);
  // ----------------------------------------------------------------------------
  // localize_spec_mark(LANG_ALL) imatake 2007/01/10
  // EBhE̘g`悪x̂C
  BmpMenuWinWrite(win, WINDOW_TRANS_OFF, MYSTERYGIFT_FRAMECHR2, WAKU_PALETTE_NUMBER2);
  CreateWindowMenuData(proc, CommWiFiYesNoMenu_MenuData, NELEMS(CommWiFiYesNoMenu_MenuData), win, mystery_wifi_001);
  // ----------------------------------------------------------------------------
  
  return MYSTERYGIFT_SEQ_DIRECT_YESNO;
}





//--------------------------------------------------------------------------------------------
/**
 * @brief	u[hLXgʐM܂Hu͂^v
 * @param	NONE
 * @return	̃V[PXԍ
 */
//--------------------------------------------------------------------------------------------
static int CommBeaconMenuYesNo(PROC *proc)
{
  GF_BGL_BMPWIN *win;
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  wk->comm_type = MYSTERYCOMM_TYPE_BEACON;
  /* ̃j[EBhE\Ȃ */
  CMG_BmpMenuWinClear(&wk->selwin[MYSTERYGIFT_WIN_COMM_TYPE], WINDOW_TRANS_ON);
  /* j[ */
  win = &wk->selwin[MYSTERYGIFT_WIN_COMM_DIRECT_YESNO];
  if(win->ini == NULL)
    GF_BGL_BmpWinAdd(wk->bgl, win, GF_BGL_FRAME0_M, 23, 10, 6, 4, FONT_PALNO_NORMAL, MYSTERYGIFT_COMMDIRCHR);
  // ----------------------------------------------------------------------------
  // localize_spec_mark(LANG_ALL) imatake 2007/01/10
  // EBhE̘g`悪x̂C
  BmpMenuWinWrite(win, WINDOW_TRANS_OFF, MYSTERYGIFT_FRAMECHR2, WAKU_PALETTE_NUMBER2);
  CreateWindowMenuData(proc, CommBeaconYesNoMenu_MenuData, NELEMS(CommBeaconYesNoMenu_MenuData), win, mystery_broadcast_001);
  // ----------------------------------------------------------------------------
  
  return MYSTERYGIFT_SEQ_DIRECT_YESNO;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	u[hLXgʐMɌf[^M邩u͂^vj[
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
static void CreateBeaconCommYesNoMenu(PROC *proc)
{
  GF_BGL_BMPWIN *win;
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  win = &wk->selwin[MYSTERYGIFT_WIN_COMM_DIRECT_YESNO];
  if(win->ini == NULL)
    GF_BGL_BmpWinAdd(wk->bgl, win, GF_BGL_FRAME0_M, 23, 10, 6, 4, FONT_PALNO_NORMAL, MYSTERYGIFT_COMMDIRCHR);
  // ----------------------------------------------------------------------------
  // localize_spec_mark(LANG_ALL) imatake 2007/01/10
  // EBhE̘g`悪x̂C
  BmpMenuWinWrite(win, WINDOW_TRANS_OFF, MYSTERYGIFT_FRAMECHR2, WAKU_PALETTE_NUMBER2);
  CreateWindowMenuData(proc, CommBeaconCommYesNoMenu_MenuData, NELEMS(CommBeaconCommYesNoMenu_MenuData), win, mystery_01_005);
  // ----------------------------------------------------------------------------
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	݂f[^サ񂵂܂Łuv
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
static int CommDirectCommMenuNo(PROC *proc)
{
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);
  /* ̃j[EBhE\Ȃ */
  CMG_BmpMenuWinClear(&wk->selwin[MYSTERYGIFT_WIN_COMM_DIRECT_YESNO], WINDOW_TRANS_ON);
  CMG_BmpMenuWinClear(&wk->upwin, WINDOW_TRANS_ON);
  WirelessIconEasyEnd();
  /* _CNgʐM̏ꍇ͒ʐMH؂ */
  if(wk->comm_type == MYSTERYCOMM_TYPE_DIRECT){
    CommMysteryExitGift();
  }
  return TopMainMenuRecvGift(proc);
}


//------------------------------------------------------------------
/**
 * @brief	u[hLXgʐMJn
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static int CommBeaconChildStart(PROC *proc)
{
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);
  
  /* ú@@Ă܂
     @΂炭@܂@ccv */
  DisplaySequence(proc, &wk->msgwin, mystery_01_004);
  /* u͂^ṽj[EBhE͂ */
  CMG_BmpMenuWinClear(&wk->selwin[MYSTERYGIFT_WIN_COMM_DIRECT_YESNO], WINDOW_TRANS_ON);
  // ^CACR\
  SetTimeWaitIcon(wk, TRUE);
#if 0//def DEBUG_ONLY_FOR_mituhara
  OS_TPrintf("r[R擾\n");
#endif
  s_state = BEACON_STATE_INIT1;
  return MYSTERYGIFT_BEACON_DOWNLOAD_WAIT_TITLE;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	̂r[RMƊm肵̓
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
static int CommChildRecvBeaconStart(PROC *proc)
{
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  OS_TPrintf("G[ԍ %d\n", wk->gift_error);

  
  // zgɎ󂯎邩`FbNs
  if(wk->gift_error == COMMMYSTERYFUNC_ERROR_FULLGIFT ||	/* zBt */
     wk->gift_error == COMMMYSTERYFUNC_ERROR_FULLCARD ||	/* J[ht */
     wk->gift_error == COMMMYSTERYFUNC_ERROR_HAVE)		/* x󂯎Ȃ */
    return MYSTERYGIFT_ERROR_FULL;

  /* u͂^ṽj[EBhE͂ */
  CMG_BmpMenuWinClear(&wk->selwin[MYSTERYGIFT_WIN_COMM_DIRECT_YESNO], WINDOW_TRANS_ON);

  // 󂯎IuWFNg̕\
  SetBaseIcon(wk, 1);

  /* ́@@サ񂿂イ@ł\nł񂰂@ȂŁ@cc */
  DisplaySequence(proc, &wk->msgwin, mystery_01_008);
  return MYSTERYGIFT_BEACON_DOWNLOAD;
}


//------------------------------------------------------------------
/**
 * @brief	̂󂯎ȂƊm肵Ƃ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static int CommChildRecvBeaconCancel(PROC *proc)
{
  if(s_state == BEACON_STATE_SCANNING || s_state == BEACON_STATE_DOWNLOAD || s_state == BEACON_STATE_ERROR){
    if(bsdown_end()){
      s_state = BEACON_STATE_CANCELING;	
    }
  }
  return MYSTERYGIFT_BEACON_DOWNLOAD_CANCEL;
}




//--------------------------------------------------------------------------------------------


//------------------------------------------------------------------
/**
 * @brief	WiFiʐMJn
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static int CommWiFiChildStart(PROC *proc)
{
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);
  
  /* ú@@Ă܂
     @΂炭@܂@ccv */
  DisplaySequence(proc, &wk->msgwin, mystery_01_004);
  SetTimeWaitIcon(wk, TRUE);
  /* u͂^ṽj[EBhE͂ */
  CMG_BmpMenuWinClear(&wk->selwin[MYSTERYGIFT_WIN_COMM_DIRECT_YESNO], WINDOW_TRANS_ON);
  // ^CACR\
  SetTimeWaitIcon(wk, TRUE);
#if 0//def DEBUG_ONLY_FOR_mituhara
  OS_TPrintf("WiFiʐMJn܂\n");
#endif

  wk->wifi_dl_seq = WIFI_MYSTERYGIFT_BASE;
  wk->wifi_check_func = NULL;
  return MYSTERYGIFT_WIFI_DOWNLOAD_MAIN;
}






//--------------------------------------------------------------------------------------------
// ʐM@Ij[̏

//--------------------------------------------------------------------------------------------
/**
 * @brief	ʐMIj[ŁuǂvI
 * @param	NONE
 * @return	̃V[PXԍ
 */
//--------------------------------------------------------------------------------------------
static int CommTypeMenuRetire(PROC *proc)
{
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);
  /* ̃j[EBhE\Ȃ */
  CMG_BmpMenuWinClear(&wk->selwin[MYSTERYGIFT_WIN_COMM_TYPE], WINDOW_TRANS_ON);
  /* Cj[\ */
  CreateMenuWindow(proc, MYSTERYGIFT_TOPMENUCHR, mystery_01_001);
  return MYSTERYGIFT_SEQ_MAIN;
}



//--------------------------------------------------------------------------------------------
// gbvCj[̏

//--------------------------------------------------------------------------------------------
/**
 * @brief	ԍŏ̑IʂŁû@ƂvI
 * @param	NONE
 * @return	̃V[PXԍ
 */
//--------------------------------------------------------------------------------------------
static int TopMainMenuRecvGift(PROC *proc)
{
  GF_BGL_BMPWIN *win;
  SYSTEMDATA *sysdata;
  //  LISTDATA ld[4];
  //  int width, max = 0;
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);
  FUSHIGI_DATA *fdata = SaveData_GetFushigiData(wk->sv);

  /* r[R擾~ */
  if(wk->beacon_seq == MYSTERYGIFT_BEACON_SEQ_TIMER){
    wk->beacon_wait = 1;
    MysteryGiftBeaconProc_Main(wk);
  }
  
  /* ̃j[EBhE\Ȃ */
  CMG_BmpMenuWinClear(&wk->selwin[MYSTERYGIFT_WIN_MAIN], WINDOW_TRANS_ON);
  /* j[ */
  win = &wk->selwin[MYSTERYGIFT_WIN_COMM_TYPE];
#if 0
  // Ԃɂăj[̍ڂƑ傫ω^Cv(ςȂȂc)
  width = 16;
  // ŏ̃j[͕K{
  ld[max++] = CommTypeMenu_MenuData[0];
  // ӂȂ̂JtI[vƂȂ܂
  ld[max++] = CommTypeMenu_MenuData[1];
  ld[max++] = CommTypeMenu_MenuData[2];

  // ŌK{
  ld[max++] = CommTypeMenu_MenuData[3];
#endif
  if(win->ini == NULL)
    GF_BGL_BmpWinAdd(wk->bgl, win, GF_BGL_FRAME0_M, 15, 9, 16, 8,
		     FONT_PALNO_NORMAL, MYSTERYGIFT_COMMTYPECHR);
  // ----------------------------------------------------------------------------
  // localize_spec_mark(LANG_ALL) imatake 2007/01/10
  // EBhE̘g`悪x̂C
  BmpMenuWinWrite(win, WINDOW_TRANS_OFF, MYSTERYGIFT_FRAMECHR2, WAKU_PALETTE_NUMBER2);
  CreateWindowMenuData(proc, CommTypeMenu_MenuData, 4, win, mystery_01_002);
  // ----------------------------------------------------------------------------
  
  return MYSTERYGIFT_SEQ_RECV;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	ԍŏ̑IʂŁuJ[h@݂vI
 * @param	NONE
 * @return	̃V[PXԍ
 */
//--------------------------------------------------------------------------------------------
static int TopMainMenuLookCard(PROC *proc)
{
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  /* r[R擾~ */
  if(wk->beacon_seq == MYSTERYGIFT_BEACON_SEQ_TIMER){
    wk->beacon_wait = 1;
    MysteryGiftBeaconProc_Main(wk);
  }
  /* MYSTERYGIFT_SEQ_WAIT_FADE  MYSTERYGIFT_SEQ_WAIT_RETURN */
  MysteryLib_RequestFade(WIPE_TYPE_FADEOUT, MYSTERYGIFT_SEQ_GO_LOOKCARD, wk->seq, MYSTERYGIFT_SEQ_WAIT_FADE);
  return -1;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	ԍŏ̑IʂŁu߂vI
 * @param	NONE
 * @return	̃V[PXԍ
 */
//--------------------------------------------------------------------------------------------
static int TopMainMenuRetire(PROC *proc)
{
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  /* r[R擾łΏI */
  if(wk->beacon_seq == MYSTERYGIFT_BEACON_SEQ_TIMER)
    wk->beacon_wait = 1;

  /* MYSTERYGIFT_SEQ_WAIT_FADE  MYSTERYGIFT_SEQ_WAIT_RETURN */
  MysteryLib_ChangeFadeType(1);
  MysteryLib_RequestFade(WIPE_TYPE_FADEOUT, MYSTERYGIFT_SEQ_RETURN, wk->seq, MYSTERYGIFT_SEQ_WAIT_FADE);
  return -1;
}


//--------------------------------------------------------------------------------------------



//--------------------------------------------------------------------------------------------
/**
 * @brief	BG
 * @param	none
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgInitSub(GF_BGL_INI *ini, int frame, u32 scrbase, u32 scrchar)
{
  GF_BGL_BGCNT_HEADER MBg_Data = {
    0, 0, 0x800, 0,
    GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
    GX_BG_SCRBASE_0xe000, GX_BG_CHARBASE_0x00000,
    GX_BG_EXTPLTT_01, 0, 0, 0, FALSE
  };
  MBg_Data.screenBase = scrbase / 0x0800;
  MBg_Data.charBase = scrchar / 0x4000;
  GF_BGL_BGControlSet(ini, frame, &MBg_Data, GF_BGL_MODE_TEXT );
  GF_BGL_ScrClear(ini, frame);
}
static void BgInit( GF_BGL_INI * ini )
{
  /* BG SYSTEM */
  GF_BGL_SYS_HEADER BGsys_data = { GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D };
  GF_BGL_InitBG( &BGsys_data );
  BgInitSub(ini, GF_BGL_FRAME0_M, 0xF000, 0x0000); /* MAIN DISP BG0 */
  BgInitSub(ini, GF_BGL_FRAME1_M, 0xF800, 0x8000); /* MAIN DISP BG1 */
  BgInitSub(ini, GF_BGL_FRAME0_S, 0x3800, 0x0000); /* SUB DISP BG0 */
  BgInitSub(ini, GF_BGL_FRAME1_S, 0x7800, 0x4000); /* SUB DISP BG1 */
}


//------------------------------------------------------------------
/**
 * @brief	wiOtBbNX̓o^
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void CreateBgScreenSub(GF_BGL_INI * ini)
{
  // Tuʂafpbg]
  ArcUtil_PalSet(ARC_MYSTERY_GRA, NARC_mystery_fusigi_bg_00_nclr, PALTYPE_SUB_BG, 16*2*8, 16*2, HEAPID_MYSTERYGIFT);
  // TuBG1L]
  ArcUtil_BgCharSet(ARC_MYSTERY_GRA, NARC_mystery_fusigi_bg_00_lz_ccgr, ini,
		    GF_BGL_FRAME1_S, 0, 10*16*0x20, 1, HEAPID_MYSTERYGIFT);
  // TuʃXN[P
  ArcUtil_ScrnSet(ARC_MYSTERY_GRA, NARC_mystery_fusigi_bg_00_lz_cscr, ini,
		  GF_BGL_FRAME1_S, 0, 32*24*2, 1, HEAPID_MYSTERYGIFT);
  GF_BGL_ScrPalChange(ini, GF_BGL_FRAME1_S, 0, 0, 32, 24, 8);
  GF_BGL_LoadScreenReq(ini, GF_BGL_FRAME1_S);
}

static void CreateBgScreen(GF_BGL_INI * ini)
{
  // Cʂafpbg]
  ArcUtil_PalSet(ARC_MYSTERY_GRA, NARC_mystery_fusigi_bg_00_nclr, PALTYPE_MAIN_BG, 16*2*8, 16*2, HEAPID_MYSTERYGIFT);
  // CBG1L]
  ArcUtil_BgCharSet(ARC_MYSTERY_GRA, NARC_mystery_fusigi_bg_00_lz_ccgr, ini,
		    GF_BGL_FRAME1_M, 0, 10*16*0x20, 1, HEAPID_MYSTERYGIFT);
  // CʃXN[P
  ArcUtil_ScrnSet(ARC_MYSTERY_GRA, NARC_mystery_fusigi_bg_00_lz_cscr, ini,
		  GF_BGL_FRAME1_M, 0, 32*24*2, 1, HEAPID_MYSTERYGIFT);
  GF_BGL_ScrPalChange(ini, GF_BGL_FRAME1_M, 0, 0, 32, 24, 8);
  GF_BGL_LoadScreenReq(ini, GF_BGL_FRAME1_M);

  // ʂ̊iq͗l
  CreateBgScreenSub(ini);
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	j[o^ėp֐
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
static void CreateWindowMenuData(PROC *proc, LISTDATA *ld, int num, GF_BGL_BMPWIN *win, u32 msg)
{
  int i;
  BMPLIST_HEADER list_h;
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  if(wk->bmd)	BMP_MENULIST_Delete(wk->bmd);
  /* j[̕o^ */
  wk->bmd = BMP_MENULIST_Create(num,HEAPID_MYSTERYGIFT);
  wk->msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_mystery_dat, HEAPID_MYSTERYGIFT);
  for(i = 0; i < num; i++)
    BMP_MENULIST_AddArchiveString(wk->bmd, wk->msgman, ld[i].id, ld[i].param);
  MSGMAN_Delete(wk->msgman);
  /* desc쐬  ύX  o^ */
  list_h = MenuListHeader;
  list_h.list = wk->bmd;
  list_h.count = list_h.line = num;
  list_h.win = win;
  if(wk->lw) 	BmpListExit(wk->lw, NULL, NULL);
  wk->lw = BmpListSet( &list_h, 0, 0, HEAPID_MYSTERYGIFT);
  /* bZ[WEBhEɃbZ[W\ */
  if(msg != -1)
    DisplaySequence(proc, &wk->msgwin, msg);
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	j[\
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
static void CreateMenuWindow(PROC *proc, int base, u32 msg)
{
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);
  GF_BGL_BMPWIN *win;
  LISTDATA ld[4];
  int i, index = 0;
  FUSHIGI_DATA *fdata = SaveData_GetFushigiData(wk->sv);
  win = &wk->selwin[MYSTERYGIFT_WIN_MAIN];
  // Kvȃj[݂̂Rs[
  ld[index++] = TopMainMenu_MenuData1[0];
  if(FUSHIGIDATA_IsExistsCardAll(fdata))
    ld[index++] = TopMainMenu_MenuData1[1];
  ld[index++] = TopMainMenu_MenuData1[2];
  // EBhEo^
  if(win->ini == NULL)
    GF_BGL_BmpWinAdd(wk->bgl, win, GF_BGL_FRAME0_M, 8,  7, 16, index*2, FONT_PALNO_NORMAL, base);
  // ----------------------------------------------------------------------------
  // localize_spec_mark(LANG_ALL) imatake 2007/01/10
  // EBhE̘g`悪x̂C
  // EBhE\
  BmpMenuWinWrite(win, WINDOW_TRANS_OFF, MYSTERYGIFT_FRAMECHR2, WAKU_PALETTE_NUMBER2);
  // j[쐬
  CreateWindowMenuData(proc, ld, index, win, msg);
  // ----------------------------------------------------------------------------
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	EBhEփbZ[W̕\
 * @param	proc	vZXւ̃|C^
 * @param	msgid	bZ[WID
 */
//--------------------------------------------------------------------------------------------
static void DisplaySequence(PROC *proc, GF_BGL_BMPWIN *win, u32 msgid)
{
  STRBUF * msg;
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  wk->msgman = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_mystery_dat, HEAPID_MYSTERYGIFT);
  wk->word = WORDSET_Create(HEAPID_MYSTERYGIFT);

  /*EBhEghԂ(F) */
  GF_BGL_BmpWinDataFill(win, FontHeaderGet(FONT_TALK, FONT_HEADER_B_COLOR));
  if(wk->msg)
    msg = wk->msg;
  else
    msg = MSGDAT_UTIL_AllocExpandString(wk->word, wk->msgman, msgid, HEAPID_MYSTERYGIFT);

  wk->m_id = GF_STR_PrintColor(win, FONT_TALK, msg, 0, 0, wk->msg_wait, MYSTERYGIFT_BLACK, NULL);
  if(wk->msg == NULL)
    STRBUF_Delete(msg);
  /*EBhEg`(bpEBhEgp) */
  BmpTalkWinWrite(win, WINDOW_TRANS_ON, MYSTERYGIFT_FRAMECHR1, WAKU_PALETTE_NUMBER1);
  MSGMAN_Delete(wk->msgman);
  WORDSET_Delete(wk->word);
  wk->msg_wait = MSG_NO_PUT;
}
static void DisplaySequenceDirect(PROC *proc, GF_BGL_BMPWIN *win, STRCODE *msgcode)
{
  STRBUF *msg;

  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  msg = STRBUF_Create( GIFT_DATA_CARD_TITLE_MAX+1, HEAPID_MYSTERYGIFT );
  STRBUF_SetStringCodeOrderLength(msg, msgcode, GIFT_DATA_CARD_TITLE_MAX);
  GF_BGL_BmpWinDataFill(win, FontHeaderGet(FONT_SYSTEM, FONT_HEADER_B_COLOR));
  GF_STR_PrintColor(win, FONT_SYSTEM, msg, 0, 0, MSG_NO_PUT, MYSTERYGIFT_BLACK, NULL);
  BmpMenuWinWrite(win, WINDOW_TRANS_ON, MYSTERYGIFT_FRAMECHR2, WAKU_PALETTE_NUMBER2);
  STRBUF_Delete(msg);
}
static BOOL DisplaySequenceEndCheck(PROC *proc)
{
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);
  if(GF_MSG_PrintEndCheck(wk->m_id) == 0)
      return TRUE;
  return FALSE;
}



//--------------------------------------------------------------------------------------------
/**
 * @brief	j[Is
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
static void DoMenuMain(PROC *proc, int *seq, int (*cfunc)(PROC *))
{
  u32 ret;
  int ret_seq;
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);
  static int (*func)(PROC *);
  
  ret = BmpListMain(wk->lw);
  switch(ret){
  case BMPLIST_NULL:	/* IĂȂ */
    break;
  case BMPLIST_CANCEL:	/* LZꂽ */
    Snd_SePlay(SEQ_SE_DP_SELECT);
    if(cfunc){
      ret_seq = cfunc(proc);
      if(ret_seq != -1)
	*seq = ret_seq;
    }
    break;
  default:		/* 肳ꂽ */
    Snd_SePlay(SEQ_SE_DP_SELECT);
    if(ret){
      func = (static int (*)(PROC *))ret;
      ret_seq = func(proc);
      if(ret_seq != -1)
	*seq = ret_seq;
    }
    break;
  }
}


//--------------------------------------------------------------------------------------------
// ȉAgݍ킹Ȃ֐\


//------------------------------------------------------------------
/**
 * @brief	OtBbNXf[^
 */
//------------------------------------------------------------------
static BOOL MysteryGift_InitGraphicsData(PROC *proc, MYSTERYGIFT_WORK *wk)
{
  int type;

  MSG_PrintInit();
  /* bZ[W̃tHgJ[ݒ */
  SystemFontPaletteLoad( PALTYPE_MAIN_BG, FONT_PALNO_NORMAL * 32, HEAPID_MYSTERYGIFT);
  SystemFontPaletteLoad( PALTYPE_MAIN_BG, FONT_PALNO_SELECT * 32, HEAPID_MYSTERYGIFT);
  /*EBhEgLApbgZbg */
  type = CONFIG_GetWindowType(wk->cfg);
  TalkWinGraphicSet(wk->bgl, GF_BGL_FRAME0_M, MYSTERYGIFT_FRAMECHR1, WAKU_PALETTE_NUMBER1, type, HEAPID_MYSTERYGIFT);
  MenuWinGraphicSet(wk->bgl, GF_BGL_FRAME0_M, MYSTERYGIFT_FRAMECHR2, WAKU_PALETTE_NUMBER2, 1, HEAPID_MYSTERYGIFT);
  /* ߂ȂR[h(pbgOJ[O̐Fł) */
  *((u16 *)HW_BG_PLTT) = RGB(12, 12, 31);
  /* bZ[W\EBhE */
  if(!GF_BGL_BmpWinAddCheck(&wk->msgwin))
    GF_BGL_BmpWinAdd(wk->bgl, &wk->msgwin, GF_BGL_FRAME0_M, 2, 19, 27, 4, FONT_PALNO_NORMAL, MYSTERYGIFT_WINDOWCHR);
  DisplaySequence(proc, &wk->msgwin, mystery_01_001); /* uӂȁ@́@ց@悤Iv */
  /* j[\EBhE uӂȁ@́@ց@悤Iv */
  CreateMenuWindow(proc, MYSTERYGIFT_TOPMENUCHR, mystery_01_001);
  CreateBgScreen(wk->bgl);
  return TRUE;
}


//------------------------------------------------------------------
/**
 * @brief	WiFi_E[hC
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
extern int WifiMysteryGift_Main(PROC *proc, int *seq);
static void WiFi_MysteryGitft_Main(PROC *proc, int *seq)
{
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  switch(WifiMysteryGift_Main(proc, &wk->wifi_dl_seq)){
  case ND_RESULT_EXECUTE:		// s
    break;
  case ND_RESULT_COMPLETE:		// _E[hI
    memcpy(&wk->gift_data, wk->filebuffer, sizeof(GIFT_COMM_PACK));
    SetTimeWaitIcon(wk, FALSE);
    wk->from_seq = MYSTERYGIFT_WIFI_DOWNLOAD_MAIN;
    *seq = MYSTERYGIFT_SEQ_AGB_START_CHILD;
    /* V[PXύX */
    break;
  case ND_RESULT_NOT_FOUND_FILES:	// t@CȂ
  case ND_RESULT_DOWNLOAD_CANCEL:	// [U[LZꂽ
    SetTimeWaitIcon(wk, FALSE);
    *seq = MYSTERYGIFT_SEQ_SEND_RECV_CANCEL_INIT;
    break;
  case ND_RESULT_DOWNLOAD_ERROR:	// Ȃ炩̃G[N
    GF_BGL_BmpWinOff(&wk->wifiwin);
    GF_BGL_BmpWinDel(&wk->wifiwin);
    GF_BGL_ScrClear(wk->bgl, GF_BGL_FRAME0_M);
    /* Cj[\ */
    Snd_SePlay(SEQ_SE_DP_SELECT);
    CreateMenuWindow(proc, MYSTERYGIFT_TOPMENUCHR, mystery_01_001);
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/04/27
// ʐMG[ɎMxACRĂ܂̂C
#if AFTER_MASTER_070426_WIFIICON_N81_EUR_FIX
      GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ,  VISIBLE_ON);	//OBJʂnm
#endif
// ----------------------------------------------------------------------------
    *seq = MYSTERYGIFT_SEQ_MAIN;
    break;
  }
}

//------------------------------------------------------------------
/**
 * @brief	Wi-FiŒʐM֕As\ȃG[Nꍇ̏
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
void WifiMysteryGift_ErrorDisp(MYSTERYGIFT_WORK *wk)
{
  WORDSET *word;
  MYSTERY_WIN mw;
  int msg;

  if(wk->wifi_errmsg != -1)	msg = dwc_error_0001 + wk->wifi_errmsg;
  else				msg = dwc_error_0012;

  // OBJʂ͔\
  GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_OFF);
  // XN[NAāc
  GF_BGL_ScrClear(wk->bgl, GF_BGL_FRAME0_M);
  // G[ԍwordփZbg
  word = WORDSET_Create(HEAPID_MYSTERYGIFT);
  WORDSET_RegisterNumber(word, 0, wk->wifi_errcode, 5, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT);
  // EBhEĕ\
  MysteryLib_WinInit1(&mw, &wk->wifiwin, FONT_PALNO_SELECT, NARC_msg_wifi_system_dat, MYSTERYGIFT_FRAMECHR2, WAKU_PALETTE_NUMBER2);
  MysteryLib_WinInit2(&mw, 24, 16, 100);
  MysteryLib_WinInit3(&mw, MYSTERYLIB_WINTYPE_NORMAL, FONT_TALK);
  mw.word = word;
  MysteryLib_CreateWin(wk->bgl, &mw, 4, 4, msg);
  WORDSET_Delete(word);
}


//------------------------------------------------------------------
/**
 * @brief	zB܂̓J[htł̂󂯎Ȃ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static int MysteryGift_FullError(PROC *proc)
{
  int msg;
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  if(wk->gift_error == COMMMYSTERYFUNC_ERROR_FULLGIFT)		msg = mystery_err_001;
  else if(wk->gift_error == COMMMYSTERYFUNC_ERROR_FULLCARD)	msg = mystery_err_005;
  else if(wk->gift_error == COMMMYSTERYFUNC_ERROR_HAVE)		msg = mystery_err_002;
  else if(wk->gift_error == COMMMYSTERYFUNC_ERROR_VERSION)	msg = mystery_err_007;
  else if(wk->gift_error == COMMMYSTERYFUNC_ERROR_GROUNDCHILD){
    msg = mystery_01_010;
    return MysteryGif_DisplayMessage(proc, &wk->msgwin, msg, MYSTERYGIFT_SEQ_GROUNDCHILD_CHECK);
  }
  
  return MysteryGif_DisplayMessage(proc, &wk->msgwin, msg, MYSTERYGIFT_SEQ_RETURN_TOPMENU);
}


//------------------------------------------------------------------
/**
 * @brief	sXVtbZ[W̕\
 * @param	NONE
 * @return	NONE
 * \ wk->msg_next_seq ɏĨV[PXĂ
*/
//------------------------------------------------------------------
static int MysteryGif_DisplayMessage(PROC *proc, GF_BGL_BMPWIN *win, int msgid, int next_seq)
{
  WORDSET *word;
  MSGDATA_MANAGER *msgman;
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  if(win && msgid){
    // \I܂msgobt@ۏႹ˂΂ȂȂ
    msgman = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_mystery_dat, HEAPID_MYSTERYGIFT);
    word = WORDSET_Create(HEAPID_MYSTERYGIFT);
    wk->msg = MSGDAT_UTIL_AllocExpandString(word, msgman, msgid, HEAPID_MYSTERYGIFT);
    wk->msg_wait = 1;
    // \
    DisplaySequence(proc, win, msgid);
    wk->msg_next_seq = next_seq;
    // gȂȂobt@͊J
    WORDSET_Delete(word);
    MSGMAN_Delete(msgman);

  } else {
    if(GF_MSG_PrintEndCheck(wk->m_id) == 0){
      // \IJ
      STRBUF_Delete(wk->msg);
      wk->msg = NULL;
      wk->msg_wait = 0;
      return wk->msg_next_seq;
    }
  }
  return MYSTERYGIFT_SEQ_DISP_MSG;
}


//------------------------------------------------------------------
/**
 * @brief	G[NۂɒʐM؂鏈
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void CommDisconnect(MYSTERYGIFT_WORK *wk)
{
  switch(wk->comm_type){
  case MYSTERYCOMM_TYPE_NULL:
    break;
  case MYSTERYCOMM_TYPE_DIRECT:		// _CNgʐM
    CommMysteryExitGift();
    WirelessIconEasyEnd(); // ʐMACR폜
    break;
  case MYSTERYCOMM_TYPE_AGBCARTRIDGE:	// `fãJ[gbW_E[h
    break;
  case MYSTERYCOMM_TYPE_BEACON:		// r[R_E[h
    break;
  case MYSTERYCOMM_TYPE_WIFI:		// Wi-Fĩ_E[h
    break;
  }
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXF
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT MysteryGiftProc_Init(PROC * proc, int * seq)
{
  MYSTERYGIFT_WORK *wk;

#if 0//def DEBUG_ONLY_FOR_mituhara
  OS_TPrintf("sizeof(GIFT_BEACON)     = %3d\n", sizeof(GIFT_BEACON));
  //  OS_TPrintf("sizeof(GIFT_BEACON_CRC) = %3d\n", sizeof(GIFT_BEACON_CRC));
  OS_TPrintf("sizeof(POKEMON_PARAM)   = %3d\n", PokemonParam_GetWorkSize());
  OS_TPrintf("sizeof(GIFT_PRESENT)    = %3d\n", sizeof(GIFT_PRESENT));
#endif
  
  MysteryGiftSetProcp(proc);
  /* [NGATITLE_STARTMENȔɍ쐬(̏Ԃ͖Ȃ͂) */
  sys_CreateHeap( HEAPID_BASE_APP, HEAPID_MYSTERYGIFT, 0x30000);
  wk = PROC_AllocWork(proc, sizeof(MYSTERYGIFT_WORK), HEAPID_MYSTERYGIFT);
  /* sǂ|̂Ń[N̓[NA */
  memset(wk, 0, sizeof(MYSTERYGIFT_WORK));
  
  /* eϐ̏ */
  wk->bgl = GF_BGL_BglIniAlloc(HEAPID_MYSTERYGIFT);
  GF_Disp_GX_VisibleControlInit();
  GF_Disp_GXS_VisibleControlInit();
  CommMysteryFunc_VramBankSet();
  BgInit(wk->bgl);

  /* ʂ̏ݒ */
  WIPE_SetBrightness( WIPE_DISP_MAIN, WIPE_FADE_BLACK );
  WIPE_SetBrightness( WIPE_DISP_SUB, WIPE_FADE_BLACK );

  /* TEhf[^[h */
  Snd_DataSetByScene( SND_SCENE_HUSIGI, SEQ_PRESENT, 1 );

  /* AGB̃_E[hǂ̃tOݒ */
  // ----------------------------------------------------------------------------
  // localize_spec_mark(LANG_ALL) imatake 2007/01/15
  // Crypto CuŃmۂq[vݒ
  SetAgbCartridgeHeapID(HEAPID_MYSTERYGIFT);
  // ----------------------------------------------------------------------------
  if(GetAgbCartridgeDataSize()){
    wk->comm_type = MYSTERYCOMM_TYPE_AGBCARTRIDGE;
    sys_InitAgbCasetteVer(CasetteVersion);
    MysteryLib_SetAgbCartridgeIntr(TRUE);	/* AGBJ[gbW̔oON */
  }
  /* r[R擾V[PX */
  wk->beacon_seq = MYSTERYGIFT_BEACON_SEQ_WAIT;
  wk->sv = ((MAINWORK *)PROC_GetParentWork(proc))->savedata;
  wk->cfg = SaveData_GetConfig(wk->sv);

  wk->msg_wait = MSG_NO_PUT;

#if 0//def DEBUG_ONLY_FOR_mituhara
  {
    POKEMON_PARAM *pp = PokeParty_GetMemberPointer(SaveData_GetTemotiPokemon(wk->sv), 0);
    u32 adrs = (u32)pp + PokemonParam_GetWorkSize();
    OS_TPrintf("POKEMON_PARAM: %08X - %08X\n", pp, adrs);
  }
#endif
  sys_CreateHeap( HEAPID_BASE_SYSTEM, HEAPID_COMMICON, 0x300 );
  
  return PROC_RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXFC
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT MysteryGiftProc_Main(PROC * proc, int * seq)
{
  u32 ret, value;
  GIFT_DELIVERY *deli;
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  CTRDG_IsExisting();

  //  OS_TPrintf("seq = %d\n", *seq);
  
  // r[R擾V[PX
  if(wk->beacon_seq != MYSTERYGIFT_BEACON_SEQ_WAIT)
    MysteryGiftBeaconProc_Main(wk);
  
  switch(*seq){
  case MYSTERYGIFT_SEQ_INIT:
    /* Cu */
    MysteryLib_Init(HEAPID_MYSTERYGIFT);
    wk->seq = seq;
    *seq = MYSTERYGIFT_SEQ_CREATE_SCREEN;
    break;

  case   MYSTERYGIFT_SEQ_CREATE_SCREEN:
    /* ʍ쐬 */
    MysteryGift_InitGraphicsData(proc, wk);
    InitCellActor(wk);
    /* tF[hC */
    MysteryLib_RequestFade(WIPE_TYPE_FADEIN, MYSTERYGIFT_SEQ_MAIN, seq, MYSTERYGIFT_SEQ_WAIT_FADE);
#if 0
    // r[R͏EȂĂǂȂ܂
    wk->beacon_seq = MYSTERYGIFT_BEACON_SEQ_INIT;
#endif
    break;

  case MYSTERYGIFT_SEQ_WAIT_FADE:
    // tF[hI܂ő҂Ď̃V[PX
    MysteryLib_FadeEndCheck(seq);
    break;

  case MYSTERYGIFT_SEQ_MAIN:
    /* gbvj[̃C[v */
    DoMenuMain(proc, seq, TopMainMenuRetire);
    break;

  case MYSTERYGIFT_SEQ_RECV:
    /* ʐM肷EBhẼC[v */
    DoMenuMain(proc, seq, CommTypeMenuRetire);
    break;

  case MYSTERYGIFT_SEQ_DIRECT_YESNO:
    /* _CNgőu͂^ṽC[v */
    DoMenuMain(proc, seq, CommDirectMenuNo);
    break;



//--------------------------------------------------------------------------------------------

    // WiFi_E[h̏

  case MYSTERYGIFT_WIFI_DOWNLOAD_MAIN:
    WiFi_MysteryGitft_Main(proc, seq);
    break;


//--------------------------------------------------------------------------------------------

    // r[R_E[h̏

  case MYSTERYGIFT_BEACON_DOWNLOAD_WAIT_TITLE:
    // event_nameĂ̂҂
    MysteryGift_BeaconMainLoop(wk);
    // r[REȉ̏֐iށB_E[ĥ͑čs
    // ÍɔASẴf[^_E[hĂ珈悤ɕύX
    if(s_state == BEACON_STATE_SUCCESS){
      // ^CACR
      SetTimeWaitIcon(wk, FALSE);
      // r[R{̃[NGAɃRs[ۑ
      CommSetSaveData(proc);

      // 󂯎r[R̃G[𒲂ׂĂ
      wk->gift_error = CommMysteryFunc_CheckGetGift(wk->sv, &wk->gift_data);
      // 󂯎苖̂qnlo[WƈقȂĂ󂯎Ȃ
      if(wk->gift_error == COMMMYSTERYFUNC_ERROR_VERSION){
	SetTimeWaitIcon(wk, FALSE);	// 	^CACR
	*seq = MYSTERYGIFT_ERROR_FULL;
      } else {

	if(!GF_BGL_BmpWinAddCheck(&wk->upwin))
	  GF_BGL_BmpWinAdd(wk->bgl, &wk->upwin, GF_BGL_FRAME0_M, 3, 2, 26, 4, FONT_PALNO_NORMAL, MYSTERYGIFT_UPWINCHR);

	// ŎM^Cg\
	DisplaySequenceDirect(proc, &wk->upwin, bsdown_c_fileheader());
	DisplaySequence(proc, &wk->msgwin, mystery_01_005);
	/* u͂^vj[̍쐬 */
	CreateBeaconCommYesNoMenu(proc);
	*seq = MYSTERYGIFT_BEACON_DOWNLOAD_YESNO;
      }
    }
    // LZ
    if(s_state == BEACON_STATE_CANCEL || s_state == BEACON_STATE_CRCERROR){
      MysteryGift_BeaconCancel();
      *seq = MYSTERYGIFT_SEQ_SEND_RECV_CANCEL_INIT;
    }
    break;

  case MYSTERYGIFT_BEACON_DOWNLOAD_YESNO:
    // û@サ񂵂܂vu͂^v
    DoMenuMain(proc, seq, CommChildRecvBeaconCancel);
    MysteryGift_BeaconMainLoop(wk);
    break;

  case MYSTERYGIFT_BEACON_DOWNLOAD:
    // _E[h͂łɏIĂ
    // ŉʂ̍XV(󂯎Aj[Vǉ)
    //    SetBaseIcon(wk, -1);
    deli = CommSetSaveData(proc);
    MysteryLib_InitGift(wk->bgl, deli);
    SetTimeWaitIcon(wk, TRUE);
    /* ŃZ[uĂ݂悤 */
    CommChildSaveRecvData(proc);
    *seq = MYSTERYGIFT_BEACON_DOWNLOAD_WAITSAVE;
    break;

  case MYSTERYGIFT_BEACON_DOWNLOAD_WAITSAVE:
    if(MysteryLib_GetSaveStatus() == MYSTERYLIB_SEQ_SAVE_LAST)
      MysteryLib_DoLastSave();
    if(MysteryLib_GetSaveStatus() == MYSTERYLIB_SEQ_SAVE_OK){
      SetTimeWaitIcon(wk, FALSE);
      SetBaseIcon(wk, -1);
      Snd_SePlay( SEQ_SE_DP_UG_020 );
      /* ̂@Ƃ܂I\nthB@Vbv@\n͂@@ƂĂˁI */
      *seq = MysteryGif_DisplayMessage(proc, &wk->msgwin, mystery_01_009, MYSTERYGIFT_SEQ_LOOP);

    } else if(MysteryLib_GetSaveStatus() == MYSTERYLIB_SEQ_SAVE_NG){
      SetBaseIcon(wk, -1);
      /* Z[uG[̎̏ */
      wk->gift_data.beacon.have_card = 0;	// J[hʂ͕\Ȃ
      *seq = MysteryGif_DisplayMessage(proc, &wk->msgwin, mystery_err_006, MYSTERYGIFT_SEQ_LOOP);
    }
    break;

    
  case MYSTERYGIFT_BEACON_DOWNLOAD_CANCEL:
    // LZI܂ő҂܂
    MysteryGift_BeaconMainLoop(wk);
    if(s_state == BEACON_STATE_CANCEL || s_state == BEACON_STATE_SUCCESS || s_state == BEACON_STATE_CRCERROR){
      if(s_state == BEACON_STATE_CANCEL)
	MysteryGift_BeaconCancel();
      // LZI
      *seq = CommDirectCommMenuNo(proc);
    }
    break;


//--------------------------------------------------------------------------------------------


#ifdef PARENT_TEST
    // ܂łeXgp̐e@łB
    // ʐMX^[gƂ͂`{^Ă
    // a{^ΉqĂ邩m邱Ƃł܂
  case MYSTERYGIFT_SEQ_START_PARENT:
    // e@ƂĒʐMJn
    if(CommIsConnect(COMM_PARENT_ID)){
      CommMPSetBeaconTempData(&wk->gift_data.beacon);
      if(sys.trg & PAD_BUTTON_CANCEL){
	Snd_SePlay(SEQ_SE_DP_SELECT);
#ifdef DEBUG_ONLY_FOR_mituhara
	OS_Printf("qĂq̐: %d\n", CommMysteryGetCommChild());
#endif
      }
      if(sys.trg & PAD_BUTTON_DECIDE){
	Snd_SePlay(SEQ_SE_DP_SELECT);
	//	wk->sync_wait = 1;
	CommTimingSyncStart(MYSTERYGIFT_SYNC_CODE);
	*seq = MYSTERYGIFT_SEQ_SYNC_CHILD_TIMING;
#ifdef DEBUG_ONLY_FOR_mituhara
	OS_Printf("MJn\n");
#endif
      }
    }
    break;

  case MYSTERYGIFT_SEQ_SYNC_CHILD_TIMING:
    if(CommIsTimingSync(MYSTERYGIFT_SYNC_CODE) == TRUE){
      *seq = MYSTERYGIFT_SEQ_SYNC_CHILD_PARENT;
    }
    break;
    
  case MYSTERYGIFT_SEQ_SYNC_CHILD_PARENT:
    //    if(--wk->sync_wait == 0){
      /* Ńf[^̑MJn(wk->gift_dataɃf[^󂯂) */
      MysteryLib_CreateCryptoData(&wk->gift_data, &wk->comm_data, HEAPID_MYSTERYGIFT);
      CommMysterySendGiftDataParent((const void *)&wk->comm_data, sizeof(GIFT_DATA));
      *seq = MYSTERYGIFT_SEQ_SENDDATA_PARENT;
      //    }
    break;

  case MYSTERYGIFT_SEQ_SENDDATA_PARENT:
    if(CommMysteryGiftGetRecvCheck() == TRUE){
      CommMysteryExitGift();
#ifdef DEBUG_ONLY_FOR_mituhara
      OS_Printf("ʐMɏI܂I\n");
#endif
      *seq = MYSTERYGIFT_SEQ_LOOP;
    }
    
    break;

#endif	// PARENT_TEST



//--------------------------------------------------------------------------------------------


    


  case MYSTERYGIFT_SEQ_START_CHILD:
    //    WirelessIconEasy_SetLevel(WM_LINK_LEVEL_3 - WM_GetLinkLevel());
    /* q@ƂĒʐMJn */
    if((wk->connectIndex = CommMysteryCheckParentBeacon(wk)) != -1){
      SetTimeWaitIcon(wk, FALSE);	// ^CACR
      // r[R̃G[`FbN̂ݍs
      // q@̏ꍇ́A󂯎o[WĂG[\悤ɂ
      wk->gift_error = CommMysteryFunc_CheckGetGift(wk->sv, &wk->gift_data);
      // r[Rɖߍ܂Ă^Cg\
      if(!GF_BGL_BmpWinAddCheck(&wk->upwin))
	GF_BGL_BmpWinAdd(wk->bgl, &wk->upwin, GF_BGL_FRAME0_M, 3, 2, 26, 4, FONT_PALNO_NORMAL, MYSTERYGIFT_UPWINCHR);
      DisplaySequenceDirect(proc, &wk->upwin, wk->gift_data.beacon.event_name);
      DisplaySequence(proc, &wk->msgwin, mystery_01_005);
      /* u͂^vj[̍쐬 */
      CreateDirectCommYesNoMenu(proc, 0);
      *seq = MYSTERYGIFT_SEQ_RECV_YESNO_CHILD;
    }
    /* LZ */
    if((sys.trg & PAD_BUTTON_CANCEL) || (--wk->timeout == 0)){
      SetTimeWaitIcon(wk, FALSE);	// ^CACR
      CommMysteryExitGift();
      WirelessIconEasyEnd();		// ʐMACR폜
      *seq = MYSTERYGIFT_SEQ_SEND_RECV_CANCEL_INIT;
    }
    break;

  case MYSTERYGIFT_SEQ_RECV_YESNO_CHILD:
    /* ú@́@@サ@܂Hv́u͂^vI */
#if 0
    DoMenuMain(proc, seq, CommDirectMenuNo);
#else
    DoMenuMain(proc, seq, CommDirectCommMenuNo);
#endif
    break;

  case MYSTERYGIFT_SEQ_REQEST_CHILD:
    /* e@̑M҂ */
    value = CommGetCurrentID();
    if(value != COMM_PARENT_ID && CommIsConnect(value)){
      if(CommIsTimingSync(MYSTERYGIFT_SYNC_CODE) == TRUE){
	SetTimeWaitIcon(wk, FALSE);
	CommStateSetErrorCheck(TRUE,TRUE);
	/* ́@@サ񂿂イ@ł
	   ł񂰂@ȂŁ@cc */
	DisplaySequence(proc, &wk->msgwin, mystery_01_008);
#if 0//def DEBUG_ONLY_FOR_mituhara
	OS_Printf("e@瑗MJn܂I\n");
#endif
	SetBaseIcon(wk, 1);
	SetTimeWaitIcon(wk, TRUE);
	wk->timeout = 60*10;
	*seq = MYSTERYGIFT_SEQ_RECV_WAIT_CHILD1;
      }
    } else if(value != COMM_PARENT_ID && CommIsConnect(value) == 0){
      /* eƂ̒ʐMƂ܂Ă܂u݋ہvƂ݂Ȃ */
      CommMysteryExitGift();
      WirelessIconEasyEnd(); // ʐMACR폜
      SetBaseIcon(wk, -1);
      SetTimeWaitIcon(wk, FALSE);
      *seq = MYSTERYGIFT_SEQ_SEND_RECV_REFUSAL;
      break;
    }
    /* LZ */
    if((sys.trg & PAD_BUTTON_CANCEL) || (--wk->timeout == 0)){
      CommMysteryExitGift();
      WirelessIconEasyEnd(); // ʐMACR폜
      SetBaseIcon(wk, -1);
      SetTimeWaitIcon(wk, FALSE);
      *seq = MYSTERYGIFT_SEQ_SEND_RECV_CANCEL_INIT;
    }
    break;

  case MYSTERYGIFT_SEQ_RECV_WAIT_CHILD1:
    /* e@f[^MI܂ő҂ */
    if(CommMysteryCheckRecvData()){
      *seq = MYSTERYGIFT_SEQ_RECV_WAIT_CHILD2;
    }
    /* LZ */
    value = CommGetCurrentID();
    if((sys.trg & PAD_BUTTON_CANCEL) || (--wk->timeout == 0) || (value != COMM_PARENT_ID && CommIsConnect(value) == 0)){
      SetTimeWaitIcon(wk, FALSE);
      CommMysteryExitGift();
      WirelessIconEasyEnd(); // ʐMACR폜
      *seq = MYSTERYGIFT_SEQ_SEND_RECV_CANCEL_INIT;
    }

    break;

  case MYSTERYGIFT_SEQ_RECV_WAIT_CHILD2:
#if 0//def DEBUG_ONLY_FOR_mituhara
    OS_Printf("󂯎mFł܂I\n");
#endif
    // ŉʂ̍XV(󂯎Aj[Vǉ)
    deli = CommSetSaveData(proc);
    MysteryLib_InitGift(wk->bgl, deli);
    CommStateSetErrorCheck(FALSE,FALSE);
    /* ŃZ[uĂ݂悤 */
    CommChildSaveRecvData(proc);
    *seq = MYSTERYGIFT_SEQ_RECV_WAIT_CHILD3;
    break;

  case MYSTERYGIFT_SEQ_RECV_WAIT_CHILD3:
    // e@Ƃ̒ʐM؂ꂽZ[us
    value = CommGetCurrentID();
    if(value != COMM_PARENT_ID && CommIsConnect(value) == 0){
      CommMysteryExitGift();
      // ʐMؒf
      wk->save_cancel = TRUE;
      MysteryLib_CancelSaveDSCard();
      SetTimeWaitIcon(wk, FALSE);
      WirelessIconEasyEnd(); // ʐMACR폜
      SetBaseIcon(wk, -1);
      *seq = MYSTERYGIFT_SEQ_RECV_WAIT_CHILD31;
      break;
    }
    // Z[u҂
    if(MysteryLib_GetSaveStatus() == MYSTERYLIB_SEQ_SAVE_LAST){
      // e@Ɠ
      CommTimingSyncStart(MYSTERYGIFT_SYNC_CODE2);
      *seq = MYSTERYGIFT_SEQ_RECV_WAIT_CHILD30;
      wk->sync_wait = 120;	// ^CAEgpJE^

    } else if(MysteryLib_GetSaveStatus() == MYSTERYLIB_SEQ_SAVE_NG){
      /* Z[uG[̎̏ */
      MysteryLib_CancelSaveDSCard();
      wk->gift_data.beacon.have_card = 0;	// J[hʂ͕\Ȃ
      SetTimeWaitIcon(wk, FALSE);
      *seq = MysteryGif_DisplayMessage(proc, &wk->msgwin, mystery_err_006, MYSTERYGIFT_SEQ_LOOP);
    }
    break;

  case MYSTERYGIFT_SEQ_RECV_WAIT_CHILD30:
    // e@Ԏ߂ĂZ[u
    if(CommIsTimingSync(MYSTERYGIFT_SYNC_CODE2) == TRUE){
      // Ō̃Z[us
      MysteryLib_DoLastSave();
      wk->sync_wait = 10;
      *seq = MYSTERYGIFT_SEQ_RECV_WAIT_CHILD4;
    } else if(--wk->sync_wait == 0){
      /* Z[uG[̎̏ */
      MysteryLib_CancelSaveDSCard();
      wk->gift_data.beacon.have_card = 0;	// J[hʂ͕\Ȃ
      SetTimeWaitIcon(wk, FALSE);
      *seq = MysteryGif_DisplayMessage(proc, &wk->msgwin, mystery_err_006, MYSTERYGIFT_SEQ_LOOP);
    }
    break;
    
  case MYSTERYGIFT_SEQ_RECV_WAIT_CHILD31:
#if 0//def DEBUG_ONLY_FOR_mituhara
      OS_TPrintf("Z[us\n");
#endif
      //      DisplaySequence(proc, &wk->msgwin, mystery_err_008);
      // ̃EBhE
      CMG_BmpMenuWinClear(&wk->upwin, WINDOW_TRANS_ON);
      wk->gift_data.beacon.have_card = 0;
      *seq = MysteryGif_DisplayMessage(proc, &wk->msgwin, mystery_err_008, MYSTERYGIFT_SEQ_LOOP);
    break;

  case MYSTERYGIFT_SEQ_RECV_WAIT_CHILD4:
    if(--wk->sync_wait == 0){ // || CommMysteryGiftGetRecvCheck() == TRUE){
      // ʐMؒf
      SetTimeWaitIcon(wk, FALSE);
      CommMysteryExitGift();
      WirelessIconEasyEnd(); // ʐMACR폜
      Snd_SePlay( SEQ_SE_DP_UG_020 );
      SetBaseIcon(wk, -1);
#if 0//def DEBUG_ONLY_FOR_mituhara
      OS_Printf("SI\n");
#endif
      /* ̂@Ƃ܂I\nthB@Vbv@\n͂@@ƂĂˁI */
      *seq = MysteryGif_DisplayMessage(proc, &wk->msgwin, mystery_01_009, MYSTERYGIFT_SEQ_LOOP);
    }
    break;

  case MYSTERYGIFT_SEQ_SEND_RECV_REFUSAL:
    /* \݂ۂꂽꍇ̏ */
    Snd_SePlay(SEQ_SE_DP_SELECT);
    // u݁@@Ё@܂v
    DisplaySequence(proc, &wk->msgwin, mystery_err_004);
    // ̃EBhE
    CMG_BmpMenuWinClear(&wk->upwin, WINDOW_TRANS_ON);
    *seq = MYSTERYGIFT_SEQ_SEND_RECV_CANCEL;
    break;
    
    break;
  case MYSTERYGIFT_SEQ_SEND_RECV_CANCEL_INIT:
    // 	^CACR
    SetTimeWaitIcon(wk, FALSE);
    /* LZ̏ */
    Snd_SePlay(SEQ_SE_DP_SELECT);
    // ú@\n݂܂@łv
    DisplaySequence(proc, &wk->msgwin, mystery_err_003);
    // ̃EBhE
    CMG_BmpMenuWinClear(&wk->upwin, WINDOW_TRANS_ON);
    *seq = MYSTERYGIFT_SEQ_SEND_RECV_CANCEL;
    break;
  case MYSTERYGIFT_SEQ_SEND_RECV_CANCEL:

    OS_TPrintf("LZ\n");

    /* [U[ɂLZ */
    if(sys.trg){
      /* Cj[\ */
      Snd_SePlay(SEQ_SE_DP_SELECT);
      CreateMenuWindow(proc, MYSTERYGIFT_TOPMENUCHR, mystery_01_001);
      *seq = MYSTERYGIFT_SEQ_MAIN;
    }
    break;

    

//--------------------------------------------------------------------------------------------
//	`faJ[gbW̃f[^]

  case MYSTERYGIFT_SEQ_AGB_START_CHILD:
    /* r[RփRs[ăj[\ */
    if(wk->from_seq != MYSTERYGIFT_WIFI_DOWNLOAD_MAIN)
      ReadAgbCartridgeData(&wk->gift_data, sizeof(GIFT_COMM_PACK));

#if 0
    // eXg
    wk->gift_data.beacon.version  = 0xFFFFFFFF;
    wk->gift_data.beacon.event_id = 0xFFFF;
#endif

    // ɃXbgñG[`FbN
    wk->gift_error = CommMysteryFunc_CheckGetGift(wk->sv, &wk->gift_data);
    
    // 󂯎苖̂qnlo[WƈقȂĂ󂯎Ȃ
    if(wk->gift_error == COMMMYSTERYFUNC_ERROR_VERSION){
      SetTimeWaitIcon(wk, FALSE);	// 	^CACR
      *seq = MYSTERYGIFT_ERROR_FULL;
    } else {
      if(!GF_BGL_BmpWinAddCheck(&wk->upwin))
	GF_BGL_BmpWinAdd(wk->bgl, &wk->upwin, GF_BGL_FRAME0_M, 3, 2, 26, 4, FONT_PALNO_NORMAL, MYSTERYGIFT_UPWINCHR);
      DisplaySequenceDirect(proc, &wk->upwin, wk->gift_data.beacon.event_name);
      DisplaySequence(proc, &wk->msgwin, mystery_01_005);
      /* u͂^vj[̍쐬 */
      CreateDirectCommYesNoMenu(proc, 0);
      *seq = MYSTERYGIFT_SEQ_AGB_RECV_YESNO_CHILD;
    }
    break;

  case MYSTERYGIFT_SEQ_AGB_RECV_YESNO_CHILD:
    /* ú@́@@サ@܂Hv́u͂^vI */
    DoMenuMain(proc, seq, CommDirectCommMenuNo);
    break;

  case MYSTERYGIFT_SEQ_AGB_RECV_CHECK_CHILD:
    /* Mł邩ǂ̃`FbN */
    *seq = MYSTERYGIFT_SEQ_AGB_REQEST_CHILD;
    break;
    
  case MYSTERYGIFT_SEQ_AGB_REQEST_CHILD:
    // ŉʂ̍XV(󂯎Aj[Vǉ)
    deli = CommSetSaveData(proc);
    MysteryLib_InitGift(wk->bgl, deli);
    /* ́@@サ񂿂イ@ł
       ł񂰂@ȂŁ@cc */
    DisplaySequence(proc, &wk->msgwin, mystery_01_008);
    SetBaseIcon(wk, 1);
    SetTimeWaitIcon(wk, TRUE);
    wk->sync_wait = 60;
    *seq = MYSTERYGIFT_SEQ_AGB_RECV_WAIT_CHILD;
    break;

  case MYSTERYGIFT_SEQ_AGB_RECV_WAIT_CHILD:
    /* e@f[^MI܂ő҂ */
    if(--wk->sync_wait == 0){
      /* ŃZ[uĂ݂悤 */
      CommChildSaveRecvData(proc);
      *seq = MYSTERYGIFT_SEQ_AGB_RECV_WAIT_CHILD2;
    }
    break;
  case MYSTERYGIFT_SEQ_AGB_RECV_WAIT_CHILD2:
    // Z[u҂
    if(MysteryLib_GetSaveStatus() == MYSTERYLIB_SEQ_SAVE_LAST)
      MysteryLib_DoLastSave();
    if(MysteryLib_GetSaveStatus() == MYSTERYLIB_SEQ_SAVE_OK){
      wk->sync_wait = 1;
      SetTimeWaitIcon(wk, FALSE);
      SetBaseIcon(wk, -1);
      Snd_SePlay( SEQ_SE_DP_UG_020 );
      /* ̂@Ƃ܂I\nthB@Vbv@\n͂@@ƂĂˁI */
      *seq = MysteryGif_DisplayMessage(proc, &wk->msgwin, mystery_01_009, MYSTERYGIFT_SEQ_AGB_SEND_RECV_FLAG_CHILD);
    } else if(MysteryLib_GetSaveStatus() == MYSTERYLIB_SEQ_SAVE_NG){
      /* Z[uG[̎̏ */
      SetBaseIcon(wk, -1);
      wk->gift_data.beacon.have_card = 0;	// J[hʂ͕\Ȃ
      *seq = MysteryGif_DisplayMessage(proc, &wk->msgwin, mystery_err_006, MYSTERYGIFT_SEQ_LOOP);
    }
    break;

  case MYSTERYGIFT_SEQ_AGB_SEND_RECV_FLAG_CHILD:
    if(--wk->sync_wait == 0){
      wk->sync_wait = 256*256;
      *seq = MYSTERYGIFT_SEQ_LOOP;
    }      
    break;


//--------------------------------------------------------------------------------------------

  case MYSTERYGIFT_ERROR_FULL:
    // ʐM؂鏈(zz`FbN̏ꍇ͐؂Ȃ)
    if(wk->gift_error != COMMMYSTERYFUNC_ERROR_GROUNDCHILD)
      CommDisconnect(wk);

    // zB܂̓J[htŎ󂯎Ȃ
    *seq = MysteryGift_FullError(proc);
    // ͂^̃j[
    CMG_BmpMenuWinClear(&wk->selwin[MYSTERYGIFT_WIN_COMM_DIRECT_YESNO], WINDOW_TRANS_ON);
    break;

  case MYSTERYGIFT_SEQ_DISP_MSG:
    // bZ[W\I܂Ń[v
    *seq = MysteryGif_DisplayMessage(proc, NULL, NULL, *seq);
    break;

  case MYSTERYGIFT_SEQ_RETURN_TOPMENU:
    if(sys.trg){
      /* ̃j[EBhE */
      CMG_BmpMenuWinClear(&wk->upwin, WINDOW_TRANS_ON);
      *seq = CommTypeMenuRetire(proc);
    }
    break;

  case MYSTERYGIFT_SEQ_GROUNDCHILD_CHECK:
    OS_TPrintf("zz`FbN\n");
    /* u͂^vj[̍쐬 */
    CreateDirectCommYesNoMenu(proc, 1);
    *seq = MYSTERYGIFT_SEQ_RECV_YESNO_CHILD;
    wk->gift_error = COMMMYSTERYFUNC_ERROR_NONE;
    break;

    
//--------------------------------------------------------------------------------------------
    
  case MYSTERYGIFT_SEQ_RETURN:
    /* ^Cg̃j[ɖ߂ */
    TopMainMenuFinish(proc);
    wk->to_seq = 0;
    return PROC_RES_FINISH;
    break;

  case MYSTERYGIFT_SEQ_GO_LOOKCARD:
    /* J[hʂ֍s */
    TopMainMenuFinish(proc);
    wk->to_seq = 1;
    return PROC_RES_FINISH;
    break;
    

  case MYSTERYGIFT_SEQ_LOOP:
    /* dneeɂ^J[h񂪂Ε\ */
    if(sys.trg){
      Snd_SePlay(SEQ_SE_DP_SELECT);
      if(wk->gift_data.beacon.have_card == 1){
	MysteryLib_RequestFade(WIPE_TYPE_FADEOUT, MYSTERYGIFT_SEQ_DISP_CARD, wk->seq, MYSTERYGIFT_SEQ_WAIT_FADE);
      } else {
	MysteryLib_ChangeFadeType(1);
	MysteryLib_RequestFade(WIPE_TYPE_FADEOUT, MYSTERYGIFT_SEQ_FADEOUT_RESET, wk->seq, MYSTERYGIFT_SEQ_WAIT_FADE);
      }	
    }
    break;

  case MYSTERYGIFT_SEQ_DISP_CARD:
    // ʂ͊iq͗l𕜊
    CreateBgScreenSub(wk->bgl);
    GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
    GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_ON );
    // ʂ̓J[h̕\
    MysteryCard_DisplayCardOnly(wk->bgl, &wk->gift_data.data.card, HEAPID_MYSTERYGIFT);
    MysteryLib_RequestFade(WIPE_TYPE_FADEIN, MYSTERYGIFT_SEQ_LOOP, wk->seq, MYSTERYGIFT_SEQ_WAIT_FADE);
    wk->gift_data.beacon.have_card = 0;
    break;

  case MYSTERYGIFT_SEQ_FADEOUT_RESET:
    OS_ResetSystem(0);
    break;
  }

  // 펞ł͂Ȃǎs֐͂Ŏs
  if(wk->func_hook)
    wk->func_hook(wk);

  
  // ACR\邽߂ɕKvȋ쓮
  MysteryLib_DoClact();

  return PROC_RES_CONTINUE;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	Z[uf[^̃|C^Ԃ
 * @param	NONE
 * @return	SAVEDATA	Z[uf[^ւ̃|C^
 */
//--------------------------------------------------------------------------------------------
PROC *MyseryGiftGetProcp(void)
{
  return MysteryProc;
}
void MysteryGiftSetProcp(PROC *proc)
{
  MysteryProc = proc;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXFI
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
extern const PROC_DATA MysteryCardProcData;
#define CHECK_OVERLAY
static PROC_RESULT MysteryGiftProc_End(PROC * proc, int * seq)
{
  FS_EXTERN_OVERLAY( title );
#ifdef CHECK_OVERLAY
  FS_EXTERN_OVERLAY( startmenu );
#endif
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);
  if(wk->to_seq == 0){
    Main_SetNextProc( FS_OVERLAY_ID(title), &TitleProcData);
  } else if(wk->to_seq == 1){
#ifdef CHECK_OVERLAY
    Main_SetNextProc( FS_OVERLAY_ID(startmenu), &MysteryCardProcData);
#else
    Main_SetNextProc( NO_OVERLAY_ID, &MysteryCardProcData);
#endif
  }
  sys_DeleteHeap(HEAPID_COMMICON);
  PROC_FreeWork(proc);
  sys_DeleteHeap(HEAPID_MYSTERYGIFT);
  if(wk->comm_type == MYSTERYCOMM_TYPE_AGBCARTRIDGE)
    sys_InitAgbCasetteVer(0);
  MysteryLib_SetAgbCartridgeIntr(FALSE);	/* AGBJ[gbW̔oOFF */

  return PROC_RES_FINISH;
}


//--------------------------------------------------------------------------------------------


//------------------------------------------------------------------
/**
 * @brief	r[R擾V[PX
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
#define BEACON_GATHER_TIME	(2*60)			// r[RW߂鎞
static void MysteryGiftBeaconProc_Main(MYSTERYGIFT_WORK *wk)
{
  int flag;

  switch(wk->beacon_seq){
  case MYSTERYGIFT_BEACON_SEQ_WAIT:	// Ȃ
    break;

  case MYSTERYGIFT_BEACON_SEQ_INIT:
    // * p[eB[Q[̒ʐMJniq@Ԃ̂݁j
    CommStateEnterPartyGameScanChild(wk->sv);
    wk->beacon_wait = BEACON_GATHER_TIME;
    wk->beacon_seq = MYSTERYGIFT_BEACON_SEQ_TIMER;
    break;

  case MYSTERYGIFT_BEACON_SEQ_TIMER:
    // r[RW
    flag = CommStateGetPartyGameBit();

#if 0//def DEBUG_ONLY_FOR_mituhara
    // fobO
    if(sys.trg & PAD_BUTTON_L)	flag |= PARTYGAME_MYSTERY_BCON;
#endif

    if(flag & PARTYGAME_MYSTERY_BCON)	wk->found_beacon = TRUE;

    if(--wk->beacon_wait == 0){
      // p[eB[Q[T[`̏I
      CommStateExitPartyGameScan();
      wk->beacon_seq = MYSTERYGIFT_BEACON_SEQ_WAIT;
    }
    break;
  }
}


//------------------------------------------------------------------
/**
 * @brief	r[R_E[h
 *		CVglmain.cɈڐA
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
// bsdownԂĂR[obNB
static void MysteryGift_BSCallBack( int code )
{
  switch( code ){
  case BSDOWNCALLBACK_STARTSCAN:	// XLJn
    s_state = BEACON_STATE_SCANNING;
    break;
  case BSDOWNCALLBACK_START:		// e@݂Ƃ
    s_state = BEACON_STATE_DOWNLOAD;
    break;
  case BSDOWNCALLBACK_SUCCESS:		// f[^SɎ󂯎Ƃ
    s_state = BEACON_STATE_COMPLETE;
    break;
  case BSDOWNCALLBACK_FINISH:		// ̏I
    if( s_state == BEACON_STATE_COMPLETE ){
      s_state = BEACON_STATE_FINISH;
    }	else {
      s_state = BEACON_STATE_CANCEL;				
    }
    break;
  case BSDOWNCALLBACK_ERROR:		// G[
    s_state = BEACON_STATE_ERROR;
    break;
  }
}


static void MysteryGift_BeaconCancel(void)
{
  OS_TPrintf("CNj[J\n");
  CommVRAMDFinalize();
  sys_FreeMemoryEz(buffer);
  WirelessIconEasyEnd(); // ʐMACR폜
  buffer = NULL;
}

static void MysteryGift_BeaconMainLoop(MYSTERYGIFT_WORK *wk)
{
  if( s_state == BEACON_STATE_FINISH ){
    MysteryGift_BeaconCancel();

    // _E[h҂Bbqb`FbN
    // R[obNłȂAŃ`FbN̂́A荞݂Ƀ[`ɏdꂽȂ
    if( bsdown_c_checkcrc() ) {
      s_state = BEACON_STATE_SUCCESS;
    } else {
      s_state = BEACON_STATE_CRCERROR;
    }
  }

  if(s_state == BEACON_STATE_INIT1 || s_state == BEACON_STATE_INIT2 || s_state == BEACON_STATE_START ||
     s_state == BEACON_STATE_SCANNING || s_state == BEACON_STATE_DOWNLOAD || s_state == BEACON_STATE_CANCELING)
    WirelessIconEasy_SetLevel(WM_LINK_LEVEL_3 - WM_GetLinkLevel());
  
  //  OS_TPrintf("s_state = %d\n", s_state - BEACON_STATE_INIT1);
  
  switch( s_state ){
  case BEACON_STATE_INIT1:				// (ʐMCu)
    CommVRAMDInitialize();
    s_state = BEACON_STATE_INIT2;
    break;			
  case BEACON_STATE_INIT2:				// 
    if(CommIsVRAMDInitialize() == TRUE){
      progress_time = 0;
      buffer = sys_AllocMemory(HEAPID_MYSTERYGIFT, bsdown_c_worksize());
      bsdown_c_init( &(wk->recvbuf[0]), MysteryGift_BSCallBack, buffer );
      s_state = BEACON_STATE_START;
      WirelessIconEasy();	// ʐMACR\(AeiȂT-T)
      debug_printf("PRESS A TO START\n");
    }
    break;
  case BEACON_STATE_START:				// 
    debug_printf("INITIALIZING...\n");
    break;
  case BEACON_STATE_SCANNING:			// XL
    debug_printf("SEARCHING......\n");
    //    debug_printf("PRESS START TO RESTART\n");
    break;
  case BEACON_STATE_DOWNLOAD:			// e@āA_E[h
    debug_printf("packets %d / %d\t", bsdown_c_received(), bsdown_c_total());
    progress_time++;
    debug_printf("time    %d : %d\n", (progress_time / 60) / 60, (progress_time / 60) % 60 );
    break;				
  case BEACON_STATE_COMPLETE:			// _E[h
    debug_printf("Finishing( size = %d byte )\n", bsdown_c_size());
    debug_printf("time    %d : %d\n", (progress_time / 60) / 60, (progress_time / 60) % 60 );				
    break;
  case BEACON_STATE_CANCELING:		// LZ
    debug_printf("CANCELING......\n");    //    s_state = BEACON_STATE_FINISH;	// sďI
    break;
  case BEACON_STATE_SUCCESS:			// _E[hI
    //    debug_printf("Complete( size = %d byte )\n", bsdown_c_size());
    //    debug_printf("time    %d : %d\n", (progress_time / 60) / 60, (progress_time / 60) % 60 );				
    //    debug_printf("PRESS START TO RESTART\n");				
    break;
  case BEACON_STATE_CANCEL:			// LZI
    //    debug_printf("PRESS START TO RESTART\n");
    return;
    break;			
  case BEACON_STATE_ERROR:				// G[	
    debug_printf("error......\n");
    break;
  case BEACON_STATE_CRCERROR:
    debug_printf("crc error.\n");
    //    debug_printf("PRESS START TO RESTART\n");
    break;
  }
		
  if(sys.trg & PAD_BUTTON_CANCEL){
    // ----------------------------------------------------------------------------
    // localize_spec_mark(LANG_ALL) imatake 2007/02/15
    // LZSE2̂C
    // ----------------------------------------------------------------------------
    // Zbg
    switch( s_state ){
    case BEACON_STATE_SCANNING:			// XL
    case BEACON_STATE_DOWNLOAD:			// e@āA_E[h
    case BEACON_STATE_ERROR:				// G[

      OS_TPrintf("LZ˗\n");
      if( bsdown_end() ){
	s_state = BEACON_STATE_CANCELING;	
      }					
      break;
				
    case BEACON_STATE_SUCCESS:			// _E[hI
    case BEACON_STATE_CANCEL:			// LZI
    case BEACON_STATE_CRCERROR:		// bqbG[
      return;
    default:
      break;
    }				
  }
}


//------------------------------------------------------------------
///	vZXf[^
//------------------------------------------------------------------
const PROC_DATA MysteryGiftProcData = {
  MysteryGiftProc_Init,
  MysteryGiftProc_Main,
  MysteryGiftProc_End,
  NO_OVERLAY_ID,
};
  
/*  */
