//============================================================================================
/**
 * @file	comm_fushigi_present.h
 * @bfief	ӂȁ@
 * @author	Satoshi Mitsuhara
 * @date	06.05.08
 *
 */
//============================================================================================
#ifndef __COMM_MYSTERY_GIFT_H__
#define __COMM_MYSTERY_GIFT_H__

#include "common.h"
#include "system/procsys.h"
#include "system/heapdefine.h"
#include "system/bmp_list.h"
#include "system/wordset.h"
#include "system/wipe.h"
#include "system/clact_tool.h"

#include "savedata/savedata_def.h"
#include "savedata/fushigi_data.h"



enum {
  MYSTERYGIFT_WIN_MAIN = 0,		/* Cj[IEBhE */
  MYSTERYGIFT_WIN_COMM_TYPE,		/* ʐMIEBhE */
  MYSTERYGIFT_WIN_COMM_DIRECT_YESNO,	/* ʐMŃ_CNgʐMg܂u͂^vEBhE */
  MYSTERYGIFT_WIN_MAX
};

#define MYSTERYGIFT_TITLE_MAX		(36)
#define MYSTERYGIFT_EXPLANATION_MAX	(250)
// e@Ǝq@邽߂̎ʃR[h
#define MYSTERYGIFT_SYNC_CODE		(0xAB)
#define MYSTERYGIFT_SYNC_CODE2		(0x93)

// ʐM߂鎞
#define MYSTERYGIFT_TIMEOUT		(60*120)


//============================================================================================

// -- WiFiɊ֘A萔 --
#define FILE_NUM				10
enum {
  ND_RESULT_EXECUTE,		// s
  ND_RESULT_COMPLETE,		// _E[hI
  ND_RESULT_NOT_FOUND_FILES,	// t@CȂ
  ND_RESULT_DOWNLOAD_CANCEL,	// [U[LZꂽ
  ND_RESULT_DOWNLOAD_ERROR,	// Ȃ炩̃G[N
  ND_RESULT_MAX
};

#define WIFI_MYSTERYGIFT_BASE	0x1000
#define WIFI_MYSTERYFILE_SIZE	4096

//============================================================================================

// ӂȂ̐p[N`
typedef struct {
  GF_BGL_INI *bgl;
  SAVEDATA *sv;
  CONFIG *cfg;
  WORDSET *word;	       			// PꃂW[䃏[Nւ̃|C^
  MSGDATA_MANAGER *msgman;	    		// MSGf[^}l[Wւ̃|C^
  STRBUF *msg;					// Qsȏ゠郁bZ[W̎̂ݎgp

  GF_BGL_BMPWIN	msgwin;				// bZ[W\EBhE
  GF_BGL_BMPWIN	selwin[MYSTERYGIFT_WIN_MAX];	// j[IEBhE
  GF_BGL_BMPWIN	upwin;				// ʏ̃^CgEBhE

  int msg_wait;					// bZ[W\x
  int m_id;
  int msg_seq;					// bZ[W\̃V[PX
  int msg_next_seq;				// bZ[W\IiނׂV[PX
  
  BMPLIST_WORK *lw;				// j[
  BMP_MENULIST_DATA *bmd;

  int gift_error;				// 󂯎(Beacon)ɊւG[
  
  int from_seq;
  int next_seq;					// tF[h̎ɍsV[PXԍ
  GIFT_COMM_PACK gift_data;			// ͂̃f[^̑S(r[R{f[^)
  int timeout;

  int connectIndex;
  int sync_wait;				// ʐM̃^C~O҂

  int to_seq;					// s


  // ZAN^[֘A
  CLACT_SET_PTR	clactSet;				// ZAN^[Zbg 
  CLACT_U_EASYRENDER_DATA renddata;			// ȈՃ_[f[^
  CLACT_U_RES_MANAGER_PTR resMan[CLACT_U_RES_MAX];	// \[X}l[W
  CLACT_U_RES_OBJ_PTR resObjTbl[CLACT_U_RES_MAX];	// \[XIuWFe[u
  CLACT_HEADER clActHeaderMain;
  // ₶邵ACR
  CLACT_WORK_PTR arrow;

  // AGBJ[gbW̃_E[htO
  //  int agb_cartridge;

  // r[R擾V[PX
  int beacon_seq;
  int beacon_wait;
  int found_beacon;

  u8 recvbuf[4*1024];
  int comm_type;

  // PROC*seqɒ`Ă܂
  int *seq;

  // WiFiӂȂ̌n
  int wifi_dl_seq;
  u8 *dwcWork;
  DWCInetControl stConnCtrl;
  BOOL callbackflag;
  int wifi_next_seq;
  int server_filenum;
  char filebuffer[WIFI_MYSTERYFILE_SIZE];
  int wifi_result;
  u32 recived,contentlen,percent;
  BOOL wifi_errflag;
  int wifi_errmsg;
  int wifi_errcode;
  int wifi_errtype;
  DWCErrorType wifi_cancel;
  BOOL (*wifi_check_func)(void);
  GF_BGL_BMPWIN	wifiwin;

  GIFT_DATA comm_data;					// Íꂽf[^

  void (*func_hook)(void *);
  int save_cancel;
  void *time_icon;
  
} MYSTERYGIFT_WORK;



enum {
  MYSTERYCOMM_TYPE_NULL,
  MYSTERYCOMM_TYPE_DIRECT,		// _CNgʐM
  MYSTERYCOMM_TYPE_AGBCARTRIDGE,	// `fãJ[gbW_E[h
  MYSTERYCOMM_TYPE_BEACON,		// r[R_E[h
  MYSTERYCOMM_TYPE_WIFI,		// Wi-Fĩ_E[h
  
  MYSTERYCOMM_TYPE_MAX
};



extern PROC *MyseryGiftGetProcp(void);
extern void MysteryGiftSetProcp(PROC *proc);
extern void WifiMysteryGift_ErrorDisp(MYSTERYGIFT_WORK *wk);
extern void SetTimeWaitIconEx(MYSTERYGIFT_WORK *wk, int flag);


#endif	// __COMM_MYSTERY_GIFT_H__
/*  */
