//=============================================================================
/**
 * @file	comm_mystery_state.c
 * @brief	ʐMԂǗT[rX  ʐM̏ʂɂ
 *          	XbĥЂƂƂēA̒ʐMԂ⑼̋@
 *          	JnIǗ
 *		comm_field_state.c̐^q
 * @author	Satoshi Mitsuhara
 * @date    	2006.05.17
 */
//=============================================================================
#include "common.h"
#include "system/main.h"

#include "communication/communication.h"
#include "communication/comm_state.h"

#include "comm_command_mystery.h"
#include "comm_mystery_state.h"
#include "comm_mystery_gift.h"

//==============================================================================
//	^錾
//==============================================================================
// R[obN֐̏
typedef void (*PTRStateFunc)(void);
//==============================================================================
// [N
//==============================================================================
typedef struct{
  MYSTERYGIFT_WORK *pMSys;
  MATHRandContext32 sRand; 			//< eq@lSVG[VpL[
  TCB_PTR pTcb;
  PTRStateFunc state;
  u16 timer;
  u8 bStateNoChange;
  u8 connectIndex;   				// q@ڑe@indexԍ
  MYSTATUS *status[SCAN_PARENT_COUNT_MAX];

  GIFT_DATA recv_data;				// Mf[^
  u8 recv_flag;					// MtO
  u8 result_flag[SCAN_PARENT_COUNT_MAX];	// ƎM܂Ԏ

  //  u8 beacon_data[MYSTERY_BEACON_DATA_SIZE];	// r[Rf[^
  
} _COMM_STATE_WORK;

static _COMM_STATE_WORK *_pCommStateM = NULL;  ///<@[N\̂̃|C^

//==============================================================================
// `
//==============================================================================
#define _START_TIME (50)     // Jn
#define _CHILD_P_SEARCH_TIME (12) ///q@ƂĐeT
#define _PARENT_WAIT_TIME (40) ///eƂĂ̂т҂
#define _FINALIZE_TIME (2)
#define _EXIT_SENDING_TIME (5)
#define _PARENT_END_TIME (2)
#define _SEND_NAME_TIME (10)
#define _PARENTSCAN_PA (3)  // e@ƂČm1/3

#define _TCB_COMMCHECK_PRT   (10)    ///< tB[hʐM̊Ď[`PRI

//==============================================================================
// static錾
//==============================================================================
static void _commCheckFunc(TCB_PTR tcb, void* work);  // Xe[gsĂ^XN
static void _mysteryParentInit(void);
static void _mysteryParentWaiting(void);

static void _mysteryChildInit(void);
static void _mysteryChildBconScanning(void);
static void _mysteryChildConnecting(void);
static void _mysteryChildSendName(void);
static void _mysteryChildWaiting(void);

#define   _CHANGE_STATE(state, time)  _changeState(state, time)

//==============================================================================
/**
 * ʐMǗXe[g̏
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _commStateInitialize(MYSTERYGIFT_WORK *pMSys)
{
  void* pWork;

  if(_pCommStateM != NULL)		// łɓ쒆̏ꍇKvȂ
    return;

  CommCommandMysteryInitialize((void *)pMSys);
  // 
  _pCommStateM = (_COMM_STATE_WORK*)sys_AllocMemory(HEAPID_COMMUNICATION, sizeof(_COMM_STATE_WORK));
  MI_CpuFill8(_pCommStateM, 0, sizeof(_COMM_STATE_WORK));
  _pCommStateM->timer = _START_TIME;
  _pCommStateM->pTcb = TCB_Add(_commCheckFunc, NULL, _TCB_COMMCHECK_PRT);
  _pCommStateM->pMSys = pMSys;
  CommRandSeedInitialize(&_pCommStateM->sRand);
}


//==============================================================================
/**
 * ʐMǗXe[g̕ύX
 * @param   state  ςXe[g̊֐
 * @param   time   Xe[gێ
 * @retval  none
 */
//==============================================================================
static void _changeState(PTRStateFunc state, int time)
{
    _pCommStateM->state = state;
    _pCommStateM->timer = time;
}


//==============================================================================
/**
 * e@Ƃďs
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _mysteryParentInit(void)
{
  int i;
  //  MYSTERYGIFT_WORK *wk;
  
  // ܂͎Ɛڑ
  if(!CommIsConnect(CommGetCurrentID()))
    return;

  for(i = 0; i < SCAN_PARENT_COUNT_MAX; i++)
    _pCommStateM->result_flag[i] = FALSE;
  // e@ƂĂ̏̂ŁAr[RYt
  //  wk = PROC_GetWork(MyseryGiftGetProcp());
  // ̃f[^͑˂
  CommInfoSendPokeData();
  _CHANGE_STATE(_mysteryParentWaiting, 0);
}


//==============================================================================
/**
 * e@Ƃđҋ@
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _mysteryParentWaiting(void)
{
  int i;
  for(i = 0; i < SCAN_PARENT_COUNT_MAX; i++){
    if(_pCommStateM->status[i] == NULL && CommIsConnect(i) == TRUE){
      _pCommStateM->status[i] = CommInfoGetMyStatus(i);
      if(_pCommStateM->status[i]){
#if 0//def DEBUG_ONLY_FOR_mituhara
	OS_Printf("q@ %d ԐM܂I\n", i);
#endif
      }
    }
  }
}


//==============================================================================
/**
 * q@̏
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _mysteryChildInit(void)
{
  if(!CommIsVRAMDInitialize()){
    return;
  }
  _CHANGE_STATE(_mysteryChildBconScanning, 0);
}


//==============================================================================
/**
 * q@ҋ@  e@r[RW
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _mysteryChildBconScanning(void)
{
  //  CommParentBconCheck();
}


//==============================================================================
/**
 * q@ҋ@  e@ɋ炢
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _mysteryChildConnecting(void)
{
  CommStateConnectBattleChild(_pCommStateM->connectIndex);
  _CHANGE_STATE(_mysteryChildSendName, 0);
}


//==============================================================================
/**
 * q@ҋ@  e@ɏ𑗐M
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _mysteryChildSendName(void)
{
  if(!CommIsBattleConnectingState())
    return;

  _pCommStateM->recv_flag = 0;
  CommInfoSendPokeData();
  CommTimingSyncStart(MYSTERYGIFT_SYNC_CODE);
  _CHANGE_STATE(_mysteryChildWaiting, 0);
}


//==============================================================================
/**
 * q@ҋ@
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _mysteryChildWaiting(void)
{
  //Exit󂯎q@ؒf
}




//==============================================================================
/**
 * ʐMǗXe[g̏
 * @param
 * @retval  none
 */
//==============================================================================
void _commCheckFunc(TCB_PTR tcb, void* work)
{
  if(_pCommStateM==NULL){
    TCB_Delete(tcb);
  } else {
    if(_pCommStateM->state != NULL){
      PTRStateFunc state = _pCommStateM->state;
      if(!_pCommStateM->bStateNoChange){
	state();
      }
    }
  }
}


//==============================================================================
/**
 * uӂȂ́v̐eƂĂ̒ʐMJn
 * @param   serviceNo  ʐMT[rXԍ
 * @retval  none
 */
//==============================================================================
void CommMysteryStateEnterGiftParent(MYSTERYGIFT_WORK *pMSys, SAVEDATA *sv, int serviceNo)
{
  if(CommIsInitialize())
    return;      // ȂĂꍇ͏O

  CommStateEnterMysteryParent(sv, serviceNo);
  _commStateInitialize(pMSys);
  _CHANGE_STATE(_mysteryParentInit, 0);
}

//==============================================================================
/**
 * q̐Ԃ
 * @param   none
 * @retval  none
 */
//==============================================================================
int CommMysteryGetCommChild(void)
{
  int i, max;
  for(max = 0, i = 1; i < SCAN_PARENT_COUNT_MAX; i++)
    if(_pCommStateM->status[i])	max++;
  return max;
}

//==============================================================================
/**
 * e@FqĂq@փf[^𑗂
 * @param   none
 * @retval  none
 */
//==============================================================================
void CommMysterySendGiftDataParent(const void *p, int size)
{
  CommSendHugeData_ServerSide(CM_GIFT_DATA, p, size);
}










//==============================================================================
/**
 * uӂȂ́v̎qƂĂ̒ʐMJn
 * @param   serviceNo  ʐMT[rXԍ
 * @retval  none
 */
//==============================================================================
void CommMysteryStateEnterGiftChild(MYSTERYGIFT_WORK *pMSys, int serviceNo)
{
  SAVEDATA *sv;
  if(CommIsInitialize())
    return;      // ȂĂꍇ͏O

  // ʐMq[v쐬
  sv = ((MAINWORK *)PROC_GetParentWork(MyseryGiftGetProcp()))->savedata;
  CommStateEnterMysteryChild(sv, serviceNo);
    _commStateInitialize(pMSys);
    _CHANGE_STATE(_mysteryChildInit, 0);
}


//==============================================================================
/**
 * uӂȂ́v̎qƂĂ̒ʐMJn
 * @param   connectIndex ڑe@Index
 * @retval  none
 */
//==============================================================================
void CommMysteryStateConnectGiftChild(int connectIndex)
{
  _pCommStateM->connectIndex = connectIndex;
  _CHANGE_STATE(_mysteryChildConnecting, 0);
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	Lȃr[R󂯎Ԃ
 * @param	NONE
 * @return	0`15: 󂯎 -1: 󂯎Ȃ
 *		󂯎ꍇbeacon_dataɏ񂪃Rs[
*/
//--------------------------------------------------------------------------------------------
int CommMysteryCheckParentBeacon(MYSTERYGIFT_WORK *wk)
{
  int i;
  GIFT_BEACON *p;

  for(i = 0; i < SCAN_PARENT_COUNT_MAX; i++){
    p = (GIFT_BEACON *)CommMPGetBeaconTempData(i);
    if(p){
      if(p->event_id){
#if 0
	memcpy(&wk->gift_data.gd2.b, p, sizeof(GIFT_DATA2_B));
#endif
	memcpy(&wk->gift_data.beacon, p, sizeof(GIFT_BEACON));
#if 0//def DEBUG_ONLY_FOR_mituhara
	OS_Printf("r[Rf[^ %d Ɏ󂯎܂I\n", i);
	OS_Printf("event_id = %d\n", p->event_id);
	OS_Printf("have_card = %d\n", p->have_card);
#endif
	return i;
      }
    }
  }
  return -1;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	ƃf[^󂯎ꂽe@֓`B
 * @param	NONE
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
void CommMysteryResultRecvData(void)
{
  CommSendData(CM_RECV_RESULT, NULL, 0);
}


//==============================================================================
/**
 * ́@̃f[^󂯎ۂɌĂ΂R[obN
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    ̂ւ̃f[^|C^
 * @retval  none
 */
//==============================================================================
void CommMysteryGiftRecvPlace(int netID, int size, void* pBuff, void* pWork)
{
  /* mȂ肩f[^Ă疳 */
  if(_pCommStateM->connectIndex != netID)
    return;
  _pCommStateM->recv_flag = 1;
#if 0//def DEBUG_ONLY_FOR_mituhara
  OS_Printf("̂̃f[^󂯎܂I\n");
#endif
}

//==============================================================================
/**
 * @brief	̂̃f[^ĂԂ
 * @param	NONE
 * @return	TRUE: Ă : FALSE: ĂĂȂ
 */
//==============================================================================
int CommMysteryCheckRecvData(void)
{
  return _pCommStateM->recv_flag;
}

//==============================================================================
/**
 * ́@̃f[^TCYԂ
 * @param   none
 * @retval  f[^TCY
 */
//==============================================================================
int CommMysteryGetRecvPlaceSize(void)
{
  return sizeof(GIFT_DATA);
}

//==============================================================================
/**
 * ́@i[|C^Ԃ
 * @param   none
 * @retval  |C^
 */
//==============================================================================
u8* CommGetMysteryGiftRecvBuff( int netID, void* pWork, int size)
{
  return (u8 *)&_pCommStateM->recv_data;
}

//==============================================================================
/**
 * ́@ĂƂ𑗂
 * @param   none
 * @retval  |C^
 */
//==============================================================================
void CommMysterySendRecvResult(int netID, int size, void* pBuff, void* pWork)
{
#if 0//def DEBUG_ONLY_FOR_mituhara
  OS_Printf("%d %d %08X %08X\n", netID, size, pBuff, pWork);
#endif

  _pCommStateM->result_flag[netID] = TRUE;
}

//==============================================================================
/**
 * ڑĂ邷ׂĂ̎q@ԎԂĂԂ
 * @param   none
 * @retval  TRUE: ԂĂ : FALSE: ԂĂĂȂ
 */
//==============================================================================
int CommMysteryGiftGetRecvCheck(void)
{
  int i;
  for(i = 1; i < SCAN_PARENT_COUNT_MAX; i++){
    if(CommInfoGetMyStatus(i) && _pCommStateM->status[i] && _pCommStateM->result_flag[i] != TRUE)
      return FALSE;
  }
  return TRUE;
}


//==============================================================================
/**
 * ʐMI
 * @param   none
 * @retval  none
 */
//==============================================================================
void CommMysteryExitGift(void)
{
  sys_FreeMemory(HEAPID_COMMUNICATION, _pCommStateM);
  _pCommStateM = NULL;
  CommStateExitBattle();
}

/*  */
