//============================================================================================
/**
 * @file	exindexdata.c
 * @bfief	OQƃt@C̍쐬
 * @author	Satoshi Mitsuhara
 * @date	06.07.30
 *
 */
//============================================================================================
#include "common.h"
#include "savedata/savedata.h"
#include "savedata/zukanwork.h"
#include "savedata/system_data.h"

#include "field/eventflag.h"
#include "field/evwkdef.h"
#include "../field/sysflag_def.h"

#include "field/location.h"
#include "field/situation.h"

#include "poketool/poke_tool.h"
#include "poketool/pokeparty.h"
#include "poketool/boxdata.h"

#include "itemtool/myitem.h"

#ifdef CREATE_INDEX

void CreateIndexData(int heapid);

typedef struct {
  // Z[uf[^̍\̂src/savedata/saveload_system.cɂ̂ŎQƂ鎖
  // SAVEDATA.SAVEWORK̍\`

  // SAVEDATÅeZ[uڂ̃ItZbg
  // e\̂̓e͌Œ肪ۏႳĂȂ߁Aœꂽ|C^
  // @ɍ\̂𒼐ڃANZX鎞ɂ͌݊ɒӂĂI
  u32 savework_offset[GMDATA_ID_MAX];

  // p[NQƗp(GMDATA_ID_ZUKANWORK̃ItZbg)
  // Ă邩tÕItZbg
  u32 zukan_get_offset;
  // 񂱂񃂁[h̃tÕItZbg
  u32 zenkoku_flag_offset;
  // F߂܂tOp[ÑItZbg
  u32 get_flag_offset;
  // FtOp[ÑItZbg
  u32 see_flag_offset;
  // FIXXtOp[ÑItZbg
  u32 sex_flag_offset;

  // Q[̐is󋵎QƗp(GMDATA_ID_EVENT_WORK̃ItZbg)
  // Q[tOQƗp
  u32 game_flag_offset;
  // Q[NAtO̔ԍ(u8 game_flag_offset[game_clear_flag / 8])
  u32 game_clear_flag;
  // obO肵tO
  u32 game_bag_flag;

  // |PZ^[ŃZ[uĂ邩𓾂邽߂̕z
  // |PZ^[ŃZ[uĂ邩𒲂ׂ@
  // Lsituation_offsetZ[uLOCATION_WORK\̂ւ̃|C^𓾂
  // ̒ɂzone_idZ[uۂ̃}bvǗIDɂȂ܂B
  // zone_idZONE_ID_???PC0101`ZONE_ID_???PC0103Ȃ΃|PZ^[łB
  // S51}bvƔrKv܂B
  // Qƃt@C
  // src/field/situation.cLOCATION_WORK nowo
  // src/fielddata/maptable/zone_id.h
  // ugrep PC src/fielddata/maptable/zone_id.hv
  u32 situation_now_offset;

  // 
  // MYSTATUSւ̃ItZbg
  //  u32 mystatus_offset;  savework_offset[GMDATA_ID_PLAYER_DATA]Ɠ
  // vC[̖Oւ̃ItZbg
  u32 mystatus_name_offset;
  // vC[ID
  u32 mystatus_id_offset;
  // vC[̐
  u32 mystatus_sex_offset;
  
  // 莝|P֘A
  // 莝|PPOKEPARTY\̂ŊǗĂ
  // u32 pokeparty_offset;  savework_offset[GMDATA_ID_TEMOTI_POKE]Ɠ
  // 莝̃|P
  u32 pokecount_offset;
  // 莝|Pւ̃ItZbg(POKEMON_PARAMTEMOTI_POKEMAX)
  u32 pokemon_member_offset;
  // sizeof(POKEMON_PARAM) ύXȂƎvǔÔ
  u32 sizeof_pokemon_param;

  // 莝ACe֘A
  // u32 myitem_offset;  savework_offset[GMDATA_ID_TEMOTI_ITEM]Ɠ
  // sizeof(MINEITEM)
  u32 sizeof_mineitem;
  // |Pbgő吔
  u32 bag_normal_item_max;
  // ؂ȕ|Pbgő吔
  u32 bag_event_item_max;
  // Z}V|Pbgő吔
  u32 bag_waza_item_max;
  // V[|Pbgő吔
  u32 bag_seal_item_max;
  // |Pbgő吔
  u32 bag_drug_item_max;
  // ؂̎|Pbgő吔
  u32 bag_nuts_item_max;
  // X^[{[|Pbgő吔
  u32 bag_ball_item_max;
  // 퓬pACe|Pbgő吔
  u32 bag_battle_item_max;
  // |Pbgւ̃ItZbg
  u32 bag_normal_item_offset;
  // ؂ȕ|Pbgւ̃ItZbg
  u32 bag_event_item_offset;
  // Z}V|Pbgւ̃ItZbg
  u32 bag_waza_item_offset;
  // V[|Pbgւ̃ItZbg
  u32 bag_seal_item_offset;
  // |Pbgւ̃ItZbg
  u32 bag_drug_item_offset;
  // ؂̎|Pbgւ̃ItZbg
  u32 bag_nuts_item_offset;
  // X^[{[|Pbgւ̃ItZbg
  u32 bag_ball_item_offset;
  // 퓬pACe|Pbgւ̃ItZbg
  u32 bag_battle_item_offset;
  
  // {bNX֘A
  // p\RɗaĂ|PPOKEMON_PASO_PARAMŊǗĂ(ςȂǔÔ)
  // u32 box_data_offset;  savework_offset[GMDATA_ID_BOXDATA]Ɠ
  // {bNX̃gC
  u32 box_data_tray_max;
  // {bNX̐擪ւ̃ItZbg
  u32 box_data_offset;
  // sizeof(POKEMON_PASO_PARAM) ύXȂƎvǔÔ
  u32 sizeof_pokemon_paso_param;

  // Wi-Fi֘A
  // OCpGameSpyIDĂꏊ
  // O\tgœID𗘗pꍇɎQƂ\܂
  // ȂA͐΂ɕsII"READ-ONLY"ł
  // u32 system_data_offset;  savework_offset[GMDATA_ID_SYSTEM_DATA]Ɠ
  // GTSEWifiog^[OCpGameSpyIDi߂Ď擾GameSpyIdۑj
  u32 profile_id_offset;
  
} EXINDEX;


// O֐`
extern LOCATION_WORK * Situation_GetNowLocation(SITUATION * st);


//------------------------------------------------------------------
/**
 * @brief	Q[pCfbNX쐬֐
 * @param	NONE
 * @return	NONE
 *  Ăяoꂽ͖[vɂĒ~
 */
//------------------------------------------------------------------
void CreateIndexData(int heapid)
{
  u32 uval1;
  void *up1, *up2;
  int i, ival1;

  SAVEDATA *sv;
  EXINDEX *ex;

  ex = sys_AllocMemory(heapid, sizeof(EXINDEX));

  sv = SaveData_GetPointer();

  // eZ[uڂւ̃ItZbgZbg
  up2 = SaveData_Get(sv, 0);
  for(i = 0; i < GMDATA_ID_MAX; i++){
    up1 = SaveData_Get(sv, i);	// up1 = absolute address
    ex->savework_offset[i] = (u32)up1 - (u32)up2;
  }

  // Ă邩̃tOʒu
  up1 = SaveData_Get(sv, GMDATA_ID_ZUKANWORK);
  ex->zukan_get_offset = (u32)Index_Get_Zukan_Offset(up1) - (u32)up1;
  ex->zenkoku_flag_offset = (u32)Index_Get_Zenkoku_Zukan_Offset(up1) - (u32)up1;
  ex->get_flag_offset = (u32)Index_Get_Get_Flag_Offset(up1) - (u32)up1;
  ex->see_flag_offset = (u32)Index_Get_See_Flag_Offset(up1) - (u32)up1;
  ex->sex_flag_offset = (u32)Index_Get_Sex_Flag_Offset(up1) - (u32)up1;

  // Q[tO֘A
  up1 = SaveData_Get(sv, GMDATA_ID_EVENT_WORK);
  ex->game_flag_offset = (u32)EventWork_GetEventFlagAdrs(up1, 1) - (u32)up1;
  ex->game_clear_flag = SYS_FLAG_GAME_CLEAR;
  ex->game_bag_flag = SYS_FLAG_BAG_GET;

  // Z[uꏊ𓾂(|PZ^[ŃZ[u̔rp)
  up1 = SaveData_Get(sv, GMDATA_ID_SITUATION);
  ex->situation_now_offset = (u32)Situation_GetNowLocation(up1) - (u32)up1;

  // MYSTATUS֘A
  up1 = SaveData_Get(sv, GMDATA_ID_PLAYER_DATA);
  ex->mystatus_name_offset = (u32)Index_Get_Mystatus_Name_Offset(up1) - (u32)up1;
  ex->mystatus_id_offset = (u32)Index_Get_Mystatus_Id_Offset(up1) - (u32)up1;
  ex->mystatus_sex_offset = (u32)Index_Get_Mystatus_Sex_Offset(up1) - (u32)up1;

  // 莝|P֘A
  up1 = SaveData_Get(sv, GMDATA_ID_TEMOTI_POKE);
  ex->pokecount_offset = (u32)Index_Get_PokeCount_Offset(up1) - (u32)up1;
  ex->pokemon_member_offset = (u32)PokeParty_GetMemberPointer(up1, 0) - (u32)up1;
  ex->sizeof_pokemon_param = PokemonParam_GetWorkSize();

  // ACe֘A
  up1 = SaveData_Get(sv, GMDATA_ID_TEMOTI_ITEM);
  ex->sizeof_mineitem = sizeof(MINEITEM);
  ex->bag_normal_item_max = BAG_NORMAL_ITEM_MAX;
  ex->bag_event_item_max = BAG_EVENT_ITEM_MAX;
  ex->bag_waza_item_max = BAG_WAZA_ITEM_MAX;
  ex->bag_seal_item_max = BAG_SEAL_ITEM_MAX;
  ex->bag_drug_item_max = BAG_DRUG_ITEM_MAX;
  ex->bag_nuts_item_max = BAG_NUTS_ITEM_MAX;
  ex->bag_ball_item_max = BAG_BALL_ITEM_MAX;
  ex->bag_battle_item_max = BAG_BATTLE_ITEM_MAX;
  ex->bag_normal_item_offset = (u32)Index_Get_Myitem_Offset(up1, BAG_POKE_NORMAL) - (u32)up1;
  ex->bag_event_item_offset =  (u32)Index_Get_Myitem_Offset(up1, BAG_POKE_EVENT) - (u32)up1;
  ex->bag_waza_item_offset = (u32)Index_Get_Myitem_Offset(up1, BAG_POKE_WAZA) - (u32)up1;
  ex->bag_seal_item_offset = (u32)Index_Get_Myitem_Offset(up1, BAG_POKE_SEAL) - (u32)up1;
  ex->bag_drug_item_offset = (u32)Index_Get_Myitem_Offset(up1, BAG_POKE_DRUG) - (u32)up1;
  ex->bag_nuts_item_offset = (u32)Index_Get_Myitem_Offset(up1, BAG_POKE_NUTS) - (u32)up1;
  ex->bag_ball_item_offset = (u32)Index_Get_Myitem_Offset(up1, BAG_POKE_BALL) - (u32)up1;
  ex->bag_battle_item_offset = (u32)Index_Get_Myitem_Offset(up1, BAG_POKE_BATTLE) - (u32)up1;

  // {bNX֘A
  up1 = SaveData_Get(sv, GMDATA_ID_BOXDATA);
  ex->box_data_tray_max = BOX_MAX_TRAY;
  ex->box_data_offset = (u32)BOXDAT_GetPokeDataAddress(up1, 0, 0) - (u32)up1;
  ex->sizeof_pokemon_paso_param = PokemonPasoParamSizeGet();

  // Wi-Fi֘A
  up1 = SaveData_Get(sv, GMDATA_ID_SYSTEM_DATA);
  ex->profile_id_offset = (u32)Index_Get_Profile_Offset(up1) - (u32)up1;
  
  OS_TPrintf("OIndex: %08X - %08X\n", ex, (u32)ex + sizeof(EXINDEX));
  OS_TPrintf("zukan_get_offset = %08X\n", &ex->zukan_get_offset);
  OS_TPrintf("game_flag_offset = %08X\n", &ex->game_flag_offset);
  OS_TPrintf("mystatus_name_offset = %08X\n", &ex->mystatus_name_offset);
  OS_TPrintf("pokecount_offset = %08X\n", &ex->pokecount_offset);
  OS_TPrintf("sizeof_mineitem = %08X\n", &ex->sizeof_mineitem);
  OS_TPrintf("box_data_tray_max = %08X\n", &ex->box_data_tray_max);
  OS_TPrintf("profile_id_offset = %08X\n", &ex->profile_id_offset);
  
  // I
  OS_Terminate();
}

/*  */

#endif	// CREATE_INDEX
