//============================================================================================
/**
 * @file	mysterylib.h
 * @bfief	ӂȁ@̂Ŏg郉Cuǂ
 * @author	Satoshi Mitsuhara
 * @date	06.06.12
 *
 */
//============================================================================================
#ifndef __MYSTERYLIB_H__
#define __MYSTERYLIB_H__

#include "system/fontproc.h"
#include "system/clact_util.h"
#include "system/bmp_list.h"
#include "savedata/fushigi_data.h"

#ifdef DEBUG_ONLY_FOR_mituhara
#define MIT_PRINTF(...)		(void) ((OS_TPrintf(__VA_ARGS__)))
#else
#define MIT_PRINTF(...)		NULL
#endif


// bZ[WEBhEn
typedef struct {
  int winmode;
  int drawflag;
  int redrawflag;
  int rightflag;		// E
  GF_BGL_BMPWIN *win;
  WORDSET *word;
  int width, height;
  int dx, dy;
  int base;
  int screen;
  int palno;
  int arcno;
  int fchr, fcol;
  FONT_TYPE font;
  GF_PRINTCOLOR color;
  u8 clrcolor;
  int msgid;
  int msgspd;
} MYSTERY_WIN;


// ZAN^[n
typedef struct {
  CLACT_SET_PTR	clactSet;				// ZAN^[Zbg 
  CLACT_U_EASYRENDER_DATA renddata;			// ȈՃ_[f[^
  CLACT_U_RES_MANAGER_PTR resMan[CLACT_U_RES_MAX];	// \[X}l[W
  CLACT_U_RES_OBJ_PTR resObjTbl[2][CLACT_U_RES_MAX];	// \[XIuWFe[u
  CLACT_HEADER clActHeader[2];

  int arcfile;
  int arcchar;
  int arcpal;
  int arccell;
  int arcanim;
  int screen;
} MYSTERY_CLACT;

enum {
  MYSTERYLIB_SEQ_SAVE_INIT = 0,
  MYSTERYLIB_SEQ_SAVE_MAIN,
  MYSTERYLIB_SEQ_SAVE_OK,
  MYSTERYLIB_SEQ_SAVE_NG,
  MYSTERYLIB_SEQ_SAVE_LAST,
  MYSTERYLIB_SEQ_SAVE_MAX
};

#define MYSTERYLIB_WINTYPE_NORMAL	0
#define MYSTERYLIB_WINTYPE_TALK		1

#define MYSTERYLIB_COLOR_NULL		0
#define MYSTERYLIB_COLOR_WHITE		1
#define MYSTERYLIB_COLOR_BLACK		2
#define MYSTERYLIB_COLOR_BLUE		3


#define MYSTERYLIB_CHAR_CONT_NUM		20
#define MYSTERYLIB_CHAR_VRAMTRANS_MAIN_SIZE	2048
#define MYSTERYLIB_CHAR_VRAMTRANS_SUB_SIZE	2048
#define MYSTERYLIB_PLTT_CONT_NUM		20


//------------------------------------------------------------------
///	ӂȁ@̃Cu
//------------------------------------------------------------------
extern void MysteryLib_Init(int heap);

//------------------------------------------------------------------
///	PROC܂Ƃ߂֐
//------------------------------------------------------------------
extern void *MysteryLib_InitProc(PROC *proc, int heapid, int size, int heapsize);

//------------------------------------------------------------------
///	af֐(Pt[̂)
//------------------------------------------------------------------
extern void MysteryLib_BgInitFrame(GF_BGL_INI *ini, int frame, u8 size, u32 scrbase, u32 scrchar);

//------------------------------------------------------------------
///	tF[h̃^CvύX
//------------------------------------------------------------------
extern void MysteryLib_ChangeFadeType(int type);

//------------------------------------------------------------------
///	tF[h֐
//------------------------------------------------------------------
extern void MysteryLib_RequestFade(int type, int next_seq, int *seq, int next);

//------------------------------------------------------------------
///	tF[hI֐
//------------------------------------------------------------------
extern void MysteryLib_FadeEndCheck(int *seq);

//------------------------------------------------------------------
///	MYSTERY_WIN\̂̏
//------------------------------------------------------------------
extern void MysteryLib_WinInit1(MYSTERY_WIN *mw, GF_BGL_BMPWIN *win, int palno, int arc, int fchr, int fcol);
extern void MysteryLib_WinInit2(MYSTERY_WIN *mw, int w, int h, /*int msgid,*/ int base);
extern void MysteryLib_WinInit3(MYSTERY_WIN *mw, int type, int font);
extern void MysteryLib_WinSetColor(MYSTERY_WIN *mw, int color);
extern void MysteryLib_WinSetPos(MYSTERY_WIN *mw, int dx, int dy);

//------------------------------------------------------------------
///	bZ[WEBhEo^
//------------------------------------------------------------------
extern int MysteryLib_CreateWin(GF_BGL_INI *bgl, MYSTERY_WIN *mw, int sx, int sy, int msg);

//------------------------------------------------------------------
///	EBhELN^Ԃ
//------------------------------------------------------------------
extern int MysteryLib_GetWindowChr(MYSTERY_WIN *mw);

//------------------------------------------------------------------
///	LN^Apbg}l[W[
//------------------------------------------------------------------
extern void MysteryLib_InitCPManager(void);

//------------------------------------------------------------------
///	ZAN^[VXeĂ邩Ԃ
//------------------------------------------------------------------
extern BOOL MysteryLib_isInitClact(void);

//------------------------------------------------------------------
///	ZAN^[VXȅ
//------------------------------------------------------------------
extern void MysteryLib_InitClactSystem(void);

//------------------------------------------------------------------
///	ZAN^[
//------------------------------------------------------------------
extern void MysteryLib_InitClact(int arcfile, int arcchar, int arcpal, int arccell, int arcanim, int screen);

//------------------------------------------------------------------
///	Tuʂ̃T[tFCXύX
//------------------------------------------------------------------
extern void MysteryLib_SetSubSurfaceMatrix(fx32 x, fx32 y);

//------------------------------------------------------------------
///	t[Ăяoė~֐
//------------------------------------------------------------------
extern void MysteryLib_DoClact(void);

//------------------------------------------------------------------
///	CLACT_ADD̐`쐬
//------------------------------------------------------------------
extern CLACT_WORK_PTR MysteryLib_MakeCLACT(int screen, CLACT_WORK_PTR anim, int sx, int sy, int anum);

//------------------------------------------------------------------
///	ZAN^[̍폜
//------------------------------------------------------------------
extern void MysteryLib_RemoveClact(void);

//------------------------------------------------------------------
///	Q[JZbgɑΉrbgԂ
//------------------------------------------------------------------
extern u32 MysteryLib_GetCasetteCode(int cas);

//------------------------------------------------------------------
///	ʂɃv[g󂯎艉o\
//------------------------------------------------------------------
extern void MysteryLib_InitGift(GF_BGL_INI *ini, GIFT_DELIVERY *deli);

//------------------------------------------------------------------
///	w̃obt@Í
//------------------------------------------------------------------
extern void MysteryLib_CreateCryptoData(GIFT_COMM_PACK *gift_data, GIFT_DATA *data, int heapid);

//------------------------------------------------------------------
///	Íꂽobt@Decode
//------------------------------------------------------------------
extern void MysteryLib_DecodeCryptoData(GIFT_COMM_PACK *gift_data, GIFT_DATA *data, int heapid);

//------------------------------------------------------------------
///	j[ŃCړۂɌĂ΂R[obN
//------------------------------------------------------------------
extern void MysteryLib_MenuKeyMove(BMPLIST_WORK * wk, u32 param, u8 mode);

//------------------------------------------------------------------
///	`faJZbg̔`FbN
//------------------------------------------------------------------
extern void MysteryLib_CheckAgbCartridge(void);

//------------------------------------------------------------------
/// 	AGBJ[gbWo荞ݐݒ
//------------------------------------------------------------------
extern void MysteryLib_SetAgbCartridgeIntr(BOOL flag);
extern void MysteryLib_SetAgbCartridgeIntr2(void);

//------------------------------------------------------------------
///	crZ[uV[PX
//------------------------------------------------------------------
extern void MysteryLib_InitSaveDSCard(SAVEDATA *sv);
extern int MysteryLib_SaveDSCard(void);
extern void MysteryLib_DoLastSave(void);
extern void MysteryLib_CancelSaveDSCard(void);
extern int MysteryLib_GetSaveStatus(void);


#endif	// __MYSTERYLIB_H__
/*  */
