//============================================================================================
/**
 * @file	pokemonranger.c	
 * @bfief	|PW[Ƃ̐ڑ/܂]
 * @author	Satoshi Mitsuhara
 * @date	06.04.27
 *
 */
//============================================================================================

// BG0		j[⃁bZ[W\
// BG1		iq͗l̔wi

#include "common.h"
#include "system/fontproc.h"
#include "system/lib_pack.h"
#include "system/arc_util.h"
#include "system/wipe.h"
#include "system/render_oam.h"
#include "system/pm_rtc.h"
#include "system/snd_tool.h"
#include "system/window.h"
#include "system/msgdata_util.h"

#include "savedata/zukanwork.h"
#include "savedata/config.h"
#include "savedata/savedata.h"
#include "savedata/fushigi_data.h"

#include "msgdata/msg.naix"
#include "msgdata/msg_startmenu.h"
#include "msgdata/msg_bconfind.h"
#include "msgdata/msg_mystery.h"
#include "strbuf_family.h"	//for STRBUF_SetStringCode 

#include "demo/title.h"
#include "field/field.h"

#include "system/main.h"
#include "system/brightness.h"

#include "communication/communication.h"
#include "communication/comm_system.h"
#include "communication/comm_mp.h"
#include "communication/mpconnect.h"
#include "communication/mpdata.h"

#include "system/startmenu.h"
#include "poketool/monsno.h"

#include "mysterylib.h"
#include "mystery.naix"


#include "pokemonrangerdata.h"

//============================================================================================
/**
 * |PW[Ƃ̐ڑʗp[N`
 */
//============================================================================================

#define POKEMONRANGER_WCOL_NORMAL	0
#define POKEMONRANGER_FCOL		1
#define POKEMONRANGER_TWCOL		2

#define POKEMONRANGER_FCHR		1			// ʏt[
#define POKEMONRANGER_TWCHR		(POKEMONRANGER_FCHR + MENU_WIN_CGX_SIZ)
#define POKEMONRANGER_WCHR		(POKEMONRANGER_TWCHR + TALK_WIN_CGX_SIZ)



typedef struct {
  int heapid;
  GF_BGL_INI * bgl;
  SAVEDATA *sv;
  ZUKAN_WORK *zw;
  MYSTATUS *mst;
  CONFIG *cfg;

  GF_BGL_BMPWIN	ewin;
  GF_BGL_BMPWIN	twin;		// TalkWinp̃rbg}bvǗ\
  GF_BGL_BMPWIN	swin;		// Xe[^X\prbg}bvǗ\

  MYSTERY_WIN talkwin;		// TalkWinto^p
  MYSTERY_WIN titlewin;		// ^Cg\EBhE
  MYSTERY_WIN statwin;		// Xe[^X\pEBhE

  int chrbase;
  int commvramload;		// CNj[݂鎞TRUE

  
  int beacon_seq;		// r[R擾V[PX
  int beacon_ret;		// L̃^[l
  
  int beacon_check_time;	// r[R`FbN鎞
  int doproc;			// true = MpProc쓮
  int seq;			// 쓮V[PX
  int mp_time_out;		// ^CAEg܂ł̃JEg
  int connect_num;		// RlNVԍ
  int disable;			// true = ʐMfvtO
  u8 mp_buf[12*1024];		// MPʐM쓮p[NGA(ۂɂ͖10KBKv)
  PROC *proc;			// proc

  //  MYSTERY_CLACT act;
  CLACT_WORK_PTR arrow;
  
  FUSHIGI_DATA *fdata;		// Z[up̂ӂf[^[hꏊ
  LOAD_RESULT result;		// Lf[^̃[h

  int warning_msg;		// xʎ̃bZ[WID

  GIFT_CARD gc;			// J[h\邽߂ɕKv

  void *time_icon;		// ^CACRp
  
} POKEMONRANGER_WORK;


// CheckPokemonRangerBeacon֐Ԃl
enum {
  POKEMONRANGER_RET_NONE,	// Cxg͖
  POKEMONRANGER_RET_FOUNDRANGER,// W[I
  POKEMONRANGER_RET_DISCONNECT,	// ʐM؂ꂽ
  POKEMONRANGER_RET_TIMEOUT,	// ^CAEg
  POKEMONRANGER_RET_SUCCESS,	// ܂ʐM
  POKEMONRANGER_RET_CANCEL,	// [U[̃LZ
  POKEMONRANGER_RET_MAX
};

#define POKEMONRANGER_CHECK_BEACON_TIME		(60)


#if 0
char *vtable[] = {
  "POKEMONRANGER_COMM_INIT",
  "POKEMONRANGER_COMM_IDLE",
  "POKEMONRANGER_COMM_CHECK_PARENT_INIT",
  "POKEMONRANGER_COMM_CHECK_PARENT",
  "POKEMONRANGER_COMM_CONNECT_WAIT_PARENT",
  "POKEMONRANGER_COMM_CREATE_SCREEN",
  "POKEMONRANGER_COMM_WAIT_FADE_CREATE_SCREEN",
  "POKEMONRANGER_COMM_CONNECT_WAIT2_PARENT",
  "POKEMONRANGER_COMM_SELECT_WAIT_PARENT",
  "POKEMONRANGER_COMM_FIND_PARENT",
  "POKEMONRANGER_COMM_SEND_USERDATA_WAIT",
  "POKEMONRANGER_COMM_RECV_PARENT_INIT",
  "POKEMONRANGER_COMM_RECV_PARENT",
  "POKEMONRANGER_COMM_RECV_SUCCESS",
  "POKEMONRANGER_COMM_SAVE_WAIT",
  "POKEMONRANGER_COMM_SAVE_DUMMY_WAIT",
  "POKEMONRANGER_COMM_SAVE_SYNC",
  "POKEMONRANGER_COMM_SAVE_SYNC_WAIT",
  "POKEMONRANGER_COMM_SAVE_SYNC_END",
  "POKEMONRANGER_COMM_RECV_END_WAIT",
  "POKEMONRANGER_COMM_RECV_END",
  "POKEMONRANGER_COMM_NOTFIND_PARENT",
  "POKEMONRANGER_COMM_DISCONNECT_PARENT",
  "POKEMONRANGER_COMM_TIMEOUT",
  "POKEMONRANGER_COMM_CANSEL",
  "POKEMONRANGER_COMM_STOP",
  "POKEMONRANGER_COMM_RETURN_TITLE",
  "POKEMONRANGER_COMM_LOOP",
  "POKEMONRANGER_COMM_RESET",
};
#endif


enum {
    POKEMONRANGER_COMM_INIT,			// [hJñtF[h҂
    POKEMONRANGER_COMM_IDLE,			// ʐMCȕ҂
    POKEMONRANGER_COMM_CHECK_PARENT_INIT,	// W[ie@jT߂̏
    POKEMONRANGER_COMM_CHECK_PARENT,		// W[ie@jT
    POKEMONRANGER_COMM_CONNECT_WAIT_PARENT,	// W[ie@j̐ڑ\҂ڑv
    POKEMONRANGER_COMM_CREATE_SCREEN,		// VKǉ@ʂ
    POKEMONRANGER_COMM_WAIT_FADE_CREATE_SCREEN,	// VKǉ@tF[hÎ҂
    POKEMONRANGER_COMM_CONNECT_WAIT2_PARENT,	// W[ie@j̐ڑ҂
    POKEMONRANGER_COMM_SELECT_WAIT_PARENT,	// W[ie@jƃf[^ʐM邩ǂ̑I
    POKEMONRANGER_COMM_FIND_PARENT,		// W[ie@jɐڑ [U[f[^M
    POKEMONRANGER_COMM_SEND_USERDATA_WAIT,	// W[ie@jւ̃[U[f[^MI҂
    POKEMONRANGER_COMM_RECV_PARENT_INIT,	// W[ie@jM邽߂̏
    POKEMONRANGER_COMM_RECV_PARENT,		// W[ie@jM
    POKEMONRANGER_COMM_RECV_SUCCESS,		// W[ie@j̎M ^}SZ[uJn
    POKEMONRANGER_COMM_SAVE_WAIT,		// ^}SZ[u
    POKEMONRANGER_COMM_SAVE_DUMMY_WAIT,		// W[ie@jɓ҂Õ_~[҂
    POKEMONRANGER_COMM_SAVE_SYNC,		// ^}SZ[uI W[ie@jɓ҂NGXg
    POKEMONRANGER_COMM_SAVE_SYNC_WAIT,		// W[ie@jɓ҂    
    POKEMONRANGER_COMM_SAVE_SYNC_END,
    POKEMONRANGER_COMM_RECV_END_WAIT,
    POKEMONRANGER_COMM_RECV_END,		// W[ie@j̎M^^}SZ[uI
    POKEMONRANGER_COMM_NOTFIND_PARENT,		// W[ie@jȂ^ڑłȂ
    POKEMONRANGER_COMM_DISCONNECT_PARENT,	// W[ie@jƂ̐ڑ
    POKEMONRANGER_COMM_TIMEOUT,			// W[Ƃ̒ʐM^CAEg
    POKEMONRANGER_COMM_CANSEL,			// W[Ƃ̒ʐMLZ
    POKEMONRANGER_COMM_STOP,			// W[Ƃ̑SĂ̒ʐMI
    POKEMONRANGER_COMM_RETURN_TITLE,		// ʐMIă^Cg֖߂
    POKEMONRANGER_COMM_LOOP,			// Ȃ
    POKEMONRANGER_COMM_RESET,			// Zbg

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/10
// [U[A{^͂𑣂V[PXĂs̏C𔽉f

#if AFTERMASTER_070207_POKEMONRANGER_CONNECTMENU_FIX
    POKEMONRANGER_COMM_SELECT_WAIT_PARENT_1,
    POKEMONRANGER_COMM_SELECT_WAIT_PARENT_2,
#endif

// ----------------------------------------------------------------------------

    POKEMONRANGER_COMM_END

} POKEMONRANGER_COMM;


enum {
  // CV[PX
  POKEMONRANGER_SEQ_INIT,			// ԍŏ̏ݒ
  POKEMONRANGER_SEQ_DISP_ERROR,			// NɃG[Ε\ďI
  POKEMONRANGER_SEQ_INIT_SCREEN,		// ŏ̉ʂ\
  POKEMONRANGER_SEQ_FULL_WARNING,		// xʕ\

  POKEMONRANGER_SEQ_MAIN,
  POKEMONRANGER_SEQ_DISP_CARD_INIT,
  POKEMONRANGER_SEQ_DISP_CARD,


  // r[RV[PX
  POKEMONRANGER_SEQ_BEACON_INIT,		// ]ɕKvȃf[^̏
  POKEMONRANGER_SEQ_BEACON_FIND,		// r[RTĐڑ
  POKEMONRANGER_SEQ_BEACON_WAIT,		// Ȃ
  POKEMONRANGER_SEQ_BEACON_MAIN,		// f[^̎M̑


  POKEMONRANGER_SEQ_RESET,			// \tgEFAZbg
  POKEMONRANGER_SEQ_FINISH,			// Iă^Cgʂ֖߂
  POKEMONRANGER_SEQ_FADE_WAIT,
  
  POKEMONRANGER_SEQ_END
} POKEMONRANGER_SEQ;


#define POKEMONDP_CONNECT_ID		21
#define POKEMONRANGER_CONNECT_CH	1


#define POKEMONRANGER_FRAMECHR1	1
#define POKEMONRANGER_FRAMECHR2	(POKEMONRANGER_FRAMECHR1+9)
#define POKEMONRANGER_WINDOWCHR	(POKEMONRANGER_FRAMECHR2+9)
#define WAKU_PALETTE_NUMBER1	2
#define WAKU_PALETTE_NUMBER2	3
#define	FONT_PAL_NO_N		( 0 )	// m[}pbg
#define	FONT_PAL_NO_S		( 1 )	// Ipbg
#define	POKEMONRANGER_BLACK	(GF_PRINTCOLOR_MAKE(1, 2, 15))
#define	POKEMONRANGER_WHITE	(GF_PRINTCOLOR_MAKE(15, 2, 0))

#define RGB(r, g, b)	(((b)&31)<<10|((g)&31)<<5|((r)&31))


static void StartMenu_RangerScreenInit(PROC * proc);
static void PokemonRangerInitSubScreen(POKEMONRANGER_WORK *wk);
static void DisplaySequence(PROC *proc, u32 msgid);
static void PokemonRanger_ScreenFinish(PROC *proc);

extern int CheckPokemonRangerBeacon(POKEMONRANGER_WORK *wk);
extern int DisablePokemonRangerBeacon(POKEMONRANGER_WORK *wk);

extern void StartMenu_BgInit(PROC * proc);

extern FUSHIGI_DATA * SaveData_GetFushigiData(SAVEDATA * sv);
extern void MysteryCard_DisplayCardOnly(GF_BGL_INI *bgl, void *, int heapid);



// [U[
static u16 ModeDptestName[PERSON_NAME_SIZE+EOM_SIZE] = { 0 };
// [U[hc
static u16 ModeDptestUserId[10] = { 0 };

// Mf[^obt@
static u8 ModeDptestRecvData[42] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, };

// MPʐMpfXNv^
static MpInitDesc init_desc = {
  22, 1, OS_LANGUAGE_JAPANESE, POKEMONDP_CONNECT_ID, ModeDptestUserId, ModeDptestName,
};


//------------------------------------------------------------------
/**
 * @brief	ZAN^[쓮pVBlankFunc
 */
//------------------------------------------------------------------
static void VBlankFunc( void * work )
{
  // ZAN^[Vram]}l[W[s
  DoVramTransferManager();
  // _LOAM}l[WVram]
  REND_OAMTrans();	
  OS_SetIrqCheckFlag( OS_IE_V_BLANK );
}

//------------------------------------------------------------------
/**
 * @brief	ʐMɕKvȃf[^̏
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void PokemonRangerInitConnectData(POKEMONRANGER_WORK *wk)
{
  int i;
  u32 code;
  const STRCODE *datap;

  // [U[RANGER-CODE֕ϊĊi[
  datap = MyStatus_GetMyName( wk->mst );
  for(i = 0; i < PERSON_NAME_SIZE+EOM_SIZE; i++)
    ModeDptestName[i] = ConvDP2Ranger(datap[i]);

  // [U[ID𕶎֕ϊĊi[
  code = MyStatus_GetID_Low(wk->mst);
  ConvDPDec2RangerDec(&ModeDptestUserId[0], code);
  ModeDptestUserId[5] = ranger_EOM_;
}


//------------------------------------------------------------------
/**
 * @brief	af
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void PokemonRangerInitScreen(POKEMONRANGER_WORK *wk)
{
  int type;

  GF_BGL_DISPVRAM tbl = {
    GX_VRAM_BG_128_A,				// C2DGWBG
    GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
    GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
    GX_VRAM_SUB_BGEXTPLTT_NONE,			// Tu2DGWBGgpbg
    GX_VRAM_OBJ_64_E,				// C2DGWOBJ
    GX_VRAM_OBJEXTPLTT_NONE,			// C2DGWOBJgpbg
    GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
    GX_VRAM_SUB_OBJEXTPLTT_NONE,		// Tu2DGWOBJgpbg
    GX_VRAM_TEX_0_B,				// eNX`C[WXbg
    GX_VRAM_TEXPLTT_01_FG			// eNX`pbgXbg
  };
  GF_BGL_SYS_HEADER BGsys_data = { GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D };

  GF_Disp_SetBank( &tbl );

  /* BG SYSTEM */
  GF_BGL_InitBG( &BGsys_data );
  MysteryLib_BgInitFrame(wk->bgl, GF_BGL_FRAME0_M, GF_BGL_SCRSIZ_256x256, 0xF000, 0x0000); /* MAIN DISP BG0 */
  MysteryLib_BgInitFrame(wk->bgl, GF_BGL_FRAME1_M, GF_BGL_SCRSIZ_256x256, 0xF800, 0x4000); /* MAIN DISP BG1 */
  MysteryLib_BgInitFrame(wk->bgl, GF_BGL_FRAME0_S, GF_BGL_SCRSIZ_256x256, 0x7800, 0x0000); /* SUB DISP BG0 */
  MysteryLib_BgInitFrame(wk->bgl, GF_BGL_FRAME1_S, GF_BGL_SCRSIZ_256x256, 0x7000, 0x4000); /* SUB DISP BG1 */
  MSG_PrintInit();

  /* bZ[W̃tHgJ[ݒ */
  SystemFontPaletteLoad(PALTYPE_MAIN_BG, POKEMONRANGER_WCOL_NORMAL * 32, wk->heapid);

  //EBhEgLApbgZbg
  MenuWinGraphicSet(wk->bgl, GF_BGL_FRAME0_M, POKEMONRANGER_FCHR,  POKEMONRANGER_FCOL,     0, wk->heapid);
  type = CONFIG_GetWindowType(wk->cfg);
  TalkWinGraphicSet(wk->bgl, GF_BGL_FRAME0_M, POKEMONRANGER_TWCHR, POKEMONRANGER_TWCOL, type, wk->heapid);

  // iq͗l\
  // Cʂafpbg]
  ArcUtil_PalSet(ARC_MYSTERY_GRA, NARC_mystery_fusigi_bg_00_nclr, PALTYPE_MAIN_BG, 16*2*8, 16*2, wk->heapid);
  // CBG1L]
  ArcUtil_BgCharSet(ARC_MYSTERY_GRA, NARC_mystery_fusigi_bg_00_lz_ccgr, wk->bgl,
		    GF_BGL_FRAME1_M, 0, 10*16*0x20, 1, wk->heapid);
  // CʃXN[P
  ArcUtil_ScrnSet(ARC_MYSTERY_GRA, NARC_mystery_fusigi_bg_00_lz_cscr, wk->bgl,
		  GF_BGL_FRAME1_M, 0, 32*24*2, 1, wk->heapid);
  GF_BGL_ScrPalChange(wk->bgl, GF_BGL_FRAME1_M, 0, 0, 32, 24, 8);
  GF_BGL_LoadScreenReq(wk->bgl, GF_BGL_FRAME1_M);
  // Tuʂ̊iq͗l\
  PokemonRangerInitSubScreen(wk);
}


//------------------------------------------------------------------
/**
 * @brief	Tuʂ̊iq͗l\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void PokemonRangerInitSubScreen(POKEMONRANGER_WORK *wk)
{
  // Tuʂafpbg]
  ArcUtil_PalSet(ARC_MYSTERY_GRA, NARC_mystery_fusigi_bg_00_nclr, PALTYPE_SUB_BG, 16*2*8, 16*2, wk->heapid);
  // TuBG1L]
  ArcUtil_BgCharSet(ARC_MYSTERY_GRA, NARC_mystery_fusigi_bg_00_lz_ccgr, wk->bgl,
		    GF_BGL_FRAME0_S, 0, 10*16*0x20, 1, wk->heapid);
  // TuʃXN[O
  ArcUtil_ScrnSet(ARC_MYSTERY_GRA, NARC_mystery_fusigi_bg_00_lz_cscr, wk->bgl,
		  GF_BGL_FRAME0_S, 0, 32*24*2, 1, wk->heapid);
  GF_BGL_ScrPalChange(wk->bgl, GF_BGL_FRAME0_S, 0, 0, 32, 24, 8);
  GF_BGL_LoadScreenReq(wk->bgl, GF_BGL_FRAME0_S);
}

//------------------------------------------------------------------
/**
 * @brief	ĂȂ̃G[\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static BOOL PokemonRangerNoHaveZukan(POKEMONRANGER_WORK *wk)
{
  MYSTERY_WIN mw;

  // G[\EBhEĂ邩ǂŔfs
  if(GF_BGL_BmpWinAddCheck(&wk->ewin) == FALSE){
    MysteryLib_WinInit1(&mw, &wk->ewin, POKEMONRANGER_WCOL_NORMAL, NARC_msg_bconfind_dat, POKEMONRANGER_FCHR, POKEMONRANGER_FCOL);
    MysteryLib_WinInit2(&mw, 22, 16,wk->chrbase);
    MysteryLib_CreateWin(wk->bgl, &mw, 5, 4, bcon_003);
    return TRUE;
  } else {
    // G[EBhE̕\
    if(sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL)){
      BmpMenuWinClear(&wk->ewin, WINDOW_TRANS_ON);
      GF_BGL_BmpWinDel(&wk->ewin);
      return FALSE;
    }
  }
  return TRUE;
}


//------------------------------------------------------------------
/**
 * @brief	܂̎Mʂ쐬
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void DisplayRangerStatus(POKEMONRANGER_WORK *wk);
static void PokemonRangerCreateScreen(POKEMONRANGER_WORK *wk)
{
  // ̃bZ[W\(bEBhEJ)
  MysteryLib_WinInit1(&wk->talkwin, &wk->twin,
		      POKEMONRANGER_WCOL_NORMAL, NARC_msg_mystery_dat, POKEMONRANGER_TWCHR, POKEMONRANGER_TWCOL);
  MysteryLib_WinInit2(&wk->talkwin, 27, 4, /*mystery_test_001,*/ wk->chrbase);
  MysteryLib_WinInit3(&wk->talkwin, MYSTERYLIB_WINTYPE_TALK, FONT_TALK);
  // u|PW[́@݂\nĂ܂v
  MysteryLib_CreateWin(wk->bgl, &wk->talkwin, 2, 19, mystery_ranger_005);
  wk->chrbase += MysteryLib_GetWindowChr(&wk->talkwin);

  // ʏ̃^Cg\
  MysteryLib_WinInit1(&wk->titlewin, &wk->ewin,
		      POKEMONRANGER_WCOL_NORMAL, NARC_msg_mystery_dat, POKEMONRANGER_FCHR, POKEMONRANGER_FCOL);
  MysteryLib_WinInit2(&wk->titlewin, 30, 4, /*mystery_01_012,*/ wk->chrbase);
  MysteryLib_WinInit3(&wk->titlewin, MYSTERYLIB_WINTYPE_NORMAL, FONT_TALK);
  MysteryLib_CreateWin(wk->bgl, &wk->titlewin, 1, 1, mystery_01_012);
  wk->chrbase += MysteryLib_GetWindowChr(&wk->titlewin);

  // AN^[
  MysteryLib_InitCPManager();
  MysteryLib_InitClactSystem();
  MysteryLib_InitClact(ARC_MYSTERY_GRA,
		       NARC_mystery_fusigi_cur_00_lz_ccgr,
		       NARC_mystery_fusigi_cur_nclr,
		       NARC_mystery_fusigi_cur_00_lz_ccer,
		       NARC_mystery_fusigi_cur_00_lz_canr,
		       GF_BGL_MAIN_DISP);
  // ACRo^
  wk->arrow = MysteryLib_MakeCLACT(GF_BGL_MAIN_DISP, wk->arrow, HW_LCD_WIDTH/2, 76, 1);
  
  DisplayRangerStatus(wk);
}


//------------------------------------------------------------------
/**
 * @brief	W[ɑɂ\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void DisplayRangerStatus(POKEMONRANGER_WORK *wk)
{
  u32 high, low, width, wsize;
  u8 mac_addr[6];
  MpMACAddData mac_data;
  WORDSET *word;

  word = WORDSET_Create(wk->heapid);

  MysteryLib_WinInit1(&wk->statwin, &wk->swin,
		      POKEMONRANGER_WCOL_NORMAL, NARC_msg_mystery_dat, POKEMONRANGER_FCHR, POKEMONRANGER_FCOL);
  MysteryLib_WinInit2(&wk->statwin, 26, 4, wk->chrbase);
  MysteryLib_WinInit3(&wk->statwin, MYSTERYLIB_WINTYPE_NORMAL, FONT_TALK);
  //  wk->chrbase += MysteryLib_GetWindowChr(&wk->statwin);
  wk->statwin.word = word;

  // Oݒ
  WORDSET_RegisterPlayerName(word, 0, wk->mst);
  // IDNo.ݒ
  WORDSET_RegisterNumber(word, 1, MyStatus_GetID_Low(wk->mst), 5, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT);
  MysteryLib_CreateWin(wk->bgl, &wk->statwin, 3, 13, mystery_ranger_001);

  // u݃io[v\
  wk->statwin.redrawflag = FALSE;
  MysteryLib_WinSetPos(&wk->statwin, 0, FontHeaderGet(FONT_SYSTEM, FONT_HEADER_SIZE_Y));
  MysteryLib_CreateWin(wk->bgl, &wk->statwin, -1, -1, mystery_ranger_003);
  // ݃io[Elŕ\
  OS_GetMacAddress(mac_addr);
  mac_data = MpMACAddArrayToMACAddData(mac_addr);
  MpMACAddressToConnectCode(mac_data.u.data32, &high, &low);
  WORDSET_RegisterNumber(word, 0, high, 4, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT);
  WORDSET_RegisterNumber(word, 1, low,  4, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT);
  wk->statwin.rightflag = TRUE;
  MysteryLib_CreateWin(wk->bgl, &wk->statwin, -1, -1, mystery_ranger_004);
  
  WORDSET_Delete(word);
}


//------------------------------------------------------------------
/**
 * @brief	pJ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void PokemonRangerFinish(PROC *proc)
{
  int i;
  POKEMONRANGER_WORK *wk = PROC_GetWork(proc);

  // ZAN^[폜
  MysteryLib_RemoveClact();
  
  // EBhEJ
  if(GF_BGL_BmpWinAddCheck(&wk->ewin) == TRUE){
    GF_BGL_BmpWinOff(&wk->ewin); GF_BGL_BmpWinDel(&wk->ewin);
    GF_BGL_BmpWinOff(&wk->twin); GF_BGL_BmpWinDel(&wk->twin);
    GF_BGL_BmpWinOff(&wk->swin); GF_BGL_BmpWinDel(&wk->swin);
  }
  // BGLJ
  GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME0_M);
  GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME1_M);
  GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME0_S);
  GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME1_S);
  sys_FreeMemoryEz(wk->bgl);
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	V[PX쓮ɕKvȃ[NGA
 * @param	wk	ʐM֌W[Nւ̃|C^
 * @return	NONE
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT PokemonRangerProc_Init(PROC * proc, int * seq)
{
  POKEMONRANGER_WORK *wk;

  wk = MysteryLib_InitProc(proc, HEAPID_POKEMONRANGER, sizeof(POKEMONRANGER_WORK), 0x20000);
  // eϐ̏
  wk->heapid = HEAPID_POKEMONRANGER;
  wk->bgl = GF_BGL_BglIniAlloc(wk->heapid);
  wk->sv = ((MAINWORK *)PROC_GetParentWork(proc))->savedata;
  wk->mst = SaveData_GetMyStatus(wk->sv);
  wk->zw = SaveData_GetZukanWork(wk->sv);
  wk->cfg = SaveData_GetConfig(wk->sv);
  // Cu
  MysteryLib_Init(wk->heapid);
  // ӂf[^̃|C^𓾂
  wk->fdata = SaveData_GetFushigiData(wk->sv);
  
  // ϐ
  wk->beacon_seq = POKEMONRANGER_SEQ_BEACON_WAIT;
  wk->chrbase =POKEMONRANGER_WCHR;
  wk->beacon_check_time = 0;
  wk->seq = POKEMONRANGER_COMM_INIT;
  wk->doproc = FALSE;

  // ʐMACR\邽߂̃q[vm
  sys_CreateHeap( HEAPID_BASE_SYSTEM, HEAPID_COMMICON, 0x300 );
  
  /* TEhf[^[h */
  Snd_DataSetByScene( SND_SCENE_AGB, SEQ_PRESENT, 1 );

  return PROC_RES_FINISH;
}


//------------------------------------------------------------------
/**
 * @brief	vZX̃C
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static PROC_RESULT PokemonRangerProc_Main(PROC * proc, int * seq)
{
  POKEMONRANGER_WORK *wk = PROC_GetWork(proc);
  
  switch(*seq){
  case POKEMONRANGER_SEQ_INIT:
    PokemonRangerInitScreen(wk);
    // ĂȂΌx\ă^Cg֖߂
    if(ZukanWork_GetZukanGetFlag(wk->zw) == FALSE)
      MysteryLib_RequestFade(WIPE_TYPE_FADEIN, POKEMONRANGER_SEQ_DISP_ERROR,  seq, POKEMONRANGER_SEQ_FADE_WAIT);
    else
      *seq = POKEMONRANGER_SEQ_INIT_SCREEN;
    break;

  case POKEMONRANGER_SEQ_DISP_ERROR:
    // NɃG[Ε\ďI
    if(PokemonRangerNoHaveZukan(wk) == FALSE){
      MysteryLib_ChangeFadeType(1);
      MysteryLib_RequestFade(WIPE_TYPE_FADEOUT, POKEMONRANGER_SEQ_FINISH, seq, POKEMONRANGER_SEQ_FADE_WAIT);
    }
    break;
    
  case POKEMONRANGER_SEQ_INIT_SCREEN:
    // ŏ̉ʂ\
    PokemonRangerCreateScreen(wk);

#if 0
    if(FUSHIGIDATA_CheckCardDataSpace(wk->fdata) == FALSE){
      // J[ḧ悪ς̏ꍇ͌x\ďI
      wk->talkwin.msgspd = 1;
      wk->warning_msg = MysteryLib_CreateWin(wk->bgl, &wk->talkwin, 2, 19, mystery_err_005);
      MysteryLib_RequestFade(WIPE_TYPE_FADEIN, POKEMONRANGER_SEQ_FULL_WARNING,  seq, POKEMONRANGER_SEQ_FADE_WAIT);
    } else
#endif
      if(FUSHIGIDATA_CheckDeliDataSpace(wk->fdata) == FALSE){
      // zBς̏ꍇ͌x\ďI
      wk->talkwin.msgspd = 1;
      wk->warning_msg = MysteryLib_CreateWin(wk->bgl, &wk->talkwin, 2, 19, mystery_err_001);
      MysteryLib_RequestFade(WIPE_TYPE_FADEIN, POKEMONRANGER_SEQ_FULL_WARNING,  seq, POKEMONRANGER_SEQ_FADE_WAIT);
    } else {
      // r[RJn
      wk->beacon_seq = POKEMONRANGER_SEQ_BEACON_INIT;
      MysteryLib_RequestFade(WIPE_TYPE_FADEIN, POKEMONRANGER_SEQ_MAIN,  seq, POKEMONRANGER_SEQ_FADE_WAIT);
    }
    break;

  case POKEMONRANGER_SEQ_FULL_WARNING:
    // xʕ\
    if(GF_MSG_PrintEndCheck(wk->warning_msg) == 0 && sys.trg & PAD_BUTTON_DECIDE){
      MysteryLib_ChangeFadeType(1);
      MysteryLib_RequestFade(WIPE_TYPE_FADEOUT, POKEMONRANGER_SEQ_FINISH,  seq, POKEMONRANGER_SEQ_FADE_WAIT);
    }
    break;
    
  case POKEMONRANGER_SEQ_MAIN:
    // ŒʐM̃Cs
    wk->beacon_ret = CheckPokemonRangerBeacon(wk);
    // I邩ALZ܂ő҂
    if(wk->beacon_ret == POKEMONRANGER_RET_CANCEL){
      MysteryLib_ChangeFadeType(1);
      MysteryLib_RequestFade(WIPE_TYPE_FADEOUT, POKEMONRANGER_SEQ_FINISH,  seq, POKEMONRANGER_SEQ_FADE_WAIT);
    } else if(wk->beacon_ret == POKEMONRANGER_RET_SUCCESS){
#if 0
      MysteryLib_RequestFade(WIPE_TYPE_FADEOUT, POKEMONRANGER_SEQ_DISP_CARD_INIT, seq, POKEMONRANGER_SEQ_FADE_WAIT);
#else
      MysteryLib_ChangeFadeType(1);
      MysteryLib_RequestFade(WIPE_TYPE_FADEOUT, POKEMONRANGER_SEQ_FINISH,  seq, POKEMONRANGER_SEQ_FADE_WAIT);
#endif
    }
    break;

  case POKEMONRANGER_SEQ_DISP_CARD_INIT:
    // ʂ͊iq͗l𕜊
    PokemonRangerInitSubScreen(wk);
    GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
    GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
    // ʂ̓J[h̕\
    MysteryCard_DisplayCardOnly(wk->bgl, &wk->gc, HEAPID_POKEMONRANGER);
    MysteryLib_RequestFade(WIPE_TYPE_FADEIN, POKEMONRANGER_SEQ_DISP_CARD, seq, POKEMONRANGER_SEQ_FADE_WAIT);
    wk->gc.beacon.have_card = 0;
    break;

  case POKEMONRANGER_SEQ_DISP_CARD:
    if(sys.trg)
      MysteryLib_RequestFade(WIPE_TYPE_FADEOUT, POKEMONRANGER_SEQ_RESET,  seq, POKEMONRANGER_SEQ_FADE_WAIT);
    break;

  case POKEMONRANGER_SEQ_RESET:
    // ΍̎ɂ\tgEFAZbg
    OS_ResetSystem(0); 
    break;

  case POKEMONRANGER_SEQ_FINISH:
    // nă^Cg֖߂
    PokemonRangerFinish(proc);
    return PROC_RES_FINISH;
    break;
    
  case POKEMONRANGER_SEQ_FADE_WAIT:
    // tF[hI܂ő҂Ď̃V[PX
    MysteryLib_FadeEndCheck(seq);
    break;
  }

  // ACR\邽߂ɕKvȋ쓮
  MysteryLib_DoClact();

  return PROC_RES_CONTINUE;
}
//#include "demo/title.h"
FS_EXTERN_OVERLAY( title );
static PROC_RESULT PokemonRangerProc_End(PROC * proc, int * seq)
{
  sys_DeleteHeap(HEAPID_COMMICON);
  Main_SetNextProc(FS_OVERLAY_ID(title), &TitleProcData);
  PROC_FreeWork(proc);
  sys_DeleteHeap(HEAPID_POKEMONRANGER);

  OS_TPrintf("I܂\n");

  return PROC_RES_FINISH;
}


//------------------------------------------------------------------
/**
 * @brief	|PW[̃Z[uf[^쐬
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void CreatePokemonRangerSaveData(POKEMONRANGER_WORK *wk)
{
  RTCDate date;
  STRBUF * msg;
  WORDSET *word;
  MSGDATA_MANAGER *msgman;
#if 0
  GIFT_CARD *gc = sys_AllocMemory(wk->heapid, sizeof(GIFT_CARD));
#else
  GIFT_CARD *gc = &wk->gc;
#endif
  MI_CpuClear8(gc, sizeof(GIFT_CARD));

  msgman = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_mystery_dat, wk->heapid);
  word = WORDSET_Create(wk->heapid);

  // J[h̃f[^쐬
  gc->gift_type = MYSTERYGIFT_TYPE_RANGEREGG;	// ̃^Cv́u}itB̂܂v
  
  // J[h^Cg̐ݒ
  msg = MSGDAT_UTIL_AllocExpandString(word, msgman, mystery_ranger_011, wk->heapid);
  STRBUF_GetStringCode((const STRBUF *)msg, gc->beacon.event_name, GIFT_DATA_CARD_TITLE_MAX);
  STRBUF_Delete(msg);

  gc->beacon.version = (			// Ώۃo[W
			MysteryLib_GetCasetteCode(VERSION_DIAMOND) |
			MysteryLib_GetCasetteCode(VERSION_PEARL) |
			MysteryLib_GetCasetteCode(VERSION_DP_NEXT));
  gc->beacon.event_id = MYSTERYGIFT_MANAFIEGG;	// }itB̂܂͂P
  gc->beacon.only_one_flag = 0;			// PxzMtO(xł󂯎)
  gc->beacon.access_point = 0;			// ANZX|Cg()
  gc->beacon.have_card = 1;			// J[h܂ł
  gc->beacon.delivery_flag = 1;			// zB󂯎̂܂ł
  gc->beacon.groundchild_flag = 0;		// zzł͂Ȃ
  
  // CxgeLXg̐̕ݒ
  msg = MSGDAT_UTIL_AllocExpandString(word, msgman, mystery_ranger_010, wk->heapid);
  STRBUF_GetStringCode((const STRBUF *)msg, gc->event_text, GIFT_DATA_CARD_TEXT_MAX);
  STRBUF_Delete(msg);

  gc->re_deal_count = 0;			// Ĕzz̉(Ĕzz͏oȂ)
  gc->pokemon_icon[0] = MONSNO_MANAFI;		// |PACR(}itB)
  gc->pokemon_icon[1] = 0;			// |PACR(Ȃ)
  gc->pokemon_icon[2] = 0;			// |PACR(Ȃ)
  gc->re_dealed_count = 0;			// zz
  GF_RTC_GetDate(&date);
  gc->recv_date = RTC_ConvertDateToDay(&date);	// Z[ut

  WORDSET_Delete(word);
  MSGMAN_Delete(msgman);
			
  // Z[üɓo^(Oɋ󂫗̈`FbNĂ̂Ő΂ɑv)
#if 0
  FUSHIGIDATA_SetCardData(wk->fdata, gc);
#else
  FUSHIGIDATA_SetDeliData(wk->fdata, &gc->gift_type, 0);
#endif
#if 1
  // ŉʂ̍XV(󂯎Aj[Vǉ)
  GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
  MysteryLib_InitGift(wk->bgl, (GIFT_DELIVERY *)gc);
#endif
#if 0
  // n
  sys_FreeMemoryEz(gc);
#endif
}


//------------------------------------------------------------------
/**
 * @brief	^CAEgݒ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void PokemonRangerSetTimeOut(POKEMONRANGER_WORK *wk, int time)
{
  wk->mp_time_out = time;
}


//------------------------------------------------------------------
/**
 * @brief	^CAEgAʐMؒfALZ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static int PokemonRangerCheckConnect(POKEMONRANGER_WORK *wk, int *seq, int flag, u32 key)
{
  // ^CAEg
  if(--wk->mp_time_out == 0){
    MpRequestClose();
    *seq = POKEMONRANGER_COMM_TIMEOUT;
    return 0;
  }
  if(flag){
    // ʐMؒf`FbN
    if(!MpIsConnect()){
      MpRequestClose();
      *seq = POKEMONRANGER_COMM_DISCONNECT_PARENT;
      return 0;
    }
  }
  // LZ`FbN
  if(key && sys.trg & key){
    MpRequestClose();
    *seq = POKEMONRANGER_COMM_RETURN_TITLE;
    return 1;
  }
  return 0;
}



//--------------------------------------------------------------------------------------------
/**
 * |PW[Ƃ̒ʐMV[PX
 * ̏src/system/startmenu.cĂяo܂
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
int CheckPokemonRangerBeacon(POKEMONRANGER_WORK *wk)
{
  int num, v1;
  u16 *p1;
  int *seq = &wk->seq;

  // CȕI܂łMpProcĂяoȂ
  if(wk->doproc == TRUE){
    WirelessIconEasy_SetLevel(WM_LINK_LEVEL_3 - MpGetConnectLinkLevel());
    // C쓮
    MpProc();
    // gp|[gԍݒ
    MpSetChannel(POKEMONRANGER_CONNECT_CH);
  }

  //  MIT_PRINTF("seq = %d %s\n", *seq, vtable[*seq]);

  switch(*seq){
  case POKEMONRANGER_COMM_INIT:
    /// VRAMDɃCNj[
    PokemonRangerInitConnectData(wk);
    CommVRAMDInitialize();
    wk->commvramload = TRUE;
    *seq = POKEMONRANGER_COMM_IDLE;
    break;

  case POKEMONRANGER_COMM_IDLE:
    /// VRAMDփCNj[̂҂
    if(CommIsVRAMDInitialize()){
      // ʐM
      MpInit(&init_desc, wk->mp_buf);
      // ȍ~MpProcĂяoOK
      wk->doproc = TRUE;
      // ʐMACR\
      WirelessIconEasy();
      *seq = POKEMONRANGER_COMM_CHECK_PARENT_INIT;
    }
    break;

  case POKEMONRANGER_COMM_CHECK_PARENT_INIT:
    // q@ƂĒʐMJn
    MpRequestScan();
    // ^CAEg1600t[
    PokemonRangerSetTimeOut(wk, 1600);
    wk->time_icon = TimeWaitIconAdd(&wk->twin, POKEMONRANGER_TWCHR);
    *seq = POKEMONRANGER_COMM_CHECK_PARENT;
    break;

  case POKEMONRANGER_COMM_CHECK_PARENT:
    // e@iW[j҂
    num = MpGetConnectListNum();
    if (num) {
      // |PW[𔭌I
      wk->connect_num = num - 1;
      // ^CAEgݒ
      PokemonRangerSetTimeOut(wk, 1800);
      *seq = POKEMONRANGER_COMM_CONNECT_WAIT_PARENT;
    }
    // ^CAEgAʐMؒfALZ
    PokemonRangerCheckConnect(wk, seq, 0, PAD_BUTTON_CANCEL);

    break;

    // ڑ
    
  case POKEMONRANGER_COMM_CONNECT_WAIT_PARENT:
    // e@iW[j̐ڑ\҂
    if (MpGetConnectParentEnable(wk->connect_num)) {
      // ڑv
      MpConnectParent(wk->connect_num);
      *seq = POKEMONRANGER_COMM_CONNECT_WAIT2_PARENT;
      wk->mp_time_out = 1800;
    }
    // ^CAEgAʐMؒfALZ
    PokemonRangerCheckConnect(wk, seq, 0, PAD_BUTTON_CANCEL);
    break;

  case POKEMONRANGER_COMM_CONNECT_WAIT2_PARENT:
    // e@iW[j̐ڑ҂

    // ^CAEgAʐMؒfALZ
    PokemonRangerCheckConnect(wk, seq, 0, PAD_BUTTON_CANCEL);

    // ڑłPOKEMONRANGER_COMM_SELECT_WAIT_PARENT
    if (MpIsConnect()) {
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/10
// [U[A{^͂𑣂V[PXĂs̏C𔽉f
#if AFTERMASTER_070207_POKEMONRANGER_CONNECTMENU_FIX
      *seq = POKEMONRANGER_COMM_SELECT_WAIT_PARENT_1;
#else
      *seq = POKEMONRANGER_COMM_SELECT_WAIT_PARENT;
#endif
// ----------------------------------------------------------------------------
    }    
    break;

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/10
// [U[A{^͂𑣂V[PXĂs̏C𔽉f

#if AFTERMASTER_070207_POKEMONRANGER_CONNECTMENU_FIX
  case POKEMONRANGER_COMM_SELECT_WAIT_PARENT_1:
    MysteryLib_CreateWin(wk->bgl, &wk->talkwin, 2, 19, mystery_test_002); // u`{^@ā@v
    // ACRꎞIɏ
    CLACT_SetDrawFlag(wk->arrow, 0);
    TimeWaitIconDel(wk->time_icon);
    wk->time_icon = NULL;
    Snd_SePlay(SEQ_SE_DP_SELECT);
    wk->mp_time_out = 1800;
    *seq = POKEMONRANGER_COMM_SELECT_WAIT_PARENT_2;
    break;
  case POKEMONRANGER_COMM_SELECT_WAIT_PARENT_2:
    if(sys.trg & PAD_BUTTON_DECIDE){
      *seq = POKEMONRANGER_COMM_SELECT_WAIT_PARENT;
    }
    // ^CAEgAʐMؒfALZ
    PokemonRangerCheckConnect(wk, seq, 1, PAD_BUTTON_CANCEL);
    break;
#endif

// ----------------------------------------------------------------------------

  case POKEMONRANGER_COMM_SELECT_WAIT_PARENT:
    // W[ie@jƃf[^ʐM邩ǂ̑I
    // |PW[֐ڑ
    MpSetSendRedy();
    *seq = POKEMONRANGER_COMM_FIND_PARENT;
    wk->mp_time_out = 1800;
    // ^CAEgAʐMؒfALZ
    PokemonRangerCheckConnect(wk, seq, 1, PAD_BUTTON_CANCEL);
    break;

  case POKEMONRANGER_COMM_FIND_PARENT:
    // f[^MvʐMIH
    if (MpIsSendDataEnd()) {
      // ̃[U[f[^M
      MpSetSendUserData();
      *seq = POKEMONRANGER_COMM_SEND_USERDATA_WAIT;
      wk->mp_time_out = 3200;
      // u|PW[́@߂\n^b`@Ă
      MysteryLib_CreateWin(wk->bgl, &wk->talkwin, 2, 19, mystery_test_006);
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/10
// [U[A{^͂𑣂V[PXĂs̏C𔽉f
#if AFTERMASTER_070207_POKEMONRANGER_CONNECTMENU_FIX
      // Ȃ
#else
      // ACRꎞIɏ
      CLACT_SetDrawFlag(wk->arrow, 0);
      TimeWaitIconDel(wk->time_icon);
#endif
// ----------------------------------------------------------------------------
      Snd_SePlay(SEQ_SE_DP_SELECT);
      wk->time_icon = NULL;

      return POKEMONRANGER_RET_FOUNDRANGER;
    }    
    // ^CAEgAʐMؒfALZ
    PokemonRangerCheckConnect(wk, seq, 1, PAD_BUTTON_CANCEL);
    break;


    // ȍ~̓CV[PX
    
  case POKEMONRANGER_COMM_SEND_USERDATA_WAIT:
    // MIō̓W[̃f[^󂯎
    if (MpIsSendDataEnd()) {
      // u|PW[\nĂ񂻂@܂Ă܂v
      MysteryLib_CreateWin(wk->bgl, &wk->talkwin, 2, 19, mystery_ranger_006);
      // ACR\
      CLACT_SetDrawFlag(wk->arrow, 1);

      DisplayRangerStatus(wk);
      *seq = POKEMONRANGER_COMM_RECV_PARENT_INIT;
    }
    // ^CAEgAʐMؒfALZ
    PokemonRangerCheckConnect(wk, seq, 1, PAD_BUTTON_CANCEL);
    break;
      
  case POKEMONRANGER_COMM_RECV_PARENT_INIT:
    // e@iW[j̃f[^MJn
    MpSetRecvData(ModeDptestRecvData, 42, 1);
    *seq = POKEMONRANGER_COMM_RECV_PARENT;
    wk->mp_time_out = 3200;
    break;

  case POKEMONRANGER_COMM_RECV_PARENT:
    // f[^̎MI܂ő҂
    if (MpIsRecvDataEnd()) {
      *seq = POKEMONRANGER_COMM_RECV_SUCCESS;
      wk->mp_time_out = 60;
      // u^}Ś@サɁ@@܂v
      MysteryLib_CreateWin(wk->bgl, &wk->talkwin, 2, 19, mystery_ranger_006);
    }
    // ^CAEgAʐMؒfALZ
    PokemonRangerCheckConnect(wk, seq, 1, PAD_BUTTON_CANCEL);
    break;

  case POKEMONRANGER_COMM_RECV_SUCCESS:
    if(--wk->mp_time_out == 0){
      // Z[uJn
      // u|[g@Ă܂@΂炭@܂@v
      MysteryLib_CreateWin(wk->bgl, &wk->talkwin, 2, 19, mystery_ranger_007);
      wk->time_icon = TimeWaitIconAdd(&wk->twin, POKEMONRANGER_TWCHR);

      // Z[uf[^쐬
      CreatePokemonRangerSaveData(wk);
      // Z[uJn
      MysteryLib_InitSaveDSCard(wk->sv);

      *seq = POKEMONRANGER_COMM_SAVE_WAIT;
    }
    break;

  case POKEMONRANGER_COMM_SAVE_WAIT:
    // Z[uI҂
    if(MysteryLib_SaveDSCard() == SAVE_RESULT_LAST){
      *seq = POKEMONRANGER_COMM_SAVE_DUMMY_WAIT;
      wk->mp_time_out = 6 + (OS_GetTickLo() % 54);
    }
    break;

  case POKEMONRANGER_COMM_SAVE_DUMMY_WAIT:
    // W[ie@jɓ҂Õ_~[҂
    if (--wk->mp_time_out == 0) {
      *seq = POKEMONRANGER_COMM_SAVE_SYNC;
    }
    break;

  case POKEMONRANGER_COMM_SAVE_SYNC:
    // W[ie@jɓpf[^MJn
    // ̂߂Ƀf[^M
    MpSetRecvData(ModeDptestRecvData, 42, 2);
    *seq = POKEMONRANGER_COMM_SAVE_SYNC_WAIT;
    wk->mp_time_out = 1200;
    break;

  case POKEMONRANGER_COMM_SAVE_SYNC_WAIT:
    // f[^MIōŌ̃Z[u
    if(MpIsRecvDataAcknowledge()) {
      // Ō̂PZN^Z[u
#if 0
      MysteryLib_SaveDSCard();
#else
      MysteryLib_DoLastSave();
#endif
      
      *seq = POKEMONRANGER_COMM_SAVE_SYNC_END;
      wk->mp_time_out = 800;
      break;
    }
    // 莞Ԃo߂ĂʐMoȂ
    if(--wk->mp_time_out == 0){
      MpRequestClose();
      *seq = POKEMONRANGER_COMM_TIMEOUT;
      wk->mp_time_out = 120;
    }
    // ڑ؂ꂽ
    if (!MpIsConnect()) {
      MpRequestClose();
      *seq = POKEMONRANGER_COMM_DISCONNECT_PARENT;
      wk->mp_time_out = 120;
    }
    break;
      
  case POKEMONRANGER_COMM_SAVE_SYNC_END:
    // Z[ȕImFAf[^MI҂
    if(MysteryLib_GetSaveStatus() == MYSTERYLIB_SEQ_SAVE_NG){
      MpRequestClose();
      *seq = POKEMONRANGER_COMM_DISCONNECT_PARENT;
      wk->mp_time_out = 120;
    } else if(MysteryLib_GetSaveStatus() != MYSTERYLIB_SEQ_SAVE_OK){
      MysteryLib_SaveDSCard();
    } else {
      if(MpIsRecvDataEnd() || (!MpIsConnect())){
	*seq = POKEMONRANGER_COMM_RECV_END_WAIT;
	wk->mp_time_out = 1 /*120*/;
	MpRequestClose();
	break;
      }
    }
    // 莞Ԃo߂ĂʐMoȂ
    if(--wk->mp_time_out == 0){
      MpRequestClose();
      *seq = POKEMONRANGER_COMM_TIMEOUT;
      wk->mp_time_out = 10;
    }
      
  case POKEMONRANGER_COMM_RECV_END_WAIT:
    // W[ie@jɓ҂
    if (--wk->mp_time_out == 0) {
      *seq = POKEMONRANGER_COMM_RECV_END;
      // uĂ񂻂@イ傤@܂\n`{^Ł@ł񂰂@܂v
      MysteryLib_CreateWin(wk->bgl, &wk->talkwin, 2, 19, mystery_ranger_008);
      // ACR̕\~߂
      CLACT_SetDrawFlag(wk->arrow, 0);
      TimeWaitIconDel(wk->time_icon);
      Snd_SePlay(SEQ_SE_DP_SELECT);
      wk->time_icon = NULL;
    }
    break;
      
  case POKEMONRANGER_COMM_RECV_END:
    // W[ie@j̎M^^}SZ[uI
    if (MpIsEnd()) {
      if(wk->commvramload == TRUE){
	CommVRAMDFinalize();
	WirelessIconEasyEnd(); // ʐMACR폜
	wk->commvramload = FALSE;
      }
      if(sys.trg & PAD_BUTTON_DECIDE){
	*seq = POKEMONRANGER_COMM_LOOP;
	return POKEMONRANGER_RET_SUCCESS;
      }
    }
    break;

    
  case POKEMONRANGER_COMM_DISCONNECT_PARENT:
    // ^CAEgʐMؒf𓯂ɂ܂
    *seq = POKEMONRANGER_COMM_TIMEOUT;
  case POKEMONRANGER_COMM_TIMEOUT:
    // W[Ƃ̒ʐM^CAEg
    // u|PW[Ƃ́@񂪁@@܂v
    MysteryLib_CreateWin(wk->bgl, &wk->talkwin, 2, 19, mystery_ranger_009);
    // ACR̕\~߂
    CLACT_SetDrawFlag(wk->arrow, 0);
    if(wk->time_icon)
      TimeWaitIconDel(wk->time_icon);
    wk->time_icon = NULL;
    *seq = POKEMONRANGER_COMM_RESET;
    break;

  case POKEMONRANGER_COMM_RESET:
    // ʐMIăZbg
    if (MpIsEnd()){
      if(wk->commvramload == TRUE){
	CommVRAMDFinalize();
	WirelessIconEasyEnd(); // ʐMACR폜
	wk->commvramload = FALSE;
      }
      if(sys.trg & PAD_BUTTON_DECIDE){
	OS_ResetSystem(0); 
      }
    }      
    break;

  case POKEMONRANGER_COMM_RETURN_TITLE:
    // ʐMIă^Cg֖߂
    if (MpIsEnd()){
      if(wk->commvramload == TRUE){
	CommVRAMDFinalize();
	WirelessIconEasyEnd(); // ʐMACR폜
	wk->commvramload = FALSE;
	if(wk->time_icon)
	  TimeWaitIconDel(wk->time_icon);
	return POKEMONRANGER_RET_CANCEL;
      }
    }      
    break;

    
  case POKEMONRANGER_COMM_LOOP:
    break;
    
  }
  return POKEMONRANGER_RET_NONE;
}

#if 0
//--------------------------------------------------------------------------------------------
/**
 * |PW[Ƃ̒ʐMV[PXI
 *
 * @param	none
 * @return	none
 */
//--------------------------------------------------------------------------------------------
int DisablePokemonRangerBeacon(POKEMONRANGER_WORK *wk)
{
  if(wk->disable == TRUE){
    MpRequestClose();
    wk->disable = FALSE;
  } else {
    if (MpIsEnd()) {
      /// VRAMD̃CNj[̂Ă
      CommVRAMDFinalize();
      wk->doproc = FALSE;
      WirelessIconEasyEnd(); // ʐMACR폜
      return TRUE;
    }
  }
  return FALSE;
}
#endif

const PROC_DATA PokemonRangerProcData = {
  PokemonRangerProc_Init,
  PokemonRangerProc_Main,
  PokemonRangerProc_End,
  NO_OVERLAY_ID,
};



/*  */
