//============================================================================================
/**
 * @file	wifi_mystery_figt.c
 * @bfief	WiFi ӂȁ@
 * @author	Satoshi Mitsuhara
 * @date	06.06.23
 *
 */
//============================================================================================
#include <dwc.h>

#include "system/heapdefine.h"
#include "communication/communication.h"
#include "communication/comm_state.h"
#include "communication/wm_icon.h"
#include "wifi/dwc_rap.h"

#include "comm_mystery_gift.h"
#include "mysterylib.h"

// RpC`

#define NETCONFIG_USE_HEAP		1

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/09/07
// ڑ version t@C PG5_WIFIRELEASE = yes/no Ő؂ւ悤
// ----------------------------------------------------------------------------

// ̂܂ROMɓƊ댯Ȃ̂ŁAňÍl悤ˁc
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/10
// _E[h̐ڑꂲƂɐ؂芷
// localize_spec_mark(LANG_ALL) imatake 2007/02/23
// pX[h̐؂芷 PG5_WIFIRELEASE ɘAĂȂ̂C
// localize_spec_mark(LANG_KOREA) imatake 2007/06/27
// ؍łmakeɑΉ

#if   PM_LANG == LANG_JAPAN
#define WIFI_ND_LOGIN_NAME		"ADAJ"			// OCE
#elif PM_LANG == LANG_ENGLISH
#define WIFI_ND_LOGIN_NAME		"ADAE"			// OCEp
#elif PM_LANG == LANG_FRANCE
#define WIFI_ND_LOGIN_NAME		"ADAF"			// OCE
#elif PM_LANG == LANG_ITALY
#define WIFI_ND_LOGIN_NAME		"ADAI"			// OCE
#elif PM_LANG == LANG_GERMANY
#define WIFI_ND_LOGIN_NAME		"ADAD"			// OCE
#elif PM_LANG == LANG_SPAIN
#define WIFI_ND_LOGIN_NAME		"ADAS"			// OCE
#elif PM_LANG == LANG_KOREA
#define WIFI_ND_LOGIN_NAME		"ADAK"			// OCE
#endif

#ifdef PG5_WIFIRELEASE
#if   PM_LANG == LANG_JAPAN
#define WIFI_ND_LOGIN_PASSWD		"E3npkZwqAHyGCNVb"	// pX[h({ԃT[o)E
#elif PM_LANG == LANG_ENGLISH
#define WIFI_ND_LOGIN_PASSWD		"Sx439tCkbrWyR8X2"	// pX[h({ԃT[o)Ep
#elif PM_LANG == LANG_FRANCE
#define WIFI_ND_LOGIN_PASSWD		"ZzujfnFc5NAy3Bdv"	// pX[h({ԃT[o)E
#elif PM_LANG == LANG_ITALY
#define WIFI_ND_LOGIN_PASSWD		"ZzujfnFc5NAy3Bdv"	// pX[h({ԃT[o)E
#elif PM_LANG == LANG_GERMANY
#define WIFI_ND_LOGIN_PASSWD		"ZzujfnFc5NAy3Bdv"	// pX[h({ԃT[o)E
#elif PM_LANG == LANG_SPAIN
#define WIFI_ND_LOGIN_PASSWD		"ZzujfnFc5NAy3Bdv"	// pX[h({ԃT[o)E
#elif PM_LANG == LANG_KOREA
#define WIFI_ND_LOGIN_PASSWD		"FPmMDZU5y2VjLbAd"	// pX[h({ԃT[o)E
#endif
#else
#if   PM_LANG == LANG_JAPAN
#define WIFI_ND_LOGIN_PASSWD		"XqQPTBt56uEndmND"	// pX[h(eXgT[o)E
#elif PM_LANG == LANG_ENGLISH
#define WIFI_ND_LOGIN_PASSWD		"6E3tTdZcA9niNVw4"	// pX[h(eXgT[o)Ep
#elif PM_LANG == LANG_FRANCE
#define WIFI_ND_LOGIN_PASSWD		"kNf6BzRbQ7TtxYZG"	// pX[h(eXgT[o)E
#elif PM_LANG == LANG_ITALY
#define WIFI_ND_LOGIN_PASSWD		"kNf6BzRbQ7TtxYZG"	// pX[h(eXgT[o)E
#elif PM_LANG == LANG_GERMANY
#define WIFI_ND_LOGIN_PASSWD		"kNf6BzRbQ7TtxYZG"	// pX[h(eXgT[o)E
#elif PM_LANG == LANG_SPAIN
#define WIFI_ND_LOGIN_PASSWD		"kNf6BzRbQ7TtxYZG"	// pX[h(eXgT[o)E
#elif PM_LANG == LANG_KOREA
#define WIFI_ND_LOGIN_PASSWD		"fa6ts4GqLxbXHeMd"	// pX[h(eXgT[o)E
#endif
#endif

// ----------------------------------------------------------------------------

#define WIFI_FILE_ATTR1			""
#define WIFI_FILE_ATTR2			""
#define WIFI_FILE_ATTR3			""

// -- ND Ɋ֘A萔 --

enum {
  WIFI_MYSTERYGIFT_COMM_INIT = WIFI_MYSTERYGIFT_BASE,// Cu
  WIFI_MYSTERYGIFT_COMM_INIT_WAIT,		// Cȕ܂ő҂

  WIFI_MYSTERYGIFT_CONNECT_INET,		// C^[lbgւ̐ڑ
  WIFI_MYSTERYGIFT_CONNECT_WAIT_INET,		// ڑ܂ő҂

  WIFI_MYSTERYGIFT_NASLOGIN_START,		// F؃T[o[փOCJn
  WIFI_MYSTERYGIFT_NASLOGIN_WAIT,		// F؃T[o[փOC܂ő҂
  
  WIFI_MYSTERYGIFT_NDLIB_INIT,			// _E[hJn
  WIFI_MYSTERYGIFT_SET_ATTR,			// t@CANZX̐ݒ
  WIFI_MYSTERYGIFT_GET_FILENUM,			// T[o[ɂt@C𓾂
  WIFI_MYSTERYGIFT_GET_FILELIST,		// T[o[ɂt@CXg𓾂
  WIFI_MYSTERYGIFT_GET_FILE,			// t@C擾Jn
  WIFI_MYSTERYGIFT_GETTING_FILE,		// t@C擾

  WIFI_MYSTERYGIFT_DOWNLOAD_CANCEL,		// _E[h[U[LZ
  WIFI_MYSTERYGIFT_DOWNLOAD_COMPLETE,		// _E[hI
  WIFI_MYSTERYGIFT_DOWNLOAD_ERROR_LOOP,		// G[҂
  WIFI_MYSTERYGIFT_DOWNLOAD_ERROR_WAIT,		// callbackĂяo܂ŏ҂
  WIFI_MYSTERYGIFT_DOWNLOAD_ERROR,		// G[\̕A
  
  WIFI_MYSTERYGIFT_WAIT_CALLBACK1,		// R[obNĂ΂܂ő҂
  WIFI_MYSTERYGIFT_WAIT_CALLBACK2,		// R[obNĂ΂܂ő҂

  WIFI_MYSTERYGIFT_MAX
};


static u8 dwcWork[ DWC_INIT_WORK_SIZE ] ATTRIBUTE_ALIGN( 32 );
static BOOL callbackflag1;
static BOOL callbackflag2;
static wifi_result;
static DWCNdFileInfo fileInfo[ FILE_NUM ];

// vg^Cv錾
static void NdCleanupCallback( void );

// {̂comm_mystery_gift.c

int WifiMysteryGift_Main(PROC *proc, int *seq);


/*-------------------------------------------------------------------------*
 * Name        : AllocFunc
 * Description : mۊ֐
 * Arguments   : name  - mۂ閼O
 *             : size  - mۂTCY
 *             : align - mۂACg
 * Returns     : *void - mۂ|C^
 *
 * sys_AllocMemory4byteEŕԂĂ邽߁A𖳗32byteE
 * ACgB
 * ԂAhX-44byteɌallocAhXۑĂāA
 * freeۂɂ͂̒lQƂăt[悤ɂĂ
 *-------------------------------------------------------------------------*/
static void* AllocFunc( DWCAllocType name, u32 size, int align )
{
#pragma unused( name, align )
  void *ptr;
  u32 *base;

  //  OS_TPrintf("org: %5d -> new: ", size);
  // TCY32oCgACgZ
  size = (((size + sizeof(void *)) + 32) & ~31) + 32;
  //  OS_TPrintf("%5d\n", size);
  // m
  ptr = sys_AllocMemory(HEAPID_MYSTERYGIFT, size);
  // ptr32oCgEɕύXbase֒`
  base = (u32 *)(((u32)ptr + 32) & ~31);
  // -4oCgꏊfreeۂ̃AhX
  base--;
  *base = (u32)ptr;
  //  OS_TPrintf("Alloc: %08X [%08X], %d [%2d]\n", ptr, base, size, align);
  // Av֕Ԃl32oCgE
  base++;
  return base;
}


/*-------------------------------------------------------------------------*
 * Name        : FreeFunc
 * Description : J֐
 * Arguments   : name - J郁
 *             : *ptr - 郁̃|C^
 *             : size - TCY
 * Returns     : None.
 *-------------------------------------------------------------------------*/
static void FreeFunc( DWCAllocType name, void* ptr, u32 size  )
{
#pragma unused( name, size )
  u32 *base;

  if(!ptr) return;
  base = (u32 *)((u32)ptr - 4);
  //  OS_Printf("Free: %08X [%08X]\n", ptr, *base);
  sys_FreeMemoryEz((void *)*base);
}


//------------------------------------------------------------------
/**
 * @brief	As\ȃG[oꍇ̏
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static volatile BOOL cleanup_callback_flag;
static void cleanup_callback(void)
{
  cleanup_callback_flag = TRUE;
}
// o^
static int WifiMysteryGift_DispError(MYSTERYGIFT_WORK *wk)
{
  DWCError err;
  DWCErrorType errtype;
  int errcode;

  err = DWC_GetLastErrorEx(&errcode, &errtype);

  OS_TPrintf("code: %d : type: %d\n", errcode, errtype);
  wk->wifi_errmsg = mydwc_errorType(-errcode);
  wk->wifi_errcode = -errcode;
  wk->wifi_errtype = errtype;
  wk->wifi_errflag = TRUE;
  cleanup_callback_flag = FALSE;
  SetTimeWaitIconEx(wk, FALSE);

  return WIFI_MYSTERYGIFT_DOWNLOAD_ERROR_LOOP;
}
// G[̑Ή()
static int WifiMysteryGift_ExecError(MYSTERYGIFT_WORK *wk)
{
  DWCInetResult result;
  
  switch(wk->wifi_errtype){
  case DWC_ETYPE_SHUTDOWN_ND:
  case DWC_ETYPE_DISCONNECT:
    result = DWC_GetInetStatus();
    //    if(result == DWC_CONNECT_STATE_OPERATED ||
    //       result == 
    //    DWC_NdCleanupAsync(cleanup_callback);
    cleanup_callback_flag = TRUE;
    break;
  default:		// #####
    cleanup_callback_flag = TRUE;
    break;
  }
  WirelessIconEasyEnd();	// ʐMACR폜

  wk->wifi_errflag = FALSE;
  return WIFI_MYSTERYGIFT_DOWNLOAD_ERROR_WAIT;
}



//------------------------------------------------------------------
/**
 * @brief	C^[lbgڑ̏Ԃ𒲂ׂ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static BOOL CheckWifiConnect(MYSTERYGIFT_WORK *wk)
{
  DWCApInfo apinfo;
  DWCError err;
  int  errcode, errmsg;
  

  switch(DWC_GetInetStatus()){
  case DWC_CONNECTINET_STATE_ERROR:		// ڑs
#if 0
    // G[\
    err = DWC_GetLastError( &errcode );
    MIT_PRINTF( "   Error occurred %d %d.\n", err, errcode );
    wk->wifi_errmsg = mydwc_errorType(-errcode);
    wk->wifi_errcode = -errcode;
    DWC_ClearError();
    DWC_CleanupInet();
#endif
    break;
  case DWC_CONNECTINET_STATE_FATAL_ERROR:	// ڑs
    // As\ȃG[CommStateWifiFusigiStart(...)ߊl
    break;
  case DWC_CONNECTINET_STATE_CONNECTED:		// ڑ
    MIT_PRINTF( "   CONNECTED!!!.\n" );
    if( DWC_GetApInfo(&apinfo) == TRUE ) {
      MIT_PRINTF( "   DWCApInfo.aptype = %d\n", apinfo.aptype );
      MIT_PRINTF( "   DWCApInfo.area   = %d\n", apinfo.area );
      MIT_PRINTF( "   DWCApInfo.spotinfo = %s\n", apinfo.spotinfo );
      MIT_PRINTF( "   DWCApInfo.essid = %s\n", apinfo.essid );
      MIT_PRINTF( "   DWCApInfo.bssid = %02x:%02x:%02x:%02x:%02x:%02x\n",
		  apinfo.bssid[0], apinfo.bssid[1], apinfo.bssid[2], apinfo.bssid[3], apinfo.bssid[4], apinfo.bssid[5] );
    }
    else {
      MIT_PRINTF( "   Failed to get DWCApInfo\n" );
    }
    return TRUE;
    break;
  }
  return FALSE;
}


//------------------------------------------------------------------
/**
 * @brief	R[obN҂
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void WaitNdCallBack(MYSTERYGIFT_WORK *wk, int *seq, int next_seq)
{
  callbackflag1 = FALSE;
  wk->wifi_next_seq = next_seq;
  *seq = WIFI_MYSTERYGIFT_WAIT_CALLBACK1;
}


//------------------------------------------------------------------
/**
 * @brief	R[obNQ҂
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void WaitNdCallBack2(MYSTERYGIFT_WORK *wk, int result, int *seq, int next_seq)
{
  callbackflag2 = FALSE;
  wifi_result = result;
  wk->wifi_next_seq = next_seq;
  *seq = WIFI_MYSTERYGIFT_WAIT_CALLBACK2;
  DWC_NdCleanupAsync( NdCleanupCallback );
}


/*-------------------------------------------------------------------------*
 * Name        : NdCallback
 * Description : NDpR[obN
 * Arguments   : None.
 * Returns     : None.
 *-------------------------------------------------------------------------*/
static void NdCallback(DWCNdCallbackReason reason, DWCNdError errpr, int servererror)
{
#pragma unused(reason)
#pragma unused(errpr)
#pragma unused(servererror)
  MIT_PRINTF("NdCallback: Called\n");
  switch(reason) {
  case DWC_ND_CBREASON_GETFILELISTNUM:
    MIT_PRINTF("DWC_ND_CBREASON_GETFILELISTNUM\n");
    break;
  case DWC_ND_CBREASON_GETFILELIST:
    MIT_PRINTF("DWC_ND_CBREASON_GETFILELIST\n");
    break;
  case DWC_ND_CBREASON_GETFILE:
    MIT_PRINTF("DWC_ND_CBREASON_GETFILE\n");
    break;
  case DWC_ND_CBREASON_INITIALIZE:
    MIT_PRINTF("DWC_ND_CBREASON_INITIALIZE\n");
    break;
  }
	
  switch(errpr) {
  case DWC_ND_ERROR_NONE:
    MIT_PRINTF("DWC_ND_NOERR\n");
    break;
  case DWC_ND_ERROR_ALLOC:
    MIT_PRINTF("DWC_ND_MEMERR\n");
    break;
  case DWC_ND_ERROR_BUSY:
    MIT_PRINTF("DWC_ND_BUSYERR\n");
    break;
  case DWC_ND_ERROR_HTTP:
    MIT_PRINTF("DWC_ND_HTTPERR\n");
    // t@C̎擾łgssoG[ꍇ̓_E[hT[oɌqĂȂ\
    if( reason == DWC_ND_CBREASON_GETFILELISTNUM )
      {
	MIT_PRINTF( "It is not possible to connect download server.\n." );
	OS_Terminate();
      }
    break;
  case DWC_ND_ERROR_BUFFULL:
    MIT_PRINTF("DWC_ND_BUFFULLERR\n");
    break;
  case DWC_ND_ERROR_DLSERVER:
    MIT_PRINTF("DWC_ND_SERVERERR\n");
    break;
  case DWC_ND_ERROR_CANCELED:
    MIT_PRINTF("DWC_ND_CANCELERR\n");
    break;
  }
  MIT_PRINTF("errorcode = %d\n", servererror);
  callbackflag1 = TRUE;
}


/*-------------------------------------------------------------------------*
 * Name        : NdCleanupCallback
 * Description : DWC_NdCleanupAsyncpR[obN
 * Arguments   : None.
 * Returns     : None.
 *-------------------------------------------------------------------------*/
static void NdCleanupCallback( void )
{
  MIT_PRINTF("--------------------------------\n");
  switch( wifi_result )
    {
    case ND_RESULT_COMPLETE:
      MIT_PRINTF("DWC_ND: finished - complete -\n");
      break;
    case ND_RESULT_NOT_FOUND_FILES:
      MIT_PRINTF("DWC_ND: finished - no files -\n");
      break;
    case ND_RESULT_DOWNLOAD_CANCEL:
      MIT_PRINTF("DWC_ND: finished - cancel -\n");
      break;
    }
  MIT_PRINTF("--------------------------------\n");
  callbackflag2 = TRUE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXFC
 * @param	proc				vZXւ̃|C^
 * @param	seq				V[PXp[Nւ̃|C^
 * @return	ND_RESULT_EXECUTE		s
 * @return	ND_RESULT_COMPLETE		_E[hI
 * @return	ND_RESULT_NOT_FOUND_FILES	t@CȂ
 * @return	ND_RESULT_DOWNLOAD_CANCEL	[U[LZꂽ
 * @return	ND_RESULT_DOWNLOAD_ERROR	Ȃ炩̃G[N
 */
//--------------------------------------------------------------------------------------------
int WifiMysteryGift_Main(PROC *proc, int *seq)
{
  int ret;
  DWCNasLoginState nasloginstate;
  MYSTERYGIFT_WORK *wk = PROC_GetWork(proc);

  // G[oĂ珈
  if(wk->wifi_errflag == TRUE)
    *seq = WifiMysteryGift_ExecError(wk);
  // Inetڑ͖t[sڑێĂ邩`FbN
  if(wk->wifi_check_func){
    if(wk->wifi_check_func() == TRUE)
      *seq = WifiMysteryGift_DispError(wk);
  }
  
  //  MIT_PRINTF("WIFI: %s\n", debugseqtbl[*seq - WIFI_MYSTERYGIFT_BASE]);
  
  switch(*seq){
  case WIFI_MYSTERYGIFT_COMM_INIT:
    // Cu
    CommVRAMDInitialize();
    DwcOverlayStart();
    *seq = WIFI_MYSTERYGIFT_COMM_INIT_WAIT;
    break;

  case WIFI_MYSTERYGIFT_COMM_INIT_WAIT:
    /// VRAMDփCNj[̂҂
    if(CommIsVRAMDInitialize()){
      // fobO\xw
      DWC_SetReportLevel((unsigned long)(DWC_REPORTFLAG_ALL & ~DWC_REPORTFLAG_QR2_REQ));
      // mۊ֐ݒ
      DWC_SetMemFunc( AllocFunc, FreeFunc );
      // G[Ǘp̊Jn
      CommStateWifiFusigiStart(wk->sv);
      *seq = WIFI_MYSTERYGIFT_CONNECT_INET;
    }
    break;

    
  case WIFI_MYSTERYGIFT_CONNECT_INET:
    // C^[lbgւ̐ڑ
    DWC_InitInetEx(&wk->stConnCtrl,COMM_DMA_NO,COMM_POWERMODE,COMM_SSL_PRIORITY);

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/09/07
// version t@C PG5_WIFIRELEASE = yes 錾ĂA
// Wi-Fi̐ڑeXgT[opubNT[oɐ؂ւ

#ifdef PG5_WIFIRELEASE
	OS_TPrintf("Connecting to Release Server...\n");
    DWC_SetAuthServer(DWC_CONNECTINET_AUTH_RELEASE);
#else
	OS_TPrintf("Connecting to Test Server...\n");
    DWC_SetAuthServer(DWC_CONNECTINET_AUTH_TEST);
#endif

// ----------------------------------------------------------------------------

    // ڑJn
    DWC_ConnectInetAsync();
    // ʐMACR\
    WirelessIconEasy();
    *seq =  WIFI_MYSTERYGIFT_CONNECT_WAIT_INET;
    wk->wifi_cancel = FALSE;
    break;

  case WIFI_MYSTERYGIFT_CONNECT_WAIT_INET:		// #####
    // C^[lbgڑI܂ő҂
    if(DWC_CheckInet() == FALSE){
      // ܂ڑIĂȂ
      DWC_ProcessInet();
    } else {
      // ڑI
      if(CheckWifiConnect(wk) == TRUE){
	MIT_PRINTF("Success.\n");
	if(wk->wifi_cancel == TRUE){
	  // [U[ɂLZĂ
	  wifi_result = ND_RESULT_DOWNLOAD_CANCEL;
	  *seq = WIFI_MYSTERYGIFT_DOWNLOAD_COMPLETE;
	} else {
	  wk->wifi_check_func = DWC_UpdateConnection;
	  *seq = WIFI_MYSTERYGIFT_NASLOGIN_START;
	}
      } else {
	*seq = WifiMysteryGift_DispError(wk);
      }
    }
    // [U[ɂLZ
    if(sys.trg & PAD_BUTTON_CANCEL)
      wk->wifi_cancel = TRUE;
    break;

  case WIFI_MYSTERYGIFT_NASLOGIN_START:
    // NASLogin
    if(DWC_NASLoginAsync() == FALSE)
      *seq = WifiMysteryGift_DispError(wk);
    else
      *seq = WIFI_MYSTERYGIFT_NASLOGIN_WAIT;
    break;

  case WIFI_MYSTERYGIFT_NASLOGIN_WAIT:
    // OCI܂ő҂
    nasloginstate = DWC_NASLoginProcess();

    if(nasloginstate == DWC_NASLOGIN_STATE_SUCCESS){
      *seq = WIFI_MYSTERYGIFT_NDLIB_INIT;			// OC
    } else if(nasloginstate == DWC_NASLOGIN_STATE_ERROR){
      *seq = WifiMysteryGift_DispError(wk);			// OCs
    } else if(nasloginstate == DWC_NASLOGIN_STATE_CANCELED){
      wifi_result = ND_RESULT_DOWNLOAD_CANCEL;
      *seq = WIFI_MYSTERYGIFT_DOWNLOAD_COMPLETE;		// LZ
    }
    // [U[ɂLZ
    if(sys.trg & PAD_BUTTON_CANCEL)
      DWC_NASLoginAbort();
    break;
    
  case WIFI_MYSTERYGIFT_NDLIB_INIT:
    // NdCu
    if(DWC_NdInitAsync( NdCallback, WIFI_ND_LOGIN_NAME, WIFI_ND_LOGIN_PASSWD ) == FALSE){
      OS_TPrintf( "DWC_NdInitAsync: Failed\n" );
      *seq = WifiMysteryGift_DispError(wk);
      break;
    }
    WaitNdCallBack(wk, seq, WIFI_MYSTERYGIFT_SET_ATTR);
    break;

  case WIFI_MYSTERYGIFT_SET_ATTR:
    // LZĂΔ
    if(wk->wifi_cancel == TRUE){
      WaitNdCallBack2(wk, ND_RESULT_DOWNLOAD_CANCEL, seq, WIFI_MYSTERYGIFT_DOWNLOAD_CANCEL);
      break;
    }
    // t@C̐ݒ
    if(DWC_NdSetAttr(WIFI_FILE_ATTR1, WIFI_FILE_ATTR2, WIFI_FILE_ATTR3) == FALSE){
      OS_TPrintf( "DWC_NdSetAttr: Failed\n." );
      *seq = WifiMysteryGift_DispError(wk);
      break;
    }
    *seq = WIFI_MYSTERYGIFT_GET_FILENUM;
    break;
    
  case WIFI_MYSTERYGIFT_GET_FILENUM:
    // T[o[ɂĂt@C̐𓾂
    if(DWC_NdGetFileListNumAsync(&wk->server_filenum) == FALSE){
      OS_TPrintf( "DWC_NdGetFileListNumAsync: Failed.\n" );
      *seq = WifiMysteryGift_DispError(wk);
      break;
    }
    WaitNdCallBack(wk, seq, WIFI_MYSTERYGIFT_GET_FILELIST);
    break;
    
  case WIFI_MYSTERYGIFT_GET_FILELIST:
    if(wk->server_filenum != 1){
      // t@C݂ȂA܂͑ꍇ
      WaitNdCallBack2(wk, ND_RESULT_NOT_FOUND_FILES, seq, WIFI_MYSTERYGIFT_DOWNLOAD_COMPLETE);
    } else {
      // t@CP
      if(DWC_NdGetFileListAsync(fileInfo, 0, FILE_NUM) == FALSE){
	OS_TPrintf( "DWC_NdGetFileListNumAsync: Failed.\n" );
	*seq = WifiMysteryGift_DispError(wk);
	break;
      }
      WaitNdCallBack(wk, seq, WIFI_MYSTERYGIFT_GET_FILE);
    }
    break;

  case WIFI_MYSTERYGIFT_GET_FILE:
    // t@Cǂݍ݊Jn
    if(DWC_NdGetFileAsync( &fileInfo[ 0 ], wk->filebuffer, WIFI_MYSTERYFILE_SIZE) == FALSE){
      OS_TPrintf( "DWC_NdGetFileAsync: Failed.\n" );
      *seq = WifiMysteryGift_DispError(wk);
      break;
    }
    *seq = WIFI_MYSTERYGIFT_GETTING_FILE;
    wk->percent = 0;
    break;

  case WIFI_MYSTERYGIFT_GETTING_FILE:		// #####
    // t@Cǂݍݒ
    if(callbackflag1 == FALSE){
      // t@Cǂݍݒ

      if(sys.trg & PAD_BUTTON_CANCEL){
	// _E[hLZ
	WaitNdCallBack2(wk, ND_RESULT_DOWNLOAD_CANCEL, seq, WIFI_MYSTERYGIFT_DOWNLOAD_CANCEL);
      } else {
	// isx\
	if(DWC_NdGetProgress( &wk->recived, &wk->contentlen ) == TRUE){
	  if(wk->percent != (wk->recived*100)/wk->contentlen){
	    wk->percent = (wk->recived*100)/wk->contentlen;
	    MIT_PRINTF( "Download %d/100\n", wk->percent );
	  }
	}
      }

    } else {
      if(wk->wifi_cancel == FALSE){
	// t@CǂݍݏI
	WaitNdCallBack2(wk, ND_RESULT_COMPLETE, seq, WIFI_MYSTERYGIFT_DOWNLOAD_COMPLETE);
      } else {
	// _E[hLZ
	WaitNdCallBack2(wk, ND_RESULT_DOWNLOAD_CANCEL, seq, WIFI_MYSTERYGIFT_DOWNLOAD_COMPLETE);
      }
    }
    break;

  case WIFI_MYSTERYGIFT_DOWNLOAD_CANCEL:
    if(DWC_NdCancelAsync() == FALSE){
      *seq = WIFI_MYSTERYGIFT_DOWNLOAD_COMPLETE;
    } else {
      wk->wifi_check_func = NULL;
      // ʐMACR폜
      WirelessIconEasyEnd();
      // G[Ǘp̏I
      CommStateWifiFusigiEnd();
      DwcOverlayEnd();
      CommVRAMDFinalize();

      MIT_PRINTF("download cancel\n");
      return wifi_result;
    }
    break;
    
  case WIFI_MYSTERYGIFT_DOWNLOAD_COMPLETE:
    MIT_PRINTF("inet disabling...\n");
    if(DWC_CleanupInetAsync() == TRUE){
      wk->wifi_check_func = NULL;
      // ʐMACR폜
      WirelessIconEasyEnd();
      // G[Ǘp̏I
      CommStateWifiDPWEnd();
      DwcOverlayEnd();
      CommVRAMDFinalize();

      MIT_PRINTF("Internet close complete\n");
      return wifi_result;
    }
    break;

  case WIFI_MYSTERYGIFT_DOWNLOAD_ERROR_LOOP:
    break;
  case WIFI_MYSTERYGIFT_DOWNLOAD_ERROR_WAIT:
    if(cleanup_callback_flag == TRUE){
      WifiMysteryGift_ErrorDisp(wk);
      if(wk->wifi_errtype == DWC_ETYPE_DISCONNECT)
	DWC_CleanupInet();
      *seq = WIFI_MYSTERYGIFT_DOWNLOAD_ERROR;
    }
    break;

  case WIFI_MYSTERYGIFT_DOWNLOAD_ERROR:
    if(sys.trg & PAD_BUTTON_DECIDE){

      wk->wifi_check_func = NULL;
      DWC_ClearError();
      // G[Ǘp̏I
      CommStateWifiDPWEnd();
      DwcOverlayEnd();
      CommVRAMDFinalize();

      return ND_RESULT_DOWNLOAD_ERROR;
    }
    break;
    

  case WIFI_MYSTERYGIFT_WAIT_CALLBACK1:		// #####
    // R[obN҂
    if(callbackflag1 == TRUE){
      callbackflag1 = FALSE;
      *seq = wk->wifi_next_seq;
    } else if(sys.trg & PAD_BUTTON_CANCEL){
      OS_TPrintf("LZ܂ 3 \n");
      wk->wifi_cancel = TRUE;
    }
    break;

  case WIFI_MYSTERYGIFT_WAIT_CALLBACK2:
    // R[obN҂
    if(callbackflag2 == TRUE){
      callbackflag2 = FALSE;
      *seq = wk->wifi_next_seq;
    } else if(sys.trg & PAD_BUTTON_CANCEL){
      OS_TPrintf("LZ܂ 3 \n");
      wk->wifi_cancel = TRUE;
    }
    break;
  }
  return ND_RESULT_EXECUTE;
}


/*  */
