//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		blact.c
 *	@brief		VKr{[hAN^[
 *	@author		tomoya takahashi
 *	@data		2005.10.05
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#define __BLACT_H_GLOBAL
#include "string.h"
#include "blact.h"
#include "vram_transfer_anm.h"
#include "vram_transfer_manager.h"
#include "simple_3dgraphics.h"
#include "system.h"
#include "str_tool.h"
#include "gflib_os_print.h"
#include "assert.h"

#include "bounding_box.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
// Aj[V`FW̎
//
// Aj[VZbgύX̏
//=====================================
enum
{
	BLACT_CHG_NONE,		// Ȃ
	BLACT_CHG_VRAM,		// Vram]o^ς
};

enum{
	BLACT_RES_MAN_MDL,
	BLACT_RES_MAN_TEX,
	BLACT_RES_MAN_ANM
};

enum{
	BLACT_DRAW_REF_NONE,
	BLACT_DRAW_REF_DRAW_BEFORE,
	BLACT_DRAW_REF_DRAW_AFTER,
};

// 풓Aj
// pbgx[XAhX}XN
#define BLACT_PLTT_BASE_MASK	(0x000001fff)

//-----------------------------------------------------------------------------
/**
 *					\̐錾
 */
//-----------------------------------------------------------------------------


//-------------------------------------
//	r{[hAN^[\
//
//	r{[hP̂̃f[^
//=====================================
typedef struct BLACT_WORK_tag{
	//------------------------------------
	//	vO}[삷郁oS
	//====================================
	VecFx32		Matrix;						// ΍W
	VecFx32		Scale;						// XP[
	
	u8			draw;						// `s(0:ȂȂ 1:s)

	//------------------------------------
	//	ڑ֎~郁oS
	//===================================
	void*	pBlActSet;		// ̑ĂAj[VZbg̃|C^(LXgĎgp)

	const BLACT_ANIME_TBL*	pAnmTbl;		// Aj[Ve[u
	
	NNSG3dRenderObj			RenderObj;		// _[IuWFNg

	NNSG3dResMdlSet*		pModelSet;		// fZbg
	NNSG3dResMdl*			pModel;			// f\[X
	NNSG3dResTex*			pMdlTex;		// fɓ\teNX`
	const NNSG3dResTex*		pAnmTex;		// Aj[VpeNX`
	NNSGfdTexKey			texKey;			// eNX`VramKey
	NNSGfdTexKey			tex4x4Key;		// 4xpeNX`VramKey
	NNSGfdPlttKey			plttKey;		// pbgVramKey
	
	TEXANM_DATATBL				texAnm;		// eNX`Aj[Vf[^
	ITP_VRAM_ANM_PTR		ItpVramObj;		// Vram]pIuWF	(Vram]̂)
	
	u8			flag;						// On/OfftO
	u16			AnmOffs;					// ̃Aj[VItZbg
	fx32		frame;						// ݃t[
	
	// o^Xg
	struct BLACT_WORK_tag*	next;	// ̃AN^[
	struct BLACT_WORK_tag*	prev;	// ÕAN^[
	
} BLACT_WORK;


//===================================================================
//
//	r{[hAN^[Zbg\
//
//	r{[hAN^[̎
//
//===================================================================
typedef struct _BLACT_SET{
	/* Rg[tO */
	u8				SysFlag;	// o^Ă邩	0:o^ 1:o^
	u8				DrawFlag;	// `tO 0:` 1:`(ftHg)
	u8				MoveFlag;	// TCB^XNtO 0:񓮍 1:(ftHg)

	/* jIuWFNg܂ʂɔfĂ */
	u8				DelObjDrawRef;
	
	/* r{[hAN^[\ */
	BLACT_WORK*		pWork;		// 
	int				WorkNum;	// 
	
	/* Xggbvf[^ */
	BLACT_WORK		Dummy;	
	
	/* X^bN */
	BLACT_WORK**	ppWorkStack;	// (==WorkNum)
	int				WorkStackNow;	// ̃gbv̈ʒu
	
	/* AP[^[ */
	NNSFndAllocator* pAlloc;		// gpAP[^
	
	/* Vram]Aj[ṼIuWFNg */
	ITP_VRAM_SYS_PTR pItpTop;


}BLACT_SET;



//----------------------------------------------------------------------------
/**
 *					vg^Cv錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	r{[hAN^[VXe֐
//=====================================
static BLACT_SET_PTR getCleanBlActSet(void);
static void cleanBlActSet(BLACT_SET* work);

//-------------------------------------
//	BLACT_SET֐
//=====================================
static void drawBlActSet(BLACT_SET* pBlActSet);
static void drawBlAct( BLACT_WORK *act );

//-------------------------------------
//	풓AjpVXe
//=====================================
static void normAnmTexDataSet( BLACT_WORK* act );
static void normAnmTexParamSet( NNSG3dResMdl* p_mdl, const NNSG3dResTex* p_tex, u8 tex_idx );
static void normAnmTexParamSetOneMatData( NNSG3dResMat* pMat, const	NNSG3dResDictTexToMatIdxData* pBindData, u32 tex_offs );
static void normAnmPlttParamSet( NNSG3dResMdl* p_mdl, const NNSG3dResTex* p_tex, u8 pltt_idx );
static void normAnmPlttParamSetOneMatData( NNSG3dResMat* pMat, const NNSG3dResDictPlttToMatIdxData* pBindData, u32 pltt_offs );


//-------------------------------------
//	stack̏
//=====================================
static void initStack(BLACT_SET* pSet);			// 
static BLACT_WORK* popStack(BLACT_SET* pSet);	// o
static BOOL pushStack(BLACT_SET* pSet, BLACT_WORK* pDat);	// i[

//-------------------------------------
//	XgǗ
//=====================================
static void setList(BLACT_WORK* Dummy, BLACT_WORK* pDat);
static void remList(BLACT_WORK* pDat);

//-------------------------------------
//	eNX`̕`O
//	eNX`̕`㏈
//=====================================
static void DrawTexBind(BLACT_WORK* bl_w);
static void DrawTexreBind(BLACT_WORK* bl_w);

//-------------------------------------
//	ւ[烊\[X擾
//=====================================
static void* getRes(const BLACT_HEADER* p_head, int flag);
static const BLACT_ANIME_TBL* getAnmTbl(const BLACT_ANIME_TBL* p_anm, int ofs);

//-------------------------------------
//	f[^[hn֐S
//=====================================
static NNSG3dResMdlSet* blact_getMdl(const BLACT_HEADER* p_head,NNSG3dResMdl** ppMdl, NNSG3dResTex** ppTex);
static NNSG3dAnmObj* blact_getItp(const BLACT_HEADER* p_head, const NNSG3dResMdl* p_mdl, const NNSG3dResTex* p_tex, NNSFndAllocator* pAlloc);
static NNSG3dResTex* blact_getTex(const BLACT_HEADER* p_head);

//-------------------------------------
//	Aj[VZbgύXf[^
//=====================================
static void chgBillboadAnmSet_Core( BLACT_WORK* act, const BLACT_HEADER* header );
// Vram]pe[uf[^ݒ֐
static void chgBillboadAnmSet_Core_VRAM( BLACT_WORK* act, const BLACT_HEADER* header );
// 풓pAj[VZbgύX֐
static void core_anmset_chg_norm( BLACT_WORK* blact_w, const BLACT_HEADER* header);

static fx32	nowOffsAnmStartFrame( const BLACT_WORK* act, int offs );
static int anmFrameChg_Core( BLACT_WORK* act, fx32 num );

static int anmFrameChgSys( const BLACT_ANIME_TBL* anm, fx32* frame, fx32 num );

//-------------------------------------
//
//@eNX`\tAj
//				֐S
//	
//=====================================
static void allocTexKey(const NNSG3dResTex* tex, NNSG3dTexKey* texkey, NNSG3dTexKey* tex4x4key, NNSG3dPlttKey* plttkey);
static void releaseTexture(NNSG3dResTex* tex, NNSG3dTexKey* texkey, NNSG3dTexKey* tex4x4key, NNSG3dPlttKey* plttkey);
static void reBindTexture(NNSG3dResTex* tex, NNSG3dResMdlSet* mdl, NNSG3dTexKey* texkey, NNSG3dTexKey* tex4x4key, NNSG3dPlttKey* plttkey);
static void delBindTexture(NNSG3dTexKey* texkey, NNSG3dTexKey* tex4x4key, NNSG3dPlttKey* plttkey);
static BOOL check_texsize_equal(const NNSG3dResTex* tex1, const NNSG3dResTex* tex2);

//-------------------------------------
//
//	r{[hAN^[j
//	֐S
//	
//=====================================
static void del_blact(BLACT_SET* pBlActSet, BLACT_WORK* delWork);// j

//-------------------------------------
//
//	r{[hAN^[o^
//	֐S
//	
//=====================================
static void data_chg_vram_mdl_core(BLACT_WORK* blact_w, const BLACT_HEADER* header);
static void data_chg_vram_anm_core(const BLACT_SET* pBlActSet, BLACT_WORK* blact_w, const BLACT_HEADER* header);

static void data_chg_norm_mdl_core(BLACT_WORK* blact_w, const BLACT_HEADER* header);
static void data_chg_norm_anm_core(BLACT_WORK* blact_w, const BLACT_HEADER* header);

//----------------------------------------------------------------------------
/**
 *					O[oϐ錾
 */
//-----------------------------------------------------------------------------
static BLACT_SET*	pBlActSetTbl=NULL;	// r{[hAN^[Ǘe[u
static int			BlActSetNum=0;		// o^\


//-----------------------------------------------------------------------------
/**
 * 
 *	@brief	BLACT_SET\̌^f[^@NA
 *
 *	@param	work	BLACT_SET\̌^f[^ւ̃|C^
 *	@return none
 *	
 */
//-----------------------------------------------------------------------------
static void cleanBlActSet(BLACT_SET* work)
{
	work->SysFlag		= 0;
	work->DrawFlag		= 0;
	work->pWork			= NULL;
	work->WorkNum		= 0;
	work->ppWorkStack	= NULL;
	work->WorkStackNow	= 0;
	work->pAlloc		= NULL;
	work->pItpTop		= NULL;
	work->DelObjDrawRef = BLACT_DRAW_REF_NONE;
}

//-----------------------------------------------------------------------------
/**
 * 
 *	@brief	BLACT_WORK\̌^f[^@NA
 *
 *	@param	pDat	BLACT_WORK\̌^f[^ւ̃|C^
 *	@return none
 *	
 */
//-----------------------------------------------------------------------------
void BLACT_WorkClear( BLACT_WORK *pDat )
{
	u8 i = 0;

	pDat->pBlActSet = NULL;
	pDat->pAnmTbl	= NULL;
	
	pDat->pModelSet	= NULL;			// fZbg
	pDat->pModel	= NULL;			// f
	pDat->pMdlTex	= NULL;			// fɓ\teNX`
	pDat->pAnmTex	= NULL;			// Aj[VpeNX`
	// Aj[Vf[^
	memset( &pDat->texAnm, 0, sizeof(TEXANM_DATATBL) );
	pDat->texKey	= BLACT_TEXKEY_VRAMANM;
	pDat->tex4x4Key	= BLACT_TEXKEY_VRAMANM;
	pDat->plttKey	= BLACT_PLTTKEY_VRAMANM;
	pDat->ItpVramObj = NULL;

	VEC_Set(&(pDat->Matrix),0,0,0);
	VEC_Set(&(pDat->Scale),FX32_ONE,FX32_ONE,FX32_ONE);

	pDat->AnmOffs = 0;

	pDat->flag = 0;

	pDat->next = NULL;
	pDat->prev = NULL;
	pDat->draw = 0;
}

//=============================================================================
//
//		r{[hAN^[VXe֐S
//		
//		r{[hAN^[̃VXe𑀍삷֐
//=============================================================================
//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[VXȅ
 *
 *	@param	ContNum			Ǘr{[hAN^[Zbg
 *	@param	heap			gpq[v
 *
 *	@return none
 *
 * r{[hAN^[gpOɂPxs
 * 
 */
//-----------------------------------------------------------------------------
void BLACT_InitSys(int ContNum, int heap)
{
	int i;		// [vp

	
	GF_ASSERT((pBlActSetTbl==NULL) && "ς݂ł\n");
	
	// Ǘe[u쐬
	pBlActSetTbl = sys_AllocMemory(heap, sizeof(BLACT_SET) * ContNum);
	BlActSetNum = ContNum;

	// 
	for(i=0;i<ContNum;i++){
		cleanBlActSet(&pBlActSetTbl[i]);
	}
}

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[VXe̔j
 *
 *	@param	none
 *
 *	@return none
 *
 * r{[hAN^[gpɂPxKv
 * 
 */
//-----------------------------------------------------------------------------
void BLACT_DestSys(void)
{
	int i;		// [vp
	
	// r{[hAN^[ZbgSĂ͂
	for(i=0;i<BlActSetNum;i++){
		BLACT_DestSet(pBlActSetTbl + i);
	}

	sys_FreeMemoryEz(pBlActSetTbl);
	pBlActSetTbl = NULL;
	BlActSetNum = 0;
}

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[VXe̕`
 *
 *	@param	none
 *
 *	@return none
 *
 * o^Ăr{[hAN^[Zbg`悵܂B
 *
 * `悵ȂƂ
 *		BLACT_SET\̂DrawFlag 0ɂ
 * 
 */
//-----------------------------------------------------------------------------
void BLACT_DrawSys(void)
{
	int i;		// [vp
	
	// r{[hAN^[ZbgSĂ`
	for(i=0;i<BlActSetNum;i++){
		if(pBlActSetTbl[i].DrawFlag == 1){	
			drawBlActSet(&pBlActSetTbl[i]);
		}
		if( pBlActSetTbl[i].DelObjDrawRef == BLACT_DRAW_REF_DRAW_BEFORE ){
			pBlActSetTbl[i].DelObjDrawRef = BLACT_DRAW_REF_DRAW_AFTER;
		}
	}
}

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[P̂̕`
 *
 *	@param	act	BLACT_WORK_PTR
 *
 *	@return none
 *
 * w肵r{[hAN^[Zbg`悵܂B
 *
 * `悵ȂƂ
 *		BLACT_SET\̂DrawFlag 0ɂ
 * 
 */
//-----------------------------------------------------------------------------
void BLACT_Draw(BLACT_WORK_PTR act)
{
	drawBlAct(act);
}

//=============================================================================
//
//		r{[hAN^[Zbg֐S
//		
//=============================================================================
//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[Zbgݒ
 *
 *	@param	pSetData		AN^[Zbg	
 *
 *	@retval	BLACT_SET_PTR	AN^[Zbg|C^
 *	@retval	NULL			o^s
 *
 * 
 */
//-----------------------------------------------------------------------------
BLACT_SET_PTR BLACT_InitSet(const BLACT_SETDATA* pSetData)
{
	BLACT_SET* set;
	
	// e[u󂢂ĂAN^[Zbg擾
	set = getCleanBlActSet();

	if(set == NULL){
		GF_ASSERT_MSG( 0, "o^łAN^[Zbg܂B\n BLACT_InitSys̑P̐𑝂₵Ă\n" );
		return NULL;
	}

	// ef[^̈쐬
	set->SysFlag = 1;		// o^
	set->DrawFlag = 1;		// `
	
	// AN^[[N
	set->pWork = sys_AllocMemory(pSetData->heap, sizeof(BLACT_WORK)*pSetData->WorkNum);
	set->WorkNum = pSetData->WorkNum;
	
	// Xg_~[f[^
	BLACT_WorkClear(&set->Dummy);
	set->Dummy.next = &set->Dummy;
	set->Dummy.prev = &set->Dummy;
	
	// X^bN
	set->ppWorkStack = sys_AllocMemory(pSetData->heap, sizeof(BLACT_WORK*)*pSetData->WorkNum);
	initStack(set);
	
	// AP[^쐬
	set->pAlloc = sys_AllocMemory(pSetData->heap, sizeof(NNSFndAllocator));
	sys_InitAllocator(set->pAlloc, pSetData->heap,4);
	// ITPVram]Aj쐬
	set->pItpTop = initItpVramAnm(pSetData->WorkNum, pSetData->heap);

	return set;
}

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[Zbgj
 *
 *	@param	bl_set			AN^[Zbg|C^
 *
 *	@retval	TRUE			
 *	@retval	FALSE			s
 *
 * 
 */
//-----------------------------------------------------------------------------
BOOL BLACT_DestSet(BLACT_SET_PTR bl_set)
{
	// r{[hAN^[Zbg擾
	if(bl_set == NULL){
		GF_ASSERT_MSG( 0, "NULLł\n" );
		return FALSE;
	}

	if(bl_set->SysFlag != 0){
		// r{[hSj
		BLACT_DeleteWorkAllSet(bl_set);

		// Ǘf[^j
		sys_FreeMemoryEz(bl_set->pWork);
		sys_FreeMemoryEz(bl_set->ppWorkStack);
		sys_FreeMemoryEz(bl_set->pAlloc);
		destItpVramAnm(bl_set->pItpTop);

		cleanBlActSet(bl_set);
	}

	return TRUE;
}

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[Zbg`tOݒ
 *
 *	@param	bl_set			AN^[Zbg|C^	
 *	@param	flag			ݒ肷tOl	0:` 1:`
 *
 *	@retval	TRUE			
 *	@retval	FALSE			s
 *
 * 
 */
//-----------------------------------------------------------------------------
BOOL BLACT_DrawFlagSet(BLACT_SET_PTR bl_set, u8 flag)
{
	// r{[hAN^[Zbg擾
	if(bl_set == NULL){
		GF_ASSERT_MSG( 0, "NULLł\n" );
		return FALSE;
	}

	if(bl_set->SysFlag != 0){
		bl_set->DrawFlag = flag;
	}

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	r{[hAN^[Zbg̕`tO擾
 *
 *@param	bl_set		AN^[Zbg|C^	
 *
 *@return	u8			1:`		0:`
 *
 *
 */
//-----------------------------------------------------------------------------
u8 BLACT_DrawFlagGet(CONST_BLACT_SET_PTR bl_set)
{
	if(bl_set == NULL){
		GF_ASSERT_MSG( 0, "NULLł\n" );
		return 0;
	}

	if(bl_set->SysFlag != 0){
		return bl_set->DrawFlag;
	}

	return 0;
}

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[Zbg̑Sr{[hj
 *	
 *	@param	bl_set			AN^[Zbg|C^
 *
 *	@retval	TRUE			
 *	@retval	FALSE			s
 *
 */
//-----------------------------------------------------------------------------
BOOL BLACT_DeleteWorkAllSet(BLACT_SET_PTR bl_set)
{
	BLACT_WORK*	roop;
	BLACT_WORK*	next;
	
	// r{[hAN^[Zbg擾
	if(bl_set == NULL){
		GF_ASSERT_MSG(bl_set, "NULLł\n");
		return FALSE;
	}

	if(bl_set->SysFlag != 0){
			
		// Xg̃f[^Sj
		roop = bl_set->Dummy.next;
		while(roop != &bl_set->Dummy){
			next = roop->next;
			// j
			BLACT_Delete(roop);
			roop = next;
		}
		
	}

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	jIuWFNg܂ʂɔfĂ邩`FbN
 *	
 *	@param	bl_set	AN^[Zbg
 *
 *	@retval	TRUE	fĂ
 *	@retval	FALSE	fĂȂ
 */
//-----------------------------------------------------------------------------
BOOL BLACT_DelObjRefCheck( BLACT_SET_PTR bl_set )
{
	GF_ASSERT( bl_set );
	if( bl_set->DelObjDrawRef == BLACT_DRAW_REF_NONE ){
		return FALSE;
	}
	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	r{[hAN^[VuN
 *
 *	@param	act		[N
 */
//-----------------------------------------------------------------------------
void BLACT_VBlankFunc( BLACT_SET_PTR bl_set )
{
	// VBlankɂ̂ŁAXbvobt@s
	// ܂Ŕĵɕ`悳Ă|S
	if( bl_set->DelObjDrawRef == BLACT_DRAW_REF_DRAW_AFTER ){
		bl_set->DelObjDrawRef = BLACT_DRAW_REF_NONE;
	}
}


//=============================================================================
//
//		r{[hAN^[ZbgvCx[g֐S
//
//=============================================================================
//-----------------------------------------------------------------------------
/**
 *
 *	@brief	󂢂Ăr{[hAN^[Zbg擾
 *
 *	@param	none
 *
 *	@retval	BLACT_SET_PTR	AN^[Zbg|C^
 *	@retval	NULL			s
 *
 * 
 */
//-----------------------------------------------------------------------------
static BLACT_SET_PTR getCleanBlActSet(void)
{
	int i;		// [vp

	for(i=0;i<BlActSetNum;i++){
		if(pBlActSetTbl[i].SysFlag == 0){
			return &pBlActSetTbl[i];
		}
	}

	return NULL;
}

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[Zbg̕`
 *
 *	@param	pBlActSet	`悷r{[hAN^[Zbg
 *	@return	none
 *
 * r{[hAN^[Zbgɓo^ꂽAN^[`悵܂
 *
 */
//-----------------------------------------------------------------------------
static void drawBlActSet( BLACT_SET* pBlActSet )
{
	BLACT_WORK* roop;		// [vp
	MtxFx33 rot;				// ]s
	VecFx32	matrix;				// ΍W{΍W

	GF_ASSERT( pBlActSet );
	
	// ]sPʍsɂ
	MTX_Identity33( &rot );
	
	roop = pBlActSet->Dummy.next;
	while(roop != &pBlActSet->Dummy){
		
		if(roop->draw == 1){		// \邩`FbN
			
			// eNX`oCh
			DrawTexBind(roop);
	
			// eAj[V̍XV
			// `֐Ȃ̂ɕ`ȊÔƂŝ͗ǂȂłA
			// oChf[^ɍsKv邽
			// ōs܂
			if(roop->flag == BLACT_MOVE_NORM){
				//풓AjeNX`EpbgQƐݒ
				normAnmTexDataSet( roop );
			}else{
				if(roop->flag == BLACT_MOVE_VRAM){
					BLACT_VramAnmTransUserReq( roop );
				}
			}
			
			// `
			simple_3DModelDraw(
					&roop->RenderObj,		// _[IuWF
					&roop->Matrix,			// W
					&rot,					// ]s
					&roop->Scale);			// gk
			
			// eNX`oCh
			DrawTexreBind(roop);
			
		}
		roop = roop->next;
	}
}

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[`
 *
 *	@param	act		`悷r{[hAN^[
 *	@return	none
 *
 * AN^[`悵܂
 *
 */
//-----------------------------------------------------------------------------
static void drawBlAct( BLACT_WORK *act )
{
	MtxFx33 rot;				// ]s
	VecFx32	matrix;				// ΍W{΍W

	GF_ASSERT( act );
	MTX_Identity33( &rot );
	
	if( act->draw == FALSE ){
		return;
	}
	
	DrawTexBind( act );
	
	if( act->flag == BLACT_MOVE_NORM){
		normAnmTexDataSet( act );
	}else if( act->flag == BLACT_MOVE_VRAM ){
		transItpVramAnm( act->ItpVramObj, act->frame );
	}
	
	simple_3DModelDraw( &act->RenderObj, &act->Matrix, &rot, &act->Scale );
	DrawTexreBind( act );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Vram]p@f[^`FWf[^i[֐
 *
 *	@param	act			r{[hAN^[
 *	@param	header		wb_[f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void chgBillboadAnmSet_Core_VRAM( BLACT_WORK* act, const BLACT_HEADER* header )
{
	BLACT_SET*	as;	// AN^[Zbg

	// ̐ẽr{[hZbg
	as = (BLACT_SET*)act->pBlActSet;		

	// ܂ł̃Ajf[^j
	del_blact(as, act);

	// V\[X_[IuWFɊ֘At
	// f\[X
	// VramKey̎擾s
	data_chg_vram_mdl_core(act, header);
	
	// u]}l[W[ɃXgǉ
	data_chg_vram_anm_core(as, act, header);

	if(act->flag == BLACT_MOVE_INIT){
		// Xgɐݒ
		setList(&as->Dummy, act);
	}

	// s[hݒ
	act->flag = BLACT_MOVE_VRAM;

	// Aj[Ve[uݒ
	act->pAnmTbl	= header->anm;

	// Aj[VItZbgƁAt[Zbg
	act->AnmOffs		= 0;
	act->frame			= 0;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	풓Aj̃Aj[VZbgύX֐
 *
 *	@param	blact_w		r{[h[N
 *	@param	header		wb_[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void core_anmset_chg_norm( BLACT_WORK* blact_w, const BLACT_HEADER* header)
{
	BLACT_SET* pBlActSet = blact_w->pBlActSet;

	// ܂ł̃f[^j	
	// f\[X
	del_blact(pBlActSet, blact_w);

	// Vram][h̎̓r{[hAN^[
	// VrammۂĂ̂Ńr{[hAN^[Ŕj
	if(blact_w->flag == BLACT_MOVE_VRAM){
		// VramKeyj
		delBindTexture( &blact_w->texKey, &blact_w->tex4x4Key, &blact_w->plttKey );
	}

	// f[^ݒ
	// ff[^@Ajf[^@VramKey̐ݒ
	// VramKeyݒ
	blact_w->texKey		= header->texKey;
	blact_w->tex4x4Key	= header->tex4x4Key;
	blact_w->plttKey	= header->plttKey;

	// f\[X_[IuWFɐݒ
	data_chg_norm_mdl_core( blact_w, header );

	// Aj[VIuWF\zA_[IuWFɓo^
	data_chg_norm_anm_core( blact_w, header );


	if(blact_w->flag == BLACT_MOVE_INIT){
		// Xgɐݒ
		setList(&pBlActSet->Dummy, blact_w);
	}


	// s[hݒ
	blact_w->flag = BLACT_MOVE_NORM;

	// Aj[Ve[uݒ
	blact_w->pAnmTbl	= header->anm;

	// Aj[VItZbgƁAt[Zbg
	blact_w->AnmOffs		= 0;
	blact_w->frame			= 0;
}


//----------------------------------------------------------------------------
//
//
//	Aj[VZbgύX֐̃RA֐S
//
//
//============================================================================
//----------------------------------------------------------------------------
/**
 *
 *@brief	eNX`L[̈Vram}l[W[mۂ
 *
 *@param	tex			eNX`\[X
 *@param	texkey		eNX`L[
 *@param	tex4x4key	4x4keNX`L[
 *@param	plttkey		pbgL[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void allocTexKey(const NNSG3dResTex* tex, NNSG3dTexKey* texkey, NNSG3dTexKey* tex4x4key, NNSG3dPlttKey* plttkey)
{
    u32 szTex, szTex4x4, szPltt;
	

	// KvȃTCY擾
	szTex    = NNS_G3dTexGetRequiredSize(tex);
	szTex4x4 = NNS_G3dTex4x4GetRequiredSize(tex);
	szPltt   = NNS_G3dPlttGetRequiredSize(tex);

	if (szTex > 0){
		// ݂΃eNX`C[WXbgɊm
		*texkey = NNS_GfdAllocTexVram(szTex, FALSE, 0);
		GF_ASSERT(*texkey != BLACT_TEXKEY_VRAMANM);
//		OS_Printf( "tex addr %x size %x\n", NNS_GfdGetTexKeyAddr(*texkey), NNS_GfdGetTexKeySize(*texkey) );
	}else{
		*texkey = 0;
	}

	if (szTex4x4 > 0){
		// ݂΃eNX`C[WXbgɊm
		*tex4x4key = NNS_GfdAllocTexVram(szTex4x4, TRUE, 0);
		GF_ASSERT(*tex4x4key != BLACT_TEXKEY_VRAMANM);
//		OS_Printf( "4x4tex addr %x size %x\n", NNS_GfdGetTexKeyAddr(*tex4x4key), NNS_GfdGetTexKeySize(*tex4x4key) );
	}else{
		*tex4x4key = 0;
	}

	if (szPltt > 0){
		// ݂΃eNX`pbgXbgɊm
		*plttkey = NNS_GfdAllocPlttVram(szPltt,
							tex->tex4x4Info.flag & NNS_G3D_RESPLTT_USEPLTT4,
							0);
		GF_ASSERT(*plttkey != BLACT_PLTTKEY_VRAMANM);
//		OS_Printf( "pltt addr %x size %x\n", NNS_GfdGetPlttKeyAddr(*plttkey), NNS_GfdGetPlttKeySize(*plttkey) );
	}else{
		*plttkey = 0;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	eNX`ɃoChĂVramL[
 *
 *@param	tex			eNX`
 *@param	texkey		ʏeNX`L[
 *@param	tex4x4key	4x4keNX`L[
 *@param	plttkey		pbgL[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void releaseTexture(NNSG3dResTex* tex, NNSG3dTexKey* texkey, NNSG3dTexKey* tex4x4key, NNSG3dPlttKey* plttkey)
{
	// 
	NNS_G3dTexReleaseTexKey( tex, texkey, tex4x4key );
	*plttkey = NNS_G3dPlttReleasePlttKey( tex );
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	eNX`L[̍Đݒ
 *
 *@param	tex			eNX`[X
 *@param	mdl			f\[XZbg
 *@param	texkey		ʏeNX`L[
 *@param	tex4x4key	4x4keNX`L[
 *@param	plttkey		pbgL[
 * 
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void reBindTexture(NNSG3dResTex* tex, NNSG3dResMdlSet* mdl, NNSG3dTexKey* texkey, NNSG3dTexKey* tex4x4key, NNSG3dPlttKey* plttkey)
{
	// eNX`L[
	NNS_G3dTexSetTexKey( tex, *texkey, *tex4x4key );
	// pbgL[
	NNS_G3dPlttSetPlttKey( tex, *plttkey );

	// oCh
	// fZbg̃oCh
	NNS_G3dBindMdlSet(mdl, tex);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	eNX`L[j
 *
 *@param	texkey		ʏeNX`L[
 *@param	tex4x4key	4x4keNX`L[
 *@param	plttkey		pbgL[
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void delBindTexture(NNSG3dTexKey* texkey, NNSG3dTexKey* tex4x4key, NNSG3dPlttKey* plttkey)
{
	if(*texkey != BLACT_TEXKEY_VRAMANM){
		NNS_GfdFreeTexVram( *texkey );
	}
	if(*tex4x4key != BLACT_TEXKEY_VRAMANM){
		NNS_GfdFreeTexVram( *tex4x4key );
	}
	if(*plttkey != BLACT_PLTTKEY_VRAMANM){
		NNS_GfdFreePlttVram( *plttkey );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	eNX`TCY`FbN
 *
 *@param	tex		`FbNeNX`\[X
 *
 *@retval	TRUE	
 *@retval	FALSE	Ȃ
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL check_texsize_equal(const NNSG3dResTex* tex1, const NNSG3dResTex* tex2)
{
	u32 szTex0, szTex4x40, szPltt0;		// eTCY
	u32 szTex1, szTex4x41, szPltt1;		// eTCY
	BOOL ret;

	if((tex1 == NULL) || (tex2 == NULL)){
		return FALSE;
	}
	
	szTex0    = NNS_G3dTexGetRequiredSize(tex1);  
	szTex4x40 = NNS_G3dTex4x4GetRequiredSize(tex1);
	szPltt0   = NNS_G3dPlttGetRequiredSize(tex1);

	szTex1    = NNS_G3dTexGetRequiredSize(tex2);  
	szTex4x41 = NNS_G3dTex4x4GetRequiredSize(tex2);
	szPltt1   = NNS_G3dPlttGetRequiredSize(tex2);

	// TCYႤ`FbN
	if( (szTex0 != szTex1) || (szTex4x40 != szTex4x41) || (szPltt0 != szPltt1) ){
		ret = FALSE;		// Ȃ
	}else{
		ret = TRUE;			// 
	}

	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	r{[hAN^[j
 *
 *@param	pBlActSet	r{[hAN^[Zbg
 *@param	delWork		jr{[hAN^[
 *
 * SɔjƂ
 *	̌ハ[NX^bNɃvbVKvB
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void del_blact(BLACT_SET* pBlActSet, BLACT_WORK* delWork)
{

	if(delWork->ItpVramObj){
		// u]AjXgj
		remItpVramAnm( delWork->ItpVramObj );
		delWork->ItpVramObj = NULL;
	}
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	ff[^[Nɐݒ
 *
 *@param	blact_w			f[^i[惏[N
 *@param	header			wb_[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void data_chg_vram_mdl_core(BLACT_WORK* blact_w, const BLACT_HEADER* header)
{
	NNSG3dResTex* old_tex;
	int	result;

	// eNX`̃TCYႤ`FbN邽
	// ÂeNX`ۑ
	old_tex = blact_w->pMdlTex;	

	// r{[h̃f[^\[X}l[W[擾	
	blact_w->pModelSet = blact_getMdl(	// f\[XZbg擾
			header,					// wb_[
			&blact_w->pModel,		// f\[X
			&blact_w->pMdlTex);		// eNX`\[X
	
	NNS_G3dRenderObjInit( &blact_w->RenderObj, blact_w->pModel );	// _[IuWF

	// ÂeNX`ƔׁAVramKeyςKv邩`FbN
	// O풓AĵƂ͖VramKey擾
	if(blact_w->flag != BLACT_MOVE_NORM){
		
		result = check_texsize_equal(old_tex, blact_w->pMdlTex);
	}else{
		result = FALSE;
	}
	if(result == FALSE){	// resultFALSEȂVramKey̍Ď擾

		// OVram]Ȃ獡VramKeyj
		if( blact_w->flag == BLACT_MOVE_VRAM ){
			delBindTexture(
					&(blact_w->texKey),
					&(blact_w->tex4x4Key),
					&(blact_w->plttKey) );
		}
		allocTexKey(
				blact_w->pMdlTex,
				&(blact_w->texKey),
				&(blact_w->tex4x4Key),
				&(blact_w->plttKey) );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	eNX`p^[Aj[V
 *
 *@param	pBlActSet		r{[hAN^[Zbg
 *@param	blact_w			f[^i[惏[N 
 *@param	header			wb_[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void data_chg_vram_anm_core(const BLACT_SET* pBlActSet, BLACT_WORK* blact_w, const BLACT_HEADER* header)
{
	
	// p^[̃eNX`擾
	blact_w->pAnmTex = blact_getTex(
			header );

//	OS_Printf( "tex %x \n",NNS_G3dTexGetRequiredSize(p_tex) );

	// eNX`Aj[Vf[^ݒ
	blact_w->texAnm = header->texanm;

	// Vram]Aj[V`FbN
	// u]Aj[VVXeɃZbg
	blact_w->ItpVramObj = addItpVramAnm( 
				pBlActSet->pItpTop,
				&blact_w->texAnm,		// Aj[Vf[^e[u
				blact_w->pAnmTex,		// eNX`
				blact_w->texKey,		// eNX`f[^]VramKey
				blact_w->plttKey,		// pbgf[^]VramKey
				blact_w->frame			// t[l
				);		

}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	풓Ajpff[^쐬
 *
 *	@param	blact_w		r{[h[N
 *	@param	header		wb_[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void data_chg_norm_mdl_core(BLACT_WORK* blact_w, const BLACT_HEADER* header)
{
	// r{[h̃f[^\[X}l[W[擾	
	blact_w->pModelSet = blact_getMdl(	// f\[XZbg擾
			header,						// wb_[
			&blact_w->pModel,			// f\[X
			&blact_w->pMdlTex );		// oChpeNX`\[X

	NNS_G3dRenderObjInit( &blact_w->RenderObj, blact_w->pModel );	// _[IuWF

	// Aj[VpeNX`擾
	blact_w->pAnmTex = blact_getTex(
			header );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	풓AjpAj[VIuWF֐
 *
 *	@param	blact_w		r{[h[N
 *	@param	header		wb_[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void data_chg_norm_anm_core(BLACT_WORK* blact_w, const BLACT_HEADER* header)
{
	// eNX`Aj[Vf[^ݒ
	blact_w->texAnm = header->texanm;

	// Vram]Aj}l[WNULLݒ
	blact_w->ItpVramObj = NULL;
}

//=============================================================================
//
//		r{[hAN^[[N֐S
//
//		r{[hAN^[@X𑀍삷
//
//=============================================================================
//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[̒ǉ
 *
 *	@param	add		r{[hAN^[o^f[^
 *
 *	@retval BLACT_WORK_PTR	o^[Ñ|C^
 *	@retval	NULL			s
 *	
 */
//-----------------------------------------------------------------------------
BLACT_WORK_PTR BLACT_Add(const BLACT_ADD* add)
{
	BLACT_WORK*	bl_w;		// o^r{[h[N
	BLACT_SET*	bs;			// r{[hAN^[Zbg

	// r{[hAN^[Zbg擾
	if(add->blact_s == NULL){
		return NULL;
	}

	bs = add->blact_s;

	// X^bN擾
	bl_w = popStack(bs);
	if(bl_w == NULL){
		return NULL;
	}

	// r{[hAN^[\̔zɃf[^o^
	bl_w->pBlActSet	= bs;					// AN^[Zbg
	bl_w->Matrix	= add->matrix;			// ΍W
	bl_w->Scale		= add->scale;			// gk
	bl_w->AnmOffs	= 0;					// ̃Aj[VItZbg
	bl_w->draw		= 1;					// \

	// tOɂ
	bl_w->flag = BLACT_MOVE_INIT;	// 

	// ł̓ǂݍ݂͂łȂ̂ŃAj[VZbg`FWVXeɗ
	chgBillboadAnmSet_Core( bl_w, add->pHeader );
	

	return bl_w;
}

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	r{[hAN^[̍폜
 *
 *	@param	del		jr{[hAN^[\
 *
 *	@retval	TRUE	(BOOL^F폜ɐ)
 *	@retval	FALSE	s
 *
 */
//-----------------------------------------------------------------------------
BOOL BLACT_Delete(BLACT_WORK* del)
{
	BLACT_SET* as;	// AN^[Zbg

	GF_ASSERT(del);

	// ɒɔjꂽƂ̓AT[go
	GF_ASSERT_MSG(del->flag != BLACT_MOVE_INIT,
			"Ē̔j͏o܂B");		

	as = (BLACT_SET*)del->pBlActSet;		// AN^[Zbg
	

	// f[^̂`FbN
	if( (del->flag == BLACT_MOVE_NONE) ){
		return FALSE;
	}

	// Xgj
	remList(del);

	// Vram][h̎
	// r{[hAN^[VramKey擾Ă̂
	// eNX`
	if( del->flag == BLACT_MOVE_VRAM ){
		delBindTexture(&(del->texKey), &(del->tex4x4Key), &(del->plttKey));
	}
	
	// ܂ł̃f[^j	
	// f\[X
	del_blact(as, del);
	
	// X^bNɃvbV
	pushStack(as, del);

	// jA̕`܂ł͎cĂ
	as->DelObjDrawRef = BLACT_DRAW_REF_DRAW_BEFORE;

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 * 
 *	@brief	풓Ajp@r{[hAN^[wb_[f[^쐬x֐
 *
 *	@param	p_header		r{[hAN^[wb_[f[^i[
 *	@param	p_imd			r{[hf\[X
 *	@param	cp_itx			Aj[VeNX`\[X
 *	@param	cp_anm			Aj[Ve[u
 *	@param	cp_texanm		eNX`Aj[Vf[^e[u
 *	@param	texkey			eNX`L[
 *	@param	tex4x4key		4x4keNX`L[
 *	@param	plttkey			pbgL[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void BLACT_MakeHeaderNormalAnm( BLACT_HEADER* p_header, void* p_imd, const NNSG3dResTex* cp_itx, const BLACT_ANIME_TBL* cp_anm, const TEXANM_DATATBL* cp_texanm, NNSGfdTexKey texkey, NNSGfdTexKey tex4x4key, NNSGfdPlttKey plttkey  )
{
	p_header->ImdRes	= p_imd;
	p_header->ItxRes	= cp_itx;
	p_header->anm		= cp_anm;
	p_header->texanm	= *cp_texanm;
	p_header->texKey	= texkey;
	p_header->tex4x4Key	= tex4x4key;
	p_header->plttKey	= plttkey;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Vram]Ajp@r{[hAN^[wb_[f[^쐬x֐
 *
 *	@param	p_header		r{[hAN^[wb_[f[^i[
 *	@param	p_imd			r{[hf\[X
 *	@param	cp_itx			Aj[VeNX`\[X
 *	@param	cp_anm			Aj[Ve[u
 *	@param	cp_texanm		eNX`Aj[Vf[^e[u
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void BLACT_MakeHeaderVramAnm( BLACT_HEADER* p_header, void* p_imd, const NNSG3dResTex* cp_itx, const BLACT_ANIME_TBL* cp_anm, const TEXANM_DATATBL* cp_texanm )
{
	p_header->ImdRes	= p_imd;
	p_header->ItxRes	= cp_itx;
	p_header->anm		= cp_anm;
	p_header->texanm	= *cp_texanm;
	p_header->texKey	= BLACT_TEXKEY_VRAMANM;
	p_header->tex4x4Key	= BLACT_TEXKEY_VRAMANM;
	p_header->plttKey	= BLACT_PLTTKEY_VRAMANM;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	Wݒ
 *
 *@param	act		ݒ肷AN^[
 *@param	mat		ݒ肷W
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void BLACT_MatrixSet(BLACT_WORK_PTR act, const VecFx32* mat)
{
	GF_ASSERT(act);
	act->Matrix = *mat;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	W擾
 *
 *@param	act		擾AN^[
 * 
 *@return	const VecFx32*	W
 *
 */
//-----------------------------------------------------------------------------
const VecFx32* BLACT_MatrixGet(CONST_BLACT_WORK_PTR act)
{
	GF_ASSERT(act);
	return &act->Matrix;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	glݒ肷
 *
 *@param	act		ݒ肷AN^[
 *@param	sca		ݒ肷gl
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void BLACT_ScaleSet(BLACT_WORK_PTR act, const VecFx32* sca)
{
	GF_ASSERT(act);

	act->Scale = *sca;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	gl擾
 *
 *@param	act		擾AN^[
 *
 *@return	const VecFx32*	gl
 *
 *
 */
//-----------------------------------------------------------------------------
const VecFx32* BLACT_ScaleGet(CONST_BLACT_WORK_PTR act)
{
	GF_ASSERT(act);
	return &act->Scale;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	`tOݒ肷
 *
 *@param	act		ݒ肷AN^[
 *@param	flag	`tO	1:`	0:`
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void BLACT_ObjDrawFlagSet(BLACT_WORK_PTR act, u8 flag)
{
	GF_ASSERT(act);

	act->draw = flag;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	`tO擾
 *
 *@param	act		擾AN^[
 *
 *@return	u8		1:`	0:`
 *
 *
 */
//-----------------------------------------------------------------------------
u8 BLACT_ObjDrawFlagGet(CONST_BLACT_WORK_PTR act)
{
	GF_ASSERT(act);
	return act->draw;
}

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	Aj[Vς
 *			ł̓^XNɃf[^Zbg邾łB
 *
 *							
 *	@param	act			`FW铮z
 *	@param	header		`FWAj[Vwb_[
 *
 *	@return none
 *
 *	Eo^Ă܂BLACT_AfterDrawSysʂĂȂAN^[ɂ͎gpł܂
 *	Eۂ̕ύXBLACT_AfterDrawSys֐ōs܂B
 * 
 */
//-----------------------------------------------------------------------------
void BLACT_AnmSetChg( BLACT_WORK* act, const BLACT_HEADER* header )
{
	GF_ASSERT(act);
	
	// Aj[VZbgύX
	chgBillboadAnmSet_Core( act, header );
}

//-----------------------------------------------------------------------------
/**
 *
 *@brief	Aj[VItZbgύX
 *
 *@param	act		`FW铮z
 *@param	num		ZbgAj[VItZbgio[
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void BLACT_AnmOffsChg( BLACT_WORK_PTR act, int num )
{
	GF_ASSERT(act);

	// Aj[VItZbg
	act->AnmOffs = num;
}


//-----------------------------------------------------------------------------
/**
 *
 *@brief	Aj[VItZbgύXƓɕύXʂɔf
 *
 *@param	act		`FW铮z
 *@param	num		ZbgAj[VItZbgio[
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void BLACT_AnmOffsChgRef( BLACT_WORK_PTR act, int num )
{
	BLACT_AnmOffsChg( act, num );
	BLACT_AnmFrameChg( act, FX32_ONE );	// f
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Aj[VItZbg擾
 *
 *@param	act		擾AN^[
 *
 *@return	int		Aj[VItZbg
 *
 *
 */
//-----------------------------------------------------------------------------
int BLACT_AnmOffsGet( CONST_BLACT_WORK_PTR act )
{
	GF_ASSERT(act);
	
	// Ȃ̂ŁÃAj[VZbgio[Ԃ
	return act->AnmOffs;
}

//----------------------------------------------------------------------------
/**
 *@brief	Aj[Vt[𓮂
 *						ۂɃAj[V[vĐƂɎgp
 *
 *@param	act		Aj[V铮z
 *@param	num		Aj[VXs[h
 *
 *@retval	BLACT_ANISTA_LOOP	Đ
 *@retval	BLACT_ANISTA_END	ĐI
 */
//-----------------------------------------------------------------------------
int BLACT_AnmFrameChg( BLACT_WORK* act, fx32 num )
{
	GF_ASSERT(act);

	return anmFrameChg_Core( act, num );
}

//----------------------------------------------------------------------------
/**
 *@brief	Aj[Vt[ݒ
 *
 *@param	act		Aj[V铮z
 *@param	num		ݒ肷t[
 *
 *@return	none
 */
//-----------------------------------------------------------------------------
void BLACT_AnmFrameSet( BLACT_WORK_PTR act, fx32 num )
{
	GF_ASSERT(act);
	act->frame = num;
}

//----------------------------------------------------------------------------
/**
 *@brief	Aj[Vt[擾
 *
 *@param	act		Aj[V铮z
 *
 *@return	fx32	Aj[Vt[
 */
//-----------------------------------------------------------------------------
fx32 BLACT_AnmFrameGet( CONST_BLACT_WORK_PTR act )
{
	GF_ASSERT(act);
	
	// Aj[VIuWFNg̃Aj[Vt[̒lԂ
	return act->frame;
}

//----------------------------------------------------------------------------
/**
 *@brief	݂̃ItZbgJnt[̃Aj[Vt[Zbg
 *
 *@param	act		Aj[V铮z
 *@param	num		Aj[VXs[h
 *
 *@return	none
 *
 *	Aj[VItZbg̊Jnt[+num̃t[Zbg܂B
 *	AjȂ獶Aj̊Jnt[+num̃t[Zbg܂B 
 */
//-----------------------------------------------------------------------------
void BLACT_AnmFrameSetOffs( BLACT_WORK* act, fx32 num )
{
	GF_ASSERT(act);

	// Aj[VIuWFNg̃Aj[Vt[̒lZbg
	act->frame = nowOffsAnmStartFrame(act, act->AnmOffs);
	act->frame += num;
}

//----------------------------------------------------------------------------
/**
 *@brief	݂̃ItZbgJnt[̃Aj[Vt[擾
 *
 *@param	act		Aj[V铮z
 *
 *@return	fx32	Aj[Vt[
 *	t[ - ݂̃Aj[VItZbgJnt[̒lԂ܂
 */
//-----------------------------------------------------------------------------
fx32 BLACT_AnmFrameGetOffs( CONST_BLACT_WORK_PTR act )
{
	GF_ASSERT(act);
	
	// Aj[VIuWFNg̃Aj[Vt[̒lԂ
	return act->frame - nowOffsAnmStartFrame(act, act->AnmOffs);
}

//----------------------------------------------------------------------------
/**
 *	@brief	ID̃r{[hf\[X擾
 *
 *	@param	pDat		f\[X擾r{[hAN^[[N
 *
 *	@return NNSG3dResMdl* f\[X
 *
 */
//-----------------------------------------------------------------------------
NNSG3dResMdl* BLACT_MdlResGet(CONST_BLACT_WORK_PTR pDat)
{
	GF_ASSERT( pDat );
	
	return pDat->pModel;
}

//----------------------------------------------------------------------------
/**
 *	@brief	r{[hAN^[[Ñ|C^擾
 *
 *	@param	set			r{[hAN^[Zbg 
 *	@param	num			r{[hAN^[[NCfbNX
 *
 *	@retval BLACT_WORK_PTR	r{[hAN^[[N
 *	@retval	NULL			̃CfbNX̃[N͖
 *
 */
//-----------------------------------------------------------------------------
BLACT_WORK_PTR BLACT_WorkGet(CONST_BLACT_SET_PTR set, int num)
{
	GF_ASSERT( set );

	return &set->pWork[num];
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	݃r{[hAN^[[N͂ǂȓsĂ邩擾
 *
 *	@param	act		r{[hAN^[[N
 *
 *	@retval	BLACT_MOVE_NONE			삵ĂȂ
 *	@retval BLACT_MOVE_INIT			
 *	@retval	BLACT_MOVE_VRAM			Vram]ғ
 *	@retval	BLACT_MOVE_NORM			풓Ajғ
 *
 */
//-----------------------------------------------------------------------------
int BLACT_GetState( CONST_BLACT_WORK_PTR act )
{
	GF_ASSERT(act);
	return act->flag;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	eNX`L[̎擾
 *
 *	@param	act r{[hAN^[[N
 *
 *	@return	eNX`L[
 *
 *
 */
//-----------------------------------------------------------------------------
NNSGfdTexKey BLACT_GetTexKey( CONST_BLACT_WORK_PTR act )
{
	GF_ASSERT( act );
	return act->texKey;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgL[̎擾
 *
 *	@param	act r{[hAN^[[N
 *
 *	@return	pbgL[
 *
 *
 */
//-----------------------------------------------------------------------------
NNSGfdPlttKey BLACT_GetPlttKey( CONST_BLACT_WORK_PTR act )
{
	GF_ASSERT( act );
	return act->plttKey;
}

//----------------------------------------------------------------------------
/**
 * 풓Aj[Vp
 *
 *	@brief	eNX`L[ݒ肷
 *
 *	@param	act		r{[hAN^[[N
 *	@param	texkey	ݒ肷eNX`L[
 *
 *	@retval	TRUE	ݒ萬
 *	@retval	FALSE	ݒ莸s	iVram]Ajł͎gp邱ƂoȂłj
 *
 *	ɂOtBbNf[^ύX邱Ƃo܂B
 *	ÃOtBbNf[^ƃeNX`̍\iTCYj
 *	łȂƂƂGł܂B
 *
 *	ݒ肵texKeỷ͊OŊǗĂB
 *
 */
//-----------------------------------------------------------------------------
BOOL BLACT_SetTexKey( BLACT_WORK_PTR act, const NNSGfdTexKey* texKey )
{
	GF_ASSERT( act );
	GF_ASSERT( texKey );

	if( act->flag == BLACT_MOVE_NORM ){
		act->texKey = *texKey;
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 * 풓Aj[Vp
 *
 *	@brief	pbgL[ݒ肷
 *
 *	@param	act		r{[hAN^[[N
 *	@param	plttkey	ݒ肷pbgL[
 *
 *	@retval	TRUE	ݒ萬
 *	@retval	FALSE	ݒ莸s	iVram]Ajł͎gp邱ƂoȂłj
 *
 *	ɂpbgύX邱Ƃo܂B
 *	Ãpbgf[^ƃpbg̍\iTCYj
 *	łȂƂƂGł܂B
 *
 *	ݒ肵plttKeỷ͊OŊǗĂB
 *
 */
//-----------------------------------------------------------------------------
BOOL BLACT_SetPlttKey( BLACT_WORK_PTR act, const NNSGfdPlttKey* plttKey )
{
	GF_ASSERT( act );
	GF_ASSERT( plttKey );

	if( act->flag == BLACT_MOVE_NORM ){
		act->plttKey = *plttKey;
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	r{[hAN^[̃JO`FbN
 *
 *	@param	act		AN^[
 *
 *	@return	u32
 */
//-----------------------------------------------------------------------------
u32 BLACT_CullingCheck( BLACT_WORK_PTR act )
{
	MtxFx33 rot;
	
	//@]s񏉊
	MTX_Identity33( &rot );
	
	return BB_CullingCheck3DModel( act->pModel, &act->Matrix, &rot, &act->Scale );
}


//----------------------------------------------------------------------------
/**
 *	@brief	Vram]A]NGXg
 *	@param	act		AN^[
 */
//-----------------------------------------------------------------------------
void BLACT_VramAnmTransUserReq( BLACT_WORK_PTR act )
{
	if(act->flag == BLACT_MOVE_VRAM){
		// Vram]s(Vram][ĥƂ̂)
		transItpVramAnm(act->ItpVramObj, act->frame);
	}
}


//=============================================================================
//
//		vCx[g֐S
//
//=============================================================================
//-------------------------------------
//	풓AjpVXe
//=====================================
//----------------------------------------------------------------------------
/**
 *
 *	@brief	eNX`EpbgQƃAhXݒ
 *
 *	@param	act		r{[hAN^[f[^
 *
 *	@return	none
 *
 * (fɃeNX`oChĂKv܂)
 *
 */
//-----------------------------------------------------------------------------
static void normAnmTexDataSet( BLACT_WORK* act )
{
	TEXANM_DATA	texdata;		// ݃t[̃eNX`CfbNX@pbgCfbNX

	// ݂̃t[̃eNX`EpbgCfbNX擾
	texdata = TEXANM_GetFrameData( &act->texAnm, act->frame >> FX32_SHIFT );

	// eNX`AhXݒ
	// tex_idx̃eNX`VramAhXf̃}eAf[^ɐݒ
	normAnmTexParamSet( act->pModel, act->pAnmTex, texdata.tex_idx );

	// pbgAhXݒ
	// pltt_idx̃pbgVramAhXf̃}eAf[^ɐݒ
	normAnmPlttParamSet( act->pModel, act->pAnmTex, texdata.pltt_idx );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	f̃oChf[^S@eNX`CfbNX̃eNX`VramAhXݒ肷
 *
 *	@param	p_mdl		ff[^
 *	@param	p_tex		eNX`\[Xf[^
 *	@param	tex_idx		eNX`CfbNX
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void normAnmTexParamSet( NNSG3dResMdl* p_mdl, const NNSG3dResTex* p_tex, u8 tex_idx )
{
	NNSG3dResMat*  mat;
    const NNSG3dResDict* dict_tex;
	const NNSG3dResDictTexToMatIdxData* data;
	const NNSG3dResDictTexData* texdict_data;
	u32	tex_offs;			// eNX`̃ItZbgio[
	int i;

	// Kvȃ}eAf[^
	// eNX`oChp}eA񎫏擾
    mat     = NNS_G3dGetMat(p_mdl);
    dict_tex = (NNSG3dResDict*)((u8*)mat + mat->ofsDictTexToMatList);

	// eNX`ItZbgeNX`\[X擾
	texdict_data = NNS_G3dGetTexDataByIdx( p_tex, tex_idx );
	tex_offs = (texdict_data->texImageParam & NNS_G3D_TEXIMAGE_PARAM_TEX_ADDR_MASK);
    
    // f\[X̃eNX`->}eACfbNX񎫏
    // ꂼɑ΂ă[v
    for (i = 0; i < dict_tex->numEntry; ++i){

		// iԖڂ̃eNX`ɊւoChf[^擾
		data = (NNSG3dResDictTexToMatIdxData*) NNS_G3dGetResDataByIdx(dict_tex, i);

		// oChꂽԂ̂Ƃ̂
		// eNX`AhXݒ
		if ((data->flag & 1)){
			
			// oChĂƂ̓ff[^̃}eA[TexImageParam̒VramKeyAhXĂ
			normAnmTexParamSetOneMatData(mat, data, tex_offs );
		}
    }
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	oCh̃}eAf[^@eNX`CfbNX̃eNX`VramAhXݒ肷
 *
 *	@param	pMat			}eAf[^S
 *	@param	pBindData		oCh
 *	@param	tex_offs		eNX`ItZbg
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void normAnmTexParamSetOneMatData( NNSG3dResMat* pMat, const	NNSG3dResDictTexToMatIdxData* pBindData, u32 tex_offs )
{
	u8* p_matidx;	// }eAf[^CfbNXz
	int i;			// [vp
	NNSG3dResMatData* mat_data;	// }eAf[^

	// }eAf[^CfbNXz擾
	p_matidx = (u8*)pMat + pBindData->offset;
	
	// }eAf[^eNX`AhXݒ
    for (i = 0; i < pBindData->numIdx; i++){
		
        // emat_dataɃeNX`ZbgAbvĂB
        mat_data = NNS_G3dGetMatDataByIdx(pMat, *(p_matidx + i));
		
		// 擪̃ItZbglovert[Ȃ`FbN
		GF_ASSERT( ((mat_data->texImageParam & NNS_G3D_TEXIMAGE_PARAM_TEX_ADDR_MASK) + tex_offs) <= NNS_G3D_TEXIMAGE_PARAM_TEX_ADDR_MASK );
		
        mat_data->texImageParam += tex_offs;
    }
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	f̃oChf[^S@pbgAhXݒ肷
 *
 *	@param	p_mdl		f\[X
 *	@param	p_tex		eNX`\[X
 *	@param	pltt_idx	pbgf[^CfbNX
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void normAnmPlttParamSet( NNSG3dResMdl* p_mdl, const NNSG3dResTex* p_tex, u8 pltt_idx )
{
    NNSG3dResMat*  mat;
    const NNSG3dResDict* dict_pltt;
	const NNSG3dResDictPlttToMatIdxData* data;
	const NNSG3dResDictPlttData* plttdict_data;
	u32	pltt_offs;			// pbg̃ItZbgio[
    u32 i;

	// f}eAf[^ɂpbgoChf[^擾
    mat      = NNS_G3dGetMat(p_mdl);
    dict_pltt = (NNSG3dResDict*)((u8*)mat + mat->ofsDictPlttToMatList);

	// eNX`f[^pbgCfbNXio[
	// ̐擪̃f[^ItZbg擾
	// ItZbgl4bitEɃVtgԂœĂ邪A
	// 4FJ[pbgȊÔƂ3bitEVtglɂKv
	plttdict_data = NNS_G3dGetPlttDataByIdx( p_tex, pltt_idx );
	pltt_offs = plttdict_data->offset;
	if( !(plttdict_data->flag & 1) ){		// 4FJ[pbg̎1bitĂ
		pltt_offs >>= 1;
	}

    for (i = 0; i < dict_pltt->numEntry; ++i){
		
		// pbgoChf[^擾
		data = (NNSG3dResDictPlttToMatIdxData*) NNS_G3dGetResDataByIdx(dict_pltt, i);

		// oChĂƂ͕ύX
		if ((data->flag & 1)){
			
			// oChĂƂPlttBase̒VramKeyAhXĂ
			normAnmPlttParamSetOneMatData( mat, data, pltt_offs );
		}
    }
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	oChf[^̃}eAf[^pbgItZbgݒ
 *
 *	@param	pMat			}eAf[^S
 *	@param	pBindData		oCh
 *	@param	pltt_offs		pbgItZbg 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void normAnmPlttParamSetOneMatData( NNSG3dResMat* pMat, const NNSG3dResDictPlttToMatIdxData* pBindData, u32 pltt_offs )
{
    u8* matdata_idx;
    u32 i;

	// }eAf[^CfbNXz擾
    matdata_idx = (u8*)pMat + pBindData->offset;
	
	// oCh̃f[^
	// }eAf[^̃pbgAhXݒ
    for (i = 0; i < pBindData->numIdx; i++) {
        // ematDataɃpbgZbgAbvĂB
        NNSG3dResMatData* matData = NNS_G3dGetMatDataByIdx(pMat, *(matdata_idx + i));
		
		// overt[Ȃ`FbN
		GF_ASSERT( ((matData->texPlttBase & BLACT_PLTT_BASE_MASK) + pltt_offs) <= BLACT_PLTT_BASE_MASK );
		
        matData->texPlttBase += pltt_offs;
    }
}


//-------------------------------------
//	stack̏
//=====================================
//-----------------------------------------------------------------------------
/**
 *
 *	@brief	X^bN
 *
 *	@param	pSet		X^bNf[^i[
 *	@return none
 *
 */
//-----------------------------------------------------------------------------
static void initStack(BLACT_SET* pSet)
{
	int i;

	// 
	for (i=0; i<pSet->WorkNum; i++) {
		BLACT_WorkClear(&pSet->pWork[i]);
		pSet->ppWorkStack[i] = pSet->pWork + i;
	}
	pSet->WorkStackNow = 0;
}

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	X^bNo
 *
 *	@param	pSet		X^bNf[^i[
 *	
 *	@retval	NULLȊO	r{[h[N
 *	@retval	NULL		oɎsiX^bN󂾂ꍇj
 *
 */
//-----------------------------------------------------------------------------
static BLACT_WORK* popStack(BLACT_SET* pSet)
{
	BLACT_WORK*	ret;

	// ~bg`FbN
	if(pSet->WorkStackNow >= pSet->WorkNum){
		return NULL;
	}

	ret = pSet->ppWorkStack[pSet->WorkStackNow];
	pSet->WorkStackNow++;

	return ret;
}

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	X^bNɊi[
 *
 *	@param	pSet		X^bNf[^i[
 *	@param	pDat		i[f[^
 *	
 *	@retval	TRUE		
 *	@retval	FALSE		X^bNς
 */
//-----------------------------------------------------------------------------
static BOOL pushStack(BLACT_SET* pSet, BLACT_WORK* pDat)
{
	if(pSet->WorkStackNow <= 0){	// 󂫃`FbN
		return FALSE;
	}
	BLACT_WorkClear(pDat);
	pSet->WorkStackNow--;
	pSet->ppWorkStack[pSet->WorkStackNow] = pDat;

	return TRUE;
}

//-------------------------------------
//	XgǗ
//=====================================
//-----------------------------------------------------------------------------
/**
 *
 *	@brief	Xgɐݒ
 *
 *	@param	pDummy		擪f[^
 *	@param	pDat		ݒf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void setList(BLACT_WORK* pDummy, BLACT_WORK* pDat)
{
	pDat->prev				= pDummy->prev;
	pDummy->prev->next		= pDat;
	pDat->next				= pDummy;
	pDummy->prev			= pDat;
}

static void remList(BLACT_WORK* pDat)
{
	// XgO
	pDat->prev->next = pDat->next;
	pDat->next->prev = pDat->prev;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	f\[X擾
 *
 *@param	bl_s		r{[hAN^[Zbg
 *@param	p_head		wb_[
 *@param	num			Aj[VZbgio[
 *@param	ppMdl		f\[X
 *@param	ppTex		eNX`\[Xi[p
 *
 *@return	NNSG3dResMdlSet
 *
 *
 */
//-----------------------------------------------------------------------------
static NNSG3dResMdlSet* blact_getMdl(const BLACT_HEADER* p_head,NNSG3dResMdl** ppMdl, NNSG3dResTex** ppTex)
{
	void*				res;		// \[X
	NNSG3dResMdlSet*	mdl_set;		// f\[X

	// \[X擾	
	res = getRes(p_head, BLACT_RES_MAN_MDL);

	// f擾
	mdl_set = NNS_G3dGetMdlSet(res);
	*ppMdl = NNS_G3dGetMdlByIdx( mdl_set, 0 );

	if(ppTex){

		*ppTex = NNS_G3dGetTex( res );
	}

	return mdl_set;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	eNX`\[X擾
 *
 *@param	bl_s		r{[hAN^[Zbg
 *@param	p_head		wb_[
 *@param	num			Aj[VZbgio[
 *
 *@return	NNSG3dResMdl
 *
 *
 */
//-----------------------------------------------------------------------------
static NNSG3dResTex* blact_getTex(const BLACT_HEADER* p_head)
{
	NNSG3dResTex*	tex;		// eNX`\[X

	// \[Xf[^擾
	tex = (NNSG3dResTex*)getRes(p_head, BLACT_RES_MAN_TEX);
	return tex;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	eNX`p^[Aj[V̓ǂݍ
 *
 *@param	bl_s			r{[hAN^[Zbg
 *@param	p_head			r{[hAN^[wb_[
 *@param	anm_set			Aj[VZbgio[
 *@param	p_mdl			f\[Xiǂݍݍς݁j
 *@param	p_tex			eNX`\[Xiǂݍݍς݁NULLVram]pj
 *@param	pAlloc			gpAP[^
 *
 *@return	NNSG3dResFileHeader*	ǂݍ񂾃Aj[V\[X
 *
 *
 */
//-----------------------------------------------------------------------------
static NNSG3dAnmObj* blact_getItp(const BLACT_HEADER* p_head, const NNSG3dResMdl* p_mdl, const NNSG3dResTex* p_tex, NNSFndAllocator* pAlloc)
{
	void*			res;		// \[X
	NNSG3dAnmObj*	anm;		// Aj[VIuWF
    NNSG3dResTexPatAnm* pAnmRes;// Aj[V\[X

	// \[X擾
	res = getRes(p_head, BLACT_RES_MAN_ANM);

	// CfbNXÕAj[Vw
    pAnmRes = (NNSG3dResTexPatAnm*)NNS_G3dGetAnmByIdx(res, 0);

	// Kvʂ̃AP[gBCjVCY͕ʓrKvɂȂB
    anm = NNS_G3dAllocAnmObj(pAlloc, // gpAP[^w
                            pAnmRes,    // Aj[V\[Xw
                            p_mdl);    // f\[Xw


	//
    // AnmObj B
    //
    NNS_G3dAnmObjInit(anm,		// Aj[VIuWFNgւ̃|C^
                      pAnmRes,	// Aj\[Xւ̃|C^
                      p_mdl,	// NNSG3dResMdlւ̃|C^
					  p_tex );	// NNSG3dResTexւ̃|C^
	return anm;
}

//-----------------------------------------------------------------------------
/**
 *	@brief	Aj[VZbgύXiۂɏ֐j
 *
 *  @param	act		`FW铮z
 *  @param	header	wb_[f[^
 *
 *	@return none
 *
 *ł̓^XNɃf[^Zbg	
 *			ۂɓւ̂VuNBLACT_VlBank()
 *
 */
//-----------------------------------------------------------------------------
static void chgBillboadAnmSet_Core( BLACT_WORK* act, const BLACT_HEADER* header )
{
	// 풓AjVram]Aj`FbN
	if( header->texKey == BLACT_TEXKEY_VRAMANM ){
		
		// Vram]
		chgBillboadAnmSet_Core_VRAM( act, header );
	}else{

		// 풓Aj
		core_anmset_chg_norm( act, header );
	}
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	ItZbgl̎̊Jnt[擾
 *
 *	@param	act		擾r{[hAN^[
 *	@param	offs	ItZbgl
 *
 *	@return	fx32	Jnt[
 *
 *
 */
//-----------------------------------------------------------------------------
static fx32	nowOffsAnmStartFrame( const BLACT_WORK* act, int offs )
{
	const BLACT_ANIME_TBL* p_anm_tbl;				// Aj[Ve[u
	p_anm_tbl	= getAnmTbl( act->pAnmTbl,  offs );	// Aj[Ve[u

	return p_anm_tbl->start << FX32_SHIFT;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Aj[Vt[ύX@ʏ펞p
 *
 *	@param	act		r{[hAN^[[N
 *	@param	num		ύX
 *
 *	@retval	BLACT_ANISTA_LOOP	Đ
 *	@retval	BLACT_ANISTA_END	ĐI
 *
 *
 */
//-----------------------------------------------------------------------------
static int anmFrameChg_Core( BLACT_WORK* act, fx32 num )
{
	const BLACT_ANIME_TBL* p_anm_tbl;	// Aj[Ve[u

	p_anm_tbl	= getAnmTbl( act->pAnmTbl, act->AnmOffs );

	return anmFrameChgSys( p_anm_tbl, &act->frame, num );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	t[ύXVXe
 *
 *	@param	anm		Aj[Ve[u
 *	@param	frame	t[̃|C^
 *	@param	num		t[
 *
 *	@retval	BLACT_ANISTA_LOOP	Đ
 *	@retval	BLACT_ANISTA_END	ĐI
 *
 *
 */
//-----------------------------------------------------------------------------
static int anmFrameChgSys( const BLACT_ANIME_TBL* anm, fx32* frame, fx32 num )
{
	int ret = BLACT_ANISTA_LOOP;
	
	// Aj[Vf[^̃t[Ń[vĐ
	// [v͈͓ɂ邩`FbN
	if( ((anm->start * FX32_ONE) > *frame) || 
		((anm->end * FX32_ONE) < *frame) ){

		// ͈͊OȂ̂ŃAj[ṼX^[gt[ɂ
		*frame = (anm->start * FX32_ONE);
	}else{
		// Aj[Vʂ͈͊OɂȂȂ`FbN
		if( ((anm->end * FX32_ONE) < *frame + num) ){
			
			if(anm->cmd == BLACT_ANIM_LOOP){
				// ͈͊OɂȂ̂ŃX^[gt[ɂ
				*frame = (anm->start * FX32_ONE);
			}else{

				ret = BLACT_ANISTA_END;
				*frame = (anm->end * FX32_ONE);
			}
		}else{
			// ̃`FbNɂȂAj[V
			*frame += num;
		}
	}

	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	`O	eNX`oCh
 *
 *@param	bl_w	oCh郏[N
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DrawTexBind(BLACT_WORK* bl_w)
{
	// eNX`oCh
	reBindTexture(bl_w->pMdlTex, bl_w->pModelSet, &bl_w->texKey, &bl_w->tex4x4Key, &bl_w->plttKey);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	`㏈	eNX`oCh
 *
 *@param	bl_w	oCh郏[N
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DrawTexreBind(BLACT_WORK* bl_w)
{
	NNSG3dTexKey tex4x4key;
	NNSG3dTexKey texkey;
	NNSG3dPlttKey plttkey;
	

	// oChj
	NNS_G3dReleaseMdlSet(bl_w->pModelSet);

	// eNX`VramL[̃N͂
	releaseTexture(bl_w->pMdlTex, &texkey, &tex4x4key, &plttkey);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[X}l[W[烊\[X擾
 *
 *@param	p_head		wb_[	
 *@param	flag		ǂ̃\[X̃tO
 *
 *@return	void*		\[X
 *
 *
 */
//-----------------------------------------------------------------------------
static void* getRes(const BLACT_HEADER* p_head, int flag)
{
	void* ret;

	switch(flag){
	case BLACT_RES_MAN_MDL:
		ret = p_head->ImdRes;
		break;
	
	case BLACT_RES_MAN_TEX:
		ret = (void*)p_head->ItxRes;
		break;
	
	default:
		ret = NULL;
		break;
	}
	
	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Aj[Ve[uwb_擾
 *
 *	@param	p_head	Aj[Ve[u
 *	@param	ofs		ItZbg
 *
 *	@return	Aj[Ve[u
 *
 *
 */
//-----------------------------------------------------------------------------
static const BLACT_ANIME_TBL* getAnmTbl(const BLACT_ANIME_TBL* p_anm, int ofs)
{
	return (p_anm + ofs);
}
