//============================================================================================
/**
 * @file	bounding_box.c
 * @brief	3Df̃JO菈
 * @author	Nozomu Saito
 * @date	2005.10.28
 */
//============================================================================================

#include "bounding_box.h"

#ifdef PM_DEBUG
///#define DRAW_BOUNDING_BOX	//oEfBO{bNX\
#endif //PM_DEBUG


static void SetBoxSize( const fx16 x,
						const fx16 y,
						const fx16 z,
						const fx16 width,
						const fx16 height,
						const fx16 depth,
						GXBoxTestParam *outBox);

static u32 CheckBoundingBox( const GXBoxTestParam	*inBox );
static void CulcFx32toFx16(const fx32 inFx32, fx16 *outFx16, int *outMul);

#ifdef DRAW_BOUNDING_BOX
static void DrawBox( const GXBoxTestParam *inBox );
#endif //DRAW_BOUNDING_BOX

//----------------------------------------------------------------------------
/**
 *
 *@brief	JO`FbN
 *
 *@param	object_p		_[IuWF
 *@param	trans_p			sړl
 *@param	rot_p			]s
 *@param	scale_p			gkl
 *
 *@return	u32			0ȊO̒lł΁A{bNẌꕔ܂͑S̐ϓ
 *						0ł΁A{bNX̑SĂ̐ϊO
 *
 */
//-----------------------------------------------------------------------------
u32	BB_CullingCheck3DModel(	const NNSG3dResMdl* model_p,
							const VecFx32* trans_p,
							const MtxFx33* rot_p,
							const VecFx32* scale_p )
{
	u32 check_ret;		// `FbN̖߂lp
	GXBoxTestParam bounding_box;
	VecFx32 obj_box_trans;
	NNSG3dResMdlInfo*	model_info;		// ff[^{bNXeXgpp[^擾p

	obj_box_trans = *trans_p;
	
	model_info = NNS_G3dGetMdlInfo( model_p );			// f\[XCtHf[^擾

	SetBoxSize( 
			model_info->boxX,
			model_info->boxY,
			model_info->boxZ,
			model_info->boxW,	// 
			model_info->boxH,	// 
			model_info->boxD,	// s
			&bounding_box);

	//
	// WZbg
	//
	// ʒuݒ
	NNS_G3dGlbSetBaseTrans(&obj_box_trans);
	// pxݒ
	NNS_G3dGlbSetBaseRot(rot_p);
	// XP[ݒ
	NNS_G3dGlbSetBaseScale(scale_p);

	NNS_G3dGlbFlush();		//@WIgR}h]

	
	// ̃{bNXeXg̔̒lposScaleł邱Ƃɂ{̒lɂȂ
	NNS_G3dGePushMtx();
	NNS_G3dGeScale( model_info->boxPosScale,
					model_info->boxPosScale,
					model_info->boxPosScale );
	
	//
	// `FbN
	//
	check_ret = CheckBoundingBox(&bounding_box);	// `FbN

#ifdef DRAW_BOUNDING_BOX
	// {bNXeXg̔`@Ń`FbNp̃{bNXǂɕ`悳Ă邩킩܂
	DrawBox(&bounding_box);
#endif //DRAW_BOUNDING_BOX
	
	NNS_G3dGePopMtx(1);

	return check_ret;

}

//----------------------------------------------------------------------------
/**
 *
 *@brief	JO`FbN(\[XgpȂ)
 *
 *@param	trans_p			sړl
 *@param	rot_p			]s
 *@param	scale_p			gkl
 *
 *@return	u32			0ȊO̒lł΁A{bNẌꕔ܂͑S̐ϓ
 *						0ł΁A{bNX̑SĂ̐ϊO
 *
 */
//-----------------------------------------------------------------------------
u32	BB_CullingCheck3DModelNonResource(	const VecFx32* trans_p,
									const fx32 inBoxW,
									const fx32 inBoxH,
									const fx32 inBoxD
									/*const MtxFx33* rot_p*/
									/*const VecFx32* scale_p*/ )
{
	u32 check_ret;		// `FbN̖߂lp
	GXBoxTestParam bounding_box;

	BOUNDING_BOX	box;

	BB_MakeBoundingBox(inBoxW, inBoxH, inBoxD, &box);

	SetBoxSize( 
			0,
			0,
			0,
			box.w,	// 
			box.h,	// 
			box.d,	// s
			&bounding_box);

	//
	// WZbg
	//
	// ʒuݒ
	NNS_G3dGlbSetBaseTrans(trans_p);
	// pxݒ
	///NNS_G3dGlbSetBaseRot(rot_p);
	// XP[ݒ
	///NNS_G3dGlbSetBaseScale(scale_p);
	
	NNS_G3dGlbFlush();		//@WIgR}h]

	// ̃{bNXeXg̔̒lposScaleł邱Ƃɂ{̒lɂȂ
	NNS_G3dGePushMtx();
	NNS_G3dGeScale( box.ScaleW*FX32_ONE,
					box.ScaleH*FX32_ONE,
					box.ScaleD*FX32_ONE );

	check_ret = CheckBoundingBox(&bounding_box);	// `FbN

#ifdef DRAW_BOUNDING_BOX
	// {bNXeXg̔`@Ń`FbNp̃{bNXǂɕ`悳Ă邩킩܂
	DrawBox(&bounding_box);
#endif //DRAW_BOUNDING_BOX

	NNS_G3dGePopMtx(1);
	
	return check_ret;

}

//----------------------------------------------------------------------------
/**
 *
 *@brief	JO`FbN(\[XgpȂ)
 *
 *@param	trans_p			sړl
 *@param	rot_p			]s
 *@param	scale_p			gkl
 *
 *@return	u32			0ȊO̒lł΁A{bNẌꕔ܂͑S̐ϓ
 *						0ł΁A{bNX̑SĂ̐ϊO
 *
 */
//-----------------------------------------------------------------------------
u32	BB_CullingCheck3DModelNonResQuick(	const VecFx32* trans_p,
									const BOUNDING_BOX *inBox
									/*const MtxFx33* rot_p*/
									/*const VecFx32* scale_p*/ )
{
	u32 check_ret;		// `FbN̖߂lp
	GXBoxTestParam bounding_box;

	SetBoxSize( 
			0,
			0,
			0,
			inBox->w,	// 
			inBox->h,	// 
			inBox->d,	// s
			&bounding_box);

	//
	// WZbg
	//
	// ʒuݒ
	NNS_G3dGlbSetBaseTrans(trans_p);
	// pxݒ
	///NNS_G3dGlbSetBaseRot(rot_p);
	// XP[ݒ
	///NNS_G3dGlbSetBaseScale(scale_p);
	
	NNS_G3dGlbFlush();		//@WIgR}h]

	// ̃{bNXeXg̔̒lposScaleł邱Ƃɂ{̒lɂȂ
	NNS_G3dGePushMtx();
	NNS_G3dGeScale( inBox->ScaleW*FX32_ONE,
					inBox->ScaleH*FX32_ONE,
					inBox->ScaleD*FX32_ONE );

	check_ret = CheckBoundingBox(&bounding_box);	// `FbN

#ifdef DRAW_BOUNDING_BOX
	// {bNXeXg̔`@Ń`FbNp̃{bNXǂɕ`悳Ă邩킩܂
	DrawBox(&bounding_box);
#endif //DRAW_BOUNDING_BOX

	NNS_G3dGePopMtx(1);
	
	return check_ret;

}

//----------------------------------------------------------------------------
/**
 *
 *@brief	oEfBO{bNX̍쐬
 *
 *@param	inBoxW			
 *@param	inBoxH			
 *@param	inBoxD			s
 *@param	outBox			쐬oEfBO{bNX̃obt@
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void BB_MakeBoundingBox(const fx32 inBoxW, const fx32 inBoxH, const fx32 inBoxD, BOUNDING_BOX *outBox)
{
	CulcFx32toFx16(inBoxW, &outBox->w, &outBox->ScaleW);
	CulcFx32toFx16(inBoxH, &outBox->h, &outBox->ScaleH);
	CulcFx32toFx16(inBoxD, &outBox->d, &outBox->ScaleD);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	oEfBO{bNXZbg
 *
 *@param	x		XW
 *@param	y		YW
 *@param	z		ZW
 *@param	width	
 *@param	height	
 *@param	depth	s
 *@param	outBox	{bNXeXgpp[^i[AhX
 *
 *@return	Ȃ 
 *
 */
//-----------------------------------------------------------------------------
static void SetBoxSize( const fx16 x,
						const fx16 y,
						const fx16 z,
						const fx16 width,
						const fx16 height,
						const fx16 depth,
						GXBoxTestParam *outBox)
{
	//
	// p[^Zbg
	//
	outBox->x		= x;				// ̂W	
	outBox->y		= y;				// ̂W
	outBox->z		= z;				// ̂W
	outBox->width	= width;			// lp̕
	outBox->height	= height;			// lp̍
	outBox->depth	= depth;			// ̂̉s
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	{bNX`FbN
 *
 *@param	inBox	{bNXeXgpp[^ւ̃|C^
 *
 *@return	u32		0ȊO̒lł΁A{bNẌꕔ܂͑S̐ϓ
 *					0ł΁A{bNX̑SĂ̐ϊO 
 *
 */
//-----------------------------------------------------------------------------
static u32 CheckBoundingBox( const GXBoxTestParam	*inBox )
{
	s32 result = 1;			// 

	// |Sݒs
	NNS_G3dGePolygonAttr(
			GX_LIGHTMASK_0,         
			GX_POLYGONMODE_MODULATE,
			GX_CULL_NONE,           
			0,                      
			0,                      
			GX_POLYGON_ATTR_MISC_FAR_CLIPPING
			| GX_POLYGON_ATTR_MISC_DISP_1DOT
			);

	//|SAgr[gf 
	NNS_G3dGeBegin( GX_BEGIN_TRIANGLES );							
	NNS_G3dGeEnd();	

	//
	// {bNXeXg
	//
	NNS_G3dGeBoxTest( inBox );

	//
	// 
	//
	NNS_G3dGeFlushBuffer();

	//
	// ݒ肳Ă{bNX̐ϓ`FbN
	//
	while ( G3X_GetBoxTestResult(&result) != 0 ) ;

	return result;
}

#ifdef DRAW_BOUNDING_BOX
//----------------------------------------------------------------------------
/**
 *
 *@brief	oEfBO{bNX`
 *
 *@param	inBox	{bNXeXgpp[^ւ̃|C^
 *
 *@return	Ȃ
 *
 */
//-----------------------------------------------------------------------------
static void DrawBox( const GXBoxTestParam *inBox )
{
	//
	// `
	//
	NNS_G3dGePolygonAttr(
			GX_LIGHTMASK_0,				// Cg𔽉fȂ
			GX_POLYGONMODE_MODULATE,	// W[V[h
			GX_CULL_BACK,				// JobNs
			1,							// |Shc
			31,							// At@l
			GX_POLYGON_ATTR_MISC_NONE
			);
	
	// `Jn
	NNS_G3dGeBegin(GX_BEGIN_QUADS);           // _Xg̊Jn
                                        // (lp`|Sł̕`錾)
	{
		NNS_G3dGeNormal(0, 1 << 9, 0);
		NNS_G3dGeColor(GX_RGB(16,16,16));
		NNS_G3dGeVtx(	inBox->x + inBox->width,
						inBox->y + inBox->height,
						inBox->z + inBox->depth);
		NNS_G3dGeVtx(	inBox->x + inBox->width,
						inBox->y + inBox->height,
					    inBox->z );
		NNS_G3dGeVtx(   inBox->x,
						inBox->y + inBox->height,
					    inBox->z );
		NNS_G3dGeVtx(   inBox->x,
						inBox->y + inBox->height,
					    inBox->z + inBox->depth);
		
		NNS_G3dGeNormal(0, -1 << 9, 0);
		NNS_G3dGeVtx(	inBox->x + inBox->width,
						inBox->y,
						inBox->z + inBox->depth);
		NNS_G3dGeVtx(	inBox->x + inBox->width,
						inBox->y,
						inBox->z );
		NNS_G3dGeVtx(	inBox->x,
						inBox->y,
						inBox->z );
		NNS_G3dGeVtx(	inBox->x,
						inBox->y,
						inBox->z + inBox->depth);
		
		NNS_G3dGeNormal(1 << 9, 0, 0);
		NNS_G3dGeVtx(   inBox->x + inBox->width,
						inBox->y,
					    inBox->z);
		NNS_G3dGeVtx(	inBox->x + inBox->width,
						inBox->y,
						inBox->z + inBox->depth);
		NNS_G3dGeVtx(	inBox->x + inBox->width,
						inBox->y + inBox->height,
						inBox->z + inBox->depth);
		NNS_G3dGeVtx(	inBox->x + inBox->width,
						inBox->y + inBox->height,
						inBox->z);
		
		NNS_G3dGeNormal(-1 << 9, 0, 0);
		NNS_G3dGeVtx(	inBox->x,
						inBox->y,
					    inBox->z + inBox->depth);
		NNS_G3dGeVtx(	inBox->x,
						inBox->y,
						inBox->z );
		NNS_G3dGeVtx(   inBox->x,
						inBox->y + inBox->height,
					    inBox->z );
		NNS_G3dGeVtx(   inBox->x,
						inBox->y + inBox->height,
					    inBox->z + inBox->depth);
						
	}
	NNS_G3dGeEnd();                            // _Xg̏I
}
#endif //DRAW_BOUNDING_BOX

//----------------------------------------------------------------------------
/**
 *
 *@brief	fx32fx16ɗƂޏ
 *
 *@param	inFx32		fx32̒l
 *@param	outFx16		Ƃfx16
 *@param	outMul		̒lɖ߂߂̔{
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void CulcFx32toFx16(const fx32 inFx32, fx16 *outFx16, int *outMul)
{
	int i;
	u8 shift_count;
	u32 val32;
	u16 val16;
	shift_count = 0;
	val32 = (u32)inFx32;
	while(0x00007fff<=val32){
		val32 = (val32>>1);
		shift_count++;
	}
	val16 = val32;
	*outFx16 = (fx16)val16;
	(*outMul) = 1;
	for (i=0;i<shift_count;i++){
		(*outMul) *= 2;
	}
}
