//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	@file		char_manager.c
 *	@brief		LN^}l[W[̎ԕ
 *	@author		tomoya takahashi
 *	@data		2004.11.22
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#define __CHAR_MANAGER_H_GLOBAL
#include "char_manager.h"
#include "system.h"
#include "gflib_os_print.h"
#include "assert.h"
#include "vram_transfer_manager.h"
#include <string.h>



//-----------------------------------------------------------------------------
/**
 *					萔錾
 */
//-----------------------------------------------------------------------------
#define		CHAR_VRAM_TRANS_SHIFT	(8)		// Vram[h̃tOɃVtg

#define	CHAR_DATA_ID_NONE	(0xffffffff)

// Vram̈Ǘ萔
#define CHAR_VRAM_BANK_GET_ERR	(0xffffffff)				// TCYȂƂ̖߂l
#define CHAR_ONE_SIZE	(32)		// PLN^TCY


/// tO̐ݒ
enum
{
	CHAR_MAN_NONE,			// Ȃ
	CHAR_MAN_DO_NORMAL,		// NORMAL쒆
	CHAR_MAN_WAIT_VRAM_ORIG,// Vram]̃IWif[^҂
	CHAR_MAN_DO_VRAM_ORIG,	// Vram]̃IWif[^쒆
	CHAR_MAN_DO_VRAM_COPY,	// Vram]Copyf[^쒆
};

// LN^EvZp
enum{
	CHAR_MAN_LIM_SUB,		// ܂؂
	CHAR_MAN_LIM_ADD		// ܂𖄂߂
};
//-----------------------------------------------------------------------------
/**
 *					\̐錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
///	LN^f[^e[u
//
typedef struct
{
	NNSG2dCharacterData*	pCharData;	// LN^f[^\({f[^̕ێ)
	NNS_G2D_VRAM_TYPE		type;		// VramType
										// mainɓo^FNNS_G2D_VRAM_TYPE_2DMAIN = 1
										// subɓo^ FNNS_G2D_VRAM_TYPE_2DSUB = 2
										// ɓo^FNNS_G2D_VRAM_TYPE_2DMAX = 3
	u8			vramType;				// Vram]̃tO	PFVram]
	u32			act_num;				// o^@ID
	NNSG2dImageProxy	ImageProxy;		// C[WvNV
	u32			offset;					// ̃x[XAhX
	u32			sub_offset;				// TũItZbg
	u8			flag;					// gpĂ邩̃tO
	BOOL		mapModeAdjust;			// LN^}bsO[h̏Ԃɍ킹邩
	u32			cont_type;				// VramRg[^Cv
	
	BOOL		have_area;				// VramGAێĂ邩
	u32			have_szByte;			// VrammۃTCYC
	u32			have_szByteSub;			// VrammۃTCYTu
} CHAR_DATA_TBL;



//-------------------------------------
//	
//	LN^}l[W[\
//	
//=====================================
typedef struct {
	CHAR_DATA_TBL*	charDataTbl;	// LN^f[^e[u
	int		charDataNum;			// LN^f[^
	int		charDataNow;			// LN^f[^o^ 
	u32		Offset;					// ǂݍݎ̃ItZbg
	u32		SubOffset;				// TuVram̃ItZbg
	s32		MainObjVramSize;		// CʂVramBank̃TCY
	s32		SubObjVramSize;			// TuʂVramBank̃TCY
	s32		MainVramTransStart;		// CʂVramǗ̈̃X^[gʒu
	s32		SubVramTransStart;		// TuʂVramǗ̈̃X^[gʒu
	u32		TransAreaMainSize;		// CʂVramǗ̈	i1024̓]Ɏgw肵܂j
	u32		TransAreaSubSize;		// CʂVramǗ̈	i1024̓]Ɏgw肵܂j
	u32		MainModeCharLimit;		// Cʂ̃LN^E
	u32		SubModeCharLimit;		// Tuʂ̃LN^E
	u8*		TransAreaFlagMain;		// VramBank̃tOCʗp
	u8*		TransAreaFlagSub;		// VramBank̃tOTuʗp
} CHAR_MANAGER_DATA;


//----------------------------------------------------------------------------
/**
 *					vg^Cv錾
 */
//-----------------------------------------------------------------------------
static void cleanCharData(CHAR_DATA_TBL* data);		// 
static BOOL LoadCharData(const CHAR_MANAGER_HEADER* pEntData, CHAR_DATA_TBL* pCharData);		// LN^f[^ǂݍ
static CHAR_DATA_TBL* getImageProxyTbl(const NNSG2dImageProxy* pImage);
static BOOL TransCharData(CHAR_DATA_TBL* tbl);		// LN^f[^]
static BOOL TransCharOffset(CHAR_DATA_TBL* tbl);	// Offset][h
static BOOL TransCharAreaCont(CHAR_DATA_TBL* tbl);	// areaCont][h

static void setTransChar( CHAR_DATA_TBL* pCharData, u32 p_offset, u32 p_sub_offset );	// ]}l[W[ɃZbg

static BOOL getvramTransOffset(int type, u32* main, u32* sub, u32 szByte, u32* get_size, u32* get_size_sub);
static void setvramTransOffsetProxy(CHAR_DATA_TBL* data, u32 main, u32 sub);
static void setvramTransBitData(int type, u32 main, u32 sub, u32 szByte, u32 szByteSub);

static void transVramChar( void* p_data );				// LN^
static void transVramCharCore( CHAR_DATA_TBL* data, int vram_type);
static void transVramCharVramMode( void* p_data );		// Vram]Aj[h̃LN^
static void transVramCharVramModeCore( CHAR_DATA_TBL* data, int vram_type);
static u32 getTransAreaSize( u8* p_trans_flag );		// Vram]VramǗ̈̃TCY擾p

static CHAR_DATA_TBL* getCharData( void );				// ̃f[^e[u擾
static void setObjVramSize( void );						// VramoÑTCYZbg
static void dellCharData( CHAR_DATA_TBL* pCharData );	// LN^f[^j
static void delCharTblTransArea( CHAR_DATA_TBL* pCharData );	// LN^f[^VramGAJ
static CHAR_DATA_TBL* getCharDataPtr( int id );			// id̃LN^f[^擾
static void MakeTransArea( u32 main_size, u32 sub_size, int heap );		// Vram]pVramGA̍쐬
static void DellTransArea( u8* p_trans_flag );					// Vram]pVramGA̔j
static void TransAreaInit( u8* p_trans_flag );			// Vram]pVramGȀ

static void TransBitSet( u32 num, u32 size, u8* p_trans_flag );	// ]GÃrbgݒ
static u32 TransBitCheck( u32 size, u8* p_trans_flag );	// ]TCỸGAcĂ邩`FbN
static void TransBitClean( u32 start_num, u32 size, u8* p_trans_flag );	// ԋpGA

static int charModeAdjust( CHAR_DATA_TBL* pCharData, int type );


// ]ׂItZbgl擾֐
static BOOL modeNormOffsetGet( u32 szByte, int type, u32* offs_main, u32* offs_sub );
static void modeNormOffsetMove( u32 szByte, int type );

static void byte8_byte1_Get( int num, u32* byte8, u8* byte1 );


static int getCharModeLimNum( int num, int limit, int flag );
static int getCharModeNum( int szByte, int limit );
static int getCharModeNum_byte( int szChar, int limit );

static void getReserveAreaContData( u32 areacont_start, u32 offset, u32 size, int* start_offset, int* set_size );

//----------------------------------------------------------------------------
/**
 *					O[oϐ錾
 */
//-----------------------------------------------------------------------------
static CHAR_MANAGER_DATA*	CharManager = NULL;
// X͂̃f[^O̎A
// e֐̈ɂ̃f[^nē삷悤ɂ
// ͒NɎ΂悢̂킩Ȃ߁AŎ


//
// O[o֐
//
//----------------------------------------------------------------------------
/**
 *
 *@brief	  LN^}l[W[
 *
 *@param	CharMakeData	LN^}l[W[쐬f[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void InitCharManager( const CHAR_MANAGER_MAKE* CharMakeData )
{
	// 
	InitCharManagerReg( CharMakeData, GX_GetOBJVRamModeChar(), GXS_GetOBJVRamModeChar() );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^}l[W
 *
 *	@param	CharMakeData	LN^}l[W쐬f[^
 *	@param	modeMain		LN^}bsO[h@C
 *	@param	modeSub			LN^}bsO[h@Tu
 *
 *	@return	none
 *
 */
//-----------------------------------------------------------------------------
void InitCharManagerReg( const CHAR_MANAGER_MAKE* CharMakeData, GXOBJVRamModeChar modeMain, GXOBJVRamModeChar modeSub )
{
	int i;
	int main_size_cm;
	int sub_size_cm;
	
	if(CharManager == NULL){
		CharManager = sys_AllocMemory(CharMakeData->heap, sizeof(CHAR_MANAGER_DATA));
		MI_CpuClear32(CharManager, sizeof(CHAR_MANAGER_DATA));

		CharManager->charDataNum = CharMakeData->CharDataNum;
		CharManager->charDataTbl = sys_AllocMemory(CharMakeData->heap, sizeof(CHAR_DATA_TBL)*CharManager->charDataNum);


		for(i=0;i<CharMakeData->CharDataNum;i++){
			cleanCharData(CharManager->charDataTbl + i);	
		}

		// LN^E擾
		CharManager->MainModeCharLimit = CharModeMinNum( modeMain );
		CharManager->SubModeCharLimit = CharModeMinNum( modeSub );
		// WX^ɐݒ
		GX_SetOBJVRamModeChar( modeMain );
		GXS_SetOBJVRamModeChar( modeSub );


		// LN^ETCYVramǗ̈쐬
		main_size_cm = getCharModeNum( CharMakeData->VramTransAreaMain,
										CharManager->MainModeCharLimit );
		sub_size_cm = getCharModeNum( CharMakeData->VramTransAreaSub,
										CharManager->SubModeCharLimit );
		MakeTransArea(main_size_cm, sub_size_cm, CharMakeData->heap);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^}l[W[Sɔj܂B
 *
 *@param	none
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void DeleteCharManager(void)
{
	if(CharManager != NULL){
		DellTransArea(CharManager->TransAreaFlagMain);
		DellTransArea(CharManager->TransAreaFlagSub);
		
		DelCharAll();
		sys_FreeMemoryEz(CharManager->charDataTbl);
		sys_FreeMemoryEz(CharManager);
		CharManager = NULL;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	  [hJn֐	(Ǘ̃ItZbg)
 *
 *@param	  start_offsetFǂݍ݊Jnoffset
 *
 *@return	  none
 *
 */
//-----------------------------------------------------------------------------
///C
void CharLoadStart( u32 start_offset )
{
	CharManager->Offset = start_offset;
	setObjVramSize();			// Vram̃TCYZbg
}

/// Tu
void CharLoadStartSub( u32 start_offset )
{
	CharManager->SubOffset = start_offset;
	setObjVramSize();			// Vram̃TCYZbg
}

/// S
void CharLoadStartAll( void )
{
	CharManager->Offset    = 0;
	CharManager->SubOffset = 0;
	TransAreaInit( CharManager->TransAreaFlagMain );
	TransAreaInit( CharManager->TransAreaFlagSub );
	setObjVramSize();			// Vram̃TCYZbg
}

//----------------------------------------------------------------------------
/**
 *	@brief	AreaCont֐p	gp֎~̈ݒ
 *
 *	@param	offset		gp֎~ItZbgʒu
 *	@param	size		gp֎~TCY
 *	@param	disp		
 *
 *	disp
 *		mainɓo^FNNS_G2D_VRAM_TYPE_2DMAIN = 1
 *		subɓo^ FNNS_G2D_VRAM_TYPE_2DSUB = 2
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void SetReserveAreaContCharManager( u32 offset, u32 size, u32 disp )
{
	int start_offset;
	int set_size;
	
	// Ǘrbgݒ
	if( disp == NNS_G2D_VRAM_TYPE_2DMAIN ){
		// offsetǗ̈ȉ̂Ƃ̂ŁAPAĂ
		getReserveAreaContData( 
				CharManager->MainVramTransStart,
				offset, size,
				&start_offset, &set_size );
		
		if( set_size > 0 ){
			setvramTransBitData( NNS_G2D_VRAM_TYPE_2DMAIN, start_offset, 0, set_size, 0 );
		}
	}else{

		// offsetǗ̈ȉ̂Ƃ̂ŁAPAĂ
		getReserveAreaContData( 
				CharManager->SubVramTransStart,
				offset, size,
				&start_offset, &set_size );
		
		if( set_size > 0 ){
			setvramTransBitData( NNS_G2D_VRAM_TYPE_2DSUB, 0, start_offset, 0, set_size );
		}
	}
}


//----------------------------------------------------------------------------
/**
 *
 *@brief		LN^f[^P̂Zbgă[h
 *
 *@param		pChatDataFLN^ENTRYf[^
 *
 *@retval		TRUE FZbgł  
 *@retval		FALSEFZbgłȂ
 *
 */
//-----------------------------------------------------------------------------
BOOL CharSet( const CHAR_MANAGER_HEADER* pCharData )
{
	CHAR_DATA_TBL* tbl;
	u32* p_offset;
	u8 dell_flag = 0;		// jtO
	u32	vram_limit;			// Vram̍őTCY	

	if(CheckCharID(pCharData->id) == TRUE){
		GF_ASSERT(0&&("IDdĂ܂"));
	}

	//
	// LN^f[^e[uɃZbg
	//
	tbl = getCharData();
	if( tbl == NULL ){
		GF_ASSERT(0&&("f[^o^e[uMAXłBo^ł܂B"));
		return FALSE;		// o^s\
	}


	// LN^f[^ǂݍ
	if(LoadCharData(pCharData, tbl) == FALSE){
		return FALSE;
	}

	// Vramɓ]
	if( TransCharData(tbl) == FALSE ){
		DelChar( tbl->act_num );
		return FALSE;
	}

	// o^Abh
	CharManager->charDataNow++;

	return TRUE;
}




//----------------------------------------------------------------------------
/**
 *
 *@brief		LN^f[^𕡐Zbg
 *
 *@param		pChatDataFLN^f[^
 *@param		num			zvf
 *
 *@return		o^
 *
 */
//-----------------------------------------------------------------------------
u16 CharSets( const CHAR_MANAGER_HEADER* pCharData, int num )
{
	int i;	// [vp

	// CHAR_END܂œǂݍ
	for(i=0;i<num;i++){
		// ǂݍ݁Zbg
		if( CharSet( pCharData + i ) == FALSE ){
			// s
			break;
		}
	}

	return i;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief		LN^f[^P̂Zbgă[h
 *				}bsO[h̏ԂɕύX郂[h
 *
 *@param		pChatDataFLN^ENTRYf[^
 *
 *@retval		TRUE FZbgł  
 *@retval		FALSEFZbgłȂ
 *
 */
//-----------------------------------------------------------------------------
BOOL CharSetCharModeAdjust( const CHAR_MANAGER_HEADER* pCharData )
{
	CHAR_DATA_TBL* tbl;
	u32* p_offset;
	u8 dell_flag = 0;		// jtO
	u32	vram_limit;			// Vram̍őTCY	

	if(CheckCharID(pCharData->id) == TRUE){
		GF_ASSERT(0&&("IDdĂ܂"));
	}

	//
	// LN^f[^e[uɃZbg
	//
	tbl = getCharData();
	if( tbl == NULL ){
		GF_ASSERT(0&&("f[^o^e[uMAXłBo^ł܂B"));
		return FALSE;		// o^s\
	}


	// LN^f[^ǂݍ
	if(LoadCharData(pCharData, tbl) == FALSE){
		return FALSE;
	}

	// LN^f[^̃[h̏ԂɕύX
	tbl->mapModeAdjust = TRUE;
	

	// Vramɓ]
	if( TransCharData(tbl) == FALSE ){
		DelChar( tbl->act_num );
		return FALSE;
	}

	// o^Abh
	CharManager->charDataNow++;

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief		LN^f[^𕡐Zbg
 *				}bsO[h̏ԂɕύX郂[h
 *
 *@param		pChatData	LN^f[^z
 *@param		num			zvf
 *
 *@return		o^
 */
//-----------------------------------------------------------------------------
u16 CharSetsCharModeAdjust( const CHAR_MANAGER_HEADER* pCharData, int num )
{
	int i;	// [vp

	// CHAR_END܂œǂݍ
	for(i=0;i<num;i++){
		// ǂݍ݁Zbg
		if( CharSetCharModeAdjust( pCharData + i ) == FALSE ){
			// s
			break;
		}
	}

	return i;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	id̃LN^f[^o^Ă邩`FbN
 *
 *@param	id		`FbNid
 *
 *@retval	TRUE	o^Ă
 *@retval	FALSE	o^ĂȂ
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL CheckCharID(int id)
{
	int i;

	for(i=0;i<CharManager->charDataNum;i++){
		if(CharManager->charDataTbl[i].act_num == id){
			return TRUE;
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ǗIDVramɃLN^f[^]
 *
 *	@param	id				]̃f[^id
 *	@param	pCharData		]LN^f[^
 *
 *	@return	none
 *
 * LN^f[^̃TCYꏏłKv܂
 *
 */
//-----------------------------------------------------------------------------
void CharDataChg( int id, NNSG2dCharacterData* pCharData )
{
	CHAR_DATA_TBL* tbl;	// LN^e[u

	GF_ASSERT( pCharData );
	
	tbl = getCharDataPtr(id);
	GF_ASSERT(tbl);
	tbl->pCharData	= pCharData;

	if( (tbl->type & NNS_G2D_VRAM_TYPE_2DMAIN) ){
		// Vram
		// ]}l[Wœ]
		AddVramTransferManager(
			NNS_GFD_DST_2D_OBJ_CHAR_MAIN,
			tbl->offset,
			pCharData->pRawData,
			pCharData->szByte
			);
	}
	if( tbl->type & NNS_G2D_VRAM_TYPE_2DSUB ){
		// Vram
		// ]}l[Wœ]
		AddVramTransferManager(
			NNS_GFD_DST_2D_OBJ_CHAR_SUB,
			tbl->sub_offset,
			pCharData->pRawData,
			pCharData->szByte
			);
	}

}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Ƃo^ł̂Ԃ
 *
 *@param	none
 *
 *@return	int		co^\
 *
 *
 */
//-----------------------------------------------------------------------------
int CheckCharRest(void)
{
	return CharManager->charDataNum - CharManager->charDataNow;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^f[^j
 *
 *@param	id		LN^id
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void DelChar( int id )
{
	CHAR_DATA_TBL* tbl;		// LN^f[^
	int flag = 1;
	do{
		// LN^f[^̗vf擾
		tbl = getCharDataPtr(id);
		GF_ASSERT(tbl);
	
		// Rs[͔j
		if(tbl->flag == CHAR_MAN_DO_VRAM_COPY){
			DelVramTransData( &tbl->ImageProxy );	
		}else{
			// IWif[^̎jɍs
			flag = 0;
		}
	}while( flag );
	
	// LN^f[^j
	// ғ`FbN
	if( (tbl->flag != CHAR_MAN_NONE) ){
		// j
		dellCharData( tbl );
		CharManager->charDataNow--;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	SLN^f[^j
 *
 *@param	none
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void DelCharAll( void )
{
	int i;

	//
	// SLN^f[^j
	//
	// LN^ID̃e[uT
	for( i = 0; i < CharManager->charDataNum; i++ ){
		// ғ`FbN
		if( CharManager->charDataTbl[ i ].flag != CHAR_MAN_NONE ){
			// f[^j
			dellCharData( &CharManager->charDataTbl[ i ] );
			CharManager->charDataNow--;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ID̃C[WvNV擾
 *
 *@param	id			LN^ID
 *
 *@return	ID̃vNV
 *
 */
//-----------------------------------------------------------------------------
NNSG2dImageProxy* GetCharIDProxy( int id )
{
	CHAR_DATA_TBL* tbl;

	// LN^f[^̗vf擾
	tbl = getCharDataPtr(id);
	GF_ASSERT(tbl);

	// ғłȂNULLԂ
	if( tbl->flag == CHAR_MAN_NONE ){
		return NULL;
	}
	
	return &tbl->ImageProxy;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ID̃LN^f[^擾
 *
 *@param	pImageFC[WvNV|C^
 *
 *@return	LN^f[^
 *
 */
//-----------------------------------------------------------------------------
NNSG2dCharacterData* GetCharIDData( const NNSG2dImageProxy* pImage )
{
	CHAR_DATA_TBL* data;
	
	data = getImageProxyTbl(pImage);

	return data->pCharData;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZVram]Aj[Vp̃LN^vNV擾
 *
 *@param	id			LN^ID
 *@param	szByte		gpTCY
 *
 *@retval	C[WvNV
 *@retval	NULL			IWi͎gpȂ̂ŃRs[쐬Ă
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dImageProxy* GetCharVramTransData( int id, u32 szByte )
{
	u32	offset, offset_sub;		// ItZbg
	CHAR_DATA_TBL* now_tbl;	// o^ς݃e[u
	CHAR_DATA_TBL* pTbl;	// o^e[u
	u32	size_m, size_s;		// ۂɊmۂVramTCY

	// LN^f[^̗vf擾
	now_tbl = getCharDataPtr(id);
	GF_ASSERT(now_tbl);
	
	// ғłȂNULLԂ
	if( now_tbl->flag == CHAR_MAN_NONE ){
		return NULL;
	}
	
	//
	// Vram̃TCY悤ʂVramɂ邩`FbN
	//
	getvramTransOffset(now_tbl->type, &offset, &offset_sub, szByte, &size_m, &size_s);

	// IWif[^gpȂG[Ԃ
	if( now_tbl->flag == CHAR_MAN_DO_VRAM_ORIG ){
		
		return NULL;
		
	}else{
		// IWigȂIWigp
		// tOsɂ
		now_tbl->flag = CHAR_MAN_DO_VRAM_ORIG;
		pTbl = now_tbl;
	}

	// vNVZbg
	setvramTransOffsetProxy(pTbl, offset, offset_sub);

	// VramGAێ
	pTbl->have_area = TRUE;
	pTbl->have_szByte		= size_m;
	pTbl->have_szByteSub	= size_s;

	// ]
	transVramCharVramMode(pTbl);

	//
	// Vram̈tOgpɂ
	//
	setvramTransBitData(pTbl->type, offset, offset_sub, size_m, size_s);

	return &pTbl->ImageProxy;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZVram]Aj[Vp̃LN^vNVRs[Ď擾
 *
 *@param	Orig	IWiC[WvNV
 *
 *@return	Rs[Vram]ItZbg擾C[WvNV
 *@return	NULL	IWigpłȂ\܂B
 */
//-----------------------------------------------------------------------------
NNSG2dImageProxy* GetCharVramTransProxyCopy( const NNSG2dImageProxy* Orig )
{
	CHAR_DATA_TBL* data;
	CHAR_DATA_TBL* copy;
	u32 main, sub;		// ItZbg
	u32	size_m, size_s;	// ۂɊmۂVramTCY
	u32 data_size;
	

	// C[WvNṼe[u擾
	data = getImageProxyTbl(Orig);
	GF_ASSERT(data);
	
	// Rs[擾
	copy = getCharData();
	GF_ASSERT(copy);

	// tO`FbN
	if(data->flag != CHAR_MAN_DO_VRAM_ORIG){
		return NULL;
	}

	// Rs[
	*copy = *data;

	// tORs[ɂ
	copy->flag = CHAR_MAN_DO_VRAM_COPY;

	if( copy->type & NNS_G2D_VRAM_TYPE_2DMAIN ){
		data_size = copy->have_szByte;
	}else{
		data_size = copy->have_szByteSub;
	}
	
	// ItZbg擾
	getvramTransOffset(copy->type, &main, &sub, data_size, &size_m, &size_s);

	// vNVɐݒ
	setvramTransOffsetProxy(copy, main, sub);

	// VramGAێ
	copy->have_area = TRUE;
	copy->have_szByte = size_m;
	copy->have_szByteSub = size_s;
	
	transVramCharVramMode( (void*)copy );

	// Vram̈tOgpɂ
	setvramTransBitData(copy->type, main, sub, size_m, size_s );

	return &copy->ImageProxy;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZVram]AjVram̈J
 *
 *@param	pImageFjLN^̈
 *			C[WvNV
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void DelVramTransData( const NNSG2dImageProxy* pImage )
{
	int i;			// [vp
	
	//
	// vNṼ|C^ƓvNVT
	// 
	for( i = 0; i < CharManager->charDataNum; i++ )
	{
		// ғ`FbN
		if( (CharManager->charDataTbl[ i ].flag == CHAR_MAN_DO_VRAM_ORIG) || 
			(CharManager->charDataTbl[ i ].flag == CHAR_MAN_DO_VRAM_COPY) ){
			// ID`FbN
			if( &CharManager->charDataTbl[ i ].ImageProxy == pImage ){
				break;
			}	
		}
	}

	if( i >= CharManager->charDataNum ){
		return ;
	}

	// VramGẢ
	delCharTblTransArea( CharManager->charDataTbl + i );

	//
	// tO`F
	// IWi`FbN
	if( CharManager->charDataTbl[ i ].flag == CHAR_MAN_DO_VRAM_ORIG ){
		// ҂Ԃɂ
		CharManager->charDataTbl[ i ].flag = CHAR_MAN_WAIT_VRAM_ORIG;
	}else{
		// Copy̎̓f[^ȂԂɂ
		CharManager->charDataTbl[ i ].flag = CHAR_MAN_NONE;
		cleanCharData( &CharManager->charDataTbl[ i ] );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	NNSG2dCharacterDatagpȂƂVramGAmۗp
 *
 *	@param	szByte		LN^f[^TCY
 *	@param	cont_type	VramRg[^Cv
 *	@param	type		o^
 *	@param	allocData	mۃf[^i[
 *
 *	@retval	TRUE	̈mۂł
 *	@retval	FALSE	̈mۂłȂ
 *
 *	cont_type
 *		CHARM_CONT_OFFSET	ItZbg^Cv
 *		CHARM_CONT_AREACONT	GARg[^Cv
 *
 *	type
 *		NNS_G2D_VRAM_TYPE_2DMAIN	CVRAM
 *		NNS_G2D_VRAM_TYPE_2DSUB		TuVRAM
 *
 */
//-----------------------------------------------------------------------------
BOOL CharVramAreaAlloc( int szByte, int cont_type, int type, CHAR_MANAGER_ALLOCDATA* allocData )
{
	u32 offs_m, offs_s;
	u32 size_m, size_s;
	BOOL check;
	
	if( cont_type == CHARM_CONT_OFFSET ){
		
		// ]ł邩`FbN
		check = modeNormOffsetGet( szByte, type, &offs_m, &offs_s );

		if(check){

			// ItZbg炷
			modeNormOffsetMove( szByte, type );

			// mۃf[^쐬
			allocData->type = type;
			allocData->alloc_size	= szByte;
			if( type == NNS_G2D_VRAM_TYPE_2DMAIN ){
				allocData->alloc_ofs	= offs_m;
			}else{
				allocData->alloc_ofs	= offs_s;
			}
		}

	}else{
		
		// ]ł邩`FbN
		check = getvramTransOffset(type, &offs_m, &offs_s, szByte, &size_m, &size_s);
		if(check){

			// Vram̈tOgpɂ
			setvramTransBitData(type, offs_m, offs_s, size_m, size_s);

			// mۃf[^쐬
			allocData->type = type;
			if( type == NNS_G2D_VRAM_TYPE_2DMAIN ){
				allocData->alloc_size	= size_m;
				allocData->alloc_ofs	= offs_m;
			}else{
				allocData->alloc_size	= size_s;
				allocData->alloc_ofs	= offs_s;
			}
		}
	}

	return check;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	NNSG2dCharacterDatagpȂƂVramGAjp
 *			cont_type = CHARM_CONT_AREACONT̂Ƃ悤
 *
 *	@param	allocData	o^f[^
 * 
 *	@return	none
 *
 * ItZbg炵[hŊmۂ͉̂ł܂
 *
 */
//-----------------------------------------------------------------------------
void CharVramAreaFree( CHAR_MANAGER_ALLOCDATA* allocData )
{
	int cm_s;		// LN^EPʂ̃TCY
	int cm_ofs;		// LN^EPʂ̃ItZbg
	
	
	// ZVramAj̗̈J
	if( allocData->type & NNS_G2D_VRAM_TYPE_2DMAIN ){
		cm_s = getCharModeNum( allocData->alloc_size ,CharManager->MainModeCharLimit);
		cm_ofs = getCharModeNum( allocData->alloc_ofs - CharManager->MainVramTransStart, CharManager->MainModeCharLimit );
		TransBitClean( cm_ofs,
				cm_s,
				CharManager->TransAreaFlagMain );

	}
	
	if( allocData->type & NNS_G2D_VRAM_TYPE_2DSUB ){
		cm_s = getCharModeNum( allocData->alloc_size ,CharManager->SubModeCharLimit);
		cm_ofs = getCharModeNum( allocData->alloc_ofs - CharManager->SubVramTransStart, CharManager->SubModeCharLimit );

		TransBitClean( cm_ofs,
				cm_s,
				CharManager->TransAreaFlagSub );
	}

}


//----------------------------------------------------------------------------
/**
 *	@brief	LN^}l[W|C^̎擾
 *
 *	@param	none
 *
 *	@return	LN^}l[W|C^
 */
//-----------------------------------------------------------------------------
void* CharManagerPtrGet( void )
{
	void* buff;
	
	// jς݂̃LN^}l[Wł
	GF_ASSERT( CharManager );

	buff = CharManager;
	CharManager = NULL;
	return buff;
}

//----------------------------------------------------------------------------
/**
 *	@brief	LN^}l[W|C^ݒ
 *
 *	@param	pdata	LN^}l[W|C^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void CharManagerPtrSet( void* pdata )
{
	// ܂jĂȂ̂ɏ㏑悤ƂĂ܂
	GF_ASSERT( CharManager == NULL );

	CharManager = pdata;
}


//
// vCx[g֐
//
//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^f[^
 *
 *@param	data	f[^
 *
 *@return	void
 *
 *
 */
//-----------------------------------------------------------------------------
static void cleanCharData(CHAR_DATA_TBL* data)
{
	data->pCharData		= NULL;
	data->type			= 0;
	data->vramType		= 0;
	data->act_num		= CHAR_DATA_ID_NONE;
	data->offset		= 0;
	data->sub_offset	= 0;
	data->flag			= 0;
	data->mapModeAdjust = 0;
	NNS_G2dInitImageProxy( &data->ImageProxy );
	
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^f[^ǂݍ
 *
 *@param	pEntData		ENTRYf[^
 *@param	pCharData		LN^f[^ǂݍ݃e[u
 *
 *@return	BOOL	FTRUE	sFFALSE	(pXĂȂ@̓Ȃ)
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL LoadCharData(const CHAR_MANAGER_HEADER* pEntData, CHAR_DATA_TBL* pCharData)
{
	// f[^ݒ
	pCharData->pCharData = pEntData->res_file;
	
	// IDݒ
	pCharData->act_num = pEntData->id;
	
	// e[uZbg
	pCharData->type		= pEntData->type;	// VramTypeZbg
	pCharData->vramType	= pCharData->pCharData->characterFmt >> CHAR_VRAM_TRANS_SHIFT;

	// Rg[^Cvݒ
	pCharData->cont_type = pEntData->cont_type;

	// VramǗf[^
	pCharData->have_area = FALSE;
	pCharData->have_szByte		= 0;
	pCharData->have_szByteSub	= 0;

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	C[WvNVƓe[uT
 *
 *@param	pImage		Te[ũC[WvNV
 *
 *@return	CHAR_DATA_TBL*	e[u
 *
 *
 */
//-----------------------------------------------------------------------------
static CHAR_DATA_TBL* getImageProxyTbl(const NNSG2dImageProxy* pImage)
{
	int i;			// [vp

	//
	// vNṼ|C^ƓvNVT̃LN^f[^Ԃ
	// 
	for( i = 0; i < CharManager->charDataNum; i++ ){
		// ғ`FbN
		if( CharManager->charDataTbl[ i ].flag != CHAR_MAN_NONE ){
			// ID`FbN
			if( &CharManager->charDataTbl[ i ].ImageProxy == pImage ){
				break;
			}	
		}
	}

	if( i >= CharManager->charDataNum ){
		return NULL;
	}

	return (CharManager->charDataTbl + i);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^f[^]
 *
 *@param	pCharData	Gg[f[^
 *@param	tbl			LN^f[^
 *
 *@return	BOOL	FTRUE	sFFALSE	iVramTCYȂj
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL TransCharData(CHAR_DATA_TBL* tbl)
{
	BOOL dell_flag = TRUE;	// VramɓȂƂFALSEɂȂ
	
	// Vram]`FbN
	if( tbl->vramType ){
		tbl->flag = CHAR_MAN_WAIT_VRAM_ORIG;// Vram]ҋ@
	}else{
		tbl->flag = CHAR_MAN_DO_NORMAL;		// ʏgp

		if(tbl->cont_type == CHARM_CONT_OFFSET){
			// ItZbg炵[h
			dell_flag = TransCharOffset( tbl );
		}else{
			// GARg[[h
			dell_flag = TransCharAreaCont( tbl );
		}
	}

	return dell_flag;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Ǘ^CvItZbgœ]
 *
 *	@param	tbl		e[u
 *
 *	@retval	TRUE	]
 *	@retval	FALSE	]s
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL TransCharOffset(CHAR_DATA_TBL* tbl)
{
	BOOL dell_flag = TRUE;	// VramɓȂƂFALSEɂȂ
	u32 offs_m, offs_s;		// CTuItZbg

	// ItZbg擾
	dell_flag = modeNormOffsetGet( tbl->pCharData->szByte, tbl->type, &offs_m, &offs_s );
	
	if( dell_flag ){
		
		// ]
		setTransChar( tbl, offs_m, offs_s );
		
		// ItZbgړ
		modeNormOffsetMove( tbl->pCharData->szByte, tbl->type );
	}

	return dell_flag;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Ǘ^CvGARg[œ]
 *
 *	@param	tbl		LN^e[u
 *
 *	@retval	TRUE	]
 *	@retval	FALSE	]s
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL TransCharAreaCont(CHAR_DATA_TBL* tbl)
{
	u32	offset, offset_sub;		// ItZbg
	u32 size_m, size_s;			// ۂɊmۂVramTCY
	BOOL check;

	//
	// Vram̃TCY悤ʂVramɂ邩`FbN
	//
	check = getvramTransOffset(tbl->type, &offset, &offset_sub, tbl->pCharData->szByte, &size_m, &size_s);
	// ̈mێs
	if( check == FALSE ){
		return FALSE;
	}

	// ItZbgZbg
	setvramTransOffsetProxy(tbl, offset, offset_sub);

	// VramGAێ
	tbl->have_area = TRUE;
	tbl->have_szByte = size_m;
	tbl->have_szByteSub = size_s;

	// ]
	transVramChar(tbl);

	// Vram̈tOgpɂ
	setvramTransBitData(tbl->type, offset, offset_sub, size_m, size_s);

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^f[^j
 *
 *@param	pCharDataFLN^f[^
 *
 *@return	 none
 *
 */
//-----------------------------------------------------------------------------
static void dellCharData( CHAR_DATA_TBL* pCharData )
{
	// VramGAێĂƂ͕Ԃ
	if(pCharData->have_area){		
		delCharTblTransArea( pCharData );	
	}
	
	// f[^j
	cleanCharData(pCharData);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	̃pX̃LN^f[^̗vf擾
 *
 *@param	id		LN^f[^id
 *
 *@return	CHAR_DATA_TBL* LN^f[^e[u
 *
 */
//-----------------------------------------------------------------------------
static CHAR_DATA_TBL* getCharDataPtr( int id )
{
	int	i;		// [vp
	
	// ID̃f[^ăvNVԂ
	for( i = 0; i < CharManager->charDataNum; i++ ){
		// ID`FbN
		if( CharManager->charDataTbl[i].act_num == id ){
			return &CharManager->charDataTbl[i];
		}	
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^[h킹
 *
 *	@param	pCharData	LN^f[^
 *	@param	type		Vram^Cv
 *
 *	@return	int		}bsO[h
 *
 *
 */
//-----------------------------------------------------------------------------
static int charModeAdjust( CHAR_DATA_TBL* pCharData, int type )
{
	if(type == NNS_G2D_VRAM_TYPE_2DMAIN){
		pCharData->pCharData->mapingType = GX_GetOBJVRamModeChar();
	}else{
		pCharData->pCharData->mapingType = GXS_GetOBJVRamModeChar();
	}

	return pCharData->pCharData->mapingType;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^f[^]VuN^XNɃZbg
 *
 *@param	pCharDataFLN^f[^
 *@param	p_offsetFItZbgl
 *@param	p_sub_offsetFTuʂ̃ItZbgl
	*
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void setTransChar( CHAR_DATA_TBL* pCharData, u32 p_offset, u32 p_sub_offset )
{
	//
	// offsetlZbgăTCY炷
	//
	pCharData->offset		= p_offset;
	pCharData->sub_offset	= p_sub_offset;

	// 炷
	// Vram]`FbN
	if( !pCharData->vramType )
	{
		// Vram]
		transVramChar((void*)pCharData);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Vramɓ]]ItZbg擾
 *
 *@param	type		\
 *@param	main		CItZbgi[
 *@param	sub			TuItZbgi[
 *@param	szByte		TCY
 *@param	get_size	CۂɊmۂTCY
 *@param	get_size_subTuۂɊmۂTCY
 *
 *@retval	TRUE	̈mې
 *@retval	FALSE	̈mێs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL getvramTransOffset(int type, u32* main, u32* sub, u32 szByte, u32* get_size, u32* get_size_sub)
{
	u32 size_cm;
	
	
	if( type & NNS_G2D_VRAM_TYPE_2DMAIN ){
		// TCYLN^ETCYŊ؂lɂ
		*get_size = getCharModeLimNum( szByte, CharManager->MainModeCharLimit, CHAR_MAN_LIM_ADD );
		
		
		// LN^ETCY̒Pʂɂ
		size_cm = getCharModeNum( *get_size, CharManager->MainModeCharLimit );	

		// Cʑ
		*main = TransBitCheck( size_cm, CharManager->TransAreaFlagMain );
		
		// G[AĂ
		if( *main == CHAR_VRAM_BANK_GET_ERR ){
			GF_ASSERT(0&&("Vram]Z̗̈擾I[o["));
			return FALSE;
		}

		// ItZbglLN^ETCYoCgTCYɕύX
		*main = getCharModeNum_byte( *main, CharManager->MainModeCharLimit );
	}

	if( type & NNS_G2D_VRAM_TYPE_2DSUB ){
		// TCYLN^ETCYŊ؂lɂ
		*get_size_sub = getCharModeLimNum( szByte, CharManager->SubModeCharLimit, CHAR_MAN_LIM_ADD );
		
		// LN^ETCY̒Pʂɂ
		size_cm = getCharModeNum( *get_size_sub, CharManager->SubModeCharLimit );	
		
		// Tuʑ
		*sub = TransBitCheck( size_cm, CharManager->TransAreaFlagSub );

		// G[AĂ
		if( *sub == CHAR_VRAM_BANK_GET_ERR ){
			GF_ASSERT(0&&("Vram]Z̗̈擾I[o["));
			return FALSE;
		}

		// ItZbglLN^ETCYoCgTCYɕύX
		*sub = getCharModeNum_byte( *sub, CharManager->SubModeCharLimit );
	}

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	vNVVram]pItZbgݒ
 *
 *@param	data	LN^f[^e[u
 *@param	main	CItZbg
 *@param	sub		TuItZbg
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setvramTransOffsetProxy(CHAR_DATA_TBL* data, u32 main, u32 sub)
{
	if( data->type & NNS_G2D_VRAM_TYPE_2DMAIN ){		// Cʕ\̎
		data->offset = main + CharManager->MainVramTransStart;
	}
	if( data->type & NNS_G2D_VRAM_TYPE_2DSUB ){			// Tuʕ\̎
		data->sub_offset = sub + CharManager->SubVramTransStart;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	vNVVram]pItZbgݒ
 *
 *@param	type	ʃ^Cv
 *@param	main	CItZbg
 *@param	sub		TuItZbg
 *@param	szByte		CTCY
 *@param	szByteSub	TuTCY
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setvramTransBitData(int type, u32 main, u32 sub, u32 szByte, u32 szByteSub)
{
	int size_cm;
	int offs_cm;
	
	
	if( type & NNS_G2D_VRAM_TYPE_2DMAIN ){		// Cʕ\̎
		size_cm = getCharModeNum( szByte, CharManager->MainModeCharLimit );	
		offs_cm = getCharModeNum( main, CharManager->MainModeCharLimit );	
		TransBitSet( offs_cm, size_cm, CharManager->TransAreaFlagMain );

	}
	if( type & NNS_G2D_VRAM_TYPE_2DSUB ){			// Tuʕ\̎
		size_cm = getCharModeNum( szByteSub, CharManager->SubModeCharLimit );	
		offs_cm = getCharModeNum( sub, CharManager->SubModeCharLimit );	
		TransBitSet( offs_cm, size_cm, CharManager->TransAreaFlagSub );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VblankōsLN^f[^Vramւ̓]
 *
 *@param	p_dataF]LN^f[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void transVramChar( void* p_data )
{
	CHAR_DATA_TBL* p_char_data = (CHAR_DATA_TBL*)p_data;		// LXgăf[^擾
	int mapping_mode;		// }bsO[h

	// vNV̏
	NNS_G2dInitImageProxy(&p_char_data->ImageProxy);
	
	//
	// Vram֓ǂݍ
	//
	if( p_char_data->type != NNS_G2D_VRAM_TYPE_MAX )
	{
		
		transVramCharCore( p_char_data, p_char_data->type);
	}
	else
	{
		// ɓo^
		transVramCharCore( p_char_data, NNS_G2D_VRAM_TYPE_2DMAIN);
		
		transVramCharCore( p_char_data, NNS_G2D_VRAM_TYPE_2DSUB);
		
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	]RA֐
 *
 *	@param	data			LN^f[^
 *	@param	vram_type		Vram^Cv
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void transVramCharCore( CHAR_DATA_TBL* data, int vram_type)
{
	int mapping_mode;
	int offset;
	u32 before_mapping;
	
	if(data->mapModeAdjust){
		mapping_mode = charModeAdjust( data, vram_type );
	}else{
		mapping_mode = vram_type;
	}

	if(vram_type == NNS_G2D_VRAM_TYPE_2DMAIN){
		offset = data->offset;
		before_mapping = GX_GetOBJVRamModeChar();
	}else{
		offset = data->sub_offset;
		before_mapping = GXS_GetOBJVRamModeChar();
	}
	
	if(mapping_mode == GX_OBJVRAMMODE_CHAR_2D){
		NNS_G2dLoadImage2DMapping( 
				data->pCharData,		// LN^f[^
				offset,					// LN^x[XAhX
				vram_type,					// VramType
				&data->ImageProxy );	// C[WvNV
	}else{
		NNS_G2dLoadImage1DMapping( 
				data->pCharData,		// LN^f[^
				offset,					// LN^x[XAhX
				vram_type,					// VramType
				&data->ImageProxy );	// C[WvNV
		
	}

	if(vram_type == NNS_G2D_VRAM_TYPE_2DMAIN){
		if(GX_GetOBJVRamModeChar() != before_mapping){
			OS_Printf("L]ɂOBJ}bsO[hύX܂\n");
		}
	}
	else{
		if(GXS_GetOBJVRamModeChar() != before_mapping){
			OS_Printf("L]ɂOBJ}bsO[hύX܂\n");
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VblankōsLN^f[^Vramւ̓]
 *						Vram]Aj[h̃LN^
 *
 *@param	p_dataF]LN^f[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void transVramCharVramMode( void* p_data )
{
	CHAR_DATA_TBL* p_char_data = (CHAR_DATA_TBL*)p_data;		// LXgăf[^擾

	// vNV̏
	NNS_G2dInitImageProxy(&p_char_data->ImageProxy);
	
	//
	// Vram֓ǂݍ
	//
	if( p_char_data->type != NNS_G2D_VRAM_TYPE_MAX )
	{
		transVramCharVramModeCore( p_char_data, p_char_data->type );
	}
	else
	{
		// ɓo^
		transVramCharVramModeCore( p_char_data, NNS_G2D_VRAM_TYPE_2DMAIN );
		transVramCharVramModeCore( p_char_data, NNS_G2D_VRAM_TYPE_2DSUB );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	VRAM]Core
 */
//-----------------------------------------------------------------------------
static void transVramCharVramModeCore( CHAR_DATA_TBL* data, int vram_type)
{
	int mapping_mode;
	int offset;
	u32 before_mapping;
	
	if(data->mapModeAdjust){
		mapping_mode = charModeAdjust( data, vram_type );
	}else{
		mapping_mode = vram_type;
	}

	if(vram_type == NNS_G2D_VRAM_TYPE_2DMAIN){
		offset = data->offset;
		before_mapping = GX_GetOBJVRamModeChar();
	}else{
		offset = data->sub_offset;
		before_mapping = GXS_GetOBJVRamModeChar();
	}
	
	NNS_G2dLoadImageVramTransfer( 
			data->pCharData,		// LN^f[^
			offset,					// LN^x[XAhX
			vram_type,				// VramType
			&data->ImageProxy );	// C[WvNV

	if(vram_type == NNS_G2D_VRAM_TYPE_2DMAIN){
		if(GX_GetOBJVRamModeChar() != before_mapping){
			OS_Printf("L]ɂOBJ}bsO[hύX܂\n");
		}
	}
	else{
		if(GXS_GetOBJVRamModeChar() != before_mapping){
			OS_Printf("L]ɂOBJ}bsO[hύX܂\n");
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	̃f[^e[u擾
 *
 *@param	none
 *	
 *@return	CHAR_DATA_TBL* ^F̃e[u	NULL̎͂̃e[uȂ
 *
 */
//-----------------------------------------------------------------------------
static CHAR_DATA_TBL* getCharData( void )
{
	int i;		// [vp
	
	//
	// ̃f[^e[u擾
	//
	for( i = 0; i < CharManager->charDataNum; i++ ){
		// ĂƂT[`
		if( CharManager->charDataTbl[ i ].flag == CHAR_MAN_NONE ){
			return &CharManager->charDataTbl[ i ];
		}
	}

	return NULL;		// o^s\
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	  IuWFVramTCYZbg
 *
 *@param	 none
 *
 *@return	 none
 *
 */
//-----------------------------------------------------------------------------
static void setObjVramSize( void )
{
	GXVRamOBJ vram_bank;			// VramoN擾p
	GXVRamSubOBJ sub_vram_bank;		// TuʂVramoN擾p
	int vram_cont_area_size;
	
	//
	// VramoN̏Ԃ擾
	// VramTCYZbg
	//
	// C
	vram_bank = GX_GetBankForOBJ();
	switch( vram_bank ){
	case GX_VRAM_OBJ_NONE:		// Ȃ
		CharManager->MainObjVramSize = 0;
		break;

	case GX_VRAM_OBJ_16_F:		// 16KByte
	case GX_VRAM_OBJ_16_G:
		CharManager->MainObjVramSize = 16 * 1024;
		break;

	case GX_VRAM_OBJ_32_FG:		// 32KByte
		CharManager->MainObjVramSize = 32 * 1024;
		break;

	case GX_VRAM_OBJ_64_E:		// 64KByte
		CharManager->MainObjVramSize = 64 * 1024;
		break;

	case GX_VRAM_OBJ_80_EF:		// 80KByte
	case GX_VRAM_OBJ_80_EG:
		CharManager->MainObjVramSize = 80 * 1024;
		break;

	case GX_VRAM_OBJ_96_EFG:	// 96KByte
		CharManager->MainObjVramSize = 96 * 1024;
		break;

	case GX_VRAM_OBJ_128_A:		// 128KByte
	case GX_VRAM_OBJ_128_B:
		CharManager->MainObjVramSize = 128 * 1024;	
		break;

	case GX_VRAM_OBJ_256_AB:	// 256KByte
		CharManager->MainObjVramSize = 256 * 1024;
		break;

	default:
		CharManager->MainObjVramSize = 0;
		break;
	}
	
	// Tu
	sub_vram_bank = GX_GetBankForSubOBJ();
	switch( sub_vram_bank ){
	case GX_VRAM_SUB_OBJ_NONE:		// Ȃ
		CharManager->SubObjVramSize = 0;
		break;

	case GX_VRAM_SUB_OBJ_16_I:		// 16KByte
		CharManager->SubObjVramSize = 16 * 1024;
		break;

	case GX_VRAM_SUB_OBJ_128_D:		// 128KByte
		CharManager->SubObjVramSize = 128 * 1024;	
		break;

	default:
		CharManager->SubObjVramSize = 0;
		break;
	}

	//
	// Vram]pǗ̈X^[gʒu 
	//
	vram_cont_area_size = getCharModeNum_byte( CharManager->TransAreaMainSize, CharManager->MainModeCharLimit );
	CharManager->MainVramTransStart = CharManager->MainObjVramSize - vram_cont_area_size;
	
	vram_cont_area_size = getCharModeNum_byte( CharManager->TransAreaSubSize, CharManager->SubModeCharLimit );
	CharManager->SubVramTransStart = CharManager->SubObjVramSize - vram_cont_area_size;

	//
	// Vram]pǗ̈X^[gʒuOɂȂG[vg
	//
	GF_ASSERT_MSG( ((CharManager->MainVramTransStart >= 0)&&(CharManager->SubVramTransStart >= 0)),
				"warningFVram]pZVram̈Ǘ̈̃TCYAVramoN̊蓖ĂȂłB\n" );
	GF_ASSERT_MSG( ((CharManager->MainVramTransStart >= 0)&&(CharManager->SubVramTransStart >= 0)),
				"warningFVram]pZVram̈̓C[byte] Tu[byte]łB\n" );
}

//
// Vram̈Ǘp
//
// ̊Ǘ̈"InitCharManager()֐"ɓnAVramp̈TCYmۂ܂B
//@zuʒu"CharManager->MainVramTransStart""CharManager->SubVramTransStart"
//	"CharManager->TransAreaMainSize","CharManager->TransAreaSubSize"łB
//
//----------------------------------------------------------------------------
/**
 *
 *@brief	CATu̗Ǘ̈
 *
 *@param	none
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void TransAreaInitAll( void )
{
	TransAreaInit( CharManager->TransAreaFlagMain );
	TransAreaInit( CharManager->TransAreaFlagSub );
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	  Vram]ZpVramǗ̈쐬
 *
 *@param	main_sizeFCʑ̃TCY(LN^ETCY)
 *@param	sub_sizeFTuʑ̃TCY(LN^ETCY)
 *@param	main_limit	CʃLN^E
 *@param	sub_limit	TuʃLN^E
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void MakeTransArea( u32 main_size, u32 sub_size, int heap )
{
	//
	// TCYϐɊi[AǗ̈Ď擾
	//
	CharManager->TransAreaMainSize = main_size;
	CharManager->TransAreaSubSize = sub_size;

	// ̈
	if(CharManager->TransAreaFlagMain != NULL){
		sys_FreeMemoryEz( CharManager->TransAreaFlagMain );
	}
	if(CharManager->TransAreaFlagSub != NULL){
		sys_FreeMemoryEz( CharManager->TransAreaFlagSub );
	}

	// ̈m
	if(CharManager->TransAreaMainSize != 0){
		CharManager->TransAreaFlagMain = sys_AllocMemory( heap, sizeof(u8) * (main_size / 8) );
	}
	if(CharManager->TransAreaSubSize != 0){
		CharManager->TransAreaFlagSub = sys_AllocMemory( heap, sizeof(u8) * (sub_size / 8) );
	}

	// ̈
	TransAreaInitAll();
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	  Vram]ZpVramǗ̈j
 *
 *@param	p_trans_flagFCʂTuʂ̃tO
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void DellTransArea( u8* p_trans_flag )
{	
	// NULL `FbN
	if(p_trans_flag != NULL){
		//
		// CʃTuʂǂ`FbN
		//
		if( p_trans_flag == CharManager->TransAreaFlagMain ){
			CharManager->TransAreaMainSize = 0;

			// j
			sys_FreeMemoryEz( p_trans_flag );	
		}else{
			CharManager->TransAreaSubSize = 0;

			// j
			sys_FreeMemoryEz( p_trans_flag );
		}

		p_trans_flag = NULL;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	CATu̗Ǘ̈̃TCY擾
 *
 *@param	p_trans_flagFCTũtO
 *
 *@return	LN^TCY
 *
 * 
 */
//-----------------------------------------------------------------------------
static u32 getTransAreaSize( u8* p_trans_flag )
{
	//
	// CʂTuʂ`FbN
	//
	if( p_trans_flag == CharManager->TransAreaFlagMain ){
		return 	CharManager->TransAreaMainSize;
	}
	
	return CharManager->TransAreaSubSize;
}



//----------------------------------------------------------------------------
/**
 *
 *@brief	]GÃtȌ
 *
 *@param	p_trans_flagFCTũtO
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void TransAreaInit( u8* p_trans_flag )
{
	int i;					// [vp
	u32	char_vram_max;		// ̈ő吔Zbgp

	// NULL`FbN
	if( p_trans_flag != NULL ){
	
		// TCY擾
		char_vram_max = getTransAreaSize( p_trans_flag );

		
		//
		// ̈̏
		memset( p_trans_flag, 0, sizeof(u8) * (char_vram_max / 8) );
/*		for( i = 0; i < char_vram_max / 8; i++ )
		{
			p_trans_flag[ i ] = 0;
		}//*/
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	oCgw肵ĎgpZbg
 *
 *@param	num		JnoCg
 *@param	size	gpTCY		PʁiLN^ETCYj
 *@param	p_trans_flagFCTũtO
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void TransBitSet( u32 num, u32 size, u8* p_trans_flag )
{
	int i;			// [vp
	u32	char_vram_max;		// ̈ő吔Zbgp


	
	// NULL `FbN
	if(p_trans_flag != NULL){
		
		// TCY擾
		char_vram_max = getTransAreaSize( p_trans_flag );
		
		//
		// ]tOɂPZbgĂ
		//
		for( i = num; i < num + size; i++ )
		{
			u32 byte8;
			u8 byte1, mask;
			
			// I[o[甲
			if( i >= char_vram_max )
			{
				break;
			}
				
			// Zbg
			byte8_byte1_Get( i, &byte8, &byte1 );

			// 炽Ƃ낪łɂĂ
			GF_ASSERT( (p_trans_flag[ byte8 ] & (1 << byte1)) == 0 );

			mask = (1 << byte1);
			p_trans_flag[ byte8 ] |= mask;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	TCŸ̗悪JĂ邩`FbN
 *
 *@param	sizeFTCY	PʁiLN^ETCYj
 *@param	p_trans_flag	CTũtO
 *
 *@return	ItZbg	PʁiLN^ETCYj
 *				߂ȂƂ0xffffffff(CHAR_VRAM_BANK_GET_ERR)
 *
 */
//-----------------------------------------------------------------------------
static u32 TransBitCheck( u32 size, u8* p_trans_flag )
{
	int i, j;			// [vp
	u32	char_vram_max;		// ̈ő吔Zbgp
	
	// NULL `FbN
	if(p_trans_flag != NULL){

		// TCY擾
		char_vram_max = getTransAreaSize( p_trans_flag );
		
		// ]TCYĂ邩`FbN
		for( i = 0; i < char_vram_max; i++ )
		{
			u32 byte8;
			u8 byte1, mask;
			// Ă邩`FbN
			byte8_byte1_Get( i, &byte8, &byte1 );
			mask = (1 << byte1);

			// `FbN
			j = 0;
			while( ((p_trans_flag[ byte8 ] & mask) == 0) && (j <= size) ){
				int num = i + j;
				byte8_byte1_Get( num, &byte8, &byte1 );
				mask = (1 << byte1);

				// numchar_vram_maxȏȂ甲
				if( num >= char_vram_max ){
					return CHAR_VRAM_BANK_GET_ERR;
				}
				
				j++;
			}

			// sizeɂȂ甲
			if( j > size ){
				return i;
			}

			i += j;
		}
	}
	return CHAR_VRAM_BANK_GET_ERR;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	w肳ꂽ]GÃtȌ
 *
 *@param	start_num		JnoCg	PʁiLN^ETCYj
 *@param	size			TCY		PʁiLN^ETCYj
 *@param	limit			LN^E
 *@param	p_trans_flag	CTũtO
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void TransBitClean( u32 start_num, u32 size, u8* p_trans_flag )
{
	int i;			// [vp


	// NULL `FbN
	if(p_trans_flag != NULL){
		// ̈̏
		for( i = start_num; i < start_num + size; i++ )
		{
			u32 byte8;
			u8 byte1, mask;
			
			// 
			byte8_byte1_Get( i, &byte8, &byte1 );

			// Ƃ낪łɏĂ
			GF_ASSERT( (p_trans_flag[ byte8 ] & (1 << byte1)) );

			mask = (1 << byte1) ^ 0xff;
			p_trans_flag[ byte8 ] &= mask;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^e[u̓]GAJ
 *
 *	@param	pCharData	LN^f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void delCharTblTransArea( CHAR_DATA_TBL* pCharData )
{
	u32	offs_cm;
	u32 size_cm;
	
	//
	// ZVramAj̗̈J
	//
	if( pCharData->type & NNS_G2D_VRAM_TYPE_2DMAIN ){
		offs_cm = getCharModeNum( NNS_G2dGetImageLocation(&pCharData->ImageProxy,NNS_G2D_VRAM_TYPE_2DMAIN ) - CharManager->MainVramTransStart, CharManager->MainModeCharLimit );
		size_cm = getCharModeNum( pCharData->have_szByte, CharManager->MainModeCharLimit  );
		TransBitClean( offs_cm,
				size_cm,
				CharManager->TransAreaFlagMain );

	}
	
	if( pCharData->type & NNS_G2D_VRAM_TYPE_2DSUB ){
		offs_cm = getCharModeNum( NNS_G2dGetImageLocation(&pCharData->ImageProxy,NNS_G2D_VRAM_TYPE_2DSUB ) - CharManager->SubVramTransStart, CharManager->SubModeCharLimit );
		size_cm = getCharModeNum( pCharData->have_szByteSub, CharManager->SubModeCharLimit );
		TransBitClean( offs_cm,
				size_cm,
				CharManager->TransAreaFlagSub );
	}
	pCharData->have_area = FALSE;	// VramGÂ
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^[h牽L]ׂ擾
 *
 *	@param	mode		LN^[h
 *
 *	@return	int			]ׂLN^
 *
 *
 */
//-----------------------------------------------------------------------------
int CharModeMinNum( int mode )
{
	int char_num;
	
	switch(mode){
	case GX_OBJVRAMMODE_CHAR_1D_32K:
		char_num = 1;
		break;
	case GX_OBJVRAMMODE_CHAR_1D_64K:
		char_num = 2;
		break;
	case GX_OBJVRAMMODE_CHAR_1D_128K:
		char_num = 4;
		break;
	case GX_OBJVRAMMODE_CHAR_1D_256K:
		char_num = 8;
		break;
	default:
		char_num = 1;
		break;
	}

	return char_num;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	~bg̒lɂ킹
 *
 *	@param	num		~bgɂ킹l
 *	@param	limit	~bg
 *	@param	flag	؂肩߂邩̃tO
 *
 *	@return	int		~bgɂ킹l
 *
 *flag
 *	CHAR_MAN_LIM_SUB,		// ܂؂
 *	CHAR_MAN_LIM_ADD		// ܂𖄂߂
 *
 */
//-----------------------------------------------------------------------------
static int getCharModeLimNum( int num, int limit, int flag )
{
	if( num % limit ){
		num -= (num % limit);
		if( flag == CHAR_MAN_LIM_ADD ){
			num += limit;
		}
	}

	return num;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^Eł̃TCY擾
 *
 *	@param	szByte	oCgTCY
 *	@param	limit	LN^E
 *
 *	@return	int		LN^Eł̃TCY
 *
 *
 */
//-----------------------------------------------------------------------------
static int getCharModeNum( int szByte, int limit )
{
	szByte /= CHAR_ONE_SIZE;
	szByte /= limit;
	
	return szByte; 
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^ETCYoCgTCYɕύX
 *
 *	@param	szChar	LN^ETCY̒l
 *	@param	limit	LN^E
 *
 *	@return	int		oCgTCY
 *
 *
 */
//-----------------------------------------------------------------------------
static int getCharModeNum_byte( int szChar, int limit )
{
	szChar *= limit;
	szChar *= CHAR_ONE_SIZE;
	return szChar; 
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	m[}Rg[^Cv̍]ׂItZbgl擾
 *
 *	@param	szByte		]f[^TCY
 *	@param	type		]
 *	@param	offs_main	C]i[
 *	@param	offs_sub	Tu]i[
 *
 *	@retval	TRUE	]̈悪
 *	@retval	FALSE	̈Ȃ	offs_main offs_sub̒l
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL modeNormOffsetGet( u32 szByte, int type, u32* offs_main, u32* offs_sub )
{
	BOOL ret = TRUE;
	
	// CʂTuʂ`FbN
	if( type & NNS_G2D_VRAM_TYPE_2DMAIN ){
		// Vram~bg`FbN
		if( (CharManager->Offset + szByte) > CharManager->MainVramTransStart ){
			GF_ASSERT(0);
			ret = FALSE;
		}else{

			*offs_main = CharManager->Offset;
		}
	}
	if( type & NNS_G2D_VRAM_TYPE_2DSUB ){
		// Vram~bg`FbN
		if( (CharManager->SubOffset + szByte) > CharManager->SubVramTransStart ){
			GF_ASSERT(0);
			ret = FALSE;
		}else{

			*offs_sub = CharManager->SubOffset;
		}
	}

	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	O[õItZbgTCY炷
 *
 *	@param	szByte		oCgTCY
 *	@param	type		\
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void modeNormOffsetMove( u32 szByte, int type )
{
	// CʂTuʂ`FbN
	if( type & NNS_G2D_VRAM_TYPE_2DMAIN ){
		CharManager->Offset += szByte;

		// ItZbgLN^EŊ؂lɂ
		CharManager->Offset = getCharModeLimNum( CharManager->Offset, CharManager->MainModeCharLimit, CHAR_MAN_LIM_ADD );
	}
	if( type & NNS_G2D_VRAM_TYPE_2DSUB ){
		CharManager->SubOffset += szByte;

		CharManager->SubOffset = getCharModeLimNum( CharManager->SubOffset, CharManager->SubModeCharLimit, CHAR_MAN_LIM_ADD );
	}

}

//----------------------------------------------------------------------------
/**
 *	@brief	oCg8oCg1̒l擾
 *
 *	@param	num		l
 *	@param	byte8	8rbgPʂ̒l
 *	@param	byte1	8rbgPʓ1rbgPʂ̒l
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void byte8_byte1_Get( int num, u32* byte8, u8* byte1 )
{
	*byte8 = num >> 3;
	*byte1 = num & 7;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Ǘ̈̋֎~ݒް쐬
 *
 *	@param	areacont_start	Ǘ̈JnItZbg
 *	@param	offset			֎~ݒItZbg
 *	@param	size			TCY
 *	@param	start_offset	JnItZbgi[
 *	@param	set_size		TCYi[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void getReserveAreaContData( u32 areacont_start, u32 offset, u32 size, int* start_offset, int* set_size )
{
	*start_offset = offset - areacont_start;
	if( *start_offset < 0 ){
		// ItZbg0ɂđȂ̃TCYsize
		// 傤ǗǂȂ
		*set_size = size + *start_offset;
		*start_offset = 0;
	}else{
		*set_size = size;
	}
	
}
