//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		clact.c
 *@brief	ZAN^[
 *@author	tomoya takahashi
 *@data		2005.05.19
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#define	_CLACT_H_GLOBAL
#include <string.h>
#include "clact.h"
#include "system.h"
#include "gflib_os_print.h"
#include "vram_transfer_manager.h"
#include "assert.h"

//
#include "char_manager.h"
#include "pltt_manager.h"
#include "str_tool.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
 */
//-----------------------------------------------------------------------------
#define PLTT_ONE_SIZE	(32)	
#define	SIMPLE_DRAW_OAM_TMP	(128)

// Agr[g
#define		CLACT_ATTR_PRIORITY_MASK	(0x0c00)			// Dxf[^o}XN
#define		CLACT_ATTR_PRIORITY_SHIFT	(10)				// Dxf[^̃Vtg

// I[gAj[Vt[
#define		CLACT_AUTO_ANM_FRAME		(FX32_ONE * 2)

// Aj[V^Cv\̂̍őTCY(int)
#define		CLACT_ANM_DATA_MAX			(29)		// {̃TCY͂ꂘS

//-------------------------------------
///	Aj[V^Cv\
enum
{
	CLACT_NONE,			// gpĂȂ
	CLACT_CELL,			// ZAj[V
	CLACT_MULTICELL,	// }`ZAj[V
	CLACT_VRAM_CELL,	// ZAjVram]Aj[V
};

//-----------------------------------------------------------------------------
/**
 *					\̐錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
///	ZAj[V\	
typedef	struct CLACT_ANIM_DATA_tag
{
	const NNSG2dCellDataBank*             pCellBank;   // Zf[^
	const NNSG2dCellAnimBankData*         pAnimBank;   // ZAj[V

	NNSG2dCellAnimation				AnmCtrl;	// Aj[VRg[
} CLACT_ANIM_DATA;


//-------------------------------------
///	Vram]ZAj[V\
typedef struct CLACT_VRAM_ANIM_DATA_tag
{
	NNSG2dCellDataBank*             pCellBank;   // Zf[^
	const NNSG2dCellAnimBankData*         pAnimBank;   // ZAj[V

	NNSG2dCellAnimation				AnmCtrl;	// Aj[VRg[

	u32								CellTransManHandle;	// ZAj[VVram]Ǘ
														// Z]ԊǗIuWFNg̃nh
} CLACT_VRAM_ANIM_DATA;

//-------------------------------------
///	}`ZAj[V\	
typedef	struct CLACT_MULTICELL_ANIM_DATA_tag
{
	const NNSG2dCellDataBank*             pCellBank;	// Zf[^
    const NNSG2dCellAnimBankData*         pAnimBank;  // ZAj[V
	
	NNSG2dMultiCellAnimation		AnmCtrl;	// Aj[VRg[
	
	const NNSG2dMultiCellDataBank*        pMCBank;    // }`Zf[^
    const NNSG2dMultiCellAnimBankData*    pMCABank;   // }`ZAj[V
	NNSG2dNode*						pNode;		// }`ZɕKvȃm[h
	NNSG2dCellAnimation*			pCellAnim;	// }`ZɕKvȃAj[VRg[
	
} CLACT_MULTICELL_ANIM_DATA;


//-------------------------------------
///	ZAN^[\
typedef struct CLACT_WORK_tag{
	VecFx32		Matrix;						// W
	VecFx32		AffineMatrix;				// AtBϊW
	VecFx32		Scale;						// XP[
	u16			Rotation;					// ]
	u8			affin;						// AtBA{pAtBtO
	u8			flip;						// tbvtO
	u8			over_write;					// _[I[o[CgtO
	u8			palNo;						// pbgio[
	u8			palOfs;						// pbgItZbg
	BOOL		mosaic;						// UCN
	GXOamMode	objmode;					// OBJ[h
		
	// `ރtO
	u8			DrawFlag;	// 0:`		1:_[`
	// I[gAj[VtO
	u8			AnmFlag;	// 0:Aj	1:I[gAj
	fx32		Frame;		// Aj[VXs[h
											
	
	CLACT_SET_PTR	pClActSet;		// ẽAN^[Zbg̃|C^
	u32				AnmData[ CLACT_ANM_DATA_MAX ];	// Aj[Vf[^\́iZAj[VA}`ZAj[VAVram]Aj[Ve\̃f[^@flag̃Aj[Vf[^^ɃLXgĎgj
	NNSG2dImageProxy        ImageProxy;		// LN^/eNX`vLV
	NNSG2dImagePaletteProxy  PaletteProxy;	// pbgvLV
	u32			flag;						// ZAj[VA}`ZAj[VAVram]Aj[ṼtO
	u16			AnmNum;						// V[PXio[ĩAjio[j
	u8			Priority;					// BGʂƂ̗D揇(0,1,2,3)
	u16			DrawPriority;				// `ł̗D揇(0=őO	1,2,3....)
	NNS_G2D_VRAM_TYPE	type;				// VramType ǂɕ`悵Ă邩
	/*	typedef enum NNS_G2D_VRAM_TYPE
		{
			NNS_G2D_VRAM_TYPE_3DMAIN = 0,		// XvCg͍͎gȂ̂Ŏw肵Ȃ
			NNS_G2D_VRAM_TYPE_2DMAIN = 1,
			NNS_G2D_VRAM_TYPE_2DSUB  = 2,
			NNS_G2D_VRAM_TYPE_MAX    = 3
		}NNS_G2D_VRAM_TYPE;
	 */
	// Xg\
	struct CLACT_WORK_tag*		pLast;		// ÕAN^[
	struct CLACT_WORK_tag*		pNext;		// ̃AN^[
} CLACT_WORK;

//-------------------------------------
//
//	ZAN^[Zbg
//
//	ZAN^[VXe̎
//
//=====================================
typedef struct _CLACT_SET{
	CLACT_WORK*		pWork;			// ZAN^[\
	int				WorkNum;		// z
	CLACT_WORK**	ppWorkStack;	// X^bN
	int				WorkStackNow;	// ̃X^bNpopʒu
	
	CLACT_WORK	Dummy;	// AN^[Xg_~[f[^
	
	// OAM}l[W|C^
//	NNSG2dOamManagerInstance* pMainMan;
//	NNSG2dOamManagerInstance* pSubMan;
	
	
	// _[
	NNSG2dRendererInstance*		pRender;			// `p Renderer

	// ftHgAj[Vf[^
	void*							pAnimBuff;	// obt@
    NNSG2dCellAnimBankData*         pAnimBank;  // ZAj[V

	u32			DrawFlag;		// 1:\@0:\
}CLACT_SET;

//-------------------------------------
//	
//	`֐e[up
//	
//=====================================
typedef void (*CLACT_DRAW)( const CLACT_SET* pClActSet, CLACT_WORK* act );

//-------------------------------------
//	
//	I[gAj[V֐e[up
//	
//=====================================
typedef void (*CLACT_ANM)( CLACT_WORK* act );

//----------------------------------------------------------------------------
/**
 *					vg^Cv錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	ZAN^[Zbg샍[J֐
//=====================================
static void CleanActSet(CLACT_SET* pClAct);

//-------------------------------------
//	ZAN^[[Np
//=====================================
static u32	getActType( const CLACT_HEADER* pHeader );	// ZAjA}`ZAjԂ
static void LoadCell( const NNSG2dCellDataBank* Cell, CLACT_WORK* pWork );		// Zǂݍ
static void LoadCellAnm( const NNSG2dCellAnimBankData* Anm, CLACT_WORK* pWork );	// ZAjǂݍ
static void LoadMultiCell( const NNSG2dMultiCellDataBank* Mlt, CLACT_WORK* pWork );// }`Zǂݍ
static void LoadMultiCellAnm( const NNSG2dMultiCellAnimBankData* Anm, CLACT_WORK* pWork );// }`ZAjǂݍ
static void MakeCellAnm( CLACT_WORK* pWork, int heap );
static void MakeCellAnmVram( const CLACT_HEADER* pHeader, CLACT_WORK* pWork , int heap);
static void MakeMultiCellAnm( CLACT_WORK* pWork, int heap );							// }`ZAj̍\zs
static BOOL LoadData( const CLACT_SET* pSet, const CLACT_HEADER* pHeader, CLACT_WORK* pWork, int heap );
static u32 GetPlttProxyOffset( const NNSG2dImagePaletteProxy* pPltt, u32 vramType );	// pbg炷l擾
// _[gpxȕ`
static void renderDraw( const CLACT_SET* pClActSet, CLACT_WORK* act );
static void noDraw( const CLACT_SET* pClActSet, CLACT_WORK* act );

// I[gAj[V
static void autoAnm( CLACT_WORK* act );
static void noAnm( CLACT_WORK* act );

//-----------------------------------------------------------------------------
//				AN^[Xg
//				`D揇ʂŕ`悷邽
//=============================================================================
static void addCellActList( CLACT_SET* cs, CLACT_WORK* pWork );		// Xgɒǉ
static void dellCellActList( CLACT_WORK* pWork );	// Xgj(̈̔j͂Ȃ)
//-------------------------------------
//	stack̏
//=====================================
static void initStack(CLACT_SET* pSet);			// 
static CLACT_WORK* popStack(CLACT_SET* pSet);	// o
static BOOL pushStack(CLACT_SET* pSet, CLACT_WORK* pDat);	// i[
//=============================================================================
//----------------------------------------------------------------------------
/**
 *					O[oϐ錾
 */
//-----------------------------------------------------------------------------

//=============================================================================
//
//		AN^[VXe
//
//				AN^[Zbg쐬O
//				AN^[Zbgj
//				
//			ɍs̊֐
//
//=============================================================================
//=============================================================================
//
//	AN^[Zbg֐S
//
//=============================================================================
//-----------------------------------------------------------------------------
/**
 *@brief			ZAN^[Zbg̏
 *
 *@param	pSetData		ZAN^[Zbg쐬f[^
 *
 *@retval	CLACT_SET_PTR	쐬ZAN^[Zbg|C^
 *@retval	NULL			s
 *
 * ZAN^[Zbg쐬
 *
 */
 //----------------------------------------------------------------------------
CLACT_SET_PTR CLACT_InitSet( const CLACT_SETDATA* pSetData )
{
	CLACT_SET*	cs;		// ZAN^[Zbg	
	int			idx;	// ZAN^[CfbNX
	
	GF_ASSERT(pSetData);
	GF_ASSERT(pSetData->pRender);
	
	// AN^[Zbgm
	cs = sys_AllocMemory(pSetData->heap, sizeof(CLACT_SET));
	GF_ASSERT(cs);
	CleanActSet(cs);
	
	// [N̍쐬
	cs->pWork = sys_AllocMemory(pSetData->heap, sizeof(CLACT_WORK)*pSetData->WorkNum);
	GF_ASSERT(cs->pWork);
	cs->WorkNum = pSetData->WorkNum;	// [N
	// X^bN̏
	cs->ppWorkStack = sys_AllocMemory(pSetData->heap, sizeof(CLACT_WORK*)*pSetData->WorkNum);
	GF_ASSERT(cs->ppWorkStack);
	initStack(cs);
	
	// Xg̃_~[̏
	CLACT_WorkClear(&cs->Dummy);
	cs->Dummy.pLast = &cs->Dummy;
	cs->Dummy.pNext = &cs->Dummy;

	// OAM}l[W
//	cs->pMainMan	= pSetData->pMainMan;
//	cs->pSubMan		= pSetData->pSubMan;
	
	// _[ 
	cs->pRender = pSetData->pRender;

	// ftHgAjf[^ǂݍ
	cs->pAnimBuff = sys_LoadFile( pSetData->heap, "data/clact_default.NANR" );
	NNS_G2dGetUnpackedAnimBank( cs->pAnimBuff, &cs->pAnimBank );

	// `tO
	cs->DrawFlag = 1;

	return cs;
}

//-----------------------------------------------------------------------------
/**
 *@brief			ZAN^[Zbg̔j
 *
 *@param	ClActSet			jZAN^[Zbg|C^
 *
 *@retval	TRUE	
 *@retval	FALSE	s	(ClActSetԈႢ)
 *
 * ZAN^[Zbgj
 *		sĂAN^[IuWFĉ
 *
 */
 //----------------------------------------------------------------------------
BOOL CLACT_DestSet( CLACT_SET_PTR ClActSet )
{	

	if(ClActSet == NULL){
		return FALSE;
	}

	if(ClActSet->pWork == NULL){	// 폜ς݂`FbN
		return TRUE;
	}
	
	// AN^[j
	CLACT_DelAllSet(ClActSet);

	// Ajf[^j
	sys_FreeMemoryEz( ClActSet->pAnimBuff );
	
	// X^bNj
	sys_FreeMemoryEz(ClActSet->ppWorkStack);

	// [Nj
	sys_FreeMemoryEz(ClActSet->pWork);

	// AN^[Zbg
	CleanActSet(ClActSet);

	sys_FreeMemoryEz(ClActSet);
	ClActSet = NULL;

	return TRUE;
}

//-----------------------------------------------------------------------------
/**
 *@brief			ZAN^[Zbg̕`tOݒ
 *
 *@param	ClActSet			jZAN^[Zbg|C^
 *@param	flag				0:`	1:`
 *
 *@retval	TRUE	
 *@retval	FALSE	s	(ClActSetԈႢ)
 *
 *	o^Ăr{[hSĂ`/`悷邩ݒ
 *
 */
 //----------------------------------------------------------------------------
BOOL CLACT_DrawFlagSet( CLACT_SET_PTR ClActSet, u8 flag )
{
	if(ClActSet == NULL){
		return FALSE;
	}

	if(ClActSet->pWork == NULL){	// o^Ă邩`FbN
		return FALSE;
	}

	ClActSet->DrawFlag = flag;

	return TRUE;
}

//-----------------------------------------------------------------------------
/**
 *@brief			SAN^[j
 *
 *@param	ClActSet		ZAN^[Zbg|C^
 *
 *@retval	TRUE	
 *@retval	FALSE	s	(ClActSetԈႢ)
 */
 //----------------------------------------------------------------------------
BOOL CLACT_DelAllSet( CLACT_SET_PTR ClActSet )
{
	CLACT_WORK*	p_work;		// [vp
	CLACT_WORK*	p_next;		// ۑp

	if(ClActSet == NULL){
		return FALSE;
	}
	
	if(ClActSet->pWork == NULL){	// o^Ă邩`FbN
		return TRUE;
	}
	
	// j
	p_work = ClActSet->Dummy.pNext;
	while(p_work != &ClActSet->Dummy){
		p_next = p_work->pNext;
		
		CLACT_Delete(p_work);

		p_work = p_next;
	}

	return TRUE;
}

//-----------------------------------------------------------------------------
/**
 *@brief				`悷
 *
 *@param	pClActSys	ZAN^[VXe
 *@param	pClAct		ZAN^[Zbg
 *
 *@return	none
 */
 //----------------------------------------------------------------------------
void CLACT_Draw( const CLACT_SET* pClAct )
{
	CLACT_WORK*	p_work;		// [vp
	// `֐e[u
	static const CLACT_DRAW	drawTbl[] = {
		noDraw,		// `悵Ȃ
		renderDraw,
	};
	
	// I[gAj[Ve[u
	static const CLACT_ANM	anmTbl[] = {
		noAnm,
		autoAnm,	
	};

	GF_ASSERT( pClAct );
	
	if( pClAct->DrawFlag == 0 ){
		return ;
	}

	// `悷
	p_work = pClAct->Dummy.pNext;
	while(p_work != &pClAct->Dummy){

		// `
		drawTbl[ p_work->DrawFlag ]( pClAct, p_work );

		// I[gAj[V
		anmTbl[ p_work->AnmFlag ]( p_work );
		
		p_work = p_work->pNext;
	}
}

#if 0
//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAN^[Zbgɓo^ĂOAM}l[WOAM]
 *
 *@param	pClAct		ZAN^[Zbg
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_OAMTrans( CLACT_SET_PTR pClAct )
{
	if(pClAct->pMainMan != NULL){
		NNS_G2dApplyOamManagerToHW(pClAct->pMainMan);
		NNS_G2dResetOamManagerBuffer(pClAct->pMainMan);
	}
	if(pClAct->pSubMan != NULL){
		NNS_G2dApplyOamManagerToHW(pClAct->pSubMan);
		NNS_G2dResetOamManagerBuffer(pClAct->pSubMan);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	o^ĂOAM}l[W擾
 *
 *@param	pClAct			ZAN^[
 *@param	vramType		Vram^Cv	
					main	NNS_G2D_VRAM_TYPE_2DMAIN
					sub		NNS_G2D_VRAM_TYPE_2DSUB
 *
 *@retval	NNSG2dOamManagerInstance* OAM}l[W
 *@retval	NULL						ݒ肳ĂȂ
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dOamManagerInstance* CLACT_OAMManagerGet( CLACT_SET_PTR pClAct, int vramType )
{
	if(vramType == NNS_G2D_VRAM_TYPE_2DMAIN){
		return pClAct->pMainMan;
	}
	if(vramType == NNS_G2D_VRAM_TYPE_2DSUB){
		return pClAct->pSubMan;
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	OAM}l[Wݒ
 *
 *@param	pClAct		ZAN^[
 *@param	pOamMan		OAM}l[W
 *@param	vramType	
				mainɓo^FNNS_G2D_VRAM_TYPE_2DMAIN
				subɓo^ FNNS_G2D_VRAM_TYPE_2DSUB
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_OAMManagerSet( CLACT_SET_PTR pClAct, NNSG2dOamManagerInstance* pOamMan, int vramType )
{
	if(vramType == NNS_G2D_VRAM_TYPE_2DMAIN){
		pClAct->pMainMan = pOamMan;
	}
	if(vramType == NNS_G2D_VRAM_TYPE_2DSUB){
		pClAct->pSubMan = pOamMan;
	}
}
#endif

//----------------------------------------------------------------------------
/**
 *
 *@brief	o^Ă郌_[擾
 *
 *@param	pClAct			ZAN^[
 *
 *@retval	NNSG2dRendererInstance*		OAM}l[W
 *@retval	NULL						ݒ肳ĂȂ
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dRendererInstance* CLACT_RenderGet( CONST_CLACT_SET_PTR pClAct)
{
	return pClAct->pRender;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	_[ݒ
 *
 *@param	pClAct		ZAN^[
 *@param	pRender		_[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_RenderSet( CLACT_SET_PTR pClAct, NNSG2dRendererInstance* pRender)
{
	pClAct->pRender = pRender;
}

//-----------------------------------------------------------------------------
/**
 *@brief			AN^[Zbg
 *
 *@param	pClAct		ZAN^[Zbg
 *
 *@return	none
 */
 //----------------------------------------------------------------------------
static void CleanActSet(CLACT_SET* pClAct)
{
	pClAct->pWork		= NULL;		// ZAN^[\
	pClAct->WorkNum		= 0;		// z
	pClAct->ppWorkStack	= NULL;		// X^bN
	pClAct->WorkStackNow= 0;		// ̃X^bNpopʒu
//	pClAct->pMainMan	= NULL;
//	pClAct->pSubMan		= NULL;
	pClAct->pRender		=NULL;		// _[
	
	CLACT_WorkClear(&pClAct->Dummy);	// AN^[Xg_~[f[^
	pClAct->DrawFlag = 0;
}

//=============================================================================
//
//	AN^[[N֐S
//
//=============================================================================
//-----------------------------------------------------------------------------
/**
 *@brief		ZAN^[f[^
 *						
 *
 *@param	pWork		(0 Clear)f[^
 *
 *@return	none
 *
 */
 //----------------------------------------------------------------------------
void CLACT_WorkClear( CLACT_WORK_PTR pWork )
{
	int i;		// [vp
	
	pWork->pClActSet		= NULL;
	memset( pWork, 0, sizeof(CLACT_WORK) );
//	memset(&pWork->AnmData, 0, sizeof(u32) * CLACT_ANM_DATA_MAX);
	NNS_G2dInitImageProxy( &pWork->ImageProxy );
	NNS_G2dInitImagePaletteProxy( &pWork->PaletteProxy );
	pWork->objmode			= GX_OAM_MODE_NORMAL;
}

//-----------------------------------------------------------------------------
/**
 *@brief		ZAN^[[N̎擾
 *						
 *
 *@param	ClActSetIdx		ZAN^[Zbg|C^
 *@param	ClActIdx		ZAN^[[NCfbNX
 *
 *@retval	CLACT_WORK_PTR		
 *@retval	NULL			s
 *
 */
//----------------------------------------------------------------------------
CLACT_WORK_PTR CLACT_GetWork(CONST_CLACT_SET_PTR ClActSet, s16 ClActIdx)
{
	if(ClActSet == NULL){
		return NULL;
	}
	if(ClActIdx >= ClActSet->WorkNum){
		return NULL;
	}

	return &ClActSet->pWork[ClActIdx];
}

//-----------------------------------------------------------------------------
/**
 *@brief			ǉ
 *
 *@param	add		o^f[^
 *
 *@retval	BLACT_WORK*		o^AN^[̃|C^
 *@retval	NULL			s
 */
// ----------------------------------------------------------------------------
CLACT_WORK_PTR CLACT_Add(const CLACT_ADD* add)
{
	CLACT_WORK*	cl_w;		// ǉAN^[[N
	
	// X^bN烏[N擾
	cl_w = popStack(add->ClActSet);

	if(cl_w == NULL){
		return NULL;
	}

	
	// ̗vf̃f[^
	cl_w->pClActSet		= add->ClActSet;		// AN^[Zbg
	cl_w->AnmNum		= 0;
	cl_w->Matrix		= add->mat;			// WZbg
	cl_w->Scale			= add->sca;			// gkZbg
	cl_w->Rotation		= add->rot;			// ]pZbg
	cl_w->type			= add->DrawArea;	// ]ʃZbg
	cl_w->DrawPriority	= add->pri;			// `D揇
	cl_w->affin			= 0;				// ftH̓AtBȂ
	cl_w->flip			= 0;				// ftH̓tbvȂ
	cl_w->mosaic		= FALSE;			// UCNtO
	cl_w->objmode		= GX_OAM_MODE_NORMAL;// IuWF[hm[}

	// pbgio[
	// BG\D揇ʂoverCg
	cl_w->over_write	= NNS_G2D_RND_OVERWRITE_PLTTNO_OFFS | NNS_G2D_RND_OVERWRITE_PRIORITY;	

	// AtBϊݒ
	NNS_G2dSetRndCoreAffineOverwriteMode(
			&( add->ClActSet->pRender->rendererCore ),
			cl_w->affin );
	// tbvݒ
	NNS_G2dSetRndCoreFlipMode(
			&( add->ClActSet->pRender->rendererCore ),
			cl_w->flip & CLACT_FLIP_H,
			cl_w->flip & CLACT_FLIP_V);

	// `tOݒ
	cl_w->DrawFlag		= 1;		// _[`
	
	// I[gAj[Vݒ
	cl_w->AnmFlag		= 0;
	cl_w->Frame			= CLACT_AUTO_ANM_FRAME;

	// Aj[Vf[^ǂݍ
	if( LoadData( add->ClActSet, add->ClActHeader,cl_w, add->heap ) == FALSE ){
		// s
		CLACT_Delete( cl_w );

		return NULL;
	}

	// pbgItZbg擾
	cl_w->palOfs = GetPlttProxyOffset( &cl_w->PaletteProxy, cl_w->type );
	cl_w->palNo = cl_w->palOfs;	// l̓pbgItZbgʒuɂ

	// AN^[Xgɒǉ
	addCellActList(add->ClActSet, cl_w);
	
	return cl_w;
}

//-----------------------------------------------------------------------------
/**
 *@brief			Vvǉ
 *
 *@param	add		o^f[^
 *
 *@retval	CLACT_WORK_PTR		o^AN^[|C^
 *@retval	NULL				s
 */
// ----------------------------------------------------------------------------
CLACT_WORK_PTR CLACT_AddSimple(const CLACT_ADD_SIMPLE* add)
{
	CLACT_ADD add_ex;

	add_ex.ClActSet		= add->ClActSet;
	add_ex.ClActHeader	= add->ClActHeader;
	add_ex.mat			= add->mat;
	add_ex.sca.x		= FX32_ONE;
	add_ex.sca.y		= FX32_ONE;
	add_ex.sca.z		= FX32_ONE;
	add_ex.rot			= 0;
	add_ex.pri			= add->pri;
	add_ex.DrawArea		= add->DrawArea;
	add_ex.heap			= add->heap;

	return CLACT_Add( &add_ex );
}

//-----------------------------------------------------------------------------
/**
 *@brief			폜
 *
 *@param	del		폜AN^[[N
 *
 *@return	none
 * 
 */
// ----------------------------------------------------------------------------
void CLACT_Delete(CLACT_WORK_PTR del)
{
	CLACT_SET* cs;
	
	// f[^邩`FbN
	if( del->flag != CLACT_NONE ){
			
		CLACT_ANIM_DATA* cell_anm = (CLACT_ANIM_DATA*)&del->AnmData;

		// `惊Xgj
		if(del->pLast != NULL){
			dellCellActList( del );
		}

		
		// Vram]Aj[Ṽnh
		if( del->flag == CLACT_VRAM_CELL ){
			CLACT_VRAM_ANIM_DATA* p_vram = (CLACT_VRAM_ANIM_DATA*)&del->AnmData;	

			if( NNS_G2dGetImageLocation(&del->ImageProxy, del->type) != NNS_G2D_VRAM_ADDR_NONE ){
				NNS_G2dFreeCellTransferStateHandle( p_vram->CellTransManHandle );
			}
		}

		// }`Zf[^̉
		if( del->flag == CLACT_MULTICELL ){
			CLACT_MULTICELL_ANIM_DATA* p_multi = (CLACT_MULTICELL_ANIM_DATA*)&del->AnmData;

			// m[h
			if(p_multi->pNode != NULL){
				sys_FreeMemoryEz( p_multi->pNode );
			}

			// Aj[VRg[
			if(p_multi->pCellAnim != NULL){
				sys_FreeMemoryEz( p_multi->pCellAnim );
			}
		}
		
		// gpĂȂɂ
		del->flag = CLACT_NONE;	

		// X^bNɃvbV
		cs = (CLACT_SET*)del->pClActSet;
		pushStack(cs, del);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Wݒ
 *
 *@param	act			AN^[
 *@param	Matrix		W
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_SetMatrix(CLACT_WORK_PTR act, const VecFx32* Matrix)
{
	act->Matrix = *Matrix;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	AtBϊWݒ
 *
 *@param	act			AN^[
 *@param	Matrix		W
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_SetAffineMatrix(CLACT_WORK_PTR act, const VecFx32* Matrix)
{
	act->AffineMatrix = *Matrix;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	glݒ
 *
 *@param	act		AN^[
 *@param	Scale	gl
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_SetScale(CLACT_WORK_PTR act, const VecFx32* Scale)
{
	act->Scale = *Scale;
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	glݒ肵AAtBtOݒ肷
 *
 *@param	act		AN^[
 *@param	Scale	gl
 *@param	affine	AtBtO
 *
 *@return	none
 *
 *affinetO
 *	enum{
 *		CLACT_AFFINE_NONE,		// AtBϊȂ
 *		CLACT_AFFINE_NORMAL,	// AtBϊ
 *		CLACT_AFFINE_DOUBLE,	// {pAtBϊ
 *	};
 *
 */
//-----------------------------------------------------------------------------
void CLACT_SetScaleAffine(CLACT_WORK_PTR act, const VecFx32* Scale, int affine)
{
	CLACT_SetScale( act, Scale );
	CLACT_SetAffineParam( act, affine );
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	]pݒ
 *
 *@param	act			AN^[
 *@param	Rotation	]p
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_SetRotation(CLACT_WORK_PTR act, u16 Rotation)
{
	act->Rotation = Rotation;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	]pݒ肵ăAtBtOݒ
 *
 *@param	act			AN^[
 *@param	Rotation	]p		(0`65535)
 *@param	affine		AtBtO
 *
 *@return	none
 *
 *affinetO
 *	enum{
 *		CLACT_AFFINE_NONE,		// AtBϊȂ
 *		CLACT_AFFINE_NORMAL,	// AtBϊ
 *		CLACT_AFFINE_DOUBLE,	// {pAtBϊ
 *	};
 *
 */
//-----------------------------------------------------------------------------
void CLACT_SetRotationAffine(CLACT_WORK_PTR act, u16 Rotation, int affine)
{
	CLACT_SetRotation( act, Rotation );
	CLACT_SetAffineParam( act, affine );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	`tOݒ
 *
 *@param	act		AN^[
 *@param	flag	`tO	0:`	1:_`	
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_SetDrawFlag(CLACT_WORK_PTR act, int flag)
{
	GF_ASSERT( act );
	GF_ASSERT( flag < 2 );		// 2菬Kv
	act->DrawFlag = flag;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	I[gAjtOݒ
 *
 *@param	act		AN^[
 *@param	flag	I[gAjtO	0:Aj	1:I[gAj
 *
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_SetAnmFlag(CLACT_WORK_PTR act, int flag)
{
	GF_ASSERT( act );
	GF_ASSERT( flag < 2 );		// 2菬Kv
	act->AnmFlag = flag;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	I[gAj[Vt[ݒ
 *
 *@param	act		AN^[
 *@param	frame	PVNɐi߂t[
 *
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_SetAnmFrame(CLACT_WORK_PTR act, fx32 frame)
{
	GF_ASSERT( act );

	act->Frame = frame;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	AtBϊp[^
 *
 *	@param	act		AN^[
 *	@param	param	AtBϊp[^
 *
 *	@return	none
 *
 * param
 *	enum{
 *		CLACT_AFFINE_NONE,		// AtBϊȂ
 *		CLACT_AFFINE_NORMAL,	// AtBϊ
 *		CLACT_AFFINE_DOUBLE,	// {pAtBϊ
 *	};
 *
 */
//-----------------------------------------------------------------------------
void CLACT_SetAffineParam( CLACT_WORK_PTR act, int param )
{
	GF_ASSERT(act);

	act->affin	= param;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	tbv̐ݒ
 *
 *	@param	act		AN^[
 *	@param	flag	tbvtO 
 *
 *	@return	none
 *
 * flag
 *	enum{
 * 		CLACT_FLIP_NONE,		// tbvȂ
 * 		CLACT_FLIP_H,			// tbv
 *		CLACT_FLIP_V,			// tbv
 *		CLACT_FLIP_HV,			// tbv
 *	};
 *
 */
//-----------------------------------------------------------------------------
void CLACT_SetFlip( CLACT_WORK_PTR act, int flag )
{
	GF_ASSERT(act);
	act->flip = flag;
	act->affin	= CLACT_AFFINE_NONE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	W擾
 *
 *@param	act		AN^[
 *
 *@return	VecFx32	W
 *
 *
 */
//-----------------------------------------------------------------------------
const VecFx32* CLACT_GetMatrix(CONST_CLACT_WORK_PTR act)
{
	return &act->Matrix;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	AtBϊW擾
 *
 *@param	act		AN^[
 *
 *@return	VecFx32	W
 *
 *
 */
//-----------------------------------------------------------------------------
const VecFx32* CLACT_GetAffineMatrix(CONST_CLACT_WORK_PTR act)
{
	return &act->AffineMatrix;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	gl擾
 *
 *@param	act		AN^[
 *
 *@return	VecFx32	gl
 *
 *
 */
//-----------------------------------------------------------------------------
const VecFx32* CLACT_GetScale(CONST_CLACT_WORK_PTR act)
{
	return &act->Scale;
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	]px擾
 *
 *@param	act		AN^[
 *
 *@return	u16		]px
 *
 *
 */
//-----------------------------------------------------------------------------
u16 CLACT_GetRotation(CONST_CLACT_WORK_PTR act)
{
	return act->Rotation;
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	`tO擾
 *
 *@param	act	AN^[
 *
 *@return	int		0:`	1:`
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_GetDrawFlag(CONST_CLACT_WORK_PTR act)
{
	return act->DrawFlag;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	I[gAjtO擾
 *
 *@param	act	AN^[
 *
 *@return	int		0:Aj	1:I[gAj[V
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_GetAnmFlag(CONST_CLACT_WORK_PTR act)
{
	return act->AnmFlag;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	I[gAj[Vt[擾
 *
 *@param	act	AN^[
 *
 *@return	fx32		PVNɐi߂t[
 *
 *
 */
//-----------------------------------------------------------------------------
fx32 CLACT_GetAnmFrame(CONST_CLACT_WORK_PTR act)
{
	return act->Frame;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	AtBp[^	擾
 *
 *	@param	act		AN^[
 *
 *	@return	int		AtBp[^
 *
 * ret
 *	enum{
 *		CLACT_AFFINE_NONE,		// AtBϊȂ
 *		CLACT_AFFINE_NORMAL,	// AtBϊ
 *		CLACT_AFFINE_DOUBLE,	// {pAtBϊ
 *	};
 *
 */
//-----------------------------------------------------------------------------
int CLACT_GetAffineParam( CONST_CLACT_WORK_PTR act )
{
	GF_ASSERT(act);
	return act->affin;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	tbvݒ擾
 *
 *	@param	act		AN^[
 *
 *	@return	int		tbvݒ
 *
 * ret
 *	enum{
 * 		CLACT_FLIP_NONE,		// tbvȂ
 * 		CLACT_FLIP_H,			// tbv
 *		CLACT_FLIP_V,			// tbv
 *		CLACT_FLIP_HV,			// tbv
 *	};
 *
 */
//-----------------------------------------------------------------------------
int CLACT_GetFlip( CONST_CLACT_WORK_PTR act )
{
	GF_ASSERT(act);
	return act->flip;
}

//-----------------------------------------------------------------------------
/*
 *@brief	Aj[ṼV[PX`FW
 *
 *@param	actCellFZAN^[
 *@param	numFV[PXio[
 *
 *@return	none
 */
 //----------------------------------------------------------------------------
void CLACT_AnmChg( CLACT_WORK_PTR actCell, u32 num )
{
	const NNSG2dAnimSequence* pSeq;		// V[PX

	// ύXV[PXio[Zbg
	actCell->AnmNum = num;
	
	// ZAj[V`FbN
	if( (actCell->flag == CLACT_CELL) || (actCell->flag == CLACT_VRAM_CELL) ){
		CLACT_ANIM_DATA* anm = (CLACT_ANIM_DATA*)&actCell->AnmData;
		
		// V[PX擾
		pSeq = NNS_G2dGetAnimSequenceByIdx( anm->pAnimBank, num );

		// V[PXKp
		NNS_G2dSetCellAnimationSequence( &anm->AnmCtrl, pSeq );

		// Aj[VX^[g
		NNS_G2dStartAnimCtrl( &anm->AnmCtrl.animCtrl );
	}else{
		CLACT_MULTICELL_ANIM_DATA* anm = (CLACT_MULTICELL_ANIM_DATA*)&actCell->AnmData;
		
		// }`ZAj[V
		// V[PX擾
		pSeq = NNS_G2dGetAnimSequenceByIdx( anm->pMCABank, num );

		// V[PXKp
		NNS_G2dSetAnimSequenceToMCAnimation( &anm->AnmCtrl, pSeq );

		// Aj[VX^[g
		NNS_G2dStartAnimCtrl( &anm->AnmCtrl.animCtrl );
	}
}

//-----------------------------------------------------------------------------
/*
 *@brief	Aj[ṼV[PX`FW
 *
 *@param	actCellFZAN^[
 *@param	numFV[PXio[
 *
 *@return	none
 */
 //----------------------------------------------------------------------------
void CLACT_AnmChgCheck( CLACT_WORK_PTR actCell, u32 num )
{
	// V[PX`FW
	if( actCell->AnmNum != num ){
		CLACT_AnmChg( actCell, num );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	Aj[VX^[g
 *
 *	@param	actCell		ZAN^|
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void CLACT_AnmReStart( CLACT_WORK_PTR actCell )
{
	// ZAj[V`FbN
	if( (actCell->flag == CLACT_CELL) || (actCell->flag == CLACT_VRAM_CELL) ){
		CLACT_ANIM_DATA* anm = (CLACT_ANIM_DATA*)&actCell->AnmData;
		
		// Xe[^XZbg
		NNS_G2dResetAnimCtrlState( &anm->AnmCtrl.animCtrl );

		// Aj[VX^[g
		NNS_G2dStartAnimCtrl( &anm->AnmCtrl.animCtrl );
		
		CLACT_AnmFrameSet( actCell, 0 );
	}else{
		CLACT_MULTICELL_ANIM_DATA* anm = (CLACT_MULTICELL_ANIM_DATA*)&actCell->AnmData;
		
		// }`ZAj[V
		// Xe[^XZbg
		NNS_G2dResetAnimCtrlState( &anm->AnmCtrl.animCtrl );

		// Aj[VX^[g
		NNS_G2dStartAnimCtrl( &anm->AnmCtrl.animCtrl );

		CLACT_AnmFrameSet( actCell, 0 );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	݂̃Aj[VV[PX擾
 *
 *@param	actCell		AN^[
 *
 *@return	s32		Aj[VV[PXio[
 *
 *
 */
//-----------------------------------------------------------------------------
u32 CLACT_AnmGet( CONST_CLACT_WORK_PTR actCell )
{
	return actCell->AnmNum;
}

//-----------------------------------------------------------------------------
/**	
 *@brief	Aj[V
 *
 *@param	actCellF\
 *@param	numFt[i߂l
 *
 *@return	none
 */
 //----------------------------------------------------------------------------
void CLACT_AnmFrameChg( CLACT_WORK_PTR actCell, fx32 num )
{
	// Aj[V
	// ZAj[V`FbN
	if( (actCell->flag == CLACT_CELL) || (actCell->flag == CLACT_VRAM_CELL) ){
		CLACT_ANIM_DATA* anm = (CLACT_ANIM_DATA*)&actCell->AnmData;
		NNS_G2dTickCellAnimation( &anm->AnmCtrl, num );
	}else{
		CLACT_MULTICELL_ANIM_DATA* anm = (CLACT_MULTICELL_ANIM_DATA*)&actCell->AnmData;
		NNS_G2dTickMCAnimation( &anm->AnmCtrl, num );
	}
}

//-----------------------------------------------------------------------------
/**	
 *@brief	Aj[Vt[Zbg
 *
 *@param	actCellF\
 *@param	numFZbgAj[Vt[
 *
 *@return	none
 */
//----------------------------------------------------------------------------
void CLACT_AnmFrameSet( CLACT_WORK_PTR actCell, u16 num )
{
	// V[PXԍ̃t[̂Ƃɂ
	// ZAj[V`FbN
	if( (actCell->flag == CLACT_CELL) || (actCell->flag == CLACT_VRAM_CELL) ){
		CLACT_ANIM_DATA* anm = (CLACT_ANIM_DATA*)&actCell->AnmData;
		NNS_G2dSetCellAnimationCurrentFrame( &anm->AnmCtrl, num );
	}else{
		CLACT_MULTICELL_ANIM_DATA* anm = (CLACT_MULTICELL_ANIM_DATA*)&actCell->AnmData;
		NNS_G2dSetMCAnimationCurrentFrame( &anm->AnmCtrl, num );
	}
}

//-----------------------------------------------------------------------------
/**	
 *@brief				Aj[Vt[擾
 *
 *@param	actCellF\
 *
 *@return	̃t[
 */
//----------------------------------------------------------------------------
u16 CLACT_AnmFrameGet( CONST_CLACT_WORK_PTR actCell)
{
	NNSG2dAnimController*	anm_cntl;		// Aj[VRg[
	
	// ZAj[V`FbN
	if( (actCell->flag == CLACT_CELL) || (actCell->flag == CLACT_VRAM_CELL) ){
		CLACT_ANIM_DATA* anm = (CLACT_ANIM_DATA*)&actCell->AnmData;
		anm_cntl = NNS_G2dGetCellAnimationAnimCtrl( &anm->AnmCtrl );
	}else{
		CLACT_MULTICELL_ANIM_DATA* anm = (CLACT_MULTICELL_ANIM_DATA*)&actCell->AnmData;
		anm_cntl = NNS_G2dGetMCAnimAnimCtrl( &anm->AnmCtrl );
	}
	return NNS_G2dGetAnimCtrlCurrentFrame( anm_cntl );
}

//-----------------------------------------------------------------------------
/**
 *@brief	BGʂƂ̗DxύX
 *
 *@param	actCellF\
 *@param	PriorityFDx
 *
 *@return	none
 */
 //----------------------------------------------------------------------------
void CLACT_BGPriorityChg( CLACT_WORK_PTR actCell, u8 Priority )
{
	actCell->Priority = Priority;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	BGʂƂ̕`Dx擾
 *
 *@param	actCell		AN^[
 *
 *@return	u8			Dx
 *
 *
 */
//-----------------------------------------------------------------------------
u8 CLACT_BGPriorityGet( CONST_CLACT_WORK_PTR actCell)
{
	return actCell->Priority;
}

//-----------------------------------------------------------------------------
/**
 *@brief				pbgio[ύX
 *
 *@param	actCellF\
 *@param	pltt_numFύXpbgio[
 * 
 *@return	none
 *
 * pbgio[ݒƃpbgItZbgݒ͓܂B
 *@@pbgio[ݒ肷ƃItZbg̒l͔fȂȂ܂B
 *	@ItZbglݒ肵Ƃ̓pbgio[fȂȂ܂B
 */
 //----------------------------------------------------------------------------
void CLACT_PaletteNoChg( CLACT_WORK_PTR actCell, u32 pltt_num )
{
	GF_ASSERT( actCell );

	actCell->palNo = pltt_num;

	// pbgio[f
	// pbgItZbgf
	actCell->over_write	|= NNS_G2D_RND_OVERWRITE_PLTTNO;	
	actCell->over_write &= ~NNS_G2D_RND_OVERWRITE_PLTTNO_OFFS;
}

//-----------------------------------------------------------------------------
/**
 * CLACT_PaletteNoChǧʂɃpbg]擪io[Z܂B
 *
 *@brief				pbgio[ύX
 *
 *@param	actCell			\
 *@param	pltt_num		ύXpbgio[
 * 
 *@return	none
 *
 * pbgio[ݒƃpbgItZbgݒ͓܂B
 *@@pbgio[ݒ肷ƃItZbg̒l͔fȂȂ܂B
 *	@ItZbglݒ肵Ƃ̓pbgio[fȂȂ܂B
 * 
 */
 //----------------------------------------------------------------------------
void CLACT_PaletteNoChgAddTransPlttNo( CLACT_WORK_PTR actCell, u32 pltt_num )
{
	CLACT_PaletteNoChg( actCell, pltt_num );

	actCell->palNo += GetPlttProxyOffset( &actCell->PaletteProxy, actCell->type );

}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgio[擾
 *
 *@param	actCell		AN^[
 *
 *@return	u32		̃pbgio[
 *
 *
 */
//-----------------------------------------------------------------------------
u32 CLACT_PaletteNoGet( CONST_CLACT_WORK_PTR actCell )
{
	return actCell->palNo;
}

//-----------------------------------------------------------------------------
/**
 * OAMAgr[gɐݒ肳Ăpbgio[ɉZ܂B
 * 
 *@brief	pbgItZbgݒ
 *
 *@param	actCell		\
 *@param	pltt_num	pbgItZbgio[
 * 
 *@return	none
 *
 * pbgio[ݒƃpbgItZbgݒ͓܂B
 *@@pbgio[ݒ肷ƃItZbg̒l͔fȂȂ܂B
 *	@ItZbglݒ肵Ƃ̓pbgio[fȂȂ܂B
 * 
 */
 //----------------------------------------------------------------------------
void CLACT_PaletteOffsetChg( CLACT_WORK_PTR actCell, u32 pltt_num )
{
	GF_ASSERT( actCell );

	actCell->palOfs = pltt_num;

	// pbgio[񔽉f
	// pbgItZbgf
	actCell->over_write	|= NNS_G2D_RND_OVERWRITE_PLTTNO_OFFS;	
	actCell->over_write &= ~NNS_G2D_RND_OVERWRITE_PLTTNO;
}

//----------------------------------------------------------------------------
/**
 * CLACT_PaletteOffsetChg֐̌ʂɃpbg̓]擪pbgio[Z܂B
 *
 *@brief	pbgItZbgݒ
 *
 *	@param	act		AN^[
 *
 *	@return	pbgio[
 *
 *
 * pbgio[ݒƃpbgItZbgݒ͓܂B
 *@@pbgio[ݒ肷ƃItZbg̒l͔fȂȂ܂B
 *	@ItZbglݒ肵Ƃ̓pbgio[fȂȂ܂B
 */
//-----------------------------------------------------------------------------
void CLACT_PaletteOffsetChgAddTransPlttNo( CLACT_WORK_PTR act, u32 pltt_num )
{
	CLACT_PaletteOffsetChg( act, pltt_num );

	act->palOfs += GetPlttProxyOffset( &act->PaletteProxy, act->type );
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgItZbgl擾
 *
 *@param	actCell		AN^[
 *
 *@return	u32		̃pbgItZbgl
 *
 *
 */
//-----------------------------------------------------------------------------
u32 CLACT_PaletteOffsetGet( CONST_CLACT_WORK_PTR actCell )
{
	GF_ASSERT( actCell );

	return actCell->palOfs;
}

//-----------------------------------------------------------------------------
/**
 *@brief	`D揇ʂݒ
 *
 *@param	actCell		\
 *@param	Priority	D揇
 *				
 * 
 *@return	none
 */
 //----------------------------------------------------------------------------
void CLACT_DrawPriorityChg( CLACT_WORK_PTR actCell, u32 Priority )
{
	CLACT_SET* cs = (CLACT_SET*)actCell->pClActSet;
	
	// D揇ʂύX
	actCell->DrawPriority = Priority;
	
	// AN^[Xg̍ēo^s
	dellCellActList(actCell);
	addCellActList(cs, actCell);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	`D揇ʂ擾
 *
 *@param	actCell		AN^[
 *
 *@return	u32			`D揇
 *
 *
 */
//-----------------------------------------------------------------------------
u32 CLACT_DrawPriorityGet( CONST_CLACT_WORK_PTR actCell )
{
	return actCell->DrawPriority;
}

//----------------------------------------------------------------------------
//
/**
 *
 *	@brief	vNVf[^ݒ
 *
 *	@param	act			AN^[
 *	@param	pImageProxy	ݒ肷C[WvNV
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_ImageProxySet( CLACT_WORK_PTR act, const NNSG2dImageProxy* pImageProxy )
{
	act->ImageProxy = *pImageProxy;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	vNVf[^擾
 *
 *	@param	act			AN^[
 *
 *	@return	AN^[ĂC[WvNV
 */
//-----------------------------------------------------------------------------
NNSG2dImageProxy * CLACT_ImageProxyGet( CLACT_WORK_PTR act )
{
	return &act->ImageProxy;
}


//--------------------------------------------------------------
/**
 * @brief	vNVf[^ݒ
 *
 * @param	act	
 * @param	PaletteProxy	
 *
 * @retval	GLOBAL void	
 *
 */
//--------------------------------------------------------------
void CLACT_PaletteProxySet( CLACT_WORK_PTR act, const NNSG2dImagePaletteProxy*  PaletteProxy)
{
	act->PaletteProxy = *PaletteProxy;
}


//--------------------------------------------------------------
/**
 * @brief	vNVf[^擾
 *
 * @param	act	
 *
 * @retval	AN^[ĂvNV
 *
 */
//--------------------------------------------------------------
NNSG2dImagePaletteProxy * CLACT_PaletteProxyGet( CLACT_WORK_PTR act )
{
	return &act->PaletteProxy;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	UCNݒ
 *
 *	@param	act		AN^[[N
 *	@param	flag	tO	TRUEUCNON	FALSEUCNOFF
 *
 *	@return	none
 *
 * UCNOFF̎łAjgLN^ŃUCNONɂOAM
 * UCNĕ`悳܂B
 *
 */
//-----------------------------------------------------------------------------
void CLACT_MosaicSet( CLACT_WORK_PTR act, BOOL flag )
{
	act->mosaic = flag;

	if(flag == TRUE){
		act->over_write |= NNS_G2D_RND_OVERWRITE_MOSAIC;
	}else{
		act->over_write ^= NNS_G2D_RND_OVERWRITE_MOSAIC;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	UCNݒԂ擾
 *
 *	@param	act		AN^[[N
 *
 *	@retval	TRUE	UCNON
 *	@retval	FALSE	UCNOFF	ijgLN^Őݒ肵ĂƂ͔fj
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL CLACT_MosaicGet( CONST_CLACT_WORK_PTR act )
{
	return act->mosaic;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VRAM^Cv擾
 *
 *	@param	act		AN^[[N
 *
 *	@retval	VRAM^Cv
 *
 *
 */
//-----------------------------------------------------------------------------
NNS_G2D_VRAM_TYPE CLACT_VramTypeGet( CONST_CLACT_WORK_PTR act )
{
	return act->type;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	AN^[Aj[V`FbN
 *
 *	@param	act		AN^[[N
 *
 *	@retval	TRUE	Aj[V
 *	@retval	FALSE	Xgbv
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL CLACT_AnmActiveCheck( CLACT_WORK_PTR act )
{
	GF_ASSERT( act );

	// V[PXԍ̃t[̂Ƃɂ
	// ZAj[V`FbN
	if( (act->flag == CLACT_CELL) || (act->flag == CLACT_VRAM_CELL) ){
		CLACT_ANIM_DATA* anm = (CLACT_ANIM_DATA*)&act->AnmData;
		return NNS_G2dIsAnimCtrlActive( &anm->AnmCtrl.animCtrl );
	}else{
		CLACT_MULTICELL_ANIM_DATA* anm = (CLACT_MULTICELL_ANIM_DATA*)&act->AnmData;
		return NNS_G2dIsAnimCtrlActive( &anm->AnmCtrl.animCtrl );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	IuWF[hݒ
 *
 *	@param	act			AN^[[N
 *	@param	objmode		IuWF[h 
 *
 *	@return	none
 *
 *	IuWF[hGX_OAM_MODE_NORMALɂNitroCharacterŐݒ肵
 *	IuWF[hŕ`悳܂B
 *	
	GX_OAM_MODE_NORMAL		m[}OBJ 
	GX_OAM_MODE_XLU			OBJ 
	GX_OAM_MODE_OBJWND OBJ	EBhE 
	GX_OAM_MODE_BITMAPOBJ	rbg}bvOBJ 
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_ObjModeSet( CLACT_WORK_PTR act, GXOamMode objmode )
{
	GF_ASSERT(act);
	
	act->objmode = objmode;

	if(objmode == GX_OAM_MODE_NORMAL){
		act->over_write ^= NNS_G2D_RND_OVERWRITE_OBJMODE;
	}else{
		act->over_write |= NNS_G2D_RND_OVERWRITE_OBJMODE;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	IuWF[h擾
 *
 *	@param	act		AN^[[N
 *
 *	@retval	GX_OAM_MODE_NORMAL		m[}OBJ 
 *	@retval	GX_OAM_MODE_XLU			OBJ 
 *	@retval	GX_OAM_MODE_OBJWND OBJ	EBhE 
 *	@retval	GX_OAM_MODE_BITMAPOBJ	rbg}bvOBJ 
 *
 *	IuWF[hGX_OAM_MODE_NORMAL̎NitroCharacterŐݒ肵
 *	IuWF[hŕ`悳܂B
 *
 */
//-----------------------------------------------------------------------------
GXOamMode CLACT_ObjModeGet( CONST_CLACT_WORK_PTR act )
{
	GF_ASSERT( act );
	return act->objmode;
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAMWX^NA@C
 *
 *	@param	heap q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void CLACT_UtilOamRamClear_Main( int heap )
{
	void* p_cbff;	// pobt@

	p_cbff = sys_AllocMemory( heap, sizeof(GXOamAttr) * 128 );
	// ----------------------------------------------------------------------------
	// localize_spec_mark(JP_VER10) imatake 2006/12/01
	// OAM ɋ֎~R[hł̂C
	MI_CpuFill16( p_cbff, 0x02C0, sizeof(GXOamAttr) * 128 );
	// ----------------------------------------------------------------------------
	DC_FlushRange( p_cbff, sizeof(GXOamAttr) * 128 );
	GX_LoadOAM( p_cbff, 0, sizeof(GXOamAttr) * 128 );
	sys_FreeMemoryEz( p_cbff );
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAMWX^NA@Tu
 *
 *	@param	heap q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void CLACT_UtilOamRamClear_Sub( int heap )
{
	void* p_cbff;	// pobt@

	p_cbff = sys_AllocMemory( heap, sizeof(GXOamAttr) * 128 );
	// ----------------------------------------------------------------------------
	// localize_spec_mark(JP_VER10) imatake 2006/12/01
	// OAM ɋ֎~R[hł̂C
	MI_CpuFill16( p_cbff, 0x02C0, sizeof(GXOamAttr) * 128 );
	// ----------------------------------------------------------------------------
	GXS_LoadOAM( p_cbff, 0, sizeof(GXOamAttr) * 128 );
	sys_FreeMemoryEz( p_cbff );
}


//=============================================================================
//
//	vCx[g֐
//
//=============================================================================
//-----------------------------------------------------------------------------
/**
 *@brief				Aj[Vf[^ǂݍ
 *		
 *@param	pSet	ZAN^[Zbg
 *@param	pHeaderFet@C̓\
 *@param	pWorkF\
 *		 	
 *@retval	TRUE F
 *@retval 	FALSEFs
 *
 */
 //----------------------------------------------------------------------------
static BOOL LoadData( const CLACT_SET* pSet, const CLACT_HEADER* pHeader, CLACT_WORK* pWork, int heap )
{
	//
	// Aj[VType𒲂ׂăAj[V̓ǂݍ݂
	// Aj[VType̎擾
	pWork->flag = getActType( pHeader );

	// vNVݒ
	pWork->ImageProxy = *pHeader->pImageProxy;
	// pbgf[^
	pWork->PaletteProxy = *pHeader->pPaletteProxy;

	// TypẽAj[Vǂݍ
	// Cellf[^
	LoadCell( pHeader->pCellBank, pWork );

	// CellAj[Vf[^
	if( pHeader->pAnimBank ){
		
		LoadCellAnm( pHeader->pAnimBank, pWork );
	}else{
		
		LoadCellAnm( pSet->pAnimBank, pWork );
	}

	// type}`ẐƂ
	if( pWork->flag == CLACT_MULTICELL ){
		// MultiCellf[^
		LoadMultiCell( pHeader->pMCBank, pWork );

		// MultiCellAj[Vf[^
		LoadMultiCellAnm( pHeader->pMCABank, pWork );

		// MultiCellAj[VRg[쐬
		MakeMultiCellAnm( pWork , heap);
	}else{
		// Vram]`FbN
		if( pWork->flag == CLACT_VRAM_CELL ){
			CLACT_VRAM_ANIM_DATA* p_vram = (CLACT_VRAM_ANIM_DATA*)&pWork->AnmData;
		
			
			// Z]Aj[VŃAj[VRg[쐬
			MakeCellAnmVram( pHeader, pWork, heap );
		}else{
			// ZAj[VRg[쐬
			MakeCellAnm( pWork, heap );
		}
	}

	// BGʂƂ̗DxZbg
	pWork->Priority = pHeader->priority;


	return TRUE;
}

//-----------------------------------------------------------------------------
/**
 *@brief				Aj[VType擾
 *
 *@param	pHeaderFAjf[^it@CpX̏W܂j
 *		
 *@return	Type̒l
 *
 */
 //----------------------------------------------------------------------------
static u32	getActType( const CLACT_HEADER* pHeader )
{
	//
	// t@C邩`FbNăAj[V@Ԃ
	//
	// }`ZAj[V`FbN
	if( pHeader->pMCBank != NULL ){
		return CLACT_MULTICELL;
	}

	// Vram]`FbN
	if( pHeader->flag == 1 ){
		return CLACT_VRAM_CELL;
	}

	return CLACT_CELL;
}




//-----------------------------------------------------------------------------
/**
 *@brief				Zf[^ǂݍ
 *
 *@param	p_strFt@CpX
 *@param	pWorkF\
 *
 *@return	none
 *
 */
 //----------------------------------------------------------------------------
static void LoadCell( const NNSG2dCellDataBank* Cell, CLACT_WORK* pWork )
{
	CLACT_ANIM_DATA*	pCell;	

	//
	// Zf[^擾
	//
	pCell = (CLACT_ANIM_DATA*)&pWork->AnmData;
	
	// f[^̐ݒ
	pCell->pCellBank = Cell;
}

//-----------------------------------------------------------------------------
/**
 *@brief				ZAj[Vf[^ǂݍ
 *
 *@param	p_strFt@CpX
 *@param	pWorkF\
 *
 *@return	none
 *
 */
 //----------------------------------------------------------------------------
static void LoadCellAnm( const NNSG2dCellAnimBankData* Anm, CLACT_WORK* pWork )
{
	CLACT_ANIM_DATA*	pCell;	

	//
	// Zf[^擾
	//
	pCell = (CLACT_ANIM_DATA*)&pWork->AnmData;
	
	// f[^̐ݒ
	pCell->pAnimBank = Anm;
}

//-----------------------------------------------------------------------------
/**
 *@brief			}`Z̓ǂݍ
 *				
 *@param	p_strFt@CpX
 *@param	pWorkF\
 *
 *@return	none
 *
 */
 //----------------------------------------------------------------------------
static void LoadMultiCell( const NNSG2dMultiCellDataBank* Mlt, CLACT_WORK* pWork )
{
	CLACT_MULTICELL_ANIM_DATA*	pMulti;		// }`Zp̃f[^擾p

	// }`Zp̃f[^擾
	pMulti = (CLACT_MULTICELL_ANIM_DATA*)&pWork->AnmData;

	// f[^ݒ
	pMulti->pMCBank = Mlt;
}

//-----------------------------------------------------------------------------
/**
 *@brief			}`ZAj[V̓ǂݍ
 *				
 *@param	p_strFt@CpX
 *@param	pWorkF\
 *
 *preturn	none
 *
 */
 //----------------------------------------------------------------------------
static void LoadMultiCellAnm( const NNSG2dMultiCellAnimBankData* Anm, CLACT_WORK* pWork )
{
	CLACT_MULTICELL_ANIM_DATA*	pMulti;		// }`Zp̃f[^擾p

	// }`Zp̃f[^擾
	pMulti = (CLACT_MULTICELL_ANIM_DATA*)&pWork->AnmData;

	// f[^̐ݒ
	pMulti->pMCABank = Anm;
}

//-----------------------------------------------------------------------------
/**
 *@brief			ZAj[V\z
 *
 *@param	pWorkF\
 *
 *@return	none
 *
 */
 //----------------------------------------------------------------------------
static void MakeCellAnm( CLACT_WORK* pWork, int heap )
{
	CLACT_ANIM_DATA*	pCell;			// Zf[^擾


	//
	// Zf[^擾
	//
	pCell = (CLACT_ANIM_DATA*)&pWork->AnmData;

	//
	// ZAj[V
	//
	NNS_G2dInitCellAnimation(
                (NNSG2dCellAnimation*)&pCell->AnmCtrl,
                NNS_G2dGetAnimSequenceByIdx(pCell->pAnimBank, 0),
                pCell->pCellBank );
}

//-----------------------------------------------------------------------------
/**
 *@brief			ZVram]Aj[V\z
 *
 *@param	pWorkF\
 *
 *@return	none
 *
 */
 //----------------------------------------------------------------------------
static void MakeCellAnmVram( const CLACT_HEADER* pHeader, CLACT_WORK* pWork , int heap)
{
	CLACT_VRAM_ANIM_DATA*	pCell;			// Zf[^擾
	const NNSG2dCharacterData* pCharData;	// LN^f[^

	//
	// Zf[^擾
	//
	pCell = (CLACT_VRAM_ANIM_DATA*)&pWork->AnmData;

	// ZAj[VVram]ǗIuWFNgnh擾
	pCell->CellTransManHandle = NNS_G2dGetNewCellTransferStateHandle();
	

	// LN^f[^ݒ
	pCharData = pHeader->pCharData;

	//
	// ZVram]Aj̏
	//
	NNS_G2dInitCellAnimationVramTransfered(
                (NNSG2dCellAnimation*)&pCell->AnmCtrl,
                NNS_G2dGetAnimSequenceByIdx(pCell->pAnimBank, 0),
                pCell->pCellBank,

                pCell->CellTransManHandle,  // ̃ZAj[VVRAM]Ǘ
											// Z]ԊǗIuWFNg̃nh
											// ȉ3 (1) Callback֐ dstAddr Ƃēn܂
				// ʏ ImageProxy Ɏw肵̂Ɠlw肵܂
                NNS_G2D_VRAM_ADDR_NONE ,		// eNX`]ItZbggp܂
                NNS_G2dGetImageLocation(&pWork->ImageProxy, NNS_G2D_VRAM_TYPE_2DMAIN),      // CʃLN^]ItZbg
                NNS_G2dGetImageLocation(&pWork->ImageProxy, NNS_G2D_VRAM_TYPE_2DSUB),		// TuʃLN^]ItZbg
                pCharData->pRawData,  // LN^f[^
                NULL,				  // eNX`f[^
                pCharData->szByte     // eNX`f[^ or LN^f[^̃TCY
            );
}

//-----------------------------------------------------------------------------
/**
 *@brief			}`ZAj[V\z
 *					sOɃZAj[V̍\zKv
 *
 *@param	pWorkF\
 *
 *@return	none
 *
 */
 //----------------------------------------------------------------------------
static void MakeMultiCellAnm( CLACT_WORK* pWork, int heap )
{
	CLACT_MULTICELL_ANIM_DATA*	pCell;			// Zf[^擾
	const NNSG2dMultiCellAnimSequence* pSequence;
    u16 numNodes;


	//
	// Zf[^擾
	//
	pCell = (CLACT_MULTICELL_ANIM_DATA*)&pWork->AnmData;

	
	// ĐV[PX擾
	pSequence = NNS_G2dGetAnimSequenceByIdx( pCell->pMCABank, 0 );

	// ̃}`Z̊eV[PXɕKvȃm[h̍ő吔擾
	numNodes = NNS_G2dGetMCBankNumNodesRequired( pCell->pMCBank );
	
	// q[v numNode Ԃ NNSG2dNode  NNSG2dCellAnimation 擾
    pCell->pNode     = sys_AllocMemory( heap, sizeof(NNSG2dNode) * numNodes );
    pCell->pCellAnim = sys_AllocMemory( heap, sizeof(NNSG2dCellAnimation) * numNodes );

	
	
	//
	// }`ZAj[VRg[\z
	// 
    NNS_G2dInitMCAnimation( (NNSG2dMultiCellAnimation*)&pCell->AnmCtrl,	// }`ZAj[V
                            pCell->pNode,			// m[hz
                            pCell->pCellAnim,		// ZAj[Vz
                            numNodes,				// m[h
                            pCell->pAnimBank,		// Aj[Vf[^oN
                            pCell->pCellBank,		// Zf[^oN
                            pCell->pMCBank );		// }`Zf[^oN


	// }`ZAj[VɍĐV[PXZbg
    NNS_G2dSetAnimSequenceToMCAnimation(
                (NNSG2dMultiCellAnimation*)&pCell->AnmCtrl,
                pSequence );

}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgvNV̂pbgio[擾
 *
 *@param	pPlttFpbgio[擾pbgvNV
 *@param	vramTypeFCʂTuʂ
 *
 *@return	pbgio[
 *
 */
//-----------------------------------------------------------------------------
static u32 GetPlttProxyOffset( const NNSG2dImagePaletteProxy* pPltt, u32 vramType )
{
	u32 size;			// PpbgTCY
	u32 pltt_offset;	// pbgio[vZp
	
	// gpbg`FbN
	if( pPltt->bExtendedPlt ){
		size = PLTT_ONE_SIZE * 16;
	}else{
		// W256łȂ`FbN
		if( pPltt->fmt == GX_TEXFMT_PLTT256 ){
			// 256̎̓TCYOɂČvZȂ
			size = 0;
		}else{
			size = PLTT_ONE_SIZE;
		}
	}

	// WQTUFȊO`FbN
	if( size != 0 ){
		// 炷l擾
		pltt_offset = NNS_G2dGetImagePaletteLocation( pPltt, vramType );
		pltt_offset /= size;			// 炷lɂ(pbg炷)
	}else{
		pltt_offset = 0;
	}

	return pltt_offset;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	_[gpxȕ`
 *
 *@param	pClActSet	ZAN^[Zbg
 *@param	act			AN^[|C^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void renderDraw(const CLACT_SET* pClActSet, CLACT_WORK* act)
{
	
	VecFx32	matrix = act->Matrix;
	
	// vLVo^
	NNS_G2dSetRendererImageProxy( pClActSet->pRender, &act->ImageProxy, &act->PaletteProxy );
	
	NNS_G2dBeginRendering( pClActSet->pRender );		// `Jn
	
	// `
	NNS_G2dPushMtx();{

		// AtBϊ@tbv[hݒ
		// AtBϊݒ
		NNS_G2dSetRndCoreAffineOverwriteMode(
				&( pClActSet->pRender->rendererCore ),
				act->affin );
		
		if(act->affin == CLACT_AFFINE_NONE){
			// tbvݒ
			NNS_G2dSetRndCoreFlipMode(
					&( pClActSet->pRender->rendererCore ),
					act->flip & CLACT_FLIP_H,
					act->flip & CLACT_FLIP_V);
		}else{
			// tbvݒ
			NNS_G2dSetRndCoreFlipMode(
					&( pClActSet->pRender->rendererCore ),
					FALSE,
					FALSE );
		}
		
		
		NNS_G2dTranslate( matrix.x, matrix.y, matrix.z );
		
		if(act->affin != CLACT_AFFINE_NONE){
			NNS_G2dTranslate( act->AffineMatrix.x, act->AffineMatrix.y, act->AffineMatrix.z );
			NNS_G2dScale( act->Scale.x, act->Scale.y, act->Scale.z );
			NNS_G2dRotZ( FX_SinIdx(act->Rotation), FX_CosIdx(act->Rotation) );
			NNS_G2dTranslate( -act->AffineMatrix.x, -act->AffineMatrix.y, -act->AffineMatrix.z );
		}

	
		// I[o[CgLtOݒ
		NNS_G2dSetRendererOverwriteEnable( pClActSet->pRender, act->over_write );

		// I[o[CgtOݒ
		NNS_G2dSetRendererOverwriteDisable( pClActSet->pRender, ~act->over_write );
		
		// pbgio[ݒ
		NNS_G2dSetRendererOverwritePlttNo( pClActSet->pRender, act->palNo );
		
		// pbgItZbgݒ
		NNS_G2dSetRendererOverwritePlttNoOffset( pClActSet->pRender, act->palOfs );

		// I[o[CgɃUCN̒lݒ
		NNS_G2dSetRendererOverwriteMosaicFlag( pClActSet->pRender, act->mosaic );

		// I[o[CgOBJ[h̒lݒ
		NNS_G2dSetRendererOverwriteOBJMode( pClActSet->pRender, act->objmode );

		// BGD揇ʂݒ
		NNS_G2dSetRendererOverwritePriority( pClActSet->pRender, act->Priority );
		
		// ZAj}`Zɂ߂`FbN
		if( (act->flag == CLACT_CELL) || (act->flag == CLACT_VRAM_CELL) ){
			CLACT_ANIM_DATA* anim = (CLACT_ANIM_DATA*)&act->AnmData;
			
			// `
			NNS_G2dDrawCellAnimation( &anim->AnmCtrl );
		}
		else{
			CLACT_MULTICELL_ANIM_DATA* anim = (CLACT_MULTICELL_ANIM_DATA*)&act->AnmData;

			// `
			NNS_G2dDrawMultiCellAnimation( &anim->AnmCtrl );
		}
	}
	NNS_G2dPopMtx();
	NNS_G2dEndRendering();					// `I
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`悵Ȃ
 *
 *	@param	pClActSet		ZAN^[Zbg
 *	@param	act				ZAN^[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void noDraw( const CLACT_SET* pClActSet, CLACT_WORK* act )
{
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I[gAj[V
 *
 *	@param	act			AN^[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void autoAnm( CLACT_WORK* act )
{
	// Aj[V
	CLACT_AnmFrameChg( act, act->Frame );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I[gAj[VȂ
 *
 *	@param	act		AN^[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void noAnm( CLACT_WORK* act )
{
}

/*-----------------------------------------------------------------------------
 *
 *		Xg
 * 
 *===========================================================================*/
//-----------------------------------------------------------------------------
/**
 *@brief			Xgɒǉ
 *
 *@param	cs			ZAN^[Zbg
 *@param	pWork		ǉZAN^[f[^
 *
 *@return	none
 *
 *
 */
 //----------------------------------------------------------------------------
static void addCellActList( CLACT_SET* cs, CLACT_WORK* pWork )
{
	CLACT_WORK* p_work;		// [vp
	
	
	// 擪JĂ邩`FbN
	if(cs->Dummy.pNext == &cs->Dummy){
		
		cs->Dummy.pNext	= pWork;
		cs->Dummy.pLast	= pWork;
		pWork->pLast			= &cs->Dummy;
		pWork->pNext			= &cs->Dummy;
	}else{
		
		// Ō̃f[^̗D揇ʂ̗D揇ʈȉȂŌɃZbg
		if(cs->Dummy.pLast->DrawPriority <= pWork->DrawPriority){
			
			pWork->pLast			= cs->Dummy.pLast;
			cs->Dummy.pLast->pNext	= pWork;
			pWork->pNext			= &cs->Dummy;
			cs->Dummy.pLast			= pWork;
		}else{
		
			// ̗D揇ʂ傫f[^̑Oɒǉ
			p_work = cs->Dummy.pNext;		// 擪f[^Zbg
			while(p_work != &cs->Dummy){		// _~[f[^ɂȂ܂
				// p_work̗D揇ʂpWork̗D揇ʂ葽Ƃ
				// p_work̑Oɓo^
				if(p_work->DrawPriority > pWork->DrawPriority){

					p_work->pLast->pNext	= pWork;
					pWork->pLast			= p_work->pLast;
					p_work->pLast			= pWork;
					pWork->pNext			= p_work;
					break;
				}

				p_work = p_work->pNext;
			}
		}
	}
}

//-----------------------------------------------------------------------------
/**
 *@brief			Xg폜
 *
 *@param	pWork		폜ZAN^[f[^
 *
 *@return	none
 *
 *
 */
 //----------------------------------------------------------------------------
static void dellCellActList( CLACT_WORK* pWork )
{
	// XgO
	pWork->pLast->pNext = pWork->pNext;
	pWork->pNext->pLast = pWork->pLast;
}

//-------------------------------------
//	stack̏
//=====================================
//-----------------------------------------------------------------------------
/**
 *
 *	@brief	X^bN
 *
 *	@param	pSet		X^bNf[^i[
 *	@return none
 *
 */
//-----------------------------------------------------------------------------
static void initStack(CLACT_SET* pSet)
{
	int i;

	// 
	for (i=0; i<pSet->WorkNum; i++) {
		CLACT_WorkClear(&pSet->pWork[i]);
		pSet->ppWorkStack[i] = pSet->pWork + i;
	}
	pSet->WorkStackNow = 0;
}

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	X^bNo
 *
 *	@param	pSet		X^bNf[^i[
 *	
 *	@retval	NULLȊO	r{[h[N
 *	@retval	NULL		oɎsiX^bN󂾂ꍇj
 *
 */
//-----------------------------------------------------------------------------
static CLACT_WORK* popStack(CLACT_SET* pSet)
{
	CLACT_WORK*	ret;
	
	// ~bg`FbN
	if(pSet->WorkStackNow >= pSet->WorkNum){
		return NULL;
	}

	ret = pSet->ppWorkStack[pSet->WorkStackNow];
	pSet->WorkStackNow++;

	return ret;
}

//-----------------------------------------------------------------------------
/**
 *
 *	@brief	X^bNɊi[
 *
 *	@param	pSet		X^bNf[^i[
 *	@param	pDat		i[f[^
 *	
 *	@retval	TRUE		
 *	@retval	FALSE		X^bNς
 */
//-----------------------------------------------------------------------------
static BOOL pushStack(CLACT_SET* pSet, CLACT_WORK* pDat)
{
	if(pSet->WorkStackNow <= 0){	// 󂫃`FbN
		return FALSE;
	}
	CLACT_WorkClear(pDat);
	pSet->WorkStackNow--;
	pSet->ppWorkStack[pSet->WorkStackNow] = pDat;

	return TRUE;
}
