//=============================================================================================
/**
 * @file	debug_3d_draw_count.c
 * @brief	fobOp`֘AJEgi|SƂj
 */
//=============================================================================================
#ifdef PM_DEBUG

#include <nitro.h>
#include <nnsys.h>
#include "debug_3d_draw_count.h"

//----- |S`̉񐔂𒲂ׂ邽߂DEBUG
typedef struct{
	int NNS_AddVertexNum;
	int NNS_AddPolygonNum;
	int NNS_AddDrawNum;
	int VertexNum;
	int PolygonNum;
	int DrawNum;

	int TexBlock;
	int PlttBlock;

	NNSiGfdLnkVramBlock *texture_p;
	NNSiGfdLnkVramBlock *pal_p;
}DEBUG_DRAW_COUNT;

static DEBUG_DRAW_COUNT DebugDrawCount;

//------------------------------------------------------------------
/**
 * 3D`̂߂ɒׂlޔ
 *
*/
//------------------------------------------------------------------
void D_3D_DC_DrawPolygonCountUp(void)
{
	DebugDrawCount.NNS_AddVertexNum  = DebugDrawCount.VertexNum;
	DebugDrawCount.NNS_AddPolygonNum = DebugDrawCount.PolygonNum;
	DebugDrawCount.NNS_AddDrawNum       = DebugDrawCount.DrawNum;

	DebugDrawCount.VertexNum  = 0;
	DebugDrawCount.PolygonNum = 0;
	DebugDrawCount.DrawNum    = 0;
}

//------------------------------------------------------------------
/**
 * NITROSYSTEMɓn|S̐Ԃ
 *
 * @param	int |S
*/
//------------------------------------------------------------------
int D_3D_DC_DrawPolygonGet(void)
{
	return DebugDrawCount.NNS_AddPolygonNum;
}

//------------------------------------------------------------------
/**
 * NITROSYSTEMɓn_̐Ԃ
 *
 * @param	int	_
*/
//------------------------------------------------------------------
int D_3D_DC_DrawVertexGet(void)
{
	return DebugDrawCount.NNS_AddVertexNum;
} 

//------------------------------------------------------------------
/**
 * NITROSYSTEM|S`悵񐔂Ԃ
 *
 * @return	int	`搔
*/
//------------------------------------------------------------------
int D_3D_DC_DrawNumGet(void)
{
	return DebugDrawCount.NNS_AddDrawNum;
}

//==============================================================================
/**
 * Nhuq`l}l[W[ƃpbg}l[W[̃|C^ۑ
 *
 * @param   texp		eNX`}l[W[
 * @param   palp		pbg}l[W[
 * @param	inTexBlock	eNX`ubNTCY
 * @param	inPlttBlockSize	pbgubNTCY
 *
 * @retval  none		
 */
//==============================================================================
void D_3D_DC_VramManPSet(NNSiGfdLnkVramBlock *texp, NNSiGfdLnkVramBlock *palp,
						const int inTexBlock, const int inPlttBlock)
{
	DebugDrawCount.texture_p = texp;
	DebugDrawCount.pal_p     = palp;
	DebugDrawCount.TexBlock  = inTexBlock;
	DebugDrawCount.PlttBlock  = inPlttBlock;
}

//==============================================================================
/**
 * VRAMւ̃eNX`]Ԃ擾
 *
 *
 * @retval  int		gpĂuq`le
 */
//==============================================================================
int  D_3D_DC_VramTexSizeGet(void)
{
	int size = 0;
	int i;
	
	NNSiGfdLnkVramBlock *tex = DebugDrawCount.texture_p;
	
	
	for(i=0;i<DebugDrawCount.TexBlock;i++){
		//NhVRAM}l[W[̐擪T
		if((tex->pBlkPrev==0 && tex->pBlkNext!=0) || (tex->pBlkPrev==0 && tex->pBlkNext==0)){		
			break;
		}
		tex++;
	}

	while(tex->pBlkNext!=0){	// N葫Ď֓nĂ
		size += tex->szByte;
		tex = (NNSiGfdLnkVramBlock *)tex->pBlkNext;
	}
	size += tex->szByte;		//Ō̃NVRAM]

	// VRAM}l[W[ۑĂ̂́ugpĂȂʁvȂ̂őʂĕԂ
	return (DebugDrawCount.TexBlock*1024)-size;	
}


//==============================================================================
/**
 * NhPAL}l[W[̓]Ԃ擾
 *
 *
 * @retval  int		NhPAL}l[W[̓]oCg
 */
//==============================================================================
int  D_3D_DC_VramPalSizeGet(void)
{
	int size = 0;
	int i;
	
	NNSiGfdLnkVramBlock *tex = DebugDrawCount.pal_p;
	
	
	for(i=0;i<DebugDrawCount.PlttBlock;i++){
		//NhPALL}l[W[̐擪T
		if((tex->pBlkPrev==0 && tex->pBlkNext!=0) || (tex->pBlkPrev==0 && tex->pBlkNext==0)){		
			break;
		}
		tex++;
	}

	while(tex->pBlkNext!=0){	// N葫Ď֓nĂ
		size += tex->szByte;
		tex = (NNSiGfdLnkVramBlock *)tex->pBlkNext;
	}
	size += tex->szByte;		//Ō̃NVRAM]

	// PAL}l[W[ۑĂ̂́ugpĂȂʁvȂ̂őʂĕԂ
	return (DebugDrawCount.PlttBlock*1024)-size;	
}

//==============================================================================
/**
 * JEgAbv
 *
 * @param   object_p		_[nai		
 *
 * @retval  none
 */
//==============================================================================
void D_3D_DC_CountNum(NNSG3dRenderObj* object_p)
{
	//fOf[^\[X璸_擾đ
	DebugDrawCount.VertexNum  += object_p->resMdl->info.numVertex;
	//fOf[^\[X|S擾đ
	DebugDrawCount.PolygonNum += object_p->resMdl->info.numPolygon;		
	DebugDrawCount.DrawNum++;
}

#endif	//PM_DEBUG

