//=============================================================================================
/**
 * @file	display.c                                                  
 * @brief	\VXeݒ
 */
//=============================================================================================
#include <nitro.h>
#include <nnsys.h>

#define	__DISPLAY_H_GLOBAL
#include "display.h"
#include "system.h"

//=============================================================================================
//	vg^Cv錾
//=============================================================================================
//=============================================================================================
//	[Jϐ錾
//=============================================================================================
static	int				MainVisiblePlane;
static	int				SubVisiblePlane;

//=============================================================================================
//	ݒ֐
//=============================================================================================
//--------------------------------------------------------------------------------------------
/**
 * uq`loNS̐ݒ
 *
 * @param	data	ݒf[^
 */
//--------------------------------------------------------------------------------------------
void	GF_Disp_SetBank( const GF_BGL_DISPVRAM* dispvram )
{
	// VRAMݒ胊Zbg
	GX_ResetBankForBG();			// C2DGWBG
	GX_ResetBankForBGExtPltt();		// C2DGWBGgpbg
	GX_ResetBankForSubBG();			// Tu2DGWBG
	GX_ResetBankForSubBGExtPltt();	// Tu2DGWBGgpbg
	GX_ResetBankForOBJ();			// C2DGWOBJ
	GX_ResetBankForOBJExtPltt();	// C2DGWOBJgpbg
	GX_ResetBankForSubOBJ();		// Tu2DGWOBJ
	GX_ResetBankForSubOBJExtPltt();	// Tu2DGWOBJgpbg
	GX_ResetBankForTex();			// eNX`C[W
	GX_ResetBankForTexPltt();		// eNX`pbg

	GX_SetBankForBG( dispvram->main_bg );
	GX_SetBankForBGExtPltt( dispvram->main_bg_expltt );

	GX_SetBankForSubBG( dispvram->sub_bg );
	GX_SetBankForSubBGExtPltt( dispvram->sub_bg_expltt );

	GX_SetBankForOBJ( dispvram->main_obj );
	GX_SetBankForOBJExtPltt( dispvram->main_obj_expltt );

	GX_SetBankForSubOBJ( dispvram->sub_obj );
	GX_SetBankForSubOBJExtPltt( dispvram->sub_obj_expltt );

	GX_SetBankForTex( dispvram->teximage );
	GX_SetBankForTexPltt( dispvram->texpltt );
}

//--------------------------------------------------------------------------------------------
/**
 * Cʂ̊eʂ̕\Rg[
 *
 * @param	
 */
//--------------------------------------------------------------------------------------------
void GF_Disp_GX_VisibleControlInit( void )
{
	MainVisiblePlane = 0;
	//GX_SetVisiblePlane( MainVisiblePlane );
}

//--------------------------------------------------------------------------------------------
/**
 * Cʂ̊eʂ̕\Rg[
 *
 * @param	gxplanemask		ݒ
 * @param	flg				Rg[tO
 *
 * @li	flg = VISIBLE_ON	: \
 * @li	flg = VISIBLE_OFF	: \
 */
//--------------------------------------------------------------------------------------------
void GF_Disp_GX_VisibleControl( u8 gxplanemask, u8 flg )
{
	if( flg == VISIBLE_ON ){
		if( MainVisiblePlane & gxplanemask ){ return; }
	}else{
		if( !(MainVisiblePlane & gxplanemask) ){ return; }
	}
	MainVisiblePlane ^= gxplanemask;
	GX_SetVisiblePlane( MainVisiblePlane );
}

//--------------------------------------------------------------------------------------------
/**
 * Cʂ̊eʂ̕\Rg[iAƂj
 *
 * @param	prm		\p[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GF_Disp_GX_VisibleControlDirect( int prm )
{
	MainVisiblePlane = prm;
	GX_SetVisiblePlane( MainVisiblePlane );
}

//--------------------------------------------------------------------------------------------
/**
 * Tuʂ̊eʂ̕\Rg[
 *
 * @param	
 */
//--------------------------------------------------------------------------------------------
void GF_Disp_GXS_VisibleControlInit( void )
{
	SubVisiblePlane = 0;
	//GXS_SetVisiblePlane( MainVisiblePlane );
}

//--------------------------------------------------------------------------------------------
/**
 * Tuʂ̊eʂ̕\Rg[
 *
 * @param	gxplanemask		ݒ
 * @param	flg				Rg[tO
 *
 * @li	flg = VISIBLE_ON	: \
 * @li	flg = VISIBLE_OFF	: \
 */
//--------------------------------------------------------------------------------------------
void GF_Disp_GXS_VisibleControl( u8 gxplanemask, u8 flg )
{
	if( flg == VISIBLE_ON ){
		if( SubVisiblePlane & gxplanemask ){ return; }
	}else{
		if( !(SubVisiblePlane & gxplanemask) ){ return; }
	}
	SubVisiblePlane ^= gxplanemask;
	GXS_SetVisiblePlane( SubVisiblePlane );
}

//--------------------------------------------------------------------------------------------
/**
 * Tuʂ̊eʂ̕\Rg[iAƂj
 *
 * @param	prm		\p[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GF_Disp_GXS_VisibleControlDirect( int prm )
{
	SubVisiblePlane = prm;
	GXS_SetVisiblePlane( SubVisiblePlane );
}

//--------------------------------------------------------------------------------------------
/**
 * \Lݒ
 *
 * @param	none
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void	GF_Disp_DispOn( void )
{
	GX_DispOn();
	GXS_DispOn();
}

//--------------------------------------------------------------------------------------------
/**
 * \ݒ
 *
 * @param	none
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void	GF_Disp_DispOff( void )
{
	GX_DispOff();
	GXS_DispOff();
}


//--------------------------------------------------------------------------------------------
/**
 * ʂ̕\TChݒ
 *
 * @param	
 */
//--------------------------------------------------------------------------------------------
void GF_Disp_DispSelect( void )
{
	if(sys.disp3DSW == DISP_3D_TO_MAIN){
		GX_SetDispSelect(GX_DISP_SELECT_MAIN_SUB);
	}else{
		GX_SetDispSelect(GX_DISP_SELECT_SUB_MAIN);
	}
}


//--------------------------------------------------------------------------------------------
/**
 * Cʂ̕\󋵎擾
 *
 * @param	none
 * @return	none
 */
//--------------------------------------------------------------------------------------------
int GF_Disp_MainVisibleGet(void)
{
	return MainVisiblePlane;
}

//--------------------------------------------------------------------------------------------
/**
 * Tuʂ̕\󋵎擾
 *
 * @param	none
 * @return	none
 */
//--------------------------------------------------------------------------------------------
int GF_Disp_SubVisibleGet(void)
{
	return SubVisiblePlane;
}
