//=============================================================================================
/**
 * @file	fontdata_man.c
 * @brief	tHgf[^}l[W
 * @author	taya
 * @date	2005.09.14
 */
//=============================================================================================
#include	"common.h"
#include	"bg_system.h"
#include	"fntsys.h"
#include	"gflib\fontdata_man.h"

#include	"system\arc_tool.h"

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/06/26
#include	"system\font_arc.h"
// ----------------------------------------------------------------------------

typedef u8 (*pWidthGetFunc)(const GF_FONTDATA_MAN*, u32);
typedef void (*pGetBitmapFunc)(const GF_FONTDATA_MAN*, STRCODE, MSG_FONT_DATA* );


enum {
	SRC_CHAR_SIZE = 0x10,
	SRC_CHAR_MAX = 4,

	SRC_CHAR_MAXSIZE = SRC_CHAR_SIZE*SRC_CHAR_MAX,

#if PM_LANG == LANG_KOREA
	WIDTH_PROPOTIONAL = -1,
#endif
};

// P̃LTCY
enum {
	LETTERSIZE_1x1 = 0,
	LETTERSIZE_1x2,
	LETTERSIZE_2x1,
	LETTERSIZE_2x2,
};

//------------------------------------------------------------------
/**
 * tHgf[^wb_
 */
//------------------------------------------------------------------
typedef struct {
	u32		bitDataOffs;	// f[^擪tHgf[^e[uւ̃oCgPʃItZbg
	u32		widthTblOffs;	// f[^擪當e[uւ̃oCgPʃItZbgie[u΂Oj
	u32		letterMax;		// o^
	u8		maxWidth;		// ő啶ihbgj
	u8		maxHeight;		// ő啶ihbgj
	u8		letterCharX;	// P̉L
	u8		letterCharY;	// P̏cL
}FONTDATA_HEADER;


typedef struct {

	ARCHANDLE*    file_handle;
	u8            read_buffer[SRC_CHAR_MAXSIZE];


}FILEREAD_TYPE_WORK;

//------------------------------------------------------------------
/**
 * }l[W[N
 */
//------------------------------------------------------------------
struct  _GF_FONTDATA_MAN	{
	FONTDATA_LOADTYPE        loadType;
	pGetBitmapFunc           GetBitmapFunc;

	u32                      charShape;
	u32                      letterCharSize;

	u8*                      fontBitData;
	u8                       readBuffer[SRC_CHAR_MAXSIZE];

	ARCHANDLE*               fileHandle;
	u32                      fileDatID;

	FONTDATA_HEADER          fontHeader;
	BOOL                     fixedFontFlag;

	pWidthGetFunc            WidthGetFunc;
	u8*                      widthTbl;
};



//==============================================================
// Prototype
//==============================================================
static void load_font_header( GF_FONTDATA_MAN* wk, u32 arcID, u32 datID, BOOL fixedFontFlag, u32 heapID );
static void unload_font_header( GF_FONTDATA_MAN* wk );
static void setup_font_datas( GF_FONTDATA_MAN* wk, FONTDATA_LOADTYPE loadType, u32 heapID );
static void setup_type_on_memory( GF_FONTDATA_MAN* wk, u32 heapID );
static void setup_type_read_file( GF_FONTDATA_MAN* wk, u32 heapID );
static void cleanup_font_datas( GF_FONTDATA_MAN* wk );
static void cleanup_type_on_memory( GF_FONTDATA_MAN* wk );
static void cleanup_type_read_file( GF_FONTDATA_MAN* wk );
static void GetBitmapOnMemory( const GF_FONTDATA_MAN* wk, STRCODE fcode, MSG_FONT_DATA* dst );
static void GetBitmapFileRead( const GF_FONTDATA_MAN* wk, STRCODE fcode, MSG_FONT_DATA* dst );
static u8 GetWidthProportionalFont( const GF_FONTDATA_MAN* wk, u32 bcode );
static u8 GetWidthFixedFont( const GF_FONTDATA_MAN* wk, u32 bcode );

#if PM_LANG == LANG_KOREA
static void SetPixelToFontData(int x, int y, int color, MSG_FONT_DATA *dst);
static void GetBitmapOnMemoryOldFont(const GF_FONTDATA_MAN *wk, STRCODE fcode, MSG_FONT_DATA *dst, STRCODE fcode_offset, u8 *fontdata);
static void GetBitmapOnMemoryHangul(const GF_FONTDATA_MAN *wk, STRCODE fcode, MSG_FONT_DATA *dst, STRCODE fcode_offset, u8 *fontdata);
#endif


//==============================================================================================
/**
 * tHgf[^}l[W쐬
 *
 * @param   arcID			tHgf[^i[ĂA[JCuID
 * @param   datID			tHgf[^i[ĂA[JCut@CID
 * @param   loadType		tHgf[^̓ǂݏo
 * @param   fixedFontFlag	TRUEȂ瓙tHgƂĈ
 * @param   heapID			}l[W쐬q[vID
 *
 * @retval  GF_FONTDATA_MAN*	tHgf[^}l[W|C^
 *
 * @li  loadType  FONTDATA_LOADTYPE_ON_MEMORY ̏ꍇA}l[WƓq[v̈ɃtHgf[^ǂݍ
 */
//==============================================================================================
GF_FONTDATA_MAN* FontDataMan_Create( u32 arcID, u32 datID, FONTDATA_LOADTYPE loadType, BOOL fixedFontFlag, u32 heapID )
{
	GF_FONTDATA_MAN* wk = sys_AllocMemory( heapID, sizeof(GF_FONTDATA_MAN) );
	if( wk )
	{
		load_font_header( wk, arcID, datID, fixedFontFlag, heapID );
		setup_font_datas( wk, loadType, heapID );
	}
	return wk;
}
//==============================================================================================
/**
 * tHgf[^}l[W폜
 *
 * @param   wk		tHgf[^}l[W̃|C^
 *
 */
//==============================================================================================
void FontDataMan_Delete( GF_FONTDATA_MAN* wk )
{
	cleanup_font_datas( wk );
	unload_font_header( wk );
	sys_FreeMemoryEz( wk );
}
//==============================================================================================
/**
 * tHgrbgf[^̓ǂݍ݃^CvύX
 *
 * @param   wk			tHgf[^}l[W|C^
 * @param   loadType	ύX̓ǂݍ݃^Cv
 *
 */
//==============================================================================================
void FontDataMan_ChangeLoadType( GF_FONTDATA_MAN* wk, FONTDATA_LOADTYPE loadType, u32 heapID )
{
	if( wk->loadType != loadType )
	{
		cleanup_font_datas( wk );
		setup_font_datas( wk, loadType, heapID );
	}
}




//------------------------------------------------------------------
/**
 * ^CvŋLwb_f[^ǂݍ݁E\z
 *
 * @param   wk				[N|C^
 * @param   arcID			tHgt@C̃A[JCuID
 * @param   datID			tHgt@C̃f[^ID
 * @param   fixedFontFlag	ŒtHgtO
 * @param   heapID			q[vID
 *
 */
//------------------------------------------------------------------
static void load_font_header( GF_FONTDATA_MAN* wk, u32 arcID, u32 datID, BOOL fixedFontFlag, u32 heapID )
{
	wk->fileHandle = ArchiveDataHandleOpen( arcID, heapID );
	if( wk->fileHandle )
	{
		ArchiveDataLoadOfsByHandle( wk->fileHandle, datID, 0, sizeof(FONTDATA_HEADER), &(wk->fontHeader) );

		wk->fixedFontFlag = fixedFontFlag;
		if( fixedFontFlag )
		{
			wk->widthTbl = NULL;
			wk->WidthGetFunc = GetWidthFixedFont;
		}
		else
		{
			GF_ASSERT(wk->fontHeader.widthTblOffs);
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/19
#if PM_LANG == LANG_KOREA
			{
				u32 size;
				ArchiveDataLoadOfsByHandle( wk->fileHandle, datID, wk->fontHeader.widthTblOffs,
							sizeof(u32), (void*)&size );
				wk->widthTbl = sys_AllocMemory( heapID, size );
				wk->WidthGetFunc = GetWidthProportionalFont;
				ArchiveDataLoadOfsByHandle( wk->fileHandle, datID, wk->fontHeader.widthTblOffs + sizeof(u32),
							size, (void*)(wk->widthTbl) );
			}
#else
			wk->widthTbl = sys_AllocMemory( heapID, wk->fontHeader.letterMax );
			wk->WidthGetFunc = GetWidthProportionalFont;
			ArchiveDataLoadOfsByHandle( wk->fileHandle, datID, wk->fontHeader.widthTblOffs,
						wk->fontHeader.letterMax, (void*)(wk->widthTbl) );
#endif
// ----------------------------------------------------------------------------
		}


		{
			static const u8 charShapeTbl[2][2] = {
				{  LETTERSIZE_1x1, LETTERSIZE_1x2 },
				{  LETTERSIZE_2x1, LETTERSIZE_2x2 },
			};

			GF_ASSERT( wk->fontHeader.letterCharX <= 2 && wk->fontHeader.letterCharY <= 2 );

			wk->charShape = charShapeTbl[ wk->fontHeader.letterCharX-1 ][ wk->fontHeader.letterCharY-1 ];
			wk->letterCharSize = SRC_CHAR_SIZE * wk->fontHeader.letterCharX * wk->fontHeader.letterCharY;
		}

		wk->fileDatID = datID;
	}
}
//------------------------------------------------------------------
/**
 * \zwb_f[^̉
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void unload_font_header( GF_FONTDATA_MAN* wk )
{
	if( wk->widthTbl )
	{
		sys_FreeMemoryEz( wk->widthTbl );
	}
	if( wk->fileHandle )
	{
		ArchiveDataHandleClose( wk->fileHandle );
	}
}



//------------------------------------------------------------------
/**
 * ǗtHgf[^̓ǂݍݏ
 *
 * @param   wk				}l[W[N|C^
 * @param   loadType		ǂݍ݃^Cv
 * @param   heapID			풓^Cv̏ꍇAtHgrbgf[^mۗpq[v̎wB
 *							t@C[h^Cv̏ꍇAgpȂ
 *
 */
//------------------------------------------------------------------
static void setup_font_datas( GF_FONTDATA_MAN* wk, FONTDATA_LOADTYPE loadType, u32 heapID )
{
	static void (* const setup_func[])( GF_FONTDATA_MAN*, u32 ) = {
		setup_type_on_memory,
		setup_type_read_file,
	};

	wk->loadType = loadType;

	setup_func[loadType]( wk, heapID );
}
//------------------------------------------------------------------
/**
 * ǗtHgf[^̓ǂݍݏirbgf[^풓^Cvj
 *
 * @param   wk				}l[W[N|C^
 * @param   heapID			rbgf[^̈mۗp̃q[vID
 */
//------------------------------------------------------------------
static void setup_type_on_memory( GF_FONTDATA_MAN* wk, u32 heapID )
{
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/20
// 풓pkoCiɑΉ
#if PM_LANG == LANG_KOREA
	u32 fileDatID;

	GF_ASSERT((wk->fileDatID == NARC_font_system_dat) || (wk->fileDatID == NARC_font_talk_dat));

	switch (wk->fileDatID) {
		case NARC_font_system_dat:
			fileDatID = NARC_font_compsystem_dat;
			break;
		case NARC_font_talk_dat:
			fileDatID = NARC_font_comptalk_dat;
			break;
		default:	// ɗꍇ͎O ASSERT ɂ
			fileDatID = NARC_font_compsystem_dat;
			break;
	}

	wk->fontBitData = ArchiveDataLoadAllocByHandle( wk->fileHandle, fileDatID, heapID);
	wk->GetBitmapFunc = GetBitmapOnMemory;
#else
//	void* fontData = ArcUtil_Load( arcID, datID, FALSE, heapID, ALLOC_TOP );
	u32  bit_data_size = wk->letterCharSize * wk->fontHeader.letterMax;

	wk->fontBitData = sys_AllocMemory( heapID, bit_data_size );
	wk->GetBitmapFunc = GetBitmapOnMemory;

	ArchiveDataLoadOfsByHandle( wk->fileHandle, wk->fileDatID, wk->fontHeader.bitDataOffs,
						bit_data_size, wk->fontBitData );
#endif
// ----------------------------------------------------------------------------
}
//------------------------------------------------------------------
/**
 * ǗtHgf[^̓ǂݍݏirbgf[^ǂݏo^Cvj
 *
 * @param   wk				}l[W[N|C^
 * @param   heapID			gpȂ
 */
//------------------------------------------------------------------
static void setup_type_read_file( GF_FONTDATA_MAN* wk, u32 heapID )
{
	wk->GetBitmapFunc = GetBitmapFileRead;
}

//------------------------------------------------------------------
/**
 * ǂݍ񂾃tHgf[^̔j
 *
 * @param   wk		tHgf[^}l[W|C^
 *
 */
//------------------------------------------------------------------
static void cleanup_font_datas( GF_FONTDATA_MAN* wk )
{
	static void (* const cleanup_func[])( GF_FONTDATA_MAN* ) = {
		cleanup_type_on_memory,
		cleanup_type_read_file,
	};

	cleanup_func[ wk->loadType ]( wk );
}
//------------------------------------------------------------------
/**
 * ǂݍ񂾃tHgf[^̔jirbgf[^풓^Cvj
 *
 * @param   wk		tHgf[^}l[W|C^
 *
 */
//------------------------------------------------------------------
static void cleanup_type_on_memory( GF_FONTDATA_MAN* wk )
{
	sys_FreeMemoryEz( wk->fontBitData );
	wk->fontBitData = NULL;
}
//------------------------------------------------------------------
/**
 * ǂݍ񂾃tHgf[^̔jirbgf[^ǂݍ݃^Cvj
 *
 * @param   wk		tHgf[^}l[W|C^
 *
 */
//------------------------------------------------------------------
static void cleanup_type_read_file( GF_FONTDATA_MAN* wk )
{
	
}



//==============================================================================================
//==============================================================================================


//==============================================================================================
/*
 *	rbg}bvf[^擾
 *
 * @param	wk			tHgf[^}l[W
 * @param	fcode		R[h
 * @param	dst			擾ʃ[N
 *
 */
//==============================================================================================
void FontDataMan_GetBitmap( const GF_FONTDATA_MAN* wk, STRCODE fcode, MSG_FONT_DATA* dst )
{
	if( fcode <= wk->fontHeader.letterMax )
	{
		fcode--;
		wk->GetBitmapFunc( wk, fcode, dst );
	}
	else
	{
		dst->size_x = 0;
		dst->size_y = 0;
	}
}

//------------------------------------------------------------------
/**
 * rbg}bvf[^擾irbgf[^풓^Cvj
 *
 * @param   wk			[N|C^
 * @param   fcode		R[h
 * @param   dst			rbgf[^ǂݍݐobt@
 *
 */
//------------------------------------------------------------------
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/20
// 풓pkoCiɑΉ

#if PM_LANG == LANG_KOREA

typedef struct {
	u16 maxCode;			// 2 bytes
	union {					// 2 bytes
		u16 dataType;		// sNZe[uł͈k`i[
		s16 width;			// e[uł̓sNZi[i-1Ȃv|[Vij
	};
	u32 dataOffset;			// 4 bytes
} FONT_AREA;				// 8 bytes

typedef struct {
	u16 letterNum;			// 2 bytes
	u8  width;				// 1 byte
	u8  partsSetNum;		// 1 byte
} HANGULFONT_HEADER;		// 4 bytes

typedef struct {
	u8  x;					//  1 byte
	u8  y;					//  1 byte
	u8  width;				//  1 byte
	u8  height;				//  1 byte
	u16 partsNum;			//  2 bytes
	u8  bitDataSize;		//  1 byte
	u8  partIdSize;			//  1 byte
	u32 bitDataTableAddr;	//  4 bytes
	u32 partIdTableAddr;	//  4 bytes
} PARTSSET_HEADER;			// 16 bytes

static void SetPixelToFontData(int x, int y, int color, MSG_FONT_DATA *dst) {
	int data_index  = (x % 8 + y % 8 * 8) / 2 + (x / 8 + y / 8 * 2) * 0x20;

	if (x % 2 == 0) {
		dst->data[data_index] &= 0xF0;
		dst->data[data_index] |= color;
	} else {
		dst->data[data_index] &= 0x0F;
		dst->data[data_index] |= color << 4;
	}
}

// Bł܂ł̕\
static void GetBitmapOnMemoryOldFont(const GF_FONTDATA_MAN *wk, STRCODE fcode, MSG_FONT_DATA *dst, STRCODE fcode_offset, u8 *fontdata) {
	int i;
	int letter_num         = * (u16 *)fontdata;
	int letter_data_offset = *((u16 *)fontdata + 1 + fcode);
	u8 *letter_data        = fontdata + letter_data_offset;

	GF_ASSERT(fcode_offset == 0);

	// GetBitmapOnMemory() Ɠd`FbNɂȂ邪Ô
	if (fcode >= letter_num) {
		dst->size_x = 0;
		dst->size_y = 0;
		return;
	}

	for (i = 0; i < 0x20*4; ++i) dst->data[i] = 0;

	{
		int x;
		int y      = *letter_data++;
		int right  = wk->WidthGetFunc(wk, fcode);
		int bottom = y + *letter_data++;
		int bit_shift = 0;
		int color[4];

		color[0] = 0;
		color[1] = FntDataColorGet(COLOR_F);
		color[2] = FntDataColorGet(COLOR_S);
		color[3] = FntDataColorGet(COLOR_B);

		for (; y < bottom; ++y) {
			for (x = 0; x < right; ++x) {
				int color_index = (*letter_data >> bit_shift) & 0x03;
				SetPixelToFontData(x, y, color[color_index], dst);
				bit_shift += 2;
				if (bit_shift == 8) {
					bit_shift = 0;
					letter_data++;
				}
			}
		}

		dst->size_x = right;
		dst->size_y = wk->fontHeader.maxHeight;
	}
}

// iƂɕnOtHg\
static void GetBitmapOnMemoryHangul(const GF_FONTDATA_MAN *wk, STRCODE fcode, MSG_FONT_DATA *dst, STRCODE fcode_offset, u8 *fontdata) {
	int i;
	HANGULFONT_HEADER *hangul_font_header;
	u32               *parts_set_offset;
	int color_f, color_s;

	GF_ASSERT(fcode >= fcode_offset);
	fcode -= fcode_offset;

	hangul_font_header = (HANGULFONT_HEADER *)fontdata;

	// GetBitmapOnMemory() Ɠd`FbNɂȂ邪Ô
	if (fcode >= hangul_font_header->letterNum) {
		dst->size_x = 0;
		dst->size_y = 0;
		return;
	}

	parts_set_offset = (u32 *)(fontdata + sizeof(HANGULFONT_HEADER));

	color_f = FntDataColorGet(COLOR_F);
	color_s = FntDataColorGet(COLOR_S);

	for (i = 0; i < 0x20*4; ++i) dst->data[i] = 0;

	for (i = 0; i < hangul_font_header->partsSetNum; ++i) {
		int part_id;
		u8 *bit_data;
		PARTSSET_HEADER *parts_set_header = (PARTSSET_HEADER *)(fontdata + parts_set_offset[i]);

		switch (parts_set_header->partIdSize) {
			case 1:
				part_id = *((u8  *)((u32)fontdata + parts_set_header->partIdTableAddr) + fcode);
				break;
			case 2:
				part_id = *((u16 *)((u32)fontdata + parts_set_header->partIdTableAddr) + fcode);
				break;
			default:
				GF_ASSERT(0);
		}

		bit_data = (u8 *)((u32)fontdata + parts_set_header->bitDataTableAddr + parts_set_header->bitDataSize * part_id);

		{
			int m, n;
			int bit_shift = 0;
			int y = parts_set_header->y;

			for (n = parts_set_header->height; n; --n) {
				int x = parts_set_header->x;
				for (m = parts_set_header->width; m; --m) {
					int color = (*bit_data >> bit_shift) & 1;
					if (color) {
						SetPixelToFontData(x,   y,   color_f, dst);
						SetPixelToFontData(x+1, y,   color_s, dst);
						SetPixelToFontData(x,   y+1, color_s, dst);
						SetPixelToFontData(x+1, y+1, color_s, dst);
					}
					bit_shift++;
					if (bit_shift == 8) {
						bit_shift = 0;
						bit_data++;
					}
					++x;
				}
				++y;
			}
		}
	}

	dst->size_x = hangul_font_header->width;
	dst->size_y = wk->fontHeader.maxHeight;
}

#endif

static void GetBitmapOnMemory( const GF_FONTDATA_MAN* wk, STRCODE fcode, MSG_FONT_DATA* dst )
{
#if PM_LANG == LANG_KOREA

	static void (*const GetBitmapOnMemoryAct[])(const GF_FONTDATA_MAN *, STRCODE, MSG_FONT_DATA *, STRCODE, u8 *) = {
		GetBitmapOnMemoryOldFont,
		GetBitmapOnMemoryHangul,
	};

	int i;
	int min_code;
	u32 font_area_num    = *(u32 *)wk->fontBitData;
	FONT_AREA *font_area = (FONT_AREA *)(wk->fontBitData + sizeof(u32));

	min_code = 0;
	for (i = 0; i < font_area_num; ++i) {
		if (fcode < font_area->maxCode) {
			if (font_area->dataType) {
				GetBitmapOnMemoryAct[font_area->dataType-1](wk, fcode, dst, min_code, wk->fontBitData + font_area->dataOffset);
				return;
			}
			break;
		}
		min_code = font_area->maxCode;
		font_area++;
	}

	dst->size_x = 0;
	dst->size_y = 0;

#else

	u32	fdata_adrs;

	fdata_adrs = (u32)(&wk->fontBitData[fcode * wk->letterCharSize]);

	switch( wk->charShape ){
	case LETTERSIZE_1x1:
		FntDataSet8x8_2bit(fdata_adrs + 0x10* 0,((u32)dst->data)+0x20*0);
		break;
	case LETTERSIZE_1x2:
		FntDataSet8x8_2bit(fdata_adrs + 0x10* 0,((u32)dst->data)+0x20*0);
		FntDataSet8x8_2bit(fdata_adrs + 0x10* 1,((u32)dst->data)+0x20*2);
		break;
	case LETTERSIZE_2x1:
		FntDataSet8x8_2bit(fdata_adrs + 0x10* 0,((u32)dst->data)+0x20*0);
		FntDataSet8x8_2bit(fdata_adrs + 0x10* 1,((u32)dst->data)+0x20*1);
		break;
	case LETTERSIZE_2x2:
		FntDataSet8x8_2bit(fdata_adrs + 0x10* 0,((u32)dst->data)+0x20*0);
		FntDataSet8x8_2bit(fdata_adrs + 0x10* 1,((u32)dst->data)+0x20*1);
		FntDataSet8x8_2bit(fdata_adrs + 0x10* 2,((u32)dst->data)+0x20*2);
		FntDataSet8x8_2bit(fdata_adrs + 0x10* 3,((u32)dst->data)+0x20*3);
		break;
	}

	dst->size_x = wk->WidthGetFunc( wk, fcode );
	dst->size_y = wk->fontHeader.maxHeight;

#endif
}

// ----------------------------------------------------------------------------

//------------------------------------------------------------------
/**
 * rbg}bvf[^擾irbgf[^ǂݍ݃^Cvj
 *
 * @param   wk			[N|C^
 * @param   fcode		R[h
 * @param   dst			rbgf[^ǂݍݐobt@
 *
 */
//------------------------------------------------------------------
static void GetBitmapFileRead( const GF_FONTDATA_MAN* wk, STRCODE fcode, MSG_FONT_DATA* dst )
{
	u32	fdata_adrs;

	ArchiveDataLoadOfsByHandle( wk->fileHandle, wk->fileDatID, wk->fontHeader.bitDataOffs+fcode*wk->letterCharSize,
		wk->letterCharSize, (void*)(wk->readBuffer) );

	switch( wk->charShape ){
	case LETTERSIZE_1x1:
		FntDataSet8x8_2bit( (u32)(&(wk->readBuffer[0x10*0])), ((u32)dst->data)+0x20*0 );
		break;
	case LETTERSIZE_1x2:
		FntDataSet8x8_2bit( (u32)(&(wk->readBuffer[0x10*0])), ((u32)dst->data)+0x20*0 );
		FntDataSet8x8_2bit( (u32)(&(wk->readBuffer[0x10*1])), ((u32)dst->data)+0x20*2 );
		break;
	case LETTERSIZE_2x1:
		FntDataSet8x8_2bit( (u32)(&(wk->readBuffer[0x10*0])), ((u32)dst->data)+0x20*0 );
		FntDataSet8x8_2bit( (u32)(&(wk->readBuffer[0x10*1])), ((u32)dst->data)+0x20*1 );
		break;
	case LETTERSIZE_2x2:
		FntDataSet8x8_2bit( (u32)(&(wk->readBuffer[0x10*0])), ((u32)dst->data)+0x20*0 );
		FntDataSet8x8_2bit( (u32)(&(wk->readBuffer[0x10*1])), ((u32)dst->data)+0x20*1 );
		FntDataSet8x8_2bit( (u32)(&(wk->readBuffer[0x10*2])), ((u32)dst->data)+0x20*2 );
		FntDataSet8x8_2bit( (u32)(&(wk->readBuffer[0x10*3])), ((u32)dst->data)+0x20*3 );
		break;
	}


	dst->size_x = wk->WidthGetFunc( wk, fcode );
	dst->size_y = wk->fontHeader.maxHeight;

}

//------------------------------------------------------------------
/**
 * rbg}bv̒ihbgjvZĕԂ
 *
 * @param   wk		tHgf[^}l[W
 * @param   str		
 * @param   margin	ԁihbgj
 *
 * @retval  u32		
 */
//------------------------------------------------------------------
u32 FontDataMan_GetStrWidth( const GF_FONTDATA_MAN* wk, const STRCODE* str, u32 margin )
{
	u32 len = 0;
	while( *str != EOM_ )
	{
		if (*str == _CTRL_TAG )
		{
			str = STRCODE_SkipTag(str);
			if( *str == EOM_ )
			{
				break;
			}
		}
		len += (wk->WidthGetFunc( wk, (*str)-1 ) + margin);
		str++;
	}
	return len - margin;
}


//------------------------------------------------------------------
/**
 * P擾֐iv|[Vij
 *
 * @param   wk		
 * @param   bcode		
 *
 * @retval  u8		
 */
//------------------------------------------------------------------
static u8 GetWidthProportionalFont( const GF_FONTDATA_MAN* wk, u32 bcode )
{
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/20
// 풓pkoCiɑΉ
#if PM_LANG == LANG_KOREA
	int i;
	int min_code;
	u32 font_area_num    = *(u32 *)wk->widthTbl;
	FONT_AREA *font_area = (FONT_AREA *)(wk->widthTbl + sizeof(u32));

	min_code = 0;
	for (i = 0; i < font_area_num; ++i) {
		if (bcode < font_area->maxCode) {
			if (font_area->width == WIDTH_PROPOTIONAL) {
				return wk->widthTbl[font_area->dataOffset + bcode - min_code];
			} else {
				return (u8)font_area->width;
			}
			break;
		}
		min_code = font_area->maxCode;
		font_area++;
	}

	return 0;
#else
	return wk->widthTbl[ bcode ];
#endif
// ----------------------------------------------------------------------------
}
//------------------------------------------------------------------
/**
 * P擾֐ij
 *
 * @param   wk		
 * @param   bcode		
 *
 * @retval  u8		
 */
//------------------------------------------------------------------
static u8 GetWidthFixedFont( const GF_FONTDATA_MAN* wk, u32 bcode )
{
	return wk->fontHeader.maxWidth;
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/10/05
// sɂ킽镶́AŒs̃rbg}bvԂ֐

u32 FontDataMan_GetMaxLineWidth(const GF_FONTDATA_MAN* wk, const STRCODE* str, u32 margin)
{
	u32 maxlen = 0, linelen = 0;

	while(*str != EOM_) {
		if (*str == _CTRL_TAG) {
			str = STRCODE_SkipTag(str);
			continue;
		} else if (*str == CR_) {
			linelen -= margin;
			if (maxlen < linelen) maxlen = linelen;
			linelen = 0;
			str++;
			continue;
		}
		linelen += (wk->WidthGetFunc( wk, (*str)-1 ) + margin);
		str++;
	}

	linelen -= margin;
	if (maxlen < linelen) maxlen = linelen;

	return maxlen;
}

// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/12/14
// XNvgEBhEJۂɁAeڂ̒擾邽߂̊֐

#define EV_WIN_CURSOR_WIDTH		(12)

u32 FontDataMan_GetEvWinItemWidth( const GF_FONTDATA_MAN* wk, const STRCODE* str )
{
	u32 len = 0;

	while(*str != EOM_) {
		if (*str == _CTRL_TAG ) {
			if (STRCODE_GetTagType(str) == NC_WRITEPOS_CHANGE_X) {
				len = STRCODE_GetTagParam(str, 0) - EV_WIN_CURSOR_WIDTH;
			}
			str = STRCODE_SkipTag(str);
			continue;
		}
		len += wk->WidthGetFunc( wk, (*str)-1 );
		str++;
	}

	return len;
}

// ----------------------------------------------------------------------------
