//=============================================================================================
/**
 * @file	g3d_system.c                                                  
 * @brief	Rc`ǗVXevO
 * @date	2006/4/26
 */
//=============================================================================================
#include "system.h"
#include "display.h"
#include "gflib_os_print.h"

#define	__G3D_SYSTEM_H_GLOBAL
#include "g3d_system.h"

#ifdef PM_DEBUG
#include "debug_3d_draw_count.h"
#endif	//PM_DEBUG

//=============================================================================================
//	^錾
//=============================================================================================
#define TEX_BLOCKNUM	(128)
#define PLT_BLOCKNUM	(256)

#define TEX_SLOTSIZ		(0x20000)
#define PLT_SLOTSIZ		(0x2000)
//=============================================================================================
//	vg^Cv錾
//=============================================================================================
static void		GF_G3D_DefaultSetUp( void );
//--------------------------------------------------------------------------------------------
/**
 * VXe}l[Wݒ
 *
 * @param	heapID			擾pq[vGA
 * @param	texmanMode		eNX`}l[Wgp[h
 * @param	texmanSize		eNX`}l[Wgp̈TCYibytej
 * @param	palmanMode		pbg}l[Wgp[h
 * @param	palmanSize		pbg}l[Wgp̈TCYibytej
 * @param	setUp			ZbgAbv֐(NULL̎DefaultSetUp)
 *
 * @return	}l[W[N|C^
 */
//--------------------------------------------------------------------------------------------
GF_G3DMAN*  GF_G3DMAN_Init(	u32 heapID, 
							GF_G3DMAN_MODE texmanMode, GF_G3DMAN_TEXSIZE texmanSize, 
							GF_G3DMAN_MODE pltmanMode, GF_G3DMAN_PLTSIZE pltmanSize,
							GF_G3DSETUP_FUNC setup )
{
	int	tex_size,plt_size;
	GF_G3DMAN* man = sys_AllocMemory( heapID, sizeof(GF_G3DMAN) );

	man->heapID = heapID;

	// NitroSystem:RcGW̏
	NNS_G3dInit();
	// }gNXX^bN̏
    G3X_InitMtxStack();

	// WIgGWNKĂ΂Ȃ΂ȂȂ
    G3_SwapBuffers(GX_SORTMODE_AUTO, GX_BUFFERMODE_W);

	//uq`leNX`}l[W̐ݒ
	if( texmanMode == GF_G3DMAN_LNK ){
		//Nh[h̐ݒ
		tex_size = NNS_GfdGetLnkTexVramManagerWorkSize( TEX_BLOCKNUM * texmanSize );
		man->tex_memory = sys_AllocMemory( man->heapID, tex_size );

		// }l[WeNX`C[WXbgwXbgǗł悤ɂ
		NNS_GfdInitLnkTexVramManager( TEX_SLOTSIZ*texmanSize, 0, man->tex_memory, tex_size, TRUE);
	} else {
		//t[[h̐ݒ
		NNS_GfdInitFrmTexVramManager( texmanSize, TRUE);
	}

	//uq`lpbg}l[W̐ݒ
	if( pltmanMode == GF_G3DMAN_LNK ){
		//Nh[h̐ݒ
		plt_size = NNS_GfdGetLnkPlttVramManagerWorkSize( PLT_BLOCKNUM * pltmanSize );
		man->plt_memory = sys_AllocMemory( man->heapID, plt_size );

		// }l[WeNX`C[WXbgwTCYǗł悤ɂ
		NNS_GfdInitLnkPlttVramManager( PLT_SLOTSIZ * pltmanSize, man->plt_memory, plt_size, TRUE);
	} else {
		//t[[h̐ݒ
		NNS_GfdInitFrmTexVramManager( PLT_SLOTSIZ * pltmanSize, TRUE);
	}

	if( setup != NULL ){
		setup();
	} else {
		GF_G3D_DefaultSetUp();
	}
	return man;
}

//--------------------------------------------------------------------------------------------
/**
 * I
 *
 * @param	man		}l[W[N|C^
 *
 * @return	none
 *
 */
//--------------------------------------------------------------------------------------------
void		GF_G3D_Exit( GF_G3DMAN*  man )
{
	sys_FreeMemoryEz( man->plt_memory );
	sys_FreeMemoryEz( man->tex_memory );

	sys_FreeMemoryEz( man );
}

//--------------------------------------------------------------------------------------------
/**
 * e탂[hftHgZbgAbv
 *
 * @param	none
 * @return	none
 *
 */
//--------------------------------------------------------------------------------------------
static void		GF_G3D_DefaultSetUp( void )
{
	// Rcgpʂ̐ݒ(\vCIeB[)
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
    G2_SetBG0Priority(0);

	// e`惂[h̐ݒ(VF[hA`GCAX)
    G3X_SetShading( GX_SHADING_TOON );
    G3X_AntiAlias( FALSE );
	G3X_AlphaTest( FALSE, 0 );	// At@eXg@@It
	G3X_AlphaBlend( FALSE );		// At@uh@I
	G3X_EdgeMarking( FALSE );
	G3X_SetFog( FALSE, GX_FOGBLEND_COLOR_ALPHA, GX_FOGSLOPE_0x8000, 0 );

	// NAJ[̐ݒ
    G3X_SetClearColor(GX_RGB(0,0,0),0,0x7fff,63,FALSE);	//color,alpha,depth,polygonID,fog

	// r[|[g̐ݒ
    G3_ViewPort(0, 0, 255, 191);
}

//------------------------------------------------------------------
//  Rcaf`֐
//  
//  @param		object_p		_[nai
//  @param		trans_p			gX[g
//  @param		rot_p			[e[V
//  @param		scale_p			XP[
//
//  @return		none
//  
//------------------------------------------------------------------
void GF_G3D_Draw_1mat1shape(NNSG3dRenderObj* object_p,
							VecFx32* trans_p,
							MtxFx33* rot_p,
							VecFx32* scale_p)
{
#ifdef DEBUG_3DDRAW_COUNT
	D_3D_DC_CountNum(object_p);
#endif// DEBUG_3DDRAW_COUNT

	// ʒuݒ
	NNS_G3dGlbSetBaseTrans(trans_p);
	// pxݒ
	NNS_G3dGlbSetBaseRot(rot_p);
	// XP[ݒ
	NNS_G3dGlbSetBaseScale(scale_p);

	NNS_G3dGlbFlush();
    
    NNS_G3dDraw1Mat1Shp(object_p->resMdl,0,0,TRUE);
    
    NNS_G3dGeFlushBuffer();
}

