/*---------------------------------------------------------------------------*
  Project:  NitroSDK - TRIAL - tests - rebooter
  File:     hack.h

  Copyright 2006 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $NoKeywords: $
 *---------------------------------------------------------------------------*/
#ifndef NITROSDK_SILESYSTEM_HACK_HEADER__
#define NITROSDK_SILESYSTEM_HACK_HEADER__

#include <nitro.h>

// localize_spec_mark(LANG_ALL) yamamoto 2007/2/7
// _CAhp[ʂdlKvȂ̂ŁA
// ẌӐ}ʂɁuPOKEMONłȂ̂ɖɂ_E[h
// Ȃ悤ɂv߂̂̂ƂB

// [] |PŃogvO炤́A
//          ׂĂ"ADAJ"ɂĂBŃog̃vOł
//          K"ADAJ"Ń`FbNB
//          Ȃ̂ŁAύXĂ͂ȂII
#define GAME_CODE_ADAJ     (('A' << 0) | ('D' << 8) | ('A' << 16) | ('J' << 24))
#define MAKER_CODE_01      (('0' << 0) | ('1' << 8))

/*****************************************************************************/
/* function */

/*
 * FSCuWROMA[JCuwt@CVXeA
 * w݂̃vOxłȂw{̃vOx̂̂ɕ␳܂B
 * Ƀ|P_CAh̃CjVR[hgpāAROM̐
 * `FbNĂ܂B(ł̂ŁA{֐̓|Pp֐łB)
 * {̃vOg炱̊֐Ăяoꍇ́A
 * ̏s܂B
 *
 * ̊֐ FS_Init ֐Ăяo̒ɌĂяoKv܂B
 */
SDK_INLINE
void NormalizeRomArchive(void)
{
    if (!FS_IsAvailable())
    {
        OS_TPanic("no archive to replace!");
    }
    else
    {
        static const char name[] = "rom";
        static const int name_len = sizeof(name) - 1;
        const CARDRomHeader* header;
        FSArchive *rom;
        {
            CARDRomHeader * const arg_buffer = (CARDRomHeader *)0x027FF000/*HW_MAIN_MEM_SHARED*/;
            CARDRomHeader * const app_header = (CARDRomHeader *)HW_ROM_HEADER_BUF;
            CARDRomHeader * const org_header = (CARDRomHeader *)HW_CARD_ROM_HEADER;
            if (arg_buffer->game_code == 0)
            {
                // ROMwb_̓eޔ̈ɃRs[܂B
                CARD_Init();
                MI_CpuCopy8(app_header, arg_buffer, HW_CARD_ROM_HEADER_SIZE);
                MI_CpuCopy8(app_header, org_header, HW_CARD_ROM_HEADER_SIZE);
                arg_buffer->game_code = GAME_CODE_ADAJ;
            }
            header = arg_buffer;
        }
        rom = FS_FindArchive(name, name_len);
        rom->fat = header->fat.offset;
        rom->fat_size = header->fat.length;
        rom->fnt = header->fnt.offset;
        rom->fnt_size = header->fnt.length;
        if (header->game_code != GAME_CODE_ADAJ ||
            header->maker_code != MAKER_CODE_01)
        {
            // ʏ킠蓾ȂAog󂯎ׂROMłȂBmfB
            OS_TPanic("illegal rom");
        }
    }
}

#endif /* NITROSDK_SILESYSTEM_HACK_HEADER__ */
