//============================================================================================
/**
 * @file	point_sel.c
 * @brief	ʒuCfbNXI
 * @author	Hiroyuki Nakamura
 * @date	2004.11.12
 */
//============================================================================================
#define	POINT_SEL_H_GLOBAL

#include "system.h"
#include "point_sel.h"


//============================================================================================
//	V{`
//============================================================================================


//============================================================================================
//	vg^Cv錾
//============================================================================================


//============================================================================================
//	O[oϐ
//============================================================================================


//--------------------------------------------------------------------------------------------
/**
 * p[^擾
 *
 * @param	pw		[N
 * @param	flg		擾tO
 *
 * @return	wp[^
 */
//--------------------------------------------------------------------------------------------
u8 PointerWorkGet( const POINTER_WORK * pw, u8 flg )
{
	switch( flg ){
	case POINT_WK_PX:
		return pw->px;
	case POINT_WK_PY:
		return pw->py;
	case POINT_WK_SX:
		return pw->sx;
	case POINT_WK_SY:
		return pw->sy;
	case POINT_WK_UP:
		return pw->up;
	case POINT_WK_DOWN:
		return pw->down;
	case POINT_WK_LEFT:
		return pw->left;
	case POINT_WK_RIGHT:
		return pw->right;
	}
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * W擾
 *
 * @param	pw		[N
 * @param	x		XWi[ꏊ
 * @param	y		YWi[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PointerWkPosGet( const POINTER_WORK * pw, u8 * x, u8 * y )
{
	*x = pw->px;
	*y = pw->py;
}

//--------------------------------------------------------------------------------------------
/**
 * TCY擾
 *
 * @param	pw		[N
 * @param	x		XTCYi[ꏊ
 * @param	y		YTCYi[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PointerWkSizeGet( const POINTER_WORK * pw, u8 * x, u8 * y )
{
	*x = pw->sx;
	*y = pw->sy;
}

//--------------------------------------------------------------------------------------------
/**
 * ړw肵AWATCYACfbNX擾
 *
 * @param	pw		[N
 * @param	px		XWi[ꏊ
 * @param	py		YWi[ꏊ
 * @param	sx		XTCYi[ꏊ
 * @param	sy		YTCYi[ꏊ
 * @param	now		݂̃CfbNX
 * @param	mv		ړ
 *
 * @return	ړ̃CfbNX
 */
//--------------------------------------------------------------------------------------------
u8 PointerWkMoveSel(
		const POINTER_WORK * pw, u8 * px, u8 * py, u8 * sx, u8 * sy, u8 now, u8 mv )
{
	u8	next = now;

	switch( mv ){
	case POINT_MV_UP:
		next = pw[now].up;
		break;
	case POINT_MV_DOWN:
		next = pw[now].down;
		break;
	case POINT_MV_LEFT:
		next = pw[now].left;
		break;
	case POINT_MV_RIGHT:
		next = pw[now].right;
		break;
	}
	if( px != NULL ){ *px = pw[next].px; }
	if( py != NULL ){ *py = pw[next].py; }
	if( sx != NULL ){ *sx = pw[next].sx; }
	if( sy != NULL ){ *sy = pw[next].sy; }

	return next;
}

//--------------------------------------------------------------------------------------------
/**
 * \L[̏񂩂AWATCYACfbNX擾
 *
 * @param	pw		[N
 * @param	px		XWi[ꏊ
 * @param	py		YWi[ꏊ
 * @param	sx		XTCYi[ꏊ
 * @param	sy		YTCYi[ꏊ
 * @param	now		݂̃CfbNX
 *
 * @return	ړ̃CfbNXi\L[ĂȂꍇPOINT_SEL_NOMOVEj
 *
 * @li	sys.trggp
 */
//--------------------------------------------------------------------------------------------
u8 PointerWkMoveSelTrg( const POINTER_WORK * pw, u8 * px, u8 * py, u8 * sx, u8 * sy, u8 now )
{
	if( sys.trg & PAD_KEY_UP ){
		return PointerWkMoveSel( pw, px, py, sx, sy, now, POINT_MV_UP );
	}
	if( sys.trg & PAD_KEY_DOWN ){
		return PointerWkMoveSel( pw, px, py, sx, sy, now, POINT_MV_DOWN );
	}
	if( sys.trg & PAD_KEY_LEFT ){
		return PointerWkMoveSel( pw, px, py, sx, sy, now, POINT_MV_LEFT );
	}
	if( sys.trg & PAD_KEY_RIGHT ){
		return PointerWkMoveSel( pw, px, py, sx, sy, now, POINT_MV_RIGHT );
	}
	return POINT_SEL_NOMOVE;
}

//--------------------------------------------------------------------------------------------
/**
 * Ww肵ACfbNX擾
 *
 * @param	pw		[N
 * @param	px		XW
 * @param	py		YW
 * @param	siz		f[^TCY
 *
 * @return	wW̃CfbNX
 */
//--------------------------------------------------------------------------------------------
u8 PointerWkMovePos( const POINTER_WORK * pw, u8 px, u8 py, u8 siz )
{
	u16	i;

	for( i=0; i<siz; i++ ){
		if( pw[i].px <= px && pw[i].px+pw[i].sx > px &&
			pw[i].py <= py && pw[i].py+pw[i].sy > py ){
			break;
		}
	}
	return (u8)i;
}
