//============================================================================================
/**
 * @file	strbuf.c
 * @brief	ėpobt@^IuWFNg
 * @author	taya
 * @date	2005.11.02
 */
//============================================================================================
#include <stdlib.h>
#include <string.h>
#include "gflib/assert.h"
#include "gflib/msg_print.h"
#include "gflib/strcode.h"
#include "gflib/fntsys.h"
#include "gflib/heapsys.h"

#include "gflib/strbuf_family.h"


//--------------------------------------------------------------
/**
 * 萔                                                      
 */
//--------------------------------------------------------------
#define STRBUF_MAGIC_NUMBER		(0xb6f8d2ec)
#define STRBUF_MAX_SIZE			(1024)

//--------------------------------------------------------------
/**
 * obt@IuWFNg^`
 */
//--------------------------------------------------------------
struct _STRBUF {
	u16  size;			///< zTCY
	u16  strlen;		///< 񒷁iEOM܂܂Ȃj
	u32  magicNumber;	///< ɏς݂ł邱Ƃ`FbN邽߂̃io[

	STRCODE  buffer[1];	///< z{
};

/** wb_TCY */
#define STRBUF_HEADER_SIZE	(sizeof(STRBUF) - sizeof(STRCODE))

//--------------------------------------------------------------
/**
 * Ԉُ`FbN}N
 */
//--------------------------------------------------------------
#define  STRBUF_CHECK_STATE(pbuf)	{\
	GF_ASSERT((pbuf)!=NULL)	\
	GF_ASSERT((pbuf)->magicNumber == STRBUF_MAGIC_NUMBER);	\
}



//==============================================================================================
//==============================================================================================

//------------------------------------------------------------------
/**
 * obt@IuWFNg쐬
 *
 * @param   size		i[ł镶iEOM܂ށj
 * @param   heapID		쐬q[vID
 *
 * @retval  STRBUF*		IuWFNgւ̃|C^
 */
//------------------------------------------------------------------
STRBUF* STRBUF_Create( u32 size, u32 heapID )
{
	STRBUF* strbuf;

	strbuf = sys_AllocMemory( heapID, STRBUF_HEADER_SIZE + sizeof(STRCODE)*size );

	if( strbuf )
	{
		strbuf->magicNumber = STRBUF_MAGIC_NUMBER;
		strbuf->size = size;
		strbuf->strlen = 0;
		strbuf->buffer[0] = EOM_;
	}

	return strbuf;
}
//------------------------------------------------------------------
/**
 * obt@IuWFNg폜
 *
 * @param   strbuf		IuWFNgւ̃|C^
 *
 */
//------------------------------------------------------------------
void STRBUF_Delete( STRBUF* strbuf )
{
	STRBUF_CHECK_STATE(strbuf);

	// Free ɓAhXŌĂяoMagicNumber̂܂܎cĂ肷̂
	strbuf->magicNumber = STRBUF_MAGIC_NUMBER+1;

	sys_FreeMemoryEz( strbuf );
}
//------------------------------------------------------------------
/**
 * eNAċ󕶎ɂ
 * iCreate ̓NAĂ̂ŌĂԕKv͖j
 *
 * @param   strbuf		IuWFNgւ̃|C^
 *
 */
//------------------------------------------------------------------
void STRBUF_Clear( STRBUF* strbuf )
{
	STRBUF_CHECK_STATE(strbuf);

	strbuf->strlen = 0;
	strbuf->buffer[0] = EOM_;
}

//------------------------------------------------------------------
/**
 * obt@Ԃ̕Rs[
 *
 * @param   dst		Rs[obt@IuWFNg
 * @param   src		Rs[obt@IuWFNg
 *
 */
//------------------------------------------------------------------
void STRBUF_Copy( STRBUF* dst, const STRBUF* src )
{
	STRBUF_CHECK_STATE( dst );
	STRBUF_CHECK_STATE( src );

	if( dst->size > src->strlen )
	{
		memcpy( dst->buffer, src->buffer, (src->strlen+1)*sizeof(STRCODE) );
		dst->strlen = src->strlen;
		return;
	}

	GF_ASSERT_MSG(0, "STRBUF overflow : dstsize=%d,  srclen=%d", dst->size, src->strlen);
}

//------------------------------------------------------------------
/**
 * ẽobt@𕡐
 *
 * @param   strbuf		̃obt@IuWFNg
 *
 * @retval  STRBUF*		ꂽobt@IuWFNg
 */
//------------------------------------------------------------------
STRBUF* STRBUF_CreateBufferCopy( const STRBUF* origin, u32 heapID )
{
	STRBUF* copy;

	STRBUF_CHECK_STATE( origin );

	copy = STRBUF_Create( origin->strlen+1, heapID );
	if( copy )
	{
		STRBUF_Copy( copy, origin );
	}

	return copy;
}

//------------------------------------------------------------------
/**
 * obt@ɐZbg
 *
 * @param   dst			[out] obt@IuWFNgւ̃|C^
 * @param   number		l
 * @param   keta		ő包
 * @param   dispType	\^Cv
 * @param   codeType	R[h^Cv
 *
 */
//------------------------------------------------------------------
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/03/28
// 3/27NOEƂ̓dbčʁǍ؂͕svƂ̂ƂȂ̂Ŋ߂

void STRBUF_SetNumber( STRBUF* dst, int number, u32 keta, NUMBER_DISPTYPE dispType, NUMBER_CODETYPE codeType )
{
	static const u32 n_max[] = 
	{
		1,
		10,
		100,
		1000,
		10000,
		100000,
		1000000,
		10000000,
		100000000,
		1000000000,
	};
	int minus;
    static const STRCODE sc_zen[] = {n0_,n1_,n2_,n3_,n4_,n5_,n6_,n7_,n8_,n9_};
    static const STRCODE sc_han[] = {h_n0_,h_n1_,h_n2_,h_n3_,h_n4_,h_n5_,h_n6_,h_n7_,h_n8_,h_n9_};


	STRBUF_CHECK_STATE( dst );

	minus = (number < 0);

	if( dst->size > (keta+minus) )
	{
		u32  num_f, num_i, i;
		const STRCODE* sctbl = (codeType==NUMBER_CODETYPE_ZENKAKU)? sc_zen : sc_han;

		STRBUF_Clear(dst);

		if(minus)
		{
			number *= -1;
			dst->buffer[dst->strlen++] = (codeType==NUMBER_CODETYPE_ZENKAKU)? bou_ : h_bou_;
		}


		for(i=n_max[keta-1]; i>0; i/=10)
		{
			num_i = (u16)( number / i );
			num_f = (u32)( number - ( i * num_i ) );

			if( dispType == NUMBER_DISPTYPE_ZERO )
			{
				dst->buffer[dst->strlen++] = (num_i<10)? sctbl[num_i] : hate_;
			}
			else if( num_i != 0 || i==1 )
			{
				dispType = NUMBER_DISPTYPE_ZERO;
				dst->buffer[dst->strlen++] = (num_i<10)? sctbl[num_i] : hate_;
			}
			else if( dispType == NUMBER_DISPTYPE_SPACE )
			{
				// ----------------------------------------------------------------------------
				// localize_spec_mark(LANG_ALL) imatake 2006/11/24
				// pXy[XŃpfBOۂ́AƓ̃Xy[Xp悤
				dst->buffer[dst->strlen++] = (codeType==NUMBER_CODETYPE_ZENKAKU)? spc_ : spcnum_;
				// ----------------------------------------------------------------------------
			}

			number = num_f;
		}

		dst->buffer[dst->strlen] = EOM_;
		return;
	}

//	GF_ASSERT_MSG(0, "STRBUF overflow!");
	GF_ASSERT_MSG(0, "STRBUF overflow: bufsize=%d, keta=%d", dst->size, keta);
}

// ----------------------------------------------------------------------------

//------------------------------------------------------------------
/**
 * 𐔎ɕϊ  18Ή  ̊֐͕R[hɍE
 *
 * @param   src			ϊĂobt@
 * @param   pbFlag      ϊłǂ
 * @return  ꍇϊ
 *
 */
//------------------------------------------------------------------
u64 STRBUF_GetNumber( const STRBUF* src, BOOL* pbFlag  )
{
    u64 num = 0,add = 0, digit = 1;
    int i;
    STRCODE code;
    STRCODE zenNum = n0_;
    STRCODE hanNum = h_n0_;

    if(src->strlen > 18){
        return FALSE;  // ϊs
    }
    for(i = (src->strlen - 1); i >= 0; i--){
        code = src->buffer[i];
        num = code - zenNum;
        if(num >= 10){  // Sp̂O`XłȂ
            num = code - hanNum;
            if(num >= 10){  // p̂O`XłȂ
                *pbFlag = FALSE;
                return add;  // ϊs
            }
        }
        num = num * digit;
        add += num;
        digit *= 10;  // Abv
    }
    *pbFlag = TRUE;
    return add;  // ϊ
}

//------------------------------------------------------------------
/**
 * r
 *
 * @param   str1		P
 * @param   str2		Q
 *
 * @retval  int			"0 = v"
 * @retval  int			"1 = sv"
 */
//------------------------------------------------------------------
int STRBUF_Compare( const STRBUF* str1, const STRBUF* str2 )
{
	STRBUF_CHECK_STATE( str1 );
	STRBUF_CHECK_STATE( str2 );

	{
		int i;


		for(i=0; str1->buffer[i] == str2->buffer[i]; i++)
		{
			if( str1->buffer[i] == EOM_ )
			{
				return 0;
			}
		}

		return 1;
	}
}

//------------------------------------------------------------------
/**
 * i[Ă镶Ԃ
 *
 * @param   strbuf		obt@IuWFNg
 *
 * @retval  u32		
 */
//------------------------------------------------------------------
u32 STRBUF_GetLen( const STRBUF* str )
{
	STRBUF_CHECK_STATE( str );

	return str->strlen;
}


//------------------------------------------------------------------
/**
 * i[Ă镶񂪉s邩𒲂ׂ
 *
 * @param   strbuf		obt@IuWFNg
 *
 * @retval  u32		̍s
 */
//------------------------------------------------------------------
u32 STRBUF_GetLines( const STRBUF* str )
{
	STRBUF_CHECK_STATE( str );

	{
		int i;
		u32 cnt;

		for(i=0, cnt=1; i<str->strlen; i++)
		{
			if( str->buffer[i] == CR_ )
			{
				cnt++;
			}
		}
		return cnt;
	}
}

//------------------------------------------------------------------
/**
 * ́Awŝ݂ʃobt@փRs[
 *
 * @param   dst		Rs[obt@
 * @param   src		Rs[obt@
 * @param   line	sԍi0 originj
 *
 */
//------------------------------------------------------------------
void STRBUF_CopyLine( STRBUF* dst, const STRBUF* src, u32 line )
{
	STRBUF_CHECK_STATE( src );
	STRBUF_CHECK_STATE( dst );

	{
		int i = 0;

		if( line )
		{
			for(i=0; i<src->strlen; i++)
			{
				if( src->buffer[i] == CR_ )
				{
					if( --line == 0 )
					{
						i++;
						break;
					}
				}
			}
		}

		STRBUF_Clear( dst );
		for( ; i<src->strlen; i++)
		{
			if( src->buffer[i] == CR_ )
			{
				break;
			}
			STRBUF_AddChar( dst, src->buffer[i] );
		}
	}
}


//==============================================================================================
// ̕z舵֐Q
// 𗘗pł郂W[͏o肷
//==============================================================================================

//------------------------------------------------------------------
/**
 * ̕iEOMI[jobt@IuWFNgɃZbg
 *
 * @param   strbuf		[out] obt@IuWFNgւ̃|C^
 * @param   sz			[in]  EOM ŏI镶z
 *
 */
//------------------------------------------------------------------
void STRBUF_SetStringCode( STRBUF* strbuf, const STRCODE* sz )
{
	STRBUF_CHECK_STATE(strbuf);

	strbuf->strlen = 0;
	while( *sz != EOM_ )
	{
		if( strbuf->strlen >= (strbuf->size-1) )
		{
			GF_ASSERT_MSG( 0, "STRBUF overflow: busize=%d", strbuf->size);
			break;
		}
		strbuf->buffer[ strbuf->strlen++ ] = *sz++;
	}

	strbuf->buffer[strbuf->strlen] = EOM_;
}
//------------------------------------------------------------------
/**
 * ̕iwjobt@IuWFNgɃZbg
 *
 * @param   strbuf		[out] obt@IuWFNgւ̃|C^
 * @param   str			[in]  z̐擪|C^
 * @param   len			[in]  Zbg镶iEOM܂ށj
 *
 */
//------------------------------------------------------------------
void STRBUF_SetStringCodeOrderLength( STRBUF* strbuf, const STRCODE* str, u32 len )
{
	STRBUF_CHECK_STATE(strbuf);

	if( len <= strbuf->size )
	{
		u32 i;

		memcpy( strbuf->buffer, str, len*sizeof(STRCODE) );

		for(i=0; i<len; i++)
		{
			if(strbuf->buffer[i] == EOM_)
			{
				break;
			}
		}
		strbuf->strlen = i;

		// EOMtȂ񂾂tĂ
		if( i==len )
		{
			strbuf->buffer[len-1] = EOM_;
		}
		return;
	}

	GF_ASSERT_MSG(0, "STRBUF overflow: bufsize=%d, strlen=%d", strbuf->size, len);
}

//------------------------------------------------------------------
/**
 * obt@琶̕zRs[
 *
 * @param   strbuf		[in]  obt@IuWFNgւ̃|C^
 * @param   ary			[out] Rs[z
 * @param   arysize		[in]  Rs[z̗vf
 *
 */
//------------------------------------------------------------------
void STRBUF_GetStringCode( const STRBUF* strbuf, STRCODE* ary, u32 arysize )
{
	STRBUF_CHECK_STATE(strbuf);

	if( (strbuf->strlen+1) <= arysize )
	{
		memcpy( ary, strbuf->buffer, (strbuf->strlen+1)*sizeof(STRCODE) );
		return;
	}

	GF_ASSERT_MSG(0, "STRBUF overflow: strlen=%d, arysize=%d", strbuf->strlen, arysize);
}
//------------------------------------------------------------------
/**
 * obt@IuWFNg镶z̃AhXԂ
 * ̊֐Ăяoӏ͒BԂ񕶎o͌n̂݁B
 *
 * @param   strbuf				[in] obt@IuWFNgւ̃|C^
 *
 * @retval  const STRCODE*		z̃AhX
 */
//------------------------------------------------------------------
const STRCODE* STRBUF_GetStringCodePointer( const STRBUF* strbuf )
{
	STRBUF_CHECK_STATE(strbuf);

	return strbuf->buffer;
}


//==============================================================================================
// ̘As֐Byy gp֎~ zz
// gėǂ̂̓[JCYl񏈗W[̂݁B
//==============================================================================================

//------------------------------------------------------------------
/**
 * A
 *
 * @param   dst		Aobt@IuWFNg
 * @param   src		A镶obt@IuWFNg
 *
 */
//------------------------------------------------------------------
void STRBUF_AddStr( STRBUF* dst, const STRBUF* src )
{
	STRBUF_CHECK_STATE(dst);
	STRBUF_CHECK_STATE(src);

	if( (dst->strlen + src->strlen + 1) <= dst->size )
	{
		memcpy( &(dst->buffer[dst->strlen]), src->buffer, (src->strlen+1)*sizeof(STRCODE) );
		dst->strlen += src->strlen;
		return;
	}

	GF_ASSERT_MSG(0, "STRBUF overflow: bufsize=%d, src_len=%d, dst_len=%d", dst->size, src->strlen, dst->strlen);
}

//------------------------------------------------------------------
/**
 * PA
 *
 * @param   dst			Aobt@IuWFNg
 * @param   code		A镶R[h
 *
 */
//------------------------------------------------------------------
void STRBUF_AddChar( STRBUF* dst, STRCODE code )
{
	STRBUF_CHECK_STATE( dst );

	if( (dst->strlen + 1) < dst->size )
	{
		dst->buffer[dst->strlen++] = code;
		dst->buffer[dst->strlen] = EOM_;
		return;
	}

	GF_ASSERT_MSG(0, "STRBUF overflow: busize=%d", dst->size);
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/11/24
// 擪̕Ls^CY֐ǉ

void STRBUF_Capitalize( STRBUF *strbuf )
{
	STRBUF_CHECK_STATE( strbuf );

	if (strbuf->strlen > 0) {
		STRCODE head = strbuf->buffer[0];
		// Ƃ肠ANZgLt̃At@xbg͍lȂ
		if (head >= h_a__ && head <= h_z__) {
			strbuf->buffer[0] -= h_a__ - h_A__;
		}
	}
}

// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/12/07
// kꂽ𔻕ʁEWJ֐ǉ

#define COMPRESSED_CODE_MASK	(0x01FF)
#define COMPRESSED_CODE_BITS	(9)
#define COMPRESSED_EOM			(0x01FF)
#define STRCODE_VALID_BITS		(15)

BOOL STRBUF_IsCompressed(STRBUF *strbuf)
{
	return strbuf->strlen > 0 && strbuf->buffer[0] == COMPRESSED_MARK;
}

// kꂽWJČikĂȂ΂̂܂܌j
// kꂽ̃tH[}bg
void STRBUF_AddCompStr(STRBUF *dst, STRBUF *src)
{
	if (STRBUF_IsCompressed(src)) {
		u32 i;

		STRCODE *dstCode = &dst->buffer[dst->strlen];
		STRCODE *srcCode = &src->buffer[1];
		s32 srcBit = 0;
		s32 length = 0;

		do {
			STRCODE expCode;
			expCode = (*srcCode >> srcBit) & COMPRESSED_CODE_MASK;
			srcBit += COMPRESSED_CODE_BITS;
			if (srcBit >= STRCODE_VALID_BITS) {
				++srcCode;
				srcBit -= STRCODE_VALID_BITS;
				if (srcBit) {
					expCode |= (*srcCode << (COMPRESSED_CODE_BITS - srcBit)) & COMPRESSED_CODE_MASK;
				}
			}
			if (expCode == COMPRESSED_EOM) break;
			*dstCode++ = expCode;
			++length;
		} while (1);
		*dstCode = EOM_;
		dst->strlen += length;
	} else {
		STRBUF_AddStr(dst, src);
	}
}

// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/09/11
// ̍Ō̕o֐i؍̏̔ʗpj
// localize_spec_mark(LANG_KOREA) imatake 2007/11/22
// ̍Ōオ^OꍇȂO̕Ԃ悤ɏC

#if PM_LANG == LANG_KOREA

enum {
	TAGHEADER_SIZE     = 3,
	TAGPARAMNUM_MAX    = 2,
	TAGSIZE_MAX        = TAGHEADER_SIZE + TAGPARAMNUM_MAX,
	RETRACE_MAX        = TAGSIZE_MAX + 1,
	TAGPARAMNUM_OFFSET = 2,
};

STRCODE STRBUF_GetLastChar(STRBUF *strbuf) {
	int i;
	STRCODE lastChar;

	STRBUF_CHECK_STATE( strbuf );

	i = strbuf->strlen < RETRACE_MAX ? strbuf->strlen : RETRACE_MAX;
	lastChar = EOM_;

	while (i) {
		STRCODE *str = &strbuf->buffer[strbuf->strlen - i];
		if (*str == _CTRL_TAG) {
			int paramNum = str[TAGPARAMNUM_OFFSET];
			i -= TAGHEADER_SIZE + paramNum;
			GF_ASSERT_MSG(i >= 0, "The last tag's size is too large.\n");
		} else {
			lastChar = *str;
			i--;
		}
	}

	return lastChar;
}

#endif

// ----------------------------------------------------------------------------

//==============================================================================================
// fobOp
//==============================================================================================
#ifdef PM_DEBUG

//------------------------------------------------------------------
/**
 * w肳ꂽ|C^STRBUFƂėLȂ̂ł邩`FbN
 *
 * @param   ptr		|C^
 *
 * @retval  BOOL	TRUEŗLł
 */
//------------------------------------------------------------------
BOOL STRBUF_CheckValid(const void* ptr)
{
	return ( (ptr!=NULL) && (((const STRBUF*)ptr)->magicNumber == STRBUF_MAGIC_NUMBER) );
}

//--------------------------------------------------------------------------------------------
/**
 * l𕶎ɕϊiPUijfobOp
 *
 * @param   dst			[out] obt@IuWFNgւ̃|C^
 * @param   number		l
 * @param   keta		ő包
 * @param   dispType	\^Cv
 * @param   codeType	R[h^Cv
 *
 * @return	none
 *
 * @li	type = NUMBER_DISPTYPE_LEFT		l
 * @li	type = NUMBER_DISPTYPE_SPACE	ElAȂ͋
 * @li	type = NUMBER_DISPTYPE_ZERO		ElAȂ͐̃[
 */
//--------------------------------------------------------------------------------------------
void STRBUF_SetHexNumber(	STRBUF* dst, int num, u32 keta,
							NUMBER_DISPTYPE dispType, NUMBER_CODETYPE codeType )
{
	u32	i,max;
	u32	num_i,num_f;

	u32 temp;
	
	static const STRCODE sc_zen[] = {n0_,n1_,n2_,n3_,n4_,n5_,n6_,n7_,n8_,n9_,
												A__,B__,C__,D__,E__,F__};
	static const STRCODE sc_han[] = {h_n0_,h_n1_,h_n2_,h_n3_,h_n4_,h_n5_,h_n6_,h_n7_,h_n8_,h_n9_,
												h_A__,h_B__,h_C__,h_D__,h_E__,h_F__};

	temp = num;
	if( dst->size > (keta) ){						
		const STRCODE* sctbl = (codeType==NUMBER_CODETYPE_ZENKAKU)? sc_zen : sc_han;

		STRBUF_Clear(dst);

		max = 1;
		for( i=1; i<keta; i++ ){
			max *= 16;
		}

		for( i=max; i>0; i/=16 ){
			num_i = temp / i;
			num_f = temp % i;
			if( dispType == NUMBER_DISPTYPE_ZERO ){
				dst->buffer[dst->strlen++] = ( num_i<16 )? sctbl[num_i] : hate_;
			}else if( num_i != 0 || i==1 ){
				dispType = NUMBER_DISPTYPE_ZERO;
				dst->buffer[dst->strlen++] = ( num_i<16 )? sctbl[num_i] : hate_;
			}else if( dispType == NUMBER_DISPTYPE_SPACE ){
				dst->buffer[dst->strlen++] = spc_;
			}
			temp = num_f;
		}
		dst->buffer[dst->strlen] = EOM_;

		return;
	}
	GF_ASSERT_MSG(0, "STRBUF overflow: bufsize=%d, keta=%d", dst->size, keta);
}

#endif
