//==============================================================================
/**
 * @file	system.c
 * @brief	VXex̊֐߂
 * @author	GAME FREAK Inc.
 */
//==============================================================================

#define __SYSTEM_H_GLOBAL__
#include "standard.h" 
#include "system.h"
#include "system\wordset.h"
#include "gflib_os_print.h"
#include "assert.h"
#include "rebooter.h"

//==============================================================================
//
//			`A֐錾
//
//==============================================================================
//#define	FS_DMA_NUMBER	DEFAULT_DMA_NUMBER
#define		FS_DMA_NUMBER		(1)



static void HBlankIntrSetMain( BOOL func_flag );

#ifdef PM_DEBUG 
extern u32 sys_GetMemoryBlockSize( const void* memBlock );
#endif

//==============================================================================
//
//			ϐ`
//
//==============================================================================
SystemArea sys;						// VXe\[X

//==============================================================================
//
//			֐
//
//==============================================================================

/*---------------------------------------------------------------------------*
  Name:         sys_VBlankIntr

  Description:  VuÑR[obN[`B

  Arguments:    ȂB
  Returns:      ȂB
 *---------------------------------------------------------------------------*/
void sys_VBlankIntr(void)
{
	OS_SetIrqCheckFlag(OS_IE_V_BLANK);

	MI_WaitDma(GX_DEFAULT_DMAID);
	TCBSYS_Main( sys.vintrTCBSys );

	sys.vsync_flame_counter++;
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/24
// bZ[WEBhEsC

#if	AFTERMASTER_070122_WARNING_DISP_FIX
/*---------------------------------------------------------------------------*
 * _~[VBlank֐Zbg: pVIntr
 *---------------------------------------------------------------------------*/
static void LocalVBlankIntr(void)
{
	OS_SetIrqCheckFlag(OS_IE_V_BLANK);

	MI_WaitDma(GX_DEFAULT_DMAID);
}

/*---------------------------------------------------------------------------*
 * _~[VBlank֐Zbg
 *---------------------------------------------------------------------------*/
void sys_SetDummyVBlankIntr(void)
{
    (void)OS_DisableIrqMask(OS_IE_V_BLANK);
	OS_SetIrqFunction(OS_IE_V_BLANK, LocalVBlankIntr);
    (void)OS_EnableIrqMask(OS_IE_V_BLANK);
}
#endif

// ----------------------------------------------------------------------------

//==============================================================================
/**
 * VuNɌĂяo֐̓o^
 *
 * @param   func	Ăяo֐|C^
 * @param	work	w֐ĂяoƂ̈[Nւ̃|C^
 *
 * @retval  none		
 */
//==============================================================================
void sys_VBlankFuncChange(INTR_FUNC func, void * work)
{
	sys.pVBlank = func;
	sys.pVBlankWork = work;
}


//==============================================================================
//
//
//			HuN֘A
//
//
//==============================================================================
//----------------------------------------------------------------
//----------------------------------------------------------------
void sys_HBlankIntrStop( void )
{
	HBlankIntrSetMain( FALSE );
	sys.pHBlank = NULL;
	sys.pHBlankWork = NULL;
}

//----------------------------------------------------------------
/**
 * @brief	HuNݒ
 * @param   func	Ăяo֐|C^
 * @param	work	荞ݒɎgp郏[Nւ̃|C^
 * @retval  "TRUE = ݒ肵܂"
 * @retval	"FALSE = łɐݒ肳Ă܂"
 *
 * @li	func = NULL ̏ꍇAHuNNA
 */
//----------------------------------------------------------------
BOOL  sys_HBlankIntrSet( INTR_FUNC func, void * work )
{
#if 1
	if( func == NULL ){
		HBlankIntrSetMain( FALSE );
		sys.pHBlank = NULL;
		sys.pHBlankWork = NULL;
		return TRUE;
	} else {
		if( sys.pHBlank == NULL ){
			sys.pHBlankWork = work;
			sys.pHBlank = func;
			HBlankIntrSetMain( TRUE );
			return TRUE;
		} else {
			return FALSE;
		}
	}
#else
	if( sys.pHBlank == NULL ){
		if( func ){
			sys.pHBlankWork = work;
			sys.pHBlank = func;
			HBlankIntrSetMain( TRUE );
			return TRUE;
		} else {
			HBlankIntrSetMain( FALSE );
			sys.pHBlank = NULL;
			sys.pHBlankWork = NULL;
			return TRUE;
		}
	}else if( func == NULL ){
		HBlankIntrSetMain( FALSE );
		sys.pHBlank = NULL;
		sys.pHBlankWork = NULL;
		return TRUE;
	}
	return FALSE;
#endif
}

//----------------------------------------------------------------
/**
 */
//----------------------------------------------------------------
static void sys_HBlankIntr(void)
{
	if (sys.pHBlank) {
		sys.pHBlank(sys.pHBlankWork);
	}
}

//----------------------------------------------------------------
//----------------------------------------------------------------
static void HBlankIntrSetMain( BOOL func_flag )
{
	OSIrqMask irqmask;

	OS_DisableIrq( ); 	//荞݋֎~
	if(func_flag==FALSE){
		irqmask = OS_GetIrqMask();
		OS_DisableIrqMask(OS_IE_H_BLANK);
		(void)GX_HBlankIntr(FALSE);
	}else{
		irqmask = OS_GetIrqMask();
		//OS_SetIrqFunction( OS_IE_H_BLANK, func );
		OS_SetIrqFunction( OS_IE_H_BLANK, sys_HBlankIntr );
		OS_EnableIrqMask(OS_IE_H_BLANK);
	    (void)GX_HBlankIntr(TRUE);          // Rise a H-Blank interrupt
	}
	OS_EnableIrq( ); 	//荞݋
}


//----------------------------------------------------------------
/**
 *	{q[v\
 */
//----------------------------------------------------------------
#define HEAPSIZE_SYSTEM		(0x00d000)
#define HEAPSIZE_DEBUG		(0x001000)
#define HEAPSIZE_SAVE		(0x021000)
#define HEAPSIZE_APP		(0x106800+0x7000)	//VCTp2000m 7.27

// BASE_HEAPID ƏԂv邱ƁI 
static const HEAP_INIT_HEADER HeapInitHeader[] = {
	{ HEAPSIZE_SYSTEM,		OS_ARENA_MAIN   },
	{ HEAPSIZE_SAVE,		OS_ARENA_MAIN   },
	{ HEAPSIZE_DEBUG,		OS_ARENA_MAIN   },
	{ HEAPSIZE_APP,			OS_ARENA_MAIN   },
};


//----------------------------------------------------------------
/**
 *	TCBVXe쐬p[^
 */
//----------------------------------------------------------------
enum {
	TCB_MAIN_MAX = 160,
	TCB_VINTR_MAX = 16,
	TCB_VWAIT_MAX = 32,
	TCB_PRINT_MAX =  4,
};


//------------------------------------------------------------------
/**
 * NɃq[v쐬ʒu炵ď
 */
//------------------------------------------------------------------
static void InitHeapSystem( void )
{
	enum {
		HEAP_START_OFFSET_MAX = 256,
	};

	u32  led[8];
	u8   md5[MATH_MD5_DIGEST_SIZE];

	u32  offset, i;

	OS_GetLowEntropyData( led );
	MATH_CalcMD5( md5, led, sizeof(led) );

	offset = 0;
	for(i=0; i<MATH_MD5_DIGEST_SIZE; i++)
	{
		offset += md5[i];
	}
	offset %= HEAP_START_OFFSET_MAX;
	while( offset % 4 )
	{
		offset++;
	}

	sys_InitHeapSystem(HeapInitHeader, NELEMS(HeapInitHeader), HEAPID_MAX, offset);
}




/*---------------------------------------------------------------------------*
  Name:         sys_InitSystem

  Description:  NITRȌs܂B

  Arguments:    ȂB
  Returns:      ȂB
 *---------------------------------------------------------------------------*/
void sys_InitSystem(void)
{
	#ifdef PM_DEBUG
	#ifndef EXHEAP_DISABLE
	OS_EnableMainExArena();
	#endif
	#endif

    OS_Init();
    FX_Init();
	GX_SetPower(GX_POWER_ALL);
    GX_Init();
	OS_InitTick();

	// q[vǗVXe
	InitHeapSystem();

	// eTCBVXe̍쐬
	sys.mainTCBSys = TCBSYS_Create( TCB_MAIN_MAX,  OS_AllocFromMainArenaLo(TCBSYS_CalcSystemWorkSize(TCB_MAIN_MAX),4) );
	sys.vintrTCBSys = TCBSYS_Create( TCB_VINTR_MAX, OS_AllocFromMainArenaLo(TCBSYS_CalcSystemWorkSize(TCB_VINTR_MAX),4) );
	sys.vwaitTCBSys = TCBSYS_Create( TCB_VWAIT_MAX, OS_AllocFromMainArenaLo(TCBSYS_CalcSystemWorkSize(TCB_VWAIT_MAX),4) );
	sys.printTCBSys = TCBSYS_Create( TCB_PRINT_MAX, OS_AllocFromMainArenaLo(TCBSYS_CalcSystemWorkSize(TCB_PRINT_MAX),4) );


    GX_DispOff();
    GXS_DispOff();

	GX_SetDispSelect(GX_DISP_SELECT_MAIN_SUB);
	OS_SetIrqFunction(OS_IE_V_BLANK, sys_VBlankIntr);

    (void)OS_EnableIrqMask(OS_IE_V_BLANK);
    (void)OS_EnableIrqMask(OS_IE_FIFO_RECV);
    (void)OS_EnableIrq();

    (void)GX_VBlankIntr(TRUE);         // to generate VBlank interrupt request

	FS_Init(FS_DMA_NUMBER);
	rebooter_init();
	/* always preload FS table for faster directory access. */
	{
		u32 file_table_size = FS_GetTableSize();
		void* p_table = OS_AllocFromMainArenaLo( file_table_size, 4 );

		OS_TPrintf("FileTable Size     = 0x%08x bytes.\n", file_table_size);
		OS_TPrintf("remains of MainRAM = 0x%08x bytes.\n", (u32)(OS_GetMainArenaHi())-(u32)(OS_GetMainArenaLo()));

		GF_ASSERT(p_table != NULL);
		FS_LoadTable(p_table, file_table_size);
	}

	sys.pVBlank		= NULL;		// uuNݓĂяo֐|C^
	sys.pHBlank		= NULL;		// guNݓĂяo֐|C^
	sys.pVCount		= NULL;		// uJEgݓĂяo֐|C^
	sys.pSio		= NULL;		// rhnݓĂяo֐|C^

	sys.vsync_counter = 0;	
	sys.disp3DSW = DISP_3D_TO_MAIN;	
}

/*---------------------------------------------------------------------------*
  Name:         sys_InitVRAM

  Description:  uq`l̏s܂B

  Arguments:    ȂB
  Returns:      ȂB
 *---------------------------------------------------------------------------*/
void sys_InitVRAM(void)
{
    // SẴoNLCDCɊ蓖Ă
    GX_SetBankForLCDC(GX_VRAM_LCDC_ALL);

    // LCDCԑSĂNA
    MI_CpuClearFast( (void*)HW_LCDC_VRAM, HW_LCDC_VRAM_SIZE );
    
    // LCDCɊ蓖ĂꂽoNDisable
    (void)GX_DisableBankForLCDC();

    MI_CpuFillFast ((void*)HW_OAM    , 192, HW_OAM_SIZE   );  // OAM NA
    MI_CpuFillFast ((void*)HW_DB_OAM , 192, HW_DB_OAM_SIZE);  // clear OAM

    MI_CpuClearFast((void*)HW_PLTT   , HW_PLTT_SIZE   );      // pbg NA
    MI_CpuClearFast((void*)HW_DB_PLTT, HW_DB_PLTT_SIZE);	  // clear the standard palette
}



//==============================================================================
//
//
//
//==============================================================================
/*---------------------------------------------------------------------------*
  Name:         sys_LoadFile

  Description:  ʏt@C̓ǂݍ
  
  Arguments:    mode	wq[v̈`
				path	t@Cւ̃pX
  Returns:      t@CǂݍݐAhX
 *---------------------------------------------------------------------------*/
void* sys_LoadFile(int mode, const char *path)
{
	FSFile file;
	void*  memory;

	FS_InitFile(&file);
	if (FS_OpenFile(&file, path)){

		u32	fileSize = FS_GetLength(&file);		
		memory = sys_AllocMemory( mode, fileSize );

		if (memory == NULL){
			OS_Printf("no enough memory.\n");
		}else{
			if(FS_ReadFile(&file, memory, fileSize) != fileSize){
				// t@CTCYǂݍ߂ĂȂꍇ
				sys_FreeMemory( mode, memory );
				memory = NULL;
				OS_Printf("file reading failed.\n");
			}
		}
		(void)FS_CloseFile(&file);
	}else{
		OS_Printf("FS_OpenFile(\"%s\") ... ERROR!\n",path);
		memory = NULL;
	}
	return memory;
}

/*---------------------------------------------------------------------------*
  Name:         sys_LoadFileEx

  Description:  ʏt@C̓ǂݍ + TCY擾
  
  Arguments:    mode	wq[v̈`
				path	t@Cւ̃pX
				siz		f[^TCYi[
  Returns:      t@CǂݍݐAhX
 *---------------------------------------------------------------------------*/
void * sys_LoadFileEx( int mode, const char * path, u32 * siz )
{
	FSFile file;
	void * memory;

	FS_InitFile( &file );
	if( FS_OpenFile( &file, path ) ){

		*siz = FS_GetLength( &file );		
		memory = sys_AllocMemory( mode, *siz );

		if( memory == NULL ){
			OS_Printf( "no enough memory.\n" );
		}else{
			if( FS_ReadFile( &file, memory, *siz ) != *siz ){
				// t@CTCYǂݍ߂ĂȂꍇ
				sys_FreeMemory( mode, memory );
				memory = NULL;
				OS_Printf( "file reading failed.\n" );
			}
		}
		(void)FS_CloseFile( &file );
	}else{
		OS_Printf("FS_OpenFile(\"%s\") ... ERROR!\n",path);
	}
	return memory;
}

/*---------------------------------------------------------------------------*
  Name:         sys_LoadGraphFile

  Description:  OtBbNpt@C̓ǂݍ݁iLbVj
  
  Arguments:    path        t@Cւ̃pX
				side		CATuw
  Returns:      t@CǂݍݐAhX
 *---------------------------------------------------------------------------*/
void sys_LoadFileNoMem(const char *path, void **mem)
{
	FSFile file;
	
	FS_InitFile(&file);
	if (FS_OpenFile(&file, path)){
		u32	fileSize = FS_GetLength(&file);
#ifdef PM_DEBUG
		{
			u32 size = sys_GetMemoryBlockSize(*mem)-(0x10);
			if (fileSize>size){
				OS_Printf("fileSize=%x,allocSize=%x\n",fileSize,size);
				GF_ASSERT( 0 && "sys_LoadFileNoMem ERROR:sĂ܂");
			}
		}
#endif
		
#ifdef DEBUG_PRINT
		PrintAllocHeapSize(GRAPHIC_HEAP,path);
		
//		AddAllocHeapSize(GRAPHIC_HEAP);
#endif //DEBUG_PRINT
		if (*mem == NULL){
			OS_Printf("no memory.\n");
   	    }else{	// t@CTCYǂݍ߂ĂȂꍇ
			if (FS_ReadFile(&file, *mem, fileSize) != fileSize){
				OS_Printf("file reading failed.\n");
			}
		}
        (void)FS_CloseFile(&file);
	}else{
		OS_Printf("FS_OpenFile(\"%s\") ... ERROR!\n",path);
	}
}

/*---------------------------------------------------------------------------*
  Name:         sys_LoadFileDiv

  Description:  ʏt@C̓ǂݍݕ 
  
  Arguments:    mode	wq[v̈`
				path	t@Cւ̃pX
				memory	t@CǂݍݐAhXi[|C^
				offset	ǂݍ݃ItZbgi[|C^
				divsiz	ǂݍݕTCY
Returns:		0:pA1=I
 *---------------------------------------------------------------------------*/
int sys_LoadFileDiv( int mode, const char * path, void** memory, u32* offset, u16 divsiz )
{
	FSFile file;
	char   filename[32];

	if(path[0]=='!'){
		strcpy(filename,&path[1]);
	}else{
		strcpy(filename,path);
	}

	FS_InitFile(&file);
	if (FS_OpenFile(&file, filename))
	{
		u32	fileSize = FS_GetLength(&file);	//t@CTCY擾		
		u32	readSize = 0;
		if(*memory == NULL){	//memoryɎ擾ĂΌpƔf
			//	
			*memory = sys_AllocMemory( mode, fileSize );//ǂݍ݃GAm
			if (*memory == NULL){
				// mێs
				OS_Printf("no enough memory.\n");
				return 1;
			} else {	
				*offset = 0;	//ItZbg
			}
#ifdef SYSTEM_DEBUG_PRINT_FILE_SIZE	
			OS_Printf("DIV_LOAD_PATH:%s\nDivFileSizeTotal=%x\n",path,fileSize);
#endif
		}
		if( FS_SeekFile( &file, *offset, FS_SEEK_SET ) == FALSE ){
			// t@CItZbgύXs
			sys_FreeMemory( mode, memory );
			memory = NULL;
			OS_Printf("file div failed.\n");
			return 1;
		}
		{
			void*	read_p;
			read_p = &((u8*)*memory)[*offset];
			readSize = FS_ReadFile(&file, read_p, divsiz);
			(void)FS_CloseFile(&file);
			*offset = *offset + readSize;	//ItZbg
		}
		if( *offset >= fileSize ){
			//ǂݍݏI
			return 1;
		}
	}else{
		if(*memory != NULL){	//memoryɎ擾ĂΊJ
			sys_FreeMemory( mode, *memory );
			*memory = NULL;
		}
		OS_Printf("FS_OpenFile(\"%s\") ... ERROR!\n",filename);
		return 1;
	}
	return 0;
}

/*---------------------------------------------------------------------------*
  Name:         sys_LoadFileDiv

  Description:  ʏt@C̓ǂݍݕ 
  
  Arguments:    mode	wq[v̈`
				path	t@Cւ̃pX
				memory	t@CǂݍݐAhXi[|C^
				offset	ǂݍ݃ItZbgi[|C^
				divsiz	ǂݍݕTCY
Returns:		0:pA1=I
 *---------------------------------------------------------------------------*/
int sys_LoadFileDivNoMem( const char * path, void** memory, u32* offset, u16 divsiz )
{
	FSFile file;
	char   filename[32];
	
	strcpy(filename,path);
	
	FS_InitFile(&file);
	if (FS_OpenFile(&file, filename))
	{
		u32	fileSize = FS_GetLength(&file);	//t@CTCY擾		
		u32	readSize = 0;
		if(*memory == NULL){	//memorymۂĂȂȂ΃G[
			OS_Printf("NoMemory file div failed.\n");
			return 1;
		}
#ifdef PM_DEBUG
		{
			if (*offset == 0){
				u32 size = sys_GetMemoryBlockSize(*memory)-(0x10);
				if (fileSize>size){
					OS_Printf("fileSize=%x,allocSize=%x\n",fileSize,size);
					GF_ASSERT( 0 && "sys_LoadFileDivNoMem ERROR:sĂ܂");
				}
			}
		}
#endif
		
		if( FS_SeekFile( &file, *offset, FS_SEEK_SET ) == FALSE ){
			// t@CItZbgύXs
			OS_Printf("file div failed.\n");
			return 1;
		}
		{
			void*	read_p;
			read_p = &((u8*)*memory)[*offset];
			readSize = FS_ReadFile(&file, read_p, divsiz);
			(void)FS_CloseFile(&file);
			*offset = *offset + readSize;	//ItZbg
		}
		if( *offset >= fileSize ){
			//ǂݍݏI
			return 1;
		}
	}else{	//t@CJȂ
		OS_Printf("FS_OpenFile(\"%s\") ... ERROR!\n",filename);
		return 1;
	}
	return 0;
}

//==============================================================================
#define FILE_CACHE_MAX	(128)
typedef struct{
	void *memory;
	u32  hash;
}FILE_CACHE;

FILE_CACHE FileCache[FILE_CACHE_MAX];

u16 debugcount=0;

/**
 * t@Ct@CLbVp̃nbVl擾
 *
 * @param   path	t@C
 *
 * @retval  u32		
 */
//==============================================================================
u32 CreateFileHash(const char *path)
{
	int i,r;
	u32 work,result;
	u16 len;
	len = strlen(path);
	
	if (len%4){					//SŊۂ̌JԂ񐔂擾
		len = (len /4)+1;
	}else{
		len = len/4;	
	}

	result = 0;
	for(i=0;i<len;i++){			//4long^Ƃ݂Ȃĕ̒^S
		work = 0;				//XORs
		for(r=0;r<4;r++){
			if(path[i*4+r]!=0){
				work |= (path[i*4+r]<<(r*8));
			}else{
				break;
			}
		}
		result ^= work;
	}

	return result;
}

//==============================================================================
/**
 * ɃLbVƂđ݂Ă邢邩
 *
 * @param   hash	t@C擾nbVl
 *
 * @retval  int		0`:z̗vf	-1:Ȃ
 */
//==============================================================================
int SearchFileCache(u32 hash)
{
	int i;
	for(i=0;i<FILE_CACHE_MAX;i++){
		if(FileCache[i].hash==hash){
			if(FileCache[i].memory!=NULL){
				return i;
			}
		}
	}
	return -1;
}

//==============================================================================
/**
 * Vǂݍ񂾃t@CLbVƂēo^
 *
 * @param   memory		Vmۂ̃AhX
 * @param   hash		t@C擾nbVl
 *
 * @retval  int			o^ԍ
 */
//==============================================================================
int SetBlankCache(void* memory, u32 hash)
{
	int i;
	for(i=0;i<FILE_CACHE_MAX;i++){
		if(FileCache[i].memory==NULL){
			FileCache[i].memory = memory;
			FileCache[i].hash   = hash;
			return i;
		}
	}
	return -1;
}

//==============================================================================
/**
 * LbV̑SEnbṼNA
 *
 * @param   none		
 *
 * @retval  none		
 */
//==============================================================================
void ClearFileCache(void)
{
	int i;
	for(i=FILE_CACHE_MAX-1;i>-1;i--){
		if(FileCache[i].memory!=NULL){
			//NNS_FndFreeToExpHeap(sys.appHeap,FileCache[i].memory);
			sys_FreeMemoryEz( FileCache[i].memory );
#ifdef DEBUG_PRINT
			PrintFreeHeapSize(GRAPHIC_HEAP, "LbVf[^̊J");
			OS_Printf(	"cache:graph3DHeap = %ld\n",
						NNS_FndGetTotalFreeSizeForExpHeap(sys.graph3DHeap));
#endif //DEBUG_PRINT
			FileCache[i].memory = NULL;
			FileCache[i].hash   = 0;
		}
	}
}

//==============================================================================
/**
 * @brief	nbVzNULL
 */
//==============================================================================
void InitFileCache(void)
{
	u8 i = 0;
//	memset(FileCache,0,sizeof(FileCache)*FILE_CACHE_MAX);
	for(i=0;i < FILE_CACHE_MAX;i++){
		FileCache[i].memory = NULL;
		FileCache[i].hash   = 0;
	}
}

//==============================================================================
/**
 * @brief	̃nbVNA(L[w)
 *
 * @param   hash	t@C擾nbVl
 *
 * @retval  int		0`:폜vfIndex	-1:폜Ȃ
 */
//==============================================================================
int ClearFileCacheKey(u32 hash)
{
	int i;

	i = SearchFileCache(hash);
	if(i == -1){	//o^f[^Ȃ
		return i;
	}

	//̂ō폜
	NNS_G3dResDefaultRelease(FileCache[i].memory);	//\[X
	sys_FreeMemoryEz( FileCache[i].memory );
	FileCache[i].memory = NULL;
	FileCache[i].hash   = 0;
	return i;
}

//==============================================================================
/**
 * @brief	̃nbVNA(AhXw)
 *
 * @param   addr	\[X̃AhX
 *
 * @retval  int		0`:폜vfIndex	-1:폜Ȃ
 */
//==============================================================================
int ClearFileCacheAddr(void* addr)
{
	int	i = 0;
	
	if(addr == NULL){
		return 0xFF;
	}
	//LbV𑖍
	for(i = 0;i < FILE_CACHE_MAX;i++){	
		if(FileCache[i].memory != addr){
			continue;
		}
		//LbVj
		NNS_G3dResDefaultRelease(FileCache[i].memory);	//\[X
		sys_FreeMemoryEz(FileCache[i].memory);
		FileCache[i].memory = NULL;
		FileCache[i].hash   = 0;
		return i;
	}
	return -1;
}

/*---------------------------------------------------------------------------*
  Name:         sys_LoadGraphFile

  Description:  OtBbNpt@C̓ǂݍ݁iLbVj
  
  Arguments:    path        t@Cւ̃pX
				side		CATuw
  Returns:      t@CǂݍݐAhX
 *---------------------------------------------------------------------------*/
void* sys_LoadGraphFile(const char *path,const u8 inMode)
{
	FSFile file;
	char   filename[32];
	void*  memory;
	u32    hash;
	int	   result,flag=0;

	if(path[0]=='!'){
		strcpy(filename,&path[1]);
		flag = 1;
	}else{
		strcpy(filename,path);
	}
	hash = CreateFileHash(filename);

//	OS_Printf("\"%s\" = %08x\n",path,hash);
	
	if((result=SearchFileCache(hash))>=0 && flag==0){
		memory = FileCache[result].memory;
//		OS_Printf("cache hit! no %d : \"%s\" = %08x\n",result,path,hash);
	}else{
		FS_InitFile(&file);
		if (FS_OpenFile(&file, filename))
		{
			u32	fileSize = FS_GetLength(&file);		

			//memory = NNS_FndAllocFromExpHeapEx(sys.graph3DHeap, fileSize, 16);
			memory = sys_AllocMemory( inMode, fileSize );
#ifdef DEBUG_PRINT
			PrintAllocHeapSize(GRAPHIC_HEAP,path);
//			AddAllocHeapSize(GRAPHIC_HEAP);
#endif //DEBUG_PRINT
			if (memory == NULL)
   		     {
				OS_Printf("no enough memory.\n");
   	    	 }
   	     	else
			{	// t@CTCYǂݍ߂ĂȂꍇ
				if (FS_ReadFile(&file, memory, fileSize) != fileSize)  
				{
					//NNS_FndFreeToExpHeap(sys.graph3DHeap, memory);
					sys_FreeMemoryEz( memory );
					memory = NULL;
					OS_Printf("file reading failed.\n");
				}
			}
            (void)FS_CloseFile(&file);
            if(flag==0){
	            if(SetBlankCache(memory,hash)<0){
	                OS_Printf("file cache  over.\n");
                }
            }//			OS_Printf("cache set \"%s\" = %08x\n",path,hash);
		}
		else{
			OS_Printf("FS_OpenFile(\"%s\") ... ERROR!\n",path);
			memory = NULL;
		}
	}
	return memory;
}
#if 0
/*---------------------------------------------------------------------------*
  @brief	OtBbNpt@C\[X̉

  @param	addr	(void*)郊\[XAhX
  @param	free	TRUEȂ΁ALbVo^Ă郊\[Xł
					FALSȄꍇALbVo^ĂΉȂ
  @retval	0		
  @retval	1		LbV
  @retval	2		LbVo^Ă̂Ŕ
  @retval	0xFF	p[^s
 *---------------------------------------------------------------------------*/
s8 sys_FreeGraphFile(void* addr,u8 free)
{
	u8	i = 0;
	
	if(addr == NULL){
		return 0xFF;
	}
	//LbV𑖍
	for(i = 0;i < FILE_CACHE_MAX;i++){	
		if(FileCache[i].memory != addr){
			continue;
		}
		//HIT
		if(free){
			//LbVj
			NNS_G3dResDefaultRelease(FileCache[i].memory);	//\[X
			sys_FreeMemory(GRAPHIC3D_HEAP_AREA,FileCache[i].memory);
			FileCache[i].memory = NULL;
			FileCache[i].hash   = 0;
			return 1;
		}else{
			return 2;	//LbVɓo^Ă̂Ŕ
		}
	}
	//LbVɓo^ĂȂ̂ŕʂɉ
	NNS_G3dResDefaultRelease(FileCache[i].memory);	//\[X
	sys_FreeMemory(GRAPHIC3D_HEAP_AREA,FileCache[i].memory);
	FileCache[i].memory = NULL;
	FileCache[i].hash = 0;

	return 0;
}
#endif


/*---------------------------------------------------------------------------*
  Name:         sys_KeyRead

  Description:  L[ǂݍ݁AgKƃ[XgK߂܂B
				
  Arguments:    ȂB
  Returns:      ȂB
 *---------------------------------------------------------------------------*/

//
void sys_InitKeyRead(void)
{
	TPCalibrateParam calibrate;

	sys.key_control_mode = 0;	//L[擾[h

	sys.cont_org	= 0;	// L[
	sys.trg_org		= 0;	// L[gK[
	sys.repeat_org	= 0;	// L[s[g
	sys.cont		= 0;	// L[(Q[ݒɂϊ)
	sys.trg			= 0;	// L[gK[(Q[ݒɂϊ)
	sys.repeat      = 0;	// L[s[g(Q[ݒɂϊ)
	sys.repeatWait_Count = 0;
	sys.repeatSpeed	= 8;
	sys.repeatWait	= 15;


	sys.tp_x		 = 0;	// ^b`plXW
	sys.tp_y		 = 0;	// ^b`plYW
	sys.tp_trg		 = 0;	// ^b`plڐGgK
	sys.tp_cont		 = 0;	// ^b`plڐG
	sys.tp_auto_samp = 0;	// ^b`pl̃I[gTvOsĂ邩̃tO
									
	// ^b`pl̏ƃLu[VZbg
	TP_Init();

	// }ṼLu[Vl擾
	if( TP_GetUserInfo( &calibrate ) == TRUE ){
		// Lu[Vl̐ݒ
		TP_SetCalibrateParam( &calibrate );
		OS_Printf("Get Calibration Parameter from NVRAM\n");
	}
	else{
		// 擾ɎŝŃftHg̃Lu[V̐ݒ
		calibrate.x0 = 0x02ae;
		calibrate.y0 = 0x058c;
		calibrate.xDotSize = 0x0e25;
		calibrate.yDotSize = 0x1208;
		TP_SetCalibrateParam( &calibrate );
		OS_Printf( "Warrning : TauchPanelInit( not found valid calibration data )\n" );
	}
}

/*---------------------------------------------------------------------------*
  @brief	`faJ[gbW
 *---------------------------------------------------------------------------*/
void sys_InitAgbCasetteVer(int version)
{
	sys.AgbCasetteVersion = version;
}

/*---------------------------------------------------------------------------*
  @brief	X[vԂ֎~
 *---------------------------------------------------------------------------*/
void sys_SleepNG(u8 sleepTypeBit)
{
	sys.DontSleep |= sleepTypeBit;
}

/*---------------------------------------------------------------------------*
  @brief	X[vԂ
 *---------------------------------------------------------------------------*/
void sys_SleepOK(u8 sleepTypeBit)
{
	sys.DontSleep &= ~(sleepTypeBit);
}

//------------------------------------------------------------------
static void KeyConvert(void);

//ǂݎ

void sys_MainKeyRead(void)
{
	TPData	tpTemp;
	TPData	tpDisp;
	int	keyData;

	// ӂ܂Ăꍇ͑SĂ̓͂Ȃɂ
	if(PAD_DetectFold()){
	  sys.trg	= 0;
	  sys.cont	= 0;
	  sys.repeat	= 0;
	  sys.tp_trg	= 0;
	  sys.tp_cont	= 0;
	  return;
	}

	keyData = PAD_Read();
	
	sys.trg_org		= keyData & (keyData ^ sys.cont_org);	// gK 

    sys.repeat_org	=	keyData & (keyData ^ sys.cont_org);        // s[g 

    if((keyData!=0)&&(sys.cont_org==keyData)){
		if(--sys.repeatWait_Count==0){
			sys.repeat_org				=	keyData;
			sys.repeatWait_Count	=	sys.repeatSpeed;
		}
	}
	else{
		sys.repeatWait_Count = sys.repeatWait;
	}


	sys.cont_org	= keyData;							// x^ 

	sys.trg		= sys.trg_org;
	sys.cont	= sys.cont_org;
	sys.repeat	= sys.repeat_org;

	KeyConvert();

	// ^b`plf[^擾
	if(sys.tp_auto_samp == 0){
		while( TP_RequestRawSampling( &tpTemp ) != 0 ){};	//TvOɐ܂ő҂
	}else{
		TP_GetLatestRawPointInAuto( &tpTemp );	// I[gTvÕf[^擾
	}

	TP_GetCalibratedPoint( &tpDisp, &tpTemp );	// WʍWiO`QTTjɂ

#if 0	// 2006.07.05	W擾sύX
	switch(tpDisp.validity){		// W̗L`FbN
	case TP_VALIDITY_INVALID_X:
		sys.tp_x = 0xffff;
		sys.tp_y = tpDisp.y;
		break;
	case TP_VALIDITY_INVALID_Y:
		sys.tp_x = tpDisp.x;			// WZbg
		sys.tp_y = 0xffff;
		break;
	case TP_VALIDITY_INVALID_XY:
		sys.tp_x = 0xffff;
		sys.tp_y = 0xffff;
		break;
	default:
		sys.tp_x = tpDisp.x;
		sys.tp_y = tpDisp.y;
	}

	sys.tp_trg	= (u16)(tpDisp.touch & (tpDisp.touch ^ sys.tp_cont));	// gK 
	sys.tp_cont	= tpDisp.touch;										// x^ 
	
#endif	/// 
	
	if( tpDisp.validity == TP_VALIDITY_VALID  ){		// W̗L`FbN
		// ^b`plWL
		sys.tp_x = tpDisp.x;
		sys.tp_y = tpDisp.y;
	}else{
		// ^b`plW
		// 1VNO̍Wi[ĂƂ̂ݍŴ܂܎󂯌p
		if( sys.tp_cont ){
			switch(tpDisp.validity){
			case TP_VALIDITY_INVALID_X:
				sys.tp_y = tpDisp.y;
				break;
			case TP_VALIDITY_INVALID_Y:
				sys.tp_x = tpDisp.x;
				break;
			case TP_VALIDITY_INVALID_XY:
				break;
			default:	// 
				break;
			}
		}else{
			// gK̃^C~OȂA
			// ^b`plĂȂƂɂ
			tpDisp.touch = 0;
		}
	}
	sys.tp_trg	= (u16)(tpDisp.touch & (tpDisp.touch ^ sys.tp_cont));	// gK 
	sys.tp_cont	= tpDisp.touch;										// x^ 

}

//--------------------------------------------------------------------------------------------
/**
 * L[̕ϊ
 *
 * @param	none
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
#define KEYCONV( key, check_pat, set_pat )	{ if( key & check_pat ) key |= set_pat; }
#define KEYCONV_RESET( key, check_pat, set_pat ) {	\
	if( key & check_pat ){							\
		key |= set_pat;								\
		key &= ( check_pat^0xffff );				\
	}												\
}
#define KEYCONV_EXCHANGE( key, pat1, pat2 ) {	\
	int	tmp = 0;								\
	if( key & pat1 ){							\
		tmp |= pat2;							\
	}											\
	if( key & pat2 ){							\
		tmp |= pat1;							\
	}											\
	key &= ( (pat1 | pat2 )^0xffff );			\
	key |= tmp;									\
}
#define KEY_RESET( key, reset_pat ) {			\
	key &= ( reset_pat^0xffff );				\
}

static void KeyConvert(void)
{
	switch( sys.key_control_mode ){

	default:
	case KEYCONTROL_NORMAL:
		break;

	case KEYCONTROL_PATTERN1:

		KEYCONV( sys.trg, PAD_BUTTON_START, PAD_BUTTON_X )
		KEYCONV( sys.cont, PAD_BUTTON_START, PAD_BUTTON_X )
		KEYCONV( sys.repeat, PAD_BUTTON_START, PAD_BUTTON_X )
		break;

	case KEYCONTROL_PATTERN2:

		KEYCONV_EXCHANGE( sys.trg, PAD_BUTTON_X,PAD_BUTTON_Y )
		KEYCONV_EXCHANGE( sys.cont, PAD_BUTTON_X,PAD_BUTTON_Y )
		KEYCONV_EXCHANGE( sys.repeat, PAD_BUTTON_X,PAD_BUTTON_Y )
		break;

	case KEYCONTROL_PATTERN3:

		KEYCONV( sys.trg, PAD_BUTTON_L, PAD_BUTTON_A )
		KEYCONV( sys.cont, PAD_BUTTON_L, PAD_BUTTON_A )
		KEYCONV( sys.repeat, PAD_BUTTON_L, PAD_BUTTON_A )

		KEY_RESET( sys.trg, ( PAD_BUTTON_L | PAD_BUTTON_R ) )
		KEY_RESET( sys.cont, ( PAD_BUTTON_L | PAD_BUTTON_R ) )
		KEY_RESET( sys.repeat, ( PAD_BUTTON_L | PAD_BUTTON_R ) )
		break;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * L[s[g̑xƃEFCgZbg
 *
 * @param	speed	x
 * @param	wait	EFCg
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void sys_KeyRepeatSpeedSet( int speed, int wait )
{
	sys.repeatSpeed	= speed;
	sys.repeatWait	= wait;
}


/*---------------------------------------------------------------------------*
  @brief	\tgEGAZbgԂ֎~
 *---------------------------------------------------------------------------*/
void sys_SoftResetNG(u8 softResetBit)
{
	sys.DontSoftReset |= softResetBit;
}

/*---------------------------------------------------------------------------*
  @brief	\tgEGAZbgԂ
 *---------------------------------------------------------------------------*/
void sys_SoftResetOK(u8 softResetBit)
{
	sys.DontSoftReset &= ~(softResetBit);
}

