//=============================================================================================
/**
 * @file	tcb.c
 * @brief	ėp^XN䃂W[{
 * @author	tamada(GAME FREAK Inc.)
 * @date	2005.10.06
 * @since	2003.01.20
 *
 * @data	2004.10.14 AGB -> NDS
 * @author	Hiroyuki Nakamura
 *
 * @date	2005.10.06
 */
//=============================================================================================
#include <nitro.h>
#include "tcb.h"
#include "heapsys.h"
#include "assert.h"

//=============================================================================================
//	
//=============================================================================================
#define TASK_ADDPROC_CHECK		///< ̃tOLƁATCB_Add 쒆Ɋ荞݂TCB_MainĂ΂ꂽAsȂB



//=============================================================================================
//	`
//=============================================================================================
enum{
	TCB_ENABLE = 0,
	TCB_DISABLE = 1,
};

//------------------------------------------------------------------
/** @brief	TCB\̂̒`
 *
 * TCB\̂́AD揇ʂɏ]ăNB
 * ̂ߑoN\悤ɑOւ̃|C^B
 *
 * ܂Aꂼ̎ۂ̏ɕKvȃ[NGA͎A
 * TCBo^Ɏgp郏[NGAƂēnB
 *
 * [U[xł͎QƂKv̂Ȃoւ̃ANZX𐧌邽߁A
 * ̍\̂̓W[炵ANZXłȂB
 * Kvȕ̓ANZX֐oR悤ɂȂĂB
 */
//------------------------------------------------------------------
typedef struct _TCB {
	TCBSYS* sys;				///<ǗĂTCBVXeւ̃|C^
	TCB_PTR prev;				///<OTCBւ̃|C^
	TCB_PTR next;				///<TCBւ̃|C^
	u32 pri;					///<vCIeB
	void * work;				///<[NGAւ̃|C^
	TCB_FUNC func;				///<s֐ւ̃|C^

	u32 sw_flag;				///<֐ǉtO
}TCB;	// 52 bytes


typedef struct _TCBSYS {
	u16			tcb_max;		///< o^\TCB̍ő吔
	u16			tcb_stack_ptr;	///< MĂTCBpX^bÑ|C^
	TCB			tcb_first;		///< TCB擪
	TCB_PTR*	tcb_stack;		///< TCBpX^bN
	TCB*		tcb_table;		///< TCB̃e[u
	BOOL		adding_flag;	///< TCBǉstOĩtOĂԂMainsȂj


	TCB_PTR		now_chain;		///< C[vgpAێTCB|C^
	TCB_PTR		next_chain;		///< C[vgpAێTCB|C^
}TCBSYS;	// 68 bytes


//==============================================================
// Prototype
//==============================================================
static void TCB_WorkClear( TCBSYS* tcbsys, TCB_PTR tcb);
static void InitTCBStack( TCBSYS* tcbsys );
static TCB * PopTCB( TCBSYS* tcbsys );
static int PushTCB( TCBSYS* tcbsys, TCB * tcb );
static TCB_PTR AddTask( TCBSYS* tcbsys, TCB_FUNC func, void* work, u32 pri );


//=============================================================================================
//
//	[J֐
//
//=============================================================================================
//------------------------------------------------------------------
/**
 * @brief	TCB\̂̏
 *
 * TCB̃oϐ
 * ֐łƃ}Nł܂
 *
 * @param	tcb	TCBւ̃|C^
 * @return	none	
 */
//------------------------------------------------------------------
#define TCBWorkClear(psys,ptcb)			\
{										\
	(ptcb)->sys = (psys);				\
	(ptcb)->prev = 						\
	(ptcb)->next = &(psys->tcb_first);	\
										\
	(ptcb)->pri = 0;					\
	(ptcb)->work = NULL;				\
	(ptcb)->func = NULL;				\
}

static void TCB_WorkClear( TCBSYS* tcbsys, TCB_PTR tcb)
{
	tcb->sys = tcbsys;

	tcb->prev = 
	tcb->next = &(tcbsys->tcb_first);

	tcb->pri = 0;
	tcb->work = NULL;
	tcb->func = NULL;
}
//------------------------------------------------------------------
/**
 * @brief	TCBX^bN
 *
 * gpTCBێX^bN
 */
//------------------------------------------------------------------
static void InitTCBStack( TCBSYS* tcbsys )
{
	int i;

	for( i=0; i<tcbsys->tcb_max; i++ )
	{
		TCB_WorkClear( tcbsys, &(tcbsys->tcb_table[i]) );
		tcbsys->tcb_stack[i] = tcbsys->tcb_table + i;
	}
	tcbsys->tcb_stack_ptr = 0;
}

//------------------------------------------------------------------
/**
 * @brief	TCBX^bN̎o
 *
 * @retval	NULLȊO	TCBւ̃|C^
 * @retval	NULL		oɎsiX^bN󂾂ꍇj
 */
//------------------------------------------------------------------
static TCB * PopTCB( TCBSYS* tcbsys )
{
	TCB_PTR tcb;
	if(tcbsys->tcb_stack_ptr == tcbsys->tcb_max)
	{
		return NULL;
	}
	tcb = tcbsys->tcb_stack[ tcbsys->tcb_stack_ptr ];
	tcbsys->tcb_stack_ptr++;
	return tcb;
}

//------------------------------------------------------------------
/**
	@brief	TCBX^bNւ̃vbV

	@param	tcb		vbVTCB̃|C^
	@retval	TRUE	
	@retval	FALSE	siX^bNς̏ꍇj
*/
//------------------------------------------------------------------
static int PushTCB( TCBSYS* tcbsys, TCB * tcb )
{
	if(tcbsys->tcb_stack_ptr == 0)
	{
		return FALSE;
	}
	TCBWorkClear( tcbsys, tcb );	//lNAĂX^bNɐς
	tcbsys->tcb_stack_ptr--;
	tcbsys->tcb_stack[ tcbsys->tcb_stack_ptr ] = tcb;
	return TRUE;
}


//=============================================================================================
//
//	J֐
//
//=============================================================================================

//------------------------------------------------------------------
/**
 * TCB VXe\ẑɕKvȃʂvZ
 *
 * @param   task_max		ғłő^XN
 *
 * @retval  u32		TCYioCgPʁj
 */
//------------------------------------------------------------------
u32 TCBSYS_CalcSystemWorkSize( u32 task_max )
{
	return sizeof(TCBSYS) + (sizeof(TCB_PTR)+sizeof(TCB)) * task_max;
}

//------------------------------------------------------------------
/**
 * TCBVXe쐬
 *
 * @param   task_max		ғłő^XN
 * @param   work_area		VXe쐬ɕKv[ȃTCỸ[NGAAhX
 *
 * @retval  TCBSYS*		쐬ꂽTCBVXe|C^
 *
 * work_area ɕKvȃTCÝATCBSYS_CalcSystemWorkSize ŌvZB
 */
//------------------------------------------------------------------
TCBSYS*  TCBSYS_Create( u32 task_max, void* work_area )
{
	TCBSYS* tcbsys;

	GF_ASSERT( work_area );

	tcbsys = work_area;

	tcbsys->tcb_stack = (TCB_PTR*) ((u8*)(tcbsys) + sizeof(TCBSYS));
	tcbsys->tcb_table = (TCB*) ((u8*)(tcbsys->tcb_stack) + sizeof(TCB_PTR)*task_max);

	tcbsys->tcb_max = task_max;
	tcbsys->tcb_stack_ptr = 0;
	tcbsys->adding_flag = FALSE;

	TCBSYS_Init( tcbsys );

	return tcbsys;
}

//------------------------------------------------------------------
/**
 *	VXegpȌ
 */
//------------------------------------------------------------------
void TCBSYS_Init( TCBSYS* tcbsys )
{
	//X^bN̏
	InitTCBStack( tcbsys );
	//擪ubN̏
	TCBWorkClear( tcbsys, &tcbsys->tcb_first );

	tcbsys->now_chain = tcbsys->tcb_first.next;
}

//------------------------------------------------------------------
//	TCBC
//------------------------------------------------------------------
void TCBSYS_Main( TCBSYS* tcbsys )
{
	#ifdef TASK_ADDPROC_CHECK
	if( tcbsys->adding_flag )
	{
		return;
	}
	#endif

	tcbsys->now_chain = tcbsys->tcb_first.next;	//s̎n߂̏ꏊ
	while (tcbsys->now_chain != &(tcbsys->tcb_first))
	{
		//s֐ŃubN폜ꂽpɃAhXۑ
		tcbsys->next_chain = tcbsys->now_chain->next;

		if(tcbsys->now_chain->sw_flag == TCB_ENABLE){//o^̓
			if(tcbsys->now_chain->func != NULL){
				tcbsys->now_chain->func(tcbsys->now_chain, tcbsys->now_chain->work);
			}
		}else{
			tcbsys->now_chain->sw_flag = TCB_ENABLE;
		}
		tcbsys->now_chain = tcbsys->next_chain;	//̘A
	}
	tcbsys->now_chain->func = NULL;
}

//------------------------------------------------------------------------------
/**
	@brief	TCBǉ
	@param	tcbsys	TCBVXe|C^
	@param	func	TCB_FUNC:֘Ats֐|C^
	@param	work	void*:֘At郏[NGAւvoid^|C^
	@param	pri		u32:^XNvCIeB

	@return	TCB_PTR	ǉTCB|C^
*/
//------------------------------------------------------------------------------
TCB_PTR TCBSYS_AddTask( TCBSYS* tcbsys, TCB_FUNC func, void* work, u32 pri )
{
	TCB_PTR  ret;

	tcbsys->adding_flag = TRUE;
	ret = AddTask( tcbsys, func, work, pri );
	tcbsys->adding_flag = FALSE;
	return ret;

}
//------------------------------------------------------------------
/**
 * TCBǉ
 *
 * @param   tcbsys		TCBVXe|C^
 * @param   func		TCBɊ֘At֐|C^
 * @param   work		TCBɊ֘At郏[NGAւ̃|C^
 * @param   pri			^XNvCIeB
 *
 * @retval  TCB_PTR		ǉTCB|C^
 */
//------------------------------------------------------------------
static TCB_PTR AddTask( TCBSYS* tcbsys, TCB_FUNC func, void* work, u32 pri )
{
	TCB_PTR get;
	TCB_PTR find;

	get = PopTCB( tcbsys );	//󂢂ĂTCBE
	if(get == NULL)
	{
		//o^悤Ƃ^XNȂ
		OS_TPrintf("ERR : TCB wasn't get!");
		return NULL;
	}

	//p[^Zbg
	get->pri = pri;
	get->work = work;
	get->func = func;
	//tOݒ
	if(tcbsys->now_chain->func != NULL){
		//tOݒ(ʂ̃^XNǉ悤ƂĂꍇAo^̓鏈)
		if(tcbsys->now_chain->pri <= pri){
			get->sw_flag = TCB_DISABLE;
		}else{
			get->sw_flag = TCB_ENABLE;
		}
	}
	else{
		//{^XNO̓o^
		get->sw_flag = TCB_ENABLE;
	}

	//sXgɐڑ(vCIeB̎ɂ́Aɓo^ق)
	for(find = tcbsys->tcb_first.next; find != &(tcbsys->tcb_first); find = find->next)
	{
		if(find->pri > get->pri){	//find̑OgetȂ
			get->prev = find->prev;
			get->next = find;
			find->prev->next = get;
			find->prev = get;
			if(find == tcbsys->next_chain){
				tcbsys->next_chain = get;
			}
			return get;
		}
	}
	//Ō܂ŌqƂ낪Ȃ΍ŌɌq
	if(tcbsys->next_chain == &(tcbsys->tcb_first)){
		tcbsys->next_chain = get;
	}
	get->prev = tcbsys->tcb_first.prev;	//܂ł̍Ō
	get->next = &(tcbsys->tcb_first);	//Ō
	tcbsys->tcb_first.prev->next = get;	//܂ōŌゾubN͎̎
	tcbsys->tcb_first.prev = get;		//Xg̍ŌXV
	return get;
}

//------------------------------------------------------------------------------
/**
	@brief	TCB
	@param	tcb		TCB|C^
*/
//------------------------------------------------------------------------------
void TCBSYS_DeleteTask( TCB_PTR tcb )
{
	//AVXe̎̃N悪폜Ώۂ̏ꍇ̏
	if(tcb->sys->next_chain == tcb){
		tcb->sys->next_chain = tcb->next;	//폜ΏTCB̎TCB֘Aړ
	}
	//Xg폜
	tcb->prev->next = tcb->next;
	tcb->next->prev = tcb->prev;

	PushTCB( tcb->sys, tcb );
}


//==================================================================
//	TCBANZX֐
//==================================================================

//------------------------------------------------------------------
//TCB̓֐؂ւ
//------------------------------------------------------------------
void TCB_ChangeFunc(TCB_PTR tcb, TCB_FUNC func)
{
	tcb->func = func;
}

//------------------------------------------------------------------
//TCB̃[NAhX擾
//------------------------------------------------------------------
void * TCB_GetWork(TCB_PTR tcb)
{
	return tcb->work;
}

//------------------------------------------------------------------
//TCBvCIeB̎擾
//------------------------------------------------------------------
u32 TCB_GetPriority(TCB_PTR tcb)
{
	return tcb->pri;
}







