//****************************************************************************
/**
 *
 *@file		touchpanel.c
 *@brief	`ƃ^b`plVXeƂ̓蔻菈
 *@author	taya
 *@data		2005.07.29
 *
 */
//****************************************************************************

#include "common.h"

#define __TOUCHPANEL_H_GLOBAL__
#include "gflib/touchpanel.h"


//==============================================================
// Prototype
//==============================================================
static int recthit( const RECT_HIT_TBL* pTbl, u32 x, u32 y );
static BOOL circle_hitcheck( const TP_HIT_TBL *tbl, u32 x, u32 y );
static BOOL rect_hitcheck( const TP_HIT_TBL *tbl, u32 x, u32 y );


//----------------------------------------------------------------------------
/**
 *
 *@brief	`̓蔻	
 *
 *@param	pTbl		蔻e[u
 *@param	u32	x		^b`plxW
 *@param	u32 y		^b`plyW
 *
 *@return	int	qbge[ũCfbNXio[
 *				qbgf[^ƂRECT_HIT_NONE
 *
 */
//-----------------------------------------------------------------------------
static int recthit( const RECT_HIT_TBL* pTbl, u32 x, u32 y )
{
	int c;

	for(c = 0; pTbl[c].rect.top != RECT_HIT_END; c++)
	{
		if( ((u32)( x - pTbl[c].rect.left) < (u32)(pTbl[c].rect.right - pTbl[c].rect.left))
		&	((u32)( y - pTbl[c].rect.top) < (u32)(pTbl[c].rect.bottom - pTbl[c].rect.top))
		){
			return c;
		}
	}

	return RECT_HIT_NONE;
}

//------------------------------------------------------------------
/**
 * ~`ƂĂ̓蔻iPj
 *
 * @param   tbl		蔻e[u
 * @param   x		XW
 * @param   y		YW
 *
 * @retval  BOOL	TRUEœ
 */
//------------------------------------------------------------------
static BOOL circle_hitcheck( const TP_HIT_TBL *tbl, u32 x, u32 y )
{
	x = (tbl->circle.x - x) * (tbl->circle.x - x);
	y = (tbl->circle.y - y) * (tbl->circle.y - y);

	if( x + y < (tbl->circle.r * tbl->circle.r) )
	{
		return TRUE;
	}

	return FALSE;
}
//------------------------------------------------------------------
/**
 * `ƂĂ̓蔻iPj
 *
 * @param   tbl		蔻e[u
 * @param   x		wW
 * @param   y		xW
 *
 * @retval  BOOL		TRUEœ
 */
//------------------------------------------------------------------
static BOOL rect_hitcheck( const TP_HIT_TBL *tbl, u32 x, u32 y )
{
	if( ((u32)( x - tbl->rect.left) < (u32)(tbl->rect.right - tbl->rect.left))
	&	((u32)( y - tbl->rect.top) < (u32)(tbl->rect.bottom - tbl->rect.top))
	){
		return TRUE;
	}
	return FALSE;
}

//------------------------------------------------------------------
/**
 * `蔻ie[ugpAx^́j
 *
 * @param   pRectTbl		蔻e[uiI[R[hj
 *
 * @retval  int		e[uAqbgvf̃CfbNXio[
 *					qbgȂ RECT_HIT_NONE
 */
//------------------------------------------------------------------
int GF_TP_RectHitCont( const RECT_HIT_TBL* pRectTbl )
{
	if( sys.tp_cont ){
		return recthit( pRectTbl, sys.tp_x, sys.tp_y );
	}
	return RECT_HIT_NONE;
}
//------------------------------------------------------------------
/**
 * `蔻ie[ugpAgḰj
 *
 * @param   pRectTbl		蔻e[uiI[R[hj
 *
 * @retval  int		e[uAqbgvf̃CfbNXio[
 *					qbgȂ RECT_HIT_NONE
 */
//------------------------------------------------------------------
int GF_TP_RectHitTrg( const RECT_HIT_TBL *pRectTbl )
{
	if( sys.tp_trg ){
		return recthit( pRectTbl, sys.tp_x, sys.tp_y );
	}
	return RECT_HIT_NONE;
}
//------------------------------------------------------------------
/**
 * ^Cvi`E~`jȂ画肷ix^́j
 *
 * @param   tbl		蔻e[uiI[R[hj
 *
 * @retval  int		肪΂̗vfԍAȂ TP_HIT_NONE
 */
//------------------------------------------------------------------
int GF_TP_HitCont( const TP_HIT_TBL *tbl )
{
	if( sys.tp_cont ){
		int i;

		for(i = 0; i < tbl[i].circle.code != TP_HIT_END; i++)
		{
			if( tbl[i].circle.code == TP_USE_CIRCLE )
			{
				if( circle_hitcheck( &tbl[i], sys.tp_x, sys.tp_y ) ){
					return i;
				}
			}
			else
			{
				if( rect_hitcheck( &tbl[i], sys.tp_x, sys.tp_y ) ){
					return i;
				}
			}
		}
	}
	return TP_HIT_NONE;
}
//------------------------------------------------------------------
/**
 * ^Cvi`E~`jȂ画肷igḰj
 *
 * @param   tbl		蔻e[uiI[R[hj
 *
 * @retval  int		肪΂̗vfԍAȂ TP_HIT_NONE
 */
//------------------------------------------------------------------
int GF_TP_HitTrg( const TP_HIT_TBL *tbl )
{
	if( sys.tp_trg ){
		int i;

		for(i = 0; i < tbl[i].circle.code != TP_HIT_END; i++)
		{
			if( tbl[i].circle.code == TP_USE_CIRCLE )
			{
				if( circle_hitcheck( &tbl[i], sys.tp_x, sys.tp_y ) ){
					return i;
				}
			}
			else
			{
				if( rect_hitcheck( &tbl[i], sys.tp_x, sys.tp_y ) ){
					return i;
				}
			}
		}
	}
	return TP_HIT_NONE;
}

//------------------------------------------------------------------
/**
 * ^Cvi`E~`jȂ画肷ix^́j
 *
 * @param   tbl		蔻e[uiPj
 *
 * @retval  BOOL	ȂTRUE
 */
//------------------------------------------------------------------
BOOL GF_TP_SingleHitCont( const TP_HIT_TBL *tbl )
{
	if( sys.tp_cont ){
		if( tbl->circle.code == TP_USE_CIRCLE )
		{
			return circle_hitcheck( tbl, sys.tp_x, sys.tp_y );
		}
		else
		{
			return rect_hitcheck( tbl, sys.tp_x, sys.tp_y );
		}
	}
	return FALSE;
}
//------------------------------------------------------------------
/**
 * ^Cvi`E~`jȂ画肷igḰj
 *
 * @param   tbl		蔻e[uiPj
 *
 * @retval  BOOL	ȂTRUE
 */
//------------------------------------------------------------------
BOOL GF_TP_SingleHitTrg( const TP_HIT_TBL *tbl )
{
	if( sys.tp_trg ){
		if( tbl->circle.code == TP_USE_CIRCLE )
		{
			return circle_hitcheck( tbl, sys.tp_x, sys.tp_y );
		}
		else
		{
			return rect_hitcheck( tbl, sys.tp_x, sys.tp_y );
		}
	}
	return FALSE;
}


//------------------------------------------------------------------
/**
 * ^b`plɐGĂ邩
 *
 * @retval  BOOL		TRUEŐGĂ
 */
//------------------------------------------------------------------
BOOL GF_TP_GetCont( void )
{
	return sys.tp_cont;
}
//------------------------------------------------------------------
/**
 * ^b`plɐGĂ邩igKj
 *
 * @retval  BOOL		TRUEŐGꂽ
 */
//------------------------------------------------------------------
BOOL GF_TP_GetTrg( void )
{
	return sys.tp_trg;
}

//------------------------------------------------------------------
/**
 * ^b`plɐGĂȂ炻̍W擾ix^́j
 *
 * @param   x		wW󂯎ϐAhX
 * @param   y		xW󂯎ϐAhX
 *
 * @retval  BOOL	TRUEŐGĂBFALSEԂꍇAɂ͉ȂB
 */
//------------------------------------------------------------------
BOOL GF_TP_GetPointCont( u32* x, u32* y )
{
	if( sys.tp_cont )
	{
		*x = sys.tp_x;
		*y = sys.tp_y;
		return TRUE;
	}
	return FALSE;
}
//------------------------------------------------------------------
/**
 * ^b`plɐGĂȂ炻̍W擾igḰj
 *
 * @param   x		wW󂯎ϐAhX
 * @param   y		xW󂯎ϐAhX
 *
 * @retval  BOOL	TRUEŐGĂBFALSEԂꍇAɂ͉ȂB
 */
//------------------------------------------------------------------
BOOL GF_TP_GetPointTrg( u32* x, u32* y )
{
	if( sys.tp_trg )
	{
		*x = sys.tp_x;
		*y = sys.tp_y;
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	w肵WŁA蔻s܂B	
 *
 *	@param	tbl		蔻e[uizj
 *	@param	x		肘W
 *	@param	y		肙W
 *
 *	@retval  int		肪΂̗vfԍAȂ TP_HIT_NONE
 *
 *
 */
//-----------------------------------------------------------------------------
int GF_TP_HitSelf( const TP_HIT_TBL *tbl, u32 x, u32 y )
{
	int i;
	
	for(i = 0; i < tbl[i].circle.code != TP_HIT_END; i++)
	{
		if( tbl[i].circle.code == TP_USE_CIRCLE )
		{
			if( circle_hitcheck( &tbl[i], x, y ) ){
				return i;
			}
		}
		else
		{
			if( rect_hitcheck( &tbl[i], x, y ) ){
				return i;
			}
		}
	}
	return TP_HIT_NONE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Ŏw肵Wœ蔻s܂B@P
 *
 *	@param	tbl		蔻e[uiPj
 *	@param	x		蔻肘W
 *	@param	y		蔻肙W
 *
 *	@retval	TURE	
 *	@retval	FALSE	Ȃ
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL GF_TP_SingleHitSelf( const TP_HIT_TBL *tbl, u32 x, u32 y )
{
	if( tbl->circle.code == TP_USE_CIRCLE )
	{
		return circle_hitcheck( tbl, x, y );
	}
	else
	{
		return rect_hitcheck( tbl, x, y );
	}

	return FALSE;
}

