//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		touchpanel.c
 *@brief	^b`plVXe̎
 *@author	tomoya takahashi
 *@data		2004.12.03
 *
 */
 //]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include "system.h"
#include "assert.h"
#include "calc2d.h"
#define __TOUCHPANEL_SYSTEM_H_GLOBAL
#include "touchpanel_system.h"
#include "bg_system.h"
#include "gflib_os_print.h"

/*-----------------------------------------------------------------------------
 *					萔錾
 ----------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------
 *					\̐錾
 ----------------------------------------------------------------------------*/
//----------------------------------------------------------------------------
/**
 *					vg^Cv錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
/// ^b`plVXep
static u32 startSampling( u32 sync );		// TvO̊Jn߂]
static u32 stopSampling( void );					// TvO~
//static u32 mainBuff( u32 last_idx );		// obt@ɃTvOf[^i[
static u32 mainBuffComp( u32 type, u32 last_idx, u32 comp_num );	// k[h
static u32 mainBuffJust( u32 type, u32 last_idx );	// ̂܂܃obt@Ɋi[
//static u32 mainBuffNoLoop( u32 type, u32 last_idx, u32 comp_num );				// ̃obt@[vȂo[W
static void getThisSyncData( TP_ONE_DATA* pData, u32 last_idx );	// ̃VÑ^b`pl̏擾
static u32 modeBuff( u32 type, u32 last_idx, u32 comp_num );				// obt@O[h̃C֐

static void setStartBufferingParam( u32 SampFlag, u32 auto_samp, void* pBuff, u32 buffSize, u32 nowBuffPoint, u32 Sync );
static void oneSyncBuffClean( TPData* pBuff, int num );

//-------------------------------------
// ^b`plAGp
//
// obt@璸_ƃxNgf[^쐬
static u32 makePointData( TPData* pBuff, u32 size, u16 check_num, Vec2DS32* p_work );
// ׂ݂_`FbN
static u8	checkInVector( Vec2DS32* p_main_s, Vec2DS32* p_main_e, Vec2DS32* vect_1, Vec2DS32* vect_2, Vec2DS32* vect_3 );
// ŏI_ƍŏ̓_Ȃ
static u32	crossToPict( TPData s_TPData, Vec2DS32* p_check, Vec2DS32* p_in, u32 dist );
// _܂ł̃f[^ɂ
static u32 crossEndPict( Vec2DS32* p_work, u32* p_size, u8 flag );
//----------------------------------------------------------------------------
/**
 *					O[oϐ錾
 */
//-----------------------------------------------------------------------------
typedef struct {
	TPData* pTouchPanelBuff;					// obt@|C^i[p
	u32		TouchPanelBuffSize;						// obt@TCYi[p
	u32		TouchPanelSync;							// Pt[ɉTvO邩
	TPData	TouchPanelOneSync[ TP_ONE_SYNC_BUFF ];	// Pt[ɃTvOꂽf[^i[p
	u32		TouchPanelNowBuffPoint;					// obt@Ƀf[^ĂƂ
	u16		TouchPanelSampFlag;						// TvOtO
	u16		TouchPanelExStop;						// TvO~tO
} TOUCH_PANEL_WORK;

static TOUCH_PANEL_WORK TPWork;


//----------------------------------------------------------------------------
/**
 *
 *@brief	^b`plgp鏀s܂
 *
 *@param	none
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void InitTPSystem( void )
{

	// X[v~
	GF_ASSERT( TPWork.TouchPanelExStop == FALSE );
	
	// TvOtO
	TPWork.TouchPanelSampFlag = TP_SAMP_NONE;
	TPWork.TouchPanelExStop = FALSE;
}


//----------------------------------------------------------------------------
/**
 *@brief	^b`pl̃TvOJn
 *
 *@param	p_buffFTvOf[^obt@
 *@param	sizeFobt@̃TCY
 *@param	syncFPt[ɉTvÔ(MAX4)
 *
 *@retval	TP_OKF
 *@retval@	TP_FIFO_ERRF]s
 *@retval	TP_ERRF]ȊO̎s
 */
//-----------------------------------------------------------------------------
u32 InitTP( TPData* p_buff, u32 size, u32 sync )
{
	int	check_num = 0;
	u32	result;
	int i;

	// X[v~
	GF_ASSERT( TPWork.TouchPanelExStop == FALSE );
	
	// ^b`plTvOVXeɃTvOJn߂𑗂A
	// Ɏsꂽ`FbN
	// Pt[ɂTȏTvO悤ƂG[Ԃ
	if( (sync >= 5) || (sync <= 0) ){
#ifdef TOUCHPANEL_SYSTEM_OS_PRINTF_ON
		OS_Printf( "Pt[̃TvO͂SōłB%d͂ł܂\n", sync );
#endif
		return TP_ERR;
	}

	// TvOȂ甲
	if( TPWork.TouchPanelSampFlag != TP_SAMP_NONE ){
#ifdef TOUCHPANEL_SYSTEM_OS_PRINTF_ON
		OS_Printf("InitTPFTvOł\n");
#endif
		return TP_ERR;
	}
	
	// TvOߓ]
	result = startSampling( sync );

	// ]ɎsG[Ԃ
	if( result != TP_OK ){
		return result;
	}

	// TvOf[^ݒ
	setStartBufferingParam( TP_BUFFERING, TRUE,
			p_buff, size, 0,
			sync * 2 ); // 30t[̂

	return TP_OK;
}

//----------------------------------------------------------------------------
/**
 *@brief	^b`pl̃TvOJn	obt@OȂ
 *
 *@param	syncFPt[ɉTvÔ(MAX4)
 *
 *@retval	TP_OKF
 *@retval@	TP_FIFO_ERRF]s
 *@retval	TP_ERRF]ȊO̎s
 */
//-----------------------------------------------------------------------------
u32 InitTPNoBuff( u32 sync )
{
	u32	result;
	int i;

	// X[v~
	GF_ASSERT( TPWork.TouchPanelExStop == FALSE );
	
	// ^b`plTvOVXeɃTvOJn߂𑗂A
	// Ɏsꂽ`FbN
	// Pt[ɂTȏTvO悤ƂG[Ԃ
	if( (sync >= 5) || (sync <= 0) ){
#ifdef TOUCHPANEL_SYSTEM_OS_PRINTF_ON
		OS_Printf( "Pt[̃TvO͂SōłB%d͂ł܂\n", sync );
#endif
		return TP_ERR;
	}

	// TvOȂ甲
	if( TPWork.TouchPanelSampFlag != TP_SAMP_NONE ){
#ifdef TOUCHPANEL_SYSTEM_OS_PRINTF_ON
		OS_Printf("InitTPFTvOł\n");
#endif
		return TP_ERR;
	}
	
	// TvOߓ]
	result = startSampling( sync );

	// ]ɎsG[Ԃ
	if( result != TP_OK ){
		return result;
	}

	// TvOf[^ݒ
	setStartBufferingParam( TP_NO_BUFF, TRUE,
			NULL, 0, 0,
			sync * 2 ); // 30t[̂
	

	return TP_OK;
}


//----------------------------------------------------------------------------
/**
 *	@brief	TvOJñf[^ݒ
 *
 *	@param	SampFlag		TvOtO
 *	@param	auto_samp		AUTOTvOtO
 *	@param	pBuff			obt@|C^
 *	@param	buffSize		obt@TCY
 *	@param	nowBuffPoint	Tv̈ʒu
 *	@param	Sync			VN
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void setStartBufferingParam( u32 SampFlag, u32 auto_samp, void* pBuff, u32 buffSize, u32 nowBuffPoint, u32 Sync )
{
	// TvOtOZbg
	TPWork.TouchPanelSampFlag = SampFlag;
	sys.tp_auto_samp = auto_samp;		// VXẽtOI[gTvOɂ
	// obt@̃|C^ƃTCYi[
	TPWork.pTouchPanelBuff = pBuff;
	TPWork.TouchPanelBuffSize = buffSize;
	TPWork.TouchPanelSync = Sync;
	TPWork.TouchPanelNowBuffPoint = nowBuffPoint;
	oneSyncBuffClean( TPWork.TouchPanelOneSync, TP_ONE_SYNC_BUFF );
}

//----------------------------------------------------------------------------
/**
 *	@brief	1VNpobt@̏
 *
 *	@param	pBuff	obt@
 *	@param	num		
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void oneSyncBuffClean( TPData* pBuff, int num )
{
	int i;

	for( i = 0; i < num; i++ ){
		pBuff[ i ].touch = 0;
	}	
}

//----------------------------------------------------------------------------
/**
 *	@brief	TvO~
 */
//-----------------------------------------------------------------------------
static u32 stopSampling( void )
{
	u32 check_num = 0;			// 
	u32 result;					// 
	int	i;						// [vp

	// ݂̃TvOI
	// ɖ߂̓]Ǘ
	//
	// TvOĂ̂
	if( TPWork.TouchPanelSampFlag == TP_SAMP_NONE )
	{
		// TvOĂȂ̂łƂ܂ԂłB
		return TP_OK;
	}

	// I߂G[AĂԑ葱
	// iFIFOARM7ɖ߂𑗂Ă邽߁AKvj
	do
	{
		// I߂𑗂
		TP_RequestAutoSamplingStopAsync();
		
		// ߃NGXgI҂
		TP_WaitBusy( TP_REQUEST_COMMAND_FLAG_AUTO_OFF );
	
		// G[IĂȂ`FbN
		result = TP_CheckError( TP_REQUEST_COMMAND_FLAG_AUTO_OFF );
		if( result != 0 )
		{
			check_num++;		// G[JEg
		}

		// G[AĂāAG[TP_REQUEST_CHECK_MAXȉ̊ԃ[v
	}while( (result != 0) && (check_num <= TP_REQUEST_CHECK_MAX) );


	// check_num T傫ƂFALSE]
	if( check_num > TP_REQUEST_CHECK_MAX )
	{
#ifdef TOUCHPANEL_SYSTEM_OS_PRINTF_ON
		OS_Printf( "Iߓ]s\n" );
#endif
		return TP_FIFO_ERR;
	}
	return TP_OK;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	TvOI
 *
 *@param	none
 *
 *@retval	TP_OKF
 *@retval@	TP_FIFO_ERRF]s
 *@retval	TP_ERRF]ȊO̎s
 *
 */
//-----------------------------------------------------------------------------
u32 StopTP( void )
{
	u32 result;

	// X[v~
	GF_ASSERT( TPWork.TouchPanelExStop == FALSE );
	
	result = stopSampling();
	if( result == TP_OK ){
		// i[Ăf[^j
		setStartBufferingParam( TP_SAMP_NONE, 0, NULL, 0, 0, 0 );
	}
	return result;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	TvOǗȀԂԂ	
 *
 *@param	pDataF̃t[̏(initŎw肵TvO񐔕̏)
 *@param	typeFTvOʂ̔ԍ
 *@param	comp_numFobt@Ɋi[ƂɁAcomp_numʂ̂i[
 *
 *@return	u32FTvOʂɂω
					typeFTP_BUFFERING		TvOꂽobt@TCY
					typeFTP_NO_LOOP		TvOꂽobt@TCY
											obt@tɂȂƂ TP_END_BUFF
					typeFTP_NO_BUFF		TP_OK

					typeFTP_SAMP_NOT_START	TvOJnĂ܂
 */
//-----------------------------------------------------------------------------
u32 MainTP( TP_ONE_DATA* pData, u32 type, u32 comp_num )
{
	u32 ret = TP_SAMP_NOT_START;	// ߂l
	u32 last_idx;					// ŌɃTvOꂽʒu

	// X[v~
	GF_ASSERT( TPWork.TouchPanelExStop == FALSE );

	// TvOĂ邩`FbN
	if( TPWork.TouchPanelSampFlag != TP_SAMP_NONE ){

		// ŌɃTvOʒu擾
		last_idx  = TP_GetLatestIndexInAuto();
		
		// ʍWɕύX
		ChangeTPDataBuff( TPWork.TouchPanelOneSync, TP_ONE_SYNC_BUFF );

		// ̃t[̏擾
		if( pData != NULL ){
			getThisSyncData( pData, last_idx );
		}
		
		// typẽobt@O܂͍̃t[擾
		// f[^ZbgĕԂ
		// ܂obt@OInitĂ邩`FbN
		if( TPWork.TouchPanelSampFlag == TP_BUFFERING ){
			ret = modeBuff( type, last_idx, comp_num );	
		}else{
			// ̑̂ƂTP_OKԂ
			ret = TP_OK;
		}
	}else{
#ifdef TOUCHPANEL_SYSTEM_OS_PRINTF_ON
	
		OS_Printf( "MainTP֐ warningFTvOJnĂ܂\n" );
#endif
	}

	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	̍WʍWɂĕԂ
 *
 *@param	pDataFύX^b`plf[^
 *
 *@return	ύX̃f[^
 *
 */
//-----------------------------------------------------------------------------
TPData ChangeTPData( TPData* pData )
{
	TPData sample;		// 擾p

	// X[v~
	GF_ASSERT( TPWork.TouchPanelExStop == FALSE );
	
	// ̃^b`pllʍWɕϊĕԂ
	TP_GetCalibratedPoint( &sample, pData );

	return sample;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	̍WʍWɂĕԂ(TPDatazp)
 *
 *@param	pDataFύX^b`plf[^z
 *@param	sizeFzTCY
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void ChangeTPDataBuff( TPData* pData, u32 size )
{	
	int i;		// [vp
	TPData sample;

	// ̃^b`pllʍWɕϊĕԂ
	for( i = 0; i < size; i++ ){
		TP_GetCalibratedPoint( &sample, &(pData[ i ]) );
		pData[ i ] = sample;
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	X[vO̒~@
 */
//-----------------------------------------------------------------------------
void ReStartTP_Sleep( void )
{
	u32 result;
	
	// ~`FbN
	if( TPWork.TouchPanelExStop == FALSE ){
		return ;
	}
	// TvO`FbN
	if( TPWork.TouchPanelSampFlag == TP_SAMP_NONE ){
		return ;
	}

	// TvOJn
	result = startSampling( TPWork.TouchPanelSync / 2 );	// /230VN̂
	GF_ASSERT( result == TP_OK );

	TPWork.TouchPanelExStop = FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	X[vO̕A
 */
//-----------------------------------------------------------------------------
void StopTP_Sleep( void )
{
	u32 result;
	// łɒ~`FbN
	if( TPWork.TouchPanelExStop == TRUE ){
		return ;
	}
	// TvO`FbN
	if( TPWork.TouchPanelSampFlag == TP_SAMP_NONE ){
		return ;
	}

	// TvO~
	result = stopSampling();
	GF_ASSERT( result == TP_OK );

	TPWork.TouchPanelExStop = TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	I[gTvOJn߂]
 *
 *@param	syncFPt[̃TvO
 *
 *@return	TP_OKF
 *@return@	TP_FIFO_ERRF]s
 *
 */
//-----------------------------------------------------------------------------
static u32 startSampling( u32 sync )
{
	int	check_num = 0;
	u32	result;


	// Jn߂G[AĂԑ葱
	// iFIFOARM7ɖ߂𑗂Ă邽߁AKvj
	do
	{
		// Jn߂𑗂
		TP_RequestAutoSamplingStartAsync( 
				0,			// x[XVJEg
				sync,		// Pt[ɉTvO邩
				TPWork.TouchPanelOneSync,				// TvOf[^i[pobt@
				TP_ONE_SYNC_BUFF );		// obt@TCY
		
		// ߃NGXgI҂
		TP_WaitBusy( TP_REQUEST_COMMAND_FLAG_AUTO_ON );

		// G[IĂȂ`FbN
		result = TP_CheckError( TP_REQUEST_COMMAND_FLAG_AUTO_ON );
		if( result != 0 )
		{
			check_num++;		// G[JEg
		}

		// G[AĂāAG[TP_REQUEST_CHECK_MAXȉ̊ԃ[v
	}while( (result != 0) && (check_num <= TP_REQUEST_CHECK_MAX) );


	// check_num T傫ƂFALSE]
	if( check_num > TP_REQUEST_CHECK_MAX )
	{
#ifdef TOUCHPANEL_SYSTEM_OS_PRINTF_ON
		OS_Printf( "X^[gߓ]s\n" );
#endif
		return TP_FIFO_ERR;
	}

	return TP_OK;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	TvOǗȀԂԂ
 *			obt@O[h
 *
 *@param	typeFTvOʂ̔ԍ
 *@param	last_idxFXgCfbNX
 *@param	comp_numFobt@Ɋi[ƂɁAcomp_numʂ̂i[(k[ĥ)
 *
 *@return	TvOʂɂω
					TP_BUFFERING---TvOꂽobt@TCY
					TP_NO_LOOP---TvOꂽobt@TCY
								 obt@tɂȂƂ TP_END_BUFF
					TP_NO_BUFF---TP_OK
 *
 */
//-----------------------------------------------------------------------------
static u32 modeBuff( u32 type, u32 last_idx, u32 comp_num )
{		
	u32 ret;		// ߂l
	
	
	//
	// typẽ[hŃobt@O
	switch( type ){
	case TP_BUFFERING:
	case TP_NO_LOOP:
		ret = mainBuffComp( type, last_idx, comp_num );
		break;
		
	case TP_BUFFERING_JUST:	// ̂܂܊i[
	case TP_NO_LOOP_JUST:
		ret = mainBuffJust( type, last_idx );
		break;

	default:		// ̑
		ret = TP_OK;
		break;			// ȂɂȂ
	}

	return ret;
}

// ʏňk[hɕύX
// kȂł̃obt@O͈klɂOw肷΂悢
#if 0
//----------------------------------------------------------------------------
/**
 *
 *@brief	obt@ɈkȂŁAWi[
 *
 *@param	last_idxFŌɃTvOʒu
 *
 *@return	obt@Ɋi[TCY
 *
 */
//-----------------------------------------------------------------------------
u32 mainBuff( u32 last_idx )
{
	int i;				// [vp
	s16	samp_work;		// TvOƗp

	//
	// ^b`pl̃TvOǗȀԂԂ
	//	
	// ^b`plobt@Ƃ̃t[̃TvOf[^
	// Ɋi[
	for( i = 0; i < TouchPanelSync; i++ ){
		samp_work = last_idx - TouchPanelSync + i + 1;

		// 0ȉ̂Ƃ͍ŏIvfɂ
		if( samp_work < 0 ){
			samp_work += TP_ONE_SYNC_BUFF;
		}

		// Lȃf[^̎obt@Ɋi[
		if( (TouchPanelOneSync[ samp_work ].touch == TP_TOUCH_ON) &&
			(TouchPanelOneSync[ samp_work ].validity == TP_VALIDITY_VALID) ){
			// TvOf[^i[
			pTouchPanelBuff[ TouchPanelNowBuffPoint ] = TouchPanelOneSync[ samp_work ];				
			TouchPanelNowBuffPoint = (TouchPanelNowBuffPoint + 1) % TouchPanelBuffSize;		// obt@烋[v
		}
	}

	
	// ŌɃTvOꂽCfbNXԂ	
	return TouchPanelNowBuffPoint;
}

#endif

static  inline int TouchPanel_GetDiff( int n1, int n2 )
{
	int calc = (n1 >= n2) ? (n1 - n2) : (n2 - n1);
	return calc;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	obt@ɈkāAWi[
 *
 *@param	type		obt@O^Cv
 *@param	last_idx	ŌɃTvOʒu
 *@param	comp_num	obt@Ɋi[ƂɁAcomp_numʂ̂i[
 *
 *@return	obt@Ɋi[TCY
 *
 */
//-----------------------------------------------------------------------------
static u32 mainBuffComp( u32 type, u32 last_idx, u32 comp_num )
{
	int i;				// [vp
	s32 dist_x;			// ǂ̂炢邩
	s32 dist_y;			// ǂ̂炢邩
	s16	samp_work;		// TvOƗp

	//
	// ^b`pl̃TvOǗȀԂԂ
	//
	// ^b`plobt@Ƃ̃t[̃TvOf[^
	// Ɋi[
	for( i = 0; i < TPWork.TouchPanelSync; i++ ){
		samp_work = last_idx - TPWork.TouchPanelSync + i + 1;

		// 0ȉ̂Ƃ͍ŏIvfɂ
		if( samp_work < 0 ){
			samp_work += TP_ONE_SYNC_BUFF;
		}

		// Lȃf[^̎obt@Ɋi[
		if( (TPWork.TouchPanelOneSync[ samp_work ].touch == TP_TOUCH_ON) &&
			(TPWork.TouchPanelOneSync[ samp_work ].validity == TP_VALIDITY_VALID) ){
			// ߂
			dist_x = TouchPanel_GetDiff(TPWork.pTouchPanelBuff[ TPWork.TouchPanelNowBuffPoint - 1 ].x, TPWork.TouchPanelOneSync[ samp_work ].x);
			dist_y = TouchPanel_GetDiff(TPWork.pTouchPanelBuff[ TPWork.TouchPanelNowBuffPoint - 1 ].y, TPWork.TouchPanelOneSync[ samp_work ].y);
			
			// comp_numȏォ`FbN
			if( (dist_x >= comp_num) ||
				(dist_y >= comp_num)){
					
				// TvOf[^i[
				TPWork.pTouchPanelBuff[ TPWork.TouchPanelNowBuffPoint ] = TPWork.TouchPanelOneSync[ samp_work ];				
				TPWork.TouchPanelNowBuffPoint++;
				
				// obt@TCYI[o[`FbN
				if(TPWork.TouchPanelNowBuffPoint >= TPWork.TouchPanelBuffSize){
					// obt@[v邩`FbN
					if(type == TP_BUFFERING){
						TPWork.TouchPanelNowBuffPoint %= TPWork.TouchPanelBuffSize;	// [v
					}else{
						return TP_END_BUFF;		// [vȂ
					}
				}
			}
		}
	}

	
	// ŌɃTvOꂽCfbNXԂ	
	return TPWork.TouchPanelNowBuffPoint;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	obt@ɗLf[^A^b`̔Ɋi[
 *
 *@param	type		obt@O^Cv
 *@param	last_idx	ŌɃTvOʒu
 *
 *@return	obt@Ɋi[TCY
 *
 */
//-----------------------------------------------------------------------------
static u32 mainBuffJust( u32 type, u32 last_idx )
{
	int i;				// [vp
	s16	samp_work;		// TvOƗp

	//
	// ^b`pl̃TvOǗȀԂԂ
	//
	// ^b`plobt@Ƃ̃t[̃TvOf[^
	// Ɋi[
	for( i = 0; i < TPWork.TouchPanelSync; i++ ){
		samp_work = last_idx - TPWork.TouchPanelSync + i + 1;

		// 0ȉ̂Ƃ͍ŏIvfɂ
		if( samp_work < 0 ){
			samp_work += TP_ONE_SYNC_BUFF;
		}

		// TvOf[^i[
		TPWork.pTouchPanelBuff[ TPWork.TouchPanelNowBuffPoint ] = TPWork.TouchPanelOneSync[ samp_work ];
		TPWork.TouchPanelNowBuffPoint++;

		// obt@TCYI[o[`FbN
		if(TPWork.TouchPanelNowBuffPoint >= TPWork.TouchPanelBuffSize){
			// obt@[v邩`FbN
			if(type == TP_BUFFERING_JUST){
				TPWork.TouchPanelNowBuffPoint %= TPWork.TouchPanelBuffSize;	// [v
			}else{
				return TP_END_BUFF;		// [vȂ
			}
		}
	}

	
	// ŌɃTvOꂽCfbNXԂ	
	return TPWork.TouchPanelNowBuffPoint;
}


// obt@O̕modeBuff()݂̂ōs悤ɕύX
// tɂȂ邩̃`FbNmodeBuff()ĂԑOɍ쐬A
// TvO͏IȂ悤ɕύX܂		05/03/29	tomoya
#if 0
//----------------------------------------------------------------------------
/**
 *
 *@brief	obt@[vȂ悤Ƀobt@Ɋi[
 *
 *@param	typeFk
 *@param	last_idxFŌɃTvOʒu
 *@param	comp_numFobt@Ɋi[ƂɁAcomp_numʂ̂i[(k[ĥ)
 *
 *@return	obt@Ɋi[TCY 
 *			obt@tɂȂAXgbvƂ TP_END_BUFF
 *
 */
//-----------------------------------------------------------------------------
u32 mainBuffNoLoop( u32 type, u32 last_idx, u32 comp_num )
{
	u32 last_buff;
	int	i;			// [vp
	
	//
	// ^b`pl̃TvOǗȀԂԂ
	// ̊֐̓obt@[vȂ悤ɊǗ܂B
	//
	// k[hłȂ`FbN
	switch( type ){
	case TP_NO_LOOP:
		// kȂ
		last_buff = mainBuff( last_idx );
		break;
	
	case TP_NO_LOOP_COMP:
		// k
		last_buff = mainBuffComp( last_idx, comp_num );
		break;

	case TP_NO_LOOP_JUST:
		// ̂܂
		last_buff = mainBuffJust( last_idx );
		break;

	default:
		last_buff = 0;
		break;
	}

	// ̃t[ōő傫ȂȂI
	if( last_buff + TouchPanelSync >= TouchPanelBuffSize )
	{
		// I܂ōŏI̒l
		for( i = last_buff; i < TouchPanelBuffSize; i++ ){
			pTouchPanelBuff[ i ] = pTouchPanelBuff[ i - 1 ];
		}

		// IKvȂ̂ŏI͂Ȃ
//		while( StopTP() != TRUE ) ;

		return TP_END_BUFF;
	}

	return last_buff;
}

#endif

//----------------------------------------------------------------------------
/**
 *
 *@brief	̃VÑTvO擾
 *
 *@param	pDataF̃VÑf[^ۑp̈̃|C^
 *@param	last_idxFŌɃTvOʒu
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void getThisSyncData( TP_ONE_DATA* pData, u32 last_idx )
{
	int i;				// [vp
	s16	samp_work;		// TvOƗp

	//
	// 
	//
	pData->Size = 0;
	for( i = 0; i < TP_ONE_SYNC_DATAMAX; i++ ){
		pData->TPDataTbl[ i ].validity = TP_VALIDITY_VALID;
		pData->TPDataTbl[ i ].touch = TP_TOUCH_OFF;
		pData->TPDataTbl[ i ].x = 0;
		pData->TPDataTbl[ i ].y = 0;
	}
	
	//
	// ^b`pl̃TvOǗȀԂԂ
	//
	// ^b`plobt@Ƃ̃t[̃TvOf[^
	// Ɋi[
	for( i = 0; i < TPWork.TouchPanelSync; i++ ){
		samp_work = last_idx - TPWork.TouchPanelSync + i + 1;

		// 0ȉ̂Ƃ͍ŏIvfɂ
		if( samp_work < 0 ){
			samp_work += TP_ONE_SYNC_BUFF;
		}

		//
		// Lf[^`FbN
		//
		if( TPWork.TouchPanelOneSync[ samp_work ].validity == TP_VALIDITY_VALID ){	
			// ̃t[̃TvOi[
			pData->TPDataTbl[ pData->Size ]  = TPWork.TouchPanelOneSync[ samp_work ];
			pData->Size++;
		}
	}
}

//
/// ^b`pl̊G̏֌W֐
//
//----------------------------------------------------------------------------
/**
 *
 *@brief	^b`pl񂩂G̏쐬
 *
 *@param	u32 typeF^Cv
 *@param	TPData* pBuffF^b`pl̃obt@
 *@param	u32 sizeFobt@̗vf
 *@param	u16 check_numF	^b`pl̓_炷Ƃ̊px
 *							iƐxAf[^Ȃj
 *@param	u32 distFI_Ǝn_ȂƂ̏I_Ǝn_̒̋E
					FOȂƐȂȂ
					FRQOȂƐ΂ɂȂ
 *@param	BOOL* p_crossFG̏͌_ŕĂ̂
 *@param	heap	gpq[v
 *
 *@return	TP_PICTURE_DATA* ^F쐬G̏
 *		********_ŕĂȂĂf[^͋AĂ̂ŁA
 *				̊֐ǂ񂾂K߂l̃f[^j
 *				Kv܂B**********
 *		
 *		
 *		_P`Q̃TCY͕̎ĂȂG̃f[^Ԃ܂B
 *
 */
//-----------------------------------------------------------------------------
TP_PICTURE_DATA* MakeTPPictureData( u32 type, TPData* pBuff, u32 size, u16 check_num, u32 dist, BOOL* p_cross, int heap )
{
	int i;						// [vp
	u32 count;					// KvȒ_ƃxNgf[^
	Vec2DS32* p_work;			// f[^쐬p̒_ƃxNg̃f[^
	TP_PICTURE_DATA* p_ret;		// ߂lŕԂGf[^
	u8	cross_flag = 0;			// G̃f[^
	
	//
	/// ^b`pl̏񂩂G̏쐬
	/// G̏Ƃ͒_Ǝ̓_܂ł̃xNgłB
	/// OɎgp܂B
	//
	// _xNgf[^쐬p̈m(ƗpŕKvőlm)
	p_work = sys_AllocMemory( heap, sizeof(Vec2DS32) * (size + 1) );		// n_ƏI_Ȃ\̂Ł{P
	

	//
	// }`f[^̒_
	//
	count = 0;

	//
	// G̏f[^쐬
	//
	if( size > 3 ){	
		
		// Sȏ̂Ƃ͒_炷
		count = makePointData( pBuff, size, check_num, p_work );
	}else{
		
		// Rȉ̎͒_炳ɂ̂܂ܓ
		for( i = 0; i < size; i++ ){
			p_work[ i ].x = pBuff[ i ].x;
			p_work[ i ].y = pBuff[ i ].y;
			count++;
		}
	}


	// p_crossiĂ邩jĂȂiFALSEj
	// 
	if( p_cross != NULL ){
		*p_cross = FALSE;
	}
	
	//
	// _Rȉ̎͌_͂肦Ȃ
	//
	if( count > 3 ){
		//
		// _P[h`FbN
		//
		if( (type == TP_MAKE_PICT_ONE_FAST) || 
			(type == TP_MAKE_PICT_ONE_END)){
			if( crossEndPict( p_work, &count, type ) == 1 ){
				// f[^ɂȂ
				if( p_cross != NULL ){
					*p_cross = TRUE;
				}
				// 
				cross_flag = 1;
			}
		}
	}

	// ĂȂ`FbN
	if( cross_flag == 0 ){
		//
		// _Qȉ̎͒Ȃ̂ŏI_Ɛ擪ȂKvȂ
		//
		if( count > 2 ){
	
			//
			// I_Ɛ擪Ȃ邩`FbN
			//
			if( crossToPict( pBuff[ 0 ], &p_work[ count - 1 ], &p_work[ count ], dist ) == 1 ){
				count++;		// f[^ꂽJEg

				// f[^ɂȂ
				if( p_cross != NULL ){
					*p_cross = TRUE;
				}
			}
		}
	}

		
		
	//
	// 쐬_ƃxNgf[^TP_PICTURE_DATAf[^ɃRs[
	//
	p_ret				= sys_AllocMemory( heap, sizeof(TP_PICTURE_DATA) );
	p_ret->pPointData	= sys_AllocMemory( heap, sizeof(Vec2DS32) * count );
	p_ret->Size			= count;



	// Rs[
	for( i = 0; i < count; i++ )
	{
		p_ret->pPointData[ i ] = p_work[ i ];

#if 0
		// Rs[Ȃ`(fobNp)
		if( i > 0 ){
			drawVect( &p_ret->pPointData[ i - 1 ], &p_ret->pPointData[ i ] );
		}

		DrawTPPaste();
#endif
	}


	// Ɨp̈j
	sys_FreeMemoryEz( p_work );

	return p_ret;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	I_Ǝn_q
 *
 *@param	TPData s_TPDataFn_̃f[^
 *@param	Vec2DS32* p_checkFI_̃|C^
 *@param	Vec2DS32* p_inFi[ʒũ|C^
 *@param	u32 distFĂĂ悢
 *
 *@return	u32^FȂ@PFq
 *
 */
//-----------------------------------------------------------------------------
static u32	crossToPict( TPData s_TPData, Vec2DS32* p_check, Vec2DS32* p_in, u32 dist )
{
	//
	// I_Ɛ擪Ȃ邩`FbN
	//
	if( GetVectorDistance( s_TPData.x, s_TPData.y,
				p_check->x, p_check->y ) <= dist ){
		// 擪Ƃ
		// ^b`pl̗̏Lȍŏ̃f[^ƗLȍŌ̃f[^̃xNgŌɃZbg
		//
		p_in->x = s_TPData.x;		// xNgW
		p_in->y = s_TPData.y;		// xNgW

		return 1;
	}

	return 0;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	p_work̃f[^_܂ł̃f[^ɂ
 *
 *@param	Vec2DS32* p_workFG̃f[^
 *@param	u32* p_sizeF̃f[^
 *@param	u8 flagFԍŏ̌_̃f[^ɂ邩AŌ̌_̃f[^ɂ邩
 *
 *@return	u32^F_ PF
 *
 */
//-----------------------------------------------------------------------------
static u32 crossEndPict( Vec2DS32* p_work, u32* p_size, u8 flag )
{
	int i, j;					// [vp
	int cross_i, cross_j;		// _̂ij̒l
	Vec2DS32 cross_mat;			// _W
	Vec2DS32 cross_tmp;			// _Wۑp
	u8	cross_num;				// _
	
	
	// tO
	cross_num = 0;

	//
	// 擪̃xNg_̈ʒu߂
	//
	for( i = 0; i < *p_size - 1; i++ ){
		for( j = *p_size - 2; j >= 0; j-- ){
			// ijt]_͂Ȃ
			if( i + 1 >= j ){
				break;
			}
			
			if( CheckCrossMatrix( &p_work[ i ], &p_work[ i + 1 ],
								  &p_work[ j ], &p_work[ j + 1 ], 
								  &cross_mat) == 1 )
			{
				cross_i = i;			// _̂i
				cross_j = j;			// _̂j
				cross_num++;			// _JEg
				cross_tmp = cross_mat;	// _ۑ
				break;
			}
		}

		// _`FbN
		if( (cross_num == 1) && (flag == TP_MAKE_PICT_ONE_FAST) ){
			break;
		}
	}

	//
	// _`FbN
	//
	if( cross_num > 0 ){
		//
		// i + 1Ƃ_̂xNg̐擪̒_
		// cross_mat̒g_̍W
		// 
		// p_work0ƍŌ̃f[^̈ʒuɌ_WZbgAij傫폜
		p_work[ 0 ] = cross_tmp;
	
		*p_size = 1;
		// ȉOj - (i +1)ɂȂ܂ł߂
		for( i = cross_i + 1; i < cross_j; i++ ){
			p_work[ *p_size ] = p_work[ i ];
			(*p_size)++;		// f[^JEg
		}
		p_work[ *p_size ] = cross_tmp;
		(*p_size)++;		// f[^JEg
		return 1;
	}

	return 0;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	sN`[f[^j
 *
 *@param	TP_PICTURE_DATA* pPictDataFG̃f[^
 *
 *@return	Ȃ
 *
 */
//-----------------------------------------------------------------------------
void DestTPPictureData( TP_PICTURE_DATA* pPictData )
{
	//
	// sN`[f[^j
	//
	if( pPictData != NULL ){
		sys_FreeMemoryEz( pPictData->pPointData );
		sys_FreeMemoryEz( pPictData );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	^b`plf[^璸_ƃxNg̃f[^쐬
 *
 *@param	Vec2DS32* p_pointF_ƃxNgf[^
 *
 *@return	u32^Ff[^
 *
 */
//-----------------------------------------------------------------------------
static u32 makePointData( TPData* pBuff, u32 size, u16 check_num, Vec2DS32* p_work )
{
	int	i, j;			// [vp
	u32 count;			// JE^
	u32	next;			// `FbN鎟̒_

	
	//
	// G̏쐬
	//
	count = 0;		// JE^
	i = 0;
	while( i <= size - 3 ){

		// ̓_Zbg	
		next = i + 1;
		// `FbNxNgQ̗vfjɃZbg
		j = next + 1;
		
		while( GetVectorAngle( 
				pBuff[ i ].x, pBuff[ i ].y,
				pBuff[ next ].x, pBuff[ next ].y,
				pBuff[ i ].x, pBuff[ i ].y,
				pBuff[ j ].x, pBuff[ j ].y ) <= check_num ){
			//
			// G̏ɃZbg_T
			//
			j++;

			// TCYɂȂI
			if( j >= size )
			{
				break;		// vf̃}bNXɂȂ甲
			}
		}

		//
		// i̓_Zbg<F9>
		// j - 1̓_܂ł͊i[ȂĂ悢Bj - 1`FbNĂ
		//
		p_work[ count ].x = pBuff[ i ].x;		// xNgJnW
		p_work[ count ].y = pBuff[ i ].y;		// xNgJnW
		count++;

		// I_(j - 1)̒liɃZbg
		i = j - 1;

	}
	
	// 
	// _cQȉɂȂĂ܂̂Ń`FbNłȂ
	// Ōisize -1̒lɂȂ܂ōW
	// 
	while( i < size ){
		p_work[ count ].x = pBuff[ i ].x;
		p_work[ count ].y = pBuff[ i ].y;
		count++;
		i++;
	}

	return count;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	O
 *
 *@param	TP_PICTURE_DATA* pDataFG̃f[^
 *@param	u16 xFW
 *@param	u16 yFW
 *
 *@return	u32^FOFO@PF
 *
 */
//-----------------------------------------------------------------------------
u32 CheckTPPictureInOut( TP_PICTURE_DATA* pData, u16 x, u16 y )
{
	return CheckInOut( pData->pPointData, pData->Size, x, y );
}
