//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	H16/11/08		Tomoya Takahashi
 *
 *		Vram]}l[W[̃^XNǗ
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <nitro.h>
#include <nnsys.h>
#include "system.h"
#include "vram_transfer_manager.h"
#include "assert.h"


//-------------------------------------
//	Vram]}l[W
//=====================================
typedef struct _VRAM_TRANSFER_MANAGER{
	u32						tasksNum;			// o^\^XN
	u32						add_task_num;		// ^XNo^
	NNSGfdVramTransferTask*	pTaskArray;			// ^XNϐ
} VRAM_TRANSFER_MANAGER;


//----------------------------------------------------------------------------
/**
 *					O[oϐ錾
 */
//-----------------------------------------------------------------------------
static VRAM_TRANSFER_MANAGER* pVramTransferManager;

static BOOL CallbackRegistTransferTask( NNS_GFD_DST_TYPE type, u32 dstAddr, void* pSrc, u32 szByte );

//----------------------------------------------------------------------------
/**
 *
 *@brief	Vram]}l[W[̏
 *
 *@param	tasks_numFo^\^XN
 *@param	heap		gpq[v
 *
 *@return	none
 *
 *ȊO̓ftHg̊֐gpĂB
 *
 */
//-----------------------------------------------------------------------------
void initVramTransferManagerHeap( u32 tasks_num, int heap )
{
	// ς
	GF_ASSERT( pVramTransferManager == NULL );


	// ̍쐬
	pVramTransferManager = sys_AllocMemory( heap, sizeof(VRAM_TRANSFER_MANAGER) );
	// mێs
	GF_ASSERT( pVramTransferManager );
	
	//
	// ^XN̈mۂAVram]}l[W[ 
	//
	// ̈m
	pVramTransferManager->pTaskArray = (NNSGfdVramTransferTask*)sys_AllocMemory( heap, sizeof(NNSGfdVramTransferTask) * tasks_num );

	// ^XN
	pVramTransferManager->tasksNum = tasks_num;
	pVramTransferManager->add_task_num = 0;

	// Vram]}l[W[
	NNS_GfdInitVramTransferManager( pVramTransferManager->pTaskArray, pVramTransferManager->tasksNum );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Vram]}l[W[̔j
 *
 *@param	none
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void DellVramTransferManager( void )
{
	// jς
	GF_ASSERT( pVramTransferManager != NULL );
	//
	//^XN̈j 
	//
	// ̈j
	sys_FreeMemoryEz( pVramTransferManager->pTaskArray );

	sys_FreeMemoryEz( pVramTransferManager );
	pVramTransferManager = NULL;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	Vram]}l[W[^XNo^
 *
 *@param	type		f[^]̎
 *@param	dstAddr		]AhX
 *@param	pSrc		]f[^ւ̃|C^
 *@param	szByte		]TCY
 *
 *@retval	TRUE			
 *@retval	FALSE		s
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL AddVramTransferManager( NNS_GFD_DST_TYPE type, u32 dstAddr, void* pSrc, u32 szByte )
{	
	// ĂȂ
	GF_ASSERT( pVramTransferManager );
	pVramTransferManager->add_task_num++;		// ^XNZ

	if(pVramTransferManager->add_task_num >= pVramTransferManager->tasksNum){	// ^XNI[o[`FbN
		GF_ASSERT(0&&("VramTransferManager^XNI[o["));
		return FALSE;
	}

	return NNS_GfdRegisterNewVramTransferTask(type, dstAddr, pSrc, szByte);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ۂɓ]
 *
 *@param	none
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void DoVramTransferManager( void )
{
	if(pVramTransferManager){
		NNS_GfdDoVramTransfer();
		pVramTransferManager->add_task_num = 0;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	̃^XNo^擾
 *
 *@param	none
 *
 *@return	int		^XNo^
 *
 *
 */
//-----------------------------------------------------------------------------
int GetVramTransferManagerAddNum( void )
{
	// ĂȂ
	GF_ASSERT( pVramTransferManager );
	return pVramTransferManager->add_task_num;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	Z]}l[W̏
 *
 *@param	num		őZo^
 *@param	heap	gpq[v
 *	
 *@return	NNSG2dCellTransferState*	mۂZ]obt@
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dCellTransferState* InitCellTransfer(int num, int heap)
{
	NNSG2dCellTransferState* buff;

	// CellVram]
	buff = sys_AllocMemory(heap, sizeof(NNSG2dCellTransferState)*num);
	
	NNS_G2dInitCellTransferStateManager(
				buff,
				num,
				CallbackRegistTransferTask          // <- (1)
			);

	return buff;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Z̃f[^Vram]^XNɐݒ肷
 *
 *@param	none
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void UpdateCellTransfer(void)
{
	// Vram]^XNݒ
	NNS_G2dUpdateCellTransferStateManager();
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Z]}l[Wj
 *
 *@param	data		Z]f[^obt@
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void DeleteCellTransfer(NNSG2dCellTransferState* data)
{
	sys_FreeMemoryEz(data);
}

//-----------------------------------------------------------------------------
/**
 *@brief				NNS_G2dDraw֐ŃLN^f[^̓]^XN
 *							o^邽߂ɌĂ΂֐
 *
 *@param	typeF]Vram̈
 *@param	dstAddrF]ItZbg
 *@param	pStrF]f[^ւ̃|C^
 *@param	szByteF]TCY
 *
 *@retval	FTRUE
 *@retval	sFFALSE
 *
 */
 //----------------------------------------------------------------------------
static BOOL CallbackRegistTransferTask( NNS_GFD_DST_TYPE type, u32 dstAddr, void* pSrc, u32 szByte )
{
	// VRAM ]}l[Wɂ̂܂ܓn
    return AddVramTransferManager(
                type,
                dstAddr,
                pSrc,
                szByte );
}
