//============================================================================================
/**
 * @file	item.c
 * @brief	ACef[^
 * @author	Hiroyuki Nakamura
 * @date	05.09.06
 */
//============================================================================================
#include "common.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/gamedata.h"
#include "system/msgdata.h"
#include "battle/wazano_def.h"

#include "msgdata\msg.naix"
#include "msgdata\msg_iteminfo.h"

#include "itemtool/myitem.h"

#define	ITEM_H_GLOBAL
#include "itemtool/item.h"
#include "itemdata.h"
#include "agb_itemsym.h"
#include "item_data.naix"
#include "item_icon.naix"


//============================================================================================
//	萔`
//============================================================================================
typedef struct {
	u16	arc_data;
	u16	arc_cgx;
	u16	arc_pal;
	u16	agb_id;
}ITEMDATA_INDEX;

#define	NORMAL_WAZAMACHINE_MAX	( 92 )		// ʏ̋Z}V
#define	HIDENWAZA_MAX			( 8 )		// `Z


//============================================================================================
//	vg^Cv錾
//============================================================================================
static s32 ItemParamRcvGet( ITEMPARAM_RCV * rcv, u16 param );


//============================================================================================
//	O[oϐ
//============================================================================================
#include "itemindex.dat"
#include "waza_mcn.dat"
#include "itemtype.dat"


//--------------------------------------------------------------------------------------------
/**
 * wACewʒuɑ}
 *
 * @param	item	ACef[^
 * @param	pos1	wACeʒu
 * @param	pos2	}ʒu
 *
 * @return	none
 */	
//--------------------------------------------------------------------------------------------
void ItemPutIn( void * item, u16 pos1, u16 pos2 )
{
	MINEITEM * data;
	MINEITEM copy;
	s16	i;

	if( pos1 == pos2 ){ return; }

	data = (MINEITEM *)item;
	copy = data[pos1];

	if( pos2 > pos1 ){
		pos2 -= 1;
		for( i=(s16)pos1; i<(s16)pos2; i++ ){
			data[i] = data[i+1];
		}
	}else{
		for( i=(s16)pos1; i>(s16)pos2; i-- ){
			data[i] = data[i-1];
		}

	}
	data[pos2] = copy;
}


//============================================================================================
//============================================================================================
//	f[^擾
//============================================================================================
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * f[^CfbNX擾
 *
 * @param	item		ACeԍ
 * @param	type		擾f[^
 *
 * @return	wf[^
 *
 * @li	type = ITEM_GET_DATA		: ACef[^̃A[JCuCfbNX
 * @li	type = ITEM_GET_ICON_CGX	: ACRL̃A[JCuCfbNX
 * @li	type = ITEM_GET_ICON_PAL	: ACRpbg̃A[JCuCfbNX
 * @li	type = ITEM_GET_AGB_NUM		: AGB̃ACeԍ
 */
//--------------------------------------------------------------------------------------------
u16 GetItemIndex( u16 item, u16 type )
{
	switch( type ){
	case ITEM_GET_DATA:		// ACef[^
		if( item == ITEM_DUMMY_ID || item == ITEM_RETURN_ID ){ break; }
		return ItemDataIndex[item].arc_data;

	case ITEM_GET_ICON_CGX:	// ACRLf[^
		if( item == ITEM_DUMMY_ID ){ return NARC_item_icon_item_dumy_NCGR; }
		if( item == ITEM_RETURN_ID ){ return NARC_item_icon_item_yaji_NCGR; }
		return ItemDataIndex[item].arc_cgx;

	case ITEM_GET_ICON_PAL:	// ACRpbgf[^
		if( item == ITEM_DUMMY_ID ){ return NARC_item_icon_item_dumy_NCLR; }
		if( item == ITEM_RETURN_ID ){ return NARC_item_icon_item_yaji_NCLR; }
		return ItemDataIndex[item].arc_pal;

	case ITEM_GET_AGB_NUM:	// AGB̃ACeԍ
		if( item == ITEM_DUMMY_ID || item == ITEM_RETURN_ID ){ break; }
		return ItemDataIndex[item].agb_id;
	}
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * AGB̃ACeDP̃ACeɕϊ
 *
 * @param	agb		AGB̃ACeԍ
 *
 * @retval	"ITEM_DUMMY_ID = DPɂȂACe"
 * @retval	"ITEM_DUMMY_ID != DP̃ACeԍ"
 */
//--------------------------------------------------------------------------------------------
u16	ITEM_AgbItemCnv( u16 agb )
{
	u16	i;

	for( i=1; i<=ITEM_DATA_MAX; i++ ){
		if( agb == ItemDataIndex[i].agb_id ){
			return i;
		}
	}
	return ITEM_DUMMY_ID;
}

//--------------------------------------------------------------------------------------------
/**
 * ACeACR̃ZA[JCuCfbNX擾
 *
 * @param	none
 *
 * @return	ZA[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u16	ItemIconCellGet(void)
{
	return NARC_item_icon_itemicon_NCER;
}

//--------------------------------------------------------------------------------------------
/**
 * ACeACR̃ZAjA[JCuCfbNX擾
 *
 * @param	none
 *
 * @return	ZAjA[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u16	ItemIconCAnmGet(void)
{
	return NARC_item_icon_itemicon_NANR;
}

//--------------------------------------------------------------------------------------------
/**
 * A[JCuf[^[h
 *
 * @param	item		ACeԍ
 * @param	type		擾f[^
 * @param	heap_id		q[vID
 *
 * @return	wf[^
 *
 * @li	type = ITEM_GET_DATA		: ACef[^
 * @li	type = ITEM_GET_ICON_CGX	: ACR̃Lf[^
 * @li	type = ITEM_GET_ICON_PAL	: ACR̃pbgf[^
 */
//--------------------------------------------------------------------------------------------
void * GetItemArcData( u16 item, u16 type, u32 heap_id )
{
	if( item > ITEM_DATA_MAX ){ item = 0; }

	switch( type ){
	case ITEM_GET_DATA:		// ACef[^
		return ArchiveDataLoadMalloc( ARC_ITEMDATA, ItemDataIndex[item].arc_data, heap_id );
	case ITEM_GET_ICON_CGX:	// ACRLf[^
		return ArchiveDataLoadMalloc( ARC_ITEMICON, ItemDataIndex[item].arc_cgx, heap_id );
	case ITEM_GET_ICON_PAL:	// ACRpbgf[^
		return ArchiveDataLoadMalloc( ARC_ITEMICON, ItemDataIndex[item].arc_pal, heap_id );
	}
	return NULL;
}

//--------------------------------------------------------------------------------------------
/**
 * ACe擾
 *
 * @param   buf			ACei[obt@
 * @param   item		ACeԍ
 * @param   heap_id		q[vIDie|ƂĎgpj
 *
 */
//--------------------------------------------------------------------------------------------
void GetItemName( STRBUF* buf, u16 item, u32 heap_id )
{
	MSGDATA_MANAGER* man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_itemname_dat, heap_id );
	MSGMAN_GetString( man, item, buf );
	MSGMAN_Delete( man );
}

//--------------------------------------------------------------------------------------------
/**
 * 擾
 *
 * @param   buf			ACei[obt@
 * @param	item		ACeԍ
 * @param	heap_id		q[vID
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
void ItemInfoGet( STRBUF * buf, u16 item, u16 heap_id )
{
	MSGDATA_MANAGER * man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_iteminfo_dat, heap_id );
	MSGMAN_GetString( man, item, buf );
	MSGMAN_Delete( man );
}

//--------------------------------------------------------------------------------------------
/**
 * 擾
 *
 * @param   buf			ACei[obt@
 * @param	item		ACeԍ
 * @param	heap_id		q[vID
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
void ItemEpuipInfoGet( STRBUF * buf, u16 item, u16 heap_id )
{
	MSGDATA_MANAGER * man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_itemeqp_dat, heap_id );
	MSGMAN_GetString( man, item, buf );
	MSGMAN_Delete( man );
}

//--------------------------------------------------------------------------------------------
/**
 * p[^擾iACeԍwj
 *
 * @param	item	ACeԍ
 * @param	param	擾p[^`
 * @param	heap_id		q[vID
 *
 * @return	wp[^
 */
//--------------------------------------------------------------------------------------------
s32	ItemParamGet( u16 item, u16 param, u32 heap_id )
{
	ITEMDATA * dat;
	s32	ret;
	
	dat = (ITEMDATA *)GetItemArcData( item, ITEM_GET_DATA, heap_id );
	ret = ItemBufParamGet( dat, param );
	sys_FreeMemory( heap_id, dat );

	return ret;
}

//--------------------------------------------------------------------------------------------
/**
 * p[^擾iACef[^wj
 *
 * @param	item	ACef[^
 * @param	param	擾p[^`
 *
 * @return	wp[^
 */
//--------------------------------------------------------------------------------------------
s32 ItemBufParamGet( ITEMDATA * item, u16 param )
{
	switch( param ){
	case ITEM_PRM_PRICE:				// l
		return (s32)item->price;
	case ITEM_PRM_EQUIP:				// 
		return (s32)item->eqp;
	case ITEM_PRM_ATTACK:				// З
		return (s32)item->atc;
	case ITEM_PRM_EVENT:				// dv
		return (s32)item->imp;
	case ITEM_PRM_CNV:					// ֗{^
		return (s32)item->cnv_btn;
	case ITEM_PRM_POCKET:				// ۑi|Pbgԍj
		return (s32)item->fld_pocket;
	case ITEM_PRM_FIELD:				// field@\
		return (s32)item->field_func;
	case ITEM_PRM_BATTLE:				// battle@\
		return (s32)item->battle_func;
	case ITEM_PRM_TUIBAMU_EFF:			// ΂ތ
		return (s32)item->tuibamu_eff;
	case ITEM_PRM_NAGETUKERU_EFF:		// Ȃ
		return (s32)item->nage_eff;
	case ITEM_PRM_NAGETUKERU_ATC:		// ȂЗ
		return (s32)item->nage_atc;
	case ITEM_PRM_SIZENNOMEGUMI_ATC:	// ̂߂݈З
		return (s32)item->sizen_atc;
	case ITEM_PRM_SIZENNOMEGUMI_TYPE:	// ̂߂݃^Cv
		return (s32)item->sizen_type;
	case ITEM_PRM_BTL_POCKET:			// 퓬ۑi|Pbgԍj
		return (s32)item->btl_pocket;
	case ITEM_PRM_W_TYPE:				// [N^Cv
		return (s32)item->work_type;

	default:							// ėp[N
		switch( item->work_type ){
		case ITEM_WKTYPE_DUMMY:			// ʃf[^
			return (s32)item->work[0];
		case ITEM_WKTYPE_POKEUSE:		// |PɎg
			return ItemParamRcvGet( (ITEMPARAM_RCV *)item->work, param );
		}
	}

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * 񕜃p[^擾
 *
 * @param	rcv		񕜃f[^
 * @param	param	擾p[^`
 *
 * @return	wp[^
 */
//--------------------------------------------------------------------------------------------
static s32 ItemParamRcvGet( ITEMPARAM_RCV * rcv, u16 param )
{
	switch( param ){
	case ITEM_PRM_SLEEP_RCV:			// 
		return (s32)rcv->sleep_rcv;
	case ITEM_PRM_POISON_RCV:			// ŉ
		return (s32)rcv->poison_rcv;
	case ITEM_PRM_BURN_RCV:				// Ώ
		return (s32)rcv->burn_rcv;
	case ITEM_PRM_ICE_RCV:				// X
		return (s32)rcv->ice_rcv;
	case ITEM_PRM_PARALYZE_RCV:			// ჉
		return (s32)rcv->paralyze_rcv;
	case ITEM_PRM_PANIC_RCV:			// 
		return (s32)rcv->panic_rcv;
	case ITEM_PRM_MEROMERO_RCV:			// 
		return (s32)rcv->meromero_rcv;
	case ITEM_PRM_ABILITY_GUARD:		// \̓K[h
		return (s32)rcv->ability_guard;
	case ITEM_PRM_DEATH_RCV:			// m
		return (s32)rcv->death_rcv;
	case ITEM_PRM_ALL_DEATH_RCV:		// Sm
		return (s32)rcv->alldeath_rcv;
	case ITEM_PRM_LV_UP:				// xAbv
		return (s32)rcv->lv_up;
	case ITEM_PRM_EVOLUTION:			// i
		return (s32)rcv->evolution;
	case ITEM_PRM_ATTACK_UP:			// U̓Abv
		return (s32)rcv->atc_up;
	case ITEM_PRM_DEFENCE_UP:			// h̓Abv
		return (s32)rcv->def_up;
	case ITEM_PRM_SP_ATTACK_UP:			// UAbv
		return (s32)rcv->spa_up;
	case ITEM_PRM_SP_DEFENCE_UP:		// hAbv
		return (s32)rcv->spd_up;
	case ITEM_PRM_AGILITY_UP:			// fAbv
		return (s32)rcv->agi_up;
	case ITEM_PRM_HIT_UP:				// Abv
		return (s32)rcv->hit_up;
	case ITEM_PRM_CRITICAL_UP:			// NeBJAbv
		return (s32)rcv->critical_up;
	case ITEM_PRM_PP_UP:				// PPAbv
		return (s32)rcv->pp_up;
	case ITEM_PRM_PP_3UP:				// PPAbviRiKj
		return (s32)rcv->pp_3up;
	case ITEM_PRM_PP_RCV:				// PP
		return (s32)rcv->pp_rcv;
	case ITEM_PRM_ALL_PP_RCV:			// PP񕜁iSĂ̋Zj
		return (s32)rcv->allpp_rcv;
	case ITEM_PRM_HP_RCV:				// HP
		return (s32)rcv->hp_rcv;
	case ITEM_PRM_HP_EXP:				// HPw͒lAbv
		return (s32)rcv->hp_exp;
	case ITEM_PRM_POWER_EXP:			// Uw͒lAbv
		return (s32)rcv->pow_exp;
	case ITEM_PRM_DEFENCE_EXP:			// hw͒lAbv
		return (s32)rcv->def_exp;
	case ITEM_PRM_AGILITY_EXP:			// fw͒lAbv
		return (s32)rcv->agi_exp;
	case ITEM_PRM_SP_ATTACK_EXP:		// Uw͒lAbv
		return (s32)rcv->spa_exp;
	case ITEM_PRM_SP_DEFENCE_EXP:		// hw͒lAbv
		return (s32)rcv->spd_exp;
	case ITEM_PRM_FRIEND1:				// ȂxP
		return (s32)rcv->friend_exp1;
	case ITEM_PRM_FRIEND2:				// ȂxQ
		return (s32)rcv->friend_exp2;
	case ITEM_PRM_FRIEND3:				// ȂxR
		return (s32)rcv->friend_exp3;

	case ITEM_PRM_HP_EXP_POINT:			// HPw͒l̒l
		return (s32)rcv->prm_hp_exp;
	case ITEM_PRM_POWER_EXP_POINT:		// Uw͒l̒l
		return (s32)rcv->prm_pow_exp;
	case ITEM_PRM_DEFENCE_EXP_POINT:	// hw͒l̒l
		return (s32)rcv->prm_def_exp;
	case ITEM_PRM_AGILITY_EXP_POINT:	// fw͒l̒l
		return (s32)rcv->prm_agi_exp;
	case ITEM_PRM_SP_ATTACK_EXP_POINT:	// Uw͒l̒l
		return (s32)rcv->prm_spa_exp;
	case ITEM_PRM_SP_DEFENCE_EXP_POINT:	// hw͒l̒l
		return (s32)rcv->prm_spd_exp;
	case ITEM_PRM_HP_RCV_POINT:			// HP񕜒l̒l
		return (s32)rcv->prm_hp_rcv;
	case ITEM_PRM_PP_RCV_POINT:			// pp񕜒l̒l
		return (s32)rcv->prm_pp_rcv;
	case ITEM_PRM_FRIEND1_POINT:		// Ȃx1̒l
		return (s32)rcv->prm_friend1;
	case ITEM_PRM_FRIEND2_POINT:		// Ȃx2̒l
		return (s32)rcv->prm_friend2;
	case ITEM_PRM_FRIEND3_POINT:		// Ȃx3̒l
		return (s32)rcv->prm_friend3;
	}

	return 0;
}


//============================================================================================
//	Z}V
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * Z}VŊoZ擾
 *
 * @param	item	ACeԍ
 *
 * @return	Zԍ
 */
//--------------------------------------------------------------------------------------------
const u16 GetWazaNoItem( u16 item )
{
	if( item < ITEM_WAZAMASIN01 || item > ITEM_HIDENMASIN08 ){
		return 0;
	}
	item -= ITEM_WAZAMASIN01;
	return MachineNo[ item ];
}

//--------------------------------------------------------------------------------------------
/**
 * IꂽZ`Zǂ
 *
 * @param	waza	Zԍ
 *
 * @retval	"TRUE = `Z"
 * @retval	"FALSE = `ZȊO"
 */
//--------------------------------------------------------------------------------------------
u8 HidenWazaCheck( u16 waza )
{
	u8	i;

	for( i=0; i<HIDENWAZA_MAX; i++ ){
		if( MachineNo[NORMAL_WAZAMACHINE_MAX+i] == waza ){
			return TRUE;
		}
	}
	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * Z}Vԍ擾
 *
 * @param	item	ACeԍ
 *
 * @return	Z}Vԍ
 */
//--------------------------------------------------------------------------------------------
u8 WazaMashineNoGet( u16 item )
{
	if( item < ITEM_WAZAMASIN01 || item > ITEM_HIDENMASIN08 ){
		return 0;
	}
	return ( item - ITEM_WAZAMASIN01 );
}


//============================================================================================
//	[`FbN
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ACe[ǂ`FbN
 *
 * @param	item	ACeԍ
 *
 * @retval	"TRUE = ["
 * @retval	"FALSE = [ȊO"
 */
//--------------------------------------------------------------------------------------------
u8 ItemMailCheck( u16 item )
{
	u32	i;

	for( i=0; i<ITEM_MAIL_MAX; i++ ){
		if( ItemMailTable[i] == item ){
			return TRUE;
		}
	}
	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * ACeԍ烁[̃fUC擾
 *
 * @param	item	ACeԍ
 *
 * @return	fUCID
 */
//--------------------------------------------------------------------------------------------
u8 ItemMailDesignGet( u16 item )
{
	u32	i;

	for( i=0; i<ITEM_MAIL_MAX; i++ ){
		if( ItemMailTable[i] == item ){
			return (u8)i;
		}
	}
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * [̃fUCACeԍ擾
 *
 * @param	design		fUCID
 *
 * @return	ACeԍ
 */
//--------------------------------------------------------------------------------------------
u16 MailItemNumGet( u8 design )
{
	if( design >= ITEM_MAIL_MAX ){
		return 0;
	}
	return ItemMailTable[design];
}


//============================================================================================
//	؂̎`FbN
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ACe؂̎ǂ`FbN
 *
 * @param	item	ACeԍ
 *
 * @retval	"TRUE = ؂̎"
 * @retval	"FALSE = ؂̎ȊO"
 */
//--------------------------------------------------------------------------------------------
u8 ItemNutsCheck( u16 item )
{
	u32	i;

	for( i=0; i<ITEM_NUTS_MAX; i++ ){
		if( ItemNutsTable[i] == item ){
			return TRUE;
		}
	}
	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * ؂̎̔ԍ擾
 *
 * @param	item	ACeԍ
 *
 * @return	؂̎ԍ
 */
//--------------------------------------------------------------------------------------------
u8 NutsNoGet( u16 item )
{
	if( item < ITEM_KURABONOMI ){
		return 0xff;
	}
	return ( item - ITEM_KURABONOMI );
}

//--------------------------------------------------------------------------------------------
/**
 * wID̖؂̎̃ACeԍ擾
 *
 * @param	id		؂̎ID
 *
 * @return	ACeԍ
 */
//--------------------------------------------------------------------------------------------
u16 NutsIDItemGet( u8 id )
{
	u32	i;

	if( id >= ITEM_NUTS_MAX ){ return 0xffff; }		// G[

	return ItemNutsTable[id];
}


//============================================================================================
//	`FbN
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ACe򂩂ǂ`FbN
 *
 * @param	item	ACeԍ
 *
 * @retval	"TRUE = "
 * @retval	"FALSE = "
 */
//--------------------------------------------------------------------------------------------
u8 ItemKanpouyakuCheck( u16 item )
{
	u32	i;

	if( item == ITEM_TIKARANOKONA || item == ITEM_TIKARANONEKKO ||
		item == ITEM_BANNOUGONA || item == ITEM_HUKKATUSOU ){

		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * ACee[uׂăɓWJ
 *
 * @param	heapID	WJ郁q[vID
 *
 * @retval	mۂ̃AhX
 */
//--------------------------------------------------------------------------------------------
void	*ItemDataTableLoad(int heapID)
{
	int	max;

	max=GetItemIndex(ITEM_DATA_MAX,ITEM_GET_DATA);

//	return ArchiveDataLoadMallocOfs(ARC_ITEMDATA,0,heapID,0,sizeof(ITEMDATA)*ITEM_DATA_MAX);
	return ArchiveDataLoadMallocOfs(ARC_ITEMDATA,0,heapID,0,36*max);
}

//--------------------------------------------------------------------------------------------
/**
 * ACee[uCӂ̃AhX擾
 *
 * @param	item	ACee[u
 * @param	index	Ƃ肾CfbNXio[
 *
 * @retval	擾AhX
 */
//--------------------------------------------------------------------------------------------
ITEMDATA	*GetItemDataPointer(ITEMDATA *item,u16 index)
{
	u8 *ret_item;

	ret_item=(u8 *)item;
	ret_item+=index*36;

	return (ITEMDATA *)ret_item;
}

