/*---------------------------------------------------------------------------*
  Project:  DP WiFi Library
  File:     dpwi_session.c

  Copyright 2003-2006 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $NoKeywords: $
 *---------------------------------------------------------------------------*/

/*! @file
	@brief	DPW internal session module
	
	@author	Yuki Hayashi(hayashi_yuki@nintendo.co.jp)
	
	@version
		@li
*/

#include <dwc.h>
#include "include/libdpw/dpwi_session.h"
#include "include/libdpw/dpwi_encrypt.h"

#ifdef _NITRO
#include "include/libdpw/dpwi_define.h"
#endif

#ifndef _NITRO
	#include "include/libdpw/dpwi_sha1.h"
#endif

/*-----------------------------------------------------------------------*
					^E萔錾
 *-----------------------------------------------------------------------*/

#define HASH_LENGTH		40								// nbV̒
#define TOKEN_LENGTH	32								// g[N̒
#define KEY_LENGTH		20								// 閧̒
#define KEYTOKEN_LENGTH		(TOKEN_LENGTH + KEY_LENGTH + 1)	// 閧{g[N

#define SECRET_KEY		"sAdeqWo3voLeC5r16DYv"			// 閧

#define COMMON_ERROR_MSG_LENGTH		22

#define COMMON_ERROR_CHECKSUM			"error: check sum      "
#define COMMON_ERROR_PID				"error: pid            "
#define COMMON_ERROR_DATA_LENGTH 		"error: data length    "
#define COMMON_ERROR_TOKEN_NOT_FOUND 	"error: token not found"
#define COMMON_ERROR_TOKEN_EXPIRED		"error: token expired  "
#define COMMON_ERROR_INCORRECT_HASH		"error: incorrect hash "

/*-----------------------------------------------------------------------*
					O[oϐ`
 *-----------------------------------------------------------------------*/


/**
 * 
 * ZbVێ\̕ϐ
 * 
 * [  base url ]?pid=[-----]&hash=[-----]&data=[-----------------------]
 * |                              |            |
 * |<- *request                   |<- *hash    |<- *data
 * 
 */

struct{

	DpwiSessionState	state;

	int		reqid;		//!< NGXgʎq
	int		lasterr;	//!< XgG[
	int		reslen;		//!< X|X̃f[^TCY

	int		pid;		//!< PID

	void*	srcbuf;		//!< Mf[^obt@̃|C^
	int		srcbuflen;	//!< Mf[^obt@̃TCY
	void*	resbuf;		//!< X|Xf[^i[obt@̃|C^
	int		resbuflen;	//!< X|Xf[^i[obt@̃TCY

	char*	request;	//!< NGXg
	char*	hash;		//!< NGXg񒆂̃nbVʒu
	char*	data;		//!< NGXg񒆂̃f[^ʒu
	int		datasize;	//!< datãTCY

}g_session = { DPWI_COMMON_SESSION_STATE_ERROR, 0, 0, 0 };


static void setlasterror( int err ){

	switch( err ){
	// G[
	case DWC_GHTTP_IN_ERROR:
		g_session.lasterr = DPWI_COMMON_SESSION_ERROR_IN_ERROR;
		break;
	// ȑM
	case DWC_GHTTP_INVALID_POST:
		g_session.lasterr = DPWI_COMMON_SESSION_ERROR_INVALID_POST;
		break;
	// s
	case DWC_GHTTP_INSUFFICIENT_MEMORY:
		g_session.lasterr = DPWI_COMMON_SESSION_ERROR_INSUFFICIENT_MEMORY;
		break;
	// ȃt@C
	case DWC_GHTTP_INVALID_FILE_NAME:
		g_session.lasterr = DPWI_COMMON_SESSION_ERROR_INVALID_FILE_NAME;
		break;
	// ȃobt@TCY
	case DWC_GHTTP_INVALID_BUFFER_SIZE:
		g_session.lasterr = DPWI_COMMON_SESSION_ERROR_INVALID_BUFFER_SIZE;
		break;
	// URL
	case DWC_GHTTP_INVALID_URL:
		g_session.lasterr = DPWI_COMMON_SESSION_ERROR_INVALID_URL;
		break;
	// ̑̃G[
	case DWC_GHTTP_UNSPECIFIED_ERROR:
		g_session.lasterr = DPWI_COMMON_SESSION_ERROR_UNSPECIFIED_ERROR;
		break;
	// 
	default:
		g_session.lasterr = 0;
	}

}

// R[obN֐
static void Completed(	const char* buf,
						int len,
						DWCGHTTPResult result,
						void* param )
{
#pragma unused(param)
	
	// GHTTP̏sĂȂƂtO𗧂Ă
	g_session.reqid = -1;
	
	// Xe[gG[I
	//
	if( g_session.state == DPWI_COMMON_SESSION_STATE_ERROR ){

		return;

	}

	
	// HTTPʐM̌ʂ
	//
	// HTTP GET 200 ̃X|X̂ݏ
	// ȊO 404500ł̓G[𔭐ďI
	// 
	if ( result == DWC_GHTTP_SUCCESS ){

		switch( g_session.state ){

		// g[N擾
		//-------------------
		case DPWI_COMMON_SESSION_STATE_GETTING_TOKEN:

			// g[ÑTCYǂ
			//
			// ΃nbV߁Af[^ÍĎ̒ʐMs
			// B
			// 
			if(len == TOKEN_LENGTH){

				//
				// [݂݂ߖ񂷂݌vȂ̂ł킩ɂEEE
				//
				int i;										// [vJE^
				u8* hashtmp = (u8*)(g_session.hash + 20);	// nbVꎞ̈
				char data[KEYTOKEN_LENGTH];					// 閧{g[N
				DpwiEncResult res;							// Í
				const char hextbl[] = "0123456789abcdef";	// hexϊe[u

				// 閧i[
				strcpy( data, SECRET_KEY );

				// g[NA
				strncat( data, buf, (u32)len );
				
				// nbVvZ
				MATH_CalcSHA1((u8*)hashtmp, (const u8*)data, strlen(data));

				// p[^[ǉ
				// 
				// ̎_łrequestɂ"*?pid=****"܂ŏĂ
				// 
				strcat( g_session.request, "&hash=" );

				// hexϊ
				//
				// ݐg_session.request"hash="̌40bytes
				// 
				for(i=0; i<20; i++){
					g_session.hash[i*2]   = hextbl[hashtmp[i] >> 4];
					g_session.hash[i*2+1] = hextbl[hashtmp[i] & 0x0f];
				}
				g_session.hash[HASH_LENGTH] = '\0';

				// URLɂȂ
				strcat( g_session.request, "&data=" );


				// Mf[^̈Í
				// 
				// Íꂽf[^g_session.requestɒ
				//
				res = DpwiEncrypt(	(u32)g_session.pid,
									(u8 *)g_session.srcbuf,
									g_session.srcbuflen,
									(u8 *)g_session.data,
									g_session.datasize );

				switch(res){

				// 
				case DPWI_COMMON_ENC_SUCCESS:
					break;

				// [sG[
				case DPWI_COMMON_ENC_ERROR_NOMEMORY:
				case DPWI_COMMON_ENC_ERROR_NOBUFFER:

					// G[
					g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;

					return;
				}

				// ̃Xe[g
				//
				// -> g[N擾Xe[g
				// 
				g_session.state = DPWI_COMMON_SESSION_STATE_GOT_TOKEN;

			}else{

				// G[
				g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;

			}

			break;


		// f[^M
		//-------------------
		case DPWI_COMMON_SESSION_STATE_SENDING_DATA:

			// X|X擾
			//
			
			// G[ǂ`FbN
			if( len == COMMON_ERROR_MSG_LENGTH ){

				if( strncmp(buf, COMMON_ERROR_CHECKSUM, COMMON_ERROR_MSG_LENGTH) == 0 ){
					g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;
					g_session.lasterr = DPWI_COMMON_SESSION_ERROR_CHECKSUM;
					break;
				} else if (strncmp(buf, COMMON_ERROR_PID, COMMON_ERROR_MSG_LENGTH) == 0 ){
					g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;
					g_session.lasterr = DPWI_COMMON_SESSION_ERROR_PID;
					break;
				} else if (strncmp(buf, COMMON_ERROR_DATA_LENGTH, COMMON_ERROR_MSG_LENGTH) == 0 ){
					g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;
					g_session.lasterr = DPWI_COMMON_SESSION_ERROR_DATA_LENGTH;
					break;
				} else if (strncmp(buf, COMMON_ERROR_TOKEN_NOT_FOUND, COMMON_ERROR_MSG_LENGTH) == 0 ){
					g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;
					g_session.lasterr = DPWI_COMMON_SESSION_ERROR_TOKEN_NOT_FOUND;
					break;
				} else if (strncmp(buf, COMMON_ERROR_TOKEN_EXPIRED, COMMON_ERROR_MSG_LENGTH) == 0 ){
					g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;
					g_session.lasterr = DPWI_COMMON_SESSION_ERROR_TOKEN_EXPIRED;
					break;
				} else if (strncmp(buf, COMMON_ERROR_INCORRECT_HASH, COMMON_ERROR_MSG_LENGTH) == 0 ){
					g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;
					g_session.lasterr = DPWI_COMMON_SESSION_ERROR_INCORRECT_HASH;
					break;
				}
			}

			// X|Xobt@Ɏ܂邩`FbN
			// 
			if( len <= g_session.resbuflen ){

				// Rs[
				memcpy(g_session.resbuf, buf, (u32)len);

				// IXe[g
				g_session.state = DPWI_COMMON_SESSION_STATE_COMPLETED;

			}else{

				// X|Xi[obt@TCYȂ
				//
				// ꉞ߂邾
				// S߂ȂG[͕Ԃ
				//

				// obt@TCYRs[
				memcpy(g_session.resbuf, buf, (u32)g_session.resbuflen );

				// G[Xe[g
				g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;
				g_session.lasterr = DPWI_COMMON_SESSION_ERROR_BUFFER_OVER;
			}

			// X|X̃TCYێ
			g_session.reslen = len;

			break;

		}

	}else{

		// HTTPG[
		//
		g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;

		// G[R[h𔻕
		switch ( result ){
		// 蓖Ďs
		case DWC_GHTTP_OUT_OF_MEMORY:
			g_session.lasterr = DPWI_COMMON_SESSION_ERROR_OUT_OF_MEMORY;
			break;
		// ꂽobt@邽߁At@C̎擾s 
		case DWC_GHTTP_BUFFER_OVERFLOW:
			g_session.lasterr = DPWI_COMMON_SESSION_ERROR_BUFFER_OVERFLOW;
			break;
		// URL̓G[
		case DWC_GHTTP_PARSE_URL_FAILED:
			g_session.lasterr = DPWI_COMMON_SESSION_ERROR_PARSE_URL_FAILED;
			break;
		// zXgs
		case DWC_GHTTP_HOST_LOOKUP_FAILED:
			g_session.lasterr = DPWI_COMMON_SESSION_ERROR_HOST_LOOKUP_FAILED;
			break;
		// \Pbg̍쐬AAǂݏoAݎs 
		case DWC_GHTTP_SOCKET_FAILED:
			g_session.lasterr = DPWI_COMMON_SESSION_ERROR_SOCKET_FAILED;
			break;
		// HTTPT[oւ̐ڑs 
		case DWC_GHTTP_CONNECT_FAILED:
			g_session.lasterr = DPWI_COMMON_SESSION_ERROR_CONNECT_FAILED;
			break;
		// HTTPT[õX|X̉̓G[ 
		case DWC_GHTTP_BAD_RESPONSE:
			g_session.lasterr = DPWI_COMMON_SESSION_ERROR_BAD_RESPONSE;
			break;
		// HTTPT[õNGXg 
		case DWC_GHTTP_REQUEST_REJECTED:
			g_session.lasterr = DPWI_COMMON_SESSION_ERROR_REQUEST_REJECTED;
			break;
		// t@C擾 
		case DWC_GHTTP_UNAUTHORIZED:
			g_session.lasterr = DPWI_COMMON_SESSION_ERROR_UNAUTHORIZED;
			break;
		// HTTPT[õt@CM 
		case DWC_GHTTP_FORBIDDEN:
			g_session.lasterr = DPWI_COMMON_SESSION_ERROR_FORBIDDEN;
			break;
		// HTTPT[õt@Cs 
		case DWC_GHTTP_FILE_NOT_FOUND:
			g_session.lasterr = DPWI_COMMON_SESSION_ERROR_FILE_NOT_FOUND;
			break;
		// HTTPT[oG[
		case DWC_GHTTP_SERVER_ERROR:
			g_session.lasterr = DPWI_COMMON_SESSION_ERROR_SERVER_ERROR;
			break;
		// _E[h̒f
		case DWC_GHTTP_FILE_INCOMPLETE:
			g_session.lasterr = DPWI_COMMON_SESSION_ERROR_FILE_INCOMPLETE;
			break;
		// t@C傫邽߃_E[hs\ 
		case DWC_GHTTP_FILE_TOO_BIG:
			g_session.lasterr = DPWI_COMMON_SESSION_ERROR_FILE_TOO_BIG;
			break;
		// [G[
		case DWC_GHTTP_MEMORY_ERROR:
			g_session.lasterr = DPWI_COMMON_SESSION_ERROR_MEMORY_ERROR;
			break;
		}
		
	}

}


/*!
	ZbV܂
	
	
*/
void DpwiSessionInitialize( void ){

	// Xe[^XtOZbg
	g_session.state = DPWI_COMMON_SESSION_STATE_INITIAL;
	g_session.reqid = -1;

	// 
	if ( !DWC_InitGHTTP(NULL) ){

		// GHTTP̏Ɏs
		g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;

	}

	return;

}


/*!
	NGXg𔭍s܂
	
	ZbVmāAf[^𑗐MAX|XM܂B
	
	@param[in]		url		XNvgURL
	@param[in]		pid		GameSpy Profile ID
	@param[in]		data	Mf[^
	@param[in]		len		datãTCY
	@param[in]		resbuf	X|X󂯎邽߂̃obt@
	@param[in]		buflen	resbuf̃TCY

	@retval	DPWI_COMMON_SESSION_SUCCESS					
	@retval	DPWI_COMMON_SESSION_ERROR_NOTINITIALIZED	
	@retval	DPWI_COMMON_SESSION_ERROR_NOMEMORY			[s

*/
DpwiSessionResult DpwiSessionRequest(	const u8* url,
										int pid,
										const void* data,
										int len,
										u8* resbuf,
										int ressize ){


	// `FbN
	if( g_session.state != DPWI_COMMON_SESSION_STATE_INITIAL )
		return DPWI_COMMON_SESSION_ERROR_NOTINITIALIZED;

	// eϐێ
	g_session.pid		= pid;
	g_session.srcbuf	= (void*)data;
	g_session.srcbuflen	= len;
	g_session.resbuf	= resbuf;
	g_session.resbuflen	= ressize;

	// NGXgp[m
	// ( baseurllen + param[pid] + param[hash] + base64data + few more )
	g_session.request = (char*)DWC_Alloc( (DWCAllocType)DPWI_ALLOC,
									strlen((const char*)url)
									+ 68 + DpwiB64Size(8 + (u32)len) + 1);
	if( g_session.request == NULL )
		return DPWI_COMMON_SESSION_ERROR_NOMEMORY;

	// x[XtqkPIDNGXgɊi[
	sprintf( g_session.request, "%s?pid=%d", url, pid );

	// p[^[̃ItZbgێ
	//
	// [ߖ̂߂ɓobt@̃|C^ێ
	// 
	g_session.hash	= g_session.request + strlen(g_session.request)
						+ strlen("&hash=");
	g_session.data	= g_session.hash + HASH_LENGTH + strlen("&data=");
	g_session.datasize = (int)(DpwiB64Size(8 + (u32)len) + 1);


	// Jn
	g_session.state = DPWI_COMMON_SESSION_STATE_REQUEST;

	return DPWI_COMMON_SESSION_SUCCESS;
}


/*!
	񓯊i߂܂

	@return	ZbṼXe[^X
*/
DpwiSessionState DpwiSessionThink( void ){

	BOOL result;

	switch( g_session.state ){

	// LZꂽ
	//-----------------------
	case DPWI_COMMON_SESSION_STATE_CANCELED:
		break;

	// G[
	//-----------------------
	case DPWI_COMMON_SESSION_STATE_ERROR:
		break;

	// 
	//-----------------------
	case DPWI_COMMON_SESSION_STATE_INITIAL:
		break;

	// NGXg
	//-----------------------
	case DPWI_COMMON_SESSION_STATE_REQUEST:

		// g[N擾NGXgM
		g_session.reqid = DWC_GetGHTTPData(	g_session.request,
											Completed,
											&g_session );

		setlasterror( g_session.reqid );

		if( g_session.reqid >= 0 )
			g_session.state = DPWI_COMMON_SESSION_STATE_GETTING_TOKEN;
		else
			g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;

		break;
	
	// g[N擾
	//-----------------------
	case DPWI_COMMON_SESSION_STATE_GETTING_TOKEN:

		result = DWC_ProcessGHTTP();

		if( !result ){
			g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;
			break;
		}

		break;

	// g[N擾
	//-----------------------
	case DPWI_COMMON_SESSION_STATE_GOT_TOKEN:

		// f[^MNGXgM
		g_session.reqid = DWC_GetGHTTPData(	g_session.request,
											Completed,
											&g_session );

		setlasterror( g_session.reqid );

		if( g_session.reqid >= 0 )
			g_session.state = DPWI_COMMON_SESSION_STATE_SENDING_DATA;
		else
			g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;

		break;

	// f[^M
	//-----------------------
	case DPWI_COMMON_SESSION_STATE_SENDING_DATA:

		result = DWC_ProcessGHTTP();

		if( !result ){
			g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;
			break;
		}

		break;

	// 
	//-----------------------
	case DPWI_COMMON_SESSION_STATE_COMPLETED:
		break;
	}

	return g_session.state;
}


/*!
	ZbV𒆒f܂
	
	ZbV𒆒f܂
	
*/
void DpwiSessionCancel( void ){

	if( g_session.reqid >= 0 )
		DWC_CancelGHTTPRequest( g_session.reqid );

	g_session.state = DPWI_COMMON_SESSION_STATE_CANCELED;

	return;

}

/*!
	ZbVI܂
	
	ZbVIă[܂
	
*/
void DpwiSessionShutdown( void ){

	// [J
	if( g_session.request != NULL){
	
		DWC_Free( (DWCAllocType)DPWI_ALLOC, g_session.request, (u32)0 );
		g_session.request = NULL;

	}

	// GHTTPJ
	DWC_ShutdownGHTTP();

	// Xe[^X𖳌ɂ
	g_session.state = DPWI_COMMON_SESSION_STATE_ERROR;

	return;

}


/*!
	Ō̃G[擾܂
	
	
*/
DpwiHttpError DpwiGetLastError( void ){

	return (DpwiHttpError)g_session.lasterr;

}

/*!
	X|X̃f[^TCYԂ܂
	
	
*/
int DpwiGetResponseSize( void ){

	return g_session.reslen;

}

