#include "pokeanime/p_anm_sys.h"
#include "system/softsprite.h"
#include "system/arc_tool.h"
#include "poketool/poke_tool.h"		//for PokePersonalParaGet
#include "tcb.h"

#include "past_def.h"


#define REQUEST_MAX	(256)
#define ANM_WORK_MAX	(8)
#define MOVE_FUNC_WORK_MAX	(8)
#define MOVE_FUNC_ENTRY_MAX	(4)

#define ANM_CMD_MAX	(34)

// ----------------------------------------
//
//	wTCYAhXi߂}N
//		i߂AhX̌^Ɉˑ
//
// -----------------------------------------
#define ADRS_CMD(n, m)			((n) += (m))

// -----------------------------------------
//
//	^TCYAhXi߂}N
//		ŏPʂŃAhXi
//		ADRS_CMD 𗘗p̂Ō^Ɉˑ
//
// -----------------------------------------
#define ADRS_SHIFT(n)			(ADRS_CMD(n, 1))

typedef int	TAP;
typedef struct POKE_ANIME_tag *POKE_ANM_PTR;
typedef struct MOVE_FUNC_DATA_tag *MOVE_FUNC_DATA_PTR;
typedef void (*pAnmFunc)( POKE_ANM_PTR );
typedef void (*MoveFunc)( MOVE_FUNC_DATA_PTR, POKE_ANM_PTR);

static TAP  GetAdrsParamEx(u32* adrs, u8 s_byte, u8 byte);	///< f[^擾
static TAP  GetAdrsParam(u32* adrs, u8 byte);					///< f[^擾
static TAP  GetSeqAdrs(u32* adrs);

typedef struct MOVE_FUNC_DATA_tag
{
	BOOL Valid;		//֐LtO
	int Work[MOVE_FUNC_WORK_MAX];	//[N
	int *Target;			//֐f[^̕ύXΏی
	int *ApplyTarget;		//Ajf[^̕ύXΏې
	
	u8	ApplyType;		//lZbg邩A̒lɒl悹邩̃tO

	u8	Wait;			//֐s܂ł̃EFCg
	int StartVal;		//APPLY_ADD̊ƂȂl
	int TransX;			//wړl
	int TransY;			//xړl
	int dx;				//wړliItZbgj
	int dy;				//xړliItZbgj
	int rx;				//gkw
	int ry;				//gkx
	int Rot;			//]
	MoveFunc	Func;	//֐
}MOVE_FUNC_DATA;

typedef struct POKE_ANIME_tag
{
	SOFT_SPRITE *SoftSprite;	//\tgEFAXvCgւ̃|C^
	TCB_PTR Task;		//o^^XNiAjfpj
	void *ArcData;		//A[JCuf[^
	u32 *SeqAdrs;		//f[^V[PXAhX

	BOOL Valid;			//f[^LtO
//	int MonsNo;	//X^[io[	iȂj
	int AnimeNo;	//Ajio[(Ȃ)
	int Request;		//AjftO
	int End;			//AjR}hItO
	BOOL EndComp;		//AjItO
	int Work[ANM_WORK_MAX];	//[N
	int ReqCount;		//
	
	int LoopMax;			//[v
	int LoopCount;			//݃[v
	u32 *LoopStartAdrs;		//[vJnAhX

	int Wait;			//AjJn܂ł̃EFCg

	int OrgX;			//XvCgwW
	int OrgY;			//XvCgxW
	int TransX;			//wړl
	int TransY;			//xړl
	int dx;				//wړliItZbgj
	int dy;				//xړliItZbgj
	int rx;				//gkw
	int ry;				//gkx
	int Rot;			//]

	MOVE_FUNC_DATA			MoveFuncData[MOVE_FUNC_ENTRY_MAX];

	u8 PokeReverse;	//|PƂ̔]tO(|PɂĂ͔]Ȃ)@0F]Ȃ@1F]
	u8 CommandHold;	//֐Nz[htO
	u8 CorrectDy;	//dy␳LtO
	u8 PalFadeWaitFlg;	//pbgtF[hI҂tO

}POKE_ANIME;

typedef struct POKE_ANIME_SYS_tag
{
	POKE_ANIME *PokeAnime;
	int HeapID;		//q[vhc
	u8 Reverse;		//Aj𔽓]邩ǂ̃tO@0F]Ȃ	1F]
	u8 AnimeNum;
}POKE_ANIME_SYS;

typedef struct MOVE_FUNC_P_DATA_tag
{
	MoveFunc	Func;	//֐
	int ParamNum;		//p[^
	int TargetWorkIdx;	//ύXΏۂi[[ÑCfbNX
}MOVE_FUNC_P_DATA;

static void CallMoveFuc(POKE_ANIME *pAnm, const int inMoveFuncNo);
static void	PokemonAnimeTask(TCB_PTR tcb, void *work);
static void ExecutePokeAnime(POKE_ANIME *pAnm);

static void	PAnm_End(POKE_ANIME *pAnm);
static void	PAnm_SetRequest(POKE_ANIME *pAnm);
static void PAnm_SetDefault(POKE_ANIME *pAnm);
static void PAnm_SetIfWorkVal(POKE_ANIME *pAnm);
static void PAnm_SetWorkVal(POKE_ANIME *pAnm);
static void PAnm_CopyWorkVal(POKE_ANIME *pAnm);
static void PAnm_AddWorkVal(POKE_ANIME *pAnm);
static void PAnm_MulWorkVal(POKE_ANIME *pAnm);
static void PAnm_SubWorkVal(POKE_ANIME *pAnm);
static void PAnm_DivWorkVal(POKE_ANIME *pAnm);
static void PAnm_ModWorkVal(POKE_ANIME *pAnm);
static void	PAnm_StartLoop(POKE_ANIME *pAnm);
static void	PAnm_EndLoop(POKE_ANIME *pAnm);
static void	PAnm_SetVal(POKE_ANIME *pAnm);		//ʂ̃R}hg悤(IɍlăR}h͏܂) 20060801
static void	PAnm_AddVal(POKE_ANIME *pAnm);		//ʂ̃R}hg悤(IɍlăR}h͏܂) 20060801
static void PAnm_SetAddVal(POKE_ANIME *pAnm);
static void PAnm_SetWorkValSin(POKE_ANIME *pAnm);
static void PAnm_SetWorkValCos(POKE_ANIME *pAnm);
static void PAnm_SetTrans(POKE_ANIME *pAnm);	//ʂ̃R}hg悤(IɍlăR}h͏܂) 20060801
static void PAnm_AddTrans(POKE_ANIME *pAnm);	//ʂ̃R}hg悤(IɍlăR}h͏܂) 20060801
static void PAnm_SetAddParam(POKE_ANIME *pAnm);
static void PAnm_ApplyTrans(POKE_ANIME *pAnm);
static void PAnm_ApplyAffine(POKE_ANIME *pAnm);
static void PAnm_SetD(POKE_ANIME *pAnm);
static void PAnm_SetWait(POKE_ANIME *pAnm);
static void PAnm_PaletteFade(POKE_ANIME *pAnm);
static void PAnm_WaitPaletteFade(POKE_ANIME *pAnm);

static void PAnm_HoldAnmCommand(POKE_ANIME *pAnm);
static void PAnm_SetDyCorrect(POKE_ANIME *pAnm);
static void PAnm_CallMoveFuncCurve(POKE_ANIME *pAnm);
static void PAnm_CallMoveFuncCurveDivTime(POKE_ANIME *pAnm);
static void PAnm_CallMoveFuncLine(POKE_ANIME *pAnm);
static void PAnm_CallMoveFuncLineDivTime(POKE_ANIME *pAnm);
static void PAnm_CallMoveFuncLineDst(POKE_ANIME *pAnm);

static void PMove_Curve(MOVE_FUNC_DATA_PTR pMFD, POKE_ANM_PTR pAnm);
static void PMove_CurveDivTime(MOVE_FUNC_DATA_PTR pMFD, POKE_ANM_PTR pAnm);
static void PMove_Line(MOVE_FUNC_DATA_PTR pMFD, POKE_ANM_PTR pAnm);
static void PMove_LineDivTime(MOVE_FUNC_DATA_PTR pMFD, POKE_ANM_PTR pAnm);
static void PMove_LineDst(MOVE_FUNC_DATA_PTR pMFD, POKE_ANM_PTR pAnm);

#define CHARA_MAX	(25)
//iʃAjnbVe[ui0Fhȓ@1Fʁ@2FT߂ȓj
static const u8 PesrsonalityTbl[CHARA_MAX] = {
	0,	//΂
	2,	//݂
	0,	//䂤
	0,	//ς
	0,	//񂿂
	1,	//ԂƂ
	1,	//Ȃ
	1,	//̂
	0,	//ς
	1,	//̂Ă
	2,	//т傤
	0,	//
	1,	//܂
	0,	//悤
	0,	//ނႫ
	2,	//Ђ
	2,	//Ƃ
	2,	//ꂢ
	2,	//Ă
	1,	//
	1,	//₩
	2,	//ƂȂ
	1,	//Ȃ܂
	2,	//񂿂傤
	1,	//܂
};

static const pAnmFunc PokeAnmCmdList[ANM_CMD_MAX] = {
	PAnm_End,				//0
	PAnm_SetRequest,
	PAnm_SetDefault,
	PAnm_SetIfWorkVal,
	PAnm_SetWorkVal,
	PAnm_CopyWorkVal,
	PAnm_AddWorkVal,
	PAnm_MulWorkVal,
	PAnm_SubWorkVal,
	PAnm_DivWorkVal,
	PAnm_ModWorkVal,
	PAnm_StartLoop,
	PAnm_EndLoop,
	PAnm_SetVal,		//ʂ̃R}hg悤(IɍlăR}h͏܂) 20060801
	PAnm_AddVal,		//ʂ̃R}hg悤(IɍlăR}h͏܂) 20060801
	PAnm_SetAddVal,
	PAnm_SetWorkValSin,
	PAnm_SetWorkValCos,
	PAnm_SetTrans,	//ʂ̃R}hg悤(IɍlăR}h͏܂) 20060801
	PAnm_AddTrans,	//ʂ̃R}hg悤(IɍlăR}h͏܂) 20060801
	PAnm_SetAddParam,
	PAnm_ApplyTrans,
	PAnm_ApplyAffine,
	PAnm_SetD,

	PAnm_HoldAnmCommand,
	PAnm_SetDyCorrect,
	PAnm_CallMoveFuncCurve,
	PAnm_CallMoveFuncCurveDivTime,
	PAnm_CallMoveFuncLine,
	PAnm_CallMoveFuncLineDivTime,
	PAnm_CallMoveFuncLineDst,	
	
	PAnm_SetWait,
	PAnm_PaletteFade,
	PAnm_WaitPaletteFade,
};

enum{
	MOVE_CURVE,
	MOVE_CURVE_DIVTIME,
	MOVE_LINE,
	MOVE_LINE_DIVTIME,
	MOVE_LINE_DST,
};

#define F_PARAM_NUM_CURVE			(6)	//J[u^CvAΏہAUAZpxAʑAvZ	v6
#define F_PARAM_NUM_CURVE_DIVTIME	(6)	//J[u^CvAΏہAUApxAʑAvZ	v6
#define F_PARAM_NUM_LINE			(4)	//ΏہAxAxAvZ	v4
#define F_PARAM_NUM_LINE_DIVTIME	(3)	//ΏہAړlAvZ	v3
#define F_PARAM_NUM_LINE_DST		(4)	//ΏہAxAxAړIl	v4

static const MOVE_FUNC_P_DATA MoveFuncTbl[] = {
	{PMove_Curve, F_PARAM_NUM_CURVE, 1},
	{PMove_CurveDivTime, F_PARAM_NUM_CURVE_DIVTIME,1},
	{PMove_Line,F_PARAM_NUM_LINE, 0},
	{PMove_LineDivTime,F_PARAM_NUM_LINE_DIVTIME,0},
	{PMove_LineDst,F_PARAM_NUM_LINE_DST,0}
};

//--------------------------------------------------------------
/**
 * |PAj[VZbeBOp[^̍쐬
 *
 * @param	inMonsNo	X^[io[
 * @param	outParam	p[^i[obt@
 *
 * @retval	none
 */
//--------------------------------------------------------------
void PokeAnm_CreateSettingParam(const int inMonsNo, P_ANM_SETTING_PARAM *outParam)
{
	GF_ASSERT(outParam!=NULL&&"ERROR:paramater is NULL");
	
	outParam->AnimeNo = 0;	//0Zbg
	outParam->Wait = 0;		//0Zbg
	outParam->Reverse = PokePersonalParaGet(inMonsNo, ID_PER_reverse);	//p[\i甽]tO擾
	outParam->Reverse ^= 1;
}


//--------------------------------------------------------------
/**
 * |PAj[VpǗ̊m
 *
 * @param	inHeapID	q[vID
 * @param	inAllocNum	Ajmې
 * @param	inReverse	]tO
 *
 * @retval	POKE_ANM_S_PTR	mۂ|PAjǗ̈ւ̃|C^
 */
//--------------------------------------------------------------
POKE_ANM_SYS_PTR PokeAnm_AllocMemory(const int inHeapID, const int inAllocNum, const u8 inReverse)
{
	POKE_ANM_SYS_PTR ptr;
	ptr = sys_AllocMemory(inHeapID, sizeof(POKE_ANIME_SYS));
	ptr->Reverse = inReverse;
	ptr->AnimeNum = inAllocNum;
	ptr->HeapID = inHeapID;
	ptr->PokeAnime = sys_AllocMemory(inHeapID, sizeof(POKE_ANIME)*inAllocNum);
	//NA
	MI_CpuClear8(ptr->PokeAnime,sizeof(POKE_ANIME)*inAllocNum);
	
	return  ptr;
}

//--------------------------------------------------------------
/**
 * |PAj[VpǗ
 *
 * @param	ptr				|PAj̈ւ̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
void PokeAnm_FreeMemory(POKE_ANM_SYS_PTR ptr)
{
	sys_FreeMemoryEz(ptr->PokeAnime);
	sys_FreeMemoryEz(ptr);
}
//--------------------------------------------------------------
/**
 * iwʃ|PAj̃XbgԍԂi0`2j
 *
 * @param	inChar			|P̐i
 *
 * @retval	u8			̗pXbgԍi0`2j
 */
//--------------------------------------------------------------
u8 PokeAnm_GetBackAnmSlotNo(	const u8 inChar )
{
	u8 slot_no;
	GF_ASSERT(inChar < CHARA_MAX);
	slot_no = PesrsonalityTbl[inChar];
	
	return slot_no;
}

//--------------------------------------------------------------
/**
 * \tgEFAXvCgƃ|Pio[Zbg
 *
 * @param	ptr				|PAj̈ւ̃|C^
 * @param	ss				\tgEFAXvCgւ̃|C^
 * @param	inParam			AjZbeBOp[^
 * @param	inEntryIndex	o^CfbNX
 *
 * @retval	none
 */
//--------------------------------------------------------------
void PokeAnm_SetPokeAnime(	POKE_ANM_SYS_PTR ptr, SOFT_SPRITE *ss,
							const P_ANM_SETTING_PARAM *inParam,
							const u8 inEntryIndex)
{
	u8 idx = inEntryIndex;
	int anime_no = inParam->AnimeNo;
	int wait = inParam->Wait;
	
	GF_ASSERT((idx<ptr->AnimeNum)&&"ERROR:IndexOver");
	GF_ASSERT(ptr->PokeAnime[idx].Valid==FALSE&&"ERROR:PokeAnime Entry already");

	//NA
	MI_CpuClear8(&ptr->PokeAnime[idx],sizeof(POKE_ANIME));

	//f[^L
	ptr->PokeAnime[idx].Valid = TRUE;

	//XvCgZbg
	ptr->PokeAnime[idx].SoftSprite = ss;
#ifdef PM_DEBUG	
	//gk`FbN
	{
		int aff_x,aff_y;
		aff_x = SoftSpriteParaGet(ss, SS_PARA_AFF_X);
		aff_y = SoftSpriteParaGet(ss, SS_PARA_AFF_Y);
		GF_ASSERT( (aff_x==0x100)&&(aff_y==0x100) );
	}
#endif	
	//Ajio[͈͊OΏ
	if (anime_no >= POKE_ANIME_MAX){
		anime_no = 0;
		wait = 0;
	}
	
	//X^[io[Aj[V
	ptr->PokeAnime[idx].AnimeNo = anime_no;

	//]tOZbg
	if (ptr->Reverse){
		//X^[Ƃɔ]
		ptr->PokeAnime[idx].PokeReverse = inParam->Reverse;
	}else{
		ptr->PokeAnime[idx].PokeReverse = 0;
	}

	//AjA[JCuf[^Zbg
	ptr->PokeAnime[idx].ArcData =
		ArchiveDataLoadMallocLo(ARC_POKE_ANM, ptr->PokeAnime[idx].AnimeNo, ptr->HeapID );
	ptr->PokeAnime[idx].SeqAdrs = (u32*)ptr->PokeAnime[idx].ArcData;
	
	//AjItOIt
	ptr->PokeAnime[idx].End = 0;
	ptr->PokeAnime[idx].EndComp = FALSE;
	//z[hNA
	ptr->PokeAnime[idx].CommandHold = 0;
	//dy␳
	ptr->PokeAnime[idx].CorrectDy = CORRECT_OFF;
	//pbg҂ԃNA
	ptr->PokeAnime[idx].PalFadeWaitFlg = 0;
	//Ajo^i^XNo^jƃ^XNL
	ptr->PokeAnime[idx].Task = TCB_Add(PokemonAnimeTask, &ptr->PokeAnime[idx], 0);

	//AjJnEFCgZbg
	ptr->PokeAnime[idx].Wait = wait;		

	ptr->PokeAnime[idx].OrgX = SoftSpriteParaGet(ss,SS_PARA_POS_X);
	ptr->PokeAnime[idx].OrgY = SoftSpriteParaGet(ss,SS_PARA_POS_Y);
	ptr->PokeAnime[idx].TransX = 0;
	ptr->PokeAnime[idx].TransY = 0;
	ptr->PokeAnime[idx].dx = 0;
	ptr->PokeAnime[idx].dy = 0;
	ptr->PokeAnime[idx].rx = 0;
	ptr->PokeAnime[idx].ry = 0;
	ptr->PokeAnime[idx].Rot = 0;

///	OS_Printf("anime_struct_size = %d\n",sizeof(POKE_ANIME));
}

//--------------------------------------------------------------
/**
 * Aj[VIo
 *
 * @param	ptr				|PAj̈ւ̃|C^
 * @param	inEntryIndex	O`R܂ł̓o^CfbNX
 *
 * @retval	BOOL	TRUE:I		FALSE:p
 */
//--------------------------------------------------------------
BOOL PokeAnm_IsFinished(POKE_ANM_SYS_PTR ptr, const u8 inEntryIndex)
{
	GF_ASSERT((inEntryIndex<ptr->AnimeNum)&&"ERROR:IndexOver");

	return ptr->PokeAnime[inEntryIndex].EndComp;
}

//--------------------------------------------------------------
/**
 * Aj[VI(^XN폜)
 *
 * @param	ptr				|PAj̈ւ̃|C^
 * @param	inEntryIndex	O`R܂ł̓o^CfbNX
 *
 * @retval	none
 */
//--------------------------------------------------------------
void PokeAnm_EndAnimeForce(POKE_ANM_SYS_PTR ptr, const u8 inEntryIndex)
{
	if ( ptr->PokeAnime[inEntryIndex].Task != NULL ){
		TCB_Delete(ptr->PokeAnime[inEntryIndex].Task);
		ptr->PokeAnime[inEntryIndex].Task = NULL;
		ptr->PokeAnime[inEntryIndex].EndComp = TRUE;
		ptr->PokeAnime[inEntryIndex].Valid = FALSE;		//Aj
		//Ajf[^
		sys_FreeMemoryEz(ptr->PokeAnime[inEntryIndex].ArcData);
	}
}

//--------------------------------------------------------------
/**
 * |PAj[V^XN
 *
 * @param	tcb		^XÑ|C^
 * @param	work	^XN[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void	PokemonAnimeTask(TCB_PTR tcb, void *work)
{
	POKE_ANIME *anime = (POKE_ANIME*)(work);
	if (anime->Wait == 0){
		ExecutePokeAnime(anime);
	}else{
		anime->Wait--;
	}
	
	if (anime->End){
		anime->EndComp = TRUE;
		anime->Valid = FALSE;		//Aj
		//^XNj
		TCB_Delete(tcb);
		anime->Task = NULL;
		//Ajf[^
		sys_FreeMemoryEz(anime->ArcData);
	}
}

//--------------------------------------------------------------
/**
 * R}hs֐
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void ExecutePokeAnime(POKE_ANIME *pAnm)
{
	pAnmFunc func;
	pAnm->Request = 0;
	pAnm->ReqCount = 0;

	{
		u8 i;
		u8 invalid;
		MOVE_FUNC_DATA_PTR mfd_ptr;
		//֐
		invalid = 0;
		for(i=0;i<MOVE_FUNC_ENTRY_MAX;i++){
			mfd_ptr = &(pAnm->MoveFuncData[i]);
			if (mfd_ptr->Valid){
				if (mfd_ptr->Wait == 0){
					///֐s
					mfd_ptr->Func(mfd_ptr,pAnm);
				}else{
					mfd_ptr->Wait--;
				}
			}else{
				invalid++;
			}
		}
		if (invalid == MOVE_FUNC_ENTRY_MAX){	//֐SďIĂȂ
			//R}h߃z[h
			pAnm->CommandHold = 0;
		}
	}

	if (pAnm->CommandHold){	//֐ɂR}h߂z[hĂȂ
		//݂܂ł̌vZʂXvCgɔfāAAj[Vs
		PAnm_ApplyTrans(pAnm);
		PAnm_ApplyAffine(pAnm);
		return;
	}

	//pbgtF[hI҂ԂȂ
	if (pAnm->PalFadeWaitFlg){
		//I܂Ŏ̃R}hsȂ
		if( !SoftSpritePalFadeExist(pAnm->SoftSprite) ){//tF[h̏󋵂݂
			pAnm->PalFadeWaitFlg = 0;//tF[hI
		}else{
			return ;//tF[hpĂ̂ŁAԂ
		}
	}

	while(1) {	//AjfNGXg܂Ŏs
///		OS_Printf("val=%d\n",(u32)(*pAnm->SeqAdrs));
		pAnm->ReqCount++;
		//s֐
		GF_ASSERT((u32)*(pAnm->SeqAdrs)<ANM_CMD_MAX&&"ERROR:AnimeCmdOver");
		func = PokeAnmCmdList[(u32)*(pAnm->SeqAdrs)];
		func(pAnm);

		if (pAnm->End){
			break;
		}else{
			ADRS_SHIFT(pAnm->SeqAdrs);
			if (pAnm->Request){
///				OS_Printf("pos = %d\n",SoftSpriteParaGet(pAnm->SoftSprite,SS_PARA_POS_Y));
				break;
			}else if(pAnm->CommandHold){
				//֐ω𔽉f
				PAnm_ApplyTrans(pAnm);
				PAnm_ApplyAffine(pAnm);
				break;
			}
		}

		//[v
		if (pAnm->ReqCount >= REQUEST_MAX)
		{
			GF_ASSERT(0&&"Request too long");
			//|P̈ʒu߂ƂH
			pAnm->End = 1;
			break;
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief	woCgf[^擾
 *
 * @param	adrs	擾ΏۃAhX
 * @param	s_byte	JnoCgʒu
 * @param	byte	擾oCg
 *
 * @retval	TAP	l
 *
 */
//--------------------------------------------------------------
static TAP GetAdrsParamEx(u32* adrs, u8 s_byte, u8 byte)
{
	TAP val = adrs[s_byte];
	
	if (byte != 1){
		GF_ASSERT(0);
	}
	return val;
}

//--------------------------------------------------------------
/**
 * @brief	woCgf[^擾
 *
 * @param	adrs	擾ΏۃAhX
 * @param	byte	擾oCg
 *
 * @retval	TAP		l
 *
 */
//--------------------------------------------------------------
static TAP GetAdrsParam(u32* adrs, u8 byte)
{
	TAP val;

	val = GetAdrsParamEx(adrs, 0, byte);

	return val;
}

//--------------------------------------------------------------
/**
 * @brief	V[PXAhX擾
 *
 * @param	adrs	擾ΏۃAhX
 *
 * @retval	TAP		l
 *
 */
//--------------------------------------------------------------
static TAP GetSeqAdrs(u32* adrs)
{
	return GetAdrsParam(adrs, 1);
}

//--------------------------------------------------------------
/**
 * ֐̃Zbg
 *
 * @param	pAnm			Aj|C^
 * @param	inMoveFuncNo	֐ԍ(256͒ȂƎv)
 *
 * @retval	none
 */
//--------------------------------------------------------------
static MOVE_FUNC_DATA_PTR SetMoveFunc(POKE_ANIME *pAnm, const u8 inMoveFuncNo)
{
	MOVE_FUNC_DATA_PTR ptr;
	u8 i;
	//󂢂ĂƂT
	for(i=0;i<MOVE_FUNC_ENTRY_MAX;i++){
		ptr = &(pAnm->MoveFuncData[i]);
		if (ptr->Valid == FALSE){
			//NA
			MI_CpuClear8(ptr,sizeof(MOVE_FUNC_DATA));	
			//Zbg
			ptr->Valid = TRUE;
			ptr->Func = MoveFuncTbl[inMoveFuncNo].Func;
			return ptr;
		}
	}
	GF_ASSERT(0&&"ERROR:MOVE_FUNC_ENTRY_FAILED!!");
	return NULL;
}

//////////////////////////////////////////////////////////////////////////////////////////////////

//--------------------------------------------------------------
/**
 * int^l擾
 *
 * @param	pAnm			Aj|C^
 * @param	outVal			i[obt@
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void GetInt(POKE_ANIME *pAnm, int *outVal)
{
	ADRS_SHIFT(pAnm->SeqAdrs);
	(*outVal) =  (int)GetSeqAdrs(pAnm->SeqAdrs);
}

//--------------------------------------------------------------
/**
 * u8^l擾
 *
 * @param	pAnm			Aj|C^
 * @param	outVal			i[obt@
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void GetU8(POKE_ANIME *pAnm, u8 *outVal)
{
	ADRS_SHIFT(pAnm->SeqAdrs);
	(*outVal) =  (u8)GetSeqAdrs(pAnm->SeqAdrs);
}

//--------------------------------------------------------------
/**
 * [NCfbNX擾
 *
 * @param	pAnm			Aj|C^
 * @param	outIdx			擾CfbNXi[obt@
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void GetIdx(POKE_ANIME *pAnm, u8 *outIdx)
{
	ADRS_SHIFT(pAnm->SeqAdrs);
	(*outIdx) =  (u8)GetSeqAdrs(pAnm->SeqAdrs);
	GF_ASSERT((*outIdx)<ANM_WORK_MAX&&"ERROR:WorkOver");
}

//--------------------------------------------------------------
/**
 * [NCfbNX擾(CfbNX2AĂƂ)
 *
 * @param	pAnm			Aj|C^
 * @param	outIdx1			1ߎ擾CfbNXi[obt@
 * @param	outIdx2			2ߎ擾CfbNXi[obt@
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void GetTwoIdx(POKE_ANIME *pAnm, u8 *outIdx1, u8 *outIdx2)
{
	GetIdx(pAnm, outIdx1);
	GetIdx(pAnm, outIdx2);
}

//--------------------------------------------------------------
/**
 * ZEZʏ
 *
 * @param	pAnm			Aj|C^
 * @param	outDstIdx		i[惏[NCfbNX
 * @param	outVal1			1ߒli[obt@
 * @param	outVal2			2ߒli[obt@
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void CalcCommonAddMul(POKE_ANIME *pAnm, u8 *outDstIdx, int *outVal1, int *outVal2)
{
	u8 idx1,idx2;
	u8 calc;
	
	//i[惏[NCfbNX擾
	GetIdx(pAnm,outDstIdx);
	//vZ^Cv擾
	GetU8(pAnm,&calc);
	
	if (calc == CALC_VAL){
		//[NƒľvZ
		GetIdx(pAnm,&idx1);
		(*outVal1) = pAnm->Work[idx1];
		GetInt(pAnm,outVal2);
	}else if (calc == CALC_WORK){
		//[Nm̌vZ
		GetTwoIdx(pAnm, &idx1, &idx2);
		(*outVal1) = pAnm->Work[idx1];
		(*outVal2) = pAnm->Work[idx2];
	}else{
		GF_ASSERT(0);
	}
}

//--------------------------------------------------------------
/**
 * ZEZE]vZʏ
 *
 * @param	pAnm			Aj|C^
 * @param	outDstIdx		i[惏[NCfbNX
 * @param	outVal1			1ߒli[obt@
 * @param	outVal2			2ߒli[obt@
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void CalcCommonSubDivMod(POKE_ANIME *pAnm, u8 *outDstIdx, int *outVal1, int *outVal2)
{
	u8 idx1,idx2;
	u8 calc1,calc2;
	//i[惏[NCfbNX擾
	GetIdx(pAnm,outDstIdx);
	//vZ^Cv擾
	GetU8(pAnm,&calc1);
	GetU8(pAnm,&calc2);
	
	if (calc1 == CALC_VAL){
		//l
		GetInt(pAnm,outVal1);
	}else if(calc1 == CALC_WORK){
		//[N
		GetIdx(pAnm,&idx1);
		(*outVal1) = pAnm->Work[idx1];
	}else{
		GF_ASSERT(0);
	}

	if (calc2 == CALC_VAL){
		//l
		GetInt(pAnm,outVal2);
	}else if(calc2 == CALC_WORK){
		//[N
		GetIdx(pAnm,&idx2);
		(*outVal2) = pAnm->Work[idx2];
	}else{
		GF_ASSERT(0);
	}
}

//--------------------------------------------------------------
/**
 * TCERTC
 *
 * @param	pAnm			Aj|C^
 * @param	outDstIdx		i[惏[NCfbNX
 * @param	outRad			WAli[obt@
 * @param	outL			Uli[obt@
 * 
 * @retval	COMP_MINUS:@COMP_PULS:傫@COMP_EQUAL	
 */
//--------------------------------------------------------------
static void CalcCommonSinCos(POKE_ANIME *pAnm, u8 *outDstIdx, int *outRad, int *outL)
{
	u8 rad_idx,l_idx,ofs_idx;
	int rad;
	int ofs;
	u8 use;
	
	//[NCfbNX擾
	//WA擾
	GetTwoIdx(pAnm, outDstIdx, &rad_idx);
	
	rad = pAnm->Work[rad_idx];

	//U擾
	GetU8(pAnm,&use);
	if (use == USE_VAL){
		GetInt(pAnm,outL);
	}else if(use == USE_WORK){
		GetIdx(pAnm,&l_idx);
		(*outL) = pAnm->Work[l_idx];
	}else{
		GF_ASSERT(0);
	}

	//ʑ擾
	GetU8(pAnm,&use);
	if (use == USE_VAL){
		GetInt(pAnm,&ofs);
	}else if(use == USE_WORK){
		GetIdx(pAnm,&ofs_idx);
		ofs = pAnm->Work[ofs_idx];
	}else{
		GF_ASSERT(0);
	}
	
	(*outRad) = rad+ofs;
	(*outRad) %= 0x10000;

}

//--------------------------------------------------------------
/**
 * lr	Qڂ̒lɑ΂ĂPڂ̒lǂȒlł邩Ԃ
 *
 * @param	inVal1		lP
 * @param	inVal2		lQ
 *
 * @retval	COMP_MINUS:@COMP_PULS:傫@COMP_EQUAL	
 */
//--------------------------------------------------------------
static u8 CompVal(const int *inVal1, const int *inVal2)
{
	int val;
	val = 	(*inVal1)-(*inVal2);
	if (val<0){
		return COMP_MINUS;
	}else if (val>0){
		return COMP_PLUS;
	}else{
		return COMP_EQUAL;
	}
}

//--------------------------------------------------------------
/**
 * gkɂcx␳
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void CorrectDy(POKE_ANIME *pAnm)
{
	int correct;
	correct = (-pAnm->ry)/8;
	SoftSpriteParaCalc(pAnm->SoftSprite, SS_PARA_POS_Y, correct);
}

/////////////////////////////////////////////////////////////////////////////////////////
//R}h

//--------------------------------------------------------------
/**
 * AjI
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_End(POKE_ANIME *pAnm)
{
	//XvCg̈ʒu
	PAnm_SetDefault(pAnm);
	
	pAnm->Request = 1;
	pAnm->End = 1;
}

//--------------------------------------------------------------
/**
 * Ajf	(܂ōsvZʂ`ɔf)
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_SetRequest(POKE_ANIME *pAnm)
{
	pAnm->Request = 1;
}

//--------------------------------------------------------------
/**
 * XvCgAjȌԂɖ߂i]Agkɑ΂ẮA]A{1Zbgj
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_SetDefault(POKE_ANIME *pAnm)
{
	//ʒuA]Agkɖ߂
	SoftSpriteParaSet(pAnm->SoftSprite, SS_PARA_POS_X, pAnm->OrgX);
	SoftSpriteParaSet(pAnm->SoftSprite, SS_PARA_POS_Y, pAnm->OrgY);

	SoftSpriteParaSet(pAnm->SoftSprite, SS_PARA_ROT_Z, 0);
	SoftSpriteParaSet(pAnm->SoftSprite, SS_PARA_ROT_CX, 0);

	SoftSpriteParaSet(pAnm->SoftSprite, SS_PARA_AFF_X, 0x100);
	SoftSpriteParaSet(pAnm->SoftSprite, SS_PARA_AFF_Y, 0x100);
}

//--------------------------------------------------------------
/**
 * [NԂ̒l̃Rs[	
 * 1ڂ̃CfbNXŎw肳郏[NɁA2ڂ̃CfbNXŎw肳郏[NRs[
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_CopyWorkVal(POKE_ANIME *pAnm)
{
	u8 idx1,idx2;
	GetTwoIdx(pAnm, &idx1, &idx2);

	pAnm->Work[idx1] = pAnm->Work[idx2];
}

//--------------------------------------------------------------
/**
 * [N̉Z
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_AddWorkVal(POKE_ANIME *pAnm)
{
	u8 dst_idx;
	int val1,val2;

	CalcCommonAddMul(pAnm, &dst_idx, &val1, &val2);
	
	pAnm->Work[dst_idx] = val1 + val2;
}

//--------------------------------------------------------------
/**
 * [N̏Z
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_MulWorkVal(POKE_ANIME *pAnm)
{
	u8 dst_idx;
	int val1,val2;
	
	CalcCommonAddMul(pAnm, &dst_idx, &val1, &val2);

	pAnm->Work[dst_idx] = val1 * val2;
//	OS_Printf("mul=%d\n",pAnm->Work[dst_idx]);
}

//--------------------------------------------------------------
/**
 * [ŇZ
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_SubWorkVal(POKE_ANIME *pAnm)
{
	u8 dst_idx;
	int val1,val2;

	CalcCommonSubDivMod(pAnm, &dst_idx, &val1, &val2);	

	pAnm->Work[dst_idx] = val1 - val2;
//	OS_Printf("sub=%d\n",pAnm->Work[dst_idx]);
}

//--------------------------------------------------------------
/**
 * [N̏Z
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_DivWorkVal(POKE_ANIME *pAnm)
{
	u8 dst_idx;
	int val1,val2;

	CalcCommonSubDivMod(pAnm, &dst_idx, &val1, &val2);	

	pAnm->Work[dst_idx] = val1 / val2;
//	OS_Printf("div=%d\n",pAnm->Work[dst_idx]);
}

//--------------------------------------------------------------
/**
 * [N̗]vZ
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_ModWorkVal(POKE_ANIME *pAnm)
{
	u8 dst_idx;
	int val1,val2;

	CalcCommonSubDivMod(pAnm, &dst_idx, &val1, &val2);	

	pAnm->Work[dst_idx] = val1 % val2;
}

//--------------------------------------------------------------
/**
 * lrɃ[NZbg
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_SetIfWorkVal(POKE_ANIME *pAnm)
{
	u8 idx1,idx2;
	u8 comp, comp_result;
	u8 use;
	
	{
		int val1,val2;
		GetU8(pAnm,&use);  
		if (use == USE_VAL){
			GetIdx(pAnm,&idx1);
			val1 = pAnm->Work[idx1];
			GetInt(pAnm,&val2);
		}else if(use == USE_WORK){
			GetTwoIdx(pAnm, &idx1, &idx2);
			val1 = pAnm->Work[idx1];
			val2 = pAnm->Work[idx2];
		}else{
			GF_ASSERT(0);
		}
	
		GetU8(pAnm,&comp);
	
		GF_ASSERT((comp<=COMP_EQUAL)&&"ERROR:COMP_ERROR");
		//r
		comp_result = CompVal(&val1, &val2);
	}
	
	{
		int val;
		GetU8(pAnm,&use);
		if (use == USE_VAL){
			GetIdx(pAnm,&idx1);
			GetInt(pAnm,&val);
		}else if(use == USE_WORK){
			GetTwoIdx(pAnm, &idx1, &idx2);
			val = pAnm->Work[idx2];
		}else{
			GF_ASSERT(0);
		}

		if (comp == comp_result){	
			pAnm->Work[idx1] = val;
		}
	}
}

//--------------------------------------------------------------
/**
 * [NɒlZbg
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_SetWorkVal(POKE_ANIME *pAnm)
{
	u8 idx;
	GetIdx(pAnm, &idx);
	
	ADRS_SHIFT(pAnm->SeqAdrs);
	pAnm->Work[idx] = (int)GetSeqAdrs(pAnm->SeqAdrs);
}

//--------------------------------------------------------------
/**
 * [vJn
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_StartLoop(POKE_ANIME *pAnm)
{
	GF_ASSERT(pAnm->LoopStartAdrs==NULL&&"ERROR:Loop is moving");
	
	ADRS_SHIFT(pAnm->SeqAdrs);
	//[vJnAhXۑ
	pAnm->LoopStartAdrs = pAnm->SeqAdrs;
	//ő僋[v񐔕ۑ
	pAnm->LoopMax = (int)GetSeqAdrs(pAnm->SeqAdrs);
	pAnm->LoopCount = 0;
}

//--------------------------------------------------------------
/**
 * [vI
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_EndLoop(POKE_ANIME *pAnm)
{
	pAnm->LoopCount++;
	if (pAnm->LoopCount >= pAnm->LoopMax){
		//[vI
		pAnm->LoopStartAdrs = NULL;
		pAnm->LoopCount = 0;
		pAnm->LoopMax = 0;
	}else{
		//[vp
		pAnm->SeqAdrs = pAnm->LoopStartAdrs;	//AhX߂
	}
}

//--------------------------------------------------------------
/**
 * XvCgɒlZbg
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_SetVal(POKE_ANIME *pAnm)
{
	u8 idx;
	int ss_param;
	//ύXp[^擾
	GetInt(pAnm,&ss_param);
/**
	GetInt(pAnm,&use);
	if (use == USE_VAL){
		;
	}else if(use == USE_WAORK){
		;
	}else{
		GF_ASSERT(0);
	}
*/	
	GetIdx(pAnm, &idx);
	
	//Zbg
	SoftSpriteParaSet(pAnm->SoftSprite, ss_param, pAnm->Work[idx]);
}

//--------------------------------------------------------------
/**
 * XvCgɒlAbh
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_AddVal(POKE_ANIME *pAnm)
{
	u8 idx;
	int ss_param;
	//ύXp[^擾
	GetInt(pAnm,&ss_param);
	
	GetIdx(pAnm, &idx);
	
	//Abh
	SoftSpriteParaCalc(pAnm->SoftSprite, ss_param, pAnm->Work[idx]);
}

//--------------------------------------------------------------
/**
 * XvCgɒlZbgEAbh
 *
 * @param	pAnm			Aj|C^
 * @param	
 * @param	
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_SetAddVal(POKE_ANIME *pAnm)
{
	int ss_param;
	int val;
	
	//ύXp[^擾
	GetInt(pAnm,&ss_param);
	{
		u8 idx;
		u8 use;
		GetU8(pAnm,&use);
		if (use == USE_VAL){
			GetInt(pAnm,&val);
		}else if(use == USE_WORK){
			GetIdx(pAnm,&idx);
			val = pAnm->Work[idx];
		}else{
			GF_ASSERT(0);
		}
	}

	{
		u8 ss_calc;
		GetU8(pAnm,&ss_calc);
		if (ss_calc == PARAM_SET){
			SoftSpriteParaSet(pAnm->SoftSprite, ss_param, val);
		}else if (ss_calc == PARAM_ADD){
			SoftSpriteParaCalc(pAnm->SoftSprite, ss_param, val);
		}else{
			GF_ASSERT(0);
		}
	}
}

//--------------------------------------------------------------
/**
 * TCvZ
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_SetWorkValSin(POKE_ANIME *pAnm)
{
	u8 idx;
	int dst_rad;
	int l;

	CalcCommonSinCos(pAnm,&idx,&dst_rad,&l);
	
	pAnm->Work[idx] = FX_Whole( FX_SinIdx(dst_rad)*l );
//	OS_Printf("sin=%d\n",pAnm->Work[idx]);
}

//--------------------------------------------------------------
/**
 * RTCvZ
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_SetWorkValCos(POKE_ANIME *pAnm)
{
	u8 idx;
	int dst_rad;
	int l;

	CalcCommonSinCos(pAnm,&idx,&dst_rad,&l);

	pAnm->Work[idx] = FX_Whole( FX_CosIdx(dst_rad)*l );
}

//--------------------------------------------------------------
/**
 * ړlAjf[^gXlɃZbg
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_SetTrans(POKE_ANIME *pAnm)
{
	u8 idx;
	u8 trans;
	
	//[NCfbNX擾
	GetIdx(pAnm, &idx);

	//ύXΏێ擾
	GetU8(pAnm,&trans);

	if (trans == PARAM_X){
		pAnm->TransX = pAnm->Work[idx];
	}else if (trans == PARAM_Y){
		pAnm->TransY = pAnm->Work[idx];
	}else{
		GF_ASSERT(0);
	}
}

//--------------------------------------------------------------
/**
 * ړlAjf[^gXlɃAbh
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_AddTrans(POKE_ANIME *pAnm)
{
	u8 idx;
	u8 trans;
	
	//[NCfbNX擾
	GetIdx(pAnm, &idx);

	//ύXΏێ擾
	GetU8(pAnm,&trans);

	if (trans == PARAM_X){
		pAnm->TransX += pAnm->Work[idx];
	}else if (trans == PARAM_Y){
		pAnm->TransY += pAnm->Work[idx];
	}else{
		GF_ASSERT(0);
	}
}

//--------------------------------------------------------------
/**
 * lAjf[^lɃZbgEAbh
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_SetAddParam(POKE_ANIME *pAnm)
{
	int *target;
	int val;

	{
		u8 param;

		//ύXp[^擾
		GetU8(pAnm,&param);
		if (param == PARAM_X){
			target = &pAnm->TransX; 
		}else if (param == PARAM_Y){
			target = &pAnm->TransY;
		}else if (param == PARAM_DX){
			target = &pAnm->dx;
		}else if (param == PARAM_DY){
			target = &pAnm->dy;
		}else if (param == PARAM_RX){
			target = &pAnm->rx;
		}else if (param == PARAM_RY){
			target = &pAnm->ry;
		}else if (param == PARAM_ROT){
			target = &pAnm->Rot;
		}else{
			GF_ASSERT(0);
		}
	}
	
	{
		u8 idx;
		u8 use;
		GetU8(pAnm,&use);
		if (use == USE_VAL){
			GetInt(pAnm,&val);
		}else if(use == USE_WORK){
			GetIdx(pAnm,&idx);
			val = pAnm->Work[idx];
		}else{
			GF_ASSERT(0);
		}
	}

	{
		u8 calc;
		GetU8(pAnm,&calc);
		if (calc == PARAM_SET){
			(*target) = val;
		}else if (calc == PARAM_ADD){
			(*target) += val;
		}else{
			GF_ASSERT(0);
		}
	}

}

//--------------------------------------------------------------
/**
 * Ajf[^gXlXvCgɔf
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_ApplyTrans(POKE_ANIME *pAnm)
{
	if (pAnm->PokeReverse){
		SoftSpriteParaSet(pAnm->SoftSprite, SS_PARA_POS_X, pAnm->OrgX-(pAnm->TransX+pAnm->dx));
	}else{
		SoftSpriteParaSet(pAnm->SoftSprite, SS_PARA_POS_X, pAnm->OrgX+pAnm->TransX+pAnm->dx);
	}
	SoftSpriteParaSet(pAnm->SoftSprite, SS_PARA_POS_Y, pAnm->OrgY+pAnm->TransY+pAnm->dy);
//	SoftSpriteParaSet(pAnm->SoftSprite, SS_PARA_POS_OX, pAnm->dx);
//	SoftSpriteParaSet(pAnm->SoftSprite, SS_PARA_POS_OY, pAnm->dy);
///	OS_Printf("pos_x = %d\n",SoftSpriteParaGet(pAnm->SoftSprite,SS_PARA_POS_X));
}

//--------------------------------------------------------------
/**
 * Ajf[^]AgklXvCgɔf
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_ApplyAffine(POKE_ANIME *pAnm)
{
	SoftSpriteParaSet(pAnm->SoftSprite, SS_PARA_AFF_X, 0x100+pAnm->rx);
	SoftSpriteParaSet(pAnm->SoftSprite, SS_PARA_AFF_Y, 0x100+pAnm->ry);
	SoftSpriteParaSet(pAnm->SoftSprite, SS_PARA_ROT_Z, (u16)pAnm->Rot);

	{
		int correct;
		//d␳邩H
		if (pAnm->CorrectDy == CORRECT_ON_MINUS){
			//gk}CiX̂Ƃɕ␳
			if (pAnm->ry < 0){
				CorrectDy(pAnm);
			}
		}else if (pAnm->CorrectDy == CORRECT_ON_NOT_EQ){
			//gk{ł͂ȂƂɕ␳
			if (pAnm->ry != 0){
				CorrectDy(pAnm);
			}
		}else if(pAnm->CorrectDy == CORRECT_OFF){
			return;
		}else{
			GF_ASSERT(0);
		}
	}
}

//--------------------------------------------------------------
/**
 * ړl(dx.dy)Ajf[^DlɃZbg
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_SetD(POKE_ANIME *pAnm)
{
	u8 idx;
	u8 trans;
	
	//[NCfbNX擾
	GetIdx(pAnm, &idx);
	
	//ύXΏێ擾
	ADRS_SHIFT(pAnm->SeqAdrs);
	trans =  (int)GetSeqAdrs(pAnm->SeqAdrs);
	if ((trans == PARAM_X)||(trans == PARAM_DX)){
		pAnm->dx = pAnm->Work[idx];
	}else if ((trans == PARAM_Y)||(trans == PARAM_DY)){
		pAnm->dy = pAnm->Work[idx];
	}else{
		GF_ASSERT(0);
	}
}

//--------------------------------------------------------------
/**
 * EFCgɃZbg
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_SetWait(POKE_ANIME *pAnm)
{
	//[NCfbNX擾
	GetInt(pAnm, &pAnm->Wait);
	pAnm->Request = 1;
}

//--------------------------------------------------------------
/**
 *@pbgtF[h
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_PaletteFade(POKE_ANIME *pAnm)
{
	u8 start,end,wait;
	int rgb;
	
	GetU8(pAnm,&start);
	GetU8(pAnm,&end);
	GetU8(pAnm,&wait);
	GetInt(pAnm,&rgb);

	SoftSpritePalFadeSet(pAnm->SoftSprite, start, end, wait, rgb);
	
}

//--------------------------------------------------------------
/**
 *@pbgtF[hEFCg
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_WaitPaletteFade(POKE_ANIME *pAnm)
{
	u8 start,end,wait;

	if( SoftSpritePalFadeExist(pAnm->SoftSprite) ){//tF[h̏󋵂݂
		//tF[hp
		pAnm->PalFadeWaitFlg = 1;
		pAnm->Request = 1;
	}
}


////////////////////////////////////////////////////////////////////////////////
//֐ZbgR}h

//--------------------------------------------------------------
/**
 * R}h߃z[h
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_HoldAnmCommand(POKE_ANIME *pAnm)
{
	pAnm->CommandHold = 1;
}

//--------------------------------------------------------------
/**
 * DY␳LtORg[
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_SetDyCorrect(POKE_ANIME *pAnm)
{
	GetU8(pAnm,&pAnm->CorrectDy);
	GF_ASSERT(	(pAnm->CorrectDy==CORRECT_ON_MINUS)||
				(pAnm->CorrectDy==CORRECT_ON_NOT_EQ)||
				(pAnm->CorrectDy==CORRECT_OFF)
			&&"ERROR:Correct Unknown");
}

//--------------------------------------------------------------
/**
 * J[u֐R[
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_CallMoveFuncCurve(POKE_ANIME *pAnm)
{
	CallMoveFuc(pAnm, MOVE_CURVE);
}

//--------------------------------------------------------------
/**
 *@J[u񐔕֐R[
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_CallMoveFuncCurveDivTime(POKE_ANIME *pAnm)
{
	CallMoveFuc(pAnm, MOVE_CURVE_DIVTIME);
}

//--------------------------------------------------------------
/**
 * C֐R[
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_CallMoveFuncLine(POKE_ANIME *pAnm)
{
	CallMoveFuc(pAnm, MOVE_LINE);
}

//--------------------------------------------------------------
/**
 *@C񐔕֐R[
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_CallMoveFuncLineDivTime(POKE_ANIME *pAnm)
{
	CallMoveFuc(pAnm, MOVE_LINE_DIVTIME);
}

//--------------------------------------------------------------
/**
 *@CړIlw֐R[
 *
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PAnm_CallMoveFuncLineDst(POKE_ANIME *pAnm)
{
	CallMoveFuc(pAnm, MOVE_LINE_DST);
}


/////////////////////////////////////////////////////////////////////////////////////////////
//Aj֐֘A

//--------------------------------------------------------------
/**
 * Ajf[^ϐɓ֐l𔽉f
 *
 * @param	inType			Kp@
 * @param	inApplyVal		Kpl
 * @param	outTarget		KpΏ
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void ApplyMoveVal(const u8 inType, const int *inStartVal, const int *inApplyVal, int *outTarget )
{
	if (inType == APPLY_SET){			//Zbg
		(*outTarget) = (*inApplyVal);
	}else if(inType == APPLY_ADD){		//JnlɉZ
		(*outTarget) = (*inStartVal) + (*inApplyVal);
	}else if(inType == APPLY_SYNTHE){	//ݒlɉZ()
		(*outTarget) += (*inApplyVal);
	}else{
		GF_ASSERT(0);
	}
}

//--------------------------------------------------------------
/**
 *	ύXΏێ擾
 *
 * @param	inTarget		KpΏ
 * @param	pMFD			֐f[^|C^
 * @param	pAnm			Ajf[^|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void GetTarget(	const u8 inTarget, MOVE_FUNC_DATA_PTR pMFD, POKE_ANM_PTR pAnm )
{
	switch(inTarget){
	case TARGET_DX:
		pMFD->Target = &pMFD->dx;
		pMFD->ApplyTarget = &pAnm->dx;
		pMFD->StartVal = pAnm->dx;
		break;
	case TARGET_DY:
		pMFD->Target = &pMFD->dy;
		pMFD->ApplyTarget = &pAnm->dy;
		pMFD->StartVal = pAnm->dy;
		break;
	case TARGET_RX:
		pMFD->Target = &pMFD->rx;
		pMFD->ApplyTarget = &pAnm->rx;
		pMFD->StartVal = pAnm->rx;
		break;
	case TARGET_RY:
		pMFD->Target = &pMFD->ry;
		pMFD->ApplyTarget = &pAnm->ry;
		pMFD->StartVal = pAnm->ry;
		break;
	case TARGET_ROT:
		pMFD->Target = &pMFD->Rot;
		pMFD->ApplyTarget = &pAnm->Rot;
		pMFD->StartVal = pAnm->Rot;
		break;
	default:
		GF_ASSERT(0&&"ERROR:UnkownTarget!");
	}
}

//--------------------------------------------------------------
/**
 * ֐R[
 * ֐̃[N͂߂Ďg
 *
 * @param	pAnm				Aj|C^
 * @param	inMoveFuncNo		֐ԍ
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void CallMoveFuc(POKE_ANIME *pAnm, const int inMoveFuncNo)
{
	u8 i;
	MOVE_FUNC_DATA_PTR ptr;	
	//󂢂ĂǗꏊɓ֐Zbg
	ptr = SetMoveFunc(pAnm,inMoveFuncNo);

	//vZʓKp@Zbg
	GetU8(pAnm,&ptr->ApplyType);

	//֐sҋ@ԃZbg
	GetU8(pAnm,&ptr->Wait);
	
	//ɕKvȃp[^̃Zbg
	for(i=0;i<MoveFuncTbl[inMoveFuncNo].ParamNum;i++){
		GetInt(pAnm,&ptr->Work[i]);
///		OS_Printf("param=%d\n",ptr->Work[i]);
	}

	{
		int idx;
		idx = MoveFuncTbl[inMoveFuncNo].TargetWorkIdx;

///		OS_Printf("workidx = %d:%d\n",idx,ptr->Work[idx]);
		//ύXΏۂ̎擾
		GetTarget(ptr->Work[idx], ptr, pAnm);
	}

	if (ptr->Wait == 0){
		//s
		ptr->Func(ptr,pAnm);
	}else{
		ptr->Wait--;
	}
}

//--------------------------------------------------------------
/**
 * J[uړ
 * work0:J[u^CviZbgρj
 * work1:Ώ  (Zbg)
 * work2:UiZbgρj
 * work3:ZpxiZbgρj
 * work4:ʑiZbgρj
 * work5:vZ񐔁iZbgρj
 * work6:񐔂̃JEg
 *
 * @param	pMFD			֐f[^|C^
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PMove_Curve(MOVE_FUNC_DATA_PTR pMFD, POKE_ANM_PTR pAnm)
{
	u16 rad;
	
	int *work;
	
	work = pMFD->Work;

	rad = (work[3]*(work[6]+1))+work[4];

	switch(work[0]){
	case CURVE_SIN:
		(*pMFD->Target) = FX_Whole( FX_SinIdx(rad)*work[2] );
		break;
	case CURVE_COS:
		(*pMFD->Target) = FX_Whole( FX_CosIdx(rad)*work[2] );
		break;
	case CURVE_SIN_MINUS:
		(*pMFD->Target) = -FX_Whole( FX_SinIdx(rad)*work[2] );
		break;
	case CURVE_COS_MINUS:
		(*pMFD->Target) = -FX_Whole( FX_CosIdx(rad)*work[2] );
		break;
	default:
		GF_ASSERT(0&&"ERROR:UnkownCurveType!");
	}
	
	ApplyMoveVal(pMFD->ApplyType, &(pMFD->StartVal), pMFD->Target, pMFD->ApplyTarget );

	work[6]++;

	if (work[6] >= work[5]){
		//I
		pMFD->Valid = FALSE;
	}
}

//--------------------------------------------------------------
/**
 * J[uړ	񐔕(߂ꂽs񐔓ŁAwl̈ړ@R)
 * work0:J[u^CviZbgρj
 * work1:Ώ (Zbg)
 * work2:UiZbgρj
 * work3:pxiZbgρj
 * work4:ʑiZbgρj
 * work5:vZ񐔁iZbgρj
 * work6:񐔂̃JEg
 *
 * @param	pMFD			֐f[^|C^
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PMove_CurveDivTime(MOVE_FUNC_DATA_PTR pMFD, POKE_ANM_PTR pAnm)
{
	u16 rad;
	
	int *work;
	
	work = pMFD->Work;

	rad = ( (work[3]*(work[6]+1))/work[5] )+work[4];

	switch(work[0]){
	case CURVE_SIN:
		(*pMFD->Target) = FX_Whole( FX_SinIdx(rad)*work[2] );
		break;
	case CURVE_COS:
		(*pMFD->Target) = FX_Whole( FX_CosIdx(rad)*work[2] );
		break;
	case CURVE_SIN_MINUS:
		(*pMFD->Target) = -FX_Whole( FX_SinIdx(rad)*work[2] );
		break;
	case CURVE_COS_MINUS:
		(*pMFD->Target) = -FX_Whole( FX_CosIdx(rad)*work[2] );
		break;
	default:
		GF_ASSERT(0&&"ERROR:UnkownCurveType!");
	}
	
	ApplyMoveVal(pMFD->ApplyType, &(pMFD->StartVal), pMFD->Target, pMFD->ApplyTarget );

	work[6]++;

	if (work[6] >= work[5]){
		//I
		pMFD->Valid = FALSE;
	}
}

//--------------------------------------------------------------
/**
 * ړ
 * work0:Ώ  (Zbg)
 * work1:xiZbgρj
 * work2:xiZbgρj
 * work3:vZ񐔁iZbgρj
 * work4:񐔂̃JEg
 *
 * @param	pMFD			֐f[^|C^
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PMove_Line(MOVE_FUNC_DATA_PTR pMFD, POKE_ANM_PTR pAnm)
{
	int move;
	int *work;
	
	work = pMFD->Work;

	move = work[1]+(work[2]*work[4]);

	(*pMFD->Target)+=move;

	ApplyMoveVal(pMFD->ApplyType, &(pMFD->StartVal), pMFD->Target, pMFD->ApplyTarget );

///	OS_Printf("trans=%d\n",pAnm->TransX);

	work[4]++;

	if (work[4] >= work[3]){
		//I
		pMFD->Valid = FALSE;
	}
}

//--------------------------------------------------------------
/**
 * ړ@񐔕(߂ꂽs񐔓ŁAwl̈ړ@R)
 * work0:Ώ (Zbg)
 * work1:ړliZbgρj
 * work2:vZ񐔁iZbgρj
 * work3:񐔂̃JEg
 *
 * @param	pMFD			֐f[^|C^
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PMove_LineDivTime(MOVE_FUNC_DATA_PTR pMFD, POKE_ANM_PTR pAnm)
{
	int move;
	int *work;
	
	work = pMFD->Work;

	move = ( (work[3]+1)*work[1] )/work[2];

	(*pMFD->Target) = move;

	ApplyMoveVal(pMFD->ApplyType, &(pMFD->StartVal), pMFD->Target, pMFD->ApplyTarget );

	work[3]++;

	if (work[3] >= work[2]){
		//I
		pMFD->Valid = FALSE;
	}
}

//--------------------------------------------------------------
/**
 * ړړIlw
 * work0:Ώ  (Zbg)
 * work1:xiZbgρj
 * work2:xiZbgρj
 * work3:ړIliZbgρj
 * work4:񐔂̃JEg
 *
 * @param	pMFD			֐f[^|C^
 * @param	pAnm			Aj|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void PMove_LineDst(MOVE_FUNC_DATA_PTR pMFD, POKE_ANM_PTR pAnm)
{
	int move;
	int *work;
	
	work = pMFD->Work;

	move = work[1]+(work[2]*work[4]);

	(*pMFD->Target)+=move;

	if ( (pMFD->ApplyType == APPLY_SET) ||
		 (pMFD->ApplyType == APPLY_SYNTHE) ){			//Zbg
		if (move < 0){		//񂾒l}CiX̏ꍇ
			if ((*pMFD->Target) <= work[3]){	//ݒl̂قړIl菬ΏI
				(*pMFD->Target) = work[3];	//ړIlZbg
				pMFD->Valid = FALSE;
			}
		}else{				//񂾒lvX̏ꍇ
			if ((*pMFD->Target) >= work[3]){	//ݒl̂قړIl傫ΏI
				(*pMFD->Target) = work[3];	//ړIlZbg
				pMFD->Valid = FALSE;
			}
		}
	}else if(pMFD->ApplyType == APPLY_ADD){		//JnlɉZ
		int val = pMFD->StartVal+(*pMFD->Target);
		if (move < 0){		//񂾒l}CiX̏ꍇ
			if (val <= work[3]){	//ݒl̂قړIl菬ΏI
				(*pMFD->Target) += (work[3]- val);	//ړIlZbg
				pMFD->Valid = FALSE;
			}
		}else{				//񂾒lvX̏ꍇ
			if (val >= work[3]){	//ݒl̂قړIl傫ΏI
				(*pMFD->Target) -= (val - work[3]);	//ړIlZbg
				pMFD->Valid = FALSE;
			}
		}
	}else{
		GF_ASSERT(0);
	}

	ApplyMoveVal(pMFD->ApplyType, &(pMFD->StartVal), pMFD->Target, pMFD->ApplyTarget );

///	OS_Printf("trans=%d\n",pAnm->TransX);

	work[4]++;
}


