//============================================================================================
/**
 * @file	poke_memo.c
 * @brief	g[i[f[^擾
 * @author	
 * @date	
 */
//============================================================================================
#include	"common.h"
#include	"poketool/poke_tool.h"
#include	"poke_tool_def.h"
#include	"system/gamedata.h"

#include	"system/arc_tool.h"
#include	"system/arc_util.h"
#include	"system/fontproc.h"
#include	"system/msgdata.h"
#include	"system/wordset.h"
#include	"system/numfont.h"
#include	"system/buflen.h"
#include	"poketool/monsno.h"
#include	"system/pm_rtc.h"

#include	"msgdata/msg.naix"
#include	"msgdata/msg_pokestatus.h"
#include	"battle/chr_def.h"

#include	"savedata/mystatus.h"
#include	"poketool/poke_memo.h"

#include	"system/placename.h"
#include	"msgdata/msg_place_name.h"
#include	"msgdata/msg_place_name_haihu.h"
#include	"msgdata/msg_place_name_tokusyu.h"


//----------------------------------------------------------
#define PLACEID_MAP( ID )	( PlaceName_IndexToParamNumber( PLACENAME_TYPE_MAP, ID ))
#define PLACEID_GEV( ID )	( PlaceName_IndexToParamNumber( PLACENAME_TYPE_GAME_EVENT, ID ))
#define PLACEID_EEV( ID )	( PlaceName_IndexToParamNumber( PLACENAME_TYPE_EXT_EVENT, ID ))

#define PLACEID_POKEPARK			( PLACEID_MAP( MAPNAME_D10POKEPARK ))

#define PLACEID_MAX					( PLACEID_GEV( MAPNAME_SODATEYA ))

#define PLACEID_SODATEYA			( PLACEID_GEV( MAPNAME_SODATEYA ))
#define PLACEID_TABI				( PLACEID_GEV( MAPNAME_TABINOOZISAN ))
#define PLACEID_GEN					( PLACEID_GEV( MAPNAME_GEN ))

#define PLACEID_NAIBUTUUSINKOUKAN	( PLACEID_GEV( MAPNAME_NAIBUTUUSINKOUKAN ))
#define PLACEID_TUUSINKOUKAN		( PLACEID_GEV( MAPNAME_TUUSINKOUKAN ))
#define PLACEID_KANTO				( PLACEID_GEV( MAPNAME_KANTO ))
#define PLACEID_ZYOTO				( PLACEID_GEV( MAPNAME_ZYOTO ))
#define PLACEID_HOUEN				( PLACEID_GEV( MAPNAME_HOUEN ))
#define PLACEID_SINOU				( PLACEID_GEV( MAPNAME_HUSEI/* MAPNAME_SINOU */ ))
#define PLACEID_HUSEI				( PLACEID_GEV( MAPNAME_HUSEI ))
#define PLACEID_TOOKUHANARETATOTI	( PLACEID_GEV( MAPNAME_TOOKUHANARETATOTI ))

#define PLACEID_RENJA				( PLACEID_EEV( MAPNAME_RENJA ))

//----------------------------------------------------------
// g[i[^Cvhc
enum{	
	// ̂Ŏ擾FevFꏊPiȂjꏊQiߊlꏊj
	MEMOID_POKETYPE1 = 0,
	// ̂Ŏ擾FesvFꏊPiȂjꏊQiߊlꏊj
	MEMOID_POKETYPE2,
	// ̂Ŏ擾FꏊPiȂjꏊQiQ[j
	MEMOID_POKETYPE3,	
	// ^}SŎ擾FꏊPiʐMjꏊQizꏊj
	MEMOID_POKETYPE4,	
	// ̂Ŏ擾FꏊPiʐMjꏊQizꏊj
	MEMOID_POKETYPE5,	
	// ^}SŎ擾FꏊPiĉjꏊQizꏊj
	MEMOID_POKETYPE6,	
	// ̂Ŏ擾FꏊPiĉjꏊQizꏊj
	MEMOID_POKETYPE7,
	// ̂Ŏ擾FevFꏊPiȂjꏊQiOzzꏊjFOzztOnm
	MEMOID_POKETYPE8,
	// ̂Ŏ擾FesvFꏊPiȂjꏊQiOzzꏊjFOzztOnm
	MEMOID_POKETYPE9,
	// ^}SŎ擾FꏊPiOzzꏊjꏊQizꏊjFOzztOnm
	MEMOID_POKETYPE10,
	// ̂Ŏ擾FꏊPiOzzꏊjꏊQizꏊjFOzztOnm
	MEMOID_POKETYPE11,
	// ^}SŎ擾FꏊPi\tgjꏊQizꏊjFOzztOnm
	MEMOID_POKETYPE12,
	// ̂Ŏ擾FꏊPi\tgjꏊQizꏊjFOzztOnm
	MEMOID_POKETYPE13,
	// ^}SŎ擾FꏊPiʐMjꏊQizꏊjFOzztOnm
	MEMOID_POKETYPE14,
	// ̂Ŏ擾FꏊPiʐMjꏊQizꏊjFOzztOnm
	MEMOID_POKETYPE15,
	// ̂Ŏ擾FꏊPiȂjꏊQi|PߋJ[gbWj
	MEMOID_POKETYPE16,

	// ^}SFevFꏊPiĉjꏊQiȂj
	MEMOID_TAMAGOTYPE1,
	// ^}SFesvFꏊPiȂjꏊQiʐMj
	MEMOID_TAMAGOTYPE2,
	// ^}SFevFꏊPiOzzꏊjꏊQiȂjFOzztOnm
	MEMOID_TAMAGOTYPE3,
	// ^}SFesvFꏊPiȂjꏊQiʐMjFOzztOnm
	MEMOID_TAMAGOTYPE4,
	// ^}SFevFꏊPi\tgjꏊQiȂjFOzztOnm
	MEMOID_TAMAGOTYPE5,
};

// f[^QƑI
enum{	
	DATA1 = 0,	//f[^PQ
	DATA2,		//f[^QQ
};

static int	TrainerMemoIDGet( POKEMON_PARAM* pp, BOOL mine, int heapID );

static void character1_msgGet( TRMEMO_DATA* dat );
static void encount_msgGet( TRMEMO_DATA* dat, int msgID );
static void encountPark_msgGet( TRMEMO_DATA* dat, int msgID );
static void encountEgg_msgGet( TRMEMO_DATA* dat, int msgID,int flag );
static void character2_msgGet( TRMEMO_DATA* dat ); 
static void palate_msgGet( TRMEMO_DATA* dat );
static void eggstatus_msgGet( TRMEMO_DATA* dat );

// bZ[WTCY
#define MSGLINE_BUFSIZ	( (2*18)*2 ) // [JCYl18word*2
#define WORDSET_NUM		(9)

// |Pp[^擾
#define PARAM_GET( pp, id )			(PokeParaGet( pp, id, NULL)) 
#define PARAM_GETP( ppp, id )		(PokePasoParaGet( ppp, id, NULL)) 

// |Pp[^ݒ
#define PARAM_PUT( pp, id, buf )	(PokeParaPut( pp, id, buf)) 
#define PARAM_PUTP( ppp, id, buf )	(PokePasoParaPut( ppp, id, buf)) 

//ȉA|Pf[^\̍ږƎdlevȂ̂ŕϊ
// g[i[pf[^P:ꏊ
#define	ID_PARA_trMemo1place	( ID_PARA_get_place )	
#define	ID_PARA_trMemo1year		( ID_PARA_get_year )	
#define	ID_PARA_trMemo1month	( ID_PARA_get_month )	
#define	ID_PARA_trMemo1day		( ID_PARA_get_day )	
#define	ID_PARA_trMemo2place	( ID_PARA_birth_place )	
#define	ID_PARA_trMemo2year		( ID_PARA_birth_year )	
#define	ID_PARA_trMemo2month	( ID_PARA_birth_month )	
#define	ID_PARA_trMemo2day		( ID_PARA_birth_day )	

//----------------------------------------------------------
/**
 * @brief	g[i[̎擾
 * @param	pp		擾Ώۃ|Pf[^
 * @param	heapID	擾pq[vw
 * @return	msgtbl	擾ꂽbZ[We[u|C^
 */
//----------------------------------------------------------
// bZ[W\̏
#define MSGDATA_INIT( msgdata ){		\
	msgdata.line	= 0;				\
	msgdata.msg		= NULL;				\
}

// bZ[W\̊J
#define MSGDATA_FREE( msgdata ){			\
	if( msgdata.msg	!= NULL ){				\
		sys_FreeMemoryEz( msgdata.msg );	\
	}										\
}

// ibZ[W擾
#define GET_CHARCTER1( linenum ){		\
	dat->character1.line = linenum;		\
	character1_msgGet( dat );			\
}

// obZ[W擾
#define GET_ENCOUNT( linenum, msgID ){	\
	dat->encount.line = linenum;		\
	encount_msgGet( dat, msgID );		\
}

// oi^}SjbZ[W擾
#define GET_ENCOUNTEGG( linenum, msgID, flag ){	\
	dat->encount.line = linenum;				\
	encountEgg_msgGet( dat, msgID, flag );		\
}

// iQbZ[W擾
#define GET_CHARCTER2( linenum ){	\
	dat->character2.line = linenum;	\
	character2_msgGet( dat );		\
}

// obZ[W擾
#define GET_PALATE( linenum ){		\
	dat->palate.line = linenum;		\
	palate_msgGet( dat );			\
}

// ^}SԃbZ[W擾
#define GET_EGGSTATUS( linenum ){	\
	dat->eggstatus.line = linenum;	\
	eggstatus_msgGet( dat );		\
}

TRMEMO_DATA*	TrainerMemoGet( POKEMON_PARAM* pp, BOOL mine, int heapID )
{
	TRMEMO_DATA* dat;

	dat = sys_AllocMemory( heapID, sizeof( TRMEMO_DATA ) );
	dat->heapID = heapID;
	dat->msg_man = MSGMAN_Create
		( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_pokestatus_dat, dat->heapID );
	dat->word_set = WORDSET_CreateEx( WORDSET_NUM, WORDSET_DEFAULT_BUFLEN, dat->heapID );
	dat->pp = pp;
	dat->mine = mine;

	{
		//bZ[Wz̏
		MSGDATA_INIT( dat->character1 )
		MSGDATA_INIT( dat->encount )
		MSGDATA_INIT( dat->character2 )
		MSGDATA_INIT( dat->palate )
		MSGDATA_INIT( dat->eggstatus )
	}
	
	switch( TrainerMemoIDGet( dat->pp, dat->mine, dat->heapID ) ){

	// ̂Ŏ擾FevFꏊPiȂjꏊQiߊlꏊj
	case MEMOID_POKETYPE1:
		GET_CHARCTER1( 1 )
		GET_ENCOUNT( 2, mes_status_03_03_01_01 )
		GET_CHARCTER2( 6 )
		GET_PALATE( 7 )
		break;
	
	// ̂Ŏ擾FesvFꏊPiȂjꏊQiߊlꏊj
	case MEMOID_POKETYPE2:
		GET_CHARCTER1( 1 )
		GET_ENCOUNT( 2, mes_status_03_03_01_02 )
		GET_CHARCTER2( 6 )
		GET_PALATE( 7 )
		break;
	
	// ̂Ŏ擾FꏊPiȂjꏊQiQ[j
	case MEMOID_POKETYPE3:	
		GET_CHARCTER1( 1 )
		GET_ENCOUNT( 2, mes_status_03_03_02_01 )
		GET_CHARCTER2( 6 )
		GET_PALATE( 7 )
		break;
	
	// ^}SŎ擾FꏊPiʐMjꏊQizꏊj
	case MEMOID_POKETYPE4:	
		GET_CHARCTER1( 1 )
		GET_ENCOUNT( 2, mes_status_03_03_03_01 )
		GET_CHARCTER2( 8 )
		GET_PALATE( 9 )
		break;
	
	// ̂Ŏ擾FꏊPiʐMjꏊQizꏊj
	case MEMOID_POKETYPE5:	
		GET_CHARCTER1( 1 )
		GET_ENCOUNT( 2, mes_status_03_03_03_02 )
		GET_CHARCTER2( 8 )
		GET_PALATE( 9 )
		break;
	
	// ^}SŎ擾FꏊPiĉjꏊQizꏊj
	case MEMOID_POKETYPE6:	
		GET_CHARCTER1( 1 )
		GET_ENCOUNT( 2, mes_status_03_03_04_01 )
		GET_CHARCTER2( 8 )
		GET_PALATE( 9 )
		break;
	
	// ̂Ŏ擾FꏊPiĉjꏊQizꏊj
	case MEMOID_POKETYPE7:
		GET_CHARCTER1( 1 )
		GET_ENCOUNT( 2, mes_status_03_03_04_02 )
		GET_CHARCTER2( 8 )
		GET_PALATE( 9 )
		break;
	
	// ̂Ŏ擾FevFꏊPiȂjꏊQiOzzꏊjFOzztOnm
	case MEMOID_POKETYPE8:
		GET_CHARCTER1( 1 )
		GET_ENCOUNT( 2, mes_status_03_03_05_01 )
		GET_CHARCTER2( 7 )
		GET_PALATE( 8 )
		break;
	
	// ̂Ŏ擾FesvFꏊPiȂjꏊQiOzzꏊjFOzztOnm
	case MEMOID_POKETYPE9:
		GET_CHARCTER1( 1 )
		GET_ENCOUNT( 2, mes_status_03_03_05_02 )
		GET_CHARCTER2( 7 )
		GET_PALATE( 8 )
		break;
	
	// ^}SŎ擾FꏊPiOzzꏊjꏊQizꏊjFOzztOnm
	case MEMOID_POKETYPE10:
		GET_CHARCTER1( 1 )
		GET_ENCOUNT( 2, mes_status_03_03_06_01 )
		GET_CHARCTER2( 9 )
		break;
	
	// ̂Ŏ擾FꏊPiOzzꏊjꏊQizꏊjFOzztOnm
	case MEMOID_POKETYPE11:
		GET_CHARCTER1( 1 )
		GET_ENCOUNT( 2, mes_status_03_03_06_02 )
		GET_CHARCTER2( 9 )
		break;
	
	// ^}SŎ擾FꏊPi\tgjꏊQizꏊjFOzztOnm
	case MEMOID_POKETYPE12:
		GET_CHARCTER1( 1 )
		GET_ENCOUNT( 2, mes_status_03_03_07_01 )
		GET_CHARCTER2( 9 )
		break;
	
	// ̂Ŏ擾FꏊPi\tgjꏊQizꏊjFOzztOnm
	case MEMOID_POKETYPE13:
		GET_CHARCTER1( 1 )
		GET_ENCOUNT( 2, mes_status_03_03_07_02 )
		GET_CHARCTER2( 9 )
		break;
	
	// ^}SŎ擾FꏊPiʐMjꏊQizꏊjFOzztOnm
	case MEMOID_POKETYPE14:
		GET_CHARCTER1( 1 )
		GET_ENCOUNT( 2, mes_status_03_03_08_01 )
		GET_CHARCTER2( 9 )
		break;
	
	// ̂Ŏ擾FꏊPiʐMjꏊQizꏊjFOzztOnm
	case MEMOID_POKETYPE15:
		GET_CHARCTER1( 1 )
		GET_ENCOUNT( 2, mes_status_03_03_08_02 )
		GET_CHARCTER2( 9 )
		break;
	
	// ̂Ŏ擾FꏊPiȂjꏊQi|PߋJ[gbWj
	case MEMOID_POKETYPE16:
		GET_CHARCTER1( 1 )
		dat->encount.line = 2;
		encountPark_msgGet( dat, mes_status_03_03_09_01 );
		GET_CHARCTER2( 6 )
		GET_PALATE( 7 )
		break;
	
	// ^}SFevFꏊPiĉjꏊQiȂj
	case MEMOID_TAMAGOTYPE1:
		GET_ENCOUNTEGG( 1, mes_status_03_T_01_01_01, DATA1 )
		GET_EGGSTATUS( 6 )
		break;

	// ^}SFesvFꏊPiȂjꏊQiʐMj
	case MEMOID_TAMAGOTYPE2:
		GET_ENCOUNTEGG( 1, mes_status_03_T_01_02_01, DATA2 )
		GET_EGGSTATUS( 6 )
		break;

	// ^}SFevFꏊPiOzzꏊjꏊQiȂjFOzztOnm
	case MEMOID_TAMAGOTYPE3:
		GET_ENCOUNTEGG( 1, mes_status_03_T_01_03_01, DATA1 )
		GET_EGGSTATUS( 6 )
		break;

	// ^}SFesvFꏊPiȂjꏊQiʐMjFOzztOnm
	case MEMOID_TAMAGOTYPE4:
		GET_ENCOUNTEGG( 1, mes_status_03_T_01_03_01, DATA2 )
		GET_EGGSTATUS( 6 )
		break;

	// ^}SFevFꏊPi\tgjꏊQiȂjFOzztOnm
	case MEMOID_TAMAGOTYPE5:
		GET_ENCOUNTEGG( 1, mes_status_03_T_01_04_01, DATA1 )
		GET_EGGSTATUS( 6 )
		break;
	}
	return dat;
}

//----------------------------------------------------------
/**
 * @brief	g[i[̊J
 * @param	msgtbl	擾Ă郁bZ[We[u|C^
 */
//----------------------------------------------------------
void	TrainerMemoFree( TRMEMO_DATA* dat )
{
	MSGDATA_FREE( dat->character1 )
	MSGDATA_FREE( dat->encount )
	MSGDATA_FREE( dat->character2 )
	MSGDATA_FREE( dat->palate )
	MSGDATA_FREE( dat->eggstatus )

	WORDSET_Delete( dat->word_set );
	//bZ[Wf[^j
	MSGMAN_Delete( dat->msg_man );

	sys_FreeMemoryEz( dat );
}

//----------------------------------------------------------
/**
 * @brief	g[i[̍쐬
 * @param	pp		擾Ώۃ|Pf[^
 * @return	void*	f[^
 */
//----------------------------------------------------------
static void character1_msgGet( TRMEMO_DATA* dat )
{
	int charID = PokeSeikakuGet( dat->pp );		//i擾

	if( charID > CHR_MAX ){
		return;
	}
	//obt@̊m
	dat->character1.msg = STRBUF_Create( MSGLINE_BUFSIZ, dat->heapID );

	//̎擾
	//i̒lmsg_status_03_01i΂j0ƂAbZ[WhcƓꏇɂȂĂ
	MSGMAN_GetString( dat->msg_man, (mes_status_03_02_01 + charID), dat->character1.msg );
}

//----------------------------------------------------------
// ꏊ̃[hݒ
#define WSET_PLACE1( buf ){																\
	WORDSET_RegisterPokeGetPlace														\
		( dat->word_set, buf, PARAM_GET( dat->pp, ID_PARA_trMemo1place ) );				\
}
#define WSET_PLACE2( buf ){																\
	WORDSET_RegisterPokeGetPlace														\
		( dat->word_set, buf, PARAM_GET( dat->pp, ID_PARA_trMemo2place ) );				\
}
// Ñ[hݒ
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/26
// ̕\P\LɕύX
// localize_spec_mark(LANG_KOREA) imatake 2007/09/20
// ؍ł͓{ꓯl̐\L
#if PM_LANG == LANG_KOREA
#define WSET_TIMEDATA1( yearbuf, monthbuf, daybuf ){									\
	WORDSET_RegisterNumber(	dat->word_set, yearbuf,										\
							PARAM_GET( dat->pp, ID_PARA_trMemo1year ),					\
							2, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT );			\
	WORDSET_RegisterNumber(	dat->word_set, monthbuf,									\
							PARAM_GET( dat->pp, ID_PARA_trMemo1month ),					\
							2, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );			\
	WORDSET_RegisterNumber(	dat->word_set, daybuf,										\
							PARAM_GET( dat->pp, ID_PARA_trMemo1day ),					\
							2, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );			\
}
#define WSET_TIMEDATA2( yearbuf, monthbuf, daybuf ){									\
	WORDSET_RegisterNumber(	dat->word_set, yearbuf,										\
							PARAM_GET( dat->pp, ID_PARA_trMemo2year ),					\
							2, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT );			\
	WORDSET_RegisterNumber(	dat->word_set, monthbuf,									\
							PARAM_GET( dat->pp, ID_PARA_trMemo2month ),					\
							2, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );			\
	WORDSET_RegisterNumber(	dat->word_set, daybuf,										\
							PARAM_GET( dat->pp, ID_PARA_trMemo2day ),					\
							2, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );			\
}
#else
#define WSET_TIMEDATA1( yearbuf, monthbuf, daybuf ){									\
	WORDSET_RegisterNumber(	dat->word_set, yearbuf,										\
							PARAM_GET( dat->pp, ID_PARA_trMemo1year ),					\
							2, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT );			\
	WORDSET_RegisterMonthName( 	dat->word_set, monthbuf,								\
								PARAM_GET( dat->pp, ID_PARA_trMemo1month ));			\
	WORDSET_RegisterNumber(	dat->word_set, daybuf,										\
							PARAM_GET( dat->pp, ID_PARA_trMemo1day ),					\
							2, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );			\
}
#define WSET_TIMEDATA2( yearbuf, monthbuf, daybuf ){									\
	WORDSET_RegisterNumber(	dat->word_set, yearbuf,										\
							PARAM_GET( dat->pp, ID_PARA_trMemo2year ),					\
							2, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT );			\
	WORDSET_RegisterMonthName( 	dat->word_set, monthbuf,								\
								PARAM_GET( dat->pp, ID_PARA_trMemo2month ));			\
	WORDSET_RegisterNumber(	dat->word_set, daybuf,										\
							PARAM_GET( dat->pp, ID_PARA_trMemo2day ),					\
							2, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );			\
}
#endif
// ----------------------------------------------------------------------------
// x̃[hݒ
#define WSET_LEVEL( buf ){																\
	WORDSET_RegisterNumber(	dat->word_set, buf,											\
							PARAM_GET( dat->pp, ID_PARA_get_level ),					\
							3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );			\
}

#define ENCOUNT_BUFSIZ		( MSGLINE_BUFSIZ * 8 )	//őWC

static void encount_msgGet( TRMEMO_DATA* dat, int msgID )
{
	STRBUF*	msg_tmp = STRBUF_Create( ENCOUNT_BUFSIZ, dat->heapID );

	dat->encount.msg = STRBUF_Create( ENCOUNT_BUFSIZ, dat->heapID );//obt@̊m

	MSGMAN_GetString( dat->msg_man, msgID, msg_tmp );

	WSET_TIMEDATA2( 0, 1, 2 )
	WSET_LEVEL( 3 )
	WSET_PLACE2( 4 )
	WSET_TIMEDATA1( 5, 6, 7 )
	WSET_PLACE1( 8 )
	WORDSET_ExpandStr( dat->word_set, dat->encount.msg, msg_tmp );

	STRBUF_Delete( msg_tmp );
}

#define ENCOUNTPARK_BUFSIZ		( MSGLINE_BUFSIZ * 4 )	//SC

static void encountPark_msgGet( TRMEMO_DATA* dat, int msgID )
{
	STRBUF*	msg_tmp = STRBUF_Create( ENCOUNTPARK_BUFSIZ, dat->heapID );

	dat->encount.msg = STRBUF_Create( ENCOUNTPARK_BUFSIZ, dat->heapID );//obt@̊m

	MSGMAN_GetString( dat->msg_man, msgID, msg_tmp );

	WSET_TIMEDATA2( 0, 1, 2 )
	WSET_LEVEL( 3 )
	switch( PARAM_GET( dat->pp, ID_PARA_get_cassette ) ){
	default:
		WORDSET_RegisterPokeGetPlace( dat->word_set, 4, PLACEID_HUSEI );
		break;
	case VERSION_RED:
	case VERSION_GREEN:
		WORDSET_RegisterPokeGetPlace( dat->word_set, 4, PLACEID_KANTO );
		break;
	case VERSION_GOLD:
	case VERSION_SILVER:
		WORDSET_RegisterPokeGetPlace( dat->word_set, 4, PLACEID_ZYOTO );
		break;
	case VERSION_RUBY:
	case VERSION_SAPPHIRE:
	case VERSION_EMERALD:
		WORDSET_RegisterPokeGetPlace( dat->word_set, 4, PLACEID_HOUEN );
		break;
	case VERSION_COLOSSEUM:
		WORDSET_RegisterPokeGetPlace( dat->word_set, 4, PLACEID_TOOKUHANARETATOTI );
		break;
	case VERSION_DIAMOND:
	case VERSION_PEARL:
		WORDSET_RegisterPokeGetPlace( dat->word_set, 4, PLACEID_SINOU );
		break;
	}
	WORDSET_ExpandStr( dat->word_set, dat->encount.msg, msg_tmp );

	STRBUF_Delete( msg_tmp );
}

#define ENCOUNTEGG_BUFSIZ		( MSGLINE_BUFSIZ * 5 )	//őTC

static void encountEgg_msgGet( TRMEMO_DATA* dat, int msgID, int flag )
{
	STRBUF*	msg_tmp = STRBUF_Create( ENCOUNTEGG_BUFSIZ, dat->heapID );

	dat->encount.msg = STRBUF_Create( ENCOUNTEGG_BUFSIZ, dat->heapID );//obt@̊m

	MSGMAN_GetString( dat->msg_man, msgID, msg_tmp );

	if( flag == DATA1 ){
		WSET_TIMEDATA1( 5, 6, 7 )
		WSET_PLACE1( 8 )
	} else {
		WSET_TIMEDATA2( 5, 6, 7 )
		WSET_PLACE2( 8 )
	}
	WORDSET_ExpandStr( dat->word_set, dat->encount.msg, msg_tmp );

	STRBUF_Delete( msg_tmp );
}

//----------------------------------------------------------
#define CHR2PARAM0 ( PARAM_GET( dat->pp, ID_PARA_hp_rnd ) )
#define CHR2PARAM1 ( PARAM_GET( dat->pp, ID_PARA_pow_rnd ) )
#define CHR2PARAM2 ( PARAM_GET( dat->pp, ID_PARA_def_rnd ) )
#define CHR2PARAM3 ( PARAM_GET( dat->pp, ID_PARA_agi_rnd ) )
#define CHR2PARAM4 ( PARAM_GET( dat->pp, ID_PARA_spepow_rnd ) )
#define CHR2PARAM5 ( PARAM_GET( dat->pp, ID_PARA_spedef_rnd ) )

#define CHR2PARAM_PRI_ID ( PARAM_GET( dat->pp, ID_PARA_personal_rnd )%6 )

#define C2_TABERU_SUKI		( mes_status_03_05_01_00 )
#define C2_HIRUNE_YOKUSURU	( mes_status_03_05_01_01 )
#define C2_INEMURI_OOI		( mes_status_03_05_01_02 )
#define C2_MONO_TIRAKASU	( mes_status_03_05_01_03 )
#define C2_NONBIRI_SUKI		( mes_status_03_05_01_04 )
#define C2_TIKARA_ZIMAN		( mes_status_03_05_02_00 )
#define C2_ABARE_SUKI		( mes_status_03_05_02_01 )
#define C2_OKORIPPOI		( mes_status_03_05_02_02 )
#define C2_KENKA_SUKI		( mes_status_03_05_02_03 )
#define C2_TINOKE_OOI		( mes_status_03_05_02_04 )
#define C2_KARADA_JYOUBU	( mes_status_03_05_03_00 )
#define C2_UTARE_TUYOI		( mes_status_03_05_03_01 )
#define C2_NEBARI_TUYOI		( mes_status_03_05_03_02 )
#define C2_SINBOU_TUYOI		( mes_status_03_05_03_03 )
#define C2_GAMAN_TUYOI		( mes_status_03_05_03_04 )
#define C2_KAKEKKO_SUKI		( mes_status_03_05_04_00 )
#define C2_MONOOTO_BINKAN	( mes_status_03_05_04_01 )
#define C2_OTTYOKOTYOI		( mes_status_03_05_04_02 )
#define C2_OTYOUSIMONO		( mes_status_03_05_04_03 )
#define C2_NIGERU_HAYAI		( mes_status_03_05_04_04 )
#define C2_KOUKISIN_TUYOI	( mes_status_03_05_05_00 )
#define C2_ITAZURA_SUKI		( mes_status_03_05_05_01 )
#define C2_NUKEME_NAI		( mes_status_03_05_05_02 )
#define C2_KANGAEGOTO_OOI	( mes_status_03_05_05_03 )
#define C2_KITYOUMEN		( mes_status_03_05_05_04 )
#define C2_KI_TUYOI			( mes_status_03_05_06_00 )
#define C2_MIEPPARI			( mes_status_03_05_06_01 )
#define C2_MAKENKI_TUYOI	( mes_status_03_05_06_02 )
#define C2_MAKEZU_KIRAI		( mes_status_03_05_06_03 )
#define C2_GOUJYOU			( mes_status_03_05_06_04 )

// iQe[u
static const u16 charcter2_tbl[6][5] = {
{ C2_TABERU_SUKI,	C2_HIRUNE_YOKUSURU, C2_INEMURI_OOI,		C2_MONO_TIRAKASU,	C2_NONBIRI_SUKI },
{ C2_TIKARA_ZIMAN,	C2_ABARE_SUKI,		C2_OKORIPPOI,		C2_KENKA_SUKI,		C2_TINOKE_OOI },
{ C2_KARADA_JYOUBU, C2_UTARE_TUYOI,		C2_NEBARI_TUYOI,	C2_SINBOU_TUYOI,	C2_GAMAN_TUYOI },
{ C2_KAKEKKO_SUKI,	C2_MONOOTO_BINKAN,	C2_OTTYOKOTYOI,		C2_OTYOUSIMONO,		C2_NIGERU_HAYAI },
{ C2_KOUKISIN_TUYOI,C2_ITAZURA_SUKI,	C2_NUKEME_NAI,		C2_KANGAEGOTO_OOI,	C2_KITYOUMEN },
{ C2_KI_TUYOI,		C2_MIEPPARI,		C2_MAKENKI_TUYOI,	C2_MAKEZU_KIRAI,	C2_GOUJYOU },
};

#define	PARAM_CHECK( num ){			\
	if( param_org < param[num] ){	\
		param_ID = num;				\
		param_org = param[num];		\
	}								\
}

static void character2_msgGet( TRMEMO_DATA* dat ) 
{
	int param[6],param_ID,param_org;
	int	i,msgID;

	//obt@̊m
	dat->character2.msg = STRBUF_Create( MSGLINE_BUFSIZ, dat->heapID );

	param[0] = CHR2PARAM0;
	param[1] = CHR2PARAM1;
	param[2] = CHR2PARAM2;
	param[3] = CHR2PARAM3;
	param[4] = CHR2PARAM4;
	param[5] = CHR2PARAM5;

	//vCIeB[ɂőp[^hc̎擾@x^܂
	switch( CHR2PARAM_PRI_ID ){
	default:
	case 0:
		param_ID = 0;
		param_org = param[0];
		PARAM_CHECK( 1 )
		PARAM_CHECK( 2 )
		PARAM_CHECK( 3 )
		PARAM_CHECK( 4 )
		PARAM_CHECK( 5 )
		break;
	case 1:
		param_ID = 1;
		param_org = param[1];
		PARAM_CHECK( 2 )
		PARAM_CHECK( 3 )
		PARAM_CHECK( 4 )
		PARAM_CHECK( 5 )
		PARAM_CHECK( 0 )
		break;
	case 2:
		param_ID = 2;
		param_org = param[2];
		PARAM_CHECK( 3 )
		PARAM_CHECK( 4 )
		PARAM_CHECK( 5 )
		PARAM_CHECK( 0 )
		PARAM_CHECK( 1 )
		break;
	case 3:
		param_ID = 3;
		param_org = param[3];
		PARAM_CHECK( 4 )
		PARAM_CHECK( 5 )
		PARAM_CHECK( 0 )
		PARAM_CHECK( 1 )
		PARAM_CHECK( 2 )
		break;
	case 4:
		param_ID = 4;
		param_org = param[4];
		PARAM_CHECK( 5 )
		PARAM_CHECK( 0 )
		PARAM_CHECK( 1 )
		PARAM_CHECK( 2 )
		PARAM_CHECK( 3 )
		break;
	case 5:
		param_ID = 5;
		param_org = param[5];
		PARAM_CHECK( 0 )
		PARAM_CHECK( 1 )
		PARAM_CHECK( 2 )
		PARAM_CHECK( 3 )
		PARAM_CHECK( 4 )
		break;
	}
	msgID = charcter2_tbl[ param_ID ][ (param_org % 5)];

	MSGMAN_GetString( dat->msg_man, msgID, dat->character2.msg );
}

//----------------------------------------------------------
#define PLT_KARAI	( mes_status_03_04_01 )
#define PLT_SIBUI	( mes_status_03_04_02 )
#define PLT_AMAI	( mes_status_03_04_03 )
#define PLT_NIGAI	( mes_status_03_04_04 )
#define PLT_SUPPAI	( mes_status_03_04_05 )
#define PLT_ALL		( mes_status_03_04_06 )

#define PLTTYPE_MAX	(5)
#define PLT_LIKE	(1)

// oe[u
static const u16 palate_tbl[6] = 
	{ PLT_ALL, PLT_KARAI, PLT_SIBUI, PLT_AMAI, PLT_NIGAI, PLT_SUPPAI };

static void palate_msgGet( TRMEMO_DATA* dat ) 
{
	int	i,pltID,msgID;

	//obt@̊m
	dat->palate.msg = STRBUF_Create( MSGLINE_BUFSIZ, dat->heapID );

	pltID = 0;

	// oDݎ擾FD(=1)͈킵݂Ȃ
	for(i=0;i<PLTTYPE_MAX;i++){
		if( PokeParaLikeTasteCheck( dat->pp, i ) == PLT_LIKE ){
			pltID = i+1;
		}
	}
	msgID = palate_tbl[ pltID ];

	MSGMAN_GetString( dat->msg_man, msgID, dat->palate.msg );
}

//----------------------------------------------------------
#define EGGSTATUS_LIMIT1	( 5 )
#define EGGSTATUS_LIMIT2	( 10 )
#define EGGSTATUS_LIMIT3	( 40 )

#define EGGSTATUS_BUFSIZ	( MSGLINE_BUFSIZ * 4 )	//őSC

static void eggstatus_msgGet( TRMEMO_DATA* dat ) 
{
	int status = PARAM_GET( dat->pp, ID_PARA_friend );		//Ȃx擾
	int	msgID;

	//obt@̊m
	dat->eggstatus.msg = STRBUF_Create( EGGSTATUS_BUFSIZ, dat->heapID );

	if( status <= EGGSTATUS_LIMIT1 ){
		msgID = mes_status_03_T_02_01;
	} else if( status <= EGGSTATUS_LIMIT2 ){
		msgID = mes_status_03_T_02_02;
	} else if( status <= EGGSTATUS_LIMIT3 ){
		msgID = mes_status_03_T_02_03;
	} else {
		msgID = mes_status_03_T_02_04;
	}

	MSGMAN_GetString( dat->msg_man, msgID, dat->eggstatus.msg );
}


//----------------------------------------------------------
/**
 * @brief	g[i[^Cv̎擾
 * @param	pp		擾Ώۃ|Pf[^
 * @return	memoID	g[i[^CvID
 */
//----------------------------------------------------------
//----------------------------------------------------------
// ^}Sǂ̔
#define if_MONSNO_neq_TAMAGO_pp( pp )	(PARAM_GET( pp, ID_PARA_tamago_flag) == 0)
#define if_MONSNO_neq_TAMAGO_ppp( ppp )	(PARAM_GETP( ppp, ID_PARA_tamago_flag) == 0)

// |P^}SԂŕ߂܂ǂiꏊf[^P0̎̓^}SzĂȂj
#define if_GETSTATUS_neq_TAMAGO	(PARAM_GET(pp, ID_PARA_trMemo1place) == 0)
// OzztOnmǂ
#define if_POKEHAIFU_equ_ON		(PARAM_GET(pp, ID_PARA_event_get_flag) == 1) 
// ꏊP̈vmF
#define if_POKEGET1ID_equ( placeID )	(PARAM_GET(pp, ID_PARA_trMemo1place) == placeID )
// ꏊQ̈vmF
#define if_POKEGET2ID_equ( placeID )	(PARAM_GET(pp, ID_PARA_trMemo2place) == placeID )

static int	TrainerMemoIDGet( POKEMON_PARAM* pp, BOOL mine, int heapID )
{
	int		ret_code	= 0;

	//^}S
	if( if_MONSNO_neq_TAMAGO_pp( pp ) ){
		//|Pp
	
		//|P^}SԂŕ߂܂ǂ
		if( if_GETSTATUS_neq_TAMAGO ){
			//̂Ŏ擾|Piꏊf[^QQƁj
			
			if( if_POKEGET2ID_equ( PLACEID_POKEPARK ) ){
				// ꏊQ|Pp[N̏ꍇ
				ret_code = MEMOID_POKETYPE16;
			} else if( if_POKEHAIFU_equ_ON ){
				// OzztOnm̏ꍇ
				if( mine == TRUE ){// eƂhc̈v
					ret_code = MEMOID_POKETYPE8;
				} else {
					ret_code = MEMOID_POKETYPE9;
				}
			} else if( if_POKEGET2ID_equ( PLACEID_NAIBUTUUSINKOUKAN ) ){
				// ꏊQQ[̏ꍇ
				ret_code = MEMOID_POKETYPE3;
			} else {
				// ̑ʏFߊl
				if( mine == TRUE ){// eƂhc̈v
					ret_code = MEMOID_POKETYPE1;
				} else {
					ret_code = MEMOID_POKETYPE2;
				}
			}
		} else {
			//^}Sz|Piꏊf[^PQƁj
			if( if_POKEHAIFU_equ_ON ){
				// OzztOnm̏ꍇ

				if( if_POKEGET1ID_equ( PLACEID_TUUSINKOUKAN ) ){
					// ꏊPg[h̐ݒ肪Ăꍇ
					if( mine == TRUE ){// eƂhc̈v
						ret_code = MEMOID_POKETYPE14;
					} else {
						ret_code = MEMOID_POKETYPE15;
					}
				} else if( if_POKEGET1ID_equ( PLACEID_RENJA ) ){
					// ꏊPW[̐ݒ肪Ăꍇ
					if( mine == TRUE ){// eƂhc̈v
						ret_code = MEMOID_POKETYPE12;
					} else {
						ret_code = MEMOID_POKETYPE13;
					}
				} else {
					// ꏊP̑̐ݒ肪ĂꍇFCxg
					if( mine == TRUE ){// eƂhc̈v
						ret_code = MEMOID_POKETYPE10;
					} else {
						ret_code = MEMOID_POKETYPE11;
					}
				}
			} else {
				if( if_POKEGET1ID_equ( PLACEID_NAIBUTUUSINKOUKAN )
					||if_POKEGET1ID_equ( PLACEID_SODATEYA )
					||if_POKEGET1ID_equ( PLACEID_TABI )
					||if_POKEGET1ID_equ( PLACEID_GEN ) ){
					// ꏊPQ[̏ꍇ
					if( mine == TRUE ){// eƂhc̈v
						ret_code = MEMOID_POKETYPE6;
					} else {
						ret_code = MEMOID_POKETYPE7;
					}
				} else {
					// ̑FʐM
					if( mine == TRUE ){// eƂhc̈v
						ret_code = MEMOID_POKETYPE4;
					} else {
						ret_code = MEMOID_POKETYPE5;
					}
				}
			}
		}
		
	} else {
		//^}Sp
		
		// eƂhc̈v
		if( mine == TRUE ){// eƂhc̈v
			// ̃^}Siꏊf[^PQƁj
			if( if_POKEHAIFU_equ_ON ){
				// OzztOnm̏ꍇ
				if( if_POKEGET1ID_equ( PLACEID_RENJA ) ){
					//W[̏ꍇ
					ret_code = MEMOID_TAMAGOTYPE5;
				} else {
					ret_code = MEMOID_TAMAGOTYPE3;
				}
			} else {
				//ʏ^}S
				ret_code = MEMOID_TAMAGOTYPE1;
			}
		} else {
			// iꏊf[^QQƁj
			if( if_POKEHAIFU_equ_ON ){
				//Ozz^}S
				ret_code = MEMOID_TAMAGOTYPE4;
			} else {
				//ʏ^}S
				ret_code = MEMOID_TAMAGOTYPE2;
			}
		}
	}
	return ret_code;
}





//----------------------------------------------------------
/**
 * @brief	g[i[̐ݒ
 * @param	pp or ppp	ݒΏۃ|Pf[^
 * @param	setID		ݒhc
 * @param	placeID		ݒnhciߊl̂݁Hj
 */
//----------------------------------------------------------
static void TrainerMemoOyaSet( POKEMON_PASO_PARAM* ppp, MYSTATUS* my, int heapID );
static void TrainerMemoPlaceDaySet( POKEMON_PASO_PARAM* ppp, int placeID, int datanum );
static void TrainerMemoPlaceDayClr( POKEMON_PASO_PARAM* ppp, int datanum );
static void TrainerMemoLvlSet( POKEMON_PASO_PARAM* ppp );
static void TrainerMemoEvfSet( POKEMON_PASO_PARAM* ppp );

void	TrainerMemoSetPP(	POKEMON_PARAM* pp, MYSTATUS* my, 
							TRMEMO_SETID setID, int placeID, int heapID )
{
	TrainerMemoSetPPP( &pp->ppp, my, setID, placeID, heapID );
}


void	TrainerMemoSetPPP(	POKEMON_PASO_PARAM* ppp, MYSTATUS* my, 
							TRMEMO_SETID setID, int placeID, int heapID )
{
	switch( setID ){

	//ʏ擾iߊlj
	case TRMEMO_POKE_PLACESET:
		if( placeID > PLACEID_MAX ){
			placeID = 0;
		}
		if( if_MONSNO_neq_TAMAGO_ppp( ppp ) ){
			//|P
			TrainerMemoPlaceDayClr( ppp, DATA1 );
			TrainerMemoPlaceDaySet( ppp, placeID, DATA2 );
			TrainerMemoLvlSet( ppp );
		} else {
			//^}S
			TrainerMemoPlaceDaySet( ppp, placeID, DATA1 );
			TrainerMemoPlaceDayClr( ppp, DATA2 );
		}
		TrainerMemoOyaSet( ppp, my, heapID );
		break;

	//Q[
	case TRMEMO_OFFTRADE_PLACESET:
		if( if_MONSNO_neq_TAMAGO_ppp( ppp ) ){
			//|P
			TrainerMemoPlaceDayClr( ppp, DATA1 );
			TrainerMemoPlaceDaySet( ppp, PLACEID_NAIBUTUUSINKOUKAN, DATA2 );
			TrainerMemoLvlSet( ppp );
		} else {
			//^}S
			TrainerMemoPlaceDayClr( ppp, DATA1 );
			TrainerMemoPlaceDaySet( ppp, PLACEID_NAIBUTUUSINKOUKAN, DATA2 );
		}
		break;

	//|Pp[N
	case TRMEMO_POKEPARK_PLACESET:
		//|P
		TrainerMemoPlaceDayClr( ppp, DATA1 );
		TrainerMemoPlaceDaySet( ppp, PLACEID_POKEPARK, DATA2 );
		TrainerMemoLvlSet( ppp );
		break;

	//ĉi^}Ŝ݁j
	case TRMEMO_SODATEYA_PLACESET:
		TrainerMemoPlaceDaySet( ppp, placeID, DATA1 );
		TrainerMemoPlaceDayClr( ppp, DATA2 );
		TrainerMemoOyaSet( ppp, my, heapID );
		break;

	//Ozz
	case TRMEMO_FUSHIGI_PLACESET:
		//e̖OAhcAʂ̓ZbgĂ邱ƂO
		if( PokemonOyaCheckPPP( ppp, my, heapID ) == TRUE ){
			if( if_MONSNO_neq_TAMAGO_ppp( ppp ) ){
				//|P
				TrainerMemoPlaceDayClr( ppp, DATA1 );
				TrainerMemoPlaceDaySet( ppp, placeID, DATA2 );
				TrainerMemoLvlSet( ppp );
			} else {
				//^}S
				TrainerMemoPlaceDaySet( ppp, placeID, DATA1 );
				TrainerMemoPlaceDayClr( ppp, DATA2 );
			}
		} else {
			if( if_MONSNO_neq_TAMAGO_ppp( ppp ) ){
				//|P
				TrainerMemoPlaceDayClr( ppp, DATA1 );
				TrainerMemoPlaceDaySet( ppp, placeID, DATA2 );
				TrainerMemoLvlSet( ppp );
			} else {
				//^}S
				TrainerMemoPlaceDayClr( ppp, DATA1 );
				TrainerMemoPlaceDaySet( ppp, placeID, DATA2 );
			}
		}
		TrainerMemoEvfSet( ppp );
		break;

	//ʐM
	case TRMEMO_ONTRADE_PLACESET:
		if( if_MONSNO_neq_TAMAGO_ppp( ppp ) ){
			//|PiȂj
		} else {
			//^}S
			TrainerMemoPlaceDaySet( ppp, PLACEID_TUUSINKOUKAN, DATA2 );
		}
		break;

	//^}Sz
	case TRMEMO_EGGBIRTH_PLACESET:
		if( placeID > PLACEID_MAX ){
			placeID = 0;
		}
		if( PokemonOyaCheckPPP( ppp, my, heapID ) == FALSE ){
			{
				//^}S
				int data;

				data = PARAM_GETP( ppp, ID_PARA_trMemo2place );
				PARAM_PUTP( ppp, ID_PARA_trMemo1place, &data );
				data = PARAM_GETP( ppp, ID_PARA_trMemo2year );
				PARAM_PUTP( ppp, ID_PARA_trMemo1year, &data );
				data = PARAM_GETP( ppp, ID_PARA_trMemo2month );
				PARAM_PUTP( ppp, ID_PARA_trMemo1month, &data );
				data = PARAM_GETP( ppp, ID_PARA_trMemo2day );
				PARAM_PUTP( ppp, ID_PARA_trMemo1day, &data );
			}
		}
		TrainerMemoPlaceDaySet( ppp, placeID, DATA2 );
		TrainerMemoOyaSet( ppp, my, heapID );
		break;
	}
}

//----------------------------------------------------------
// e̐ݒ
static void TrainerMemoOyaSet( POKEMON_PASO_PARAM* ppp, MYSTATUS* my, int heapID )
{
	int	myID	= MyStatus_GetID( my );
	int	mysex	= MyStatus_GetMySex( my );
	STRBUF*	myname	= MyStatus_CreateNameString( my, heapID );

	PARAM_PUTP( ppp, ID_PARA_id_no, &myID );
	PARAM_PUTP( ppp, ID_PARA_oyasex, &mysex );
	PARAM_PUTP( ppp, ID_PARA_oyaname_buf, myname );

	STRBUF_Delete( myname );
}

//----------------------------------------------------------
// ꏊƓt̐ݒ
static void TrainerMemoPlaceDaySet( POKEMON_PASO_PARAM* ppp, int placeID, int datanum )
{
	RTCDate	rtc_d;

	GF_RTC_GetDate(&rtc_d);

	//ߊlZbg
	if( datanum == DATA1 ){
		PARAM_PUTP( ppp, ID_PARA_trMemo1place,	&placeID );
		PARAM_PUTP( ppp, ID_PARA_trMemo1year,	&rtc_d.year );
		PARAM_PUTP( ppp, ID_PARA_trMemo1month,	&rtc_d.month );
		PARAM_PUTP( ppp, ID_PARA_trMemo1day,	&rtc_d.day ); 
	} else {
		PARAM_PUTP( ppp, ID_PARA_trMemo2place,	&placeID );
		PARAM_PUTP( ppp, ID_PARA_trMemo2year,	&rtc_d.year );
		PARAM_PUTP( ppp, ID_PARA_trMemo2month,	&rtc_d.month );
		PARAM_PUTP( ppp, ID_PARA_trMemo2day,	&rtc_d.day ); 
	}
}

//----------------------------------------------------------
// ꏊt̃NA
static void TrainerMemoPlaceDayClr( POKEMON_PASO_PARAM* ppp, int datanum )
{
	int data = 0;

	if( datanum == DATA1 ){
		PARAM_PUTP( ppp, ID_PARA_trMemo1place,	&data );
		PARAM_PUTP( ppp, ID_PARA_trMemo1year,	&data );
		PARAM_PUTP( ppp, ID_PARA_trMemo1month,	&data );
		PARAM_PUTP( ppp, ID_PARA_trMemo1day,	&data ); 
	} else {
		PARAM_PUTP( ppp, ID_PARA_trMemo2place,	&data );
		PARAM_PUTP( ppp, ID_PARA_trMemo2year,	&data );
		PARAM_PUTP( ppp, ID_PARA_trMemo2month,	&data );
		PARAM_PUTP( ppp, ID_PARA_trMemo2day,	&data ); 
	}
}
//----------------------------------------------------------
// x̐ݒ
static void TrainerMemoLvlSet( POKEMON_PASO_PARAM* ppp )
{
	int level = PARAM_GETP( ppp, ID_PARA_level );

	PARAM_PUTP( ppp, ID_PARA_get_level, &level );
}
//----------------------------------------------------------
// OzztO̐ݒ
static void TrainerMemoEvfSet( POKEMON_PASO_PARAM* ppp )
{
	int event_get_flag = 1;

	PARAM_PUTP( ppp, ID_PARA_event_get_flag, &event_get_flag );
}

