//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		pokefoot.c
 *	@brief		|PՃOtBbNf[^擾֐
 *	@author		tomoya takahashi
 *	@data		2006.01.31
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include "include/system/arc_util.h"
#include "include/system/arc_tool.dat"
#include "include/poketool/monsno.h"

#define	__POKEFOOT_H_GLOBAL
#include "include/poketool/pokefoot.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define POKEFOOT_ARC_PLTT		( 0 )		// pbgCfbNX
#define POKEFOOT_ARC_CELL		( 2 )		// ZCfbNX
#define POKEFOOT_ARC_CELLANM	( 1 )		// ZAjCfbNX
#define POKEFOOT_ARC_CHAR_DMMY	( 3 )		// poke_foot_000
#define POKEFOOT_ARC_CHAR_START	( 4	)		// LN^JnCfbNX

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	X^[io[瑫ՃLN^f[^擾
 *
 *	@param	mons_no		X^[io[
 *	@param	heap		q[v
 *	@param	alloc_type	AbN^Cv
 *
 *	@return	t@Cf[^
 */
//-----------------------------------------------------------------------------
void* PokeFootCharPtrGet( int mons_no, int heap, ALLOC_TYPE alloc_type )
{	
	void* p_buff;
	
	GF_ASSERT( mons_no <= MONSNO_END );

	p_buff = ArcUtil_Load( ARC_POKEFOOT_GRA, POKEFOOT_ARC_CHAR_DMMY + mons_no, TRUE, heap, alloc_type );

	// 擾s
	GF_ASSERT( p_buff );

	return p_buff;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Ճpbgf[^擾
 *
 *	@param	heap	q[v
 *	@param	alloc_type	AbN^Cv
 *
 *	@return	t@Cf[^
 */
//-----------------------------------------------------------------------------
void* PokeFootPlttPtrGet( int heap, ALLOC_TYPE alloc_type )
{
	void* p_buff;
	
	p_buff = ArcUtil_Load( ARC_POKEFOOT_GRA, POKEFOOT_ARC_PLTT, FALSE, heap, alloc_type );

	// 擾s
	GF_ASSERT( p_buff );

	return p_buff;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ՃZf[^擾
 *
 *	@param	heap	q[v
 *	@param	alloc_type	AbN^Cv
 *
 *	@return	t@Cf[^
 */
//-----------------------------------------------------------------------------
void* PokeFootCellPtrGet( int heap, ALLOC_TYPE alloc_type )
{
	void* p_buff;
	
	p_buff = ArcUtil_Load( ARC_POKEFOOT_GRA, POKEFOOT_ARC_CELL, TRUE, heap, alloc_type );

	// 擾s
	GF_ASSERT( p_buff );

	return p_buff;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ՃZAjf[^擾
 *
 *	@param	heap	q[v
 *	@param	alloc_type	AbN^Cv
 *
 *	@return	t@Cf[^
 */
//-----------------------------------------------------------------------------
void* PokeFootCellAnmPtrGet( int heap, ALLOC_TYPE alloc_type )
{
	void* p_buff;
	
	p_buff = ArcUtil_Load( ARC_POKEFOOT_GRA, POKEFOOT_ARC_CELLANM, TRUE, heap, alloc_type );

	// 擾s
	GF_ASSERT( p_buff );

	return p_buff;
}



// A[JCut@CIDX@f[^IDX
//----------------------------------------------------------------------------
/**
 *	@brief	A[JCut@CIDX擾
 *
 *	@param	none	
 *
 *	@return	A[JCut@CIDX
 */
//-----------------------------------------------------------------------------
int PokeFootArcFileGet( void )
{
	return ARC_POKEFOOT_GRA;
}

//----------------------------------------------------------------------------
/**
 *	@brief	LN^f[^IDX擾
 *
 *	@param	mons_no		X^[io[
 *
 *	@return	LN^f[^IDX
 */
//-----------------------------------------------------------------------------
int PokeFootCharDataIdxGet( int mons_no )
{
	return POKEFOOT_ARC_CHAR_DMMY + mons_no;
}
//----------------------------------------------------------------------------
/**
 *	@brief	pbgf[^IDX擾
 *
 *	@param	none
 *
 *	@return	pbgf[^IDX
 */
//-----------------------------------------------------------------------------
int PokeFootPlttDataIdxGet( void )
{
	return POKEFOOT_ARC_PLTT;
}
//----------------------------------------------------------------------------
/**
 *	@brief	Zf[^IDX擾
 *
 *	@param	none
 *
 *	@return	Zf[^IDX
 */
//-----------------------------------------------------------------------------
int PokeFootCellDataIdxGet( void )
{
	return POKEFOOT_ARC_CELL;
}
//----------------------------------------------------------------------------
/**
 *	@brief	ZAjf[^IDX擾
 *
 *	@param	none
 *
 *	@return	ZAjf[^IDX
 */
//-----------------------------------------------------------------------------
int PokeFootCellAnmDataIdxGet( void )
{
	return POKEFOOT_ARC_CELLANM;
}

