//============================================================================================
/**
 * @file	pokeparty.c
 * @brief	|Pp[eB
 * @author	tamada	GAME FREAK Inc.
 * @date	2005.10.13
 */
//============================================================================================


#include	"common.h"
#include	"poketool/poke_tool.h"
#include	"poke_tool_def.h"
#include	"system/gamedata.h"

#include	"poketool/pokeparty.h"

//莝|Pf[^擾̂
#include	"system/savedata.h"

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	|Pp[eB[\̂̒`
 *
 * ő6̂܂ł̃|P܂Ƃ߂ĕێł悤ɂȂĂB
 */
//----------------------------------------------------------
struct _POKEPARTY {
	///	ێł|P̍ő
	int PokeCountMax;
	///	ݕێĂ|P
	int PokeCount;
	///	|Pf[^
	struct pokemon_param member[TEMOTI_POKEMAX];
};

//----------------------------------------------------------
/**
 * @brief	wʒuǂ̔
 * @param	party	POKEPARTY\̂ւ̃|C^
 * @param	pos		|P̈ʒuiOIWj
 */
//----------------------------------------------------------
#define	PARTY_POS_ASSERT(party, pos)	{\
	GF_ASSERT((pos) >= 0);				\
	GF_ASSERT_MSG((pos) < (party)->PokeCount, "pos(%d) >= PokeCount(%d)\n",pos, (party)->PokeCount); \
	GF_ASSERT((pos) < (party)->PokeCountMax) \
}

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	POKEPARTY\̂̃TCY擾
 * @return	int	POKEPARTY\̂̑傫
 */
//----------------------------------------------------------
int PokeParty_GetWorkSize(void)
{
	return sizeof(POKEPARTY);
}

//----------------------------------------------------------
/**
 * @brief	POKEPARTY\̂̃[Nm
 * @param	heapID		mۂq[vւ̃|C^
 * @return	POKEPARTYւ̃|C^
 */
//----------------------------------------------------------
POKEPARTY * PokeParty_AllocPartyWork(u32 heapID)
{
	POKEPARTY * party;

	party = sys_AllocMemory(heapID, sizeof(POKEPARTY));
	PokeParty_InitWork(party);

	return party;
}

//----------------------------------------------------------
/**
 * @brief	POKEPARTY̏
 * @param	party	POKEPARTY\̂ւ̃|C^
 */
//----------------------------------------------------------
void PokeParty_InitWork(POKEPARTY * party)
{
	PokeParty_Init(party, TEMOTI_POKEMAX);
}

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	POKEPARTY̏
 * @param	party	POKEPARTY\̂ւ̃|C^
 * @param	max		POKEPARTYێłő̃|P
 */
//----------------------------------------------------------
void PokeParty_Init(POKEPARTY * party, int max)
{
	int i;
	GF_ASSERT(max <= TEMOTI_POKEMAX);
	memset(party, 0, sizeof(POKEPARTY));
	party->PokeCount = 0;
	party->PokeCountMax = max;
	for (i = 0; i < TEMOTI_POKEMAX; i++) {
		PokeParaInit(&party->member[i]);
	}
}

//----------------------------------------------------------
/**
 * @brief	POKEPARTYɃ|P
 * @param	party	POKEPARTY\̂ւ̃|C^
 * @param	poke	|Pւ̃f[^
 * @retval	TRUE	
 * @retval	FALSE	s
 */
//----------------------------------------------------------
BOOL PokeParty_Add(POKEPARTY * party, POKEMON_PARAM * poke)
{
	if (party->PokeCount >= party->PokeCountMax) {
		//莝ς
		return FALSE;
	}
	party->member[party->PokeCount] = *poke;
	party->PokeCount ++;

	return TRUE;
}

//----------------------------------------------------------
/**
 * @brief	POKEPARTY|P菜
 * @param	party	POKEPARTY\̂ւ̃|C^
 * @param	pos		菜|P̈ʒuiOIWj
 * @retval	TRUE	
 * @retval	FALSE	s
 */
//----------------------------------------------------------
BOOL PokeParty_Delete(POKEPARTY * party, int pos)
{
	int i;
	PARTY_POS_ASSERT(party, pos);
	GF_ASSERT( party->PokeCount > 0 );

	for (i = pos ;i < party->PokeCount - 1; i ++) {
		party->member[i] = party->member[i + 1];
	}
	PokeParaInit(&party->member[i]);
	party->PokeCount--;

	return TRUE;
}

//----------------------------------------------------------
/**
 * @brief	POKEPARTY莝擾
 * @param	party	POKEPARTY\̂ւ̃|C^
 * @retval	莝
 */
//----------------------------------------------------------
int	PokeParty_GetPokeCount(const POKEPARTY * party)
{
	return party->PokeCount;
}

//----------------------------------------------------------
/**
 * @brief	POKEPARTY|Pւ̃|C^擾
 * @param	party	POKEPARTY\̂ւ̃|C^
 * @param	pos		QƂ|P̈ʒuiOIWj
 * @retval	POKEMON_PARAM	w肵|Pւ̃|C^
 */
//----------------------------------------------------------
POKEMON_PARAM * PokeParty_GetMemberPointer(const POKEPARTY * party, int pos)
{
	PARTY_POS_ASSERT(party, pos);
	return (POKEMON_PARAM*)&party->member[pos];
}

//----------------------------------------------------------
/**
 * @brief	POKEPARTYփ|Pf[^Zbg
 * @param	party	POKEPARTY\̂ւ̃|C^
 * @param	pos		Zbg|P̈ʒuiOIWj
 * @param	pp		Zbg|Pf[^
 *
 * {bNXEĂ|PƁuւvɕ֗Ȃ̂ō쐬B
 * ʏAo[̒ǉɂ PokeParty_Add gĂB  taya
 *
 */
//----------------------------------------------------------
void PokeParty_SetMemberData( POKEPARTY* party, int pos, POKEMON_PARAM* pp )
{
	int cnt;

	PARTY_POS_ASSERT(party, pos);

	cnt = PokeParaGet(&(party->member[pos]), ID_PARA_poke_exist, NULL) - PokeParaGet(pp, ID_PARA_poke_exist, NULL);
	party->member[pos] = *pp;
	party->PokeCount += cnt;
}

//----------------------------------------------------------
/**
 * @brief	POKEPARTYŃ|P̈ʒuւ
 * @param	party	POKEPARTY\̂ւ̃|C^
 * @param	pos1	|P̈ʒuiOIWj
 * @param	pos2	|P̈ʒuiOIWj
 * @retval	TRUE	
 * @retval	FALSE	s
 */
//----------------------------------------------------------
BOOL PokeParty_ExchangePosition(POKEPARTY * party, int pos1, int pos2)
{
	struct pokemon_param * temp;

	PARTY_POS_ASSERT(party, pos1);
	PARTY_POS_ASSERT(party, pos2);

	temp = sys_AllocMemory(HEAPID_BASE_SYSTEM, sizeof(struct pokemon_param));
	*temp = party->member[pos1];
	party->member[pos1] = party->member[pos2];
	party->member[pos2] = *temp;
	sys_FreeMemoryEz(temp);

	return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	POKEPARTỸRs[
 * @param	src		POKEPARTY\̂ւ̃|C^
 * @param	dst		POKEPARTY\̂ւ̃|C^
 */
//----------------------------------------------------------
void PokeParty_Copy(const POKEPARTY * src, POKEPARTY * dst)
{
	*dst = *src;
}

//----------------------------------------------------------
/**
 * @brief	POKEPARTYɃX^[邩ǂH
 * @param	ppt		`FbNPOKEPARTY\̂ւ̃|C^
 * @param	mons_no	邩`FbN郂X^[io[
 * @return	FALSE:Ȃ@TRUE:
 */
//----------------------------------------------------------
BOOL PokeParty_PokemonCheck(const POKEPARTY * ppt, int mons_no)
{
	int				i;

	for(i=0;i<ppt->PokeCount;i++){
		if(PokeParaGet((POKEMON_PARAM*)&ppt->member[i],ID_PARA_monsno,NULL)==mons_no){
			break;
		}
	}

	return (i!=ppt->PokeCount);
}

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	莝|Pf[^̎擾
 * @param	sv	Z[uf[^ւ̃|C^
 * @return	POKEPARTY	莝|Pf[^ւ̃|C^
 */
//----------------------------------------------------------
POKEPARTY * SaveData_GetTemotiPokemon(SAVEDATA * sv)
{
	POKEPARTY * party;
	party = (POKEPARTY *)SaveData_Get(sv, GMDATA_ID_TEMOTI_POKE);
	return party;
}

//----------------------------------------------------------
/**
 * @brief	fobOF_~[p[eB̐
 * @param	party	POKEPARTY\̂ւ̃|C^
 */
//----------------------------------------------------------
void Debug_PokeParty_MakeParty(POKEPARTY * party)
{
	struct pokemon_param poke;
	int i;
	PokeParty_Init(party, TEMOTI_POKEMAX);
	for (i = 0; i < 3; i++) {
		PokeParaInit(&poke);
		PokeParaSet(&poke, 392 + i, 99, POW_RND, RND_NO_SET, 0, ID_NO_SET, 0);
		PokeParty_Add(party, &poke);
	}
}

// OQƃCfbNX鎞̂ݗL(Q[͖)
#ifdef CREATE_INDEX
void *Index_Get_PokeCount_Offset(POKEPARTY *pt){ return &pt->PokeCount; }
#endif
