
//============================================================================================
/**
 * @file	waza_tool.c
 * @bfief	Zp[^c[S
 * @author	HisashiSogabe
 * @date	05.07.28
 */
//============================================================================================

#include	"common.h"

#include	"battle/battle_common.h"
#include	"battle/battle_server.h"
#include	"battle/fight_tool.h"
#include	"battle/server.h"
#include	"battle/server_tool.h"
#include	"battle/tokusyu_def.h"
#include	"battle/wazano_def.h"
#include	"poketool/monsno.h"
#include	"poketool/poke_tool.h"
#include	"poketool/waza_tool.h"
#include	"system/arc_tool.h"

#include	"itemtool/item.h"
#include	"itemtool/itemequip.h"
#include	"itemtool/itemsym.h"

#include	"waza_tool_def.h"

//============================================================================================
/**
 * 萔錾
 */
//============================================================================================

typedef struct{
	u16	monsno;
	s16 hp;

	u16	hpmax;
	u8	eqp;
	u8	atc;

	u32 condition;

	u8	speabino;
	u8	sex;
	u8	type1;
	u8	type2;
}WAZA_DAMAGE_CALC_PARAM;

//============================================================================================
/**
 * vg^Cv錾
 */
//============================================================================================
void		WT_WazaTableDataGet(void *buffer);
ARCHANDLE	*WT_WazaDataParaHandleOpen(u32 heapID);
void		WT_WazaDataParaHandleClose(ARCHANDLE *handle);
u32			WT_WazaDataParaGet(int waza_no,int id);
u32			WT_WazaDataParaGetHandle(ARCHANDLE *handle,int waza_no,int id);
u8			WT_PPMaxGet(u16 wazano,u8 maxupcnt);
u32			WT_WazaDataParaGetAct(WAZA_TABLE_DATA *wtd,int id);

static	void	WT_WazaDataGet(int waza_no,WAZA_TABLE_DATA *wtd);

//============================================================================================
/**
 *	Zf[^e[uf[^AllocɓWJ
 *
 * @param[in]	heapID	f[^WJ郁q[vID
 */
//============================================================================================
void	WT_WazaTableDataGet(void *buffer)
{
	ArchiveDataLoadOfs(buffer,ARC_WAZA_TBL,0,0,sizeof(WAZA_TABLE_DATA)*(WAZANO_MAX+1));
}

//============================================================================================
/**
 *	Zf[^e[ut@CnhI[v
 *
 * @param[in]	heapID	nhAllocq[vID
 */
//============================================================================================
ARCHANDLE	*WT_WazaDataParaHandleOpen(u32 heapID)
{
	return	ArchiveDataHandleOpen(ARC_WAZA_TBL,heapID);
}

//============================================================================================
/**
 *	Zf[^e[ut@CnhN[Y
 *
 * @param[in]	handle	N[YHandle
 */
//============================================================================================
void	WT_WazaDataParaHandleClose(ARCHANDLE *handle)
{
	ArchiveDataHandleClose(handle);
}

//============================================================================================
/**
 *	Zf[^e[ul擾
 *
 * @param[in]	waza_no		擾Zio[
 * @param[in]	id			擾l̎
 */
//============================================================================================
u32	WT_WazaDataParaGet(int waza_no,int id)
{
	WAZA_TABLE_DATA wtd;

	WT_WazaDataGet(waza_no,&wtd);

	return	WT_WazaDataParaGetAct(&wtd,id);
}

//============================================================================================
/**
 *	Zf[^e[ul擾it@Cnhgpj
 *
 * @param[in]	waza_no		擾Zio[
 * @param[in]	id			擾l̎
 */
//============================================================================================
u32	WT_WazaDataParaGetHandle(ARCHANDLE *handle,int waza_no,int id)
{
	WAZA_TABLE_DATA wtd;

	ArchiveDataLoadByHandle(handle,waza_no,&wtd);

	return	WT_WazaDataParaGetAct(&wtd,id);
}

//============================================================================================
/**
 *	PPMax擾
 *
 * @param[in]	wazano		擾Zio[
 * @param[in]	maxupcnt	}bNXAbvgp
 *
 * @retval	PPMAX
 */
//============================================================================================
u8	WT_PPMaxGet(u16 wazano,u8 maxupcnt)
{
	u8	ppmax;

	if(maxupcnt>3){
		maxupcnt=3;
	}

	ppmax=WT_WazaDataParaGet(wazano,ID_WTD_pp);
	ppmax+=(ppmax*20*maxupcnt)/100;

	return	ppmax;
}

//============================================================================================
/**
 *	Ze[u\̃f[^l擾
 *
 * @param[in]	wtd		Ze[u\̃f[^ւ̃|C^
 * @param[in]	id		擾Zf[^Index
 */
//============================================================================================
u32	WT_WazaDataParaGetAct(WAZA_TABLE_DATA *wtd,int id)
{
	u32	ret;

	switch(id){
	case ID_WTD_battleeffect:
		ret=wtd->battleeffect;
		break;
	case ID_WTD_kind:
		ret=wtd->kind;
		break;
	case ID_WTD_damage:
		ret=wtd->damage;
		break;
	case ID_WTD_wazatype:
		ret=wtd->wazatype;
		break;
	case ID_WTD_hitprobability:
		ret=wtd->hitprobability;
		break;
	case ID_WTD_pp:
		ret=wtd->pp;
		break;
	case ID_WTD_addeffect:
		ret=wtd->addeffect;
		break;
	case ID_WTD_attackrange:
		ret=wtd->attackrange;
		break;
	case ID_WTD_attackpri:
		ret=wtd->attackpri;
		break;
	case ID_WTD_flag:
		ret=wtd->flag;
		break;
	case ID_WTD_ap_no:				//ReXgpp[^@As[No
		ret=wtd->condata.ap_no;
		break;
	case ID_WTD_contype:			//ReXgpp[^@ReXgZ^Cv
		ret=wtd->condata.contype;
		break;
	}
	return ret;
}

//============================================================================================
/**
 *							OJȂ֐S
 */
//============================================================================================
//============================================================================================
/**
 *	Ze[u\̃f[^擾
 *
 * @param[in]	waza_no		擾Zio[
 * @param[out]	wtd			擾Zf[^̊i[w
 */
//============================================================================================
static	void	WT_WazaDataGet(int waza_no,WAZA_TABLE_DATA *wtd)
{
	ArchiveDataLoad(wtd,ARC_WAZA_TBL,waza_no);
}

