#include "Bitmap2Color.hpp"

#include <iostream>
using namespace std;

Bitmap2Color::Bitmap2Color() {
	_width  = 0;
	_height = 0;

	_data = NULL;
}

Bitmap2Color::Bitmap2Color(int width, int height) {
	_data = NULL;
	setSize(width, height);
}

Bitmap2Color::~Bitmap2Color() {
	if (_data) delete[] _data;
}

void Bitmap2Color::setSize(int width, int height) {
	if (_data) delete[] _data;

	_width  = width;
	_height = height;

	int size = getSize();
	_data = new unsigned char[size];

	for (int i = 0; i < size; ++i) _data[i] = 0;
}

bool Bitmap2Color::equals(Bitmap2Color *opr) {
	if (_width  != opr->_width)  return false;
	if (_height != opr->_height) return false;

	int size = getSize();
	for (int i = 0; i < size; ++i) {
		if (_data[i] != opr->_data[i]) return false;
	}

	return true;
}

int Bitmap2Color::getSize() {
	return (_width * _height + 7) / 8;			// 1 bit/pixel
}

void Bitmap2Color::setPixel(int x, int y, int color) {
	int bitno = x + y * _width;

	int index = bitno / 8;
	int shift = bitno % 8;

	if (color & 1) {
		_data[index] |=   1 << shift;
	} else {
		_data[index] &= ~(1 << shift);
	}
}

int Bitmap2Color::getPixel(int x, int y) {
	int bitno = x + y * _width;

	int index = bitno / 8;
	int shift = bitno % 8;

	return (_data[index] >> shift) & 1;
}

void Bitmap2Color::print() {
	cout << "(" << _width << ", " << _height << ")" << endl;
	for (int y = 0; y < _height; ++y) {
		for (int x = 0; x < _width; ++x) {
			cout << getPixel(x, y);
		}
		cout << endl;
	}
}
