#ifndef __DIVIDEDHANGUL_HPP__
#define __DIVIDEDHANGUL_HPP__

#include <vector>
using namespace std;

class FontBitmap;
class Bitmap2Color;

typedef struct {
	int x;
	int y;
	int width;
	int height;
	int indexNum;
	int bitDataNum;
	int *indexTable;
	Bitmap2Color **bitDataTable;
} FontPartsSet;

class DividedHangul {
private:
	static const int BITMAPFILEHEADEREX_PADDINGSIZE = 2;
	static const int BITMAPINFOHEADER_SIZE = 40;

	static const int BITMAP_BOXWIDTH  = 16;
	static const int BITMAP_BOXHEIGHT = 16;
	static const int BITMAP_CHARACTERNUMLINE = 16;

	static const int BITMAP_WIDTH        = BITMAP_BOXWIDTH * BITMAP_CHARACTERNUMLINE;
	static const int BITMAP_PLANES       = 1;
	static const int BITMAP_BITCOUNT     = 8;
	static const int BITMAP_COMPRESSION  = 0;		// No compression
	static const int BITMAP_XPIXPERMETER = 3780;
	static const int BITMAP_YPIXPERMETER = 3780;
	static const int BITMAP_CLRUSED      = 1 << BITMAP_BITCOUNT;
	static const int BITMAP_CLRIMPORTANT = 0;

	static const int BITMAP_COLORSIZE    = 4;
	static const int BITMAP_PALETTESIZE  = BITMAP_COLORSIZE * BITMAP_CLRUSED;

	vector<FontPartsSet *> _partsSetVector;

	int _getPartsSetSize(FontPartsSet *partsSet);
	int _saveBitmap(FontPartsSet *partsSet, const char *filename);

public:
	DividedHangul();
	~DividedHangul();

	void addParts(FontBitmap *fontBitmap, int x, int y, int width, int height, int yofs);
	int printCompressRate(void);
	int saveFile(const char *filename);
};

#endif
