#ifndef __FONTBITMAP_HPP__
#define __FONTBITMAP_HPP__

class Bitmap2Color;

class FontBitmap {
private:
	static const int BITMAPFILEHEADEREX_PADDINGSIZE = 2;
	static const int BITMAPINFOHEADER_SIZE = 40;

	int _entryNum;

	int _pixelDataSize;
	unsigned char *_pixelData;

	int _bitmapWidth;	// rbg}bv摜x̕
	int _bitmapHeight;	// rbg}bv摜y̕
	int _lineSize;		// f[^\x̕ibitmapWidth4̔{Ɋۂ߂́j

	int _blockWidth;	// ubNx̕
	int _blockHeight;	// ubNy̕
	int _cellWidth;		// Zx̕
	int _cellHeight;	// Zy̕

	int _colorGrid;
	int _colorMargin;
	int _colorFont;
	int _colorBackground;

	int _charTop;
	int _charBottom;
	int _charHeight;

	int _blockNumLine;	// xɕłubN̐

	void _searchColors();
	int _countBlockWidth();
	int _countBlockHeight();

	int _getPixelIndex(int x, int y);
	int _getPixel(int x, int y);

	int _getCharTop();
	int _getCharBottom();

public:
	FontBitmap();
	~FontBitmap();

	int loadFile(const char *filename);

	int getEntryNum() { return _entryNum; };

	int getCellX(int charCode);
	int getCellY(int charCode);
	int getWidthLineX(int charCode);
	int getWidthLineY(int charCode);

	int getCharPixel(int charCode, int x, int y);
	bool isFontPixel(int charCode, int x, int y);

	void getCharBitmap(int charCode, Bitmap2Color *bitmap2Color);
};

#endif
