#include "MergedBinary.hpp"

#include <string.h>

#include <iostream>
#include <fstream>
using namespace std;

MergedBinary::MergedBinary() {
	_maxCode = 0;
}

MergedBinary::~MergedBinary() {
	int num = _fontFileVector.size();

	for (int i = 0; i < num; ++i) {
		delete[] _fontFileVector.at(i).filename;
	}
}

int MergedBinary::addFile(int codeOffset, int dataType, const char *filename) {
	if (_maxCode > codeOffset) {
		return -1;
	} else if (_maxCode < codeOffset) {
		FontBinaryFile fontFile;
		fontFile.codeOffset  = _maxCode;
		fontFile.letterNum   = codeOffset - _maxCode;
		fontFile.dataType    = 0;
		fontFile.filename    = new char[1];
		fontFile.filename[0] = '\0';
		_fontFileVector.push_back(fontFile);
	}

	FontBinaryFile fontFile;
	fontFile.codeOffset = codeOffset;
	{
		ifstream in;
		unsigned short letterNum;
		ios::pos_type beg;

		in.open(filename, ios::in|ios::binary);

		if (!in) {
			cout << "\"" << filename << "\" could not be opened." << endl;
			return -1;
		}

		in.read((char *)&letterNum, sizeof(unsigned short));

		in.seekg(0, ios::beg);
		beg = in.tellg();
		in.seekg(0, ios::end);
		fontFile.size = in.tellg() - beg;

		in.close();

		fontFile.letterNum = letterNum;
	}
	fontFile.dataType = dataType;
	fontFile.filename = new char[strlen(filename)+1];
	strcpy(fontFile.filename, filename);

	_fontFileVector.push_back(fontFile);
}

typedef struct {
	unsigned short maxCode;			// 2 bytes
	unsigned short dataType;		// 2 bytes
	unsigned int   dataOffset;		// 4 bytes
} FONT_AREA;						// 8 bytes

#define BUFFER_SIZE		(1024)

int MergedBinary::saveFile(const char *filename) {
	ofstream out;
	out.open(filename, ios::out|ios::binary);

	if (!out) {
		cout << "\"" << filename << "\" could not be opened." << endl;
		return -1;
	}

	int num = _fontFileVector.size();
	out.write((char *)&num, sizeof(int));

	int dataOffset = sizeof(int) + sizeof(FONT_AREA) * num;
	for (int i = 0; i < num; ++i) {
		FontBinaryFile *fontFile = &_fontFileVector.at(i);

		FONT_AREA fontArea;
		fontArea.maxCode    = fontFile->codeOffset + fontFile->letterNum;
		fontArea.dataType   = fontFile->dataType;
		if (fontFile->dataType) {
			fontArea.dataOffset = dataOffset;
			dataOffset = (dataOffset + fontFile->size + 3) / 4 * 4;
		} else {
			fontArea.dataOffset = 0;
		}

		out.write((char *)&fontArea, sizeof(FONT_AREA));
	}

	char buffer[BUFFER_SIZE];

	for (int i = 0; i < num; ++i) {
		FontBinaryFile *fontFile = &_fontFileVector.at(i);

		if (fontFile->dataType) {
			ifstream in;

			in.open(fontFile->filename, ios::in|ios::binary);

			int readSize;
			do {
				in.read(buffer, BUFFER_SIZE);
				readSize = in.gcount();
				out.write(buffer, readSize);
			} while (readSize == BUFFER_SIZE);

			if (readSize % 4 != 0) {
				buffer[0] = 0;
				buffer[1] = 0;
				buffer[2] = 0;
				out.write(buffer, 4 - readSize % 4);
			}

			in.close();
		}
	}

	out.close();
}
