#ifndef __POKEMONFONT_HPP__
#define __POKEMONFONT_HPP__

#include <vector>
using namespace std;

class FontBitmap;
class Bitmap2Color;

typedef struct {
	unsigned int  bitDataOffs;		// u32
	unsigned int  widthTblOffs;		// u32
	unsigned int  letterMax;		// u32
	unsigned char maxWidth;			// u8
	unsigned char maxHeight;		// u8
	unsigned char letterCharX;		// u8
	unsigned char letterCharY;		// u8
} FONTDATA_HEADER;

typedef struct {
	unsigned char y;
	unsigned char height;
} LETTER_HEADER;

class PokemonFont {
private:
	static const int PIXELDATA_TILESIZE  = 16 / sizeof(unsigned short);
	static const int PIXELDATA_ENTRYSIZE = PIXELDATA_TILESIZE * 4;
	static const int TILE_WIDTH  = 8;
	static const int TILE_HEIGHT = 8;
	static const int PIXELDATA_WIDTH  = 16;
	static const int PIXELDATA_HEIGHT = 16;

	static const int BLOCK_WIDTH  = PIXELDATA_WIDTH  + 4;
	static const int BLOCK_HEIGHT = PIXELDATA_HEIGHT + 6;

	static const int BITMAPFILEHEADEREX_PADDINGSIZE = 2;
	static const int BITMAPINFOHEADER_SIZE = 40;
	static const int BITMAP_CHARACTERNUMLINE = 16;

	static const int BITMAP_WIDTH        = BLOCK_WIDTH * BITMAP_CHARACTERNUMLINE;
	static const int BITMAP_PLANES       = 1;
	static const int BITMAP_BITCOUNT     = 8;
	static const int BITMAP_COMPRESSION  = 0;		// No compression
	static const int BITMAP_XPIXPERMETER = 3780;
	static const int BITMAP_YPIXPERMETER = 3780;
	static const int BITMAP_CLRUSED      = 1 << BITMAP_BITCOUNT;
	static const int BITMAP_CLRIMPORTANT = 0;

	static const int BITMAP_COLORSIZE    = 4;
	static const int BITMAP_PALETTESIZE  = BITMAP_COLORSIZE * BITMAP_CLRUSED;

	static const int WIDTH_PROPOTIONAL = -1;

	typedef struct {
		unsigned short pixelData[PIXELDATA_ENTRYSIZE];
		unsigned char  width;
		bool marking;
	} FontCharacter;

	typedef struct {
		unsigned short maxCode;
		short          width;
		unsigned long  offset;
	} WidthTableEntry;

	typedef struct {
		int width;
		int height;
		int marking;
		int *from;
		int *to;
	} FixPattern;

	FONTDATA_HEADER _header;
	vector<FontCharacter> _fontCharacterVector;
	vector<WidthTableEntry> _widthTableVector;

	void _setLetterMax(int num);
	void _setPixel(int charCode, int x, int y, int color);
	int  _getPixel(int charCode, int x, int y);
	void _drawCharacter(Bitmap2Color *bitmap2Color, int charCode, int top, int left, int color);
	void _addShadowForBold(Bitmap2Color *bitmap2Color, int charCode, int top, int left);
	void _setData(Bitmap2Color *bitmap2Color, int charCode, int top, bool bold, int width);

	int _getLetterInfo(int charCode, LETTER_HEADER *letterHeader);

public:
	static const int COLOR_NONE       = 0;
	static const int COLOR_FONT       = 1;
	static const int COLOR_SHADOW     = 2;
	static const int COLOR_BACKGROUND = 3;

	static const int COLOR_LIGHTSHADOW = 2;
	static const int COLOR_DARKSHADOW  = 3;

	PokemonFont();
	PokemonFont(const char *filename);
	~PokemonFont();

	int saveFile(const char *filename);
	int saveCompressedFile(const char *filename);
	int importFile(const char *filename, int offset);
	int importBitmap(FontBitmap *fontBitmap, int offset, int top, bool bold, int width);
	int fixFont(const char *filename, int offset, int num);
	int saveBitmap(const char *filename);
};

#endif
