#include <iostream>
#include <fstream>
using namespace std;

int main(int argc, char **argv) {
	if (argc != 2) {
		cout << argv[0] << " <pattern file>" << endl;
		return 0;
	}

	ifstream in;
	const char *filename = argv[1];
	in.open(filename, ios::in);

	if (!in) {
		cout << "\"" << filename << "\" could not be opened." << endl;
		return 1;
	}

	int patternNum;
	in >> patternNum;

	const char *symbol[] = {
		"", "@", "", "", "",
	};

	for (int i = 0; i < patternNum; ++i) {
		cout << i << endl;

		int width, height, marking;
		in >> width;
		in >> height;
		in >> marking;	// ǂݎ̂
		for (int y = 0; y < height; ++y) {
			for (int x = 0; x < width; ++x) {
				int from;
				in >> from;
				cout << symbol[from+1];
			}
			cout << endl;
		}
		cout << endl;
		for (int y = 0; y < height; ++y) {
			for (int x = 0; x < width; ++x) {
				int to;
				in >> to;
				cout << symbol[to+1];
			}
			cout << endl;
		}
		cout << endl << endl;
	}

	in.close();
}
