#include "FontBitmap.hpp"
#include "DividedHangul.hpp"
#include "PokemonFont.hpp"
#include "MergedBinary.hpp"

#include <stdlib.h>
#include <iostream>
#include <fstream>
using namespace std;

#define BUFFER_SIZE		(256)

int main(int argc, char *argv[]) {
	if (argc >= 2) {
		if (strcmp(argv[1], "full") == 0) {
			if (argc == 4 || argc == 5) {
				ifstream in;
				in.open(argv[2]);

				if (!in) {
					cout << "\"" << argv[2] << "\" could not be opened." << endl;
					return 1;
				}

				PokemonFont pokemonFont;

				while (!in.eof()) {
					char str[BUFFER_SIZE];
					in >> str;
					if (strcmp(str, "dat") == 0) {
						int offset;

						in >> str;
						in >> offset;
						pokemonFont.importFile(str, offset);
					} else if (strcmp(str, "bmp") == 0) {
						int offset;
						int top;
						bool bold;
						int width;

						in >> str;
						in >> offset;
						in >> top;
						in >> bold;
						in >> width;

						FontBitmap fontBitmap;
						fontBitmap.loadFile(str);
						pokemonFont.importBitmap(&fontBitmap, offset, top, bold, width);
					} else {
						cout << "Unknown format." << endl;
						return 1;
					}
				}

				pokemonFont.saveFile(argv[3]);
				if (argc == 5) pokemonFont.saveBitmap(argv[4]);

				return 0;
			}
		} else if (strcmp(argv[1], "div") == 0) {
			if (argc == 4) {
				// SYSTEM FONT
				ifstream in;
				in.open(argv[2]);

				if (!in) {
					cout << "\"" << argv[2] << "\" could not be opened." << endl;
					return 1;
				}

				char filename[BUFFER_SIZE];
				in >> filename;

				FontBitmap fontBitmap;
				fontBitmap.loadFile(filename);

				DividedHangul dividedHangul;

				int yofs;
				in >> yofs;

				while (!in.eof()) {
					int x, y, width, height;
					in >> x;
					in >> y;
					in >> width;
					in >> height;
					dividedHangul.addParts(&fontBitmap, x, y, width, height, yofs);
				}

				in.close();

				dividedHangul.saveFile(argv[3]);

				return 0;
			}
		} else if (strcmp(argv[1], "comp") == 0) {
			if (argc == 4) {
				PokemonFont pokemonFont(argv[2]);

				pokemonFont.saveCompressedFile(argv[3]);

				return 0;
			}
		} else if (strcmp(argv[1], "merge") == 0) {
			if (argc == 4) {
				ifstream in;
				in.open(argv[2]);

				if (!in) {
					cout << "\"" << argv[2] << "\" could not be opened." << endl;
					return 1;
				}

				MergedBinary mergedBinary;

				while (!in.eof()) {
					int codeOffset, dataType;
					char filename[BUFFER_SIZE];
					in >> codeOffset;
					in >> dataType;
					in >> filename;
					mergedBinary.addFile(codeOffset, dataType, filename);
				}

				mergedBinary.saveFile(argv[3]);

				return 0;
			}
		}
	}

	cout << "Usage:" << endl;
	cout << "  " << argv[0] << " full  <input list> <output binary> [output bitmap]" << endl;
	cout << "  " << argv[0] << " div   <input list> <output binary>" << endl;
	cout << "  " << argv[0] << " comp  <conventional binary> <output binary>" << endl;
	cout << "  " << argv[0] << " merge <input list> <output binary>" << endl;

	return 0;
}
