/**
 *	@file	b_tower_local.h
 *	@brief	og^[@Z[uf[^\̒`
 *	@author	Miyuki Iwasawa
 *	@date	06.04.18	
 */

#ifndef __H_BTOWER_LOCAL_H__
#define __H_BTOWER_LOCAL_H__

#include "savedata/b_tower_def.h"
#include "libdpw/dpw_bt.h"
#include "battle/battle_common.h"
#include "system/gamedata.h"
#include "gflib/gf_date.h"
#include "battle/b_tower_data.h"

/**
 * @brief	og^[vCisf[^
 *
 * size=20byte
 * JnɃNA
*/
struct _BTLTOWER_PLAYWORK{
	u8	itemfix_f	:1;	///<ŒACeǂ̃tO
	u8	saved_f		:1;	///<Z[uς݂ǂ
	u8	play_mode	:3;	///<݂ǂɃ`W?
	u8	partner		:3;	///<ݒNƑgł邩?
	u8	dummy;			///<4byteE_~[

	u8	tower_round;		///<og^[lځH

	u8	wifi_rec_down;		///<܂łɓ|ꂽ|P
	u16	wifi_rec_turn;		///<ɂ^[
	u16	wifi_rec_damage;	///<܂łɎ󂯂_[W

	u8	member_poke[BTOWER_STOCK_MEMBER_MAX];		///<I|P̈ʒu
	u16	trainer_no[BTOWER_STOCK_TRAINER_MAX];		///<ΐg[i[Noۑ
	
	u32	play_rnd_seed;	///<^[vCω_V[hۑꏊ

	struct	_B_TOWER_PAREPOKE_PARAM	pare_poke;	///<AI}`̃yÃ|PĐɕKvȃp[^
};

/**
 *	@brief	og^[@XRAf[^
 *
 *	size= 20+168+168=356byte
 *	Q[ʂĕۑ&ǗĂAvC[
 */
struct _BTLTOWER_SCOREWORK{
	u16	btl_point;	///<og|Cg
	u8	wifi_lose;	///<AsJEg
	u8	wifi_rank;	///<WiFiN

	u32	day_rnd_seed;	///<^[ptω_V[hۑꏊ
	
	union{
		struct{
		u16	silver_get:1;		///<Vo[gtB[Qbg
		u16	gold_get:1;			///<S[hgtB[Qbg
		u16	silver_ready:1;		///<Vo[Ⴆ܂
		u16	gold_ready:1;		///<S[hႦ܂
		u16	wifi_lose_f:1;		///<wifiAstO
		u16	wifi_update:1;		///<wifiуAbv[htO
		u16	wifi_poke_data:1;	///<wifi|Pf[^XgbNLiVtO
		u16	single_poke_data:1;	///<single|Pf[^XgbNLiVtO
		u16	single_record:1;	///<VOR[h풆tO
		u16	double_record:1;	///<_uR[h풆tO
		u16	multi_record:1;		///<}`R[h풆tO
		u16	cmulti_record:1;	///<ʐM}`R[h풆tO
		u16	wifi_record:1;		///<WifiR[h풆tO
		u16	copper_get:1;		///<Jbp[gtB[Qbg
		u16	copper_ready:1;		///<Jbp[Ⴆ܂
		u16	:1;	///<E_~[
		};
		u16	flags;
	};
	u16	padding;	///<4byteE_~[
	
	u16	tower_stage[5];		///<og^[

	//WiFi`Wf[^
	u16	wifi_score;	///<WiFi
	//WiFi|Pf[^XgbN
	struct _B_TOWER_POKEMON	wifi_poke[3];
	//g[i[[hpVOf[^XgbN
	struct _B_TOWER_POKEMON	single_poke[3];
	
};

/**
 *	@brief	og^[ vC[bZ[Wf[^
 *
 *	8*4=32byte
 */
struct _BTLTOWER_PLAYER_MSG{
	PMS_DATA	msg[4];	///<pbZ[W
};


/**
 *	@brief	og^[ WIFI vC[f[^
 *
 *	56*3+60=228byte
 */
struct _BTLTOWER_WIFI_PLAYER{
	struct _B_TOWER_POKEMON	poke[3];
	
	STRCODE	name[PERSON_NAME_SIZE+EOM_SIZE];	//g[i[((PERSON_NAME_SIZE:7)+(EOM_SIZE:1))*(STRCODE:u16)=16

	u8	casette_version;					//JZbgversion
	u8	lang_version;						//o[W
	u8	country_code;						//R[h
	u8	address;							//ZłƂ

	u32	id_no;								//IDNo	

	u16	leader_word[4];						//[_[bZ[W

	union{
		struct{
		u8	ngname_f:1;						//NGl[tO
		u8	gender:1;						//
		u8			:6;						//܂6bit
		};
		u8	flags;
	};
	u8	tr_type;							//g[i[^Cv
	u16	appear_word[4];						//oꃁbZ[W	
	u16	win_word[4];						//bZ[W	
	u16	lose_word[4];						//sރbZ[W	

	u16	result;								//
};


/**
 *	@brief	og^[ WIFI DLf[^
 *
 *	280byte+1596(228*7)byte+1020(34*30)byte=2836byte
 */
struct _BTLTOWER_WIFI_DATA{
	GF_DATE	day;	///<DLt4byte
	u8		flags[BTOWER_ROOM_DATA_FLAGS_LEN];	///<DLς݃tOGA(2000bit)
	u8		player_data_f;	///<vC[f[^LǂH
	u8		leader_data_f;	///<[_[f[^LǂH

	//DLf[^̃[ID
	u8	player_room;	///<vC[f[^[No
	u8	player_rank;	///<vC[f[^[N
	u8	leader_room;	///<[_[f[^[No
	u8	leader_rank;	///<[_[f[^[N

	///vC[f[^
	struct _BTLTOWER_WIFI_PLAYER player[BTOWER_STOCK_WIFI_PLAYER_MAX];
	///[_[f[^
	struct _B_TOWER_LEADER_DATA leader[BTOWER_STOCK_WIFI_LEADER_MAX];
};

/**
 *	@brief	og^[@WiFi DLf[^
 */
struct _BTLTOWER_SAVEWORK{
	//vCf[^
	struct _BTLTOWER_PLAYWORK	play;
	//XRAf[^
	struct _BTLTOWER_SCOREWORK	score;
	//WiFi vC[bZ[Wf[^
	struct _BTLTOWER_PLAYER_MSG	player_msg;
	//WiFi f[^
	struct _BTLTOWER_WIFI_DATA	wifi;
};

#endif	//__H_BTOWER_LOCAL_H__
