//============================================================================================
/**
 * @brief	coin.c
 * @brief	RC
 * @date	2006.03.09
 * @author	tamada
 */
//============================================================================================

#include "savedata/coin.h"
#include "coin_local.h"
#include "gflib/assert.h"

//============================================================================================
//============================================================================================
//---------------------------------------------------------------------------
/**
 * @brief	RCf[^̏
 * @param	coin		RCf[^ւ̃|C^
 */
//---------------------------------------------------------------------------
void COIN_Init(COIN * coin)
{
	coin->value = 0;
}
//---------------------------------------------------------------------------
/**
 * @brief	RC̐Zbg
 * @param	coin		RCf[^ւ̃|C^
 * @param	setvalue	Zbgl
 */
//---------------------------------------------------------------------------
void COIN_Set(COIN * coin, u32 setvalue)
{
	GF_ASSERT(setvalue <= COIN_MAX);
	coin->value = setvalue;
}

//---------------------------------------------------------------------------
/**
 * @brief	RC̐擾
 * @param	coin		RCf[^ւ̃|C^
 * @retval	int			RC̐
 */
//---------------------------------------------------------------------------
u32 COIN_GetValue(const COIN * coin)
{
	return coin->value;
}

//---------------------------------------------------------------------------
/**
 * @brief	RC𑝂₷
 * @param	coin		RCf[^ւ̃|C^
 * @param	addvalue	₷l
 * @retval	TRUE		
 * @retval	FALSE		s
 */
//---------------------------------------------------------------------------
BOOL COIN_Add(COIN * coin, u32 addvalue)
{
//	GF_ASSERT(addvalue > COIN_MAX);
	if (coin->value >= COIN_MAX) {
		return FALSE;
	}
	coin->value += addvalue;
	if (coin->value > COIN_MAX) {
		coin->value = COIN_MAX;
	}
	return TRUE;
}

//---------------------------------------------------------------------------
/**
 * @brief	RC𑝂₹邩ǂ`FbN
 * @param	coin		RCf[^ւ̃|C^
 * @param	addvalue	₷l
 * @retval	TRUE		RC𑝂₷̂ɐ
 * @retval	FALSE		RC𑝂₷̂Ɏsiől𒴂j
 */
//---------------------------------------------------------------------------
BOOL COIN_AddCheck(const COIN * coin, u32 addvalue)
{
	if (addvalue + (u32)coin->value <= COIN_MAX) {
		return TRUE;
	} else {
		return FALSE;
	}
}

//---------------------------------------------------------------------------
/**
 * @brief	RC炷
 * @param	coin		RCf[^ւ̃|C^
 * @param	subvalue	炷l
 * @retval	TRUE		
 * @retval	FALSE		s
 */
//---------------------------------------------------------------------------
BOOL COIN_Sub(COIN * coin, u32 subvalue)
{
//	GF_ASSERT(subvalue > COIN_MAX);
	if (coin->value < subvalue) {
		return FALSE;
	}
	coin->value -= subvalue;
	return TRUE;
}

