//============================================================================================
/**
 * @file	dendou_data.c
 * @brief	aZ[uf[^
 * @author	taya
 * @date	2006.04.20
 */
//============================================================================================
#include "common.h"
#include "savedata\savedata.h"
#include "system\gamedata.h"
#include "gflib\strbuf_family.h"
#include "poketool\pokeparty.h"

#include "savedata\dendou_data.h"


enum {
	POKENAME_BUFSIZE = MONS_NAME_SIZE+EOM_SIZE,		// 11
	OYANAME_BUFSIZE = PERSON_NAME_SIZE+EOM_SIZE,	// 8
};


//----------------------------------------------------------
/**
 *	a|P̃f[^i60 bytesj
 */
//----------------------------------------------------------
typedef struct {
	u16	monsno;				///< |Pio[iOȂf[^Ŝj
	u8	level;				///< x
	u8	formNumber;			///< tH
	u32	personalRandom;		///< ̗
	u32	idNumber;			///< ID
	STRCODE	nickname[ POKENAME_BUFSIZE ];	///< jbNl[
	STRCODE	oyaname[ OYANAME_BUFSIZE ];		///< ▼
	u16	waza[ 4 ];			///< Zio[
}DENDOU_POKEMON_DATA_INSIDE;


//----------------------------------------------------------
/**
 *	aPR[hf[^i364 bytesj
 */
//----------------------------------------------------------
typedef struct {
	DENDOU_POKEMON_DATA_INSIDE	pokemon[ TEMOTI_POKEMAX ];	///< |Pf[^
	u16			year;				///< atiNj 2006 `
	u8			month;				///< atij 1`12
	u8			day;				///< atij 1`31
}DENDOU_RECORD;


//----------------------------------------------------------
/**
 *	aZ[uf[^{́i10920 bytesj
 */
//----------------------------------------------------------
struct _DENDOU_SAVEDATA {

	DENDOU_RECORD	record[ DENDOU_RECORD_MAX ];

	u32		savePoint;		///< recordz񒆂́AɃZ[uindex
	u32		latestNumber;	///< ŐVf[^̓aʎZ
};



//==============================================================
// Prototype
//==============================================================
static int inline recIndex_to_datIndex( const DENDOU_SAVEDATA* data, int recIndex );





//------------------------------------------------------------------
/**
 * Z[uf[^TCYԂ
 *
 * @retval  int		
 */
//------------------------------------------------------------------
int DendouData_GetWorkSize( void )
{
	return sizeof(DENDOU_SAVEDATA);
}
//------------------------------------------------------------------
/**
 * f[^
 *
 * @param   data		
 *
 */
//------------------------------------------------------------------
void DendouData_Init( DENDOU_SAVEDATA* data )
{
	MI_CpuClear32( data, sizeof(DENDOU_SAVEDATA) );
}




//------------------------------------------------------------------
/**
 * a背R[hPǉ
 *
 * @param   data		aZ[uf[^|C^
 * @param   party		ap[eB[̃f[^
 * @param   date		atf[^iNITRÕf[^̂܂܁j
 *
 */
//------------------------------------------------------------------
void DendouData_AddRecord( DENDOU_SAVEDATA* data, const POKEPARTY* party, const RTCDate* date )
{
	DENDOU_RECORD*  record;
	POKEMON_PARAM*  pp;
	STRBUF*         strbuf;
	int  pokeCount, i, p;
	BOOL fastFlag;

	GF_ASSERT(data != NULL);
	GF_ASSERT(data->savePoint < DENDOU_RECORD_MAX);

	if( data->latestNumber >= DENDOU_NUMBER_MAX )
	{
		return;
	}

	record = &data->record[ data->savePoint ];
	pokeCount = PokeParty_GetPokeCount( party );

	strbuf = STRBUF_Create( POKENAME_BUFSIZE, HEAPID_BASE_SYSTEM );

	MI_CpuClear16( record->pokemon,  sizeof(DENDOU_POKEMON_DATA_INSIDE)*TEMOTI_POKEMAX );

	for(i=0, p=0; i<pokeCount; i++)
	{
		pp = PokeParty_GetMemberPointer( party, i );

		fastFlag = PokeParaFastModeOn( pp );

		if( PokeParaGet(pp, ID_PARA_tamago_flag, NULL) == FALSE )
		{
			record->pokemon[p].monsno = PokeParaGet( pp, ID_PARA_monsno, NULL );
			record->pokemon[p].level = PokeParaGet( pp, ID_PARA_level, NULL );
			record->pokemon[p].formNumber = PokeParaGet( pp, ID_PARA_form_no, NULL );
			record->pokemon[p].personalRandom = PokeParaGet( pp, ID_PARA_personal_rnd, NULL );
			record->pokemon[p].idNumber = PokeParaGet( pp, ID_PARA_id_no, NULL );
			record->pokemon[p].waza[0] = PokeParaGet( pp, ID_PARA_waza1, NULL );
			record->pokemon[p].waza[1] = PokeParaGet( pp, ID_PARA_waza2, NULL );
			record->pokemon[p].waza[2] = PokeParaGet( pp, ID_PARA_waza3, NULL );
			record->pokemon[p].waza[3] = PokeParaGet( pp, ID_PARA_waza4, NULL );

			if(strbuf)
			{
				PokeParaGet( pp, ID_PARA_nickname_buf, strbuf );
				STRBUF_GetStringCode( strbuf, record->pokemon[p].nickname, POKENAME_BUFSIZE );

				PokeParaGet( pp, ID_PARA_oyaname_buf, strbuf );
				STRBUF_GetStringCode( strbuf, record->pokemon[p].oyaname, OYANAME_BUFSIZE );
			}
			else
			{
				record->pokemon[p].nickname[0] = EOM_;
				record->pokemon[p].oyaname[0] = EOM_;
			}

			p++;
		}

		PokeParaFastModeOff( pp, fastFlag );
	}

	record->year = date->year;
	record->month = date->month;
	record->day = date->day;


	if(++(data->savePoint) >= DENDOU_RECORD_MAX)
	{
		data->savePoint = 0;
	}
	data->latestNumber++;


	if(strbuf)
	{
		STRBUF_Delete(strbuf);
	}

}




//------------------------------------------------------------------
/**
 * a背R[hԂ
 *
 * @param   data	af[^|C^
 *
 * @retval  u32		
 */
//------------------------------------------------------------------
u32 DendouData_GetRecordCount( const DENDOU_SAVEDATA* data )
{
	GF_ASSERT(data != NULL);
	GF_ASSERT(data->savePoint < DENDOU_RECORD_MAX);

	if( data->latestNumber >= DENDOU_RECORD_MAX )
	{
		return DENDOU_RECORD_MAX;
	}
	return data->latestNumber;
}
//------------------------------------------------------------------
/**
 * a背R[hAڂ̓a肩Ԃ
 *
 * @param   data		af[^|C^
 * @param   index		R[hCfbNXi0ŐVŁAɋȂĂj
 *
 * @retval  u32			
 */
//------------------------------------------------------------------
u32 DendouData_GetRecordNumber( const DENDOU_SAVEDATA* data, int index )
{
	GF_ASSERT(data != NULL);
	GF_ASSERT(data->savePoint < DENDOU_RECORD_MAX);
	GF_ASSERT(index < DENDOU_RECORD_MAX);

	return data->latestNumber - index;
}
//------------------------------------------------------------------
/**
 * a背R[hA|P擾
 *
 * @param   data		af[^|C^
 * @param   index		R[hCfbNXi0ŐVŁAɋȂĂj
 *
 * @retval	u32		ap[eB[̃|P
 */
//------------------------------------------------------------------
u32 DendouData_GetPokemonCount( const DENDOU_SAVEDATA* data, int index )
{
	u32 i;

	GF_ASSERT(data != NULL);
	GF_ASSERT(data->savePoint < DENDOU_RECORD_MAX);
	GF_ASSERT(index < DENDOU_RECORD_MAX);

	index = recIndex_to_datIndex( data, index );
	for(i=0; i<TEMOTI_POKEMAX; i++)
	{
		if(data->record[index].pokemon[i].monsno == 0)
		{
			break;
		}
	}
	return i;
}
//------------------------------------------------------------------
/**
 * a背R[hA|Pf[^擾
 *
 * @param   data		af[^|C^
 * @param   index		R[hCfbNXi0ŐVŁAɋȂĂj
 * @param   poke_pos	̖ڂ̃|Pi0`5j
 * @param   poke_data	|Pf[^󂯎\̂̃|C^
 */
//------------------------------------------------------------------
void DendouData_GetPokemonData( const DENDOU_SAVEDATA* data, int index, int poke_pos, DENDOU_POKEMON_DATA* poke_data )
{
	const DENDOU_POKEMON_DATA_INSIDE*  recPoke;
	int i;

	GF_ASSERT(data != NULL);
	GF_ASSERT(data->savePoint < DENDOU_RECORD_MAX);
	GF_ASSERT(index < DENDOU_RECORD_MAX);

	index = recIndex_to_datIndex( data, index );
	recPoke = &(data->record[index].pokemon[poke_pos]);

	poke_data->monsno = recPoke->monsno;
	poke_data->level = recPoke->level;
	poke_data->personalRandom = recPoke->personalRandom;
	poke_data->idNumber = recPoke->idNumber;
	poke_data->formNumber = recPoke->formNumber;

	STRBUF_SetStringCode( poke_data->nickname, recPoke->nickname );
	STRBUF_SetStringCode( poke_data->oyaname, recPoke->oyaname );

	for(i=0; i<4; i++)
	{
		poke_data->waza[i] = recPoke->waza[i];
	}
}
//------------------------------------------------------------------
/**
 * a背R[hAat擾
 *
 * @param   data		af[^|C^
 * @param   index		R[hCfbNXi0ŐVŁAɋȂĂj
 * @param   date		tf[^󂯎\̂ւ̃|C^
 */
//------------------------------------------------------------------
void DendouData_GetDate( const DENDOU_SAVEDATA* data, int index, RTCDate* date )
{
	GF_ASSERT(data != NULL);
	GF_ASSERT(data->savePoint < DENDOU_RECORD_MAX);
	GF_ASSERT(index < DENDOU_RECORD_MAX);

	index = recIndex_to_datIndex( data, index );
	date->year = data->record[index].year;
	date->month = data->record[index].month;
	date->day = data->record[index].day;

	// j͕ۑȂAꉞNAĂ
	date->week = 0;

}















//------------------------------------------------------------------
/**
 * R[hCfbNXiVCfbNXjf[^zCfbNXɕϊ
 *
 * @param   index		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int inline recIndex_to_datIndex( const DENDOU_SAVEDATA* data, int recIndex )
{
	int datIndex = (data->savePoint - 1 - recIndex);
	if( datIndex < 0 )
	{
		datIndex += DENDOU_RECORD_MAX;
	}
	return datIndex;
}
