//============================================================================================
/**
 * @file	encount.c
 * @brief	GJEg֘AANZXp\[X
 * @author	tamada GAME FREAK inc.
 * @date	2003.04.28
 */
//============================================================================================

#include "common.h"
#include "savedata/savedata.h"
#include "savedata/encount.h"
#include "system/pm_rtc.h"
#include "field/move_pokemon_def.h"
#include "savedata/vidro_type.h"

#include "field/encount_define.h"
//؃f[^
typedef struct HONEY_TREE_tag
{
	u8 TreeNo;			//OGJEg؂̃io[
	HONEY_DATA HoneyData[HONEY_TREE_MAX];
}HONEY_TREE;

//Rf[^
typedef struct HILL_BACK_DATA_tag
{
	BOOL TalkFlg;	//bLtO	<<ʂɃZ[uĂƂ낪̂Ŗgp 20060526
	u16 EncTblIdx1;	//RGJEge[uCfbNX1
	u16 EncTblIdx2;	//RGJEge[uCfbNX2
}HILL_BACK_DATA;

//@̃][
typedef struct PLAYER_ZONE_HIST_tag
{
	int BeforeZone;	//O][
	int OldZone;	//OX][
}PLAYER_ZONE_HIST;

//ړ|Pf[^
typedef struct MV_POKE_DATA_tag{

	int ZoneID;			//][hc
	u32	PowRnd;		// p[
	u32	PersonalRnd;	// 

	u16	MonsNo;				// |Pio[
	u16	Hp;				// HP

	u8	Lv;				// Lv
	u8	Cond;			// Ԉُ

	u8	Encount;		// GJEgtO
	u8	Dummy;

}MV_POKE_DATA;

typedef struct ENC_SV_DATA_tag
{
	int SafariRandSeed;			//Tt@_̎
	int GenerateRandSeed;		//ʔ_̎
	HILL_BACK_DATA HillBackData;			//Rf[^
	HONEY_TREE HoneyTree;		//؃f[^
	SWAY_GRASS_HIST		SwayGrassHist;	//hꑐ
	PLAYER_ZONE_HIST	PlayerZoneHist;	//][
	MV_POKE_DATA	MovePokeData[MOVE_POKE_MAX];	//ړ|Pf[^
	u8 MovePokeZoneIdx[MOVE_POKE_MAX];	//ړ|P݃][CfbNX
	u8 GenerateValid;					//ʔtO
	u8 SprayCount;						//Xv[L(ő250)
	u8 PokeSearcherCharge;				//|PT[`[dliő50炵j
	u8 VidroType;						//gpĂr[hividro_type.hɒ`j
	
}ENC_SV_DATA;

//----------------------------------------------------------
/**
 * @brief	GJEg֘AZ[uf[^TCY擾
 * 
 * @return	int		ENC_SV_DATÃTCY
 */
//----------------------------------------------------------
int EncDataSave_GetWorkSize(void)
{
	return sizeof(ENC_SV_DATA);
}

//----------------------------------------------------------
/**
 * @brief		GJEg֘AZ[uf[^̏
 * 
 * @param	outEncData		GJEg֘AZ[uf[^ւ̃|C^
 *
 * @return	none
 */
//----------------------------------------------------------
void EncDataSave_InitSaveData(ENC_SV_PTR outEncData)
{
	memset( outEncData, 0, sizeof(ENC_SV_DATA) );

	//_̎Zbg
	outEncData->SafariRandSeed = gf_mtRand();
	outEncData->GenerateRandSeed = gf_mtRand();
	
	//R͂ȂtOƂ
	outEncData->HillBackData.TalkFlg = FALSE;
	//RGJEge[uCfbNXZbg
	outEncData->HillBackData.EncTblIdx1 = HILL_BACK_POKE_NONE;
	outEncData->HillBackData.EncTblIdx2 = HILL_BACK_POKE_NONE;
	//؏
	{
		int i;
		HT_PTR ht_ptr = &(outEncData->HoneyTree);
		ht_ptr->TreeNo = HONEY_TREE_MAX;
		for(i=0;i<HONEY_TREE_MAX;i++){
			ht_ptr->HoneyData[i].Time = 0;
			//outHoneyTree->HoneyData[i].State = HONEY_SPREAD_OK;
			ht_ptr->HoneyData[i].TblMonsNo = 0;
			ht_ptr->HoneyData[i].TblNo = 0;
			ht_ptr->HoneyData[i].RareLv = 0;
			ht_ptr->HoneyData[i].SwayLv = 0;
		}
	}
	//ʔtO𗎂Ƃ
	outEncData->GenerateValid = 0;
	//Xv[
	outEncData->SprayCount = 0;
	//|PT[`[
	outEncData->PokeSearcherCharge = 0;
	//r[h
	outEncData->VidroType = VIDRO_NONE;
}

//----------------------------------------------------------
/**
 * @brief		GJEg֘A_̎XV
 * 
 * @param	outEncData		GJEg֘AZ[uf[^ւ̃|C^
 *
 * @return	none
 */
//----------------------------------------------------------
void EncDataSave_UpdateRandSeed(ENC_SV_PTR ioEncData, const u32 inRandSeed)
{
	ioEncData->SafariRandSeed = inRandSeed;
	ioEncData->GenerateRandSeed = inRandSeed;
}

//----------------------------------------------------------
/**
 * @brief	GJEg֘A_̎擾
 * 
 * @param	inEncData		GJEg֘AZ[uf[^ւ̃|C^
 * @param	inSeedType		_̎̎ށiencount.hɈӋ`j
 *
 * @return	u32				Tt@_̎
 */
//----------------------------------------------------------
u32 EncDataSave_GetRandSeed(ENC_SV_PTR inEncData, const u8 inSeedType)
{
	switch(inSeedType){
	case ENC_RND_SEED_SAFARI:
		return inEncData->SafariRandSeed;
	case ENC_RND_SEED_GENERATE:
		return inEncData->GenerateRandSeed;
	default:
		GF_ASSERT(0);
		return 0;
	}
}

//----------------------------------------------------------
/**
 * @brief	hꑐf[^擾
 * 
 * @param	outEncData		GJEg֘AZ[uf[^ւ̃|C^
 *
 * @return	hꑐf[^|C^
 */
//----------------------------------------------------------
SWAY_GRASS_HIST *  EncDataSave_GetSwayGrassHist(ENC_SV_PTR outEncData)
{
	return &(outEncData->SwayGrassHist);
}

//==============================================================================
/**
 * Z[uf[^擪|C^擾
 *
 * @param	sv		Z[u|C^
 *
 * @return	ENC_SV_PTR		g[i[J[hf[^|C^
 */
//==============================================================================
ENC_SV_PTR EncDataSave_GetSaveDataPtr(SAVEDATA * sv)
{
	return SaveData_Get(sv, GMDATA_ID_ENCOUNT);
}

//؊֘A-------------------------------------------------------------------------------------------------------------

//==============================================================================
/**
 * ؃f[^|C^擾
 *
 * @param	sv		Z[u|C^
 *
 * @return	HT_PTR	hf[^|C^
 */
//==============================================================================
HT_PTR EncDataSave_GetHoneyTree(ENC_SV_PTR inEncData)
{
	return &(inEncData->HoneyTree);
}

//==============================================================================
/**
 * OGJEg؂̃io[擾
 *
 * @param	inPtr		hGJEgf[^|C^
 *
 * @return	int			؃io[
 */
//==============================================================================
const int HTSave_GetBeforeTreeNo(HT_PTR inPtr)
{
	return inPtr->TreeNo;
}

//==============================================================================
/**
 * OGJEg؂̃io[Zbg
 *
 * @param	inTreeNo	؃io[
 * @param	outPtr		hGJEgf[^|C^
 *
 * @return	none
 */
//==============================================================================
void HTSave_SetBeforeTreeNo(const u8 inTreeNo, HT_PTR outPtr)
{
	outPtr->TreeNo = inTreeNo;
}

//==============================================================================
/**
 * ؃f[^|C^̎擾
 *
 * @param	inTreeNo	؃io[
 * @param	outPtr		hGJEgf[^|C^
 *
 * @return	none
 */
//==============================================================================
HONEY_DATA *HTSave_GetHoneyDataPtr(const u8 inTreeNo, HT_PTR outPtr)
{
	HONEY_DATA *data;
	data = &outPtr->HoneyData[inTreeNo];

	return data;
}

//==============================================================================
/**
 * ԍXV
 *
 * @param	sv				Z[u|C^
 * @param	inDiffminute	ԍ
 *
 * @return	none
 */
//==============================================================================
void HTSave_UpdateHoneyTreeTime(SAVEDATA * sv,  const int inDiffMinute)
{
	int i;
	HT_PTR ptr;
	ENC_SV_PTR enc_data;
	HONEY_DATA *data;
	enc_data = EncDataSave_GetSaveDataPtr(sv);
	ptr = &(enc_data->HoneyTree);

	for(i=0;i<HONEY_TREE_MAX;i++){
		data = HTSave_GetHoneyDataPtr(i, ptr);
		if (data->Time != 0){
			data->Time -= inDiffMinute;
			if (data->Time < 0){
				data->Time = 0;
			}
		}
	}
}

//==============================================================================
/**
 * ʔJn
 *
 * @param	sv				Z[u|C^
 *
 * @return	none
 */
//==============================================================================
void EncDataSave_StartGenerate( SAVEDATA * sv )
{
	ENC_SV_PTR enc_data;
	enc_data = EncDataSave_GetSaveDataPtr(sv);
	enc_data->GenerateValid = 1;
}

//==============================================================================
/**
 * ʔԂ
 *
 * @param	inEncData			GJEg֘AZ[u|C^
 *
 * @return	u8 0ȊOFʔ
 */
//==============================================================================
u8 EncDataSave_IsGenerate( ENC_SV_PTR inEncData )
{
	return inEncData->GenerateValid;
}

//==============================================================================
/**
 * l̃][̍XV
 *
 * @param	outEncData			GJEg֘AZ[u|C^
 * @param	inZoneID			][hc
 */
//==============================================================================
void EncDataSave_UpdatePlayerZoneHist(ENC_SV_PTR ioEncData, const int inZoneID)
{
	if (ioEncData->PlayerZoneHist.BeforeZone != inZoneID){
		ioEncData->PlayerZoneHist.OldZone = ioEncData->PlayerZoneHist.BeforeZone;
		ioEncData->PlayerZoneHist.BeforeZone = inZoneID;
	}
}

//==============================================================================
/**
 * l̑OX񂢂][擾
 *
 * @param	inEncData		GJEg֘AZ[u|C^
 *
 * @return	int				][hc
 */
//==============================================================================
int EncDataSave_GetPlayerOldZone(ENC_SV_PTR inEncData)
{
	return inEncData->PlayerZoneHist.OldZone;
}

//==============================================================================
/**
 * wړ|P̃][CfbNX擾
 *
 * @param	inEncData		GJEg֘AZ[u|C^
 * @param	inTargetPoke	ړ|P(0`2)
 *
 * @return	u8				][CfbNX
 */
//==============================================================================
u8 EncDataSave_GetMovePokeZoneIdx(ENC_SV_PTR inEncData, const u8 inTargetPoke)
{
	GF_ASSERT(inTargetPoke<MOVE_POKE_MAX);
	
	return inEncData->MovePokeZoneIdx[inTargetPoke];
}

//==============================================================================
/**
 * wړ|P̃][CfbNXZbg
 *
 * @param	outEncData		GJEg֘AZ[u|C^
 * @param	inTargetPoke	ړ|P(0`2)
 * @param	inZoneIndex		][CfbNX
 *
 * @return	none
 */
//==============================================================================
void EncDataSave_SetMovePokeZoneIdx(ENC_SV_PTR outEncData, const u8 inTargetPoke, const u8 inZoneIndex)
{
	GF_ASSERT(inTargetPoke<MOVE_POKE_MAX);
	outEncData->MovePokeZoneIdx[inTargetPoke] = inZoneIndex;
}

//==============================================================================
/**
 * wړ|P̃GJEgtO݂āAړĂ邩ǂ`FbN
 *
 * @param	inEncData		GJEg֘AZ[u|C^
 * @param	inTargetPoke	ړ|P(0`2)
 *
 * @return	u8			0ȊO:ړĂ	0:ړĂȂ
 */
//==============================================================================
u8 EncDataSave_IsMovePokeValid(ENC_SV_PTR inEncData, const u8 inTargetPoke)
{
	GF_ASSERT(inTargetPoke<MOVE_POKE_MAX);
	return inEncData->MovePokeData[inTargetPoke].Encount;
}

//==============================================================================
/**
 * wړ|Pf[^̃NA
 *
 * @param	inEncData		GJEg֘AZ[u|C^
 * @param	inTargetPoke	ړ|P(0`2)
 *
 * @return	none
 */
//==============================================================================
void EncDataSave_ClearMovePokeData(MPD_PTR *outMPData)
{
	memset((*outMPData), 0, sizeof(MV_POKE_DATA));
}

//==============================================================================
/**
 * wړ|Pf[^|C^̎擾
 *
 * @param	inEncData		GJEg֘AZ[u|C^
 * @param	inTargetPoke	ړ|P(0`2)
 *
 * @return	MPD_PTR			ړ|Pf[^
 */
//==============================================================================
MPD_PTR	EncDataSave_GetMovePokeDataPtr(ENC_SV_PTR inEncData, const u8 inTargetPoke)
{
	GF_ASSERT(inTargetPoke<MOVE_POKE_MAX);
	return &(inEncData->MovePokeData[inTargetPoke]);
}

//==============================================================================
/**
 * ړ|Pf[^p[^擾
 *
 * @param	inMPData		ړ|Pf[^|C^
 * @param	inParamID		p[^hc
 *
 * @return	u32
 */
//==============================================================================
u32 EncDataSave_GetMovePokeDataParam(const MPD_PTR inMPData, const u8 inParamID)
{
	u32 val;
	switch(inParamID){
	case MP_PARAM_ZONE_ID:			//o][
		val = inMPData->ZoneID;
		break;
	case MP_PARAM_POW_RND:			//p[
		val = inMPData->PowRnd;
		break;
	case MP_PARAM_PER_RND:			//
		val = inMPData->PersonalRnd;
		break;
	case MP_PARAM_MONSNO:			//X^[io[
		val = inMPData->MonsNo;
		break;
	case MP_PARAM_HP:				//go
		val = inMPData->Hp;
		break;
	case MP_PARAM_LV:				//ku
		val = inMPData->Lv;
		break;
	case MP_PARAM_COND:				//Ԉُ
		val = inMPData->Cond;
		break;
	case MP_PARAM_ENC:				//GJEgtO
		val = inMPData->Encount;
		break;
	defauld:
		GF_ASSERT(0);
		return 0;
	}
	return val;
}

//==============================================================================
/**
 * ړ|Pf[^p[^Zbg
 *
 * @param	EncData		GJEg֘AZ[u|C^
 * @param	inParamID	p[^hc
 * @param	inVal		Zbgl
 *
 * @return	none
 */
//==============================================================================
void EncDataSave_SetMovePokeDataParam(MPD_PTR outMPData, const u8 inParamID, const u32 inVal)
{
	u32 val;
	switch(inParamID){
	case MP_PARAM_ZONE_ID:			//o][
		outMPData->ZoneID = inVal;
		break;
	case MP_PARAM_POW_RND:			//p[
		outMPData->PowRnd = inVal;
		break;
	case MP_PARAM_PER_RND:			//
		outMPData->PersonalRnd = inVal;
		break;
	case MP_PARAM_MONSNO:			//X^[io[
		outMPData->MonsNo = inVal;
		break;
	case MP_PARAM_HP:				//go
		outMPData->Hp = inVal;
		break;
	case MP_PARAM_LV:				//ku
		outMPData->Lv = inVal;
		break;
	case MP_PARAM_COND:				//Ԉُ
		outMPData->Cond = inVal;
		break;
	case MP_PARAM_ENC:				//GJEgtO
		outMPData->Encount = inVal;
		break;
	defauld:
		GF_ASSERT(0);
	}
}

//==============================================================================
/**
 * |PT[`[dli[õ|C^擾
 *
 * @param	inEncData		GJEg֘AZ[u|C^
 *
 * @return	u8*				|PT[`[[dl|C^
 */
//==============================================================================
u8 *EncDataSave_GetPokeSearcherCharge(ENC_SV_PTR inEncData)
{
	return &(inEncData->PokeSearcherCharge);
}

//==============================================================================
/**
 * Xv[Li[õ|C^擾
 *
 * @param	inEncData		GJEg֘AZ[u|C^
 *
 * @return	u8*				Xv[L|C^
 */
//==============================================================================
u8 *EncDataSave_GetSprayCnt(ENC_SV_PTR inEncData)
{
	return &(inEncData->SprayCount);
}

//==============================================================================
/**
 * Xv[gpł邩ǂ̃`FbN
 * 
 * @param	inEncData		GJEg֘AZ[u|C^
 *
 * @return	BOOL	TRUE:gp		FALSE:gps
 */
//==============================================================================
BOOL EncDataSave_CanUseSpray(ENC_SV_PTR inEncData)
{
	if (!inEncData->SprayCount){
		return TRUE;
	}else{
		return FALSE;
	}
}

//==============================================================================
/**
 * r[h^CvZbg
 * 
 * @param	outEncData		GJEg֘AZ[u|C^
 * @param	inType			r[h^Cv
 *
 * @return	none
 */
//==============================================================================
void EncDataSave_SetVidro(ENC_SV_PTR outEncData, const u8 inType)
{
	GF_ASSERT( (inType == VIDRO_BLACK)||
				(inType == VIDRO_WHITE)||
				(inType == VIDRO_NONE) );
	outEncData->VidroType = inType;
}

//==============================================================================
/**
 * r[h^Cv擾
 * 
 * @param	inEncData		GJEg֘AZ[u|C^
 *
 * @return	u8			r[h^Cv
 */
//==============================================================================
u8 EncDataSave_GetVidro(ENC_SV_PTR inEncData)
{
	return inEncData->VidroType;
}

//==============================================================================
/**
 * RGJEg|PCfbNX̎擾
 *
 * @param	sv				Z[uf[^|C^
 * @param	outIndex1		R|PCfbNX
 * @param	outIndex2		R|PCfbNX
 *
 * @return	none
 */
//==============================================================================
void EncDataSave_GetHillBackPokeIdx(SAVEDATA *sv, u16 *outIndex1, u16 *outIndex2)
{
	ENC_SV_PTR  enc_data = EncDataSave_GetSaveDataPtr(sv);
	(*outIndex1) = enc_data->HillBackData.EncTblIdx1;
	(*outIndex2) = enc_data->HillBackData.EncTblIdx2;
}

//==============================================================================
/**
 * RGJEg|PCfbNX̃Zbgioj
 *
 * @param	sv			Z[uf[^|C^
 * @param	inIndex		R|PCfbNX
 *
 * @return	none
 */
//==============================================================================
void EncDataSave_SetHillBackPokeIdx(SAVEDATA *sv, const u16 inIndex)
{
	ENC_SV_PTR  enc_data = EncDataSave_GetSaveDataPtr(sv);
	GF_ASSERT(inIndex<HILL_BACK_ENC_MONS_MAX);
	enc_data->HillBackData.EncTblIdx2 = enc_data->HillBackData.EncTblIdx1;
	enc_data->HillBackData.EncTblIdx1 = inIndex;
}

